	GBLA ADR_TYPE
	GBLL mem8
	GBLA size_cycle
	GBLA adr_cycles
	GBLA WRITE_CYCLE
	GBLS mnemonic
	GBLA op_cycles
	GBLL return_addr
	GBLA ret8
	GBLA ret16
	GBLA op_group
	GBLA dups

		;r0=temp
		;r1=temp
		;r2=temp
snes_a		RN r3 ;aa000000 (8bit) aaaa0000 (16bit)   snes_b holds MSB in 8bit modes
snes_x		RN r4 ;00xx00db (8bit) xxxx00db (16bit)
snes_y		RN r5 ;00yy00db (8bit) yyyy00db (16bit)
snes_d		RN r6 ;0000dddd
snes_pc		RN r7
snes_nz		RN r8 ;Z=(bits 0-15==0)  N=(bit 15|bit17)
snes_cycles	RN r9 ;bit0=C, bit1=E, bit2=V
snes_memtbl	RN r10 ;=readmem8_tbl>>2
snes_optable	RN r11 ;=optable_??
		;r12=addy
		;r13=SP
		;r14=LR
		;r15=PC
;C			;(in snes_cycles)
CYCLES_E_FLAG EQU 2
CYCLES_V_FLAG EQU 4	;don't move these around unless you fixup PHP, etc
WAI_WAITING EQU	8	;set during WAI

C_FLAG EQU 2_00000001	;65816 flags
Z_FLAG EQU 2_00000010
I_FLAG EQU 2_00000100
D_FLAG EQU 2_00001000
X_FLAG EQU 2_00010000
M_FLAG EQU 2_00100000
V_FLAG EQU 2_01000000
N_FLAG EQU 2_10000000

	MACRO
	eatcycles $count
	adds snes_cycles,snes_cycles,#($count)*CPUCYCLE
	MEND

	MACRO
	givecycles $count
	sub snes_cycles,snes_cycles,#($count)*CPUCYCLE ;(don't use SUBS - see MVx)
	MEND

	MACRO
	fetch $count
 [ $count>0:LOR:SAFE
	adds snes_cycles,snes_cycles,#($count)*CPUCYCLE
 ]
 [ DEBUG
	b debugtrap
 |
	[ $count>0:LOR:SAFE
		ldrmib r0,[snes_pc],#1
		ldrmi pc,[snes_optable,r0,lsl#2]
		b timeout
	|
		ldrb r0,[snes_pc],#1
		ldr pc,[snes_optable,r0,lsl#2]
	]
 ]
	MEND

	MACRO
	fetch_D $count
 [ $count>0:LOR:SAFE
	adds snes_cycles,snes_cycles,#($count)*CPUCYCLE
 ]
 [ DEBUG
	ldr pc,=debugtrap
 |
	[ $count>0:LOR:SAFE
		ldrmib r0,[snes_pc],#1
		ldrmi pc,[snes_optable,r0,lsl#2]
		ldr pc,=timeout
	|
		ldrb r0,[snes_pc],#1
		ldr pc,[snes_optable,r0,lsl#2]
	]
 ]
	MEND

	MACRO
	timeout_fetch $count
	subs snes_cycles,snes_cycles,$count
	ldrmib r0,[snes_pc],#1
	ldrmi pc,[snes_optable,r0,lsl#2]
	b timeout
	MEND

	MACRO
	fetch_set_c $count
	adcs snes_cycles,snes_cycles,#($count)*CPUCYCLE
 [ DEBUG
	b debugtrap
 |
	ldrmib r0,[snes_pc],#1
	ldrmi pc,[snes_optable,r0,lsl#2]
	b timeout
 ]
	MEND

	MACRO			;r0=snes_mxdi
	load_snes_optable
	tst r0,#D_FLAG
	and r0,r0,#M_FLAG+X_FLAG
	ldreq snes_optable,=optable___
	ldrne snes_optable,=optable___d
	add snes_optable,snes_optable,r0,lsl#6
	MEND

	MACRO		;translate 65816 addr in r12 to GBA addr in r1
	translateR12
ADR_TYPE SETA _ABS
	readmem8	
	MEND

	MACRO		;translate 65816 addr in r12 to GBA addr in snes_pc (lr,etc killed)
	translatePC	;r1=snes_pc_offset on exit.
	translateR12
	mov snes_pc,r1
	sub r1,r1,r12
	MEND

	MACRO		;same shit, save snes_pc_offset too.    DOES NOT update snes_pb, you need to do this yourself
	encodePC
	translatePC
	str r1,snes_pc_offset
	MEND

	MACRO
	encodeP		;put cpu flags in r0
	ldr r0,snes_mxdi
	tst snes_nz,#0x28000
	orrne r0,r0,#N_FLAG
	movs r1,snes_nz,lsl#16
	orreq r0,r0,#Z_FLAG
	and r1,snes_cycles,#CYCLES_V_FLAG
	movs r2,snes_cycles,lsr#1
	adc r0,r0,r1,lsl#4
	MEND

;memory access---------------------------------

;read8:		IN: r12=addy		OUT: r0=LSB (bits 8-23=0), r1=(see below), r2=readmem_tbl ptr (for RMW), r12=unchanged
;read16:		IN: r12=addy		OUT: r0=MSB, r1=LSB, r2=readmem_tbl ptr, r12=unchanged
;write8/16:	IN: r12=addy, r0=data (upper bits undefined)	OUT: r0,r1,r2,r12=trashed
;8-bit memory reads (not I/O) return with r1 pointing to the data read (used in direct long addressing modes and PC translation)

	MACRO
	set_mem8
size_cycle SETA 0
mem8 SETL {TRUE}
	MEND

	MACRO
	set_mem16
size_cycle SETA 1
mem8 SETL {FALSE}
	MEND

	MACRO			;keeps track of available return addresses
	set_mnemonic $name	;(reset when different instruction is encountered)
	[ mnemonic <> "$name"
op_group SETA op_group+1
ret8 SETA 0
ret16 SETA 0
mnemonic SETS "$name"
	]
	MEND

	MACRO			;set op_cycles, and try to get a return address for readmem*
	check_return_addr $cycles
op_cycles SETA $cycles
	[ mem8
return_addr SETL ret8:AND:(1:SHL:op_cycles)<>0
	|
return_addr SETL ret16:AND:(1:SHL:op_cycles)<>0
	]
	[ return_addr
dups SETA dups+1
	]
	MEND

	MACRO			;all this return address crap is an attempt to reduce redundant code,
	put_return_addr_here	;by having reads return into existing code (of same operand size and cycle count)
	[ mem8
ret8 SETA ret8:OR:(1:SHL:op_cycles)
$mnemonic.$op_group.$op_cycles.bit8
	|
ret16 SETA ret16:OR:(1:SHL:op_cycles)
$mnemonic.$op_group.$op_cycles.bit16
	]
	MEND

	MACRO
	readmem8 $use_other_returnaddr
	[ ADR_TYPE = _IMM
		ldrb r0,[snes_pc],#1
		[ "$use_other_returnaddr"="T"
			you fucked something up...
		]
	|
		[ "$use_other_returnaddr"="T"
			adr lr,$mnemonic.$op_group.$op_cycles.bit8
		|
			adr lr,%F0
		]
		add r1,snes_memtbl,r12,lsr#13
		mov r2,#0
		ldr pc,[r2,r1,lsl#2]!
0
	]
	MEND


	MACRO
	readmem16 $use_other_returnaddr
	[ ADR_TYPE = _IMM
		ldrb r1,[snes_pc],#1
		ldrb r0,[snes_pc],#1
		[ "$use_other_returnaddr"="T"
			you fucked something up...
		]
	|
		[ "$use_other_returnaddr"="T"
			adr lr,$mnemonic.$op_group.$op_cycles.bit16
		|
			adr lr,%F0
		]
		add r1,snes_memtbl,r12,lsr#13
		mov r2,#0x2000
		ldr pc,[r2,r1,lsl#2]!
0
	]
	MEND

	MACRO
	writemem8 $use_other_returnaddr
	[ "$use_other_returnaddr"="T"
		adr lr,$mnemonic.$op_group.$op_cycles.bit8
	|
		adr lr,%F0
	]
	add r1,snes_memtbl,r12,lsr#13
	mov r2,#0x4000
	ldr pc,[r2,r1,lsl#2]
0
	MEND

	MACRO
	writemem16 $use_other_returnaddr
	[ "$use_other_returnaddr"="T"
		adr lr,$mnemonic.$op_group.$op_cycles.bit16
	|
		adr lr,%F0
	]
	add r1,snes_memtbl,r12,lsr#13
	mov r2,#0x6000
	ldr pc,[r2,r1,lsl#2]
0
	MEND

	MACRO
	writememRMW
	adr lr,%F0
	mov r1,#0x4000
	ldr pc,[r2,r1]
0
	MEND

	MACRO
	writeram8
	bic r1,r12,#0xE000
	orr r1,r1,#SNES_RAM
	strb r0,[r1]
	MEND

	MACRO
	writeHIram8
	bic r1,r12,#0xFE0000
	orr r1,r1,#SNES_RAM
	strb r0,[r1]
	MEND

	MACRO
	readram8
	bic r1,r12,#0xE000
	orr r1,r1,#SNES_RAM
	ldrb r0,[r1]
	MEND

	MACRO
	writeram16
	bic r1,r12,#0xE000
	orr r1,r1,#SNES_RAM
	strb r0,[r1]
	mov r0,r0,lsr#8
	strb r0,[r1,#1]
	MEND

	MACRO
	readram16
	bic r2,r12,#0xE000
	orr r2,r2,#SNES_RAM
	ldrb r1,[r2]
	ldrb r0,[r2,#1]
	MEND

;stack ops----------------------------------------------------------------------------

	MACRO		;push r0
	push8
ADR_TYPE SETA _ABS
	ldr r12,snes_s
	sub r1,r12,#1
	str r1,snes_s
 [ SAFE
	writemem8
 |
	writeram8
 ]
	MEND

	MACRO		;push r0
	push16
ADR_TYPE SETA _ABS
	ldr r12,snes_s
	sub r12,r12,#2
	str r12,snes_s
	add r12,r12,#1
 [ SAFE
	writemem16
 |
	writeram16
 ]
	MEND

	MACRO		;pop to r0
	pop8
ADR_TYPE SETA _ABS
	ldr r12,snes_s
	add r12,r12,#1
	str r12,snes_s
 [ SAFE
	readmem8
 |
	readram8
 ]
	MEND

	MACRO		;pop to r0:r1
	pop16
ADR_TYPE SETA _ABS
	ldr r12,snes_s
	add r12,r12,#2
	str r12,snes_s
	sub r12,r12,#1
 [ SAFE
	readmem16
 |
	readram16
 ]
	MEND

	MACRO		;pop to r1:r0(16)
	pop24
ADR_TYPE SETA _ABS
	ldr r12,snes_s
	add r12,r12,#3
	str r12,snes_s
	sub r12,r12,#2
 [ SAFE
	readmem8
 |
	readram8
 ]
	ldrb r12,[r1,#1]
	orr r0,r0,r12,lsl#8
	ldrb r1,[r1,#2]
	MEND

;addressing modes (setup R12 and increment PC)------------------------------------------------------

_IMM	EQU 1                       ;immediate
_ABS	EQU 3                       ;absolute

	MACRO
	addrIMM				;#$nn
ADR_TYPE SETA _IMM
adr_cycles SETA 1
	MEND

	MACRO
	addrABS				;$nnnn
ADR_TYPE SETA _ABS
adr_cycles SETA 3
WRITE_CYCLE SETA 0
	ldrb r12,[snes_pc],#1
	ldrb r0,[snes_pc],#1
	orr r12,r12,r0,lsl#8
	orr r12,r12,snes_x,lsl#16
	MEND

	MACRO
	addrABSL				;$nnnnnn
ADR_TYPE	SETA _ABS
adr_cycles SETA 4
WRITE_CYCLE SETA 0
	ldrb r12,[snes_pc],#1
	ldrb r0,[snes_pc],#1
	ldrb r1,[snes_pc],#1
	orr r12,r12,r0,lsl#8
	orr r12,r12,r1,lsl#16
	MEND

	MACRO
	addrDIR				;$nn
ADR_TYPE SETA _ABS
adr_cycles SETA 2
WRITE_CYCLE SETA 0
	ldrb r12,[snes_pc],#1
	add r12,r12,snes_d
	MEND

	MACRO
	addrDIY				;($nn),y
ADR_TYPE	SETA _ABS
adr_cycles SETA 4
WRITE_CYCLE SETA 1
	ldrb r12,[snes_pc],#1
	add r12,r12,snes_d
 [ SAFE
	readmem16
 |
	readram16
 ]
	orr r12,r1,r0,lsl#8
	add r12,r12,snes_y,ror#16
	MEND

	MACRO
	addrDIX				;($nn,x)
ADR_TYPE	SETA _ABS
adr_cycles SETA 5
WRITE_CYCLE SETA 0
	ldrb r0,[snes_pc],#1
	add r12,r0,snes_d
	add r12,r12,snes_x,lsr#16
 [ SAFE
	readmem16
 |
	readram16
 ]
	orr r12,r1,r0,lsl#8
	add r12,r12,snes_x,lsl#16
	MEND

	MACRO
	addrDX				;$nn,x
ADR_TYPE SETA _ABS
adr_cycles SETA 3
WRITE_CYCLE SETA 0
	ldrb r12,[snes_pc],#1
	add r12,r12,snes_d
	add r12,r12,snes_x,lsr#16
	MEND

	MACRO
	addrDY				;$nn,y
ADR_TYPE SETA _ABS
adr_cycles SETA 3
WRITE_CYCLE SETA 0
	ldrb r12,[snes_pc],#1
	add r12,r12,snes_d
	add r12,r12,snes_y,lsr#16
	MEND

	MACRO
	addrAX				;$nnnn,x
ADR_TYPE SETA _ABS
adr_cycles SETA 3
WRITE_CYCLE SETA 1
	ldrb r12,[snes_pc],#1
	ldrb r0,[snes_pc],#1
	orr r12,r12,r0,lsl#8
	add r12,r12,snes_x,ror#16
	MEND

	MACRO
	addrAY				;$nnnn,y
ADR_TYPE SETA _ABS
adr_cycles SETA 3
WRITE_CYCLE SETA 1
	ldrb r12,[snes_pc],#1
	ldrb r0,[snes_pc],#1
	orr r12,r12,r0,lsl#8
	add r12,r12,snes_y,ror#16
	MEND

	MACRO
	addrAXL				;$nnnnnn,x
ADR_TYPE	SETA _ABS
adr_cycles SETA 4
WRITE_CYCLE SETA 0
	ldrb r12,[snes_pc],#1
	ldrb r0,[snes_pc],#1
	ldrb r1,[snes_pc],#1
	orr r12,r12,r0,lsl#8
	orr r12,r12,r1,lsl#16
	add r12,r12,snes_x,lsr#16
	MEND

	MACRO
	addrDI				;($nn)
ADR_TYPE	SETA _ABS
adr_cycles SETA 4
WRITE_CYCLE SETA 0
	ldrb r12,[snes_pc],#1
	add r12,r12,snes_d
 [ SAFE
	readmem16
 |
	readram16
 ]
	orr r12,r1,r0,lsl#8
	add r12,r12,snes_x,lsl#16
	MEND

	MACRO
	addrDIL				;[$nn]
ADR_TYPE	SETA _ABS
adr_cycles SETA 5
WRITE_CYCLE SETA 0
	ldrb r12,[snes_pc],#1
	add r12,r12,snes_d
 [ SAFE
	readmem8
 |
	readram8
 ]
	ldrb r2,[r1,#1]
	orr r12,r0,r2,lsl#8
	ldrb r2,[r1,#2]
	orr r12,r12,r2,lsl#16
	MEND

	MACRO
	addrDIYL				;[$nn],y
	addrDIL
	add r12,r12,snes_y,lsr#16
	MEND

	MACRO
	addrDS				;$nn,s
ADR_TYPE SETA _ABS
adr_cycles SETA 3
WRITE_CYCLE SETA 0
	ldrb r12,[snes_pc],#1
	ldr r0,snes_s
	add r12,r12,r0
	MEND

	MACRO
	addrDSY				;($nn,s),y
	addrDS
adr_cycles SETA 6
 [ SAFE
	readmem16
 |
	readram16
 ]
	orr r12,r1,r0,lsl#8
	add r12,r12,snes_y,ror#16
	MEND

	MACRO				;doesn't follow the pattern.  use with caution
	addrAI				;($nnnn)
ADR_TYPE SETA _ABS
	ldrb r12,[snes_pc],#1
	ldrb r0,[snes_pc],#1
	orr r12,r12,r0,lsl#8
	MEND

;----------------------------------------------------------------------------

	MACRO
	opSTZ $opsize, $addrmode
	set_mnemonic "STZSTA"
	$opsize
	$addrmode
	check_return_addr 1+adr_cycles+size_cycle+WRITE_CYCLE
	mov r0,#0
	[ mem8
		writemem8 $return_addr
	|
		writemem16 $return_addr
	]
	[ return_addr
		MEXIT
	]
	put_return_addr_here
	fetch op_cycles
	MEND

	MACRO
	opSTA $opsize, $addrmode
	set_mnemonic "STZSTA"
	$opsize
	$addrmode
	check_return_addr 1+adr_cycles+size_cycle+WRITE_CYCLE
	[ mem8
		mov r0,snes_a,lsr#24
		writemem8 $return_addr
	|
		mov r0,snes_a,lsr#16
		writemem16 $return_addr
	]
	[ return_addr
		MEXIT
	]
	put_return_addr_here
	fetch op_cycles
	MEND

	MACRO
	opSTX $opsize, $addrmode
	set_mnemonic "STXSTY"
	$opsize
	$addrmode
	check_return_addr 1+adr_cycles+size_cycle
	mov r0,snes_x,lsr#16
	[ mem8
		writemem8 $return_addr
	|
		writemem16 $return_addr
	]
	[ return_addr
		MEXIT
	]
	put_return_addr_here
	fetch op_cycles
	MEND

	MACRO
	opSTY $opsize, $addrmode
	set_mnemonic "STXSTY"
	$opsize
	$addrmode
	check_return_addr 1+adr_cycles+size_cycle
	mov r0,snes_y,lsr#16
	[ mem8
		writemem8 $return_addr
	|
		writemem16 $return_addr
	]
	[ return_addr
		MEXIT
	]
	put_return_addr_here
	fetch op_cycles
	MEND


	MACRO
	opLDX $opsize, $addrmode
	set_mnemonic "LDX"
	$opsize
	$addrmode
	check_return_addr 1+adr_cycles+size_cycle
	[ mem8
		readmem8 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		and snes_x,snes_x,#0xff		;keep DB
		mov snes_nz,r0,lsl#8
		orr snes_x,snes_x,r0,lsl#16
	|
		readmem16 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		and snes_x,snes_x,#0xff		;keep DB
		orr snes_nz,r1,r0,lsl#8
		orr snes_x,snes_x,snes_nz,lsl#16
	]
	fetch op_cycles
	MEND

	MACRO
	opLDY $opsize, $addrmode
	set_mnemonic "LDY"
	$opsize
	$addrmode
	check_return_addr 1+adr_cycles+size_cycle
	[ mem8
		readmem8 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		and snes_y,snes_y,#0xff		;keep DB
		mov snes_nz,r0,lsl#8
		orr snes_y,snes_y,r0,lsl#16
	|
		readmem16 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		and snes_y,snes_y,#0xff		;keep DB
		orr snes_nz,r1,r0,lsl#8
		orr snes_y,snes_y,snes_nz,lsl#16
	]
	fetch op_cycles
	MEND

	MACRO
	opCPX $opsize, $addrmode
	set_mnemonic "CPX"
	$opsize
	$addrmode
	check_return_addr 1+adr_cycles+size_cycle
	[ mem8
		readmem8 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		mov r1,snes_x,lsl#8
		subs snes_nz,r1,r0,lsl#24

	|
		readmem16 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		orr r0,r1,r0,lsl#8
		subs snes_nz,snes_x,r0,lsl#16
	]
	mov snes_nz,snes_nz,lsr#16
	bic snes_cycles,snes_cycles,#C_FLAG
	fetch_set_c op_cycles
	MEND

	MACRO
	opCPY $opsize, $addrmode
	set_mnemonic "CPY"
	$opsize
	$addrmode
	check_return_addr 1+adr_cycles+size_cycle
	[ mem8
		readmem8 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		mov r1,snes_y,lsl#8
		subs snes_nz,r1,r0,lsl#24

	|
		readmem16 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		orr r0,r1,r0,lsl#8
		subs snes_nz,snes_y,r0,lsl#16
	]
	mov snes_nz,snes_nz,lsr#16
	bic snes_cycles,snes_cycles,#C_FLAG
	fetch_set_c op_cycles
	MEND

	MACRO
	opCMP $opsize, $addrmode
	set_mnemonic "CMP"
	$opsize
	$addrmode
	check_return_addr 1+adr_cycles+size_cycle
	[ mem8
		readmem8 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		subs snes_nz,snes_a,r0,lsl#24
	|
		readmem16 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		orr r0,r1,r0,lsl#8
		subs snes_nz,snes_a,r0,lsl#16
	]
	mov snes_nz,snes_nz,lsr#16
	bic snes_cycles,snes_cycles,#C_FLAG
	fetch_set_c op_cycles
	MEND

	MACRO
	opAND $opsize, $addrmode
	set_mnemonic "AND"
	$opsize
	$addrmode
	eatcycles 1+adr_cycles+size_cycle
	check_return_addr 0
	[ mem8
		readmem8 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		and snes_a,snes_a,r0,lsl#24
	|
		readmem16 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		orr r0,r1,r0,lsl#8
		and snes_a,snes_a,r0,lsl#16
	]
	mov snes_nz,snes_a,lsr#16
	fetch op_cycles
	MEND

	MACRO
	opORA $opsize, $addrmode
	set_mnemonic "ORA"
	$opsize
	$addrmode
	eatcycles 1+adr_cycles+size_cycle
	check_return_addr 0
	[ mem8
		readmem8 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		orr snes_a,snes_a,r0,lsl#24
	|
		readmem16 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		orr r0,r1,r0,lsl#8
		orr snes_a,snes_a,r0,lsl#16
	]
	mov snes_nz,snes_a,lsr#16
	fetch op_cycles
	MEND

	MACRO
	opEOR $opsize, $addrmode
	set_mnemonic "EOR"
	$opsize
	$addrmode
	eatcycles 1+adr_cycles+size_cycle
	check_return_addr	0
	[ mem8
		readmem8 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		eor snes_a,snes_a,r0,lsl#24
	|
		readmem16 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		orr r0,r1,r0,lsl#8
		eor snes_a,snes_a,r0,lsl#16
	]
	mov snes_nz,snes_a,lsr#16
	fetch op_cycles
	MEND

	MACRO
	opINC $opsize, $addrmode
	set_mnemonic "INC"
	$opsize
	$addrmode
	check_return_addr 3+adr_cycles+WRITE_CYCLE+size_cycle*2
	[ mem8
		readmem8 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		add r0,r0,#1
		mov snes_nz,r0,lsl#8
	|
		readmem16 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		orr r0,r1,r0,lsl#8
		add r0,r0,#1
		mov snes_nz,r0
	]
	writememRMW
	fetch op_cycles
	MEND

	MACRO
	opDEC $opsize, $addrmode
	set_mnemonic "DEC"
	$opsize
	$addrmode
	check_return_addr 3+adr_cycles+WRITE_CYCLE+size_cycle*2
	[ mem8
		readmem8 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		sub r0,r0,#1
		mov snes_nz,r0,lsl#8
	|
		readmem16 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		orr r0,r1,r0,lsl#8
		sub r0,r0,#1
		mov snes_nz,r0
	]
	writememRMW
	fetch op_cycles
	MEND

	MACRO
	opLDA $opsize, $addrmode
	set_mnemonic "LDA"
	$opsize
	$addrmode
	eatcycles 1+adr_cycles+size_cycle
	check_return_addr	0
	[ mem8
		readmem8 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		mov snes_nz,r0,lsl#8
		mov snes_a,r0,lsl#24
	|
		readmem16 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		orr snes_nz,r1,r0,lsl#8
		mov snes_a,snes_nz,lsl#16
	]
	fetch op_cycles
	MEND

	MACRO
	opADC $opsize, $addrmode
	set_mnemonic "ADC"
	$opsize
	$addrmode
	eatcycles 1+adr_cycles+size_cycle
	check_return_addr 0
	[ mem8
		readmem8 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		movs r2,snes_cycles,lsr#1 ;get C
		subcs r0,r0,#0x00000100
		adcs snes_a,snes_a,r0,ror#8
	|
		readmem16 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		movs r2,snes_cycles,lsr#1 ;get C
		orr r0,r1,r0,lsl#8
		subcs r0,r0,#0x00010000
		adcs snes_a,snes_a,r0,ror#16
	]
	mov snes_nz,snes_a,lsr#16 ;NZ
	bic snes_cycles,snes_cycles,#C_FLAG+CYCLES_V_FLAG
	orrvs snes_cycles,snes_cycles,#CYCLES_V_FLAG ;v
	orrcs snes_cycles,snes_cycles,#C_FLAG	;c
	fetch op_cycles
	MEND

	MACRO
	opADCD $opsize, $addrmode
	set_mnemonic "ADCD"
	$opsize
	$addrmode
	eatcycles 1+adr_cycles+size_cycle
	check_return_addr 0
	[ mem8
		readmem8 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
;		mov r11,r11							;No$GBA brk
		movs snes_cycles,snes_cycles,lsr#1	;get C
		and r1,r0,#0xF
		subcs r1,r1,#0x10
		mov r1,r1,ror#4
		adcs r1,r1,snes_a,lsl#4
		cmncc r1,#0x60000000
		addcs r1,r1,#0x60000000

		mov r2,snes_a,lsr#28
		adc r0,r2,r0,lsr#4
		movs r0,r0,lsl#28					;to get out C
		cmncc r0,#0x60000000
		addcs r0,r0,#0x60000000
		orr snes_a,r0,r1,lsr#4
	|
		readmem16 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here				;r1=low, r0=high
;		mov r11,r11							;No$GBA brk
		movs snes_cycles,snes_cycles,lsr#1	;get C
		eor r0,r0,#0xFF
		eor r1,r1,#0xFF

		mov r2,snes_a,lsl#12
		sbcs r12,r2,r1,lsl#28
		and r12,r12,#0xf0000000
		cmncc r12,#0x60000000
		addcs r12,r12,#0x60000000

		mov r2,snes_a,lsr#20
		and r2,r2,#0xF
		sbcs r1,r2,r1,lsr#4
		mov r1,r1,lsl#28
		cmncc r1,#0x60000000
		addcs r1,r1,#0x60000000
		orr r12,r1,r12,lsr#4

		mov r2,snes_a,lsl#4
		and r2,r2,#0xF0000000
		sbcs r1,r2,r0,lsl#28
		and r1,r1,#0xf0000000
		cmncc r1,#0x60000000
		addcs r1,r1,#0x60000000
		orr r12,r1,r12,lsr#4

		mov r2,snes_a,lsr#28
		sbcs r1,r2,r0,lsr#4
		mov r1,r1,lsl#28
		cmncc r1,#0x60000000
		addcs r1,r1,#0x60000000
		orr snes_a,r1,r12,lsr#4
	]
	mov snes_nz,snes_a,lsr#16				;NZ
	adc snes_cycles,snes_cycles,snes_cycles	;c
	fetch_D op_cycles
	MEND

	MACRO
	opASL $opsize, $addrmode
	set_mnemonic "ASL"
	$opsize
	$addrmode
	check_return_addr 3+adr_cycles+WRITE_CYCLE+size_cycle*2
	[ mem8
		readmem8 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		mov r0,r0,lsl#1
		mov snes_nz,r0,lsl#8
	|
		readmem16 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		orr r0,r1,r0,lsl#8
		mov r0,r0,lsl#1
		mov snes_nz,r0
	]
	bic snes_cycles,snes_cycles,#C_FLAG
	orr snes_cycles,snes_cycles,snes_nz,lsr#16
	writememRMW
	fetch op_cycles
	MEND

	MACRO
	opLSR $opsize, $addrmode
	set_mnemonic "LSR"
	$opsize
	$addrmode
	check_return_addr 3+adr_cycles+WRITE_CYCLE+size_cycle*2
	[ mem8
		readmem8 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		movs r0,r0,lsr#1
		mov snes_nz,r0,lsl#8
	|
		readmem16 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		orr r0,r1,r0,lsl#8
		movs r0,r0,lsr#1
		mov snes_nz,r0
	]
	bic snes_cycles,snes_cycles,#C_FLAG
	orrcs snes_cycles,snes_cycles,#C_FLAG
	writememRMW
	fetch op_cycles
	MEND

	MACRO
	opROR $opsize, $addrmode
	set_mnemonic "ROR"
	$opsize
	$addrmode
	check_return_addr 3+adr_cycles+WRITE_CYCLE+size_cycle*2
	[ mem8
		readmem8 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		movs snes_cycles,snes_cycles,lsr#1 ;c
		orrcs r0,r0,#0x100
		movs r0,r0,lsr#1
		mov snes_nz,r0,lsl#8
	|
		readmem16 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		orr r0,r1,r0,lsl#8
		movs snes_cycles,snes_cycles,lsr#1 ;c
		orrcs r0,r0,#0x10000
		movs r0,r0,lsr#1
		mov snes_nz,r0
	]
	adc snes_cycles,snes_cycles,snes_cycles
	writememRMW
	fetch op_cycles
	MEND

	MACRO
	opROL $opsize, $addrmode
	set_mnemonic "ROL"
	$opsize
	$addrmode
	check_return_addr 3+adr_cycles+WRITE_CYCLE+size_cycle*2
	[ mem8
		readmem8 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		movs snes_nz,snes_cycles,lsr#1 ;c
		adc r0,r0,r0
		mov snes_nz,r0,lsl#8
	|
		readmem16 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		orr r0,r1,r0,lsl#8
		movs snes_nz,snes_cycles,lsr#1 ;c
		adc r0,r0,r0
		mov snes_nz,r0
	]
	bic snes_cycles,snes_cycles,#C_FLAG
	orr snes_cycles,snes_cycles,snes_nz,lsr#16
	writememRMW
	fetch op_cycles
	MEND

	MACRO
	opSBC $opsize, $addrmode
	set_mnemonic "SBC"
	$opsize
	$addrmode
	eatcycles 1+adr_cycles+size_cycle
	check_return_addr 0
	[ mem8
		readmem8 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		movs r2,snes_cycles,lsr#1 ;get C
		sbcs snes_a,snes_a,r0,lsl#24
		and snes_a,snes_a,#0xff000000
		mov snes_nz,snes_a,lsr#16
	|
		readmem16 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		movs r2,snes_cycles,lsr#1 ;get C
		orr r0,r1,r0,lsl#8
		sbcs snes_nz,snes_a,r0,lsl#16
		mov snes_nz,snes_nz,lsr#16 ;NZ
		mov snes_a,snes_nz,lsl#16
	]
	bic snes_cycles,snes_cycles,#C_FLAG+CYCLES_V_FLAG
	orrvs snes_cycles,snes_cycles,#CYCLES_V_FLAG ;v
	orrcs snes_cycles,snes_cycles,#C_FLAG	;c
	fetch op_cycles
	MEND

	MACRO
	opSBCD $opsize, $addrmode				;It's not complete yet, probably doesn't need to be (same function as Snes9X).
	set_mnemonic "SBCD"
	$opsize
	$addrmode
	eatcycles 1+adr_cycles+size_cycle
	check_return_addr 0
	[ mem8
		readmem8 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
;		mov r11,r11							;No$GBA brk
		movs snes_cycles,snes_cycles,lsr#1	;get C
		mov r2,snes_a,lsl#4
		sbcs r1,r2,r0,lsl#28
		and r1,r1,#0xf0000000
		subcc r1,r1,#0x60000000

		mov r2,snes_a,lsr#28
		sbcs r0,r2,r0,lsr#4
		mov r0,r0,lsl#28
		subcc r0,r0,#0x60000000
		orr snes_a,r0,r1,lsr#4
	|
		readmem16 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here				;r1=low, r0=high
;		mov r11,r11							;No$GBA brk
		movs snes_cycles,snes_cycles,lsr#1	;get C

		mov r2,snes_a,lsl#12
		sbcs r12,r2,r1,lsl#28
		and r12,r12,#0xf0000000
		subcc r12,r12,#0x60000000

		mov r2,snes_a,lsr#20
		and r2,r2,#0xF
		sbcs r1,r2,r1,lsr#4
		mov r1,r1,lsl#28
		subcc r1,r1,#0x60000000
		orr r12,r1,r12,lsr#4

		mov r2,snes_a,lsl#4
		and r2,r2,#0xF0000000
		sbcs r1,r2,r0,lsl#28
		and r1,r1,#0xf0000000
		subcc r1,r1,#0x60000000
		orr r12,r1,r12,lsr#4

		mov r2,snes_a,lsr#28
		sbcs r1,r2,r0,lsr#4
		mov r1,r1,lsl#28
		subcc r1,r1,#0x60000000
		orr snes_a,r1,r12,lsr#4
	]
	mov snes_nz,snes_a,lsr#16			;NZ
	adc snes_cycles,snes_cycles,snes_cycles	;c
	fetch_D op_cycles
	MEND

	MACRO
	opBIT $opsize, $addrmode
	set_mnemonic "BIT"
	$opsize
	$addrmode
	check_return_addr 1+adr_cycles+size_cycle
	[ mem8
		readmem8 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		bic snes_cycles,snes_cycles,#CYCLES_V_FLAG
		movs r1,r0,lsr#7
		orrcs snes_cycles,snes_cycles,#CYCLES_V_FLAG
		and snes_nz,r0,snes_a,lsr#24	;Z
		orr snes_nz,snes_nz,r1,lsl#17	;N
	|
		readmem16 $return_addr
		[ return_addr
			MEXIT
		]
		put_return_addr_here
		orr r0,r1,r0,lsl#8
		bic snes_cycles,snes_cycles,#CYCLES_V_FLAG
		movs r1,r0,lsr#15
		orrcs snes_cycles,snes_cycles,#CYCLES_V_FLAG
		mov snes_nz,r1,lsl#17
		tst snes_a,r0,lsl#16
		orrne snes_nz,snes_nz,#1
	]
	fetch op_cycles
	MEND

	MACRO
	opTSB $opsize, $addrmode
	$opsize
	$addrmode
	[ mem8
		readmem8
		orr snes_nz,snes_nz,snes_nz,lsl#2
		and snes_nz,snes_nz,#0x20000	;preserve N
		tst r0,snes_a,lsr#24;
		orr r0,r0,snes_a,lsr#24
		orrne snes_nz,snes_nz,#1		;Z
	|
		readmem16
		orr r0,r1,r0,lsl#8
		orr snes_nz,snes_nz,snes_nz,lsl#2
		and snes_nz,snes_nz,#0x20000	;preserve N
		tst r0,snes_a,lsr#16
		orr r0,r0,snes_a,lsr#16
		orrne snes_nz,snes_nz,#1		;Z
	]
	writememRMW
	fetch 3+adr_cycles+size_cycle*2
	MEND

	MACRO
	opTRB $opsize, $addrmode
	$opsize
	$addrmode
	[ mem8
		readmem8
		orr snes_nz,snes_nz,snes_nz,lsl#2
		and snes_nz,snes_nz,#0x20000	;preserve N
		tst r0,snes_a,lsr#24;
		bic r0,r0,snes_a,lsr#24
		orrne snes_nz,snes_nz,#1		;Z
	|
		readmem16
		orr r0,r1,r0,lsl#8
		orr snes_nz,snes_nz,snes_nz,lsl#2
		and snes_nz,snes_nz,#0x20000	;preserve N
		tst r0,snes_a,lsr#16
		bic r0,r0,snes_a,lsr#16
		orrne snes_nz,snes_nz,#1		;Z
	]
	writememRMW
	fetch 3+adr_cycles+size_cycle*2
	MEND

;----------------------------
	END