	INCLUDE memory.h
	INCLUDE io.h
	INCLUDE spc.h
 [ :LNOT:SNES9X
	INCLUDE equates.h
	INCLUDE 65816mac.h
	INCLUDE debug.h
	INCLUDE gba.h

	EXPORT vcount
	EXPORT vtimetemp
	EXPORT timeup
	EXPORT hcount_latch
	EXPORT vcount_latch
	EXPORT hardreset
	EXPORT run
	EXPORT cycles_per_line
	EXPORT HVtimer
	EXPORT HVtimerlatch
	EXPORT adjusted_vtime
 [ DEBUG
	EXPORT debugstep
	EXPORT copy_65816_state
 ]
	AREA iwram, CODE, READWRITE
;---------------------------------------------------------------
MVP
	mov r0,#0
	sub r0,r0,#0x00010000

MVN	;r0=(00010000/FFFF0000), snes_a=BBAA0000, r1=index mask (safe)
ADR_TYPE SETA _ABS
 [ SAFE
	stmfd sp!,{snes_d,snes_nz,lr}
	mov snes_nz,r1
 |
	stmfd sp!,{snes_d,lr}
 ]
	mov snes_d,r0		;snes_d=index inc/dec

	bic snes_x,snes_x,#0xff
	bic snes_y,snes_y,#0xff
	ldrb r0,[snes_pc],#-1
	orr snes_y,snes_y,r0	;dst bank
	ldrb r0,[snes_pc,#2]
	orr snes_x,snes_x,r0	;src bank goes in X temporarily
mvloop
	mov r12,snes_x,ror#16
	readmem8
	add snes_x,snes_x,snes_d
	mov r12,snes_y,ror#16
 [ SAFE
	writemem8
 |
	writeHIram8
 ]
	add snes_y,snes_y,snes_d
 [ SAFE
	bic snes_x,snes_x,snes_nz		;lock MSB at 0 when X=1
	bic snes_y,snes_y,snes_nz
 ]
	subs snes_a,snes_a,#0x00010000
	bcc mvdone
	eatcycles 7
	bmi mvloop
	givecycles 7		;early exit - give back stolen cycles
mvdone
	addmi snes_pc,snes_pc,#3	;advance PC when A=FFFF
	bic snes_x,snes_x,#0xff
	and r0,snes_y,#0xff
	orr snes_x,snes_x,r0	;fixup X-DB
 [ SAFE
	ldmfd sp!,{snes_d,snes_nz,pc}
 |
	ldmfd sp!,{snes_d,pc}
 ]
;---------------------------------------------------------------
__CB	;WAI
_xCB
m_CB
mxCB
	orr snes_cycles,snes_cycles,#WAI_WAITING
	sub snes_pc,snes_pc,#1
	bl speedhack
	fetch 0
;---------------------------------------------------------------
__E9
_xE9
	opSBC set_mem16, addrIMM
__E5
_xE5
	opSBC set_mem16, addrDIR
__F5
_xF5
	opSBC set_mem16, addrDX
__F2
_xF2
	opSBC set_mem16, addrDI
__E1
_xE1
	opSBC set_mem16, addrDIX
__F1
_xF1
	opSBC set_mem16, addrDIY
__E7
_xE7
	opSBC set_mem16, addrDIL
__F7
_xF7
	opSBC set_mem16, addrDIYL
__ED
_xED
	opSBC set_mem16, addrABS
__FD
_xFD
	opSBC set_mem16, addrAX
__F9
_xF9
	opSBC set_mem16, addrAY
__EF
_xEF
	opSBC set_mem16, addrABSL
__FF
_xFF
	opSBC set_mem16, addrAXL
;---------------------------------------------------------------
m_E9
mxE9
	opSBC set_mem8, addrIMM
m_E5
mxE5
	opSBC set_mem8, addrDIR
m_F5
mxF5
	opSBC set_mem8, addrDX
m_F2
mxF2
	opSBC set_mem8, addrDI
m_E1
mxE1
	opSBC set_mem8, addrDIX
m_F1
mxF1
	opSBC set_mem8, addrDIY
m_E7
mxE7
	opSBC set_mem8, addrDIL
m_F7
mxF7
	opSBC set_mem8, addrDIYL
m_ED
mxED
	opSBC set_mem8, addrABS
m_FD
mxFD
	opSBC set_mem8, addrAX
m_F9
mxF9
	opSBC set_mem8, addrAY
m_EF
mxEF
	opSBC set_mem8, addrABSL
m_FF
mxFF
	opSBC set_mem8, addrAXL
;---------------------------------------------------------------
__69
_x69
	opADC set_mem16, addrIMM
__65
_x65
	opADC set_mem16, addrDIR
__75
_x75
	opADC set_mem16, addrDX
__72
_x72
	opADC set_mem16, addrDI
__61
_x61
	opADC set_mem16, addrDIX
__71
_x71
	opADC set_mem16, addrDIY
__67
_x67
	opADC set_mem16, addrDIL
__77
_x77
	opADC set_mem16, addrDIYL
__6D
_x6D
	opADC set_mem16, addrABS
__7D
_x7D
	opADC set_mem16, addrAX
__79
_x79
	opADC set_mem16, addrAY
__6F
_x6F
	opADC set_mem16, addrABSL
__7F
_x7F
	opADC set_mem16, addrAXL
;---------------------------------------------------------------
m_69
mx69
	opADC set_mem8, addrIMM
m_65
mx65
	opADC set_mem8, addrDIR
m_75
mx75
	opADC set_mem8, addrDX
m_72
mx72
	opADC set_mem8, addrDI
m_61
mx61
	opADC set_mem8, addrDIX
m_71
mx71
	opADC set_mem8, addrDIY
m_67
mx67
	opADC set_mem8, addrDIL
m_77
mx77
	opADC set_mem8, addrDIYL
m_6D
mx6D
	opADC set_mem8, addrABS
m_7D
mx7D
	opADC set_mem8, addrAX
m_79
mx79
	opADC set_mem8, addrAY
m_6F
mx6F
	opADC set_mem8, addrABSL
m_7F
mx7F
	opADC set_mem8, addrAXL
;---------------------------------------------------------------
__A9
_xA9
	opLDA set_mem16, addrIMM
__A5
_xA5
	opLDA set_mem16, addrDIR
__B5
_xB5
	opLDA set_mem16, addrDX
__B2
_xB2
	opLDA set_mem16, addrDI
__A1
_xA1
	opLDA set_mem16, addrDIX
__B1
_xB1
	opLDA set_mem16, addrDIY
__A7
_xA7
	opLDA set_mem16, addrDIL
__B7
_xB7
	opLDA set_mem16, addrDIYL
__AD
_xAD
	opLDA set_mem16, addrABS
__BD
_xBD
	opLDA set_mem16, addrAX
__B9
_xB9
	opLDA set_mem16, addrAY
__AF
_xAF
	opLDA set_mem16, addrABSL
__BF
_xBF
	opLDA set_mem16, addrAXL
;---------------------------------------------------------------
m_A9
mxA9
	opLDA set_mem8, addrIMM
m_A5
mxA5
	opLDA set_mem8, addrDIR
m_B5
mxB5
	opLDA set_mem8, addrDX
m_B2
mxB2
	opLDA set_mem8, addrDI
m_A1
mxA1
	opLDA set_mem8, addrDIX
m_B1
mxB1
	opLDA set_mem8, addrDIY
m_A7
mxA7
	opLDA set_mem8, addrDIL
m_B7
mxB7
	opLDA set_mem8, addrDIYL
m_AD
mxAD
	opLDA set_mem8, addrABS
m_BD
mxBD
	opLDA set_mem8, addrAX
m_B9
mxB9
	opLDA set_mem8, addrAY
m_AF
mxAF
	opLDA set_mem8, addrABSL
m_BF
mxBF
	opLDA set_mem8, addrAXL
;---------------------------------------------------------------
__29
_x29
	opAND set_mem16, addrIMM
__25
_x25
	opAND set_mem16, addrDIR
__35
_x35
	opAND set_mem16, addrDX
__32
_x32
	opAND set_mem16, addrDI
__21
_x21
	opAND set_mem16, addrDIX
__31
_x31
	opAND set_mem16, addrDIY
__27
_x27
	opAND set_mem16, addrDIL
__37
_x37
	opAND set_mem16, addrDIYL
__2D
_x2D
	opAND set_mem16, addrABS
__3D
_x3D
	opAND set_mem16, addrAX
__39
_x39
	opAND set_mem16, addrAY
__2F
_x2F
	opAND set_mem16, addrABSL
__3F
_x3F
	opAND set_mem16, addrAXL
;---------------------------------------------------------------
m_29
mx29
	opAND set_mem8, addrIMM
m_25
mx25
	opAND set_mem8, addrDIR
m_35
mx35
	opAND set_mem8, addrDX
m_32
mx32
	opAND set_mem8, addrDI
m_21
mx21
	opAND set_mem8, addrDIX
m_31
mx31
	opAND set_mem8, addrDIY
m_27
mx27
	opAND set_mem8, addrDIL
m_37
mx37
	opAND set_mem8, addrDIYL
m_2D
mx2D
	opAND set_mem8, addrABS
m_3D
mx3D
	opAND set_mem8, addrAX
m_39
mx39
	opAND set_mem8, addrAY
m_2F
mx2F
	opAND set_mem8, addrABSL
m_3F
mx3F
	opAND set_mem8, addrAXL
;---------------------------------------------------------------
__09
_x09
	opORA set_mem16, addrIMM
__05
_x05
	opORA set_mem16, addrDIR
__15
_x15
	opORA set_mem16, addrDX
__12
_x12
	opORA set_mem16, addrDI
__01
_x01
	opORA set_mem16, addrDIX
__11
_x11
	opORA set_mem16, addrDIY
__07
_x07
	opORA set_mem16, addrDIL
__17
_x17
	opORA set_mem16, addrDIYL
__0D
_x0D
	opORA set_mem16, addrABS
__1D
_x1D
	opORA set_mem16, addrAX
__19
_x19
	opORA set_mem16, addrAY
__0F
_x0F
	opORA set_mem16, addrABSL
__1F
_x1F
	opORA set_mem16, addrAXL
;---------------------------------------------------------------
m_09
mx09
	opORA set_mem8, addrIMM
m_05
mx05
	opORA set_mem8, addrDIR
m_15
mx15
	opORA set_mem8, addrDX
m_12
mx12
	opORA set_mem8, addrDI
m_01
mx01
	opORA set_mem8, addrDIX
m_11
mx11
	opORA set_mem8, addrDIY
m_07
mx07
	opORA set_mem8, addrDIL
m_17
mx17
	opORA set_mem8, addrDIYL
m_0D
mx0D
	opORA set_mem8, addrABS
m_1D
mx1D
	opORA set_mem8, addrAX
m_19
mx19
	opORA set_mem8, addrAY
m_0F
mx0F
	opORA set_mem8, addrABSL
m_1F
mx1F
	opORA set_mem8, addrAXL
;---------------------------------------------------------------
__49
_x49
	opEOR set_mem16, addrIMM
__45
_x45
	opEOR set_mem16, addrDIR
__55
_x55
	opEOR set_mem16, addrDX
__52
_x52
	opEOR set_mem16, addrDI
__41
_x41
	opEOR set_mem16, addrDIX
__51
_x51
	opEOR set_mem16, addrDIY
__47
_x47
	opEOR set_mem16, addrDIL
__57
_x57
	opEOR set_mem16, addrDIYL
__4D
_x4D
	opEOR set_mem16, addrABS
__5D
_x5D
	opEOR set_mem16, addrAX
__59
_x59
	opEOR set_mem16, addrAY
__4F
_x4F
	opEOR set_mem16, addrABSL
__5F
_x5F
	opEOR set_mem16, addrAXL

;---------------------------------------------------------------
m_49
mx49
	opEOR set_mem8, addrIMM
m_45
mx45
	opEOR set_mem8, addrDIR
m_55
mx55
	opEOR set_mem8, addrDX
m_52
mx52
	opEOR set_mem8, addrDI
m_41
mx41
	opEOR set_mem8, addrDIX
m_51
mx51
	opEOR set_mem8, addrDIY
m_47
mx47
	opEOR set_mem8, addrDIL
m_57
mx57
	opEOR set_mem8, addrDIYL
m_4D
mx4D
	opEOR set_mem8, addrABS
m_5D
mx5D
	opEOR set_mem8, addrAX
m_59
mx59
	opEOR set_mem8, addrAY
m_4F
mx4F
	opEOR set_mem8, addrABSL
m_5F
mx5F
	opEOR set_mem8, addrAXL
;---------------------------------------------------------------
__C9
_xC9
	opCMP set_mem16, addrIMM
__C5
_xC5
	opCMP set_mem16, addrDIR
__D5
_xD5
	opCMP set_mem16, addrDX
__D2
_xD2
	opCMP set_mem16, addrDI
__C1
_xC1
	opCMP set_mem16, addrDIX
__D1
_xD1
	opCMP set_mem16, addrDIY
__C7
_xC7
	opCMP set_mem16, addrDIL
__D7
_xD7
	opCMP set_mem16, addrDIYL
__CD
_xCD
	opCMP set_mem16, addrABS
__DD
_xDD
	opCMP set_mem16, addrAX
__D9
_xD9
	opCMP set_mem16, addrAY
__CF
_xCF
	opCMP set_mem16, addrABSL
__DF
_xDF
	opCMP set_mem16, addrAXL
;---------------------------------------------------------------
m_C9
mxC9
	opCMP set_mem8, addrIMM
m_C5
mxC5
	opCMP set_mem8, addrDIR
m_D5
mxD5
	opCMP set_mem8, addrDX
m_D2
mxD2
	opCMP set_mem8, addrDI
m_C1
mxC1
	opCMP set_mem8, addrDIX
m_D1
mxD1
	opCMP set_mem8, addrDIY
m_C7
mxC7
	opCMP set_mem8, addrDIL
m_D7
mxD7
	opCMP set_mem8, addrDIYL
m_CD
mxCD
	opCMP set_mem8, addrABS
m_DD
mxDD
	opCMP set_mem8, addrAX
m_D9
mxD9
	opCMP set_mem8, addrAY
m_CF
mxCF
	opCMP set_mem8, addrABSL
m_DF
mxDF
	opCMP set_mem8, addrAXL
;---------------------------------------------------------------
__89	;BIT #nn (special case BIT - only Z flag is affected)
_x89
	ldrb r0,[snes_pc],#1
	ldrb r1,[snes_pc],#1
	orr r0,r0,r1,lsl#8
	orr snes_nz,snes_nz,snes_nz,lsl#2
	and snes_nz,snes_nz,#0x20000	;N
	tst r0,snes_a,lsr#16
	orrne snes_nz,snes_nz,#1		;Z
	fetch 3
m_89
mx89
	ldrb r0,[snes_pc],#1
	orr snes_nz,snes_nz,snes_nz,lsl#2
	and snes_nz,snes_nz,#0x20000	;N
	tst r0,snes_a,lsr#24
	orrne snes_nz,snes_nz,#1		;Z
	fetch 2
;---------------------------------------------------------------
__24	;BIT $nn
_x24
	opBIT set_mem16, addrDIR
m_24
mx24
	opBIT set_mem8, addrDIR
;---------------------------------------------------------------
__34	;BIT $nn,x
_x34
	opBIT set_mem16, addrDX
m_34
mx34
	opBIT set_mem8, addrDX
;---------------------------------------------------------------
__2C	;BIT $nnnn
_x2C
	opBIT set_mem16, addrABS
m_2C
mx2C
	opBIT set_mem8, addrABS
;---------------------------------------------------------------
__3C	;BIT $nnnn,x
_x3C
	opBIT set_mem16, addrAX
m_3C
mx3C
	opBIT set_mem8, addrAX
;---------------------------------------------------------------
__64	;STZ $nn
_x64
	opSTZ set_mem16, addrDIR
m_64
mx64
	opSTZ set_mem8, addrDIR
;---------------------------------------------------------------
__74	;STZ $nn,x
_x74
	opSTZ set_mem16, addrDX
m_74
mx74
	opSTZ set_mem8, addrDX
;---------------------------------------------------------------
__9C	;STZ $nnnn
_x9C
	opSTZ set_mem16, addrABS
m_9C
mx9C
	opSTZ set_mem8, addrABS
;---------------------------------------------------------------
__9E	;STZ $nnnn,x
_x9E
	opSTZ set_mem16, addrAX
m_9E
mx9E
	opSTZ set_mem8, addrAX
;---------------------------------------------------------------
__9D	;STA $nnnn,x
_x9D
	opSTA set_mem16, addrAX
m_9D
mx9D
	opSTA set_mem8, addrAX
;---------------------------------------------------------------
__8D	;STA $nnnn
_x8D
	opSTA set_mem16, addrABS
m_8D
mx8D
	opSTA set_mem8, addrABS
;---------------------------------------------------------------
__85	;STA $nn
_x85
	opSTA set_mem16, addrDIR
m_85
mx85
	opSTA set_mem8, addrDIR
;---------------------------------------------------------------
__95	;STA $nn,x
_x95
	opSTA set_mem16, addrDX
m_95
mx95
	opSTA set_mem8, addrDX
;---------------------------------------------------------------
__92	;STA ($nn)
_x92
	opSTA set_mem16, addrDI
m_92
mx92
	opSTA set_mem8, addrDI
;---------------------------------------------------------------
__99	;STA $nnnn,y
_x99
	opSTA set_mem16, addrAY
m_99
mx99
	opSTA set_mem8, addrAY
;---------------------------------------------------------------
__8F	;STA $nnnnnn
_x8F
	opSTA set_mem16, addrABSL
m_8F
mx8F
	opSTA set_mem8, addrABSL
;---------------------------------------------------------------
__9F	;STA $nnnnnn,x
_x9F
	opSTA set_mem16, addrAXL
m_9F
mx9F
	opSTA set_mem8, addrAXL
;---------------------------------------------------------------
__91	;STA ($nn),y
_x91
	opSTA set_mem16, addrDIY
m_91
mx91
	opSTA set_mem8, addrDIY
;---------------------------------------------------------------
__81	;STA ($nn,x)
_x81
	opSTA set_mem16, addrDIX
m_81
mx81
	opSTA set_mem8, addrDIX
;---------------------------------------------------------------
__87	;STA [$nn]
_x87
	opSTA set_mem16, addrDIL
m_87
mx87
	opSTA set_mem8, addrDIL
;---------------------------------------------------------------
__97	;STA [$nn],y
_x97
	opSTA set_mem16, addrDIYL
m_97
mx97
	opSTA set_mem8, addrDIYL
;---------------------------------------------------------------
__86	;STX $nn
m_86
	opSTX set_mem16, addrDIR
_x86
mx86
	opSTX set_mem8, addrDIR
;---------------------------------------------------------------
__8E	;STX $nnnn
m_8E
	opSTX set_mem16, addrABS
_x8E
mx8E
	opSTX set_mem8, addrABS
;---------------------------------------------------------------
__96	;STX $nn,y
m_96
	opSTX set_mem16, addrDY
_x96
mx96
	opSTX set_mem8, addrDY
;---------------------------------------------------------------
__84	;STY $nn
m_84
	opSTY set_mem16, addrDIR
_x84
mx84
	opSTY set_mem8, addrDIR
;---------------------------------------------------------------
__8C	;STY $nnnn
m_8C
	opSTY set_mem16, addrABS
_x8C
mx8C
	opSTY set_mem8, addrABS
;---------------------------------------------------------------
__94	;STY $nn,x
m_94
	opSTY set_mem16, addrDX
_x94
mx94
	opSTY set_mem8, addrDX
;---------------------------------------------------------------
__E0	;CPX #
m_E0
	opCPX set_mem16, addrIMM
_xE0
mxE0
	opCPX set_mem8, addrIMM
;---------------------------------------------------------------
__E4	;CPX $nn
m_E4
	opCPX set_mem16, addrDIR
_xE4
mxE4
	opCPX set_mem8, addrDIR
;---------------------------------------------------------------
__EC	;CPX $nnnn
m_EC
	opCPX set_mem16, addrABS
_xEC
mxEC
	opCPX set_mem8, addrABS
;---------------------------------------------------------------
__C0	;CPY #
m_C0
	opCPY set_mem16, addrIMM
_xC0
mxC0
	opCPY set_mem8, addrIMM
;---------------------------------------------------------------
__C4	;CPY $nn
m_C4
	opCPY set_mem16, addrDIR
_xC4
mxC4
	opCPY set_mem8, addrDIR
;---------------------------------------------------------------
__CC	;CPY $nnnn
m_CC
	opCPY set_mem16, addrABS
_xCC
mxCC
	opCPY set_mem8, addrABS
;---------------------------------------------------------------
__A2	;LDX #
m_A2
	opLDX set_mem16, addrIMM
_xA2
mxA2
	opLDX set_mem8, addrIMM
;---------------------------------------------------------------
__A6	;LDX $nn
m_A6
	opLDX set_mem16, addrDIR
_xA6
mxA6
	opLDX set_mem8, addrDIR
;---------------------------------------------------------------
__AE	;LDX $nnnn
m_AE
	opLDX set_mem16, addrABS
_xAE
mxAE
	opLDX set_mem8, addrABS
;---------------------------------------------------------------
__B6	;LDX $nn,y
m_B6
	opLDX set_mem16, addrDY
_xB6
mxB6
	opLDX set_mem8, addrDY
;---------------------------------------------------------------
__BE	;LDX $nnnn,y
m_BE
	opLDX set_mem16, addrAY
_xBE
mxBE
	opLDX set_mem8, addrAY
;---------------------------------------------------------------
__A0	;LDY #
m_A0
	opLDY set_mem16, addrIMM
_xA0
mxA0
	opLDY set_mem8, addrIMM
;---------------------------------------------------------------
__A4	;LDY $nn
m_A4
	opLDY set_mem16, addrDIR
_xA4
mxA4
	opLDY set_mem8, addrDIR
;---------------------------------------------------------------
__AC	;LDY $nnnn
m_AC
	opLDY set_mem16, addrABS
_xAC
mxAC
	opLDY set_mem8, addrABS
;---------------------------------------------------------------
__B4	;LDY $nn,x
m_B4
	opLDY set_mem16, addrDX
_xB4
mxB4
	opLDY set_mem8, addrDX
;---------------------------------------------------------------
__BC	;LDY $nnnn,x
m_BC
	opLDY set_mem16, addrAX
_xBC
mxBC
	opLDY set_mem8, addrAX
;---------------------------------------------------------------
__E6	;INC $nn
_xE6
	opINC set_mem16, addrDIR
m_E6
mxE6
	opINC set_mem8, addrDIR
;---------------------------------------------------------------
__F6	;INC $nn,x
_xF6
	opINC set_mem16, addrDX
m_F6
mxF6
	opINC set_mem8, addrDX
;---------------------------------------------------------------
__EE	;INC $nnnn
_xEE
	opINC set_mem16, addrABS
m_EE
mxEE
	opINC set_mem8, addrABS
;---------------------------------------------------------------
__FE	;INC $nnnn,x
_xFE
	opINC set_mem16, addrAX
m_FE
mxFE
	opINC set_mem8, addrAX
;---------------------------------------------------------------
__1A	;INC A
_x1A
	add snes_a,snes_a,#0x00010000
	mov snes_nz,snes_a,lsr#16
	fetch 2
m_1A
mx1A
	add snes_a,snes_a,#0x01000000
	mov snes_nz,snes_a,lsr#16
	fetch 2
;---------------------------------------------------------------
__C6	;DEC $nn
_xC6
	opDEC set_mem16, addrDIR
m_C6
mxC6
	opDEC set_mem8, addrDIR
;---------------------------------------------------------------
__D6	;DEC $nn,x
_xD6
	opDEC set_mem16, addrDX
m_D6
mxD6
	opDEC set_mem8, addrDX
;---------------------------------------------------------------
__CE	;DEC $nnnn
_xCE
	opDEC set_mem16, addrABS
m_CE
mxCE
	opDEC set_mem8, addrABS
;---------------------------------------------------------------
__DE	;DEC $nnnn,x
_xDE
	opDEC set_mem16, addrAX
m_DE
mxDE
	opDEC set_mem8, addrAX
;---------------------------------------------------------------
__3A	;DEC A
_x3A
	sub snes_a,snes_a,#0x00010000
	mov snes_nz,snes_a,lsr#16
	fetch 2
m_3A
mx3A
	sub snes_a,snes_a,#0x01000000
	mov snes_nz,snes_a,lsr#16
	fetch 2
;---------------------------------------------------------------
__06	;ASL $nn
_x06
	opASL set_mem16, addrDIR
m_06
mx06
	opASL set_mem8, addrDIR
;---------------------------------------------------------------
__16	;ASL $nn,x
_x16
	opASL set_mem16, addrDX
m_16
mx16
	opASL set_mem8, addrDX
;---------------------------------------------------------------
__0E	;ASL $nnnn
_x0E
	opASL set_mem16, addrABS
m_0E
mx0E
	opASL set_mem8, addrABS
;---------------------------------------------------------------
__1E	;ASL $nnnn,x
_x1E
	opASL set_mem16, addrAX
m_1E
mx1E
	opASL set_mem8, addrAX
;---------------------------------------------------------------
__0A	;ASL A
_x0A
m_0A
mx0A
	movs snes_a,snes_a,lsl#1
	mov snes_nz,snes_a,lsr#16
	bic snes_cycles,snes_cycles,#C_FLAG
	fetch_set_c 2
;---------------------------------------------------------------
__46	;LSR $nn
_x46
	opLSR set_mem16, addrDIR
m_46
mx46
	opLSR set_mem8, addrDIR
;---------------------------------------------------------------
__56	;LSR $nn,x
_x56
	opLSR set_mem16, addrDX
m_56
mx56
	opLSR set_mem8, addrDX
;---------------------------------------------------------------
__4E	;LSR $nnnn
_x4E
	opLSR set_mem16, addrABS
m_4E
mx4E
	opLSR set_mem8, addrABS
;---------------------------------------------------------------
__5E	;LSR $nnnn,x
_x5E
	opLSR set_mem16, addrAX
m_5E
mx5E
	opLSR set_mem8, addrAX
;---------------------------------------------------------------
__4A	;LSR A
_x4A
	movs snes_nz,snes_a,lsr#17
	mov snes_a,snes_nz,lsl#16
	bic snes_cycles,snes_cycles,#C_FLAG
	fetch_set_c 2
m_4A
mx4A
	movs snes_nz,snes_a,lsr#25
	mov snes_nz,snes_nz,lsl#8
	mov snes_a,snes_nz,lsl#16
	bic snes_cycles,snes_cycles,#C_FLAG
	fetch_set_c 2
;---------------------------------------------------------------
__66	;ROR $nn
_x66
	opROR set_mem16, addrDIR
m_66
mx66
	opROR set_mem8, addrDIR
;---------------------------------------------------------------
__76	;ROR $nn,x
_x76
	opROR set_mem16, addrDX
m_76
mx76
	opROR set_mem8, addrDX
;---------------------------------------------------------------
__6E	;ROR $nnnn
_x6E
	opROR set_mem16, addrABS
m_6E
mx6E
	opROR set_mem8, addrABS
;---------------------------------------------------------------
__7E	;ROR $nnnn,x
_x7E
	opROR set_mem16, addrAX
m_7E
mx7E
	opROR set_mem8, addrAX
;---------------------------------------------------------------
__6A	;ROR A
_x6A
	movs snes_cycles,snes_cycles,lsr#1 ;c
	mov snes_nz,snes_a,rrx
	movs snes_nz,snes_nz,lsr#16
	mov snes_a,snes_nz,lsl#16
	adc snes_cycles,snes_cycles,snes_cycles
	fetch 2
m_6A
mx6A
	movs snes_cycles,snes_cycles,lsr#1 ;c
	mov snes_nz,snes_a,rrx
	movs snes_nz,snes_nz,lsr#24
	mov snes_a,snes_nz,lsl#24
	mov snes_nz,snes_nz,lsl#8
	adc snes_cycles,snes_cycles,snes_cycles
	fetch 2
;---------------------------------------------------------------
__26	;ROL $nn
_x26
	opROL set_mem16, addrDIR
m_26
mx26
	opROL set_mem8, addrDIR
;---------------------------------------------------------------
__36	;ROL $nn,x
_x36
	opROL set_mem16, addrDX
m_36
mx36
	opROL set_mem8, addrDX
;---------------------------------------------------------------
__2E	;ROL $nnnn
_x2E
	opROL set_mem16, addrABS
m_2E
mx2E
	opROL set_mem8, addrABS
;---------------------------------------------------------------
__3E	;ROL $nnnn,x
_x3E
	opROL set_mem16, addrAX
m_3E
mx3E
	opROL set_mem8, addrAX
;---------------------------------------------------------------
__2A	;ROL A
_x2A
	movs snes_cycles,snes_cycles,lsr#1 ;c
	orrcs snes_a,snes_a,#0x00008000
	movs snes_a,snes_a,lsl#1
	mov snes_nz,snes_a,lsr#16
	adc snes_cycles,snes_cycles,snes_cycles
	fetch 2
m_2A
mx2A
	movs snes_cycles,snes_cycles,lsr#1 ;c
	orrcs snes_a,snes_a,#0x00800000
	movs snes_a,snes_a,lsl#1
	mov snes_nz,snes_a,lsr#16
	adc snes_cycles,snes_cycles,snes_cycles
	fetch 2
;---------------------------------------------------------------
__04	;TSB $nn
_x04
	opTSB set_mem16, addrDIR
m_04
mx04
	opTSB set_mem8, addrDIR
;---------------------------------------------------------------
__0C	;TSB $nnnn
_x0C
	opTSB set_mem16, addrABS
m_0C
mx0C
	opTSB set_mem8, addrABS
;---------------------------------------------------------------
__14	;TRB $nn
_x14
	opTRB set_mem16, addrDIR
m_14
mx14
	opTRB set_mem8, addrDIR
;---------------------------------------------------------------
__1C	;TRB $nnnn
_x1C
	opTRB set_mem16, addrABS
m_1C
mx1C
	opTRB set_mem8, addrABS
;---------------------------------------------------------------
__DB	;<hack> eat cycles and branch
_xDB
m_DB
mxDB
	bl speedhack

	ldrb r0,[snes_pc],#1
	movs r0,r0,lsl#25		;bit7: 0=BNE 1=BEQ
	mov r0,r0,asr#25
	bcc __D0+4
	bcs __F0+4
;---------------------------------------------------------------
__42	;<hack> eat cycles and branch back
_x42
m_42
mx42
	bl speedhack

	ldrb r0,[snes_pc],#1
	and r1,r0,#0xf0
	and r0,r0,#0x0f
	sub r0,r0,#0x10
	ldr lr,[snes_optable,r1,lsl#2]
	add pc,lr,#4
;---------------------------------------------------------------
__B0	;BCS
_xB0
m_B0
mxB0
	ldrsb r0,[snes_pc],#1
	tst snes_cycles,#C_FLAG	;??42 jumps here
	addne snes_pc,snes_pc,r0
	addne snes_cycles,snes_cycles,#CPUCYCLE
	fetch 2
;---------------------------------------------------------------
__D0	;BNE
_xD0
m_D0
mxD0
	ldrsb r0,[snes_pc],#1
	movs r1,snes_nz,lsl#16	;??42 jumps here
	addne snes_pc,snes_pc,r0
	addne snes_cycles,snes_cycles,#CPUCYCLE
	fetch 2
;---------------------------------------------------------------
__F0	;BEQ
_xF0
m_F0
mxF0
	ldrsb r0,[snes_pc],#1
	movs r1,snes_nz,lsl#16	;??42 jumps here
	addeq snes_pc,snes_pc,r0
	addeq snes_cycles,snes_cycles,#CPUCYCLE
	fetch 2
;---------------------------------------------------------------
__50	;BVC
_x50
m_50
mx50
	ldrsb r0,[snes_pc],#1
	tst snes_cycles,#CYCLES_V_FLAG	;??42 jumps here
	addeq snes_pc,snes_pc,r0
	addeq snes_cycles,snes_cycles,#CPUCYCLE
	fetch 2
;---------------------------------------------------------------
__70	;BVS
_x70
m_70
mx70
	ldrsb r0,[snes_pc],#1
	tst snes_cycles,#CYCLES_V_FLAG	;??42 jumps here
	addne snes_pc,snes_pc,r0
	addne snes_cycles,snes_cycles,#CPUCYCLE
	fetch 2
;---------------------------------------------------------------
__10	;BPL
_x10
m_10
mx10
	ldrsb r0,[snes_pc],#1
	tst snes_nz,#0x28000	;??42 jumps here
	addeq snes_pc,snes_pc,r0
	addeq snes_cycles,snes_cycles,#CPUCYCLE
	fetch 2
;---------------------------------------------------------------
__30	;BMI
_x30
m_30
mx30
	ldrsb r0,[snes_pc],#1
	tst snes_nz,#0x28000	;??42 jumps here
	addne snes_pc,snes_pc,r0
	addne snes_cycles,snes_cycles,#CPUCYCLE
	fetch 2
;---------------------------------------------------------------
__90	;BCC
_x90
m_90
mx90
	ldrsb r0,[snes_pc],#1
	tst snes_cycles,#C_FLAG	;??42 jumps here
	addeq snes_pc,snes_pc,r0
	addeq snes_cycles,snes_cycles,#CPUCYCLE
	fetch 2
;---------------------------------------------------------------
__80	;BRA
_x80
m_80
mx80
	ldrsb r0,[snes_pc],#1
	add snes_pc,snes_pc,r0	;??42 jumps here
	fetch 3
;---------------------------------------------------------------
__B8	;CLV
_xB8
m_B8
mxB8
	bic snes_cycles,snes_cycles,#CYCLES_V_FLAG
	fetch 2
;---------------------------------------------------------------
__18	;CLC
_x18
m_18
mx18
	bic snes_cycles,snes_cycles,#C_FLAG
	fetch 2
;---------------------------------------------------------------
__38	;SEC
_x38
m_38
mx38
	orr snes_cycles,snes_cycles,#C_FLAG
	fetch 2
;---------------------------------------------------------------
__C8	;INY
m_C8
	add snes_y,snes_y,#0x00010000
	mov snes_nz,snes_y,lsr#16
	fetch 2
_xC8
mxC8
	add snes_y,snes_y,#0x00010000
	bic snes_y,snes_y,#0x01000000
	mov snes_nz,snes_y,lsr#8
	fetch 2	
;---------------------------------------------------------------
__88	;DEY
m_88
	sub snes_y,snes_y,#0x00010000
	mov snes_nz,snes_y,lsr#16
	fetch 2
_x88
mx88
	sub snes_y,snes_y,#0x00010000
	bic snes_y,snes_y,#0xff000000
	mov snes_nz,snes_y,lsr#8
	fetch 2
;---------------------------------------------------------------
__CA	;DEX
m_CA
	sub snes_x,snes_x,#0x00010000
	mov snes_nz,snes_x,lsr#16
	fetch 2
_xCA
mxCA
	sub snes_x,snes_x,#0x00010000
	bic snes_x,snes_x,#0xff000000
	mov snes_nz,snes_x,lsr#8
	fetch 2
;---------------------------------------------------------------
__E8	;INX
m_E8
	add snes_x,snes_x,#0x00010000
	mov snes_nz,snes_x,lsr#16
	fetch 2
_xE8
mxE8
	add snes_x,snes_x,#0x00010000
	bic snes_x,snes_x,#0x01000000
	mov snes_nz,snes_x,lsr#8
__EA	;NOP - - - - - - - - - - - - - - - - - - - - - - - - -
_xEA
m_EA
mxEA
	fetch 2	
;---------------------------------------------------------------
__98	;TYA
_x98
	bic snes_a,snes_y,#0xff
	mov snes_nz,snes_a,lsr#16
	fetch 2
m_98
	and r0,snes_y,#0x00ff0000
	mov snes_a,r0,lsl#8
	mov snes_nz,r0,lsr#8
	fetch 2
mx98
	mov snes_nz,snes_y,lsr#8
	mov snes_a,snes_nz,lsl#16
	fetch 2
;---------------------------------------------------------------
__8A	;TXA
_x8A
	bic snes_a,snes_x,#0xff
	mov snes_nz,snes_a,lsr#16
	fetch 2
m_8A
	and r0,snes_x,#0x00ff0000
	mov snes_a,r0,lsl#8
	mov snes_nz,r0,lsr#8
	fetch 2
mx8A
	mov snes_nz,snes_x,lsr#8
	mov snes_a,snes_nz,lsl#16
	fetch 2
;---------------------------------------------------------------
__9B	;TXY
m_9B
	mov snes_y,snes_x
	mov snes_nz,snes_y,lsr#16
	fetch 2
_x9B
mx9B
	mov snes_y,snes_x
	mov snes_nz,snes_y,lsr#8
	fetch 2
;---------------------------------------------------------------
__BB	;TYX
m_BB
	mov snes_x,snes_y
	mov snes_nz,snes_x,lsr#16
	fetch 2
_xBB
mxBB
	mov snes_x,snes_y
	mov snes_nz,snes_x,lsr#8
	fetch 2

;****** snes_s instructions ******
;---------------------------------------------------------------
__BA	;TSX
m_BA
	and snes_x,snes_x,#0xff
	ldr snes_nz,snes_s
	orr snes_x,snes_x,snes_nz,lsl#16
	fetch 2
_xBA
mxBA
	and snes_x,snes_x,#0xff
	ldrb snes_nz,snes_s
	orr snes_x,snes_x,snes_nz,lsl#16
	mov snes_nz,snes_nz,lsl#8
	fetch 2
;---------------------------------------------------------------
__9A	;TXS
m_9A
_x9A
mx9A
	mov r0,snes_x,lsr#16
	str r0,snes_s
	fetch 2
;---------------------------------------------------------------
__AB	;PLB
m_AB
_xAB
mxAB
	pop8
	mov snes_nz,r0,lsl#8
	bic snes_x,snes_x,#0xff
	bic snes_y,snes_y,#0xff
	orr snes_x,snes_x,r0
	orr snes_y,snes_y,r0
	fetch 4
;---------------------------------------------------------------
__63	;ADC $nn,s
_x63
	opADC set_mem16, addrDS
m_63
mx63
	opADC set_mem8, addrDS
;---------------------------------------------------------------
__73	;ADC ($nn,s),y
_x73
	opADC set_mem16, addrDSY
m_73
mx73
	opADC set_mem8, addrDSY
;---------------------------------------------------------------
__E3	;SBC $nn,s
_xE3
	opSBC set_mem16, addrDS
m_E3
mxE3
	opSBC set_mem8, addrDS
;---------------------------------------------------------------
__F3	;SBC ($nn,s),y
_xF3
	opSBC set_mem16, addrDSY
m_F3
mxF3
	opSBC set_mem8, addrDSY
;---------------------------------------------------------------
__A3	;LDA $nn,s
_xA3
	opLDA set_mem16, addrDS
m_A3
mxA3
	opLDA set_mem8, addrDS
;---------------------------------------------------------------
__B3	;LDA ($nn,s),y
_xB3
	opLDA set_mem16, addrDSY
m_B3
mxB3
	opLDA set_mem8, addrDSY
;---------------------------------------------------------------
__23	;AND $nn,s
_x23
	opAND set_mem16, addrDS
m_23
mx23
	opAND set_mem8, addrDS
;---------------------------------------------------------------
__33	;AND ($nn,s),y
_x33
	opAND set_mem16, addrDSY
m_33
mx33
	opAND set_mem8, addrDSY
;---------------------------------------------------------------
__03	;ORA $nn,s
_x03
	opORA set_mem16, addrDS
m_03
mx03
	opORA set_mem8, addrDS
;---------------------------------------------------------------
__13	;ORA ($nn,s),y
_x13
	opORA set_mem16, addrDSY
m_13
mx13
	opORA set_mem8, addrDSY
;---------------------------------------------------------------
__43	;EOR $nn,s
_x43
	opEOR set_mem16, addrDS
m_43
mx43
	opEOR set_mem8, addrDS
;---------------------------------------------------------------
__53	;EOR ($nn,s),y
_x53
	opEOR set_mem16, addrDSY
m_53
mx53
	opEOR set_mem8, addrDSY
;---------------------------------------------------------------
__C3	;CMP $nn,s
_xC3
	opCMP set_mem16, addrDS
m_C3
mxC3
	opCMP set_mem8, addrDS
;---------------------------------------------------------------
__D3	;CMP ($nn,s),y
_xD3
	opCMP set_mem16, addrDSY
m_D3
mxD3
	opCMP set_mem8, addrDSY
;---------------------------------------------------------------
__83	;STA $nn,s
_x83
	opSTA set_mem16, addrDS
m_83
mx83
	opSTA set_mem8, addrDS
;---------------------------------------------------------------
__93	;STA ($nn,s),y
_x93
	opSTA set_mem16, addrDSY
m_93
mx93
	opSTA set_mem8, addrDSY
;---------------------------------------------------------------
__48	;PHA
_x48
	mov r0,snes_a,lsr#16
	push16
	fetch 4
m_48
mx48
	mov r0,snes_a,lsr#24
	push8
	fetch 3
;---------------------------------------------------------------
__5A	;PHY
m_5A
	mov r0,snes_y,lsr#16
	push16
	fetch 4
_x5A
mx5A
	mov r0,snes_y,lsr#16
	push8
	fetch 3
;---------------------------------------------------------------
__DA	;PHX
m_DA
	mov r0,snes_x,lsr#16
	push16
	fetch 4
_xDA
mxDA
	mov r0,snes_x,lsr#16
	push8
	fetch 3
;---------------------------------------------------------------
__0B	;PHD
m_0B
_x0B
mx0B
	mov r0,snes_d
	push16
	fetch 4
;---------------------------------------------------------------
__2B	;PLD
_x2B
m_2B
mx2B
	pop16
	orr snes_nz,r1,r0,lsl#8
	mov snes_d,snes_nz
	fetch 5
;---------------------------------------------------------------
__8B	;PHB
_x8B
m_8B
mx8B
	and r0,snes_x,#0xFF
	push8
	fetch 3
;---------------------------------------------------------------
__4B	;PHK
_x4B
m_4B
mx4B
	ldrb r0,snes_pb
	push8
	fetch 3
;---------------------------------------------------------------
__F4	;PEA
_xF4
m_F4
mxF4
	ldrb r0,[snes_pc],#1
	ldrb r1,[snes_pc],#1
	orr r0,r0,r1,lsl#8
	push16
	fetch 5
;---------------------------------------------------------------
__68	;PLA
_x68
	pop16
	orr snes_nz,r1,r0,lsl#8
	mov snes_a,snes_nz,lsl#16
	fetch 5
m_68
mx68
	pop8
	mov snes_nz,r0,lsl#8
	mov snes_a,r0,lsl#24
	fetch 4
;---------------------------------------------------------------
__7A	;PLY
m_7A
	pop16
	orr snes_nz,r1,r0,lsl#8
	and snes_y,snes_y,#0xff ;db
	orr snes_y,snes_y,snes_nz,lsl#16
	fetch 5
_x7A
mx7A
	pop8
	mov snes_nz,r0,lsl#8
	and snes_y,snes_y,#0xff ;db
	orr snes_y,snes_y,r0,lsl#16
	fetch 4
;---------------------------------------------------------------
__FA	;PLX
m_FA
	pop16
	orr snes_nz,r1,r0,lsl#8
	and snes_x,snes_x,#0xff ;db
	orr snes_x,snes_x,snes_nz,lsl#16
	fetch 5
_xFA
mxFA
	pop8
	mov snes_nz,r0,lsl#8
	and snes_x,snes_x,#0xff ;db
	orr snes_x,snes_x,r0,lsl#16
	fetch 4

;****** snes_pb + snes_pc_offset + snes_s ******
;---------------------------------------------------
__60	;RTS
_x60
m_60
mx60
	pop16
	ldr r12,snes_pb
	orr r12,r1,r12,lsl#16
	orr r12,r12,r0,lsl#8
	add r12,r12,#1
	encodePC
	fetch 6
;---------------------------------------------------
__6B	;RTL
_x6B
m_6B
mx6B
	pop24
	str r1,snes_pb
	orr r0,r0,r1,lsl#16
	add r12,r0,#1
	encodePC
	fetch 6
;---------------------------------------------------------------
__20	;JSR
_x20
m_20
mx20
	ldr r0,snes_pc_offset
	ldrb r1,[snes_pc],#1	;r1=addr lo
	sub r0,snes_pc,r0		;r0=what to push
	ldrb r2,[snes_pc]		;r2=addr hi
	and snes_pc,r0,#0xff0000	;same pb
	orr snes_pc,snes_pc,r1
	orr snes_pc,snes_pc,r2,lsl#8
	push16
	mov r12,snes_pc
	encodePC
	fetch 6
;---------------------------------------------------------------
__FC	;JSR ($nnnn,x)
_xFC
m_FC
mxFC
	ldr r0,snes_pc_offset
	ldrb r1,[snes_pc],#1	;r1=addr lo
	sub r0,snes_pc,r0		;r0=what to push
	ldrb r2,[snes_pc]		;r2=addr hi
	and snes_pc,r0,#0xff0000	;same pb
	orr snes_pc,snes_pc,r1
	orr snes_pc,snes_pc,r2,lsl#8
	push16
	add r12,snes_pc,snes_x,lsr#16
	readmem16
	and r12,snes_pc,#0xff0000	;same pb
	orr r0,r1,r0,lsl#8
	orr r12,r12,r0
	encodePC
	fetch 8
;---------------------------------------------------------------
__22	;JSL $nnnnnn
_x22
m_22
mx22
	ldr r0,snes_pb
	push8
	ldr r0,snes_pc_offset
	ldrb r1,[snes_pc],#1	;r1=addr lo
	ldrb r2,[snes_pc],#1	;r2=addr hi
	sub r0,snes_pc,r0		;r0=what to push
	ldrb r12,[snes_pc]	;r12=new pb
	str r12,snes_pb		;save pb
	orr snes_pc,r1,r12,lsl#16
	orr snes_pc,snes_pc,r2,lsl#8
	push16
	mov r12,snes_pc
	encodePC
	fetch 8
;------------------------------------------------------------
__62	;PER
_x62
m_62
mx62
	ldrb r0,[snes_pc],#1
	ldrb r1,[snes_pc],#1
	orr r0,r0,r1,lsl#8
	ldr r2,snes_pc_offset
	sub r1,snes_pc,r2
	add r0,r0,r1
	push16
	fetch 6
;------------------------------------------------------------
__D4	;PEI
_xD4
m_D4
mxD4
	addrDIR
 [ SAFE
	readmem16
 |
	readram16
 ]
	orr r0,r1,r0,lsl#8
	push16
	fetch 6
;---------------------------------------------------------------
 	MAP 0,r12

snes_b		DCD 0	;bb000000
snes_b_r12 	# 4
snes_mxdi 	DCD 0	;00MXDI00
snes_mxdi_r12 	# 4
snes_s		DCD 0	;0000ssss
snes_s_r12 	# 4
snes_pc_offset	DCD 0	;snes_pc-snes_pc_offset=actual 65816 pc
snes_pc_offset_r12 # 4
snes_pb		DCD 0
snes_pb_r12	# 4	;000000pb

;****** snes_mxdi + snes_b + snes_s ******
;---------------------------------------------------------------
__FB	;XCE
_xFB
m_FB
mxFB
;	mov r11,r11								;No$GBA brk
	ands r0,snes_cycles,#3
	cmpne r0,#3
	eorne snes_cycles,snes_cycles,#3
	ldr r1,snes_mxdi
	mov r0,r1
changeMX		;r0=new snes_mxdi, r1=old snes_mxdi
	tst snes_cycles,#CYCLES_E_FLAG			;E=1?
	movne r2,#1
	strneb r2,snes_s+1		;SH=1
	orrne r0,r0,#M_FLAG+X_FLAG
	tst r1,#M_FLAG
		ldrne r2,snes_b
		orrne snes_a,r2,snes_a,lsr#8
	tst r0,#M_FLAG
		andne r1,snes_a,#0xff000000
		strne r1,snes_b
		movne snes_a,snes_a,lsl#8
	tst r0,#X_FLAG
		bicne snes_x,snes_x,#0xff000000
		bicne snes_y,snes_y,#0xff000000
changeD		;r0=new snes_mxdi
	str r0,snes_mxdi
	load_snes_optable
ch0
	fetch 2

;****** snes_b + snes_s instructions ******
;---------------------------------------------------------------
__1B	;TCS
_x1B
	mov r0,snes_a,lsr#16
	str r0,snes_s
	fetch 2
m_1B
mx1B
	ldr r1,snes_b
	orr r1,r1,snes_a,lsr#8
	mov r1,r1,lsr#16
	str r1,snes_s
	fetch 2
;---------------------------------------------------------------
__3B	;TSC
_x3B
	ldr snes_nz,snes_s
	mov snes_a,snes_nz,lsl#16
	fetch 2
m_3B
mx3B
	ldr snes_nz,snes_s
	mov snes_a,snes_nz,ror#8
	strb snes_a,snes_b+3
	and snes_a,snes_a,#0xff000000
	fetch 2

;****** snes_b instructions ******
;---------------------------------------------------------------
__AA	;TAX
	and snes_x,snes_x,#0xff
	orr snes_x,snes_x,snes_a
	mov snes_nz,snes_x,lsr#16
	fetch 2
_xAA
	and snes_x,snes_x,#0xff
	orr snes_x,snes_x,snes_a
	bic snes_x,snes_x,#0xff000000
	mov snes_nz,snes_x,lsr#8
	fetch 2
m_AA
	and snes_x,snes_x,#0xff
	ldr r0,snes_b
	orr r0,r0,snes_a,lsr#8
	orr snes_x,snes_x,r0
	mov snes_nz,snes_x,lsr#16
	fetch 2
mxAA
	and snes_x,snes_x,#0xff
	orr snes_x,snes_x,snes_a,lsr#8
	mov snes_nz,snes_x,lsr#8
	fetch 2
;---------------------------------------------------------------
__A8	;TAY
	and snes_y,snes_y,#0xff
	orr snes_y,snes_y,snes_a
	mov snes_nz,snes_y,lsr#16
	fetch 2
_xA8
	and snes_y,snes_y,#0xff
	orr snes_y,snes_y,snes_a
	bic snes_y,snes_y,#0xff000000
	mov snes_nz,snes_y,lsr#8
	fetch 2
m_A8
	and snes_y,snes_y,#0xff
	ldr r0,snes_b
	orr r0,r0,snes_a,lsr#8
	orr snes_y,snes_y,r0
	mov snes_nz,snes_y,lsr#16
	fetch 2
mxA8
	and snes_y,snes_y,#0xff
	orr snes_y,snes_y,snes_a,lsr#8
	mov snes_nz,snes_y,lsr#8
	fetch 2
;---------------------------------------------------------------
__EB	;XBA
_xEB
	mov snes_a,snes_a,ror#24		;=A00B
	mov snes_nz,snes_a,lsl#8		;=00B0
	orr snes_a,snes_a,snes_a,lsl#16	;=AB0B
	bic snes_a,snes_a,#0xff		;=AB00
	fetch 3
m_EB
mxEB
	adr r0,snes_b
	swp snes_a,snes_a,[r0]
	mov snes_nz,snes_a,lsr#16
	fetch 3
;---------------------------------------------------------------
__5B	;TCD
_x5B
	mov snes_d,snes_a,lsr#16
	mov snes_nz,snes_d
	fetch 2
m_5B
mx5B
	ldr r0,snes_b
	orr r0,r0,snes_a,lsr#8
	mov snes_d,r0,lsr#16
	mov snes_nz,snes_d
	fetch 2
;---------------------------------------------------------------
__7B	;TDC
_x7B
	mov snes_nz,snes_d
	mov snes_a,snes_nz,lsl#16
	fetch 2
m_7B
mx7B
	mov snes_nz,snes_d
	mov snes_a,snes_nz,ror#8
	strb snes_a,snes_b+3
	and snes_a,snes_a,#0xff000000
	fetch 2
;---------------------------------------------------------------
_x54	;MVN
 [ SAFE
	mov r1,#0xff000000
	b %F0
 ]
__54
 [ SAFE
	mov r1,#0
0
 ]
	mov r0,#0x00010000
	bl MVN
	fetch 7
mx54
 [ SAFE
	mov r1,#0xff000000
	b %F0
 ]
m_54
 [ SAFE
	mov r1,#0
0
 ]
	mov r0,#0x00010000
	ldr r2,snes_b
	orr snes_a,r2,snes_a,lsr#8
	bl MVN
	and r0,snes_a,#0xff000000
	str r0,snes_b
	mov snes_a,snes_a,lsl#8
	fetch 7
;---------------------------------------------------------------
_x44	;MVP
 [ SAFE
	mov r1,#0xff000000
	b %F0
 ]
__44
 [ SAFE
	mov r1,#0
0
 ]
	bl MVP
	fetch 7
mx44
 [ SAFE
	mov r1,#0xff000000
	b %F0
 ]
m_44
 [ SAFE
	mov r1,#0
0
 ]
	ldr r2,snes_b
	orr snes_a,r2,snes_a,lsr#8
	bl MVP
	and r0,snes_a,#0xff000000
	str r0,snes_b
	mov snes_a,snes_a,lsl#8
	fetch 7

;****** snes_mxdi instructions ******
;---------------------------------------------------------------
__58	;CLI
_x58
m_58
mx58
	ldr r0,snes_mxdi
	bic r0,r0,#I_FLAG
	str r0,snes_mxdi
	fetch 2
;---------------------------------------------------------------
__78	;SEI
_x78
m_78
mx78
	ldr r0,snes_mxdi
	orr r0,r0,#I_FLAG
	str r0,snes_mxdi
	fetch 2
;---------------------------------------------------------------
__D8	;CLD
_xD8
m_D8
mxD8
	ldr r0,snes_mxdi
	bic r0,r0,#D_FLAG
	b changeD 		;r0=new mxdi
;---------------------------------------------------------------
__F8	;SED
_xF8
m_F8
mxF8
	ldr r0,snes_mxdi
	orr r0,r0,#D_FLAG
	b changeD 		;r0=new mxdi
;---------------------------------------------------------------
__C2	;REP #nn
_xC2
m_C2
mxC2
	ldrb r2,[snes_pc],#1
	tst r2,#C_FLAG
	bicne snes_cycles,snes_cycles,#C_FLAG
	tst r2,#V_FLAG
	bicne snes_cycles,snes_cycles,#CYCLES_V_FLAG
	tst r2,#N_FLAG
	orrne snes_nz,snes_nz,snes_nz,lsr#1	
	bicne snes_nz,snes_nz,#0x28000
	tst r2,#Z_FLAG
	orrne snes_nz,snes_nz,#1
	ldr r1,snes_mxdi
	bic r0,r1,r2
	eatcycles 1
	b changeMX 		;r0=new mxdi, r1=old mxdi
;---------------------------------------------------------------
__E2	;SEP #nn
_xE2
m_E2
mxE2
	ldrb r2,[snes_pc],#1
	tst r2,#C_FLAG
	orrne snes_cycles,snes_cycles,#C_FLAG
	tst r2,#V_FLAG
	orrne snes_cycles,snes_cycles,#CYCLES_V_FLAG
	tst r2,#N_FLAG
	orrne snes_nz,snes_nz,#0x20000
	tst r2,#Z_FLAG
	orrne snes_nz,snes_nz,snes_nz,lsl#2
	andne snes_nz,snes_nz,#0x20000
	ldr r1,snes_mxdi
	and r2,r2,#M_FLAG+X_FLAG+D_FLAG+I_FLAG
	orr r0,r1,r2
	eatcycles 1
	b changeMX 		;r0=new mxdi, r1=old mxdi

;****** snes_mxdi + snes_s ******
;------------------------------------------------------------
__08	;PHP
_x08
m_08
mx08
	encodeP
	push8
	fetch 3
;------------------------------------------------------------
__28	;PLP
_x28
m_28
mx28
	pop8	
plp_r0
	bic snes_cycles,snes_cycles,#CYCLES_V_FLAG+C_FLAG
	and r1,r0,#V_FLAG
	movs r12,r0,lsr#1
	adc snes_cycles,snes_cycles,r1,lsr#4	;VC
	mov snes_nz,r0,lsl#10
	and snes_nz,snes_nz,#0x20000		;N
	tst r0,#Z_FLAG
	orreq snes_nz,snes_nz,#1			;Z
	and r0,r0,#M_FLAG+X_FLAG+D_FLAG+I_FLAG
	ldr r1,snes_mxdi
	eatcycles 2
	b changeMX ;r0=new mxdi, r1=old mxdi

;------------------------------------------------------------
__40	;RTI
_x40
m_40
mx40
	pop8
	mov snes_nz,r0

	pop24
	str r1,snes_pb
	orr r12,r0,r1,lsl#16
	encodePC
	eatcycles 3

	mov r0,snes_nz
	b plp_r0

;****** snes_pb + snes_pc_offset ******
;------------------------------------------------------------
__4C	;JMP $nnnn
_x4C
m_4C
mx4C
	ldrb r0,[snes_pc],#1
	ldrb r1,[snes_pc]
	ldrb r2,snes_pb
	orr r12,r0,r1,lsl#8
	orr r12,r12,r2,lsl#16
	encodePC
	fetch 3
;------------------------------------------------------------
__82	;BRL $nnnn
_x82
m_82
mx82
 [ SAFE
	ldrb r0,[snes_pc],#1
	ldrb r1,[snes_pc],#1
	orr r0,r0,r1,lsl#8
	ldr r2,snes_pc_offset
	sub r12,snes_pc,r2
	add r12,r12,r0
	ldr r2,snes_pb
	bic r12,r12,#0xff0000
	orr r12,r12,r2,lsl#16
	encodePC
 |
	ldrb r0,[snes_pc],#1
	ldrsb r1,[snes_pc],#1
	orr r0,r0,r1,lsl#8
	add snes_pc,snes_pc,r0
 ]
	fetch 4
;---------------------------------------------------------------
__5C	;JMP $nnnnnn
_x5C
m_5C
mx5C
	ldrb r0,[snes_pc],#1
	ldrb r1,[snes_pc],#1
	ldrb r2,[snes_pc],#1
	strb r2,snes_pb
	orr r12,r0,r1,lsl#8
	orr r12,r12,r2,lsl#16
	encodePC
	fetch 4
;------------------------------------------------------------
__6C	;JMP ($nnnn)
_x6C
m_6C
mx6C
	addrAI
	readmem16
	orr r12,r1,r0,lsl#8
	ldr r0,snes_pb
	orr r12,r12,r0,lsl#16
	encodePC
	fetch 5
;------------------------------------------------------------
__7C	;JMP ($nnnn,x)
_x7C
m_7C
mx7C
	addrAI
	add r12,r12,snes_x,lsr#16
	ldr snes_pc,snes_pb
	add r12,r12,snes_pc,lsl#16
	readmem16
	orr r12,r1,r0,lsl#8
	orr r12,r12,snes_pc,lsl#16
	encodePC
	fetch 6
;------------------------------------------------------------
__DC	;JML ($nnnn)
_xDC
m_DC
mxDC
	addrAI
	readmem8
	ldrb r2,[r1,#1]
	ldrb r12,[r1,#2]
	str r12,snes_pb
	orr r12,r0,r12,lsl#16
	orr r12,r12,r2,lsl#8
	encodePC
	fetch 6

;******* mxdi, pb, s, offset
;---------------------------------------------------------------
__02	;COP
_x02
m_02
mx02
	ldr r12,=SNES_COP_VECTOR
	b brk
;---------------------------------------------------------------
__00	;BRK
_x00
m_00
mx00
 [ DEBUG
;	ldr r1,snes_pc_offset
;	sub r0,snes_pc,r1
;	sub r0,r0,#1
;	DEBUGERROR 0x204b5242,r0
 ]
	ldr r12,=SNES_BRK_VECTOR
brk
	add snes_pc,snes_pc,#1
	bl interrupt
	fetch 0
;---------------------------------------------------------------
interrupt	;r12=vector
	stmfd sp!,{r12,lr}
;	tst snes_cycles,#CYCLES_E_FLAG
;	beq note
	mov r11,r11								;No$GBA brk
;note

	ldr r0,snes_pb		;save PC
	push8
	ldr r1,snes_pc_offset
	sub r0,snes_pc,r1
	push16

	encodeP			;save P
	push8

	ldmfd sp!,{r12}		;(vector)
	bl rom00_R16
	add r12,r1,r0,lsl#8
	encodePC
	strb snes_a,snes_pb	;PB=0

	ldr r0,snes_mxdi
	orr r0,r0,#I_FLAG
	bic r0,r0,#D_FLAG
	str r0,snes_mxdi		;Interrupt disable
	load_snes_optable

	eatcycles 8
	ldmfd sp!,{pc}
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-==-=-=-
	INFO 0,"*** $dups dups removed!"

cycles_per_line DCD 0

;65816.h contains map to r1
vcount DCD 0		;*i (current scanline)
HVtimer DCD 0		;*i (4207/09) interrupt when HVtimer<=vcount.  set to 0 when htimer enabled (interrupt every line)
hcount_latch DCD 0	;(213c)
vcount_latch DCD 0	;(213d)
vtimetemp DCW 0		;*i (4209)
htimetemp DCW 0		;*i
HVtimerlatch DCW 0	;*i copied to HVtimer every frame
rdnmi DCB 0		;*i 4210
nmitimen DCB 0		;*i 4200
adjusted_vtime DCW 0	;*i vtimetemp modified (262->263, 0->262)
adjusted_htime DCW 0	;*i htimetemp modified (0-339=0 >339=-1)??
timeup DCW 0		;(4211)

	ALIGN
timeout			;new scanline
	adr r2,vcount
	ldmia r2,{r0,r1}
	add r0,r0,#1
	str r0,vcount			;scanline++

	DEBUGINFO LINE,r0

	cmp r0,r1			;h/v timeout when vcount>=HVtimer
	bhs HVtimeup
timer_return
	cmp r0,#120
	beq scanline120
	cmp r0,#225			;225/240
	beq scanlineVBL
	subs r0,r0,#232		;cmp r0,#232/247
	beq scanlineNMI
	cmp r0,#30			;cmp r0,#262: 30/15
	beq scanline0
next_line
	ldr r0,cycles_per_line
	timeout_fetch r0
HVtimeup				;do VTIME or HTIME interrupt
	mov r2,#0x80
	strb r2,timeup

	DEBUGCOUNT TIME

	strh r1,HVtimer+2		;stop timer if this was VTIME interrupt (interrupt only once per frame)

	ldrb r1,nmitimen
	tst r1,#0x30		;H/VIRQ enabled?
	beq timer_return		;r0 is still vcount

	tst snes_cycles,#WAI_WAITING	;break out of WAI..
	addne snes_pc,snes_pc,#1
	bic snes_cycles,snes_cycles,#WAI_WAITING

	ldr r1,snes_mxdi
	tst r1,#I_FLAG			;1=IRQs disabled
	bne timer_return
	
	DEBUGCOUNT IRQS

	ldr r12,=SNES_IRQ_VECTOR
	bl interrupt
	ldr r0,vcount
	b timer_return	;r0=vcount
scanline0
	mov r0,#0
	str r0,vcount
	strb r0,rdnmi		;clear VBL

	DEBUGINFO LINE,r0

	adr lr,next_line
	b post_vblank_process	;do sprites, etc
scanline120
	adr lr,next_line
;	b mid_frame_process		;do fade and prio.
	ldr pc,=mid_frame_process		;do fade and prio.
scanlineVBL
;	mov r0,#0x80
;	strb r0,rdnmi		;set VBL flag
	b next_line
scanlineNMI
	mov r0,#0x80
	strb r0,rdnmi		;set NMI flag

	ldrb r2,nmitimen
	tst r2,#0x80		;NMI enabled?
	beq no_nmi

	tst snes_cycles,#WAI_WAITING	;break out of WAI..
	addne snes_pc,snes_pc,#1
	bic snes_cycles,snes_cycles,#WAI_WAITING

	ldr r12,=SNES_NMI_VECTOR
	bl interrupt
no_nmi
 [ :LNOT:DEBUG
	ldr r2,=throttle_intr
	ldrb r1,[r2]
	mov r0,#0
	cmp r1,#0
	mov r12,r3	;(r3 gets trashed by the swi)
	swine 0x040000
	mov r3,r12

	bl pre_vblank_process
	movs r1,r1			;check if menu keycombo was pressed
	bpl next_line
	b return_to_main
 |
	adr lr,next_line
	b pre_vblank_process
 ]
;-----------------------------------------------
speedhack
	and snes_cycles,snes_cycles,#CYCLE-1	;skip to end of current line
	mov pc,lr

;	adr r12,vcount
;	ldmia r12,{r0,r1}
;	cmp r0,r1
;	movhs pc,lr	;already timeup, don't need to do anything

;	mov r2,#241	;skip to scanline (HVtimer/241/262), whichever comes next
;	cmp r0,r2
;	addpl r2,r2,#21
;	cmp r2,r1
;	movhi r2,r1

;	sub r2,r2,#1
;	str r2,[r12]
;	mov pc,lr
;-----------------------------------------------
run_iwram
 [ DEBUG
	str r0,debug_instrcount
 ]
	stmfd sp!,{r4-r11,lr}
	ldr r12,=snes_state
	ldmia r12,{r3-r11}	
debugnext
	timeout_fetch #0
 [ DEBUG
debugtrap
	ldr r0,debug_instrcount
	subs r0,r0,#1
	str r0,debug_instrcount
	bne debugnext
 |
return_to_main				;from snes vblank
	ldr r0,cycles_per_line
	sub snes_cycles,snes_cycles,r0
 ]
	ldr r12,=snes_state
	stmia r12,{r3-r11}
	ldmfd sp!,{r4-r11,lr}
	bx lr
 [ DEBUG
debug_instrcount DCD 0
 ]
;---------------------------------------------------------------

snes_state % 4*9 	;r3-r11

	LTORG


optable___
        DCD __00,__01,__02,__03,__04,__05,__06,__07,__08,__09,__0A,__0B,__0C,__0D,__0E,__0F
        DCD __10,__11,__12,__13,__14,__15,__16,__17,__18,__19,__1A,__1B,__1C,__1D,__1E,__1F
        DCD __20,__21,__22,__23,__24,__25,__26,__27,__28,__29,__2A,__2B,__2C,__2D,__2E,__2F
        DCD __30,__31,__32,__33,__34,__35,__36,__37,__38,__39,__3A,__3B,__3C,__3D,__3E,__3F
        DCD __40,__41,__42,__43,__44,__45,__46,__47,__48,__49,__4A,__4B,__4C,__4D,__4E,__4F
        DCD __50,__51,__52,__53,__54,__55,__56,__57,__58,__59,__5A,__5B,__5C,__5D,__5E,__5F
        DCD __60,__61,__62,__63,__64,__65,__66,__67,__68,__69,__6A,__6B,__6C,__6D,__6E,__6F
        DCD __70,__71,__72,__73,__74,__75,__76,__77,__78,__79,__7A,__7B,__7C,__7D,__7E,__7F
        DCD __80,__81,__82,__83,__84,__85,__86,__87,__88,__89,__8A,__8B,__8C,__8D,__8E,__8F
        DCD __90,__91,__92,__93,__94,__95,__96,__97,__98,__99,__9A,__9B,__9C,__9D,__9E,__9F
        DCD __A0,__A1,__A2,__A3,__A4,__A5,__A6,__A7,__A8,__A9,__AA,__AB,__AC,__AD,__AE,__AF
        DCD __B0,__B1,__B2,__B3,__B4,__B5,__B6,__B7,__B8,__B9,__BA,__BB,__BC,__BD,__BE,__BF
        DCD __C0,__C1,__C2,__C3,__C4,__C5,__C6,__C7,__C8,__C9,__CA,__CB,__CC,__CD,__CE,__CF
        DCD __D0,__D1,__D2,__D3,__D4,__D5,__D6,__D7,__D8,__D9,__DA,__DB,__DC,__DD,__DE,__DF
        DCD __E0,__E1,__E2,__E3,__E4,__E5,__E6,__E7,__E8,__E9,__EA,__EB,__EC,__ED,__EE,__EF
        DCD __F0,__F1,__F2,__F3,__F4,__F5,__F6,__F7,__F8,__F9,__FA,__FB,__FC,__FD,__FE,__FF
optable__x
        DCD _x00,_x01,_x02,_x03,_x04,_x05,_x06,_x07,_x08,_x09,_x0A,_x0B,_x0C,_x0D,_x0E,_x0F
        DCD _x10,_x11,_x12,_x13,_x14,_x15,_x16,_x17,_x18,_x19,_x1A,_x1B,_x1C,_x1D,_x1E,_x1F
        DCD _x20,_x21,_x22,_x23,_x24,_x25,_x26,_x27,_x28,_x29,_x2A,_x2B,_x2C,_x2D,_x2E,_x2F
        DCD _x30,_x31,_x32,_x33,_x34,_x35,_x36,_x37,_x38,_x39,_x3A,_x3B,_x3C,_x3D,_x3E,_x3F
        DCD _x40,_x41,_x42,_x43,_x44,_x45,_x46,_x47,_x48,_x49,_x4A,_x4B,_x4C,_x4D,_x4E,_x4F
        DCD _x50,_x51,_x52,_x53,_x54,_x55,_x56,_x57,_x58,_x59,_x5A,_x5B,_x5C,_x5D,_x5E,_x5F
        DCD _x60,_x61,_x62,_x63,_x64,_x65,_x66,_x67,_x68,_x69,_x6A,_x6B,_x6C,_x6D,_x6E,_x6F
        DCD _x70,_x71,_x72,_x73,_x74,_x75,_x76,_x77,_x78,_x79,_x7A,_x7B,_x7C,_x7D,_x7E,_x7F
        DCD _x80,_x81,_x82,_x83,_x84,_x85,_x86,_x87,_x88,_x89,_x8A,_x8B,_x8C,_x8D,_x8E,_x8F
        DCD _x90,_x91,_x92,_x93,_x94,_x95,_x96,_x97,_x98,_x99,_x9A,_x9B,_x9C,_x9D,_x9E,_x9F
        DCD _xA0,_xA1,_xA2,_xA3,_xA4,_xA5,_xA6,_xA7,_xA8,_xA9,_xAA,_xAB,_xAC,_xAD,_xAE,_xAF
        DCD _xB0,_xB1,_xB2,_xB3,_xB4,_xB5,_xB6,_xB7,_xB8,_xB9,_xBA,_xBB,_xBC,_xBD,_xBE,_xBF
        DCD _xC0,_xC1,_xC2,_xC3,_xC4,_xC5,_xC6,_xC7,_xC8,_xC9,_xCA,_xCB,_xCC,_xCD,_xCE,_xCF
        DCD _xD0,_xD1,_xD2,_xD3,_xD4,_xD5,_xD6,_xD7,_xD8,_xD9,_xDA,_xDB,_xDC,_xDD,_xDE,_xDF
        DCD _xE0,_xE1,_xE2,_xE3,_xE4,_xE5,_xE6,_xE7,_xE8,_xE9,_xEA,_xEB,_xEC,_xED,_xEE,_xEF
        DCD _xF0,_xF1,_xF2,_xF3,_xF4,_xF5,_xF6,_xF7,_xF8,_xF9,_xFA,_xFB,_xFC,_xFD,_xFE,_xFF
optable_m_
        DCD m_00,m_01,m_02,m_03,m_04,m_05,m_06,m_07,m_08,m_09,m_0A,m_0B,m_0C,m_0D,m_0E,m_0F
        DCD m_10,m_11,m_12,m_13,m_14,m_15,m_16,m_17,m_18,m_19,m_1A,m_1B,m_1C,m_1D,m_1E,m_1F
        DCD m_20,m_21,m_22,m_23,m_24,m_25,m_26,m_27,m_28,m_29,m_2A,m_2B,m_2C,m_2D,m_2E,m_2F
        DCD m_30,m_31,m_32,m_33,m_34,m_35,m_36,m_37,m_38,m_39,m_3A,m_3B,m_3C,m_3D,m_3E,m_3F
        DCD m_40,m_41,m_42,m_43,m_44,m_45,m_46,m_47,m_48,m_49,m_4A,m_4B,m_4C,m_4D,m_4E,m_4F
        DCD m_50,m_51,m_52,m_53,m_54,m_55,m_56,m_57,m_58,m_59,m_5A,m_5B,m_5C,m_5D,m_5E,m_5F
        DCD m_60,m_61,m_62,m_63,m_64,m_65,m_66,m_67,m_68,m_69,m_6A,m_6B,m_6C,m_6D,m_6E,m_6F
        DCD m_70,m_71,m_72,m_73,m_74,m_75,m_76,m_77,m_78,m_79,m_7A,m_7B,m_7C,m_7D,m_7E,m_7F
        DCD m_80,m_81,m_82,m_83,m_84,m_85,m_86,m_87,m_88,m_89,m_8A,m_8B,m_8C,m_8D,m_8E,m_8F
        DCD m_90,m_91,m_92,m_93,m_94,m_95,m_96,m_97,m_98,m_99,m_9A,m_9B,m_9C,m_9D,m_9E,m_9F
        DCD m_A0,m_A1,m_A2,m_A3,m_A4,m_A5,m_A6,m_A7,m_A8,m_A9,m_AA,m_AB,m_AC,m_AD,m_AE,m_AF
        DCD m_B0,m_B1,m_B2,m_B3,m_B4,m_B5,m_B6,m_B7,m_B8,m_B9,m_BA,m_BB,m_BC,m_BD,m_BE,m_BF
        DCD m_C0,m_C1,m_C2,m_C3,m_C4,m_C5,m_C6,m_C7,m_C8,m_C9,m_CA,m_CB,m_CC,m_CD,m_CE,m_CF
        DCD m_D0,m_D1,m_D2,m_D3,m_D4,m_D5,m_D6,m_D7,m_D8,m_D9,m_DA,m_DB,m_DC,m_DD,m_DE,m_DF
        DCD m_E0,m_E1,m_E2,m_E3,m_E4,m_E5,m_E6,m_E7,m_E8,m_E9,m_EA,m_EB,m_EC,m_ED,m_EE,m_EF
        DCD m_F0,m_F1,m_F2,m_F3,m_F4,m_F5,m_F6,m_F7,m_F8,m_F9,m_FA,m_FB,m_FC,m_FD,m_FE,m_FF
optable_mx
        DCD mx00,mx01,mx02,mx03,mx04,mx05,mx06,mx07,mx08,mx09,mx0A,mx0B,mx0C,mx0D,mx0E,mx0F
        DCD mx10,mx11,mx12,mx13,mx14,mx15,mx16,mx17,mx18,mx19,mx1A,mx1B,mx1C,mx1D,mx1E,mx1F
        DCD mx20,mx21,mx22,mx23,mx24,mx25,mx26,mx27,mx28,mx29,mx2A,mx2B,mx2C,mx2D,mx2E,mx2F
        DCD mx30,mx31,mx32,mx33,mx34,mx35,mx36,mx37,mx38,mx39,mx3A,mx3B,mx3C,mx3D,mx3E,mx3F
        DCD mx40,mx41,mx42,mx43,mx44,mx45,mx46,mx47,mx48,mx49,mx4A,mx4B,mx4C,mx4D,mx4E,mx4F
        DCD mx50,mx51,mx52,mx53,mx54,mx55,mx56,mx57,mx58,mx59,mx5A,mx5B,mx5C,mx5D,mx5E,mx5F
        DCD mx60,mx61,mx62,mx63,mx64,mx65,mx66,mx67,mx68,mx69,mx6A,mx6B,mx6C,mx6D,mx6E,mx6F
        DCD mx70,mx71,mx72,mx73,mx74,mx75,mx76,mx77,mx78,mx79,mx7A,mx7B,mx7C,mx7D,mx7E,mx7F
        DCD mx80,mx81,mx82,mx83,mx84,mx85,mx86,mx87,mx88,mx89,mx8A,mx8B,mx8C,mx8D,mx8E,mx8F
        DCD mx90,mx91,mx92,mx93,mx94,mx95,mx96,mx97,mx98,mx99,mx9A,mx9B,mx9C,mx9D,mx9E,mx9F
        DCD mxA0,mxA1,mxA2,mxA3,mxA4,mxA5,mxA6,mxA7,mxA8,mxA9,mxAA,mxAB,mxAC,mxAD,mxAE,mxAF
        DCD mxB0,mxB1,mxB2,mxB3,mxB4,mxB5,mxB6,mxB7,mxB8,mxB9,mxBA,mxBB,mxBC,mxBD,mxBE,mxBF
        DCD mxC0,mxC1,mxC2,mxC3,mxC4,mxC5,mxC6,mxC7,mxC8,mxC9,mxCA,mxCB,mxCC,mxCD,mxCE,mxCF
        DCD mxD0,mxD1,mxD2,mxD3,mxD4,mxD5,mxD6,mxD7,mxD8,mxD9,mxDA,mxDB,mxDC,mxDD,mxDE,mxDF
        DCD mxE0,mxE1,mxE2,mxE3,mxE4,mxE5,mxE6,mxE7,mxE8,mxE9,mxEA,mxEB,mxEC,mxED,mxEE,mxEF
        DCD mxF0,mxF1,mxF2,mxF3,mxF4,mxF5,mxF6,mxF7,mxF8,mxF9,mxFA,mxFB,mxFC,mxFD,mxFE,mxFF
;----------------------------------------------------------------------------
	AREA rom, CODE, READONLY

optable___d
        DCD __00,__01,__02,__03,__04,__05,__06,__07,__08,__09,__0A,__0B,__0C,__0D,__0E,__0F
        DCD __10,__11,__12,__13,__14,__15,__16,__17,__18,__19,__1A,__1B,__1C,__1D,__1E,__1F
        DCD __20,__21,__22,__23,__24,__25,__26,__27,__28,__29,__2A,__2B,__2C,__2D,__2E,__2F
        DCD __30,__31,__32,__33,__34,__35,__36,__37,__38,__39,__3A,__3B,__3C,__3D,__3E,__3F
        DCD __40,__41,__42,__43,__44,__45,__46,__47,__48,__49,__4A,__4B,__4C,__4D,__4E,__4F
        DCD __50,__51,__52,__53,__54,__55,__56,__57,__58,__59,__5A,__5B,__5C,__5D,__5E,__5F
        DCD __60,__d61,__62,__d63,__64,__d65,__66,__d67,__68,__d69,__6A,__6B,__6C,__d6D,__6E,__d6F
        DCD __70,__d71,__d72,__d73,__74,__d75,__76,__d77,__78,__d79,__7A,__7B,__7C,__d7D,__7E,__d7F
        DCD __80,__81,__82,__83,__84,__85,__86,__87,__88,__89,__8A,__8B,__8C,__8D,__8E,__8F
        DCD __90,__91,__92,__93,__94,__95,__96,__97,__98,__99,__9A,__9B,__9C,__9D,__9E,__9F
        DCD __A0,__A1,__A2,__A3,__A4,__A5,__A6,__A7,__A8,__A9,__AA,__AB,__AC,__AD,__AE,__AF
        DCD __B0,__B1,__B2,__B3,__B4,__B5,__B6,__B7,__B8,__B9,__BA,__BB,__BC,__BD,__BE,__BF
        DCD __C0,__C1,__C2,__C3,__C4,__C5,__C6,__C7,__C8,__C9,__CA,__CB,__CC,__CD,__CE,__CF
        DCD __D0,__D1,__D2,__D3,__D4,__D5,__D6,__D7,__D8,__D9,__DA,__DB,__DC,__DD,__DE,__DF
        DCD __E0,__dE1,__E2,__dE3,__E4,__dE5,__E6,__dE7,__E8,__dE9,__EA,__EB,__EC,__dED,__EE,__dEF
        DCD __F0,__dF1,__dF2,__dF3,__F4,__dF5,__F6,__dF7,__F8,__dF9,__FA,__FB,__FC,__dFD,__FE,__dFF
optable__xd
        DCD _x00,_x01,_x02,_x03,_x04,_x05,_x06,_x07,_x08,_x09,_x0A,_x0B,_x0C,_x0D,_x0E,_x0F
        DCD _x10,_x11,_x12,_x13,_x14,_x15,_x16,_x17,_x18,_x19,_x1A,_x1B,_x1C,_x1D,_x1E,_x1F
        DCD _x20,_x21,_x22,_x23,_x24,_x25,_x26,_x27,_x28,_x29,_x2A,_x2B,_x2C,_x2D,_x2E,_x2F
        DCD _x30,_x31,_x32,_x33,_x34,_x35,_x36,_x37,_x38,_x39,_x3A,_x3B,_x3C,_x3D,_x3E,_x3F
        DCD _x40,_x41,_x42,_x43,_x44,_x45,_x46,_x47,_x48,_x49,_x4A,_x4B,_x4C,_x4D,_x4E,_x4F
        DCD _x50,_x51,_x52,_x53,_x54,_x55,_x56,_x57,_x58,_x59,_x5A,_x5B,_x5C,_x5D,_x5E,_x5F
        DCD _x60,_xd61,_x62,_xd63,_x64,_xd65,_x66,_xd67,_x68,_xd69,_x6A,_x6B,_x6C,_xd6D,_x6E,_xd6F
        DCD _x70,_xd71,_xd72,_xd73,_x74,_xd75,_x76,_xd77,_x78,_xd79,_x7A,_x7B,_x7C,_xd7D,_x7E,_xd7F
        DCD _x80,_x81,_x82,_x83,_x84,_x85,_x86,_x87,_x88,_x89,_x8A,_x8B,_x8C,_x8D,_x8E,_x8F
        DCD _x90,_x91,_x92,_x93,_x94,_x95,_x96,_x97,_x98,_x99,_x9A,_x9B,_x9C,_x9D,_x9E,_x9F
        DCD _xA0,_xA1,_xA2,_xA3,_xA4,_xA5,_xA6,_xA7,_xA8,_xA9,_xAA,_xAB,_xAC,_xAD,_xAE,_xAF
        DCD _xB0,_xB1,_xB2,_xB3,_xB4,_xB5,_xB6,_xB7,_xB8,_xB9,_xBA,_xBB,_xBC,_xBD,_xBE,_xBF
        DCD _xC0,_xC1,_xC2,_xC3,_xC4,_xC5,_xC6,_xC7,_xC8,_xC9,_xCA,_xCB,_xCC,_xCD,_xCE,_xCF
        DCD _xD0,_xD1,_xD2,_xD3,_xD4,_xD5,_xD6,_xD7,_xD8,_xD9,_xDA,_xDB,_xDC,_xDD,_xDE,_xDF
        DCD _xE0,_xdE1,_xE2,_xdE3,_xE4,_xdE5,_xE6,_xdE7,_xE8,_xdE9,_xEA,_xEB,_xEC,_xdED,_xEE,_xdEF
        DCD _xF0,_xdF1,_xdF2,_xdF3,_xF4,_xdF5,_xF6,_xdF7,_xF8,_xdF9,_xFA,_xFB,_xFC,_xdFD,_xFE,_xdFF
optable_m_d
        DCD m_00,m_01,m_02,m_03,m_04,m_05,m_06,m_07,m_08,m_09,m_0A,m_0B,m_0C,m_0D,m_0E,m_0F
        DCD m_10,m_11,m_12,m_13,m_14,m_15,m_16,m_17,m_18,m_19,m_1A,m_1B,m_1C,m_1D,m_1E,m_1F
        DCD m_20,m_21,m_22,m_23,m_24,m_25,m_26,m_27,m_28,m_29,m_2A,m_2B,m_2C,m_2D,m_2E,m_2F
        DCD m_30,m_31,m_32,m_33,m_34,m_35,m_36,m_37,m_38,m_39,m_3A,m_3B,m_3C,m_3D,m_3E,m_3F
        DCD m_40,m_41,m_42,m_43,m_44,m_45,m_46,m_47,m_48,m_49,m_4A,m_4B,m_4C,m_4D,m_4E,m_4F
        DCD m_50,m_51,m_52,m_53,m_54,m_55,m_56,m_57,m_58,m_59,m_5A,m_5B,m_5C,m_5D,m_5E,m_5F
        DCD m_60,m_d61,m_62,m_d63,m_64,m_d65,m_66,m_d67,m_68,m_d69,m_6A,m_6B,m_6C,m_d6D,m_6E,m_d6F
        DCD m_70,m_d71,m_d72,m_d73,m_74,m_d75,m_76,m_d77,m_78,m_d79,m_7A,m_7B,m_7C,m_d7D,m_7E,m_d7F
        DCD m_80,m_81,m_82,m_83,m_84,m_85,m_86,m_87,m_88,m_89,m_8A,m_8B,m_8C,m_8D,m_8E,m_8F
        DCD m_90,m_91,m_92,m_93,m_94,m_95,m_96,m_97,m_98,m_99,m_9A,m_9B,m_9C,m_9D,m_9E,m_9F
        DCD m_A0,m_A1,m_A2,m_A3,m_A4,m_A5,m_A6,m_A7,m_A8,m_A9,m_AA,m_AB,m_AC,m_AD,m_AE,m_AF
        DCD m_B0,m_B1,m_B2,m_B3,m_B4,m_B5,m_B6,m_B7,m_B8,m_B9,m_BA,m_BB,m_BC,m_BD,m_BE,m_BF
        DCD m_C0,m_C1,m_C2,m_C3,m_C4,m_C5,m_C6,m_C7,m_C8,m_C9,m_CA,m_CB,m_CC,m_CD,m_CE,m_CF
        DCD m_D0,m_D1,m_D2,m_D3,m_D4,m_D5,m_D6,m_D7,m_D8,m_D9,m_DA,m_DB,m_DC,m_DD,m_DE,m_DF
        DCD m_E0,m_dE1,m_E2,m_dE3,m_E4,m_dE5,m_E6,m_dE7,m_E8,m_dE9,m_EA,m_EB,m_EC,m_dED,m_EE,m_dEF
        DCD m_F0,m_dF1,m_dF2,m_dF3,m_F4,m_dF5,m_F6,m_dF7,m_F8,m_dF9,m_FA,m_FB,m_FC,m_dFD,m_FE,m_dFF
optable_mxd
        DCD mx00,mx01,mx02,mx03,mx04,mx05,mx06,mx07,mx08,mx09,mx0A,mx0B,mx0C,mx0D,mx0E,mx0F
        DCD mx10,mx11,mx12,mx13,mx14,mx15,mx16,mx17,mx18,mx19,mx1A,mx1B,mx1C,mx1D,mx1E,mx1F
        DCD mx20,mx21,mx22,mx23,mx24,mx25,mx26,mx27,mx28,mx29,mx2A,mx2B,mx2C,mx2D,mx2E,mx2F
        DCD mx30,mx31,mx32,mx33,mx34,mx35,mx36,mx37,mx38,mx39,mx3A,mx3B,mx3C,mx3D,mx3E,mx3F
        DCD mx40,mx41,mx42,mx43,mx44,mx45,mx46,mx47,mx48,mx49,mx4A,mx4B,mx4C,mx4D,mx4E,mx4F
        DCD mx50,mx51,mx52,mx53,mx54,mx55,mx56,mx57,mx58,mx59,mx5A,mx5B,mx5C,mx5D,mx5E,mx5F
        DCD mx60,mxd61,mx62,mxd63,mx64,mxd65,mx66,mxd67,mx68,mxd69,mx6A,mx6B,mx6C,mxd6D,mx6E,mxd6F
        DCD mx70,mxd71,mxd72,mxd73,mx74,mxd75,mx76,mxd77,mx78,mxd79,mx7A,mx7B,mx7C,mxd7D,mx7E,mxd7F
        DCD mx80,mx81,mx82,mx83,mx84,mx85,mx86,mx87,mx88,mx89,mx8A,mx8B,mx8C,mx8D,mx8E,mx8F
        DCD mx90,mx91,mx92,mx93,mx94,mx95,mx96,mx97,mx98,mx99,mx9A,mx9B,mx9C,mx9D,mx9E,mx9F
        DCD mxA0,mxA1,mxA2,mxA3,mxA4,mxA5,mxA6,mxA7,mxA8,mxA9,mxAA,mxAB,mxAC,mxAD,mxAE,mxAF
        DCD mxB0,mxB1,mxB2,mxB3,mxB4,mxB5,mxB6,mxB7,mxB8,mxB9,mxBA,mxBB,mxBC,mxBD,mxBE,mxBF
        DCD mxC0,mxC1,mxC2,mxC3,mxC4,mxC5,mxC6,mxC7,mxC8,mxC9,mxCA,mxCB,mxCC,mxCD,mxCE,mxCF
        DCD mxD0,mxD1,mxD2,mxD3,mxD4,mxD5,mxD6,mxD7,mxD8,mxD9,mxDA,mxDB,mxDC,mxDD,mxDE,mxDF
        DCD mxE0,mxdE1,mxE2,mxdE3,mxE4,mxdE5,mxE6,mxdE7,mxE8,mxdE9,mxEA,mxEB,mxEC,mxdED,mxEE,mxdEF
        DCD mxF0,mxdF1,mxdF2,mxdF3,mxF4,mxdF5,mxF6,mxdF7,mxF8,mxdF9,mxFA,mxFB,mxFC,mxdFD,mxFE,mxdFF

;---------------------------------------------------------------
__dE9
_xdE9
	opSBCD set_mem16, addrIMM
__dE5
_xdE5
	opSBCD set_mem16, addrDIR
__dF5
_xdF5
	opSBCD set_mem16, addrDX
__dF2
_xdF2
	opSBCD set_mem16, addrDI
__dE1
_xdE1
	opSBCD set_mem16, addrDIX
__dF1
_xdF1
	opSBCD set_mem16, addrDIY
__dE7
_xdE7
	opSBCD set_mem16, addrDIL
__dF7
_xdF7
	opSBCD set_mem16, addrDIYL
__dED
_xdED
	opSBCD set_mem16, addrABS
__dFD
_xdFD
	opSBCD set_mem16, addrAX
__dF9
_xdF9
	opSBCD set_mem16, addrAY
__dEF
_xdEF
	opSBCD set_mem16, addrABSL
__dFF
_xdFF
	opSBCD set_mem16, addrAXL
;---------------------------------------------------------------
m_dE9
mxdE9
	opSBCD set_mem8, addrIMM
m_dE5
mxdE5
	opSBCD set_mem8, addrDIR
m_dF5
mxdF5
	opSBCD set_mem8, addrDX
m_dF2
mxdF2
	opSBCD set_mem8, addrDI
m_dE1
mxdE1
	opSBCD set_mem8, addrDIX
m_dF1
mxdF1
	opSBCD set_mem8, addrDIY
m_dE7
mxdE7
	opSBCD set_mem8, addrDIL
m_dF7
mxdF7
	opSBCD set_mem8, addrDIYL
m_dED
mxdED
	opSBCD set_mem8, addrABS
m_dFD
mxdFD
	opSBCD set_mem8, addrAX
m_dF9
mxdF9
	opSBCD set_mem8, addrAY
m_dEF
mxdEF
	opSBCD set_mem8, addrABSL
m_dFF
mxdFF
	opSBCD set_mem8, addrAXL
;---------------------------------------------------------------
__d69
_xd69
	opADCD set_mem16, addrIMM
__d65
_xd65
	opADCD set_mem16, addrDIR
__d75
_xd75
	opADCD set_mem16, addrDX
__d72
_xd72
	opADCD set_mem16, addrDI
__d61
_xd61
	opADCD set_mem16, addrDIX
__d71
_xd71
	opADCD set_mem16, addrDIY
__d67
_xd67
	opADCD set_mem16, addrDIL
__d77
_xd77
	opADCD set_mem16, addrDIYL
__d6D
_xd6D
	opADCD set_mem16, addrABS
__d7D
_xd7D
	opADCD set_mem16, addrAX
__d79
_xd79
	opADCD set_mem16, addrAY
__d6F
_xd6F
	opADCD set_mem16, addrABSL
__d7F
_xd7F
	opADCD set_mem16, addrAXL
;---------------------------------------------------------------
m_d69
mxd69
	opADCD set_mem8, addrIMM
m_d65
mxd65
	opADCD set_mem8, addrDIR
m_d75
mxd75
	opADCD set_mem8, addrDX
m_d72
mxd72
	opADCD set_mem8, addrDI
m_d61
mxd61
	opADCD set_mem8, addrDIX
m_d71
mxd71
	opADCD set_mem8, addrDIY
m_d67
mxd67
	opADCD set_mem8, addrDIL
m_d77
mxd77
	opADCD set_mem8, addrDIYL
m_d6D
mxd6D
	opADCD set_mem8, addrABS
m_d7D
mxd7D
	opADCD set_mem8, addrAX
m_d79
mxd79
	opADCD set_mem8, addrAY
m_d6F
mxd6F
	opADCD set_mem8, addrABSL
m_d7F
mxd7F
	opADCD set_mem8, addrAXL
;---------------------------------------------------------------
__dE3	;SBC $nn,s
_xdE3
;	opSBCD set_mem16, addrDS
m_dE3
mxdE3
;	opSBCD set_mem8, addrDS
;---------------------------------------------------------------
__dF3	;SBC ($nn,s),y
_xdF3
;	opSBCD set_mem16, addrDSY
m_dF3
mxdF3
;	opSBCD set_mem8, addrDSY
;---------------------------------------------------------------
__d63	;ADC $nn,s
_xd63
;	opADCD set_mem16, addrDS
m_d63
mxd63
;	opADCD set_mem8, addrDS
;---------------------------------------------------------------
__d73	;ADC ($nn,s),y
_xd73
;	opADCD set_mem16, addrDSY
m_d73
mxd73
;	opADCD set_mem8, addrDSY
;---------------------------------------------------------------
ErrorMsg
	DCB "Error",0
	ALIGN
;----------------------------------------------------------------------------
debugstep
run
	ldr pc,=run_iwram
;---------------------------------------
reset_cpu
	stmfd sp!,{lr}

	ldr snes_memtbl,=readmem8_tbl
	mov snes_memtbl,snes_memtbl,lsr#2

	ldr r12,=SNES_RESET_VECTOR
	adr lr,%F0
	ldr pc,=rom00_R16		;bl rom00_R16
0	add r12,r1,r0,lsl#8
	translatePC

	ldr r12,=snes_b
	str r1,snes_pc_offset_r12

	mov snes_a,#0
	mov snes_x,#0
	mov snes_y,#0
	mov snes_nz,#0
	mov snes_d,#0
	str snes_a,snes_b_r12
	str snes_a,snes_pb_r12
	ldr r0,=0x1fd
	str r0,snes_s_r12
	mov r0,#M_FLAG+X_FLAG+I_FLAG
	str r0,snes_mxdi_r12
	load_snes_optable
		
	mov snes_cycles,#CYCLES_E_FLAG		;C=0, E=1, V=0, cycles=0

	ldr r0,=snes_state
	stmia r0,{r3-r11}
	ldmfd sp!,{pc}
;------------------------------------------
 [ DEBUG
copy_65816_state		;copy state to r0
		MAP 0,r0
a_reg 		# 4
x_reg 		# 4
y_reg 		# 4
d_reg 		# 4
s_reg 		# 4
pc_reg 		# 4
flags_reg 	# 4
cycle		# 4
nextop		# 8
romoffset	# 4

	stmfd sp!,{r4-r11}

	ldr r12,=snes_state
	ldmia r12,{r3-r11}
	ldr r12,=snes_b

	ldr r1,snes_s_r12
	str r1,s_reg

	mov r1,snes_cycles,asr#CYCLESHIFT
	rsb r1,r1,#0
	str r1,cycle

	ldr r1,snes_mxdi_r12
	mov snes_x,snes_x,ror#16
	mov snes_y,snes_y,ror#16
	str snes_x,x_reg
	str snes_y,y_reg
	tst r1,#M_FLAG
	moveq snes_a,snes_a,ror#16
	movne snes_a,snes_a,ror#24
	ldrne snes_x,snes_b_r12
	orrne snes_a,snes_a,snes_x,lsr#16
	str snes_a,a_reg
	str snes_d,d_reg

	tst snes_cycles,#CYCLES_E_FLAG
	orrne r1,r1,#0x100
	tst snes_cycles,#CYCLES_V_FLAG
	orrne r1,r1,#V_FLAG
	tst snes_cycles,#C_FLAG
	orrne r1,r1,#C_FLAG
	tst snes_nz,#0x28000
	orrne r1,r1,#N_FLAG
	movs snes_nz,snes_nz,lsl#16
	orreq r1,r1,#Z_FLAG
	str r1,flags_reg

	ldr r1,snes_pc_offset_r12
	sub r1,snes_pc,r1
	str r1,pc_reg

	ldr r1,=snes_rom_ptr
	ldr r1,[r1]
	sub r1,snes_pc,r1
	str r1,romoffset

	ldrb r1,[snes_pc]
	ldrb r2,[snes_pc,#1]
	ldrb r3,[snes_pc,#2]
	ldrb r4,[snes_pc,#3]
	strb r1,nextop
	strb r2,nextop+1
	strb r3,nextop+2
	strb r4,nextop+3
	ldrb r1,[snes_pc,#4]
	ldrb r2,[snes_pc,#5]
	ldrb r3,[snes_pc,#6]
	ldrb r4,[snes_pc,#7]
	strb r1,nextop+4
	strb r2,nextop+5
	strb r3,nextop+6
	strb r4,nextop+7

	ldmfd sp!,{r4-r11}
	bx lr
 ] ;DEBUG
 ] ; :LNOT:SNES9X ---------------------------------
 [ SNES9X
	AREA rom, CODE, READONLY
	EXPORT hardreset
	IMPORT reset_cpu
 ]
hardreset				;called from C:  r0=rom ptr, r1=flags
	stmfd sp!,{r4-r11,lr}

	bl resetmem
	bl reset_io
	bl reset_spc
	bl reset_cpu

	ldmfd sp!,{r4-r11,lr}
	bx lr
;----------------------------------------------------------
	END

