#ifndef __ZOMBIE_H__
#define __ZOMBIE_H__

#include <windows.h>

#define	ASK 0
#define TELL 1

#define INPUT 0
#define OUTPUT 1

#define CPU_IRQ_CALLBACK		0x000
#define CPU_IO_HANDLER			0x001
#define CPU_CYCLE_COUNT			0x002
#define CPU_REG_PC				0x003
#define CPU_REG_SP				0x004
#define CPU_BREAKPOINT			0x005
#define CPU_SPEED				0x006
#define CPU_INPB_CALLBACK		0x007
#define CPU_OUTPB_CALLBACK		0x008
#define CPU_CYCLE_SCALING		0x009
#define CPU_REG					0x00A
#define CPU_CYCLE_PTR			0x00B

#define MMU_READ_BYTE_CALLBACK	0x100
#define MMU_READ_WORD_CALLBACK	0x101
#define MMU_WRITE_BYTE_CALLBACK	0x102
#define MMU_WRITE_WORD_CALLBACK	0x103
#define MMU_TRANSLATE_ADDRESS_CALLBACK	0x104
#define MMU_MAP_PORT			0x105
#define MMU_READ_DWORD_CALLBACK	0x106
#define MMU_WRITE_DWORD_CALLBACK 0x107
#define MMU_MAP_MEMORY			0x108
#define MMU_GET_CALLBACK		0x109
#define MMU_IRQ_CALLBACK		0x10A
#define MMU_TIMER_OVERFLOW		0x10B

#define GPU_CURRENT_SCANLINE	0x200
#define GPU_SCREEN_WIDTH		0x201
#define GPU_SCREEN_HEIGHT		0x202
#define GPU_FRAME_COMPLETED		0x203
#define GPU_VBLANK_LINES		0x204
#define GPU_HBLANK_PIXELS		0x205
#define GPU_MEMORY				0x206
#define GPU_NUMBER_COLORS		0x207
#define GPU_PALETTE				0x208
#define GPU_VBLANK_ACTION		0x209
#define GPU_HBLANK_ACTION		0x20A
#define GPU_SIZE_MULTIPLIER		0x20B

#define APU_WRITE_CALLBACK		0x300

#define	ZOMBIE_WINDOW_HANDLE	0x500
#define ZOMBIE_ROM_BASE			0x501
#define ZOMBIE_KEYSTATE			0x502
#define ZOMBIE_ROM_SIZE			0x503
#define ZOMBIE_EVENT			0x504

#define PLUGIN_NAME				0x600
#define LAST_ERROR				0x601
#define	PLUGIN_SETTING			0x602


#define	EV_TIMER_OVERFLOW		6


typedef struct
{
	char *data;
	BITMAPINFOHEADER bih;
	RGBQUAD colors[256];
} palette_dib;


typedef void(__stdcall *cpu_irq_callback)(int);
typedef void(__stdcall *cpu_set_io_handler_callback)(int,int,void*);
typedef int(__stdcall *cpu_inpb_callback)(int);
typedef void(__stdcall *cpu_outpb_callback)(int,int);
typedef short int(__stdcall *mmu_read_word_callback)(int);
typedef int(__stdcall *mmu_get_callback)(int);
typedef void(__stdcall *apu_write_callback)(unsigned char,unsigned char);
typedef void*(__stdcall *zombie_callback)(int,int,void*,void*);

#endif
