; An ARM7TDMI emulator
; /Mic, 2004


.686p
.model flat,stdcall
option casemap:none


include \masm32\include\windows.inc
include \masm32\include\kernel32.inc
include \masm32\include\user32.inc

includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\user32.lib

wsprintfA PROTO C :DWORD, :VARARG
wsprintf equ <wsprintfA>

.data

	; Message enumerators
	CPU_IRQ_CALLBACK		equ 000h
	CPU_SET_IO_CALLBACK		equ 001h
	CPU_IO_HANDLER			equ 001h
	CPU_CYCLE_COUNT			equ 002h
	CPU_REG_PC			equ 003h
	CPU_REG_SP			equ 004h
	CPU_BREAKPOINT			equ 005h
	CPU_SPEED			equ 006h
	CPU_INPB_CALLBACK		equ 007h
	CPU_OUTPB_CALLBACK		equ 008h
	CPU_CYCLE_SCALING		equ 009h
	CPU_REG				equ 00Ah
	CPU_CYCLE_PTR			equ 00Bh
	CPU_ENABLE_IRQ			equ 00Ch
	
	MMU_READ_BYTE_CALLBACK		equ 100h
	MMU_READ_WORD_CALLBACK		equ 101h
	MMU_WRITE_BYTE_CALLBACK		equ 102h
	MMU_WRITE_WORD_CALLBACK		equ 103h
	MMU_TRANSLATE_ADDRESS_CALLBACK	equ 104h
	MMU_READ_DWORD_CALLBACK		equ 106h
	MMU_WRITE_DWORD_CALLBACK	equ 107h

	GPU_CURRENT_SCANLINE		equ 200h
	GPU_SCREEN_WIDTH		equ 201h
	GPU_SCREEN_HEIGHT		equ 202h
	GPU_FRAME_COMPLETED		equ 203h
	GPU_SCREEN_PITCH		equ 204h
	GPU_MEMORY			equ 206h
	
	ZOMBIE_WINDOW_HANDLE		equ 500h

	PLUGIN_NAME			equ 600h
	LAST_ERROR			equ 601h
	PLUGIN_SETTING			equ 602h

;###############################################################################################

	INPUT		equ 0
	OUTPUT		equ 1

	; Communication direction
	ASK		equ 0
	TELL		equ 1

;###############################################################################################


	USE_VRAM_SPEEDHACK		equ 0
	
	LDR_CYCLES			equ 3
	STR_CYCLES			equ 2
	

	CYCLE_MULTIPLIER		equ 1
	

;###############################################################################################

	; Function pointer prototypes
	_1ARGS_PROTO	typedef PROTO :DWORD
	_2ARGS_PROTO	typedef PROTO :DWORD,:DWORD
	_4ARGS_PROTO	typedef PROTO :DWORD,:DWORD,:DWORD,:DWORD
	_1ARGS		typedef ptr _1ARGS_PROTO
	_2ARGS		typedef ptr _2ARGS_PROTO
	_4ARGS		typedef ptr _4ARGS_PROTO

	cpu_inpb	PROTO :DWORD
	cpu_outpb	PROTO :DWORD,:DWORD


	cpuName		db "ARM7TDMI",0
	
	Overflow	db 0
	Carry		db 0
	Zero		db 0
	Negative	db 0

	align 4
	; Flags		   Z C N V 	
	flags		dd 1,1,1,1,1,0,0,1
	flags_usr	dd 1,1,1,1,1,0,0,1
	flags_irq	dd 1,1,1,1,1,0,0,1
	
	cycle		dd 0
	breakpoint	dd 0
	speed		dd 1000000h	; 16.77 MHz
	halted 		dd 0
	irqEnabled	dd 1
	shifterC	dd 0
	
	frequencies	dd 1000000h,
			   1800000h,
			   2000000h,
			   3000000h,
			   4000000h,
			   5000000h
			   
	szFreq0 	db "16.77 MHz",0
	szFreq1 	db "25.16 MHz",0
	szFreq2 	db "33.55 MHz",0
	szFreq3 	db "50.33 MHz",0
	szFreq4 	db "67.10 MHz",0
	szFreq5 	db "83.88 MHz",0
	freqSel 	dd 0

	;szCMOVError	db "This program requires CMOV instructions to run",0
	
	; Debug messages
	szBranch 	db "Branch instruction",13,10,0
	szTrue 		db "true",13,10,0
	szBuffer 	db 64 dup (0)
	szFormat 	db "Read %08x at pc=%08x",13,10,0
	szFormat2 	db "Instruction type %d at %08x",13,10,0
	szFormat3 	db "Writing %04x at %08x",13,10,0
	szFormat4 	db "Branching with link from %08x to %08x",13,10,0
	szFormat5 	db "mov pc,lr (%08x)",13,10,0
	szFormat6 	db "stmfd %08x",13,10,0
	szFormat7 	db "ldmfd %08x",13,10,0
	szFormat8 	db "ldr r%d,=%d",13,10,0
	szFormat9 	db "MUL r%d,%08x,%08x",13,10,0
	szFormat11 	db "%08x, %08x, %08x, %08x, %08x, %08x",13,10,0
	szFormat19 	db "r15 = %08x",13,10,0
	szFormat20 	db "Rs,Rd = %08x, %08x",13,10,0
	szFormat21 	db "ARM: %08x, %08x, %08x, %08x, %08x, %08x, %08x, %08x, %08x, %08x",13,10,0
	szFormat22 	db "TMB: %08x, %08x, %08x, %08x, %08x, %08x, %08x, %08x, %08x, %08x, %08x, %08x, %08x, %08x, %08x, %08x, %08x, %08x",13,10,0
	szFormat25	db "IRQ at 0x%08x with IF=0x%04x",13,10,0
	szFormat26	db "IRQ processing finished at 0x%08x. Jumping back to 0x%08x",13,10,0
	szFormat27	db "Branch back to ARM state from 0x%08x",13,10,0
	guard 		dd 0
	
	
.data?
align 8
	; General registers
	r0		dd ?
	r1		dd ?
	r2		dd ?
	r3		dd ?
	r4		dd ?
	r5		dd ?
	r6		dd ?
	r7		dd ?
	r8		dd ?
	r9		dd ?
	r10		dd ?
	r11		dd ?
	r12		dd ?
	r13		dd ?	; SP
	r14		dd ?	; LR
	r15		dd ?	; PC
	r16		dd ?	; CPSR
	r17		dd ?	; SPSR

	r13_usr		dd ?
	r14_usr		dd ?
	spsr_usr	dd ?
	
	r13_irq		dd ?
	r14_irq		dd ?
	spsr_irq	dd ?
	
	hInst		dd ?
	hout		dd ?
	dummy 		dd ?
	lastPC 		dd ?
	physaddr 	dd ?
	flagsd		dd ?
	lastCyc		dd ?
	IWRAM 		dd ?
	VRAM		dd ?
	cb_execute 	dd ?
	cb_execute_bi	dd ?	; The execute callback before an IRQ (for Thumb restoration)
	hwnd 		dd ?
	irq_cb_stack	dd 64 DUP(?)
	irq_cb_stack_ptr dd ?
	;timer		dd 0,0,0,0
	zombie		_4ARGS ?
	mmu_read_byte 	_1ARGS ?
	mmu_read_word 	_1ARGS ?
	mmu_read_dword 	_1ARGS ?
	mmu_write_byte 	_2ARGS ?
	mmu_write_word 	_2ARGS ?
	mmu_write_dword _2ARGS ?
	mmu_get 	_1ARGS ?
	mmu_translate_address _1ARGS ?
	lpszError	dd ?
	
.code


ADD_CYCLES MACRO num
	if num EQ 1
		inc dword ptr cycle
	else
		add cycle,num*CYCLE_MULTIPLIER
	endif
	;sub dword ptr [timer+00h],num*CYCLE_MULTIPLIER
	;sub dword ptr [timer+04h],num*CYCLE_MULTIPLIER
	;sub dword ptr [timer+08h],num*CYCLE_MULTIPLIER
	;sub dword ptr [timer+0Ch],num*CYCLE_MULTIPLIER
ENDM


; Cause a division by zero. Used for debugging purposes
DIV0 MACRO
	mov edi,r15
	xor ebp,ebp
	div ebp
ENDM


PUSH_FLAGS MACRO
	pushfd
	pop dword ptr [flagsd]
ENDM

POP_FLAGS MACRO
	push dword ptr [flagsd]
	popfd
ENDM


SHIFT_OPERAND MACRO reg
	mov ebp,60h
	and ebp,eax		; Get shift type
		
	.if ebp == 0
		shl reg,cl
	.elseif ebp == 20h
		shr reg,cl
	.elseif ebp == 40h
		sar reg,cl
	.else
		ror reg,cl
	.endif
ENDM


SHIFT_OPERAND_ZERO MACRO reg
	mov ebp,60h
	and ebp,eax		; Get shift type
		
	.if ebp == 0
		mov ebp,[flags+4]
		mov [shifterC],ebp
	.elseif ebp == 20h
		shr reg,31
		xor reg,1
		mov [shifterC],reg
		xor reg,reg
	.elseif ebp == 40h
		sar reg,31
		sete byte ptr [shifterC]
	.elseif ebp == 60h
		cmp [flags+4],1		; Set x86 carry if ARM7 carry is set
		rcr reg,1		; Rotate through carry
		UPDATE_C
	.endif
ENDM


SHIFT_OPERAND_32 MACRO reg
	mov ebp,60h
	and ebp,eax		; Get shift type
		
	.if ebp == 0
		xor reg,1
		mov [shifterC],reg
		xor reg,reg
	.elseif ebp == 20h
		shr reg,31
		xor reg,1
		mov [shifterC],reg
		xor reg,reg
	.elseif ebp == 40h
		sar reg,31
		sete byte ptr [shifterC]
	.elseif ebp == 60h
		test reg,80000000h
		sete byte ptr [shifterC]
	.endif
ENDM


SHIFT_OPERAND_GT32 MACRO reg
	mov ebp,60h
	and ebp,eax		; Get shift type
		
	.if ebp < 40h
		mov [shifterC],1
		xor reg,reg
	.elseif ebp == 40h
		sar reg,31
		sete byte ptr [shifterC]
	.elseif ebp == 60h
		and ecx,31
		ror reg,cl
		setnc byte ptr [shifterC]
	.endif
ENDM


RDWORD MACRO adr
	;mov edi,adr
	;and edi,0F000000h
	;.if edi == 03000000h
	;	and adr,07FFFh
	;	add adr,IWRAM
	;	mov eax,[adr]
	;.else
		push edx
		invoke mmu_read_dword,adr
		pop edx
	;.endif
ENDM



RDBYTE MACRO adr
	;mov edi,adr
	;and edi,0F000000h
	;.if edi == 03000000h
	;	and adr,07FFFh
	;	add adr,IWRAM
	;	mov al,[adr]
	;.else
		push edx
		invoke mmu_read_byte,adr
		pop edx
	;.endif
ENDM


WRBYTE MACRO adr,r8,r32
	;mov edi,adr
	;and edi,0F000000h
	;.if edi == 03000000h
	;	and adr,0FFFFFFh
	;	add adr,IWRAM
	;	mov [adr],r8
	;.else
		invoke mmu_write_byte,adr,r32
	;.endif
ENDM


WRHWORD MACRO adr,r16,r32
	IF USE_VRAM_SPEEDHACK EQ 1
		mov edi,adr
		and edi,0F000000h
		.if edi == 06000000h
			and adr,17FFFh
			add adr,VRAM
			mov [adr],r16
		.else
			invoke mmu_write_word,adr,r32
		.endif
	ELSE
		invoke mmu_write_word,adr,r32
	ENDIF
ENDM



; Update all flags
; Destroys eax, ebx, edx
UPDATE_FLAGS MACRO 
	setnz byte ptr [flags]
	setnc ah
	setns byte ptr [flags+8]
	setno byte ptr [flags+12]

	setz dl
	setl  byte ptr [flags+20]
	setle byte ptr [flags+24] 
	or dl,ah
	mov byte ptr [flags+4],ah
	mov byte ptr [flags+16],dl
ENDM


; Update all flags (after a sub, sbc, rsb, rsc, cmp)
; Destroys eax, ebx, edx
UPDATE_FLAGS_SUB MACRO 
	setnz byte ptr [flags]
	setc byte ptr [flags+4]
	setns byte ptr [flags+8]
	setno byte ptr [flags+12]

	setbe byte ptr [flags+16]
	setl  byte ptr [flags+20]
	setle byte ptr [flags+24] 
ENDM


UPDATE_C_FORCE MACRO
	setnc byte ptr [flags+4]
ENDM


UPDATE_C MACRO
	;setnc byte ptr [flags+1]
	setnc byte ptr [shifterC]
ENDM


; Only update N, Z and derived flags like HI, BE etc
; Destroys eax, edx
UPDATE_NZ MACRO 
	setnz al
	setns dh
	mov byte ptr [flags],al		; Z
	mov byte ptr [flags+8],dh	; N 

	setz dl
	xor dh,byte ptr [flags+12]	; dh = N not equal V
	or dl,byte ptr [flags+4]	; dl = Z set or C clear
	xor al,1			; al = Z set
	mov byte ptr [flags+16],dl
	or al,dh			; al = Z set OR (N not equal V) 
	mov byte ptr [flags+20],dh
	mov byte ptr [flags+24],al
ENDM

UPDATE_NZ_MULL MACRO 
	test edx,80000000h
	setz dh
	or eax,edx
	setnz al
	mov byte ptr [flags+8],dh	; N 
	mov byte ptr [flags],al		; Z

	setz dl
	xor dh,byte ptr [flags+12]	; dh = N not equal V
	or dl,byte ptr [flags+4]	; dl = Z set or C clear
	xor al,1			; al = Z set
	mov byte ptr [flags+16],dl
	or al,dh			; al = Z set OR (N not equal V) 
	mov byte ptr [flags+20],dh
	mov byte ptr [flags+24],al
ENDM



LibMain PROC hInstDLL:DWORD, reason:DWORD, unused:DWORD

        .if reason == 1		;DLL_PROCESS_ATTACH
        	mov eax,hInstDLL
        	mov hInst,eax
		mov eax,TRUE
		mov cb_execute,OFFSET cpu_execute_until_arm
		ret

        .elseif reason == 0	;DLL_PROCESS_DETACH
        .elseif reason == 2	;DLL_THREAD_ATTACH
        .elseif reason == 3	;DLL_THREAD_DETACH
        .endif

        mov eax,FALSE
        ret
LibMain ENDP


inpb_null PROC
	ret
inpb_null ENDP
.data
inpb_handlers dd 256 DUP(OFFSET inpb_null)
.code

outpb_null PROC dat:DWORD
	ret
outpb_null ENDP
.data
outpb_handlers dd 256 DUP(OFFSET outpb_null)
.code	




; ARM dataproc ops
align 8

op_and:
	shr eax,12		; Get Rd
	and esi,edi		; Rs AND Op2
	and eax,0Fh
	ADD_CYCLES 1
	mov [r0+eax*4],esi	; Write result
	.if ebp == r15
		mov physaddr,-1
	.endif
	ret
op_ands:
	mov ebp,eax
	and esi,edi
	UPDATE_NZ
	shr ebp,12
	mov eax,[shifterC]
	and ebp,0Fh
	mov [flags+4],eax
	ADD_CYCLES 1
	mov [r0+ebp*4],esi
	ret
op_eor:
	shr eax,12
	xor esi,edi		; Rs XOR Op2
	and eax,0Fh
	ADD_CYCLES 1
	mov [r0+eax*4],esi
	.if ebp == r15
		mov physaddr,-1
	.endif
	ret
op_eors:
	mov ebp,eax
	xor esi,edi
	UPDATE_NZ
	shr ebp,12
	mov eax,[shifterC]
	and ebp,0Fh
	mov [flags+4],eax
	mov [r0+ebp*4],esi
	ADD_CYCLES 1
	ret
op_sub:
	shr eax,12
	sub esi,edi		; Rs - Op2
	and eax,0Fh
	ADD_CYCLES 1
	mov [r0+eax*4],esi
	.if eax == 15
		mov physaddr,-1
	.endif
	ret
op_subs:
	mov ebp,eax
	sub esi,edi
	UPDATE_FLAGS_SUB
	shr ebp,12
	ADD_CYCLES 1
	and ebp,0Fh
	mov [r0+ebp*4],esi
	ret

op_subs_irq:
	mov ebp,eax
	sub esi,edi
	UPDATE_FLAGS_SUB
	shr ebp,12
	ADD_CYCLES 1
	and ebp,0Fh
	.if ebp == 15
		sub esi,4	
		mov [r0+ebp*4],esi

		mov eax,r13
		mov ebx,r14
		mov ecx,r13_usr
		mov edx,r14_usr

		mov r13_irq,eax
		mov r14_irq,ebx
		mov r13,ecx
		mov r14,edx

		mov dword ptr [subs_handler],offset op_subs
		mov ebp,esp
		mov esp,irq_cb_stack_ptr
		pop eax
		mov irq_cb_stack_ptr,esp
		mov esp,ebp
		mov physaddr,-1
		mov cb_execute,eax		
	.endif
	ret
	
op_rsb:
	shr eax,12
	sub edi,esi		; Op2 - Rs
	and eax,0Fh
	mov [r0+eax*4],edi
	ADD_CYCLES 1
	.if eax == 15
		mov physaddr,-1
	.endif
	ret
op_rsbs:
	mov ebp,eax
	sub edi,esi
	UPDATE_FLAGS_SUB
	shr ebp,12
	and ebp,0Fh
	mov [r0+ebp*4],edi
	ADD_CYCLES 1
	ret
op_add:
	shr eax,12
	add esi,edi		; Rs + Op2
	and eax,0Fh
	ADD_CYCLES 1
	mov [r0+eax*4],esi
	.if eax == 15
		mov physaddr,-1
	.endif
	ret
op_adds:
	mov ebp,eax
	add esi,edi
	UPDATE_FLAGS
	shr ebp,12
	ADD_CYCLES 1
	and ebp,0Fh
	mov [r0+ebp*4],esi
	.if ebp == r15
		mov physaddr,-1
	.endif
	ret
op_adc:
	shr eax,12
	cmp [flags+4],1	; Set x86 carry if ARM7 carry is set
	adc esi,edi
	and eax,0Fh
	mov [r0+eax*4],esi
	ADD_CYCLES 1
	.if ebp == r15
		mov physaddr,-1
	.endif
	ret
op_adcs:
	mov ebp,eax
	cmp [flags+4],1	; Set x86 carry if ARM7 carry is set
	adc esi,edi
	UPDATE_FLAGS
	shr ebp,12
	and ebp,0Fh
	mov [r0+ebp*4],esi
	ADD_CYCLES 1
	.if ebp == r15
		mov physaddr,-1
	.endif
	ret
op_sbc:
	shr eax,12
	cmp [flags+4],1	; Set x86 carry if ARM7 carry is set
	cmc
	sbb esi,edi
	and eax,0Fh
	mov [r0+eax*4],esi
	ADD_CYCLES 1
	.if ebp == r15
		mov physaddr,-1
	.endif
	ret
op_sbcs:
	mov ebp,eax
	cmp [flags+4],1	; Set x86 carry if ARM7 carry is set
	cmc
	sbb esi,edi
	UPDATE_FLAGS_SUB
	shr ebp,12
	and ebp,0Fh
	mov [r0+ebp*4],esi
	ADD_CYCLES 1
	ret
op_rsc:
	shr eax,12
	cmp [flags+4],1	; Set x86 carry is ARM7 carry is set
	cmc
	sbb edi,esi
	and eax,0Fh
	mov [r0+eax*4],edi
	ADD_CYCLES 1
	.if ebp == r15
		mov physaddr,-1
	.endif
	ret
op_rscs:
	mov ebp,eax
	cmp [flags+4],1	; Set x86 carry if ARM7 carry is set
	cmc
	sbb edi,esi
	UPDATE_FLAGS_SUB
	shr ebp,12
	and ebp,0Fh
	mov [r0+ebp*4],edi
	ADD_CYCLES 1
	ret

.data
szMRS1 db "MRS CPSR",13,10,0
.code
op_tst:
;	pusha
;	invoke WriteConsole,hout,ADDR szMRS1,10,ADDR dummy,NULL
;	popa
	ADD_CYCLES 1
	ret
	
op_tsts:
	and esi,edi
	UPDATE_NZ
	mov eax,[shifterC]
	ADD_CYCLES 1
	mov [flags+4],eax
	ret

.data
szMSR1 db "MSR CPSR",13,10,0
.code
op_teq:
;	pusha
;	invoke WriteConsole,hout,ADDR szMSR1,10,ADDR dummy,NULL
;	popa
	ADD_CYCLES 1
	ret
	
op_teqs:
	xor esi,edi
	UPDATE_NZ
	mov eax,[shifterC]
	ADD_CYCLES 1
	mov [flags+4],eax
	ret

.data
szMRS2 db "MRS SPSR",13,10,0
.code
op_cmp:
;	pusha
;	invoke WriteConsole,hout,ADDR szMRS2,10,ADDR dummy,NULL
;	popa
	ADD_CYCLES 1
	ret

op_cmps:
	cmp esi,edi
	UPDATE_FLAGS_SUB
	ADD_CYCLES 1
	ret

.data
szMSR2 db "MSR SPSR",13,10,0
.code
op_cmn:
;	pusha
;	invoke WriteConsole,hout,ADDR szMSR2,10,ADDR dummy,NULL
;	popa
	ADD_CYCLES 1
	ret

op_cmns:
	add esi,edi
	UPDATE_FLAGS
	ADD_CYCLES 1
	ret
op_orr:
	shr eax,12
	or esi,edi		; Rs OR Op2
	and eax,0Fh
	.if eax==15
		ADD_CYCLES 3
		mov physaddr,-1
		mov r15,esi
		ret
	.endif
	ADD_CYCLES 1
	mov [r0+eax*4],esi
	ret
op_orrs:
	mov ebp,eax
	or esi,edi
	UPDATE_NZ
	shr ebp,12
	mov eax,[shifterC]
	and ebp,0Fh
	mov [flags+4],eax
	ADD_CYCLES 1
	mov [r0+ebp*4],esi
	ret
op_mov:
	shr eax,12
	and eax,0Fh
	.if eax==15
		ADD_CYCLES 3
		;add edi,4
		mov physaddr,-1
		mov r15,edi
		ret
	.endif
	ADD_CYCLES 1
	mov [r0+eax*4],edi
	ret
	
op_movs:
	mov ebp,eax
	or edi,edi
	UPDATE_NZ
	shr ebp,12
	mov eax,[shifterC]
	and ebp,0Fh
	mov [flags+4],eax
	.if ebp==15
		ADD_CYCLES 2
		mov physaddr,-1
	.endif
	mov [r0+ebp*4],edi
	ADD_CYCLES 1
	ret
op_bic:
	not edi
	shr eax,12
	and esi,edi		; Rs AND (NOT Op2)
	and eax,0Fh
	mov [r0+eax*4],esi
	ADD_CYCLES 1
	ret
op_bics:
	not edi
	mov ebp,eax
	and esi,edi
	UPDATE_NZ
	mov eax,[shifterC]
	shr ebp,12
	ADD_CYCLES 1
	mov [flags+4],eax
	and ebp,0Fh
	mov [r0+ebp*4],esi
	ret
op_mvn:
	shr eax,12
	and eax,0Fh
	not edi 
	.if eax==15
		;cmp edi,[r0+56]
		;jz @@not_mvn_pc_lr
		;	add edi,4
		;@@not_mvn_pc_lr:
		mov physaddr,-1
	.endif
	mov [r0+eax*4],edi
	ADD_CYCLES 1
	ret
op_mvns:
	mov ebp,eax
	not edi 
	UPDATE_NZ
	shr ebp,12
	mov eax,[shifterC]
	and ebp,0Fh
	mov [flags+4],eax
	mov [r0+ebp*4],edi
	ADD_CYCLES 1
	ret
	

.data
align 16
; Jump table
data_proc_ops dd OFFSET op_and
	dd OFFSET op_ands	
	dd OFFSET op_eor
	dd OFFSET op_eors
	dd OFFSET op_sub
subs_handler dd OFFSET op_subs
	dd OFFSET op_rsb
	dd OFFSET op_rsbs
	dd OFFSET op_add
	dd OFFSET op_adds
	dd OFFSET op_adc
	dd OFFSET op_adcs
	dd OFFSET op_sbc
	dd OFFSET op_sbcs
	dd OFFSET op_rsc
	dd OFFSET op_rscs
	dd OFFSET op_tst
	dd OFFSET op_tsts
	dd OFFSET op_teq
	dd OFFSET op_teqs
	dd OFFSET op_cmp
	dd OFFSET op_cmps
	dd OFFSET op_cmn
	dd OFFSET op_cmns
	dd OFFSET op_orr
	dd OFFSET op_orrs
	dd OFFSET op_mov
	dd OFFSET op_movs
	dd OFFSET op_bic
	dd OFFSET op_bics
	dd OFFSET op_mvn
	dd OFFSET op_mvns
.code





hword_xfer_00:
	mov ebp,r15
	mov edi,eax
	sub ebp,8
	DIV0
	ret
hword_xfer_01:	; STRH Rd,[Rn],-disp
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov ebx,[r0+ebx*4]
	mov edx,[r0+edx*4]
	invoke mmu_write_word,ebx,edx
	ADD_CYCLES 4
	ret
	
hword_xfer_02:	; STRSB Rd,[Rn],-disp
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov ebx,[r0+ebx*4]
	mov edx,[r0+edx*4]
	invoke mmu_write_byte,ebx,edx
	ADD_CYCLES STR_CYCLES
	ret
	
hword_xfer_03:	; STRSH Rd,[Rn],-disp
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov ebx,[r0+ebx*4]
	mov edx,[r0+edx*4]
	invoke mmu_write_word,ebx,edx
	ADD_CYCLES STR_CYCLES
	ret
	
hword_xfer_04:
	DIV0
	ret
hword_xfer_05:	; LDRH Rd,[Rn],-disp
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov ebx,[r0+ebx*4]
	push edx
	invoke mmu_read_word,ebx
	pop edx
	mov [r0+edx*4],eax
	ADD_CYCLES 4
	ret
	
hword_xfer_06:	; LDRSB Rd,[Rn],-disp
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov ebx,[r0+ebx*4]
	push edx
	invoke mmu_read_byte,ebx
	movsx eax,al
	pop edx
	mov [r0+edx*4],eax
	ADD_CYCLES 4
	ret

hword_xfer_07:	; LDRSH Rd,[Rn],-disp
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov ebx,[r0+ebx*4]
	push edx
	invoke mmu_read_byte,ebx
	movsx eax,ax
	pop edx
	mov [r0+edx*4],eax
	ADD_CYCLES 4
	ret
	
hword_xfer_08:
	DIV0
	ret
hword_xfer_09:	; STRH Rd,[Rn],-disp!
	mov ebx,eax
	mov edx,eax
	xor esi,-1
	shr ebx,16
	shr edx,12
	inc esi
	and ebx,0Fh
	and edx,0Fh
	;push ebx
	mov eax,[r0+ebx*4]
	mov edx,[r0+edx*4]
	add esi,eax
	;push esi
	;invoke mmu_write_word,ebx,edx
	;pop esi
	;pop ebx
	mov [r0+ebx*4],esi
	WRHWORD eax,dx,edx
	ADD_CYCLES STR_CYCLES
	ret

hword_xfer_0A:	; STRSB Rd,[Rn],-disp!
	mov ebx,eax
	mov edx,eax
	xor esi,-1
	shr ebx,16
	shr edx,12
	inc esi
	and ebx,0Fh
	and edx,0Fh
	push ebx
	mov ebx,[r0+ebx*4]
	mov edx,[r0+edx*4]
	add esi,ebx
	push esi
	invoke mmu_write_byte,ebx,edx
	pop esi
	pop ebx
	mov [r0+ebx*4],esi
	ADD_CYCLES STR_CYCLES
	ret
	
hword_xfer_0B:	; STRSH Rd,[Rn],-disp!
	mov ebx,eax
	mov edx,eax
	xor esi,-1
	shr ebx,16
	shr edx,12
	inc esi
	and ebx,0Fh
	and edx,0Fh
	push ebx
	mov ebx,[r0+ebx*4]
	mov edx,[r0+edx*4]
	add esi,ebx
	push esi
	invoke mmu_write_word,ebx,edx
	pop esi
	pop ebx
	mov [r0+ebx*4],esi
	ADD_CYCLES 4
	ret
	
hword_xfer_0C:
	DIV0
	ret
hword_xfer_0D:	; LDRH Rd,[Rn],-disp!
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov eax,[r0+ebx*4]
	push edx
	sub [r0+ebx*4],esi
	invoke mmu_read_word,eax
	and eax,0FFFFh
	pop edx
	mov [r0+edx*4],eax
	ADD_CYCLES LDR_CYCLES
	ret
	
hword_xfer_0E:	; LDRSB Rd,[Rn],-disp!
	DIV0
	ret
hword_xfer_0F:	; LDRSH Rd,[Rn],-disp!
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov eax,[r0+ebx*4]
	push edx
	sub [r0+ebx*4],esi
	invoke mmu_read_word,eax
	movsx eax,ax
	pop edx
	mov [r0+edx*4],eax
	ADD_CYCLES LDR_CYCLES
	ret
	
hword_xfer_10:
	DIV0
	ret
hword_xfer_11:	; STRH Rd,[Rn],+disp
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov ebx,[r0+ebx*4]
	add r15,4
	mov edx,[r0+edx*4]
	invoke mmu_write_word,ebx,edx
	ADD_CYCLES STR_CYCLES
	sub r15,4
	ret

hword_xfer_12:
	DIV0
	ret
hword_xfer_13:
	DIV0
	ret
hword_xfer_14:
	DIV0
	ret
hword_xfer_15:	; LDRH Rd,[Rn],+disp
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov ebx,[r0+ebx*4]
	push edx
	invoke mmu_read_word,ebx
	and eax,0FFFFh
	pop edx
	mov [r0+edx*4],eax
	ADD_CYCLES LDR_CYCLES
	ret

hword_xfer_16:
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov ebx,[r0+ebx*4]
	push edx
	invoke mmu_read_byte,ebx
	movsx eax,al
	pop edx
	mov [r0+edx*4],eax
	ADD_CYCLES LDR_CYCLES
	ret
hword_xfer_17:	; LDRSH Rd,[Rn],+disp
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov ebx,[r0+ebx*4]
	push edx
	invoke mmu_read_word,ebx
	movsx eax,ax
	pop edx
	mov [r0+edx*4],eax
	ADD_CYCLES LDR_CYCLES
	ret
hword_xfer_18:
	DIV0
	ret
hword_xfer_19:	; STRH Rd,[Rn],+disp!
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	;push ebx
	mov eax,[r0+ebx*4]
	add r15,4
	mov edx,[r0+edx*4]
	add esi,eax
	;push esi
	;invoke mmu_write_word,ebx,edx
	;pop esi
	;pop ebx
	mov [r0+ebx*4],esi
	WRHWORD eax,dx,edx
	ADD_CYCLES STR_CYCLES
	sub r15,4
	ret
	
hword_xfer_1A:
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	push ebx
	mov ebx,[r0+ebx*4]
	mov edx,[r0+edx*4]
	add esi,ebx
	push esi
	invoke mmu_write_byte,ebx,edx
	pop esi
	pop ebx
	mov [r0+ebx*4],esi
	ADD_CYCLES STR_CYCLES
	ret
hword_xfer_1B:
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	push ebx
	mov ebx,[r0+ebx*4]
	add r15,4
	mov edx,[r0+edx*4]
	add esi,ebx
	push esi
	invoke mmu_write_word,ebx,edx
	pop esi
	pop ebx
	mov [r0+ebx*4],esi
	ADD_CYCLES STR_CYCLES
	sub r15,4
	ret
hword_xfer_1C:
	DIV0
	ret
hword_xfer_1D:	; LDRH Rd,[Rn],+disp!
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov eax,[r0+ebx*4]
	push edx
	add [r0+ebx*4],esi
	invoke mmu_read_word,eax
	and eax,0FFFFh
	pop edx
	mov [r0+edx*4],eax
	ADD_CYCLES LDR_CYCLES
	ret

hword_xfer_1E:	; LDRSB Rd,[Rn],+disp!
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov eax,[r0+ebx*4]
	push edx
	add [r0+ebx*4],esi
	invoke mmu_read_byte,eax
	movsx eax,al
	pop edx
	mov [r0+edx*4],eax
	ADD_CYCLES LDR_CYCLES
	ret
hword_xfer_1F:
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov eax,[r0+ebx*4]
	push edx
	add [r0+ebx*4],esi
	invoke mmu_read_word,eax
	movsx eax,ax
	pop edx
	mov [r0+edx*4],eax
	ADD_CYCLES LDR_CYCLES
	ret
hword_xfer_20:
	DIV0
	ret
hword_xfer_21:		; STRH Rd,[Rn,-disp]
	mov ebx,eax
	neg esi
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	add r15,4
	and edx,0Fh
	add esi,[r0+ebx*4]
	mov edx,[r0+edx*4]
	;invoke mmu_write_word,esi,edx
	WRHWORD esi,dx,edx
	ADD_CYCLES STR_CYCLES
	sub r15,4
	ret
hword_xfer_22:	; STRSB Rd,[Rn,-disp]
	mov ebx,eax
	neg esi
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	add esi,[r0+ebx*4]
	mov edx,[r0+edx*4]
	invoke mmu_write_byte,esi,edx
	ADD_CYCLES STR_CYCLES
	ret
hword_xfer_23:	; STRSH Rd,[Rn,-disp]	
	mov ebx,eax
	neg esi
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	add esi,[r0+ebx*4]
	mov edx,[r0+edx*4]
	;invoke mmu_write_word,esi,edx
	WRHWORD esi,dx,edx
	ADD_CYCLES STR_CYCLES
	ret
hword_xfer_24:
	DIV0
	ret
hword_xfer_25:	; LDRH Rd,[Rn,-disp]
	mov ebx,eax
	neg esi
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	add esi,[r0+ebx*4]
	push edx
	invoke mmu_read_word,esi
	and eax,0FFFFh
	pop edx
	mov [r0+edx*4],eax
	ADD_CYCLES LDR_CYCLES
	ret
	
hword_xfer_26:	; LDRSB Rd,[Rn,-disp]
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	neg esi
	mov ebx,[r0+ebx*4]
	add esi,ebx
	push edx
	invoke mmu_read_byte,esi
	movsx eax,al
	pop edx
	mov [r0+edx*4],eax
	ADD_CYCLES LDR_CYCLES
	ret
	
hword_xfer_27:	; LDRSH Rd,[Rn,-disp]
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	neg esi
	add esi,[r0+ebx*4]
	push edx
	invoke mmu_read_word,esi
	movsx eax,ax
	pop edx
	mov [r0+edx*4],eax
	ADD_CYCLES LDR_CYCLES
	ret

hword_xfer_28:	
	DIV0
	ret
hword_xfer_29:	; STRH Rd,[Rn,-disp]!	
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	neg esi
	and edx,0Fh
	add esi,[r0+ebx*4]
	add r15,4
	mov edx,[r0+edx*4]
	mov [r0+ebx*4],esi
	;invoke mmu_write_word,esi,edx
	WRHWORD esi,dx,edx
	ADD_CYCLES STR_CYCLES
	sub r15,4
	ret
	
hword_xfer_2A:	; STRSB Rd,[Rn,-disp]!
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	neg esi
	and edx,0Fh
	add esi,[r0+ebx*4]
	mov edx,[r0+edx*4]
	mov [r0+ebx*4],esi
	invoke mmu_write_byte,esi,edx
	ADD_CYCLES STR_CYCLES
	ret
hword_xfer_2B:	; STRSH Rd,[Rn,-disp]!
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	neg esi
	and edx,0Fh
	add esi,[r0+ebx*4]
	mov edx,[r0+edx*4]
	mov [r0+ebx*4],esi
	invoke mmu_write_word,esi,edx
	ADD_CYCLES STR_CYCLES
	ret
	
hword_xfer_2C:
	DIV0
	ret
hword_xfer_2D:	; LDRH Rd,[Rn,-disp]!
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov edi,[r0+ebx*4]
	sub edi,esi
	push edx
	mov [r0+ebx*4],edi
	invoke mmu_read_word,edi
	and eax,0FFFFh
	pop edx
	mov [r0+edx*4],eax
	ADD_CYCLES LDR_CYCLES
	ret
	
hword_xfer_2E:	; LDRSB Rd,[Rn,-disp]!
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov edi,[r0+ebx*4]
	sub edi,esi
	push edx
	mov [r0+ebx*4],edi
	invoke mmu_read_byte,edi
	movsx eax,al
	pop edx
	mov [r0+edx*4],eax
	ADD_CYCLES LDR_CYCLES
	ret
hword_xfer_2F:	; LDRSH Rd,[Rn,-disp]!
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov edi,[r0+ebx*4]
	sub edi,esi
	push edx
	mov [r0+ebx*4],edi
	invoke mmu_read_word,edi
	movsx eax,ax
	pop edx
	mov [r0+edx*4],eax
	ADD_CYCLES LDR_CYCLES
	ret
	
hword_xfer_30:
	DIV0
	ret
hword_xfer_31:	; STRH Rd,[Rn,+disp]
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	add esi,[r0+ebx*4]
	add r15,4
	mov edx,[r0+edx*4]
	;invoke mmu_write_word,esi,edx
	WRHWORD esi,dx,edx
	ADD_CYCLES STR_CYCLES
	sub r15,4
	ret
	
hword_xfer_32:	; STRSB Rd,[Rn,+disp]
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	add esi,[r0+ebx*4]
	add r15,4
	mov edx,[r0+edx*4]
	invoke mmu_write_byte,esi,edx
	ADD_CYCLES STR_CYCLES
	sub r15,4
	ret

hword_xfer_33:	; STRSH Rs,[Rn,+disp]
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	add esi,[r0+ebx*4]
	add r15,4
	mov edx,[r0+edx*4]
	invoke mmu_write_word,esi,edx
	ADD_CYCLES STR_CYCLES
	sub r15,4
	ret
	
hword_xfer_34:
	DIV0
	ret
hword_xfer_35:	; LDRH Rd,[Rn,+disp]
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	add esi,[r0+ebx*4]
	push edx
	invoke mmu_read_word,esi
	and eax,0FFFFh
	pop edx
	mov [r0+edx*4],eax
	ADD_CYCLES LDR_CYCLES
	ret

hword_xfer_36:	; LDRSB Rd,[Rn,+disp]
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov ebx,[r0+ebx*4]
	add esi,ebx
	push edx
	invoke mmu_read_byte,esi
	movsx eax,al
	pop edx
	mov [r0+edx*4],eax
	ADD_CYCLES LDR_CYCLES
	ret
	
hword_xfer_37:	; LDRSH Rd,[Rn,+disp]
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov ebx,[r0+ebx*4]
	add esi,ebx
	push edx
	invoke mmu_read_word,esi
	movsx eax,ax
	pop edx
	mov [r0+edx*4],eax
	ADD_CYCLES 4
	ret
	
hword_xfer_38:
	DIV0
	ret

hword_xfer_39:	; STRH Rd,[Rn,+disp]!
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	add esi,[r0+ebx*4]
	add r15,4
	mov [r0+ebx*4],esi
	mov edx,[r0+edx*4]
	;invoke mmu_write_word,esi,edx
	WRHWORD esi,dx,edx
	ADD_CYCLES STR_CYCLES
	sub r15,4
	ret
hword_xfer_3A:	; STRSB Rd,[Rn,+disp]!
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	add esi,[r0+ebx*4]
	add r15,4
	mov [r0+ebx*4],esi
	mov edx,[r0+edx*4]
	invoke mmu_write_byte,esi,edx
	ADD_CYCLES STR_CYCLES
	sub r15,4
	ret
hword_xfer_3B:	; STRSH Rd,[Rn,+disp]!
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	add esi,[r0+ebx*4]
	add r15,4
	mov [r0+ebx*4],esi
	mov edx,[r0+edx*4]
	invoke mmu_write_word,esi,edx
	ADD_CYCLES STR_CYCLES
	sub r15,4
	ret
	
hword_xfer_3C:
	DIV0
	ret
hword_xfer_3D:	; LDRH Rd,[Rn,+disp]!
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov edi,[r0+ebx*4]
	add esi,edi
	push edx
	mov [r0+ebx*4],esi
	invoke mmu_read_word,esi
	and eax,0FFFFh
	pop edx
	mov [r0+edx*4],eax
	ADD_CYCLES LDR_CYCLES
	ret
	
hword_xfer_3E:	; LDRSB Rd,[Rn,+disp]!
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov edi,[r0+ebx*4]
	add esi,edi
	push edx
	mov [r0+ebx*4],esi
	invoke mmu_read_byte,esi
	movsx eax,al
	pop edx
	mov [r0+edx*4],eax
	ADD_CYCLES LDR_CYCLES
	ret
	
hword_xfer_3F:	; LDRSB Rd,[Rn,+disp]!
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov edi,[r0+ebx*4]
	add esi,edi
	push edx
	mov [r0+ebx*4],esi
	invoke mmu_read_word,esi
	movsx eax,ax
	pop edx
	mov [r0+edx*4],eax
	ADD_CYCLES LDR_CYCLES
	ret


.data
align 16
; Jump table	
hword_xfer dd OFFSET hword_xfer_08 ;00
	dd OFFSET hword_xfer_09 ;01
	dd OFFSET hword_xfer_0A ;02
	dd OFFSET hword_xfer_0B ;03
	dd OFFSET hword_xfer_0C ;04
	dd OFFSET hword_xfer_0D ;05
	dd OFFSET hword_xfer_0E ;06
	dd OFFSET hword_xfer_0F ;07
	dd OFFSET hword_xfer_08
	dd OFFSET hword_xfer_09
	dd OFFSET hword_xfer_0A
	dd OFFSET hword_xfer_0B
	dd OFFSET hword_xfer_0C
	dd OFFSET hword_xfer_0D
	dd OFFSET hword_xfer_0E
	dd OFFSET hword_xfer_0F
	dd OFFSET hword_xfer_18 ;10
	dd OFFSET hword_xfer_19 ;11
	dd OFFSET hword_xfer_1A ;12
	dd OFFSET hword_xfer_1B ;13
	dd OFFSET hword_xfer_1C ;14
	dd OFFSET hword_xfer_1D ;15
	dd OFFSET hword_xfer_1E ;16
	dd OFFSET hword_xfer_1F ;17
	dd OFFSET hword_xfer_18
	dd OFFSET hword_xfer_19
	dd OFFSET hword_xfer_1A
	dd OFFSET hword_xfer_1B
	dd OFFSET hword_xfer_1C
	dd OFFSET hword_xfer_1D
	dd OFFSET hword_xfer_1E
	dd OFFSET hword_xfer_1F
	dd OFFSET hword_xfer_20
	dd OFFSET hword_xfer_21
	dd OFFSET hword_xfer_22
	dd OFFSET hword_xfer_23
	dd OFFSET hword_xfer_24
	dd OFFSET hword_xfer_25
	dd OFFSET hword_xfer_26
	dd OFFSET hword_xfer_27
	dd OFFSET hword_xfer_28
	dd OFFSET hword_xfer_29
	dd OFFSET hword_xfer_2A
	dd OFFSET hword_xfer_2B
	dd OFFSET hword_xfer_2C
	dd OFFSET hword_xfer_2D
	dd OFFSET hword_xfer_2E
	dd OFFSET hword_xfer_2F
	dd OFFSET hword_xfer_30
	dd OFFSET hword_xfer_31
	dd OFFSET hword_xfer_32
	dd OFFSET hword_xfer_33
	dd OFFSET hword_xfer_34
	dd OFFSET hword_xfer_35
	dd OFFSET hword_xfer_36
	dd OFFSET hword_xfer_37
	dd OFFSET hword_xfer_38
	dd OFFSET hword_xfer_39
	dd OFFSET hword_xfer_3A
	dd OFFSET hword_xfer_3B
	dd OFFSET hword_xfer_3C
	dd OFFSET hword_xfer_3D
	dd OFFSET hword_xfer_3E
	dd OFFSET hword_xfer_3F
.code


data_xfer_00:	; STR Rd,[Rn],-imm
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov ebx,[r0+ebx*4]
	mov edx,[r0+edx*4]
	invoke mmu_write_dword,ebx,edx
	ADD_CYCLES STR_CYCLES
	ret

data_xfer_01:	; LDR Rd,[Rn],-imm
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov ebx,[r0+ebx*4]
	RDWORD ebx
	ADD_CYCLES LDR_CYCLES
	mov [r0+edx*4],eax
	ret
	
data_xfer_02:	; STR Rd,[Rn],-imm!
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	xor ecx,-1
	and edx,0Fh
	inc ecx			; xor -1 / inc = neg
	mov esi,[r0+ebx*4]	; Rn
	add r15,4
	mov edx,[r0+edx*4]	; Rd
	add ecx,esi
	cmp ebx,15
	je @@data_xfer_02_no_wb
	mov [r0+ebx*4],ecx
	@@data_xfer_02_no_wb:
	invoke mmu_write_dword,esi,edx
	ADD_CYCLES STR_CYCLES
	sub r15,4
	ret
	
data_xfer_03:	; LDR Rd,[Rn],-imm!
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	xor ecx,-1
	and edx,0Fh
	inc ecx
	mov esi,[r0+ebx*4]
	add ecx,esi
	cmp ebx,15
	je @@data_xfer_03_no_wb
	mov [r0+ebx*4],ecx
	@@data_xfer_03_no_wb:
	RDWORD esi
	ADD_CYCLES LDR_CYCLES
	mov [r0+edx*4],eax
	ret
	
data_xfer_04:	; STRB Rd,[Rn],-disp
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov ebx,[r0+ebx*4]
	mov edx,[r0+edx*4]
	invoke mmu_write_byte,ebx,edx
	ADD_CYCLES STR_CYCLES
	ret
	
data_xfer_05:	; LDRB Rd,[Rn],-disp
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov ebx,[r0+ebx*4]
	push edx
	invoke mmu_read_byte,ebx
	pop edx
	and eax,0FFh
	ADD_CYCLES LDR_CYCLES
	mov [r0+edx*4],eax
	ret
	
data_xfer_06:	; STRB Rd,[Rn],-disp!
	mov ebx,eax
	mov edx,eax
	xor ecx,-1
	shr ebx,16
	shr edx,12
	inc ecx
	and ebx,0Fh
	and edx,0Fh
	mov esi,[r0+ebx*4]	; Rn
	mov edx,[r0+edx*4]	; Rd
	add ecx,esi
	cmp ebx,15
	je @@data_xfer_06_no_wb
	mov [r0+ebx*4],ecx
	@@data_xfer_06_no_wb:
	WRBYTE esi,dl,edx
	ADD_CYCLES STR_CYCLES
	ret
	
data_xfer_07:	; LDRB Rd,[Rn],-disp!
	mov ebx,eax
	mov edx,eax
	xor ecx,-1
	shr ebx,16
	shr edx,12
	inc ecx
	and ebx,0Fh
	and edx,0Fh
	mov esi,[r0+ebx*4]
	add ecx,esi
	cmp ebx,15
	je @@data_xfer_07_no_wb
	mov [r0+ebx*4],ecx
	@@data_xfer_07_no_wb:
	RDBYTE esi
	and eax,0FFh
	ADD_CYCLES LDR_CYCLES
	mov [r0+edx*4],eax
	ret
	
data_xfer_08:	; STR Rd,[Rn],+disp
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov ebx,[r0+ebx*4]
	mov edx,[r0+edx*4]
	invoke mmu_write_dword,ebx,edx
	ADD_CYCLES STR_CYCLES
	ret
	
data_xfer_09:	; LDR Rd,[Rn],+disp
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov ebx,[r0+ebx*4]
	push edx
	invoke mmu_read_dword,ebx
	pop edx
	ADD_CYCLES LDR_CYCLES
	mov [r0+edx*4],eax
	ret
	
data_xfer_0A:	; STR Rd,[Rn],+imm!
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov esi,[r0+ebx*4]
	add r15,4
	mov edx,[r0+edx*4]
	add ecx,esi
	cmp ebx,15
	je @@data_xfer_0A_no_wb
	mov [r0+ebx*4],ecx
	@@data_xfer_0A_no_wb:
	invoke mmu_write_dword,esi,edx
	ADD_CYCLES STR_CYCLES
	sub r15,4
	ret

data_xfer_0B:	; LDR Rd,[Rn],+disp!
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov esi,[r0+ebx*4]
	add ecx,esi
	cmp ebx,15
	je @@data_xfer_0B_no_wb
	mov [r0+ebx*4],ecx
	@@data_xfer_0B_no_wb:
	RDWORD esi
	mov [r0+edx*4],eax
	ADD_CYCLES LDR_CYCLES
	ret

data_xfer_0C:	; STRB Rd,[Rn],+disp
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov ebx,[r0+ebx*4]
	mov edx,[r0+edx*4]
	invoke mmu_write_byte,ebx,edx
	ADD_CYCLES STR_CYCLES
	ret
	
data_xfer_0D:	; LDRB Rd,[Rn],+disp
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov ebx,[r0+ebx*4]
	push edx
	invoke mmu_read_byte,ebx
	pop edx
	and eax,0FFh
	ADD_CYCLES LDR_CYCLES
	mov [r0+edx*4],eax
	ret

data_xfer_0E:	; STRB Rd,[Rn],+disp!
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov esi,[r0+ebx*4]
	mov edx,[r0+edx*4]
	add ecx,esi
	cmp ebx,15
	je @@data_xfer_0E_no_wb
	mov [r0+ebx*4],ecx
	@@data_xfer_0E_no_wb:
	WRBYTE esi,dl,edx
	ADD_CYCLES STR_CYCLES
	ret

data_xfer_0F:	; LDRB Rd,[Rn],+imm!
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov esi,[r0+ebx*4]
	add ecx,esi
	push edx
	cmp ebx,15
	je @@data_xfer_0F_no_wb
	mov [r0+ebx*4],ecx
	@@data_xfer_0F_no_wb:
	invoke mmu_read_byte,esi
	pop edx
	and eax,0FFh
	ADD_CYCLES LDR_CYCLES
	mov [r0+edx*4],eax
	ret
	
data_xfer_10:	; STR Rd,[Rn,-disp]
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov esi,[r0+ebx*4]
	add r15,4
	mov edx,[r0+edx*4]
	sub esi,ecx
	invoke mmu_write_dword,esi,edx
	ADD_CYCLES STR_CYCLES
	sub r15,4
	ret
	
data_xfer_11:	; LDR Rd,[Rn,-disp]
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov ebx,[r0+ebx*4]
	sub ebx,ecx
	RDWORD ebx
	mov [r0+edx*4],eax
	ADD_CYCLES LDR_CYCLES
	ret
	
data_xfer_12:	; STR Rd,[Rn,-disp]!
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov esi,[r0+ebx*4]
	add r15,4
	mov edx,[r0+edx*4]
	sub esi,ecx
	mov [r0+ebx*4],esi
	invoke mmu_write_dword,esi,edx
	ADD_CYCLES STR_CYCLES
	sub r15,4
	ret
	
data_xfer_13:	; LDR Rd,[Rn,-disp]!
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov esi,[r0+ebx*4]
	sub esi,ecx
	mov [r0+ebx*4],esi
	RDWORD esi
	mov [r0+edx*4],eax
	ADD_CYCLES LDR_CYCLES
	ret

data_xfer_14:	; STRB Rd,[Rn,-disp]
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov esi,[r0+ebx*4]
	mov edx,[r0+edx*4]
	sub esi,ecx
	WRBYTE esi,dl,edx
	ADD_CYCLES STR_CYCLES
	ret
	
data_xfer_15:	; LDRB Rd,[Rn,-disp]
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov ebx,[r0+ebx*4]
	sub ebx,ecx
	RDBYTE ebx
	and eax,0FFh
	ADD_CYCLES LDR_CYCLES
	mov [r0+edx*4],eax
	ret
	
data_xfer_16:	; STRB Rd,[Rn,-disp]!
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov esi,[r0+ebx*4]
	mov edx,[r0+edx*4]
	sub esi,ecx
	mov [r0+ebx*4],esi
	WRBYTE esi,dl,edx
	ADD_CYCLES STR_CYCLES
	ret
	
data_xfer_17:	; LDRB Rd,[Rn,-disp]!
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov esi,[r0+ebx*4]
	sub esi,ecx
	mov [r0+ebx*4],esi
	RDBYTE esi
	and eax,0FFh
	ADD_CYCLES LDR_CYCLES
	mov [r0+edx*4],eax
	ret
	
data_xfer_18:	; STR Rd,[Rn,+disp]
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov esi,[r0+ebx*4]
	add r15,4
	mov edx,[r0+edx*4]
	add esi,ecx
	invoke mmu_write_dword,esi,edx
	ADD_CYCLES STR_CYCLES
	sub r15,4
	ret
	
data_xfer_19:	; LDR Rd,[Rn,+disp]
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov ebx,[r0+ebx*4]
	add ecx,ebx
	RDWORD ecx
	mov [r0+edx*4],eax
	ADD_CYCLES LDR_CYCLES
	ret

data_xfer_1A:	; STR Rd,[Rn,+disp]!
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov esi,[r0+ebx*4]
	add r15,4
	mov edx,[r0+edx*4]
	add esi,ecx
	mov [r0+ebx*4],esi
	invoke mmu_write_dword,esi,edx
	ADD_CYCLES STR_CYCLES
	sub r15,4
	ret
	
data_xfer_1B:	; LDR Rd,[Rn,+disp]!
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov esi,[r0+ebx*4]
	add esi,ecx
	mov [r0+ebx*4],esi
	RDWORD esi
	mov [r0+edx*4],eax
	ADD_CYCLES 4
	ret
	
data_xfer_1C:	; STRB Rd,[Rn,+disp]
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov esi,[r0+ebx*4]
	mov edx,[r0+edx*4]
	add esi,ecx
	WRBYTE esi,dl,edx
	ADD_CYCLES STR_CYCLES
	ret
	
data_xfer_1D:	; LDRB Rd,[Rn,+disp]
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov ebx,[r0+ebx*4]
	add ecx,ebx
	RDBYTE ecx
	and eax,0FFh
	ADD_CYCLES LDR_CYCLES
	mov [r0+edx*4],eax
	ret

data_xfer_1E:	; STRB Rd,[Rn,+disp]!
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov esi,[r0+ebx*4]
	mov edx,[r0+edx*4]
	add esi,ecx
	mov [r0+ebx*4],esi
	WRBYTE esi,dl,edx
	ADD_CYCLES STR_CYCLES
	ret
	
data_xfer_1F:	; LDRB Rd,[Rn,+disp]!
	mov ebx,eax
	mov edx,eax
	shr ebx,16
	shr edx,12
	and ebx,0Fh
	and edx,0Fh
	mov esi,[r0+ebx*4]
	add esi,ecx
	mov [r0+ebx*4],esi
	RDBYTE esi
	and eax,0FFh
	ADD_CYCLES LDR_CYCLES
	mov [r0+edx*4],eax
	ret

.data
align 16
; Jump table
data_xfer dd OFFSET data_xfer_02 ;00
	dd OFFSET data_xfer_03 ;01
	dd OFFSET data_xfer_02
	dd OFFSET data_xfer_03
	dd OFFSET data_xfer_06 ;04
	dd OFFSET data_xfer_07 ;05
	dd OFFSET data_xfer_06
	dd OFFSET data_xfer_07
	dd OFFSET data_xfer_0A ;08
	dd OFFSET data_xfer_0B ;09
	dd OFFSET data_xfer_0A
	dd OFFSET data_xfer_0B
	dd OFFSET data_xfer_0E ;0C
	dd OFFSET data_xfer_0F ;0D
	dd OFFSET data_xfer_0E
	dd OFFSET data_xfer_0F
	dd OFFSET data_xfer_10
	dd OFFSET data_xfer_11
	dd OFFSET data_xfer_12
	dd OFFSET data_xfer_13
	dd OFFSET data_xfer_14
	dd OFFSET data_xfer_15
	dd OFFSET data_xfer_16
	dd OFFSET data_xfer_17
	dd OFFSET data_xfer_18
	dd OFFSET data_xfer_19
	dd OFFSET data_xfer_1A
	dd OFFSET data_xfer_1B
	dd OFFSET data_xfer_1C
	dd OFFSET data_xfer_1D
	dd OFFSET data_xfer_1E
	dd OFFSET data_xfer_1F
.code


block_xfer_00:	; STMED Rn,{...}
	add r15,4
	mov ebx,eax
	shr ebx,16
	mov ecx,15
	and ebx,0Fh		
	mov ebp,[r0+ebx*4]	; get Rn
	shl eax,16
	@@block_xfer_00_loop:
		shl eax,1
		jnc @@block_xfer_00_no_xfer
			.if ecx == ebx
				mov edx,ebp
			.else
				mov edx,[r0+ecx*4]
			.endif
			push eax
			push edx
			push ecx
			push ebp
			invoke mmu_write_dword,ebp,edx
			pop ebp
			pop ecx
			sub ebp,4
			pop edx
			pop eax
		@@block_xfer_00_no_xfer:
		dec ecx
		jns @@block_xfer_00_loop
	sub r15,4
	ADD_CYCLES 8
	ret
	
block_xfer_01:	; LDMFA Rn,{...}
	mov ebx,eax
	mov esi,OFFSET r0
	shr ebx,16
	mov ecx,15
	and ebx,0Fh		
	mov edx,eax
	.if eax & 8000h
		mov physaddr,-1
	.endif
	mov ebp,[esi+ebx*4]	; get Rn
	shl edx,16

	@@block_xfer_01_loop:
		shl edx,1
		jnc @@block_xfer_01_no_xfer
			push ebp
			push ecx
			push edx
			push esi
			invoke mmu_read_dword,ebp
			pop esi
			pop edx
			pop ecx
			pop ebp
			mov [esi+ecx*4],eax
			add ebp,4 

			;cmp ecx,15
			;jne @@block_xfer_01_not_pc
				;add r15,4
			;	mov physaddr,-1
			;@@block_xfer_09_not_pc:
		@@block_xfer_01_no_xfer:
		dec ecx
		jns @@block_xfer_01_loop
	ADD_CYCLES 8
	ret
	
block_xfer_02:
	DIV0
	ret
block_xfer_03:
	mov ebx,eax
	mov esi,OFFSET r0
	shr ebx,16
	mov ecx,15
	and ebx,0Fh		
	mov edx,eax
	.if eax & 8000h
		mov physaddr,-1
	.endif
	shl edx,16
	@@block_xfer_03_loop:
		shl edx,1
		jnc @@block_xfer_03_no_xfer
			;push ebp
			push ecx
			push edx
			mov ebp,[esi+ebx*4]	; get Rn
			push esi
			invoke mmu_read_dword,ebp
			pop esi
			pop edx
			pop ecx
			;pop ebp
			mov [esi+ecx*4],eax
			add dword ptr [esi+ebx*4],4 

		@@block_xfer_03_no_xfer:
		dec ecx
		jns @@block_xfer_03_loop
	ADD_CYCLES 8
	ret
	
block_xfer_04:
	add r15,4
	mov ebx,eax
	shr ebx,16
	mov ecx,15
	and ebx,0Fh		
	mov ebp,[r0+ebx*4]	; get Rn
	shl eax,16
	@@block_xfer_04_loop:
		shl eax,1
		jnc @@block_xfer_04_no_xfer
			.if ecx == ebx
				mov edx,ebp
			.else
				mov edx,[r0+ecx*4]
			.endif
			push eax
			push edx
			push ecx
			push ebp
			invoke mmu_write_dword,ebp,edx
			pop ebp
			pop ecx
			sub ebp,4
			pop edx
			pop eax
		@@block_xfer_04_no_xfer:
		dec ecx
		jns @@block_xfer_04_loop
	sub r15,4
	ADD_CYCLES 8
	ret
	
block_xfer_05:
	DIV0
	ret
block_xfer_06:		; STMEDS Rn!,{...}
	add r15,4
	mov ebx,eax
	shr ebx,16
	mov ecx,15
	and ebx,0Fh		
	mov ebp,[r0+ebx*4]	; get Rn
	shl eax,16
	push ebx
	@@block_xfer_06_loop:
		shl eax,1
		jnc @@block_xfer_06_no_xfer
			.if ecx == ebx
				mov edx,ebp
			.else
				mov edx,[r0+ecx*4]
			.endif
			push eax
			push edx
			push ecx
			push ebp
			invoke mmu_write_dword,ebp,edx
			pop ebp
			pop ecx
			sub ebp,4
			pop edx
			pop eax
		@@block_xfer_06_no_xfer:
		dec ecx
		jns @@block_xfer_06_loop
	pop ebx
	mov [r0+ebx*4],ebp
	sub r15,4
	ADD_CYCLES 8
	ret
	
block_xfer_07:
	DIV0
	ret
block_xfer_08:		; STMIA Rn,{...}
	add r15,4
	mov ebx,eax
	shr ebx,16
	mov ecx,0
	and ebx,0Fh		
	mov ebp,[r0+ebx*4]	; get Rn
	@@block_xfer_08_loop:
		shr eax,1
		jnc @@block_xfer_08_no_xfer
			.if ecx == ebx
				mov edx,ebp
			.else
				mov edx,[r0+ecx*4]
			.endif
			push eax
			push edx
			push ecx
			push ebp
			invoke mmu_write_dword,ebp,edx
			pop ebp
			pop ecx
			add ebp,4
			pop edx
			pop eax
		@@block_xfer_08_no_xfer:
		inc ecx
		cmp ecx,16
		jne @@block_xfer_08_loop
	sub r15,4
	ADD_CYCLES 8
	ret
	
block_xfer_09:	; LDMFD Rn,{...}
	mov ebx,eax
	mov esi,OFFSET r0
	shr ebx,16
	mov ecx,0
	and ebx,0Fh		
	mov edx,eax
	mov ebp,[esi+ebx*4]	; get Rn
	@@block_xfer_09_loop:
		shr edx,1
		jnc @@block_xfer_09_no_xfer
			push ebp
			push ecx
			push edx
			push esi
			;mov ebp,[esi+ebx*4]
			invoke mmu_read_dword,ebp
			pop esi
			pop edx
			pop ecx
			pop ebp
			mov [esi+ecx*4],eax
			add ebp,4 

			cmp ecx,15
			jne @@block_xfer_09_not_pc
				;add r15,4
				mov physaddr,-1
			@@block_xfer_09_not_pc:
		@@block_xfer_09_no_xfer:
		inc ecx
		cmp ecx,16
		jne @@block_xfer_09_loop
	ADD_CYCLES 8
	ret

block_xfer_0A:		; STMIA Rn!,{...}
	add r15,4
	mov ebx,eax
	shr ebx,16
	mov ecx,0
	and ebx,0Fh		
	mov ebp,[r0+ebx*4]	; get Rn
	push ebx
	@@block_xfer_0A_loop:
		shr eax,1
		jnc @@block_xfer_0A_no_xfer
			.if ecx == ebx
				mov edx,ebp
			.else
				mov edx,[r0+ecx*4]
			.endif
			push eax
			push edx
			push ecx
			push ebp
			invoke mmu_write_dword,ebp,edx
			pop ebp
			pop ecx
			add ebp,4
			pop edx
			pop eax
		@@block_xfer_0A_no_xfer:
		inc ecx
		cmp ecx,16
		jne @@block_xfer_0A_loop
	pop ebx
	mov [r0+ebx*4],ebp
	sub r15,4
	ADD_CYCLES 8
	ret

block_xfer_0B:	; LDMFD Rn!,{...}
	mov ebx,eax
	shr ebx,16
	mov ecx,0
	and ebx,0Fh		
	mov edx,eax
	@@block_xfer_0B_loop:
		shr edx,1
		jnc @@block_xfer_0B_no_xfer
			push ebx
			push ecx
			push edx
			mov ebp,[r0+ebx*4]
			invoke mmu_read_dword,ebp
			pop edx
			pop ecx
			pop ebx
			mov [r0+ecx*4],eax
			add dword ptr [r0+ebx*4],4 ;ebp,4

			cmp ecx,15
			jne @@block_xfer_0B_not_pc
				;add r15,4
				mov physaddr,-1
			@@block_xfer_0B_not_pc:	
		@@block_xfer_0B_no_xfer:
		inc ecx
		cmp ecx,16
		jne @@block_xfer_0B_loop
	ADD_CYCLES 8
	ret

block_xfer_0C:		; STMIAS Rn,{...}
	add r15,4
	mov ebx,eax
	shr ebx,16
	mov ecx,0
	and ebx,0Fh		
	mov ebp,[r0+ebx*4]	; get Rn
	@@block_xfer_0C_loop:
		shr eax,1
		jnc @@block_xfer_0C_no_xfer
			.if ecx == ebx
				mov edx,ebp
			.else
				mov edx,[r0+ecx*4]
			.endif
			push eax
			push edx
			push ecx
			push ebp
			invoke mmu_write_dword,ebp,edx
			pop ebp
			pop ecx
			add ebp,4
			pop edx
			pop eax
		@@block_xfer_0C_no_xfer:
		inc ecx
		cmp ecx,16
		jne @@block_xfer_0C_loop
	sub r15,4
	ADD_CYCLES 8
	ret
	
block_xfer_0D:
	mov ebx,eax
	shr ebx,16
	mov ecx,0
	and ebx,0Fh		
	mov edx,eax
	mov ebp,[r0+ebx*4]
	@@block_xfer_0D_loop:
		shr edx,1
		jnc @@block_xfer_0D_no_xfer
			push ebx
			push ecx
			push ebp
			push edx
			invoke mmu_read_dword,ebp
			pop edx
			pop ebp
			pop ecx
			pop ebx
			mov [r0+ecx*4],eax
			add ebp,4 ;dword ptr [r0+ebx*4],4 ;ebp,4

			cmp ecx,15
			jne @@block_xfer_0D_not_pc
				mov physaddr,-1
			@@block_xfer_0D_not_pc:	
		@@block_xfer_0D_no_xfer:
		inc ecx
		cmp ecx,16
		jne @@block_xfer_0D_loop
	ADD_CYCLES 8
	ret
	
block_xfer_0E:
	DIV0
	ret
block_xfer_0F:
	DIV0
	ret
block_xfer_10:	; STMFD Rn,{...}
	add r15,4
	mov ebx,eax
	shr ebx,16
	mov ecx,15
	and ebx,0Fh		
	mov ebp,[r0+ebx*4]	; get Rn
	shl eax,16
	@@block_xfer_10_loop:
		shl eax,1
		jnc @@block_xfer_10_no_xfer
			.if ecx == ebx
				mov edx,ebp
			.else
				mov edx,[r0+ecx*4]
			.endif
			push eax
			push edx
			sub ebp,4
			push ecx
			push ebp
			push ebx
			invoke mmu_write_dword,ebp,edx
			pop ebx
			pop ebp
			pop ecx
			pop edx
			pop eax
		@@block_xfer_10_no_xfer:
		dec ecx
		jns @@block_xfer_10_loop
	sub r15,4
	ADD_CYCLES 8
	ret

block_xfer_11:	; LDMEA Rn,{...}
	mov ebx,eax
	mov esi,OFFSET r0
	shr ebx,16
	mov ecx,15
	and ebx,0Fh		
	mov edx,eax
	mov ebp,[esi+ebx*4]	; get Rn
	shl edx,16
	@@block_xfer_11_loop:
		shl edx,1
		jnc @@block_xfer_11_no_xfer
			sub ebp,4 
			push edx
			push esi
			push ebp
			push ecx
			invoke mmu_read_dword,ebp
			pop ecx
			pop ebp
			pop esi
			pop edx
			mov [esi+ecx*4],eax

			cmp ecx,15
			jne @@block_xfer_11_not_pc
				;add r15,4
				mov physaddr,-1
			@@block_xfer_11_not_pc:
		@@block_xfer_11_no_xfer:
		dec ecx
		jns @@block_xfer_11_loop
	ADD_CYCLES 8
	ret
	
block_xfer_12:	; STMFD Rn!,{...}
	add r15,4
	mov ebx,eax
	;mov esi,OFFSET r0
	shr ebx,16
	mov ecx,15
	and ebx,0Fh		
	mov ebp,[r0+ebx*4]	; get Rn
	shl eax,16
	@@block_xfer_12_loop:
		shl eax,1
		jnc @@block_xfer_12_no_xfer
			.if ecx == ebx
				mov edx,ebp
			.else
				mov edx,[r0+ecx*4]
			.endif
			push eax
			push edx
			sub ebp,4
			push ecx
			push ebp
			push ebx
			invoke mmu_write_dword,ebp,edx
			pop ebx
			pop ebp
			pop ecx
			pop edx
			pop eax
		@@block_xfer_12_no_xfer:
		dec ecx
		jns @@block_xfer_12_loop
	mov [r0+ebx*4],ebp
	sub r15,4
	ADD_CYCLES 8
	ret

block_xfer_13:
	mov ebx,eax
	mov esi,OFFSET r0
	shr ebx,16
	mov ecx,15
	and ebx,0Fh		
	mov edx,eax
	mov ebp,[esi+ebx*4]	; get Rn
	shl edx,16
	push ebx
	@@block_xfer_13_loop:
		shl edx,1
		jnc @@block_xfer_13_no_xfer
			sub ebp,4 
			push edx
			push esi
			push ebp
			push ecx
			invoke mmu_read_dword,ebp
			pop ecx
			pop ebp
			pop esi
			pop edx
			mov [esi+ecx*4],eax

			cmp ecx,15
			jne @@block_xfer_13_not_pc
				;add r15,4
				mov physaddr,-1
			@@block_xfer_13_not_pc:
		@@block_xfer_13_no_xfer:
		dec ecx
		jns @@block_xfer_13_loop
	pop ebx
	ADD_CYCLES 8
	mov [r0+ebx*4],ebp
	ret
	
block_xfer_14:
	DIV0
	ret
block_xfer_15:
	DIV0
	ret
block_xfer_16:
	DIV0
	ret
block_xfer_17:
	DIV0
	ret

block_xfer_18:
	add r15,4
	mov ebx,eax
	shr ebx,16
	mov ecx,15
	and ebx,0Fh		
	mov ebp,[r0+ebx*4]	; get Rn
	shl eax,16
	@@block_xfer_18_loop:
		shl eax,1
		jnc @@block_xfer_18_no_xfer
			mov edx,[r0+ecx*4]
			push eax
			push edx
			add ebp,4
			push ecx
			push ebp
			invoke mmu_write_dword,ebp,edx
			pop ebp
			pop ecx
			pop edx
			pop eax
		@@block_xfer_18_no_xfer:
		dec ecx
		jns @@block_xfer_18_loop
	sub r15,4
	ADD_CYCLES 8
	ret

block_xfer_19:
	mov ebx,eax
	mov esi,OFFSET r0
	shr ebx,16
	mov ecx,0
	and ebx,0Fh		
	mov edx,eax
	mov ebp,[esi+ebx*4]	; get Rn
	;shl edx,16
	@@block_xfer_19_loop:
		shr edx,1
		jnc @@block_xfer_19_no_xfer
			add ebp,4 
			push edx
			push esi
			push ebp
			push ecx
			invoke mmu_read_dword,ebp
			pop ecx
			pop ebp
			pop esi
			pop edx
			mov [esi+ecx*4],eax

			cmp ecx,15
			jne @@block_xfer_19_not_pc
				;add r15,4
				mov physaddr,-1
			@@block_xfer_19_not_pc:
		@@block_xfer_19_no_xfer:
		inc ecx
		cmp ecx,16
		jne @@block_xfer_19_loop
	ADD_CYCLES 8
	ret
	
block_xfer_1A:
	DIV0
	ret
block_xfer_1B:
	DIV0
	ret
block_xfer_1C:
	DIV0
	ret
block_xfer_1D:	; LDMEDS Rn,{...}
	mov ebx,eax
	mov esi,OFFSET r0
	shr ebx,16
	mov ecx,0
	and ebx,0Fh		
	mov edx,eax
	mov ebp,[esi+ebx*4]	; get Rn
	;shl edx,16
	@@block_xfer_1D_loop:
		shr edx,1
		jnc @@block_xfer_1D_no_xfer
			add ebp,4 
			push edx
			push esi
			push ebp
			push ecx
			invoke mmu_read_dword,ebp
			pop ecx
			pop ebp
			pop esi
			pop edx
			mov [esi+ecx*4],eax

			cmp ecx,15
			jne @@block_xfer_1D_not_pc
				;add r15,4
				mov physaddr,-1
			@@block_xfer_1D_not_pc:
		@@block_xfer_1D_no_xfer:
		inc ecx
		cmp ecx,16
		jne @@block_xfer_1D_loop
	ADD_CYCLES 8
	ret
	
block_xfer_1E:
	DIV0
	ret
block_xfer_1F:
	DIV0
	ret


.data
align 16	
block_xfer dd OFFSET block_xfer_00
	dd OFFSET block_xfer_01
	dd OFFSET block_xfer_02
	dd OFFSET block_xfer_03
	dd OFFSET block_xfer_04
	dd OFFSET block_xfer_05
	dd OFFSET block_xfer_06
	dd OFFSET block_xfer_07
	dd OFFSET block_xfer_08
	dd OFFSET block_xfer_09
	dd OFFSET block_xfer_0A
	dd OFFSET block_xfer_0B
	dd OFFSET block_xfer_0C
	dd OFFSET block_xfer_0D
	dd OFFSET block_xfer_0E
	dd OFFSET block_xfer_0F
	dd OFFSET block_xfer_10
	dd OFFSET block_xfer_11
	dd OFFSET block_xfer_12
	dd OFFSET block_xfer_13
	dd OFFSET block_xfer_14
	dd OFFSET block_xfer_15
	dd OFFSET block_xfer_16
	dd OFFSET block_xfer_17
	dd OFFSET block_xfer_18
	dd OFFSET block_xfer_19
	dd OFFSET block_xfer_1A
	dd OFFSET block_xfer_1B
	dd OFFSET block_xfer_1C
	dd OFFSET block_xfer_1D
	dd OFFSET block_xfer_1E
	dd OFFSET block_xfer_1F
.code	


;----------------------------------------------------
; Multiply operations
; eax contains Rs, ebx contains the Rm number (0..15)
; edi contains the full opcode
;----------------------------------------------------

op_mul_:
	shr edi,16
	imul dword ptr [r0+ebx*4]		
	and edi,0Fh
	ADD_CYCLES 2
	mov [r0+edi*4],eax
	ret
op_muls_:
	shr edi,16
	imul dword ptr [r0+ebx*4]
	mov esi,eax
	cmp eax,0
	UPDATE_NZ
	and edi,0Fh
	ADD_CYCLES 2
	mov [r0+edi*4],esi
	ret		
op_mla:
	mov esi,edi
	imul dword ptr [r0+ebx*4]
	shr esi,12
	shr edi,16
	and esi,0Fh
	and edi,0Fh
	add eax,[r0+esi*4]
	ADD_CYCLES 2
	mov [r0+edi*4],eax
	ret
op_mlas:
	mov esi,edi
	imul dword ptr [r0+ebx*4]	; Rs *= Rm
	shr esi,12
	shr edi,16
	and esi,0Fh
	and edi,0Fh
	add eax,[r0+esi*4]		; Rs += Rn
	mov ebp,eax
	;cmp eax,0
	UPDATE_NZ
	ADD_CYCLES 2
	mov [r0+edi*4],ebp		; Rd = Rs*Rm + Rn
	ret	
op_umull:
	mov esi,edi
	mul dword ptr [r0+ebx*4]	; Rs *= Rm
	shr esi,12
	shr edi,16
	and esi,0Fh			; esi : RdLo
	and edi,0Fh			; edi : RdHi
	ADD_CYCLES 2
	mov [r0+esi*4],eax
	mov [r0+edi*4],edx
	ret		
op_umulls:
	mov esi,edi
	mul dword ptr [r0+ebx*4]	; Rs *= Rm
	mov ecx,edx
	mov ebp,eax
	UPDATE_NZ_MULL
	shr esi,12
	shr edi,16
	and esi,0Fh			; esi : RdLo
	and edi,0Fh			; edi : RdHi
	ADD_CYCLES 2
	mov [r0+esi*4],ebp
	mov [r0+edi*4],ecx
	ret		
op_smull:
	mov esi,edi
	imul dword ptr [r0+ebx*4]	; Rs *= Rm
	shr esi,12
	shr edi,16
	and esi,0Fh			; esi : RdLo
	and edi,0Fh			; edi : RdHi
	ADD_CYCLES 2
	mov [r0+esi*4],eax
	mov [r0+edi*4],edx
	ret		
op_smulls:
	mov esi,edi
	imul dword ptr [r0+ebx*4]	; Rs *= Rm
	mov ecx,edx
	mov ebp,eax
	UPDATE_NZ_MULL
	shr esi,12
	shr edi,16
	and esi,0Fh			; esi : RdLo
	and edi,0Fh			; edi : RdHi
	ADD_CYCLES 2
	mov [r0+esi*4],ebp
	mov [r0+edi*4],ecx
	ret		

op_umlal:
	mov esi,edi
	mul dword ptr [r0+ebx*4]	; Rs *= Rm
	shr esi,12
	shr edi,16
	and esi,0Fh			; esi : RdLo
	and edi,0Fh			; edi : RdHi
	ADD_CYCLES 2
	add [r0+esi*4],eax
	adc [r0+edi*4],edx
	ret		
op_umlals:
	DIV0
op_smlal:
	mov esi,edi
	imul dword ptr [r0+ebx*4]	; Rs *= Rm
	shr esi,12
	shr edi,16
	and esi,0Fh			; esi : RdLo
	and edi,0Fh			; edi : RdHi
	ADD_CYCLES 2
	add [r0+esi*4],eax
	adc [r0+edi*4],edx
	ret	
op_smlals:
	DIV0
	
op_swpb:
	mov esi,eax
	push eax
	shr esi,16
	and esi,0Fh
	push esi
	invoke mmu_read_byte,dword ptr [r0+esi*4]
	pop esi

	pop edi
	and eax,0FFh
	mov edx,edi
	shr edi,12
	and edx,0Fh
	and edi,0Fh
	mov [r0+edi*4],eax
	invoke mmu_write_byte,esi,dword ptr [r0+edx*4]
	ADD_CYCLES 4
	ret
op_swpd:
	mov esi,eax
	push eax
	shr esi,16
	and esi,0Fh
	push esi
	invoke mmu_read_dword,dword ptr [r0+esi*4]
	pop esi
	pop edi
	and eax,0FFh
	mov edx,edi
	shr edi,12
	and edx,0Fh
	and edi,0Fh
	mov [r0+edi*4],eax
	invoke mmu_write_dword,esi,dword ptr [r0+edx*4]
	ADD_CYCLES 4
	ret	


	
	
.data
align 8
mul_ops dd OFFSET op_mul_
	dd OFFSET op_muls_
	dd OFFSET op_mla
	dd OFFSET op_mlas
	dd OFFSET op_mul_
	dd OFFSET op_muls_
	dd OFFSET op_mla
	dd OFFSET op_mlas
	dd OFFSET op_umull
	dd OFFSET op_umulls
	dd OFFSET op_umlal
	dd OFFSET op_umlals
	dd OFFSET op_smull
	dd OFFSET op_smulls
	dd OFFSET op_smlal
	dd OFFSET op_smlals
	
	dd OFFSET op_swpd
	dd OFFSET op_swpd
	dd OFFSET op_swpd
	dd OFFSET op_swpd
	dd OFFSET op_swpb
	dd OFFSET op_swpb
	dd OFFSET op_swpb
	dd OFFSET op_swpb
	dd OFFSET op_swpd
	dd OFFSET op_swpd
	dd OFFSET op_swpd
	dd OFFSET op_swpd
	dd OFFSET op_swpb
	dd OFFSET op_swpb
	dd OFFSET op_swpb
	dd OFFSET op_swpb

.code


swi_handler:
	.if eax == 6
		mov eax,r0
		cdq
		idiv dword ptr r1
		mov r0,eax
		mov r1,edx
		test eax,80000000h
		jz @@swi6_positive
		neg eax
		@@swi6_positive:
		mov r2,eax
		ADD_CYCLES 20
		ret
	.elseif eax == 7
		mov eax,r1
		cdq
		idiv dword ptr r0
		mov r0,eax
		mov r1,edx
		test eax,80000000h
		jz @@swi7_positive
		neg eax
		@@swi7_positive:
		mov r2,eax
		ADD_CYCLES 20
		ret	
	.elseif eax == 8
		fild dword ptr [r0]
		fsqrt
		fistp dword ptr [r0]
		ADD_CYCLES 30
		ret
	.elseif eax == 12
	;		pusha
	;		invoke wsprintf,ADDR szBuffer,ADDR szFormat21,r0,r1,r2,r3,r12,r13,r14,r15,dword ptr [flags+4],0
	;		invoke lstrlen,ADDR szBuffer
	;		invoke WriteConsole,hout,ADDR szBuffer,eax,ADDR dummy,NULL
	;		popa	
	.endif
	ADD_CYCLES 4
	ret

	
type_0:
	mov ecx,eax
	and ecx,12FFF10h
	cmp ecx,12FFF10h
	je @@type_0_bx

	mov ebx,eax
	and ebx,90h
	cmp ebx,90h
	je @@hword_op_or_mul

	mov ebx,eax
	mov esi,eax
	mov edi,eax
	shr ebx,20			; Get opcode
	shr esi,16			; Get Rn
	and edi,0Fh			; Get Rm
	and esi,0Fh
	and ebx,01Fh
	mov esi,[r0+esi*4]

	test eax,10h			; Shift amount specified in register
	jz @@type_0_imm_shift
		mov ecx,eax
		add r15,4
		shr ecx,8
		ADD_CYCLES 1
		and ecx,0Fh
		mov ecx,[r0+ecx*4]
		and ecx,0FFh
		mov edi,[r0+edi*4]
		jz @@type_0_shift_reg_zero
		cmp ecx,32
		jge @@reg_shift_ge_32
		SHIFT_OPERAND edi
		UPDATE_C
		call dword ptr [data_proc_ops + ebx*4]
		sub r15,4
		ret
		
		@@type_0_shift_reg_zero:
		mov ecx,[flags+4]
		mov [shifterC],ecx
		call dword ptr [data_proc_ops + ebx*4]
		sub r15,4
		ret
		
		@@reg_shift_ge_32:
		jg @@reg_shift_gt_32		
		SHIFT_OPERAND_32 edi
		;UPDATE_C
		call dword ptr [data_proc_ops + ebx*4]
		sub r15,4
		ret
		
		@@reg_shift_gt_32:		
		SHIFT_OPERAND_GT32 edi
		;UPDATE_C
		call dword ptr [data_proc_ops + ebx*4]
		sub r15,4
		ret
		
	@@type_0_imm_shift:		; Shift amount specified in immediate value	
		test eax,0F80h		
		mov edi,[r0+edi*4]
		jz @@type_0_zero_shift	; Only perform the shift if imm>0
			mov ecx,eax
			and ecx,0FFFh
			shr ecx,7	; Get Rm shift
			SHIFT_OPERAND edi
			UPDATE_C
			jmp dword ptr [data_proc_ops + ebx*4]
		@@type_0_zero_shift:
		;mov ecx,eax
		;and ecx,0FFFh
		;shr ecx,7	; Get Rm shift
		SHIFT_OPERAND_ZERO edi
		;UPDATE_C
	 	jmp dword ptr [data_proc_ops + ebx*4]


	@@hword_op_or_mul:
	test eax,60h
	jnz @@hword_op
	test eax,1000000h
	jnz @@hword_op

	@@mul_or_mla:
	; Cond 0000 LUAS Rd Rn  Rs  1001 Rm
	; Rd = Rs*Rm | Rd = Rs*Rm + Rn
	mov ebx,eax
	mov ecx,eax
	mov ebp,eax

	mov edi,eax
	shr ebx,8
	and ecx,0Fh		; Rm

	and ebp,1F00000h
	and ebx,0Fh		; Rs
	shr ebp,18
	mov eax,[r0+ecx*4]
	jmp dword ptr [mul_ops + ebp]
	

	@@hword_op:	
	mov ebx,eax
	mov ecx,eax
	shr ebx,18		
	shr ecx,5		
	and ebx,07Ch		; ebx = PU0WL00
	and ecx,3		; ecx = SH
	mov edx,ebx
	or ebx,ecx		; ebx = PU0WLSH
	shr edx,1		; edx = 0PU0WL0
	and ebx,0Fh		; ebx = 000WLSH
	and edx,30h		; edx = 0PU0000 
	;or ebx,edx		; ebx = 0PUWLSH
	test eax,400000h
	jz @@hword_op_reg_offs
		mov esi,eax
		mov edi,eax
		and esi,0Fh
		shr edi,4
		and edi,0F0h
		or ebx,edx
		or esi,edi	; esi = 8bit offset
		jmp dword ptr [hword_xfer + ebx*4]
	@@hword_op_reg_offs:
		mov edi,eax
		and edi,0Fh
		or ebx,edx
		mov esi,[r0+edi*4] ; esi = offset register	
		jmp dword ptr [hword_xfer + ebx*4]


	@@type_0_bx:
		and eax,0Fh
		mov physaddr,-1
		mov ebx,[r0+eax*4]
		test ebx,1
		jz @@bx_no_switch
			mov cb_execute,OFFSET cpu_execute_until_thumb
			mov dword ptr [esp],OFFSET cpu_execute_until_thumb
			or r16,20h	; set the T bit
			and ebx,0FFFFFFFEh
		@@bx_no_switch:
		mov r15,ebx
		ADD_CYCLES 4
		ret
type_1:
	mov ebx,eax
	mov edi,eax
	mov ecx,eax
	shr ebx,20		; Get opcode
	shr ecx,16		; Get Rn
	and edi,0FFh		; Get Op2
	and ecx,0Fh
	and ebx,01Fh
	mov esi,[r0+ecx*4]

	test eax,0F00h
	jz @@type_1_no_rot
		mov ecx,eax
		shr ecx,8	; Get Op2 shift
		and ecx,0Fh
		add ecx,ecx
		ror edi,cl
		UPDATE_C
	@@type_1_no_rot:
	jmp dword ptr [data_proc_ops + ebx*4]

; Type 2 - LDR/STR Rd,[Rn],imm	
type_2:
	mov ebx,eax
	mov ecx,eax
	shr ebx,20
	mov edx,eax
	and ecx,0FFFh
	and edx,50F000h
	and ebx,01Fh
	.if edx == 10F000h
		mov physaddr,-1
	.endif
	jmp dword ptr [data_xfer + ebx*4]

; Type 3 - LDR/STR Rd,[Rn],Rm	
type_3:
	mov ebx,eax
	mov edi,eax
	mov edx,eax
	shr ebx,20
	and edi,0Fh
	and edx,50F000h
	and ebx,01Fh
	mov edi,[r0+edi*4]
	.if edx == 10F000h
		mov physaddr,-1
	.endif

	test eax,0F80h
	jz @@type_3_zero_shift
		mov ecx,eax
		and ecx,0FFFh
		shr ecx,7		; Get Rm shift
		SHIFT_OPERAND edi
		mov ecx,edi
		jmp dword ptr [data_xfer + ebx*4]
	@@type_3_zero_shift:
	SHIFT_OPERAND_ZERO edi
	mov ecx,edi
	jmp dword ptr [data_xfer + ebx*4]


; Type 4 - Block transfer
type_4:
	mov ebx,eax
	shr ebx,20
	and ebx,01Fh
	jmp dword ptr [block_xfer + ebx*4]
	
; Type 5 - Branch
type_5:
	test eax,1000000h
	jz @@no_link
		mov ebx,r15
		sub ebx,4
		mov r14,ebx
	@@no_link:
	and eax,0FFFFFFh	; Get 24-bit offset
	shl eax,8
	sar eax,6		; Shift left by 2 and sign-extend
	;add eax,4		

	mov physaddr,-1
	add r15,eax
	
	ADD_CYCLES 3
	ret

type_6:
	;DIV0
	ADD_CYCLES 1
	ret
type_7:
	;DIV0
	;ADD_CYCLES 1
	;ret
	shr eax,16
	and eax,0FFh
	jmp swi_handler	
	
.data
align 8
instr_decoder dd OFFSET type_0
	dd OFFSET type_1
	dd OFFSET type_2
	dd OFFSET type_3
	dd OFFSET type_4
	dd OFFSET type_5
	dd OFFSET type_6
	dd OFFSET type_7
.code



;######################################### THUMB emulation #########################################


op_and_thumb:
	mov eax,[r0+esi*4]
	and [r0+edi*4],eax
	UPDATE_NZ
	ADD_CYCLES 1
	ret
op_eor_thumb:
	mov eax,[r0+esi*4]
	xor [r0+edi*4],eax
	UPDATE_NZ
	ADD_CYCLES 1
	ret
op_lsl_thumb:
	mov ecx,[r0+esi*4]
	and ecx,0FFh
	jz op_lsl_thumb_zero
	cmp ecx,32
	jge op_lsl_thumb_ge_32
	shl dword ptr [r0+edi*4],cl
	UPDATE_C_FORCE
	UPDATE_NZ
	ADD_CYCLES 1
	ret
	op_lsl_thumb_zero:
	or dword ptr [r0+edi*4],0
	UPDATE_NZ
	ADD_CYCLES 1
	ret
	op_lsl_thumb_ge_32:
	jg op_lsl_thumb_gt_32
	shr dword ptr [r0+edi*4],1
	UPDATE_C_FORCE
	mov dword ptr [r0+edi*4],0
	xor ecx,ecx
	UPDATE_NZ
	ADD_CYCLES 1
	ret
	op_lsl_thumb_gt_32:
	mov [flags+4],1
	mov dword ptr [r0+edi*4],0
	xor ecx,ecx
	UPDATE_NZ
	ADD_CYCLES 1
	ret
	
op_lsr_thumb:
	mov ecx,[r0+esi*4]
	and ecx,0FFh
	jz op_lsr_thumb_zero
	cmp ecx,32
	jge op_lsr_thumb_ge_32
	shr dword ptr [r0+edi*4],cl
	UPDATE_C_FORCE
	UPDATE_NZ
	ADD_CYCLES 1
	ret
	op_lsr_thumb_zero:
	or dword ptr [r0+edi*4],0
	UPDATE_NZ
	ADD_CYCLES 1
	ret
	op_lsr_thumb_ge_32:
	jg op_lsr_thumb_gt_32
	shl dword ptr [r0+edi*4],1
	UPDATE_C_FORCE
	mov dword ptr [r0+edi*4],0
	xor ecx,ecx
	UPDATE_NZ
	ADD_CYCLES 1
	ret
	op_lsr_thumb_gt_32:
	mov [flags+4],1
	mov dword ptr [r0+edi*4],0
	xor ecx,ecx
	UPDATE_NZ
	ADD_CYCLES 1
	ret
	
op_asr_thumb:
	mov ecx,[r0+esi*4]
	and ecx,0FFh
	jz op_asr_thumb_zero
	cmp ecx,32
	jge op_asr_thumb_ge_32
	sar dword ptr [r0+edi*4],cl
	UPDATE_C_FORCE
	UPDATE_NZ
	ADD_CYCLES 1
	ret
	op_asr_thumb_zero:
	or dword ptr [r0+edi*4],0
	UPDATE_NZ
	ADD_CYCLES 1
	ret
	op_asr_thumb_ge_32:
	mov eax,[r0+edi*4]
	shl eax,1
	UPDATE_C_FORCE
	sar dword ptr [r0+edi*4],31
	UPDATE_NZ
	ADD_CYCLES 1
	ret
	
op_adc_thumb:
	mov eax,[r0+esi*4]
	cmp [flags+4],1			; Set x86 carry if ARM7 carry is set
	adc [r0+edi*4],eax
	UPDATE_FLAGS
	ADD_CYCLES 1
	ret
	
op_sbc_thumb:
	mov eax,[r0+esi*4]
	cmp [flags+4],1			; Set x86 carry if ARM7 carry is set
	cmc
	sbb [r0+edi*4],eax
	UPDATE_FLAGS_SUB
	ADD_CYCLES 1
	ret

op_ror_thumb:
	mov ecx,[r0+esi*4]
	and ecx,0FFh
	jz op_ror_thumb_zero
	cmp ecx,32
	jge op_ror_thumb_ge_32
op_ror_thumb_bypass_load:
	ror dword ptr [r0+edi*4],cl
	UPDATE_C_FORCE
	UPDATE_NZ
	ADD_CYCLES 1
	ret
	op_ror_thumb_zero:
	or dword ptr [r0+edi*4],0
	UPDATE_NZ
	ADD_CYCLES 1
	ret
	op_ror_thumb_ge_32:
	jg op_ror_thumb_gt_32
	mov eax,[r0+edi*4]
	mov ecx,eax
	shl eax,1
	UPDATE_C_FORCE
	or ecx,ecx
	UPDATE_NZ
	ADD_CYCLES 1
	ret
	op_ror_thumb_gt_32:
	and ecx,31
	jmp op_ror_thumb_bypass_load

op_tst_thumb:
	mov eax,[r0+esi*4]
	and eax,[r0+edi*4]
	UPDATE_NZ
	ADD_CYCLES 1
	ret
op_neg_thumb:
	xor ebp,ebp
	sub ebp,[r0+esi*4]
	UPDATE_FLAGS_SUB
	mov [r0+edi*4],ebp
	ADD_CYCLES 1
	ret
op_cmp_thumb:
	mov eax,[r0+edi*4]
	sub eax,[r0+esi*4]
	UPDATE_FLAGS_SUB
	ADD_CYCLES 1
	ret
op_cmn_thumb:
	mov eax,[r0+edi*4]
	add eax,[r0+esi*4]
	UPDATE_FLAGS
	ADD_CYCLES 1
	ret
op_orr_thumb:
	mov eax,[r0+esi*4]
	or [r0+edi*4],eax
	UPDATE_NZ
	ADD_CYCLES 1
	ret	
op_mul_thumb:
	mov eax,[r0+esi*4]
	imul dword ptr [r0+edi*4]
	mov [r0+edi*4],eax
	cmp eax,0
	UPDATE_NZ
	ADD_CYCLES 2
	ret		
op_bic_thumb:
	mov eax,[r0+esi*4]
	not eax
	and [r0+edi*4],eax
	UPDATE_NZ
	ADD_CYCLES 1
	ret
op_mvn_thumb:
	mov eax,[r0+esi*4]
	not eax
	mov [r0+edi*4],eax
	UPDATE_NZ
	ADD_CYCLES 1
	ret

.data	
thumb_alu_ops dd offset op_and_thumb
	dd offset op_eor_thumb
	dd offset op_lsl_thumb
	dd offset op_lsr_thumb
	dd offset op_asr_thumb
	dd offset op_adc_thumb
	dd offset op_sbc_thumb
	dd offset op_ror_thumb
	dd offset op_tst_thumb
	dd offset op_neg_thumb
	dd offset op_cmp_thumb
	dd offset op_cmn_thumb
	dd offset op_orr_thumb
	dd offset op_mul_thumb
	dd offset op_bic_thumb
	dd offset op_mvn_thumb
.code


	

; LSL Rd,Rs,#Offset5
thumb_type_00:
	mov esi,eax
	mov ecx,eax
	mov edi,eax
	and esi,38h
	and ecx,7C0h
	shr esi,1
	and edi,7
	mov esi,[r0+esi]
	shr ecx,6
	jz thumb_type_00_zero
	shl esi,cl
	UPDATE_C_FORCE
	UPDATE_NZ
	mov [r0+edi*4],esi
	ADD_CYCLES 1
	ret
	thumb_type_00_zero:
	and esi,esi
	UPDATE_NZ
	mov [r0+edi*4],esi
	ADD_CYCLES 1
	ret
	
; LSR Rd,Rs,#Offset5
thumb_type_01:
	mov esi,eax
	mov ecx,eax
	mov edi,eax
	and esi,38h
	and ecx,7C0h
	shr esi,1
	and edi,7
	mov esi,[r0+esi]
	shr ecx,6
	jz thumb_type_01_zero
	shr esi,cl
	UPDATE_C_FORCE
	UPDATE_NZ
	mov [r0+edi*4],esi
	ADD_CYCLES 1
	ret
	thumb_type_01_zero:
	shr esi,31
	xor esi,1
	mov [flags+4],esi
	xor esi,esi
	UPDATE_NZ
	mov [r0+edi*4],esi
	ADD_CYCLES 1
	ret
	

; ASR Rd,Rs,#Offset5
thumb_type_02:
	mov esi,eax
	mov ecx,eax
	mov edi,eax
	and esi,38h
	and ecx,7C0h
	shr esi,1
	and edi,7
	mov esi,[r0+esi]
	shr ecx,6
	jz thumb_type_02_zero
	sar esi,cl
	UPDATE_C_FORCE
	UPDATE_NZ
	mov [r0+edi*4],esi
	ADD_CYCLES 1
	ret
	thumb_type_02_zero:
	sar esi,31
	sete byte ptr [flags+4]
	UPDATE_NZ
	mov [r0+edi*4],esi
	ADD_CYCLES 1
	ret
	
		
; ADD/SUB Rd,Rs,Rn/#Offset3
thumb_type_03:	
	mov esi,eax
	mov edi,eax
	mov ebx,eax
	and esi,38h		; Rs
	and edi,1C0h		; Rn/Offset3
	shr esi,1
	shr edi,6
	mov esi,[r0+esi]
	test eax,400h
	jnz @@thumb_type_03_imm
	mov edi,[r0+edi*4]
	@@thumb_type_03_imm:
	and eax,7		; Rd
	shl eax,12
	test ebx,200h		; Op
	jz op_adds
	jmp op_subs

; MOV Rd,#Offset8
thumb_type_04:
	mov edi,eax
	mov ecx,eax
	shr edi,8
	and ecx,0FFh
	and edi,7
	mov [r0+edi*4],ecx	; MOV Rd,#Offset8
	or ecx,ecx
	UPDATE_NZ
	ADD_CYCLES 1
	ret

; CMP Rd,#Offset8
thumb_type_05:
	mov edi,eax
	mov ecx,eax
	shr edi,8
	and ecx,0FFh
	and edi,7
	mov eax,[r0+edi*4]
	sub eax,ecx		; CMP Rd,#Offset8
	UPDATE_FLAGS_SUB
	ADD_CYCLES 1
	ret

; ADD Rd,#Offset8
thumb_type_06:
	mov edi,eax
	mov ecx,eax
	shr edi,8
	and ecx,0FFh
	and edi,7
	add [r0+edi*4],ecx	; ADD Rd,#Offset8
	UPDATE_FLAGS
	ADD_CYCLES 1
	ret

; SUB Rd,#Offset8
thumb_type_07:
	mov edi,eax
	mov ecx,eax
	shr edi,8
	and ecx,0FFh
	and edi,7
	sub [r0+edi*4],ecx	; SUB Rd,#Offset8
	UPDATE_FLAGS_SUB
	ADD_CYCLES 1
	ret
	
; ALU ops / HiReg ops / BX
thumb_type_08:
	test eax,400h
	jnz @@thumb_hireg_op

	mov esi,eax
	mov ebx,eax
	mov edi,eax
	shr esi,3		; 000010000oooosss
	shr ebx,6		; 000000010000oooo
	and edi,7		; 0000000000000ddd
	and ebx,0Fh		; 000000000000oooo
	and esi,7		; 0000000000000sss
	jmp dword ptr [thumb_alu_ops + ebx*4]
	
	@@thumb_hireg_op:
	mov ebx,eax
	mov esi,eax
	mov edi,eax
	and ebx,300h
	mov ecx,eax
	mov edx,eax
	shr esi,3
	shr ecx,3	; H2
	shr edx,4	; H1
	and edi,7
	and ecx,8
	and esi,7
	and edx,8
	add esi,ecx
	add edi,edx
	.if ebx == 000h		; ADD Rd,Rd,Rs
		mov eax,[r0+esi*4]
		add [r0+edi*4],eax
	.elseif ebx == 100h	; CMP Rd,Rs
		mov eax,[r0+edi*4]
		cmp eax,[r0+esi*4]
		UPDATE_FLAGS_SUB
	.elseif ebx == 200h	; MOV Rd,Rs
		mov eax,[r0+esi*4]
		mov [r0+edi*4],eax
		.if edi == 15
			mov physaddr,-1
			add r15,2
		.endif
	.else			; BX Rs
		mov ebx,[r0+esi*4]
		test ebx,1
		jnz @@thumb_bx_no_switch
			;pusha
			;mov eax,r15
			;sub eax,4
			;invoke wsprintf,ADDR szBuffer,ADDR szFormat27,eax
			;invoke lstrlen,ADDR szBuffer
			;invoke WriteConsole,hout,ADDR szBuffer,eax,ADDR dummy,NULL
			;invoke wsprintf,ADDR szBuffer,ADDR szFormat22,r0,r1,r2,r3,r4,r5,r6,r7,r8,r9,r10,r11,r12,r13,r14,r15,dword ptr [flags],0
			;invoke lstrlen,ADDR szBuffer
			;invoke WriteConsole,hout,ADDR szBuffer,eax,ADDR dummy,NULL
			;popa
		
			mov cb_execute,OFFSET cpu_execute_until_arm
			mov dword ptr [esp],OFFSET cpu_execute_until_arm
			and r16,0FFFFFFDFh	; Clear the T bit
			sub ebx,2
		@@thumb_bx_no_switch:
		and ebx,0FFFFFFFEh
		add ebx,2
		mov physaddr,-1
		mov r15,ebx
		ADD_CYCLES 4
		ret		
	.endif
	ADD_CYCLES 1
	ret
	
; LDR Rd,[pc,#Offset10]
thumb_type_09:
	mov ebx,eax
	mov esi,r15
	mov edx,eax
	and ebx,0FFh
	and edx,700h
	and esi,0FFFFFFFDh
	shl ebx,2
	shr edx,8
	add esi,ebx
	RDWORD esi
	mov [r0+edx*4],eax
	ADD_CYCLES LDR_CYCLES
	ret

; STR with register offset
thumb_type_0A:
	mov ebx,eax
	mov esi,eax
	mov edi,eax
	mov ecx,eax
	and edi,7
	shr esi,3
	shr ecx,6
	and esi,7
	and ecx,7
	test eax,200h
	jnz @@thumb_type_0A_shb
	and ebx,400h
	mov edx,[r0+esi*4]
	add edx,[r0+ecx*4]
	.if ebx == 0000h	
		; STR Rd,[Rb,Ro]
		mov ebx,[r0+edi*4]
		invoke mmu_write_dword,edx,ebx
	.else
		; STRB Rd,[Rb,Ro]
		mov ebx,[r0+edi*4]
		invoke mmu_write_byte,edx,ebx
	.endif
	ADD_CYCLES STR_CYCLES
	ret

	@@thumb_type_0A_shb:	
	and ebx,0400h
	mov edx,[r0+esi*4]
	add edx,[r0+ecx*4]
	.if ebx == 0000h
		; STRH Rd,[Rb,Ro]
		mov ebx,[r0+edi*4]
		invoke mmu_write_word,edx,ebx
		ADD_CYCLES STR_CYCLES
	.else
		; LDSB Rd,[Rb,Ro]
		push edi
		invoke mmu_read_byte,edx
		movsx eax,al
		pop edi
		mov [r0+edi*4],eax
		ADD_CYCLES LDR_CYCLES
	.endif
	ret

; LDR with register offset	
thumb_type_0B:
	mov ebx,eax
	mov esi,eax
	mov edi,eax
	mov ecx,eax
	and edi,7
	shr esi,3
	shr ecx,6
	and esi,7
	and ecx,7
	test eax,200h
	jnz @@thumb_type_0B_shb
	and ebx,400h
	mov edx,[r0+esi*4]
	add edx,[r0+ecx*4]
	.if ebx == 0000h	
		; LDR Rd,[Rb,Ro]
		push edi
		invoke mmu_read_dword,edx
		pop edi
		mov [r0+edi*4],eax
	.else
		; LDRB Rd,[Rb,Ro]
		push edi
		invoke mmu_read_byte,edx
		pop edi
		and eax,0FFh
		mov [r0+edi*4],eax
	.endif
	ADD_CYCLES LDR_CYCLES
	ret
	
	@@thumb_type_0B_shb:	
	and ebx,0400h
	mov edx,[r0+esi*4]
	add edx,[r0+ecx*4]
	.if ebx == 0000h
		; LDRH Rd,[Rb,Ro]
		push edi
		invoke mmu_read_word,edx
		and eax,0FFFFh
		pop edi
		mov [r0+edi*4],eax
	.else
		; LDSH Rd,[Rb,Ro]
		push edi
		invoke mmu_read_word,edx
		movsx eax,ax
		pop edi
		mov [r0+edi*4],eax
	.endif
	ADD_CYCLES LDR_CYCLES
	ret

; STR Rd,[Rb,#Offset6]
thumb_type_0C:
	mov esi,eax
	mov edi,eax
	mov edx,eax
	and edi,7
	shr edx,4
	shr esi,3
	and edx,7Ch
	and esi,7
	mov ebx,[r0+esi*4]
	mov ecx,[r0+edi*4]
	add edx,ebx
	invoke mmu_write_dword,edx,ecx
	ADD_CYCLES STR_CYCLES
	ret

; LDR Rd,[Rb,#Offset6]	
thumb_type_0D:
	mov esi,eax
	mov edi,eax
	mov edx,eax
	and edi,7
	shr edx,4
	shr esi,3
	and edx,7Ch
	and esi,7
	mov ebx,[r0+esi*4]
	add edx,ebx
	push edi
	invoke mmu_read_dword,edx
	pop edi
	mov [r0+edi*4],eax
	ADD_CYCLES LDR_CYCLES
	ret

; STRB Rd,[Rb,#Offset6]
thumb_type_0E:
	mov esi,eax
	mov edi,eax
	mov edx,eax
	and edi,7
	shr edx,6
	shr esi,3
	and edx,1Fh
	and esi,7
	mov ebx,[r0+esi*4]
	mov ecx,[r0+edi*4]
	add edx,ebx
	invoke mmu_write_byte,edx,ecx
	ADD_CYCLES STR_CYCLES
	ret

; LDRB Rd,[Rb,#Offset6]
thumb_type_0F:
	mov esi,eax
	mov edi,eax
	mov edx,eax
	and edi,7
	shr edx,6
	shr esi,3
	and edx,1Fh
	and esi,7
	mov ebx,[r0+esi*4]
	add edx,ebx
	push edi
	invoke mmu_read_byte,edx
	and eax,0FFh
	pop edi
	mov [r0+edi*4],eax
	ADD_CYCLES LDR_CYCLES
	ret

; STRH Rd,[Rb,#Offset6]
thumb_type_10:
	mov esi,eax
	mov edi,eax
	mov edx,eax
	and edi,7
	shr edx,5
	shr esi,3
	and edx,3Eh
	and esi,7
	mov ebx,[r0+esi*4]
	mov ecx,[r0+edi*4]
	add edx,ebx
	invoke mmu_write_word,edx,ecx
	ADD_CYCLES STR_CYCLES
	ret
	
; LDRH Rd,[Rb,#Offset6]
thumb_type_11:
	mov esi,eax
	mov edi,eax
	mov edx,eax
	and edi,7
	shr edx,5
	shr esi,3
	and edx,3Eh
	and esi,7
	mov ebx,[r0+esi*4]
	push edi
	add edx,ebx
	invoke mmu_read_word,edx
	and eax,0FFFFh
	pop edi
	mov [r0+edi*4],eax	
	ADD_CYCLES LDR_CYCLES
	ret

; STR Rd,[sp,#Offset10]
thumb_type_12:
	mov ebx,eax
	mov esi,r13
	mov edx,eax
	and ebx,0FFh
	and edx,700h
	shl ebx,2
	shr edx,8
	add esi,ebx
	mov ecx,[r0+edx*4]
	invoke mmu_write_dword,esi,ecx
	ADD_CYCLES STR_CYCLES
	ret

; LDR Rd,[sp,#Offset10]
thumb_type_13:
	mov ebx,eax
	mov esi,r13
	mov edx,eax
	and ebx,0FFh
	and edx,700h
	shl ebx,2
	shr edx,8
	add esi,ebx
	RDWORD esi
	mov [r0+edx*4],eax
	ADD_CYCLES LDR_CYCLES
	ret

; Load address (PC)
thumb_type_14:
	mov ebx,eax
	mov esi,r15
	mov edx,eax
	and esi,0FFFFFFFDh
	and ebx,0FFh
	and edx,700h
	shl ebx,2
	shr edx,8
	add esi,ebx
	mov [r0+edx*4],esi
	ADD_CYCLES 1
	ret
	
; Load address (SP)
thumb_type_15:
	mov ebx,eax
	mov esi,r13
	mov edx,eax
	and ebx,0FFh
	and edx,700h
	shl ebx,2
	shr edx,8
	add esi,ebx
	mov [r0+edx*4],esi
	ADD_CYCLES 1
	ret

; Add offset to stack pointer / PUSH registers
thumb_type_16:
	test eax,400h
	jnz @@thumb_type_16_push
	mov ebx,eax
	and ebx,7Fh
	shl ebx,2
	test eax,80h
	jz @@thumb_type_16_positive
	neg ebx
	@@thumb_type_16_positive:
	add r13,ebx
	ADD_CYCLES 1
	ret

	@@thumb_type_16_push:
	mov ecx,7
	mov ebp,r13 
	shl eax,24
	jnc @@thumb_push_not_lr
		push eax
		mov edx,r14
		sub ebp,4
		push ecx
		push ebp
		invoke mmu_write_dword,ebp,edx
		pop ebp
		pop ecx
		pop eax
	@@thumb_push_not_lr:	
	@@thumb_push_loop:
		shl eax,1
		jnc @@thumb_push_no_xfer
			mov edx,[r0+ecx*4]
			push eax
			sub ebp,4
			push ecx
			push ebp
			invoke mmu_write_dword,ebp,edx
			pop ebp
			pop ecx
			pop eax
		@@thumb_push_no_xfer:
		dec ecx
		jns @@thumb_push_loop
	mov r13,ebp
	ADD_CYCLES 5
	ret
	
; POP registers
thumb_type_17:
	mov ecx,0
	mov edx,eax
	@@thumb_pop_loop:
		shr edx,1
		jnc @@thumb_pop_no_xfer
			push ecx
			push edx
			mov ebp,r13 
			invoke mmu_read_dword,ebp
			pop edx
			pop ecx
			mov [r0+ecx*4],eax
			add r13,4
		@@thumb_pop_no_xfer:
		inc ecx
		cmp ecx,8
		jne @@thumb_pop_loop
	shr edx,1
	jnc @@thumb_pop_not_pc
		mov ebp,r13 
		invoke mmu_read_dword,ebp
		add r13,4
		and eax,0FFFFFFFEh
		mov r15,eax
		mov physaddr,-1
		add r15,2
	@@thumb_pop_not_pc:
	ADD_CYCLES 5
	ret
	

; STMIA
thumb_type_18:
	mov ebx,eax
	shr ebx,8
	and ebx,7
	mov ebp,[r0+ebx*4]
	xor ecx,ecx
	@@stmia_thumb:
		shr eax,1
		jnc @@stmia_thumb_no_xfer
			push eax
			push ebx
			push ecx
			mov ebx,[r0+ecx*4]
			push ebp
			invoke mmu_write_dword,ebp,ebx
			pop ebp
			pop ecx
			pop ebx
			add ebp,4
			pop eax
		@@stmia_thumb_no_xfer:
		inc ecx
		cmp ecx,8
	jne @@stmia_thumb
	mov [r0+ebx*4],ebp
	ADD_CYCLES 5
	ret

; LDMIA
thumb_type_19:
	mov ebx,eax
	shr ebx,8
	and ebx,7
	mov ebp,[r0+ebx*4]
	xor ecx,ecx
	@@ldmia_thumb:
		shr eax,1
		jnc @@ldmia_thumb_no_xfer
			push eax
			push ebx
			push ecx
			push ebp
			invoke mmu_read_dword,ebp
			pop ebp
			pop ecx
			pop ebx
			mov [r0+ecx*4],eax
			add ebp,4
			pop eax
		@@ldmia_thumb_no_xfer:
		inc ecx
		cmp ecx,8
	jne @@ldmia_thumb
	mov [r0+ebx*4],ebp
	ADD_CYCLES 5
	ret
	
; Conditional branch
thumb_type_1A:
	mov ebx,eax
	and ebx,0F00h
	mov edx,ebx	
	shr ebx,9
	shr edx,8
	and edx,1
	xor edx,[ebx*4 + flags]
	jnz @@thumb_type_1A_cond_false	
		and eax,255
		shl eax,24
		mov physaddr,-1
		sar eax,23
		add eax,2
		add r15,eax
	@@thumb_type_1A_cond_false:
	ADD_CYCLES 3
	ret

; Conditional branch / SWI
thumb_type_1B:
	mov ebx,eax
	and ebx,0F00h
	cmp ebx,0F00h
	je @@thumb_type_1B_swi
	mov edx,ebx	
	shr ebx,9
	shr edx,8
	and edx,1
	xor edx,[ebx*4 + flags]
	jnz @@thumb_type_1B_cond_false	
		and eax,255
		shl eax,24
		mov physaddr,-1
		sar eax,23
		add eax,2
		add r15,eax
	@@thumb_type_1B_cond_false:
	ADD_CYCLES 3
	ret

	@@thumb_type_1B_swi:
	;DIV0
	and eax,0FFh
	jmp swi_handler
	

; Unconditional branch	
thumb_type_1C:		
	mov ebx,eax
	and eax,7FFh	; 11-bit offset
	shl eax,21	
	mov physaddr,-1	; Invalidate current address mapping
	sar eax,20	; Convert to 12-bit sign extended
	add eax,2	; Add 2 since the execution loop will subtract 2 from r15 at the
			; end of each iteration.
	add r15,eax
	ADD_CYCLES 3
	ret
	

thumb_type_1D:
	pusha
	invoke wsprintf,ADDR szBuffer,ADDR szFormat22,r0,r1,r2,r3,r4,r5,r6,r7,r8,r9,r10,r11,r12,r13,r14,r15,dword ptr [flags],0
	invoke lstrlen,ADDR szBuffer
	invoke WriteConsole,hout,ADDR szBuffer,eax,ADDR dummy,NULL
	popa
	DIV0

; Long branch with link HI	
thumb_type_1E:
	and eax,7FFh
	shl eax,21
	sar eax,9
	add eax,r15
	mov r14,eax
	ADD_CYCLES 1
	ret
	
; Long branch with link LO
thumb_type_1F:
	and eax,7FFh
	shl eax,1
	mov ebx,r15
	add eax,r14
	sub ebx,2
	mov physaddr,-1
	or ebx,1
	add eax,2
	mov r14,ebx
	mov r15,eax
	ADD_CYCLES 1
	ret

.data
align 16
thumb_instr_decoder dd OFFSET thumb_type_00
	dd OFFSET thumb_type_01
	dd OFFSET thumb_type_02
	dd OFFSET thumb_type_03
	dd OFFSET thumb_type_04
	dd OFFSET thumb_type_05
	dd OFFSET thumb_type_06
	dd OFFSET thumb_type_07
	dd OFFSET thumb_type_08
	dd OFFSET thumb_type_09
	dd OFFSET thumb_type_0A
	dd OFFSET thumb_type_0B
	dd OFFSET thumb_type_0C
	dd OFFSET thumb_type_0D
	dd OFFSET thumb_type_0E
	dd OFFSET thumb_type_0F
	dd OFFSET thumb_type_10
	dd OFFSET thumb_type_11
	dd OFFSET thumb_type_12
	dd OFFSET thumb_type_13
	dd OFFSET thumb_type_14
	dd OFFSET thumb_type_15
	dd OFFSET thumb_type_16
	dd OFFSET thumb_type_17
	dd OFFSET thumb_type_18
	dd OFFSET thumb_type_19
	dd OFFSET thumb_type_1A
	dd OFFSET thumb_type_1B
	dd OFFSET thumb_type_1C
	dd OFFSET thumb_type_1D
	dd OFFSET thumb_type_1E
	dd OFFSET thumb_type_1F
.code



;###################################################################################################


cpu_init PROC commlink:DWORD	
	;pusha
	

	mov eax,commlink
	mov zombie,eax

	;invoke AllocConsole
	invoke GetStdHandle,STD_OUTPUT_HANDLE
	mov hout,eax

	;popa
	mov eax,1
	ret
cpu_init ENDP


cpu_reset PROC
	pusha

	invoke zombie,ASK,MMU_READ_BYTE_CALLBACK,0,0
	mov mmu_read_byte,eax
	invoke zombie,ASK,MMU_READ_WORD_CALLBACK,0,0
	mov mmu_read_word,eax
	invoke zombie,ASK,MMU_READ_DWORD_CALLBACK,0,0
	mov mmu_read_dword,eax

	invoke zombie,ASK,MMU_WRITE_BYTE_CALLBACK,0,0
	mov mmu_write_byte,eax
	invoke zombie,ASK,MMU_WRITE_WORD_CALLBACK,0,0
	mov mmu_write_word,eax
	invoke zombie,ASK,MMU_WRITE_DWORD_CALLBACK,0,0
	mov mmu_write_dword,eax

	invoke zombie,ASK,MMU_TRANSLATE_ADDRESS_CALLBACK,0,0
	mov mmu_translate_address,eax

	invoke zombie,TELL,CPU_CYCLE_PTR,ADDR cycle,0
	
	mov eax,3000000h
	invoke mmu_translate_address,eax	
	mov IWRAM,eax

	IF USE_VRAM_SPEEDHACK EQ 1
		invoke zombie,ASK,GPU_MEMORY,0,0
		mov VRAM,eax
	ENDIF
	
	mov cb_execute,OFFSET cpu_execute_until_arm

	mov irq_cb_stack_ptr,OFFSET irq_cb_stack
	add irq_cb_stack_ptr,64*4
	
	;mov dword ptr [flags+0],01010101h
	;mov dword ptr [flags+4],01000001h

	;1,1,1,1,1,0,0,1
	mov dword ptr [flags+0],1
	mov dword ptr [flags+4],1
	mov dword ptr [flags+8],1
	mov dword ptr [flags+12],1
	mov dword ptr [flags+16],0
	mov dword ptr [flags+20],0
	mov dword ptr [flags+24],1
	
	mov dword ptr [flags_irq+0],01010101h
	mov dword ptr [flags_irq+4],01000001h
	
	mov r13,3007F00h
	mov r13_irq,3007FA0h
	
	mov physaddr,-1
	
	popa
	ret
cpu_reset ENDP


cpu_close PROC
	invoke FreeConsole
	call close_dump
	ret
cpu_close ENDP



DlgProc PROC hdlg:DWORD, msg:DWORD, wParam:DWORD, lParam:DWORD
	LOCAL hCmb:DWORD,hIRQ:DWORD

	invoke GetDlgItem,hdlg,1000
	mov hCmb,eax
	invoke GetDlgItem,hdlg,1001
	mov hIRQ,eax
	
	.if msg == WM_INITDIALOG
		invoke SetWindowLong,hdlg, DWL_USER, lParam
		
		invoke SendMessage,hCmb, CB_ADDSTRING, 0, ADDR szFreq0		
		invoke SendMessage,hCmb, CB_ADDSTRING, 0, ADDR szFreq1		
		invoke SendMessage,hCmb, CB_ADDSTRING, 0, ADDR szFreq2		
		invoke SendMessage,hCmb, CB_ADDSTRING, 0, ADDR szFreq3		
		invoke SendMessage,hCmb, CB_ADDSTRING, 0, ADDR szFreq4		
		invoke SendMessage,hCmb, CB_ADDSTRING, 0, ADDR szFreq5
		invoke SendMessage,hCmb, CB_SETCURSEL, freqSel, 0

		invoke SendMessage,hIRQ, BM_SETCHECK, irqEnabled, 0		
		
		mov eax,1
		ret
	.elseif msg == WM_COMMAND
		mov eax,wParam
		and eax,0FFFFh
		.if eax == IDOK
			invoke SendMessage,eax, CB_GETCURSEL, 0, 0
			mov freqSel,eax
			mov eax,[frequencies+eax*4]
			mov speed,eax

			invoke SendMessage,hIRQ,BM_GETCHECK,0,0
			cmp eax,BST_CHECKED
			sete byte ptr [irqEnabled]

			invoke EndDialog,hdlg, 0
			mov eax,1
			ret
		.elseif eax == IDCANCEL
			invoke EndDialog,hdlg, 1
			mov eax,0
			ret
		.endif
	.endif
	mov eax,0
	ret
DlgProc ENDP


cpu_config PROC hWnd:DWORD
	invoke DialogBoxParam,hInst,101,hWnd,ADDR DlgProc,NULL
	ret
cpu_config ENDP



cpu_set_io_handler PROC mode:DWORD,port:DWORD,pfhandler:DWORD
	push ebx

	mov eax,port
	mov ebx,pfhandler
	
	.if mode==INPUT	
		mov [inpb_handlers + eax*4],ebx
	.else
		mov [outpb_handlers + eax*4],ebx
	.endif
	
	pop ebx
	ret
cpu_set_io_handler ENDP


cpu_get PROC what:DWORD
	.if what == CPU_CYCLE_COUNT
		mov eax,cycle
	.elseif what == CPU_CYCLE_SCALING
		mov eax,CYCLE_MULTIPLIER
	.elseif what == CPU_SET_IO_CALLBACK
		mov eax,offset cpu_set_io_handler
	.elseif what == CPU_IRQ_CALLBACK
		mov eax,offset cpu_irq
	.elseif what == CPU_INPB_CALLBACK
		mov eax,offset cpu_inpb
	.elseif what == CPU_OUTPB_CALLBACK
		mov eax,offset cpu_outpb
	.elseif what == CPU_SPEED
		mov eax,speed
	.elseif what == CPU_REG_PC
		mov eax,r15
	.elseif what == CPU_REG
		mov eax,OFFSET r0
	.elseif what == 00Fh
		mov eax,OFFSET flags
	.elseif what == PLUGIN_NAME
		mov eax,offset cpuName
	.elseif what == LAST_ERROR
		mov eax,lpszError
	.endif
	ret
cpu_get ENDP


cpu_set PROC what:DWORD,param1:DWORD,param2:DWORD
	.if what == CPU_REG_PC
		mov eax,param1
		mov r15,eax
	
	.elseif what == CPU_REG_SP
		mov eax,param1
		mov r13,eax
	
	.elseif what == CPU_CYCLE_COUNT
		mov eax,param1
		mov cycle,eax
	
	.elseif what == CPU_BREAKPOINT
		mov eax,param1
		mov breakpoint,eax
	
	.elseif what == CPU_SPEED
		mov eax,param1
		mov speed,eax
		shr eax,24
		.if eax != 0
			dec eax
			mov freqSel,eax
		.endif
		
	.elseif what == CPU_IO_HANDLER
		mov eax,param1
		and param1,0FFh
		shr eax,8
		invoke cpu_set_io_handler,eax,param1,param2
	

	.elseif what == CPU_ENABLE_IRQ
		mov eax,param1
		and eax,1
		mov irqEnabled,eax
		
	.elseif what == PLUGIN_SETTING
		mov eax,param1
	.endif
	ret
cpu_set ENDP



cpu_outpb PROC port:DWORD,dat:DWORD
	push ecx
	push dword ptr dat
	mov eax,port
	call dword ptr [outpb_handlers + eax*4]
	pop ecx
	ret
cpu_outpb ENDP


cpu_inpb PROC port:DWORD
	push ecx
	mov eax,port
	call dword ptr [inpb_handlers + eax*4]
	pop ecx
	ret
cpu_inpb ENDP


cpu_irq PROC address:DWORD
	pusha
	
	cmp irqEnabled,0
	jz ime_false
	
	mov eax,04000208h
	invoke mmu_read_byte,eax
	test eax,1
	jz ime_false

	;pusha
	;mov eax,4000202h
	;invoke mmu_read_word,eax
	;and eax,0FFFFh
	;invoke wsprintf,ADDR szBuffer,ADDR szFormat25,r15,eax
	;invoke lstrlen,ADDR szBuffer
	;invoke WriteConsole,hout,ADDR szBuffer,eax,ADDR dummy,NULL
	;popa
	
	mov eax,r13
	mov ebx,r14
	mov ecx,r13_irq
	;mov edx,r14_irq
	mov edx,r15
	add edx,8
	
	mov r13_usr,eax
	mov r14_usr,ebx
	mov r13,ecx
	mov r14,edx

	mov dword ptr [subs_handler],offset op_subs_irq
	mov eax,address
	mov physaddr,-1
	mov r15,eax

	mov ebp,esp
	mov esp,irq_cb_stack_ptr
	push dword ptr cb_execute
	mov irq_cb_stack_ptr,esp
	mov esp,ebp	

	;test r16,20h
	;jz @@cpu_irq_already_arm
	;	mov cb_execute_bi,OFFSET cpu_execute_until_thumb
		mov cb_execute,OFFSET cpu_execute_until_arm
		and r16,0FFFFFFDFh
	;@@cpu_irq_already_arm:

	ime_false:
	popa
	ret
cpu_irq ENDP


cpu_execute PROC
	ret
cpu_execute ENDP


DEBUG_ARM	equ 0
DEBUG_THUMB	equ 0


.data
dump dd -1
bytesWritten dd 0
dumps dd 0
szDump db "c:\coredump.bin",0
.code

dump_state:
	pusha

	.if dump == -1
		invoke CreateFile,ADDR szDump,GENERIC_WRITE,0,0,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,0
		mov dump,eax
		;popa
		;ret
	.endif

	;mov eax,[flags+8]
	;shl eax,1
	;or eax,[flags+0]
	;shl eax,1
	;or eax,[flags+4]
	;shl eax,1
	;or eax,[flags+12]
	;xor eax,15
	;shl eax,28
	;mov ebx,r16
	;mov r17,ebx
	;or r16,eax
	;invoke WriteFile,dump,ADDR r0,17*4,ADDR bytesWritten,0
	;mov eax,r17
	;mov r16,eax

	invoke wsprintf,ADDR szBuffer,ADDR szFormat21,r0,r1,r2,r3,r12,r13,r14,r15,dword ptr [flags+4],0
	invoke lstrlen,ADDR szBuffer	
	invoke WriteFile,dump,ADDR szBuffer,eax,ADDR bytesWritten,0

	popa
	ret

close_dump:
	pusha
	.if dump != -1
		invoke CloseHandle,dump
	.endif
	popa
	ret
	
	

align 16
cpu_execute_until_arm:	; DWORD threshold 

	@@ceu_arm_entry:
	
	mov ecx,cycle
	sub r15,4
	mov physaddr,-1
	
	@@exe_loop:
		cmp ecx,[esp+36] ;threshold
		jge @@exe_done
		;mov lastCyc,ecx
		
		.if physaddr == -1
			add r15,4
			;mov eax,r15
			invoke mmu_translate_address,r15
			mov physaddr,eax
		.endif

		;.if guard <= 10
		IF DEBUG_ARM EQ 1
			.if r15 == 0800186Ch
				mov ebx,physaddr
				pusha
				invoke wsprintf,ADDR szBuffer,ADDR szFormat22,r0,r1,r2,r3,r4,r5,r6,r7,r8,r9,r10,r11,r12,r13,r14,r15,dword ptr [flags],dword ptr [ebx]
				invoke lstrlen,ADDR szBuffer
				invoke WriteConsole,hout,ADDR szBuffer,eax,ADDR dummy,NULL
				popa
			.endif
			
			;.if r15 > 3001990h
			;.if r15 < 4000000h
			;.if r15 == 80006F8h
			;	add r15,4
			;	add physaddr,4
			;.endif
			;.endif
			;call dump_state
		ENDIF
		;	inc guard
		;.endif
		
		mov ebx,physaddr
		mov eax,[ebx]

		mov edx,eax
		;mov ebx,eax
		and edx,0F0000000h
		add physaddr,4
		cmp edx,0E0000000h
		je @@cond_true
		shr edx,28
		mov ecx,edx
		and ecx,1
		shr edx,1
		;xor cl,byte ptr [edx + flags]
		xor ecx,[flags + edx*4]
		jnz @@cond_false
		@@cond_true:
			mov ebx,eax
			nop
			shr ebx,23
			add r15,8
			and ebx,1Ch
			call dword ptr [instr_decoder + ebx]
			mov ecx,cycle
			sub r15,4
			jmp @@exe_loop
			
		@@cond_false:
		ADD_CYCLES 1
		add r15,4 ; add
		mov ecx,cycle
		
		; !! Temp fix !!
		;cmp ecx,lastCyc
		jmp @@exe_loop
		mov ecx,1
	 
	@@exe_done:
	;mov cycle,ecx
	.if physaddr == -1
		add r15,4
	.endif
	popa
	
	mov eax,cycle
	ret


align 4
cpu_execute_until_thumb:
	@@ceu_thumb_entry:
	
	mov ecx,cycle
	mov physaddr,-1
	
	@@thumb_exe_loop:
		cmp ecx,[esp+36] 
		jge @@thumb_exe_done
		mov lastCyc,ecx

		.if physaddr == -1
			mov eax,r15
			invoke mmu_translate_address,eax
			mov physaddr,eax
		.endif
		mov ebx,physaddr

		IF DEBUG_THUMB EQ 1
		;.if r15 >= 0800085Eh
		;.if r15 <= 08000864h
		;.if r15 == 08000116h
		;.if r1 <= 4
		;.if guard <= 10
			;mov ebx,physaddr
			;pusha
			;invoke wsprintf,ADDR szBuffer,ADDR szFormat22,r0,r1,r2,r3,r4,r5,r6,r7,r8,r9,r10,r11,r12,r13,r14,r15,dword ptr [flags],dword ptr [ebx]
			;;invoke wsprintf,ADDR szBuffer,ADDR szFormat19,r15
			;invoke lstrlen,ADDR szBuffer
			;invoke WriteConsole,hout,ADDR szBuffer,eax,ADDR dummy,NULL
			;popa
		;	;add guard,1
		;.endif
		;.endif
		;.endif
			.if r15 == 8000228h
			mov ebx,physaddr
			pusha
			invoke wsprintf,ADDR szBuffer,ADDR szFormat21,r0,r1,r2,r3,r12,r13,r14,r15,dword ptr [flags+4],dword ptr [ebx]
			invoke lstrlen,ADDR szBuffer
			invoke WriteConsole,hout,ADDR szBuffer,eax,ADDR dummy,NULL
			popa
			.endif
			.if r15 == 8000100h
			mov ebx,physaddr
			pusha
			invoke wsprintf,ADDR szBuffer,ADDR szFormat21,r0,r1,r2,r3,r12,r13,r14,r15,dword ptr [flags+4],dword ptr [ebx]
			invoke lstrlen,ADDR szBuffer
			invoke WriteConsole,hout,ADDR szBuffer,eax,ADDR dummy,NULL
			popa
			.endif					
			;call dump_state
		ENDIF
		
		and eax,0FFFFh
		mov ax,[ebx]
		add physaddr,2
		
			mov ebx,eax
			add r15,4
			shr ebx,11 ; 13
			and ebx,31 ;7
			
			call dword ptr [thumb_instr_decoder + ebx*4]
			mov ecx,cycle
			sub r15,2
		
			cmp ecx,lastCyc
			jmp @@thumb_exe_loop
			jmp @@thumb_exe_done
			
		;@@thumb_cond_false:
		;ADD_CYCLES 1
		;add r15,4
		;mov ecx,cycle
		
		; !! Temp fix !!
		cmp ecx,lastCyc
		jne @@thumb_exe_loop
		mov ecx,1
	 
	@@thumb_exe_done:
	popa
	
	mov eax,cycle
	ret


align 8
PUBLIC cpu_execute_until
cpu_execute_until:
	pusha
	;mov eax,cb_execute
	;jmp eax
	jmp dword ptr [cb_execute]	


qwert dd 0


END LibMain
