// tablesgen.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "math.h"
#include "stdio.h"
#include "stdlib.h"
#include "string.h"

#define LOG_BITS 12
#define LIN_BITS 6
#define LOG_LIN_BITS 30

typedef  char     int8;
typedef  short    int16;
typedef  int      int32;

typedef  unsigned char  uint8;
typedef  unsigned short uint16;
typedef  unsigned int   uint32;

static uint32 lineartbl[(1 << LIN_BITS) + 1];
static uint32 logtbl[1 << LOG_BITS];

void doLog(void)
{	
	static int32 initialized = 0;
	int32 i;
	double a;
	if (initialized) return;
	initialized = 1;
	for (i = 0; i < (1 << LOG_BITS); i++)
	{
		a = (1 << LOG_LIN_BITS) / pow(2, i / (double)(1 << LOG_BITS));
		logtbl[i] = (uint32)a;
	}
	lineartbl[0] = LOG_LIN_BITS << LOG_BITS;
	for (i = 1; i < (1 << LIN_BITS) + 1; i++)
	{
		uint32 ua;
		a = i << (LOG_LIN_BITS - LIN_BITS);
		ua = (uint32)((LOG_LIN_BITS - (log(a) / log(2))) * (1 << LOG_BITS));
		lineartbl[i] = ua << 1;
	}
}

int main(int argc, char* argv[])
{
	unsigned char gamma[10][256];
	double factor,R;
	int i,j,k;
	FILE *f;
	char st[256];
	for (j=0;j<10;j++)
	for (i=0;i<32/*256*/;i++)
	{
		R=(double)i/31/*255*/;
		R=pow(R,1-(double)j/10);
		R=R*31/*255*/;
		gamma[j][i]=R;
	}
	
	f=fopen("gammatab.h","w+t");
	if (f)
	{
		fprintf(f,"unsigned char gammatab[10][32]={\n");
		for (j=0;j<10;j++)
		for (i=0;i<2/*16*/;i++)
		{			
			if (i==0) sprintf(st,"{");
			else st[0]=0;
			for (k=0;k<16;k++)
				sprintf(st,"%s0x%02X,",st,gamma[j][i*16+k]);
			if (i==1/*15*/) 
			{
				st[strlen(st)-1]=0;
				if (j==9) sprintf(st,"%s}",st);
				else sprintf(st,"%s},",st);
			}
			
			fprintf(f,"\t%s\n",st);
		}
		fprintf(f,"};\n");
		fclose(f);
	}


/*	doLog();

	f=fopen("c:\\temp\\logtab.h","w+t");
	if (f)
	{
		fprintf(f,"static uint32 lineartbl[(1 << LIN_BITS) + 1]={\n");
		for (j=0;j<((1 << LIN_BITS) + 1);j++)		
		{												
			sprintf(st,"0x%08X,",lineartbl[j]);
			if (j==(1 << LIN_BITS)) st[strlen(st)-1]=0;
			if ((j&15)==15) fprintf(f,"%s\n",st);
			else fprintf(f,"%s",st);
		}
		fprintf(f,"};\n\n");

		fprintf(f,"static uint32 logtbl[1 << LOG_BITS]={\n");
		for (j=0;j<(1 << LOG_BITS);j++)		
		{												
			sprintf(st,"0x%08X,",logtbl[j]);
			if (j==((1 << LOG_BITS)-1)) st[strlen(st)-1]=0;
			if ((j&15)==15) fprintf(f,"%s\n",st);
			else fprintf(f,"%s",st);
		}
		fprintf(f,"};\n");
		fclose(f);
	}


	f=fopen("c:\\temp\\cossintab.h","w+t");
	if (f)
	{
		fprintf(f,"static int32 fix_sin[1024]={\n");
		for (j=0;j<1024;j++)		
		{												
			sprintf(st,"%d,",int(65336*sin( (double)j*3.14159/512.0) ));
			if (j==1023) st[strlen(st)-1]=0;
			if ((j&15)==15) fprintf(f,"%s\n",st);
			else fprintf(f,"%s",st);
		}
		fprintf(f,"};\n\n");

		fprintf(f,"static int32 fix_cos[1024]={\n");
		for (j=0;j<1024;j++)		
		{												
			sprintf(st,"%d,",int(65536*cos( (double)j*3.14159/512.0) ));
			if (j==1023) st[strlen(st)-1]=0;
			if ((j&15)==15) fprintf(f,"%s\n",st);
			else fprintf(f,"%s",st);
		}
		fprintf(f,"};\n\n");

		fprintf(f,"static int32 fix_div[1024]={\n");
		for (j=0;j<1024;j++)		
		{												
			sprintf(st,"%d,",65536/(j+1));
			if (j==1023) st[strlen(st)-1]=0;
			if ((j&15)==15) fprintf(f,"%s\n",st);
			else fprintf(f,"%s",st);
		}
		fprintf(f,"};\n\n");

		
		fclose(f);
	}*/



	return 0;
}
;