#include "snes9x.h"


#define _DO_COMPRESS_ 	   


#ifdef _DO_COMPRESS_
#include "unzip.h"
#define _sf_zipname_ "gp:\\gpmm\\os9xdat.tmp"

#endif


#define _file_name_ "gp:\\gpmm\\OS9Xgp.fxe"
#define _sf_numfiles 10

#define _sp_file_buffer_ 2048


#define _credit_model_size_ 12701 //63827
#define _logo_model_size_ 12357 //53279
#define _logo_mod_size_   85790 //200690
#define _credits_mod_ 83544 //200302
#define _texture_env2_size_   2195 //8192
#define _texture_env1_size_   1760 //8192
#define _texture2_size_   6796 //8192
#define _texture1_size_   3920 //8192
#define _logo_a15d_ 62563 //153600
#define _browser_mod_ 62278 //82546 


int _sf_filesize[_sf_numfiles]=
{_credit_model_size_,
_logo_model_size_,
_logo_mod_size_,
_credits_mod_,
_texture_env2_size_,
_texture_env1_size_,
_texture2_size_,
_texture1_size_,
_logo_a15d_,
_browser_mod_
};

#ifdef _DO_COMPRESS_
int SF_LoadZIPData(int num_file,char **buffer)
{
	unz_file_info info;
	char name[256];
	unzFile file;
	F_HANDLE src,dst;	
	char *tmpbuffer;
	int err,i;
	ulong fsize,dummy;
	long l,_sf_nofs;
	
	*buffer=NULL;	
	if (num_file>=_sf_numfiles) return 1;	
	_sf_nofs=0;
	for (i=0;i<=num_file;i++) _sf_nofs+=_sf_filesize[i];

	//create zip file by extracting from fxe
	if (GpFileCreate(_sf_zipname_, ALWAYS_CREATE, &dst)!=SM_OK) return 1;		
	if (GpFileGetSize(_file_name_,&fsize)!=SM_OK) return -1;			
	if (GpFileOpen(_file_name_,OPEN_R,&src)!=SM_OK) return -1;
	
	tmpbuffer=(char*)malloc(_sp_file_buffer_);
	GpFileSeek(src,FROM_BEGIN,fsize-_sf_nofs,&l);		
	i=_sf_filesize[num_file];
	while (i>=_sp_file_buffer_)
	{
		i-=_sp_file_buffer_;
		GpFileRead(src,tmpbuffer,_sp_file_buffer_,&dummy);
		GpFileWrite(dst,tmpbuffer,_sp_file_buffer_);
	}		
	if (i)
	{
		GpFileRead(src,tmpbuffer,i,&dummy);
		GpFileWrite(dst,tmpbuffer,i);
	}
    GpFileClose(src);
    GpFileClose(dst);	
	free(tmpbuffer);
	/*********************/
	
	//read file from zip
	
	
	file = unzOpen(_sf_zipname_);
    if(file == NULL) return (FALSE);	
	if (unzGoToFirstFile(file)==UNZ_OK)
	{
		unzGetCurrentFileInfo(file, &info, name,250, NULL,0, NULL,0);
		if (unzOpenCurrentFile(file)==UNZ_OK)
		{					
			*buffer=(char*)gm_malloc(info.uncompressed_size);
			unzReadCurrentFile(file,*buffer,info.uncompressed_size);
			unzCloseCurrentFile(file);		
		}		
	}
	unzClose(file);
	
	GpFileRemove(_sf_zipname_);
	return 0;
}
#endif

int SF_LoadData(int num_file,char **buffer)
{	
#ifdef _DO_COMPRESS_ 	   
	return SF_LoadZIPData(num_file,buffer);
#else

	F_HANDLE f;
	ulong fsize,dummy;
	long l;
	long _sf_nofs;
	int err,i;
	
	if (num_file>=_sf_numfiles) return 1;
	_sf_nofs=0;
	for (i=0;i<=num_file;i++) _sf_nofs+=_sf_filesize[i];
	
	
	err=GpFileGetSize(_file_name_,&fsize);		
	if (err!=SM_OK) return -1;
	*buffer = (char*)gm_malloc(_sf_filesize[num_file]);	
	err=GpFileOpen(_file_name_,OPEN_R,&f);	
	if (err!=SM_OK) 
	{	
		gm_free(*buffer);
		return -1;
	}
	GpFileSeek(f,FROM_BEGIN,fsize-_sf_nofs,&l);
	GpFileRead(f,(char*)(*buffer),_sf_filesize[num_file],&dummy);		
    GpFileClose(f);
    

	return 0;
#endif    	
}
