#include "gpdef.h"
#include "gpstdlib.h"
#include "gpgraphic.h"
#include "gpstdio.h"

#define _DO_COMPRESS_ 	   


#ifdef _DO_COMPRESS_
#include "unzip.h"
#define _sf_zipname_ "gp:\\gpmm\\os9xdat.zip"
#endif


#define _file_name_ "gp:\\gpmm\\OS9Xgp.fxe"
#define _sf_numfiles 10



#define _credit_model_size_ 63827
#define _logo_model_size_ 53279
#define _logo_mod_size_   200690
#define _credits_mod_ 200302
#define _texture1_size_   8192
#define _texture2_size_   8192
#define _texture_env1_size_   8192
#define _texture_env2_size_   8192
#define _logo_a15d_ 153600
#define _browser_mod_ 82546 


int _sf_filesize[_sf_numfiles]=
{_credit_model_size_,
_logo_model_size_,
_logo_mod_size_,
_credits_mod_,
_texture1_size_,
_texture2_size_,
_texture_env1_size_,
_texture_env2_size_,
_logo_a15d_,
_browser_mod_
};

#ifdef _DO_COMPRESS_
char _sf_filename[_sf_numfiles][32]=
{"credits2.m3d",
"os9xgp5.m3d",
"logo.mod",
"credits.mod",
"texture1.bin",
"texture2.bin",
"textenv1.bin",
"textenv2.bin",
"splash.bin",
"browser.mod"
};


int SF_LoadZIPData(int num_file,char **buffer)
{
	unz_file_info info;
	char name[256];
	unzFile file;
	*buffer=NULL;	
	if (num_file>=_sf_numfiles) return 1;	
	file = unzOpen(_sf_zipname_);
    if(file == NULL) return (FALSE);	
	if (unzLocateFile (file, _sf_filename[num_file], 2)==UNZ_OK)
	{
		unzGetCurrentFileInfo(file, &info, name,250, NULL,0, NULL,0);
		if (unzOpenCurrentFile(file)==UNZ_OK)
		{			
			*buffer=(char*)gm_malloc(info.uncompressed_size);
			unzReadCurrentFile(file,*buffer,info.uncompressed_size);
			unzCloseCurrentFile(file);		
		}		
	}
	unzClose(file);
	return 0;
}
#endif

int SF_LoadData(int num_file,char **buffer)
{	
#ifdef _DO_COMPRESS_ 	   
	return SF_LoadZIPData(num_file,buffer);
#else

	F_HANDLE f;
	ulong fsize,dummy;
	long l;
	long _sf_nofs;
	int err,i;
	
	if (num_file>=_sf_numfiles) return 1;
	_sf_nofs=0;
	for (i=0;i<=num_file;i++) _sf_nofs+=_sf_filesize[i];
	
	
	err=GpFileGetSize(_file_name_,&fsize);		
	if (err!=SM_OK) return -1;
	*buffer = (char*)gm_malloc(_sf_filesize[num_file]);	
	err=GpFileOpen(_file_name_,OPEN_R,&f);	
	if (err!=SM_OK) 
	{	
		gm_free(*buffer);
		return -1;
	}
	GpFileSeek(f,FROM_BEGIN,fsize-_sf_nofs,&l);
	GpFileRead(f,(char*)(*buffer),_sf_filesize[num_file],&dummy);		
    GpFileClose(f);
    

	return 0;
#endif    	
}
