#ifndef __os9xgp_openspc_h__
#define __os9xgp_openspc_h__


typedef enum
{
  SPC_EMULATOR_UNKNOWN = 0,
  SPC_EMULATOR_ZSNES,
  SPC_EMULATOR_SNES9X
} SPC_EmulatorType;

typedef struct SPC_ID666
{
  char songname[33];
  char gametitle[33];
  char dumper[17];
  char comments[33];
  char author[33];
  int playtime;
  int fadetime;
  SPC_EmulatorType emulator;
} SPC_ID666;


int OSPC_Init(void);

int OSPC_Update();
int OSPC_Load(const char *fname);
void OSPC_Close(void);
void OSPC_Play(char *fname);
SPC_ID666 *OSPC_GetID666(char *buf);

#endif
