#include "snes9x.h"

#include "os9xgp_openspc.h"
#include "openspc.h"
#include "gp32_func.h"

#include "special_file.h"

extern "C"
{
#include "gfxlib.h"
#include "bioslib.h"
#include "gp32.h"
}

#define RATE 50



openspc *ospc;
char *spc_data;

extern uint8 *gp32_sndBuffer;
extern uint8 *gp32_sndBufferpos,*gp32_sndBufferend;
extern uint32 gp32_sndSz;
extern int gp32_sndFrequency;
extern char gp32_sndStereo;
extern char gp32_snd16bits;
extern int gp32_sndBuffsize;
extern volatile int gp32_sndPlaychan;
extern int *gp32_sndPlaypos;
#define __gp32_NBBUFFERS 16

uint8 *real_sndBuffer;

volatile int os9xgp_timersync_running;
volatile int os9xgp_sync_cpt;
int os9xgp_sync_real_cpt;

#include "file_dialog.h"
extern uint16 *halfval;
extern unsigned char *vrambuffer,*currentbuffer,*listbuffer[3];


void os9xgp_timersync(void)
{
	if (os9xgp_timersync_running) return;
	os9xgp_timersync_running=1;
	os9xgp_sync_cpt++;
	os9xgp_timersync_running=0;
}


void OSPC_Mix(void)
{
	ospc->run(-1,(int16*)real_sndBuffer,gp32_sndBuffsize<<gp32_snd16bits);
	
	uint16 *dst=(uint16*)gp32_sndBufferpos;
	int16  *src=(int16*)real_sndBuffer;
	
	for (int i=gp32_sndBuffsize;i;i--) 
	{		
		*dst++=(*src++)^0x8000;
	}
	
	/*uint32 mix_error=32000*1024/22050;
	uint32 mix_cur=0;
	int16  val;
	val=0;
	for (int i=gp32_sndBuffsize;i;i--) 
	{
		mix_cur+=mix_error;
		while (mix_cur>=1024)
		{
			val=*src++;//(val+*src++)>>1;
			mix_cur-=1024;
		}		
		*dst++=val^0x8000;
	}*/
		
	gp32_sndBufferpos+=gp32_sndBuffsize<<(gp32_snd16bits);
	if (gp32_sndBufferpos>=gp32_sndBufferend) 
	{
		if (gp32_sndBufferpos>gp32_sndBufferend) 
	   	{
		   	uint32 snd_posdiff;
			snd_posdiff=gp32_sndBufferpos-gp32_sndBufferend;
			gm_memcpy(gp32_sndBuffer,gp32_sndBufferend,snd_posdiff);
			gp32_sndBufferpos=gp32_sndBuffer+snd_posdiff;
		}
		else gp32_sndBufferpos=gp32_sndBuffer;
	}
}

int OSPC_Update(void)
{
	unsigned int pp,pw,dist;
	
	
	pp=((unsigned int)*gp32_sndPlaypos);
    pw=((unsigned int)gp32_sndBufferpos);
	if (pw>pp) dist=(pw-pp);
	else dist=((pw+gp32_sndSz)-pp);	  
	dist=dist>>gp32_snd16bits;
	   	   	   	   
   	if ( dist<(gp32_sndBuffsize*__gp32_NBBUFFERS/2) )   		
   	{
   		while ( dist<(gp32_sndBuffsize*__gp32_NBBUFFERS/2) )
   		{
	   		OSPC_Mix();	   	
		   	pp=((unsigned int)*gp32_sndPlaypos);
		    pw=((unsigned int)gp32_sndBufferpos);
			if (pw>pp) dist=(pw-pp);
			else dist=((pw+gp32_sndSz)-pp);	  
			dist=dist>>gp32_snd16bits;
		}	
	   	return 1;
   	}
   	return 0;
}

int OSPC_Init()
{
    int i;
    
    enum PCM_SR freq;
	enum PCM_BIT resSample;
	
    gp32_sndFrequency = 32340;//22050;
    gp32_snd16bits=1;
    gp32_sndStereo=1;
    
    gp32_sndBuffsize=(gp32_sndFrequency/RATE) << gp32_sndStereo;
    gp32_sndBuffer = (uint8*)malloc(gp32_sndBuffsize*(__gp32_NBBUFFERS<<(gp32_snd16bits))/*+4095*/);    
    gp32_sndBufferend=gp32_sndBuffer+ (gp32_sndBuffsize*(__gp32_NBBUFFERS<<(gp32_snd16bits)));
    gp32_sndSz=gp32_sndBuffsize*__gp32_NBBUFFERS<<((gp32_snd16bits));
       
    real_sndBuffer = (uint8*)malloc(gp32_sndBuffsize<<gp32_snd16bits);

    if (gp32_snd16bits) resSample=PCM_16BIT;
    else resSample= PCM_8BIT ;
    switch (gp32_sndFrequency/1000)
    {
  	case 11:if (gp32_sndStereo) freq=PCM_S11;
			   else freq=PCM_M11;
			   break;
	case 22:if (gp32_sndStereo) freq=PCM_S22;
			   else freq=PCM_M22;
			   break;
	case 32:if (gp32_sndStereo) freq=PCM_S22;
			   else freq=PCM_M22;
			   break;			   
	case 44:if (gp32_sndStereo) freq=PCM_S44;
			   else freq=PCM_M44;
			   break;			   			   
  }			   
  
  GpClockSpeedChange(90000000, 0x34021, 3);   //dirty hack to have 22Khz played at 32Khz when switch back to clockspeed 132Mhz...
  
  GpPcmInit(freq,resSample);  
  
  
  ospc=(openspc*)malloc(sizeof(openspc));
  (openspc*)ospc->openspc();
}

void OSPC_Close(void)
{
	free(spc_data);	
	ospc->~openspc();
	free(ospc);	
	free(real_sndBuffer);
	free(gp32_sndBuffer);
}

SPC_ID666 *OSPC_GetID666(char *buf)
{
  SPC_ID666 *id;
  char tmps[16];
  int i;

  id = (SPC_ID666 *)malloc(sizeof(*id));
  if (id == NULL)
    return NULL;

  
  if (buf[0x23] == 27) {  
      free(id);
      return NULL;
  }

  memcpy(id->songname,buf+0x2E,32);  
  id->songname[32] = '\0';

  memcpy(id->gametitle,buf+32+0x2E,32); 
  id->gametitle[32] = '\0';

  memcpy(id->dumper,buf+32*2+0x2E,16);
  id->dumper[16] = '\0';

  memcpy(id->dumper,buf+32*2+17+0x2E,32);  
  id->comments[32] = '\0';

  switch (buf[0xD1]) {
  case 1:
      id->emulator = SPC_EMULATOR_ZSNES;
      break;
  case 2:
      id->emulator = SPC_EMULATOR_SNES9X;
      break;
  case 0:
  default:
      id->emulator = SPC_EMULATOR_UNKNOWN;
      break;
  }

  memcpy(id->author,buf+0xB0,32);  
  id->author[32] = '\0';
  
  tmps[0]=buf[0xA9];
  tmps[1]=buf[0xAA];
  tmps[2]=buf[0xAB];
  tmps[3]=0;
  id->playtime=0;
  i=0;
  while (tmps[i])
  {
	id->playtime*=10;
  	id->playtime+=tmps[i]-'0';
  	i++;
  }
  tmps[0]=buf[0xAC];
  tmps[1]=buf[0xAD];
  tmps[2]=buf[0xAE];
  tmps[3]=buf[0xAF];
  tmps[4]=0;
  id->fadetime=0;
  while (tmps[i])
  {
	id->fadetime*=10;
  	id->fadetime+=tmps[i]-'0';
  	i++;
  }
  

  return id;
  
}

int OSPC_Load(char *fname)
{
  int err_code;
  F_HANDLE f;  
  unsigned long filesize;
  unsigned long bread;

  if (GpFileGetSize(fname, &filesize)!=SM_OK) return NULL;
  if (GpFileOpen(fname, OPEN_R, &f)!=SM_OK) return NULL;
  spc_data=(char*)malloc(filesize);
  GpFileRead(f, spc_data,filesize,&bread);
  GpFileClose(f);
  return ospc->init(spc_data,filesize);
}

void OSPC_Stop(void)
{
	GpPcmStop();
	GpTimerKill(0);
}

void OSPC_Play(char *fname)
{
    int i,j;
    char str[256];
    char *bg,*bgtmp;   
    int r,v,b,k;
    SPC_ID666 *id;
    char *emulator[3]={"Unknown","Zsnes","Snes9x"};
    
    OSPC_Init();
    if (i=OSPC_Load(fname))
    {
    	sprintf(str,"Error at SPC loading, code : %d",i);
    	S9xMessage(0,0,str);
    	gp32_pause();
    	GpAppExit();
    }
    
  
    SF_LoadData(8,&bgtmp);
    bg=(char*)malloc(320*240*2);
    
    for (i=0;i<320;i++)
	for (j=0;j<240;j++) 
	{
	   	k=((uint16*)bgtmp)[i+j*320];
	   	r=(k>>11)&31;v=(k>>6)&31;b=(k>>1)&31;
	   	r>>=1;
	   	v>>=1;
	   	b>>=1;
    	((uint16*)bg)[i*240+239-j]=(r<<11)|(v<<6)|(b<<1)|1;
	}
	free(bgtmp);
	
	halfval = (uint16*)malloc(65536*sizeof(uint16));	
	for (int i=0;i<65536;i++)
	{
		int r,v,b;
		r=((i>>11)>>2)+24;
		v=(((i>>6)&31)>>2)+24;
		b=(((i>>1)&31)>>2)+24;
		if (r>31) r=31;if (v>31) v=31;if (b>31) b=31;
		halfval[i]=(r<<11)|(v<<6)|(b<<1)|1;
	}
	gm_memcpy(vrambuffer,bg,320*240*2);
	DrawWindow2((char*)(vrambuffer), 15, 10, 320-15*2, 20 , COLOR_YELLOW,COLOR_ORANGE);	
	sprintf(str,"Playing : %s      START to exit",fname);
	gp32_GpTextOut(vrambuffer,20,18,str,(29<<11)|(20<<6)|(31<<1)|1,1);	
	DrawWindow2((char*)(vrambuffer), 15, 200, 300-15*2, 20 , COLOR_YELLOW,COLOR_ORANGE);	
	
	id=OSPC_GetID666(spc_data);
	if (id)
	{
		DrawWindow2((char*)(vrambuffer), 15, 50, 300-15*2, 100 , COLOR_YELLOW,COLOR_ORANGE);	
		sprintf(str,"Song : %s",id->songname);
		gp32_GpTextOut(vrambuffer,20,58,str,(31<<11)|(24<<6)|(16<<1)|1,1);	
		sprintf(str,"Game : %s",id->gametitle);
		gp32_GpTextOut(vrambuffer,20,58+12*1,str,(31<<11)|(24<<6)|(16<<1)|1,1);	
		sprintf(str,"Dumper : %s",id->dumper);
		gp32_GpTextOut(vrambuffer,20,58+12*2,str,(31<<11)|(24<<6)|(16<<1)|1,1);	
		sprintf(str,"Comments : %s",id->comments);
		gp32_GpTextOut(vrambuffer,20,58+12*3,str,(31<<11)|(24<<6)|(16<<1)|1,1);	
		sprintf(str,"Author : %s",id->author);
		gp32_GpTextOut(vrambuffer,20,58+12*4,str,(31<<11)|(24<<6)|(16<<1)|1,1);	
		sprintf(str,"Emulator used : %s",emulator[id->emulator]);
		gp32_GpTextOut(vrambuffer,20,58+12*5,str,(31<<11)|(24<<6)|(16<<1)|1,1);	
		sprintf(str,"Playtime : %02d:%02d / Fade : %dms",id->playtime/60,id->playtime%60,id->fadetime);
		gp32_GpTextOut(vrambuffer,20,58+12*6,str,(31<<11)|(24<<6)|(16<<1)|1,1);	
		
		free(id);
	}
	
    memcpy(currentbuffer,vrambuffer,320*240*2);
    currentbuffer = vrambuffer;		  
    vrambuffer = swapBuffer(&lcd,3/*3*/);
    memcpy(vrambuffer,currentbuffer,320*240*2);
    
    
    gm_memset(gp32_sndBuffer,0x80,gp32_sndBuffsize*(__gp32_NBBUFFERS<<(gp32_snd16bits)));
	gp32_sndBufferpos=gp32_sndBuffer+ (gp32_sndBuffsize*(__gp32_NBBUFFERS<<(gp32_snd16bits)))/2;       		
	GpPcmPlay((unsigned short*)gp32_sndBuffer, gp32_sndBuffsize*(__gp32_NBBUFFERS<<(gp32_snd16bits)),1);
	GpPcmLock((unsigned short*)gp32_sndBuffer,(int *)&gp32_sndPlaychan,(unsigned int *)&gp32_sndPlaypos);	    	    
	
	
	GpClockSpeedChange(132000000, 0x3a011, 3); 
	gp32_timermul=(67800*256/132000);

    
    os9xgp_timersync_running=0;
    os9xgp_sync_cpt=0;
    os9xgp_sync_real_cpt=0;
    GpTimerOptSet(0, (RATE*gp32_timermul>>8), 0, os9xgp_timersync);
    GpTimerSet(0);        

	
	memcpy(vrambuffer,currentbuffer,320*240*2);
    for (;;) 
    {
		i=GpKeyGet();
		if (i&GPC_VK_START) break;
		
		if ((os9xgp_sync_real_cpt&31)==0)
		{
			i=os9xgp_sync_cpt/RATE;
			sprintf(str,"%02d:%02d",i/60,i%60);
			for (i=20;i<20+5*7;i++)
			for (j=208+0;j<10+208;j++) ((int16*)vrambuffer)[i*240+239-j]=halfval[((int16*)bg)[i*240+239-j]];
			gp32_GpTextOut(vrambuffer,20,208,str,(10<<11)|(31<<6)|(5<<1)|1,1);
			currentbuffer = vrambuffer;		  
	   	    vrambuffer = swapBuffer(&lcd,3/*3*/);
	   	}   	       	    
	   	
	   	if (OSPC_Update()) os9xgp_sync_real_cpt++;
    }
    OSPC_Stop();
            
    OSPC_Close();
    
    free(halfval);
    free(bg);
}
