//#define __asm65c816cpu__
#define __fullasm65c816cpu__
//#define __showdebug__
//#define __testop__
//#define __showframe__
//#define __generatelogop__		

#define DEB_MIN_CYCLES 0
#define DEB_MAX_CYCLES 200000
#define DEB_MIN_FRAME 10


#define __debugexpr__ 0/*((CPU.PC-CPU.PCBase)==0x804A)||(S9xGetByte(0x8048)!=0x5D)*/

/*
 * Snes9x - Portable Super Nintendo Entertainment System (TM) emulator.
 *
 * (c) Copyright 1996 - 2001 Gary Henderson (gary.henderson@ntlworld.com) and
 *                           Jerremy Koot (jkoot@snes9x.com)
 *
 * Super FX C emulator code 
 * (c) Copyright 1997 - 1999 Ivar (ivar@snes9x.com) and
 *                           Gary Henderson.
 * Super FX 	assembler emulator code (c) Copyright 1998 zsKnight and _Demo_.
 *
 * DSP1 emulator code (c) Copyright 1998 Ivar, _Demo_ and Gary Henderson.
 * C4 asm and some C emulation code (c) Copyright 2000 zsKnight and _Demo_.
 * C4 C code (c) Copyright 2001 Gary Henderson (gary.henderson@ntlworld.com).
 *
 * DOS port code contains the works of other authors. See headers in
 * individual files.
 *
 * Snes9x homepage: http://www.snes9x.com
 *
 * Permission to use, copy, modify and distribute Snes9x in both binary and
 * source form, for non-commercial purposes, is hereby granted without fee,
 * providing that this license information and copyright notice appear with
 * all copies and any derived work.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event shall the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Snes9x is freeware for PERSONAL USE only. Commercial users should
 * seek permission of the copyright holders first. Commercial use includes
 * charging money for Snes9x or software derived from Snes9x.
 *
 * The copyright holders request that bug fixes and improvements to the code
 * should be forwarded to them so everyone can benefit from the modifications
 * in future versions.
 *
 * Super NES and Super Nintendo Entertainment System are trademarks of
 * Nintendo Co., Limited and its subsidiary companies.
 */
 

 
#include "snes9x.h"

#include "memmap.h"
#include "cpuops.h"
#include "ppu.h"
#include "cpuexec.h"
#include "debug.h"
#include "snapshot.h"
#include "gfx.h"
#include "missing.h"
#include "apu.h"
#include "dma.h"
//#include "fxemu.h"
#include "sa1.h"


#include "os9x_asm_cpu.h"


STREAM flogop;

void init_logop(void)
{
#ifdef __generatelogop__	
	flogop=OPEN_STREAM("gp:\\gpmm\\logop.bin","wb");
#else
	flogop=OPEN_STREAM("gp:\\logop.bin","rb");
#endif	
}

void close_logop(void)
{
	CLOSE_STREAM(flogop);
}

typedef struct {
uint8	save_PB;//	0
uint8	save_DB;//	1
uint16	save_P;//	2
uint16	save_A;//	4
uint16	save_D;//	6
uint16	save_X;//	8
uint16	save_Y;//	10
uint16	save_PC;//	12
uint16	save_S;//	14
//--------------
uint16	save_Cycles;// 16		
uint16  dummy;
} save_cpu_var_t;


save_cpu_var_t save_cpu_var;
uint16 mem_check=0;

char *S9xMnemonics[256] = {    "BRK", "ORA", "COP", "ORA", "TSB", "ORA", "ASL", "ORA",
    "PHP", "ORA", "ASL", "PHD", "TSB", "ORA", "ASL", "ORA",
    "BPL", "ORA", "ORA", "ORA", "TRB", "ORA", "ASL", "ORA",
    "CLC", "ORA", "INC", "TCS", "TRB", "ORA", "ASL", "ORA",
    "JSR", "AND", "JSL", "AND", "BIT", "AND", "ROL", "AND",
    "PLP", "AND", "ROL", "PLD", "BIT", "AND", "ROL", "AND",
    "BMI", "AND", "AND", "AND", "BIT", "AND", "ROL", "AND",
    "SEC", "AND", "DEC", "TSC", "BIT", "AND", "ROL", "AND",
    "RTI", "EOR", "DB ", "EOR", "MVP", "EOR", "LSR", "EOR",
    "PHA", "EOR", "LSR", "PHK", "JMP", "EOR", "LSR", "EOR",
    "BVC", "EOR", "EOR", "EOR", "MVN", "EOR", "LSR", "EOR",
    "CLI", "EOR", "PHY", "TCD", "JMP", "EOR", "LSR", "EOR",
    "RTS", "ADC", "PER", "ADC", "STZ", "ADC", "ROR", "ADC",
    "PLA", "ADC", "ROR", "RTL", "JMP", "ADC", "ROR", "ADC",
    "BVS", "ADC", "ADC", "ADC", "STZ", "ADC", "ROR", "ADC",
    "SEI", "ADC", "PLY", "TDC", "JMP", "ADC", "ROR", "ADC",
    "BRA", "STA", "BRL", "STA", "STY", "STA", "STX", "STA",
    "DEY", "BIT", "TXA", "PHB", "STY", "STA", "STX", "STA",
    "BCC", "STA", "STA", "STA", "STY", "STA", "STX", "STA",
    "TYA", "STA", "TXS", "TXY", "STZ", "STA", "STZ", "STA",
    "LDY", "LDA", "LDX", "LDA", "LDY", "LDA", "LDX", "LDA",
    "TAY", "LDA", "TAX", "PLB", "LDY", "LDA", "LDX", "LDA",
    "BCS", "LDA", "LDA", "LDA", "LDY", "LDA", "LDX", "LDA",
    "CLV", "LDA", "TSX", "TYX", "LDY", "LDA", "LDX", "LDA",
    "CPY", "CMP", "REP", "CMP", "CPY", "CMP", "DEC", "CMP",
    "INY", "CMP", "DEX", "WAI", "CPY", "CMP", "DEC", "CMP",
    "BNE", "CMP", "CMP", "CMP", "PEI", "CMP", "DEC", "CMP",
    "CLD", "CMP", "PHX", "STP", "JML", "CMP", "DEC", "CMP",
    "CPX", "SBC", "SEP", "SBC", "CPX", "SBC", "INC", "SBC",
    "INX", "SBC", "NOP", "XBA", "CPX", "SBC", "INC", "SBC",
    "BEQ", "SBC", "SBC", "SBC", "PEA", "SBC", "INC", "SBC",
    "SED", "SBC", "PLX", "XCE", "JSR", "SBC", "INC", "SBC"
};

int framecpt=0;
long internal_cpt=0;
long current_pos=0;

int compare_reg(void)
{
	char str[512];
	int difference;
	save_cpu_var_t save_cpu_var;
	if (current_pos<internal_cpt) 
	{
		SEEK_STREAM((internal_cpt)*20,SEEK_SET,flogop);
		current_pos=internal_cpt;
	}
	READ_STREAM(&save_cpu_var,20,flogop);		
	current_pos++;
	
	
	difference=0;

		str[0]=0;
		if (Registers.A.W!=save_cpu_var.save_A) 
		{	difference=1;sprintf(str,"%s\nA : %04X %04X",str,Registers.A.W,save_cpu_var.save_A);}
		if (Registers.X.W!=save_cpu_var.save_X) 
		{	difference=1;sprintf(str,"%s\nX : %04X %04X",str,Registers.X.W,save_cpu_var.save_X);}
		if (Registers.Y.W!=save_cpu_var.save_Y) 
		{	difference=1;sprintf(str,"%s\nY : %04X %04X",str,Registers.Y.W,save_cpu_var.save_Y);}
		if (Registers.S.W!=save_cpu_var.save_S) 
		{	difference=1;sprintf(str,"%s\nS : %04X %04X",str,Registers.S.W,save_cpu_var.save_S);}
		if (Registers.P.W!=save_cpu_var.save_P) 
		{	difference=1;sprintf(str,"%s\nP : %04X %04X",str,Registers.P.W,save_cpu_var.save_P);}
		if (Registers.D.W!=save_cpu_var.save_D) 
		{	difference=1;sprintf(str,"%s\nD : %04X %04X",str,Registers.D.W,save_cpu_var.save_D);}
		if (Registers.PB!=save_cpu_var.save_PB) 
		{	difference=1;sprintf(str,"%s\nPB : %02X %02X",str,Registers.PB,save_cpu_var.save_PB);}
		if (Registers.DB!=save_cpu_var.save_DB) 
		{	difference=1;sprintf(str,"%s\nDB : %02X %02X",str,Registers.DB,save_cpu_var.save_DB);}
		if ((CPU.PC-CPU.PCBase)!=save_cpu_var.save_PC) 
		{	difference=1;sprintf(str,"%s\nPC : %04X %04X",str,CPU.PC-CPU.PCBase,save_cpu_var.save_PC);}
		if (CPU.Cycles!=save_cpu_var.save_Cycles) 
		{   difference=1;sprintf(str,"%s\nCycles : %02X %02X",str,CPU.Cycles,save_cpu_var.save_Cycles);}
		
//		if (mem_check!=save_cpu_var.dummy) 
//		{   difference=1;sprintf(str,"%s\nMemcheck : %04X %04X",str,mem_check,save_cpu_var.dummy);}
		
		if (difference)
		{
			S9xMessage(1,70,str);
			gp32_pause();		
		}		
		return difference;
}


int oppause=0;

void S9xMainLoop (void)
{	
#ifdef PROFILING
	PROF_START(0);
#endif
	char stra[64];	
	
	framecpt++;
#if defined(__showframe__)
	sprintf(stra,"framecpt : %d",framecpt);
	S9xMessage(0,0,stra);
#endif	
#ifdef __fullasm65c816cpu__
	asm_S9xMainLoop();
#else	
    for (;;)
    {
	APU_EXECUTE ();
	if (CPU.Flags)
	{
	    if (CPU.Flags & NMI_FLAG)
	    {
			if (--CPU.NMICycleCount == 0)
			{
		    	CPU.Flags &= ~NMI_FLAG;
			    if (CPU.WaitingForInterrupt)
			    {
					CPU.WaitingForInterrupt = FALSE;
					CPU.PC++;
			    }
			    S9xOpcode_NMI ();
			}
	    }

	    if (CPU.Flags & IRQ_PENDING_FLAG)
	    {
			if (CPU.IRQCycleCount == 0)
			{
		    	if (CPU.WaitingForInterrupt)
			    {
					CPU.WaitingForInterrupt = FALSE;
					CPU.PC++;
			    }
		    	if (CPU.IRQActive && !Settings.DisableIRQ)
			    {
					if (!CheckFlag (IRQ))
					    S9xOpcode_IRQ ();
			    }
			    else
					CPU.Flags &= ~IRQ_PENDING_FLAG;
			}
			else
			    CPU.IRQCycleCount--;
	    }
	    if (CPU.Flags & SCAN_KEYS_FLAG)	    
			break;		
	}

#ifdef PROFILING
    PROF_START(1);
#endif

	int y=0;
	
	if ((CPU.Cycles>=DEB_MIN_CYCLES)&&(CPU.Cycles<=DEB_MAX_CYCLES)&&(framecpt>=DEB_MIN_FRAME)
	) 
	{
		int sCy=CPU.Cycles;
		uint16 smem=mem_check;
		oppause=1;
		
/*		if ((CPU.PC-CPU.PCBase)>=0x8030) oppause=1;
		else
		{
		for (int i=-3;i<=3;i++)
		  if (S9xGetByte(Registers.S.W+i)==0xF0) {oppause=1;break;}
		 }*/
	    CPU.Cycles=sCy;
	    mem_check=smem;
	}
#ifdef __showdebug__		
	char str[512];
	
	S9xPackStatus();

	if (oppause)
	{
	int sCy=CPU.Cycles;
	uint16 smem=mem_check;
	sprintf(str,"opcode : %02X/ %s parm : %02X %02X %02X\nA=%04X X=%04X Y=%04X\nP=%04X D=%04X S=%04X\nPB=%02X DB=%02X\nCycles=%d Memspeed=%d PC=%04X BRCH=%d\nframe %d / %02X %02X %02X s%02X %02X %02X %02X",*CPU.PC,S9xMnemonics[*CPU.PC],CPU.PC[1],CPU.PC[2],CPU.PC[3],
	Registers.A.W,Registers.X.W,Registers.Y.W,Registers.P.W,
	Registers.D.W,Registers.S.W,Registers.PB,Registers.DB,
	sCy,CPU.MemSpeed,CPU.PC-CPU.PCBase,CPU.BranchSkip,framecpt,
	S9xGetByte(Registers.S.W+3),S9xGetByte(Registers.S.W+2),S9xGetByte(Registers.S.W+1),
	S9xGetByte(Registers.S.W),
	S9xGetByte(Registers.S.W-1),S9xGetByte(Registers.S.W-2),S9xGetByte(Registers.S.W-3));	
	S9xMessage(0,0,str);	
	gp32_pause();
	CPU.Cycles=sCy;
	mem_check=smem;
	}
#endif	


	{		
		char str[512];
#ifdef __testop__		
		if (oppause)
		{		
			int sCy=CPU.Cycles;
			uint16 smem=mem_check;
			S9xPackStatus();
			sprintf(str,"opcode : %02X / %s param %02X %02X %02X\nA=%04X X=%04X Y=%04X\nP=%04X D=%04X S=%04X\nPB=%02X DB=%02X\nCycles=%d Memspeed=%d PC=%04X BRCH=%d\nframe %d / %02X %02X %02X s%02X %02X %02X %02X\nPCx=%04X PCB=%04X",*CPU.PC,S9xMnemonics[*CPU.PC],CPU.PC[1],CPU.PC[2],CPU.PC[3],
				Registers.A.W,Registers.X.W,Registers.Y.W,Registers.P.W,
				Registers.D.W,Registers.S.W,Registers.PB,Registers.DB,
				sCy,CPU.MemSpeed,CPU.PC-CPU.PCBase,CPU.BranchSkip,framecpt,
				S9xGetByte(Registers.S.W+3),S9xGetByte(Registers.S.W+2),S9xGetByte(Registers.S.W+1),
				S9xGetByte(Registers.S.W),
				S9xGetByte(Registers.S.W-1),S9xGetByte(Registers.S.W-2),S9xGetByte(Registers.S.W-3),
				CPU.PC-Memory.ROM,CPU.PCBase-Memory.ROM);
			CPU.Cycles=sCy;
			mem_check=smem;
		}
#endif			
#ifdef __asm65c816cpu__
		test_opcode(&CPU);
		S9xUnpackStatus();
#else		
	#ifdef CPU_SHUTDOWN
		CPU.PCAtOpcodeStart = CPU.PC;
	#endif
		CPU.Cycles += CPU.MemSpeed;
		(*ICPU.S9xOpcodes [*CPU.PC++].S9xOpcode) ();
		
#endif		
#ifdef __generatelogop__		
		S9xPackStatus();
		save_cpu_var.save_PB=(uint8)Registers.PB;
		save_cpu_var.save_DB=(uint8)Registers.DB;
		save_cpu_var.save_P=(uint16)Registers.P.W;
				
		save_cpu_var.save_A=(uint16)Registers.A.W;
		save_cpu_var.save_D=(uint16)Registers.D.W;
		save_cpu_var.save_S=(uint16)Registers.S.W;
		save_cpu_var.save_X=(uint16)Registers.X.W;
		save_cpu_var.save_Y=(uint16)Registers.Y.W;
		save_cpu_var.save_PCBase=(uint32)CPU.PCBase;
		save_cpu_var.save_PC=(uint32)CPU.PC;
		save_cpu_var.save_Cycles=CPU.Cycles;
		save_cpu_var.save_MemSpeed=CPU.MemSpeed;
						
		WRITE_STREAM(&save_cpu_var,28,flogop);
#endif
#ifdef __testop__
		S9xPackStatus();
		if (oppause)
		{	
			int sCy=CPU.Cycles;	
			uint16 smem=mem_check;
			int res=__debugexpr__;
			CPU.Cycles=sCy;
			mem_check=smem;
			if (compare_reg()||res)
			{		
				sCy=CPU.Cycles;			
				smem=mem_check;
				S9xMessage(0,0,str);	
				gp32_pause();
				sprintf(str,"opcode : %02X / %s param %02X %02X %02X\nA=%04X X=%04X Y=%04X\nP=%04X D=%04X S=%04X\nPB=%02X DB=%02X\nCycles=%d Memspeed=%d PC=%04X BRCH=%d\nframe %d / %02X %02X %02X s%02X %02X %02X %02X\nPCx=%04X PCB=%04X",*CPU.PC,S9xMnemonics[*CPU.PC],CPU.PC[1],CPU.PC[2],CPU.PC[3],
					Registers.A.W,Registers.X.W,Registers.Y.W,Registers.P.W,
					Registers.D.W,Registers.S.W,Registers.PB,Registers.DB,
					sCy,CPU.MemSpeed,CPU.PC-CPU.PCBase,CPU.BranchSkip,framecpt,
					S9xGetByte(Registers.S.W+3),S9xGetByte(Registers.S.W+2),S9xGetByte(Registers.S.W+1),
					S9xGetByte(Registers.S.W),
					S9xGetByte(Registers.S.W-1),S9xGetByte(Registers.S.W-2),S9xGetByte(Registers.S.W-3),
					CPU.PC-Memory.ROM,CPU.PCBase-Memory.ROM);
				CPU.Cycles=sCy;
				mem_check=smem;
				S9xMessage(1,160,str);	
				gp32_pause();
			}
		}
		internal_cpt++;
		y=120;
#endif			
	}

#ifdef __showdebug__	
	if (oppause)
	{
		int sCy=CPU.Cycles;
		uint16 smem=mem_check;		
		S9xPackStatus();
		sprintf(str,"result\n%02X\nA=%04X X=%04X Y=%04X\nP=%04X D=%04X S=%04X\nPB=%02X DB=%02X\nCycles=%d Memspeed=%d PC=%04X BRCH=%d\n%02X %02X %02X s%02X %02X %02X %02X",*CPU.PC,
			Registers.A.W,Registers.X.W,Registers.Y.W,Registers.P.W,
			Registers.D.W,Registers.S.W,Registers.PB,Registers.DB,
			sCy,CPU.MemSpeed,CPU.PC-CPU.PCBase,CPU.BranchSkip,
			S9xGetByte(Registers.S.W+3),S9xGetByte(Registers.S.W+2),S9xGetByte(Registers.S.W+1),
			S9xGetByte(Registers.S.W),
			S9xGetByte(Registers.S.W-1),S9xGetByte(Registers.S.W-2),S9xGetByte(Registers.S.W-3));
		CPU.Cycles=sCy;
		mem_check=smem;
		S9xMessage(1,y,str);
		gp32_pause();	
	 }
#endif	
	
	
#ifdef PROFILING
    PROF_END(1);
#endif	
	
	if (SA1.Executing)
	    S9xSA1MainLoop ();
	DO_HBLANK_CHECK();
    }
#endif    
    
    Registers.PC = CPU.PC - CPU.PCBase;
    S9xPackStatus ();
    APURegisters.PC = IAPU.PC - IAPU.RAM;
    S9xAPUPackStatus ();
    
    if (CPU.Flags & SCAN_KEYS_FLAG)
    {
#ifdef PROFILING
    PROF_START(2);
#endif
	    S9xSyncSpeed ();
#ifdef PROFILING
    PROF_END(2);
#endif	    
	CPU.Flags &= ~SCAN_KEYS_FLAG;
    }
    
    if (CPU.BRKTriggered && Settings.SuperFX && !CPU.TriedInterleavedMode2)
    {
	CPU.TriedInterleavedMode2 = TRUE;
	CPU.BRKTriggered = FALSE;
	S9xDeinterleaveMode2 ();
    }
    
#ifdef PROFILING
    PROF_END(0);
#endif
}

void S9xSetIRQ (uint32 source)
{
    CPU.IRQActive |= source;
    CPU.Flags |= IRQ_PENDING_FLAG;
    CPU.IRQCycleCount = 3;
    if (CPU.WaitingForInterrupt)
    {
	// Force IRQ to trigger immediately after WAI - 
	// Final Fantasy Mystic Quest crashes without this.
	CPU.IRQCycleCount = 0;
	CPU.WaitingForInterrupt = FALSE;
	CPU.PC++;
    }
}

void S9xClearIRQ (uint32 source)
{
    CLEAR_IRQ_SOURCE (source);
}

void S9xDoHBlankProcessing ()
{
#ifdef CPU_SHUTDOWN
    CPU.WaitCounter++;
#endif
    switch (CPU.WhichEvent)
    {
    case HBLANK_START_EVENT:
	if (IPPU.HDMA && CPU.V_Counter <= PPU.ScreenHeight)
	    IPPU.HDMA = S9xDoHDMA (IPPU.HDMA);

	break;

    case HBLANK_END_EVENT:
//	S9xSuperFXExec ();

#ifndef STORM
	if (Settings.SoundSync)
	    S9xGenerateSound ();
#endif

	CPU.Cycles -= Settings.H_Max;
	if (/*IAPU.APUExecuting*/CPU.APU_APUExecuting)
	    APU.Cycles -= Settings.H_Max;
	else
	    APU.Cycles = 0;

	CPU.NextEvent = -1;
	ICPU.Scanline++;

	if (++CPU.V_Counter > (Settings.PAL ? SNES_MAX_PAL_VCOUNTER : SNES_MAX_NTSC_VCOUNTER))
	{
	    PPU.OAMAddr = PPU.SavedOAMAddr;
	    PPU.OAMFlip = 0;
	    CPU.V_Counter = 0;
	    CPU.NMIActive = FALSE;
	    ICPU.Frame++;
	    PPU.HVBeamCounterLatched = 0;
	    CPU.Flags |= SCAN_KEYS_FLAG;
	    S9xStartHDMA ();
	}

	if (PPU.VTimerEnabled && !PPU.HTimerEnabled &&
	    CPU.V_Counter == PPU.IRQVBeamPos)
	{
	    S9xSetIRQ (PPU_V_BEAM_IRQ_SOURCE);
	}

	if (CPU.V_Counter == PPU.ScreenHeight + FIRST_VISIBLE_LINE)
	{
	    // Start of V-blank
	    S9xEndScreenRefresh ();
	    PPU.FirstSprite = 0;
	    IPPU.HDMA = 0;
	    // Bits 7 and 6 of $4212 are computed when read in S9xGetPPU.
	    missing.dma_this_frame = 0;
	    IPPU.MaxBrightness = PPU.Brightness;
	    PPU.ForcedBlanking = (Memory.FillRAM [0x2100] >> 7) & 1;

	    Memory.FillRAM[0x4210] = 0x80;
	    if (Memory.FillRAM[0x4200] & 0x80)
	    {
		CPU.NMIActive = TRUE;
		CPU.Flags |= NMI_FLAG;
		CPU.NMICycleCount = CPU.NMITriggerPoint;
	    }

#ifdef OLD_SNAPSHOT_CODE
	    if (CPU.Flags & SAVE_SNAPSHOT_FLAG)
	    {
		CPU.Flags &= ~SAVE_SNAPSHOT_FLAG;
		Registers.PC = CPU.PC - CPU.PCBase;
		S9xPackStatus ();
		S9xAPUPackStatus ();
		Snapshot (NULL);
	    }
#endif
        }

	if (CPU.V_Counter == PPU.ScreenHeight + 3)
	    S9xUpdateJoypads ();

	if (CPU.V_Counter == FIRST_VISIBLE_LINE)
	{
	    Memory.FillRAM[0x4210] = 0;
	    CPU.Flags &= ~NMI_FLAG;
	    S9xStartScreenRefresh ();
	}
	if (CPU.V_Counter >= FIRST_VISIBLE_LINE &&
	    CPU.V_Counter < PPU.ScreenHeight + FIRST_VISIBLE_LINE)
	{
	    RenderLine (CPU.V_Counter - FIRST_VISIBLE_LINE);
	}
	// Use TimerErrorCounter to skip update of SPC700 timers once
	// every 128 updates. Needed because this section of code is called
	// once every emulated 63.5 microseconds, which coresponds to
	// 15.750KHz, but the SPC700 timers need to be updated at multiples
	// of 8KHz, hence the error correction.
//	IAPU.TimerErrorCounter++;
//	if (IAPU.TimerErrorCounter >= )
//	    IAPU.TimerErrorCounter = 0;
//	else
	{
	    if (APU.TimerEnabled [2])
	    {
		APU.Timer [2] += 4;
		while (APU.Timer [2] >= APU.TimerTarget [2])
		{
		    IAPU.RAM [0xff] = (IAPU.RAM [0xff] + 1) & 0xf;
		    APU.Timer [2] -= APU.TimerTarget [2];
#ifdef SPC700_SHUTDOWN		
		    IAPU.WaitCounter++;
		    /*IAPU.APUExecuting*/CPU.APU_APUExecuting= TRUE;
#endif		
		}
	    }
	    if (CPU.V_Counter & 1)
	    {
		if (APU.TimerEnabled [0])
		{
		    APU.Timer [0]++;
		    if (APU.Timer [0] >= APU.TimerTarget [0])
		    {
			IAPU.RAM [0xfd] = (IAPU.RAM [0xfd] + 1) & 0xf;
			APU.Timer [0] = 0;
#ifdef SPC700_SHUTDOWN		
			IAPU.WaitCounter++;
			/*IAPU.APUExecuting*/CPU.APU_APUExecuting = TRUE;
#endif		    
		    }
		}
		if (APU.TimerEnabled [1])
		{
		    APU.Timer [1]++;
		    if (APU.Timer [1] >= APU.TimerTarget [1])
		    {
			IAPU.RAM [0xfe] = (IAPU.RAM [0xfe] + 1) & 0xf;
			APU.Timer [1] = 0;
#ifdef SPC700_SHUTDOWN		
			IAPU.WaitCounter++;
			/*IAPU.APUExecuting*/CPU.APU_APUExecuting = TRUE;
#endif		    
		    }
		}
	    }
	}
	break;
    case HTIMER_BEFORE_EVENT:
    case HTIMER_AFTER_EVENT:
	if (PPU.HTimerEnabled &&
	    (!PPU.VTimerEnabled || CPU.V_Counter == PPU.IRQVBeamPos))
	{
	    S9xSetIRQ (PPU_H_BEAM_IRQ_SOURCE);
	}
	break;
    }
    S9xReschedule ();
}
