		AREA		ppuasm8, CODE, READONLY
		EXPORT		asmDrawTile8


		EXPORT		asmDrawTileClipped8


	;;R12 = OfsGP32 (ram video)
	;;R11 = Cache Pixel
	;;R10 = Cache Header
	;;R9  = Ofs jumptable
	;;R8  = Column counter
	;;R7  = 240 (ofsgp32 adder)
	;;R6  = Clipping value to add to header value


		MACRO
$label		NEXT_COL8
		subs		R8,R8,#1
		ldrneb		R0,[R10],#1
		addne		R12,R12,R7
		orrne		R0,R0,R6
		ldrne		PC,[R9,R0,lsl #2]
		ldmfd		R13!,{R4-R11}
		mov			PC,LR
		MEND


		MACRO
$label		INIT_TILER8
		and		R0,R12,#3
		cmp		R0,#0
		bne		%f10		;not_aligned8_A
		cmp		R3,#0
		bne		%f01		;flip_not0_aligned8
		ldr		R9,= jumptable_ppu800
		ldrb	R0,[R10],#1
		orr		R0,R0,R6
		ldr		R7, = 248
		ldr		PC,[R9,R0,lsl #2]
01		;flip_not0_aligned8
		cmp		R3,#1
		bne		%f02		;flip_not1_aligned8
		ldr		R9,= jumptable_ppu811
		ldrb	R0,[R10],#1
		orr		R0,R0,R6
		ldr		R7, = 232
		sub		R12,R12,#7
		ldr		PC,[R9,R0,lsl #2]
02		;flip_not1_aligned8
		cmp		R3,#2
		bne		%f03		;flip_not2_aligned8
		ldr		R9,= jumptable_ppu800
		ldrb	R0,[R10],#1
		orr		R0,R0,R6
		ldr		R7, = -232
		ldr		PC,[R9,R0,lsl #2]
03		;flip_not2_aligned8
		ldr		R9,= jumptable_ppu811
		ldrb	R0,[R10],#1
		orr		R0,R0,R6
		ldr		R7, = -248
		sub		R12,R12,#7
		ldr		PC,[R9,R0,lsl #2]
10		;not_aligned8_A
		cmp		R0,#1
		bne		%f20		;not_aligned8_B
		cmp		R3,#0
		bne		%f11		;flip_not0_not_aligned8_A
		ldr		R9,= jumptable_ppu801
		ldrb	R0,[R10],#1
		orr		R0,R0,R6
		ldr		R7, = 248
		ldr		PC,[R9,R0,lsl #2]
11		;flip_not0_not_aligned8_A
		cmp		R3,#1
		bne		%f12		;flip_not1_not_aligned8_A
		ldr		R9,= jumptable_ppu812
		ldrb	R0,[R10],#1
		orr		R0,R0,R6
		ldr		R7, = 232
		sub		R12,R12,#7
		ldr		PC,[R9,R0,lsl #2]
12		;flip_not1_not_aligned8_A
		cmp		R3,#2
		bne		%f13		;flip_not2_not_aligned8_A
		ldr		R9,= jumptable_ppu801
		ldrb	R0,[R10],#1
		orr		R0,R0,R6
		ldr		R7, = -232
		ldr		PC,[R9,R0,lsl #2]
13		;flip_not2_not_aligned8_A
		ldr		R9,= jumptable_ppu812
		ldrb	R0,[R10],#1
		orr		R0,R0,R6
		ldr		R7, = -248
		sub		R12,R12,#7
		ldr		PC,[R9,R0,lsl #2]
20		;not_aligned8_B
		cmp		R0,#2
		bne		%f30		;not_aligned8_C
		cmp		R3,#0
		bne		%f21		;flip_not0_not_aligned8_B
		ldr		R9,= jumptable_ppu802
		ldrb	R0,[R10],#1
		orr		R0,R0,R6
		ldr		R7, = 248
		ldr		PC,[R9,R0,lsl #2]
21		;flip_not0_not_aligned8_B
		cmp		R3,#1
		bne		%f22		;flip_not1_not_aligned8_B
		ldr		R9,= jumptable_ppu813
		ldrb	R0,[R10],#1
		orr		R0,R0,R6
		ldr		R7, = 232
		sub		R12,R12,#7
		ldr		PC,[R9,R0,lsl #2]
22		;flip_not1_not_aligned8_B
		cmp		R3,#2
		bne		%f23		;flip_not2_not_aligned8_B
		ldr		R9,= jumptable_ppu802
		ldrb	R0,[R10],#1
		orr		R0,R0,R6
		ldr		R7, = -232
		ldr		PC,[R9,R0,lsl #2]
23		;flip_not2_not_aligned8_B
		ldr		R9,= jumptable_ppu813
		ldrb	R0,[R10],#1
		orr		R0,R0,R6
		ldr		R7, = -248
		sub		R12,R12,#7
		ldr		PC,[R9,R0,lsl #2]
30		;not_aligned8_C
		cmp		R3,#0
		bne		%f31		;flip_not0_not_aligned8_C
		ldr		R9,= jumptable_ppu803
		ldrb	R0,[R10],#1
		orr		R0,R0,R6
		ldr		R7, = 248
		ldr		PC,[R9,R0,lsl #2]
31		;flip_not0_not_aligned8_C
		cmp		R3,#1
		bne		%f32		;flip_not1_not_aligned8_C
		ldr		R9,= jumptable_ppu810
		ldrb	R0,[R10],#1
		orr		R0,R0,R6
		ldr		R7, = 232
		sub		R12,R12,#7
		ldr		PC,[R9,R0,lsl #2]
32		;flip_not1_not_aligned8_C
		cmp		R3,#2
		bne		%f33		;flip_not2_not_aligned8_C
		ldr		R9,= jumptable_ppu803
		ldrb	R0,[R10],#1
		orr		R0,R0,R6
		ldr		R7, = -232
		ldr		PC,[R9,R0,lsl #2]
33		;flip_not2_not_aligned8_C
		ldr		R9,= jumptable_ppu810
		ldrb	R0,[R10],#1
		orr		R0,R0,R6
		ldr		R7, = -248
		sub		R12,R12,#7
		ldr		PC,[R9,R0,lsl #2]
		MEND


;;main funcs
asmDrawTile8	PROC
;; asmDrawTile( cache,solidbuf,OffsetGP32,Flip) 
;;               R0    R1       R2         R3 
;; Flip : 0,1,2,3 -> None,VFLIP,HFLIP,VFLIP&HFLIP 
		stmfd		R13!,{R4-R11}
		mov		R12,R2
		mov		R10,R0
		add		R11,R0,#8
		mov		R8,#8
		mov		R6,R1
		INIT_TILER8
	ENDP

asmDrawTileClipped8	PROC
		;; asmDrawTileClipped( cache,start<<16 width<<8 solidbuf,OffsetGP32,Flip) 
		;;                      R0             R1                 R2         R3 
		;; Flip : 0,1,2,3 -> None,VFLIP,HFLIP,VFLIP&HFLIP 

		stmfd		R13!,{R4-R11}
		mov		R12,R2
		mov		R10,R0
		add		R11,R0,#8

		mov		R0,R1,lsr #8
		and		R8,R0,#0xFF				
		mov		R0,R0,lsr #8			
		add		R10,R10,R0
		add		R11,R11,R0,lsl #3

		and		R6,R1,#0xFF

		INIT_TILER8
		ENDP

	LTORG


PPU8_00_0_0
;;case 00000000
;;mode : 00000000 => first pix:0
	;;Pos : 0, Pix opaque : 8, Pix transp : 0
		ldmia	R11!,{R0,R1}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		strb	R1,[R12],#-1
		mov		R1,R1,lsr #8
		strb	R1,[R12],#-1
		mov		R1,R1,lsr #8
		strb	R1,[R12],#-1
		mov		R1,R1,lsr #8
		strb	R1,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_01_0_0
;;case 00000001
;;mode : 00000001 => first pix:0
	;;Pos : 0, Pix opaque : 7, Pix transp : 1
		ldmia	R11!,{R0,R1}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		strb	R1,[R12],#-1
		mov		R1,R1,lsr #8
		strb	R1,[R12],#-1
		mov		R1,R1,lsr #8
		strb	R1,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_02_0_0
;;case 00000010
;;mode : 00000010 => first pix:0
	;;Pos : 0, Pix opaque : 6, Pix transp : 1
		ldmia	R11,{R0,R1}
		add		R11,R11,#7
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		strb	R1,[R12],#-1
		mov		R1,R1,lsr #8
		strb	R1,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_03_0_0
;;case 00000011
;;mode : 00000011 => first pix:0
	;;Pos : 0, Pix opaque : 6, Pix transp : 2
		ldmia	R11,{R0,R1}
		add		R11,R11,#8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		strb	R1,[R12],#-1
		mov		R1,R1,lsr #8
		strb	R1,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_04_0_0
;;case 00000100
;;mode : 00000100 => first pix:0
	;;Pos : 0, Pix opaque : 5, Pix transp : 1
		ldmia	R11,{R0,R1}
		add		R11,R11,#6
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		strb	R1,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_05_0_0
;;case 00000101
;;mode : 00000101 => first pix:0
	;;Pos : 0, Pix opaque : 5, Pix transp : 1
		ldmia	R11,{R0,R1}
		add		R11,R11,#6
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		strb	R1,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_06_0_0
;;case 00000110
;;mode : 00000110 => first pix:0
	;;Pos : 0, Pix opaque : 5, Pix transp : 2
		ldmia	R11,{R0,R1}
		add		R11,R11,#7
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		strb	R1,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_07_0_0
;;case 00000111
;;mode : 00000111 => first pix:0
	;;Pos : 0, Pix opaque : 5, Pix transp : 3
		ldmia	R11,{R0,R1}
		add		R11,R11,#8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		strb	R1,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_08_0_0
;;case 00001000
;;mode : 00001000 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_09_0_0
;;case 00001001
;;mode : 00001001 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_0A_0_0
;;case 00001010
;;mode : 00001010 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_0B_0_0
;;case 00001011
;;mode : 00001011 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_0C_0_0
;;case 00001100
;;mode : 00001100 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#6
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_0D_0_0
;;case 00001101
;;mode : 00001101 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#6
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_0E_0_0
;;case 00001110
;;mode : 00001110 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 3
		ldmia	R11,{R0}
		add		R11,R11,#7
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_0F_0_0
;;case 00001111
;;mode : 00001111 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 4
		ldmia	R11,{R0}
		add		R11,R11,#8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-5
		NEXT_COL8
;;----------------------------------------

PPU8_10_0_0
;;case 00010000
;;mode : 00010000 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_11_0_0
;;case 00010001
;;mode : 00010001 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_12_0_0
;;case 00010010
;;mode : 00010010 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_13_0_0
;;case 00010011
;;mode : 00010011 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_14_0_0
;;case 00010100
;;mode : 00010100 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_15_0_0
;;case 00010101
;;mode : 00010101 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_16_0_0
;;case 00010110
;;mode : 00010110 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_17_0_0
;;case 00010111
;;mode : 00010111 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_18_0_0
;;case 00011000
;;mode : 00011000 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_19_0_0
;;case 00011001
;;mode : 00011001 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_1A_0_0
;;case 00011010
;;mode : 00011010 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_1B_0_0
;;case 00011011
;;mode : 00011011 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_1C_0_0
;;case 00011100
;;mode : 00011100 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 3
		ldmia	R11,{R0}
		add		R11,R11,#6
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-4
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_1D_0_0
;;case 00011101
;;mode : 00011101 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 3
		ldmia	R11,{R0}
		add		R11,R11,#6
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-4
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_1E_0_0
;;case 00011110
;;mode : 00011110 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 4
		ldmia	R11,{R0}
		add		R11,R11,#7
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-5
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_1F_0_0
;;case 00011111
;;mode : 00011111 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 5
		ldmia	R11,{R0}
		add		R11,R11,#8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-6
		NEXT_COL8
;;----------------------------------------

PPU8_20_0_0
;;case 00100000
;;mode : 00100000 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 5, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_21_0_0
;;case 00100001
;;mode : 00100001 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 4, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_22_0_0
;;case 00100010
;;mode : 00100010 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_23_0_0
;;case 00100011
;;mode : 00100011 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 3, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_24_0_0
;;case 00100100
;;mode : 00100100 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_25_0_0
;;case 00100101
;;mode : 00100101 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_26_0_0
;;case 00100110
;;mode : 00100110 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_27_0_0
;;case 00100111
;;mode : 00100111 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 2, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_28_0_0
;;case 00101000
;;mode : 00101000 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_29_0_0
;;case 00101001
;;mode : 00101001 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_2A_0_0
;;case 00101010
;;mode : 00101010 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_2B_0_0
;;case 00101011
;;mode : 00101011 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_2C_0_0
;;case 00101100
;;mode : 00101100 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_2D_0_0
;;case 00101101
;;mode : 00101101 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_2E_0_0
;;case 00101110
;;mode : 00101110 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_2F_0_0
;;case 00101111
;;mode : 00101111 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
		NEXT_COL8
;;----------------------------------------

PPU8_30_0_0
;;case 00110000
;;mode : 00110000 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_31_0_0
;;case 00110001
;;mode : 00110001 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_32_0_0
;;case 00110010
;;mode : 00110010 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_33_0_0
;;case 00110011
;;mode : 00110011 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_34_0_0
;;case 00110100
;;mode : 00110100 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_35_0_0
;;case 00110101
;;mode : 00110101 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_36_0_0
;;case 00110110
;;mode : 00110110 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_37_0_0
;;case 00110111
;;mode : 00110111 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_38_0_0
;;case 00111000
;;mode : 00111000 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 3
		ldrh	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-4
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_39_0_0
;;case 00111001
;;mode : 00111001 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 3
		ldrh	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-4
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_3A_0_0
;;case 00111010
;;mode : 00111010 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 3
		ldrh	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-4
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_3B_0_0
;;case 00111011
;;mode : 00111011 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 3
		ldrh	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-4
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_3C_0_0
;;case 00111100
;;mode : 00111100 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 4
		ldrh	R0,[R11]
		add		R11,R11,#6
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-5
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_3D_0_0
;;case 00111101
;;mode : 00111101 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 4
		ldrh	R0,[R11]
		add		R11,R11,#6
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-5
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_3E_0_0
;;case 00111110
;;mode : 00111110 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 5
		ldrh	R0,[R11]
		add		R11,R11,#7
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-6
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_3F_0_0
;;case 00111111
;;mode : 00111111 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 6
		ldrh	R0,[R11]
		add		R11,R11,#8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-7
		NEXT_COL8
;;----------------------------------------

PPU8_40_0_0
;;case 01000000
;;mode : 01000000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 6, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_41_0_0
;;case 01000001
;;mode : 01000001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 5, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_42_0_0
;;case 01000010
;;mode : 01000010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 4, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_43_0_0
;;case 01000011
;;mode : 01000011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 4, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_44_0_0
;;case 01000100
;;mode : 01000100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_45_0_0
;;case 01000101
;;mode : 01000101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_46_0_0
;;case 01000110
;;mode : 01000110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 3, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_47_0_0
;;case 01000111
;;mode : 01000111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 3, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_48_0_0
;;case 01001000
;;mode : 01001000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_49_0_0
;;case 01001001
;;mode : 01001001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_4A_0_0
;;case 01001010
;;mode : 01001010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_4B_0_0
;;case 01001011
;;mode : 01001011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_4C_0_0
;;case 01001100
;;mode : 01001100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_4D_0_0
;;case 01001101
;;mode : 01001101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_4E_0_0
;;case 01001110
;;mode : 01001110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 2, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_4F_0_0
;;case 01001111
;;mode : 01001111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 2, Pix transp : 4
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
		NEXT_COL8
;;----------------------------------------

PPU8_50_0_0
;;case 01010000
;;mode : 01010000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_51_0_0
;;case 01010001
;;mode : 01010001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_52_0_0
;;case 01010010
;;mode : 01010010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_53_0_0
;;case 01010011
;;mode : 01010011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_54_0_0
;;case 01010100
;;mode : 01010100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_55_0_0
;;case 01010101
;;mode : 01010101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_56_0_0
;;case 01010110
;;mode : 01010110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_57_0_0
;;case 01010111
;;mode : 01010111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_58_0_0
;;case 01011000
;;mode : 01011000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_59_0_0
;;case 01011001
;;mode : 01011001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_5A_0_0
;;case 01011010
;;mode : 01011010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_5B_0_0
;;case 01011011
;;mode : 01011011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_5C_0_0
;;case 01011100
;;mode : 01011100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_5D_0_0
;;case 01011101
;;mode : 01011101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_5E_0_0
;;case 01011110
;;mode : 01011110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_5F_0_0
;;case 01011111
;;mode : 01011111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 5
		ldrb	R0,[R11],#6
		strb	R0,[R12],#-6
		NEXT_COL8
;;----------------------------------------

PPU8_60_0_0
;;case 01100000
;;mode : 01100000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 5, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_61_0_0
;;case 01100001
;;mode : 01100001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 4, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_62_0_0
;;case 01100010
;;mode : 01100010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_63_0_0
;;case 01100011
;;mode : 01100011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 3, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_64_0_0
;;case 01100100
;;mode : 01100100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_65_0_0
;;case 01100101
;;mode : 01100101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_66_0_0
;;case 01100110
;;mode : 01100110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_67_0_0
;;case 01100111
;;mode : 01100111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 2, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_68_0_0
;;case 01101000
;;mode : 01101000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_69_0_0
;;case 01101001
;;mode : 01101001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_6A_0_0
;;case 01101010
;;mode : 01101010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_6B_0_0
;;case 01101011
;;mode : 01101011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_6C_0_0
;;case 01101100
;;mode : 01101100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_6D_0_0
;;case 01101101
;;mode : 01101101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_6E_0_0
;;case 01101110
;;mode : 01101110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_6F_0_0
;;case 01101111
;;mode : 01101111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
		NEXT_COL8
;;----------------------------------------

PPU8_70_0_0
;;case 01110000
;;mode : 01110000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_71_0_0
;;case 01110001
;;mode : 01110001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_72_0_0
;;case 01110010
;;mode : 01110010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_73_0_0
;;case 01110011
;;mode : 01110011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_74_0_0
;;case 01110100
;;mode : 01110100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_75_0_0
;;case 01110101
;;mode : 01110101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_76_0_0
;;case 01110110
;;mode : 01110110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_77_0_0
;;case 01110111
;;mode : 01110111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_78_0_0
;;case 01111000
;;mode : 01111000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#-5
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_79_0_0
;;case 01111001
;;mode : 01111001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#-5
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_7A_0_0
;;case 01111010
;;mode : 01111010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#-5
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_7B_0_0
;;case 01111011
;;mode : 01111011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#-5
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_7C_0_0
;;case 01111100
;;mode : 01111100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 5
		ldrb	R0,[R11]
		add		R11,R11,#6
		strb	R0,[R12],#-6
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_7D_0_0
;;case 01111101
;;mode : 01111101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 5
		ldrb	R0,[R11]
		add		R11,R11,#6
		strb	R0,[R12],#-6
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_7E_0_0
;;case 01111110
;;mode : 01111110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 6
		ldrb	R0,[R11]
		add		R11,R11,#7
		strb	R0,[R12],#-7
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_7F_0_0
;;case 01111111
;;mode : 01111111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 7
		ldrb	R0,[R11]
		add		R11,R11,#8
		strb	R0,[R12],#-8
		NEXT_COL8
;;----------------------------------------


PPU8_80_0_0
;;case 10000000
;;mode : 10000000 => first pix:1
	;;Pos : 1, Pix opaque : 7, Pix transp : 0
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_81_0_0
;;case 10000001
;;mode : 10000001 => first pix:1
	;;Pos : 1, Pix opaque : 6, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_82_0_0
;;case 10000010
;;mode : 10000010 => first pix:1
	;;Pos : 1, Pix opaque : 5, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_83_0_0
;;case 10000011
;;mode : 10000011 => first pix:1
	;;Pos : 1, Pix opaque : 5, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_84_0_0
;;case 10000100
;;mode : 10000100 => first pix:1
	;;Pos : 1, Pix opaque : 4, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_85_0_0
;;case 10000101
;;mode : 10000101 => first pix:1
	;;Pos : 1, Pix opaque : 4, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_86_0_0
;;case 10000110
;;mode : 10000110 => first pix:1
	;;Pos : 1, Pix opaque : 4, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_87_0_0
;;case 10000111
;;mode : 10000111 => first pix:1
	;;Pos : 1, Pix opaque : 4, Pix transp : 3
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_88_0_0
;;case 10001000
;;mode : 10001000 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_89_0_0
;;case 10001001
;;mode : 10001001 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_8A_0_0
;;case 10001010
;;mode : 10001010 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_8B_0_0
;;case 10001011
;;mode : 10001011 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_8C_0_0
;;case 10001100
;;mode : 10001100 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_8D_0_0
;;case 10001101
;;mode : 10001101 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_8E_0_0
;;case 10001110
;;mode : 10001110 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 3
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_8F_0_0
;;case 10001111
;;mode : 10001111 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 4
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
		NEXT_COL8
;;----------------------------------------

PPU8_90_0_0
;;case 10010000
;;mode : 10010000 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_91_0_0
;;case 10010001
;;mode : 10010001 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_92_0_0
;;case 10010010
;;mode : 10010010 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_93_0_0
;;case 10010011
;;mode : 10010011 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_94_0_0
;;case 10010100
;;mode : 10010100 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_95_0_0
;;case 10010101
;;mode : 10010101 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_96_0_0
;;case 10010110
;;mode : 10010110 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_97_0_0
;;case 10010111
;;mode : 10010111 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_98_0_0
;;case 10011000
;;mode : 10011000 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_99_0_0
;;case 10011001
;;mode : 10011001 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_9A_0_0
;;case 10011010
;;mode : 10011010 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_9B_0_0
;;case 10011011
;;mode : 10011011 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_9C_0_0
;;case 10011100
;;mode : 10011100 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 3
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_9D_0_0
;;case 10011101
;;mode : 10011101 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 3
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_9E_0_0
;;case 10011110
;;mode : 10011110 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 4
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_9F_0_0
;;case 10011111
;;mode : 10011111 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 5
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#6
		strb	R0,[R12],#-6
		NEXT_COL8
;;----------------------------------------

PPU8_A0_0_0
;;case 10100000
;;mode : 10100000 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 5, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_A1_0_0
;;case 10100001
;;mode : 10100001 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 4, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_A2_0_0
;;case 10100010
;;mode : 10100010 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_A3_0_0
;;case 10100011
;;mode : 10100011 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 3, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_A4_0_0
;;case 10100100
;;mode : 10100100 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_A5_0_0
;;case 10100101
;;mode : 10100101 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_A6_0_0
;;case 10100110
;;mode : 10100110 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_A7_0_0
;;case 10100111
;;mode : 10100111 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 2, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_A8_0_0
;;case 10101000
;;mode : 10101000 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_A9_0_0
;;case 10101001
;;mode : 10101001 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_AA_0_0
;;case 10101010
;;mode : 10101010 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_AB_0_0
;;case 10101011
;;mode : 10101011 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_AC_0_0
;;case 10101100
;;mode : 10101100 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_AD_0_0
;;case 10101101
;;mode : 10101101 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_AE_0_0
;;case 10101110
;;mode : 10101110 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_AF_0_0
;;case 10101111
;;mode : 10101111 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
		NEXT_COL8
;;----------------------------------------

PPU8_B0_0_0
;;case 10110000
;;mode : 10110000 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_B1_0_0
;;case 10110001
;;mode : 10110001 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_B2_0_0
;;case 10110010
;;mode : 10110010 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_B3_0_0
;;case 10110011
;;mode : 10110011 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_B4_0_0
;;case 10110100
;;mode : 10110100 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_B5_0_0
;;case 10110101
;;mode : 10110101 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_B6_0_0
;;case 10110110
;;mode : 10110110 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_B7_0_0
;;case 10110111
;;mode : 10110111 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_B8_0_0
;;case 10111000
;;mode : 10111000 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_B9_0_0
;;case 10111001
;;mode : 10111001 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_BA_0_0
;;case 10111010
;;mode : 10111010 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_BB_0_0
;;case 10111011
;;mode : 10111011 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_BC_0_0
;;case 10111100
;;mode : 10111100 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 4
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_BD_0_0
;;case 10111101
;;mode : 10111101 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 4
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_BE_0_0
;;case 10111110
;;mode : 10111110 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 5
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#6
		strb	R0,[R12],#-6
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_BF_0_0
;;case 10111111
;;mode : 10111111 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 6
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#7
		strb	R0,[R12],#-7
		NEXT_COL8
;;----------------------------------------

PPU8_C0_0_0
;;case 11000000
;;mode : 11000000 => first pix:2
	;;Pos : 2, Pix opaque : 6, Pix transp : 0
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_C1_0_0
;;case 11000001
;;mode : 11000001 => first pix:2
	;;Pos : 2, Pix opaque : 5, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_C2_0_0
;;case 11000010
;;mode : 11000010 => first pix:2
	;;Pos : 2, Pix opaque : 4, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_C3_0_0
;;case 11000011
;;mode : 11000011 => first pix:2
	;;Pos : 2, Pix opaque : 4, Pix transp : 2
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_C4_0_0
;;case 11000100
;;mode : 11000100 => first pix:2
	;;Pos : 2, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_C5_0_0
;;case 11000101
;;mode : 11000101 => first pix:2
	;;Pos : 2, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_C6_0_0
;;case 11000110
;;mode : 11000110 => first pix:2
	;;Pos : 2, Pix opaque : 3, Pix transp : 2
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_C7_0_0
;;case 11000111
;;mode : 11000111 => first pix:2
	;;Pos : 2, Pix opaque : 3, Pix transp : 3
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_C8_0_0
;;case 11001000
;;mode : 11001000 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_C9_0_0
;;case 11001001
;;mode : 11001001 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_CA_0_0
;;case 11001010
;;mode : 11001010 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_CB_0_0
;;case 11001011
;;mode : 11001011 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_CC_0_0
;;case 11001100
;;mode : 11001100 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_CD_0_0
;;case 11001101
;;mode : 11001101 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_CE_0_0
;;case 11001110
;;mode : 11001110 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 3
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_CF_0_0
;;case 11001111
;;mode : 11001111 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 4
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
		NEXT_COL8
;;----------------------------------------

PPU8_D0_0_0
;;case 11010000
;;mode : 11010000 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_D1_0_0
;;case 11010001
;;mode : 11010001 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_D2_0_0
;;case 11010010
;;mode : 11010010 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_D3_0_0
;;case 11010011
;;mode : 11010011 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_D4_0_0
;;case 11010100
;;mode : 11010100 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_D5_0_0
;;case 11010101
;;mode : 11010101 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_D6_0_0
;;case 11010110
;;mode : 11010110 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_D7_0_0
;;case 11010111
;;mode : 11010111 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_D8_0_0
;;case 11011000
;;mode : 11011000 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_D9_0_0
;;case 11011001
;;mode : 11011001 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_DA_0_0
;;case 11011010
;;mode : 11011010 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_DB_0_0
;;case 11011011
;;mode : 11011011 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_DC_0_0
;;case 11011100
;;mode : 11011100 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_DD_0_0
;;case 11011101
;;mode : 11011101 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_DE_0_0
;;case 11011110
;;mode : 11011110 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 4
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_DF_0_0
;;case 11011111
;;mode : 11011111 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 5
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#6
		strb	R0,[R12],#-6
		NEXT_COL8
;;----------------------------------------

PPU8_E0_0_0
;;case 11100000
;;mode : 11100000 => first pix:3
	;;Pos : 3, Pix opaque : 5, Pix transp : 0
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_E1_0_0
;;case 11100001
;;mode : 11100001 => first pix:3
	;;Pos : 3, Pix opaque : 4, Pix transp : 1
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_E2_0_0
;;case 11100010
;;mode : 11100010 => first pix:3
	;;Pos : 3, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_E3_0_0
;;case 11100011
;;mode : 11100011 => first pix:3
	;;Pos : 3, Pix opaque : 3, Pix transp : 2
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_E4_0_0
;;case 11100100
;;mode : 11100100 => first pix:3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_E5_0_0
;;case 11100101
;;mode : 11100101 => first pix:3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_E6_0_0
;;case 11100110
;;mode : 11100110 => first pix:3
	;;Pos : 3, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_E7_0_0
;;case 11100111
;;mode : 11100111 => first pix:3
	;;Pos : 3, Pix opaque : 2, Pix transp : 3
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_E8_0_0
;;case 11101000
;;mode : 11101000 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_E9_0_0
;;case 11101001
;;mode : 11101001 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_EA_0_0
;;case 11101010
;;mode : 11101010 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_EB_0_0
;;case 11101011
;;mode : 11101011 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_EC_0_0
;;case 11101100
;;mode : 11101100 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_ED_0_0
;;case 11101101
;;mode : 11101101 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_EE_0_0
;;case 11101110
;;mode : 11101110 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_EF_0_0
;;case 11101111
;;mode : 11101111 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 4
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
		NEXT_COL8
;;----------------------------------------

PPU8_F0_0_0
;;case 11110000
;;mode : 11110000 => first pix:4
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
		add	R11,R11,#4
		sub	R12,R12,#4
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_F1_0_0
;;case 11110001
;;mode : 11110001 => first pix:4
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#4
		sub	R12,R12,#4
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_F2_0_0
;;case 11110010
;;mode : 11110010 => first pix:4
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#4
		sub	R12,R12,#4
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_F3_0_0
;;case 11110011
;;mode : 11110011 => first pix:4
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#4
		sub	R12,R12,#4
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_F4_0_0
;;case 11110100
;;mode : 11110100 => first pix:4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#4
		sub	R12,R12,#4
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_F5_0_0
;;case 11110101
;;mode : 11110101 => first pix:4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#4
		sub	R12,R12,#4
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_F6_0_0
;;case 11110110
;;mode : 11110110 => first pix:4
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#4
		sub	R12,R12,#4
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_F7_0_0
;;case 11110111
;;mode : 11110111 => first pix:4
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#4
		sub	R12,R12,#4
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_F8_0_0
;;case 11111000
;;mode : 11111000 => first pix:5
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		add	R11,R11,#5
		sub	R12,R12,#5
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_F9_0_0
;;case 11111001
;;mode : 11111001 => first pix:5
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#5
		sub	R12,R12,#5
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_FA_0_0
;;case 11111010
;;mode : 11111010 => first pix:5
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#5
		sub	R12,R12,#5
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_FB_0_0
;;case 11111011
;;mode : 11111011 => first pix:5
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#5
		sub	R12,R12,#5
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_FC_0_0
;;case 11111100
;;mode : 11111100 => first pix:6
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		add	R11,R11,#6
		sub	R12,R12,#6
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_FD_0_0
;;case 11111101
;;mode : 11111101 => first pix:6
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#6
		sub	R12,R12,#6
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_FE_0_0
;;case 11111110
;;mode : 11111110 => first pix:7
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		add	R11,R11,#7
		sub	R12,R12,#7
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_FF_0_0
;;case 11111111
		add		R11,R11,#8
		sub		R12,R12,#8
		NEXT_COL8
;;----------------------------------------
jumptable_ppu800
		DCD		PPU8_00_0_0
		DCD		PPU8_01_0_0
		DCD		PPU8_02_0_0
		DCD		PPU8_03_0_0
		DCD		PPU8_04_0_0
		DCD		PPU8_05_0_0
		DCD		PPU8_06_0_0
		DCD		PPU8_07_0_0
		DCD		PPU8_08_0_0
		DCD		PPU8_09_0_0
		DCD		PPU8_0A_0_0
		DCD		PPU8_0B_0_0
		DCD		PPU8_0C_0_0
		DCD		PPU8_0D_0_0
		DCD		PPU8_0E_0_0
		DCD		PPU8_0F_0_0
		DCD		PPU8_10_0_0
		DCD		PPU8_11_0_0
		DCD		PPU8_12_0_0
		DCD		PPU8_13_0_0
		DCD		PPU8_14_0_0
		DCD		PPU8_15_0_0
		DCD		PPU8_16_0_0
		DCD		PPU8_17_0_0
		DCD		PPU8_18_0_0
		DCD		PPU8_19_0_0
		DCD		PPU8_1A_0_0
		DCD		PPU8_1B_0_0
		DCD		PPU8_1C_0_0
		DCD		PPU8_1D_0_0
		DCD		PPU8_1E_0_0
		DCD		PPU8_1F_0_0
		DCD		PPU8_20_0_0
		DCD		PPU8_21_0_0
		DCD		PPU8_22_0_0
		DCD		PPU8_23_0_0
		DCD		PPU8_24_0_0
		DCD		PPU8_25_0_0
		DCD		PPU8_26_0_0
		DCD		PPU8_27_0_0
		DCD		PPU8_28_0_0
		DCD		PPU8_29_0_0
		DCD		PPU8_2A_0_0
		DCD		PPU8_2B_0_0
		DCD		PPU8_2C_0_0
		DCD		PPU8_2D_0_0
		DCD		PPU8_2E_0_0
		DCD		PPU8_2F_0_0
		DCD		PPU8_30_0_0
		DCD		PPU8_31_0_0
		DCD		PPU8_32_0_0
		DCD		PPU8_33_0_0
		DCD		PPU8_34_0_0
		DCD		PPU8_35_0_0
		DCD		PPU8_36_0_0
		DCD		PPU8_37_0_0
		DCD		PPU8_38_0_0
		DCD		PPU8_39_0_0
		DCD		PPU8_3A_0_0
		DCD		PPU8_3B_0_0
		DCD		PPU8_3C_0_0
		DCD		PPU8_3D_0_0
		DCD		PPU8_3E_0_0
		DCD		PPU8_3F_0_0
		DCD		PPU8_40_0_0
		DCD		PPU8_41_0_0
		DCD		PPU8_42_0_0
		DCD		PPU8_43_0_0
		DCD		PPU8_44_0_0
		DCD		PPU8_45_0_0
		DCD		PPU8_46_0_0
		DCD		PPU8_47_0_0
		DCD		PPU8_48_0_0
		DCD		PPU8_49_0_0
		DCD		PPU8_4A_0_0
		DCD		PPU8_4B_0_0
		DCD		PPU8_4C_0_0
		DCD		PPU8_4D_0_0
		DCD		PPU8_4E_0_0
		DCD		PPU8_4F_0_0
		DCD		PPU8_50_0_0
		DCD		PPU8_51_0_0
		DCD		PPU8_52_0_0
		DCD		PPU8_53_0_0
		DCD		PPU8_54_0_0
		DCD		PPU8_55_0_0
		DCD		PPU8_56_0_0
		DCD		PPU8_57_0_0
		DCD		PPU8_58_0_0
		DCD		PPU8_59_0_0
		DCD		PPU8_5A_0_0
		DCD		PPU8_5B_0_0
		DCD		PPU8_5C_0_0
		DCD		PPU8_5D_0_0
		DCD		PPU8_5E_0_0
		DCD		PPU8_5F_0_0
		DCD		PPU8_60_0_0
		DCD		PPU8_61_0_0
		DCD		PPU8_62_0_0
		DCD		PPU8_63_0_0
		DCD		PPU8_64_0_0
		DCD		PPU8_65_0_0
		DCD		PPU8_66_0_0
		DCD		PPU8_67_0_0
		DCD		PPU8_68_0_0
		DCD		PPU8_69_0_0
		DCD		PPU8_6A_0_0
		DCD		PPU8_6B_0_0
		DCD		PPU8_6C_0_0
		DCD		PPU8_6D_0_0
		DCD		PPU8_6E_0_0
		DCD		PPU8_6F_0_0
		DCD		PPU8_70_0_0
		DCD		PPU8_71_0_0
		DCD		PPU8_72_0_0
		DCD		PPU8_73_0_0
		DCD		PPU8_74_0_0
		DCD		PPU8_75_0_0
		DCD		PPU8_76_0_0
		DCD		PPU8_77_0_0
		DCD		PPU8_78_0_0
		DCD		PPU8_79_0_0
		DCD		PPU8_7A_0_0
		DCD		PPU8_7B_0_0
		DCD		PPU8_7C_0_0
		DCD		PPU8_7D_0_0
		DCD		PPU8_7E_0_0
		DCD		PPU8_7F_0_0
		DCD		PPU8_80_0_0
		DCD		PPU8_81_0_0
		DCD		PPU8_82_0_0
		DCD		PPU8_83_0_0
		DCD		PPU8_84_0_0
		DCD		PPU8_85_0_0
		DCD		PPU8_86_0_0
		DCD		PPU8_87_0_0
		DCD		PPU8_88_0_0
		DCD		PPU8_89_0_0
		DCD		PPU8_8A_0_0
		DCD		PPU8_8B_0_0
		DCD		PPU8_8C_0_0
		DCD		PPU8_8D_0_0
		DCD		PPU8_8E_0_0
		DCD		PPU8_8F_0_0
		DCD		PPU8_90_0_0
		DCD		PPU8_91_0_0
		DCD		PPU8_92_0_0
		DCD		PPU8_93_0_0
		DCD		PPU8_94_0_0
		DCD		PPU8_95_0_0
		DCD		PPU8_96_0_0
		DCD		PPU8_97_0_0
		DCD		PPU8_98_0_0
		DCD		PPU8_99_0_0
		DCD		PPU8_9A_0_0
		DCD		PPU8_9B_0_0
		DCD		PPU8_9C_0_0
		DCD		PPU8_9D_0_0
		DCD		PPU8_9E_0_0
		DCD		PPU8_9F_0_0
		DCD		PPU8_A0_0_0
		DCD		PPU8_A1_0_0
		DCD		PPU8_A2_0_0
		DCD		PPU8_A3_0_0
		DCD		PPU8_A4_0_0
		DCD		PPU8_A5_0_0
		DCD		PPU8_A6_0_0
		DCD		PPU8_A7_0_0
		DCD		PPU8_A8_0_0
		DCD		PPU8_A9_0_0
		DCD		PPU8_AA_0_0
		DCD		PPU8_AB_0_0
		DCD		PPU8_AC_0_0
		DCD		PPU8_AD_0_0
		DCD		PPU8_AE_0_0
		DCD		PPU8_AF_0_0
		DCD		PPU8_B0_0_0
		DCD		PPU8_B1_0_0
		DCD		PPU8_B2_0_0
		DCD		PPU8_B3_0_0
		DCD		PPU8_B4_0_0
		DCD		PPU8_B5_0_0
		DCD		PPU8_B6_0_0
		DCD		PPU8_B7_0_0
		DCD		PPU8_B8_0_0
		DCD		PPU8_B9_0_0
		DCD		PPU8_BA_0_0
		DCD		PPU8_BB_0_0
		DCD		PPU8_BC_0_0
		DCD		PPU8_BD_0_0
		DCD		PPU8_BE_0_0
		DCD		PPU8_BF_0_0
		DCD		PPU8_C0_0_0
		DCD		PPU8_C1_0_0
		DCD		PPU8_C2_0_0
		DCD		PPU8_C3_0_0
		DCD		PPU8_C4_0_0
		DCD		PPU8_C5_0_0
		DCD		PPU8_C6_0_0
		DCD		PPU8_C7_0_0
		DCD		PPU8_C8_0_0
		DCD		PPU8_C9_0_0
		DCD		PPU8_CA_0_0
		DCD		PPU8_CB_0_0
		DCD		PPU8_CC_0_0
		DCD		PPU8_CD_0_0
		DCD		PPU8_CE_0_0
		DCD		PPU8_CF_0_0
		DCD		PPU8_D0_0_0
		DCD		PPU8_D1_0_0
		DCD		PPU8_D2_0_0
		DCD		PPU8_D3_0_0
		DCD		PPU8_D4_0_0
		DCD		PPU8_D5_0_0
		DCD		PPU8_D6_0_0
		DCD		PPU8_D7_0_0
		DCD		PPU8_D8_0_0
		DCD		PPU8_D9_0_0
		DCD		PPU8_DA_0_0
		DCD		PPU8_DB_0_0
		DCD		PPU8_DC_0_0
		DCD		PPU8_DD_0_0
		DCD		PPU8_DE_0_0
		DCD		PPU8_DF_0_0
		DCD		PPU8_E0_0_0
		DCD		PPU8_E1_0_0
		DCD		PPU8_E2_0_0
		DCD		PPU8_E3_0_0
		DCD		PPU8_E4_0_0
		DCD		PPU8_E5_0_0
		DCD		PPU8_E6_0_0
		DCD		PPU8_E7_0_0
		DCD		PPU8_E8_0_0
		DCD		PPU8_E9_0_0
		DCD		PPU8_EA_0_0
		DCD		PPU8_EB_0_0
		DCD		PPU8_EC_0_0
		DCD		PPU8_ED_0_0
		DCD		PPU8_EE_0_0
		DCD		PPU8_EF_0_0
		DCD		PPU8_F0_0_0
		DCD		PPU8_F1_0_0
		DCD		PPU8_F2_0_0
		DCD		PPU8_F3_0_0
		DCD		PPU8_F4_0_0
		DCD		PPU8_F5_0_0
		DCD		PPU8_F6_0_0
		DCD		PPU8_F7_0_0
		DCD		PPU8_F8_0_0
		DCD		PPU8_F9_0_0
		DCD		PPU8_FA_0_0
		DCD		PPU8_FB_0_0
		DCD		PPU8_FC_0_0
		DCD		PPU8_FD_0_0
		DCD		PPU8_FE_0_0
		DCD		PPU8_FF_0_0


PPU8_00_1_0
;;case 00000000
;;mode : 00000000 => first pix:0
	;;Pos : 0, Pix opaque : 8, Pix transp : 0
		ldmia	R11!,{R0,R1}
		stmia	R12!,{R0,R1}
		NEXT_COL8
;;----------------------------------------

PPU8_01_1_0
;;case 00000001
;;mode : 00000001 => first pix:0
	;;Pos : 0, Pix opaque : 7, Pix transp : 1
		ldmia	R11!,{R0,R1}
		str		R0,[R12],#4
		strh	R1,[R12],#2
		mov		R1,R1,lsr #16
		strb	R1,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_02_1_0
;;case 00000010
;;mode : 00000010 => first pix:0
	;;Pos : 0, Pix opaque : 6, Pix transp : 1
		ldmia	R11,{R0,R1}
		add		R11,R11,#7
		str		R0,[R12],#4
		strh	R1,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_03_1_0
;;case 00000011
;;mode : 00000011 => first pix:0
	;;Pos : 0, Pix opaque : 6, Pix transp : 2
		ldmia	R11,{R0,R1}
		add		R11,R11,#8
		str		R0,[R12],#4
		strh	R1,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_04_1_0
;;case 00000100
;;mode : 00000100 => first pix:0
	;;Pos : 0, Pix opaque : 5, Pix transp : 1
		ldmia	R11,{R0,R1}
		add		R11,R11,#6
		str		R0,[R12],#4
		strb	R1,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_05_1_0
;;case 00000101
;;mode : 00000101 => first pix:0
	;;Pos : 0, Pix opaque : 5, Pix transp : 1
		ldmia	R11,{R0,R1}
		add		R11,R11,#6
		str		R0,[R12],#4
		strb	R1,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_06_1_0
;;case 00000110
;;mode : 00000110 => first pix:0
	;;Pos : 0, Pix opaque : 5, Pix transp : 2
		ldmia	R11,{R0,R1}
		add		R11,R11,#7
		str		R0,[R12],#4
		strb	R1,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_07_1_0
;;case 00000111
;;mode : 00000111 => first pix:0
	;;Pos : 0, Pix opaque : 5, Pix transp : 3
		ldmia	R11,{R0,R1}
		add		R11,R11,#8
		str		R0,[R12],#4
		strb	R1,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_08_1_0
;;case 00001000
;;mode : 00001000 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#5
		str		R0,[R12],#5
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_09_1_0
;;case 00001001
;;mode : 00001001 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#5
		str		R0,[R12],#5
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_0A_1_0
;;case 00001010
;;mode : 00001010 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#5
		str		R0,[R12],#5
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_0B_1_0
;;case 00001011
;;mode : 00001011 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#5
		str		R0,[R12],#5
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_0C_1_0
;;case 00001100
;;mode : 00001100 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#6
		str		R0,[R12],#6
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_0D_1_0
;;case 00001101
;;mode : 00001101 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#6
		str		R0,[R12],#6
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_0E_1_0
;;case 00001110
;;mode : 00001110 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 3
		ldmia	R11,{R0}
		add		R11,R11,#7
		str		R0,[R12],#7
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_0F_1_0
;;case 00001111
;;mode : 00001111 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 4
		ldmia	R11,{R0}
		add		R11,R11,#8
		str		R0,[R12],#8
		NEXT_COL8
;;----------------------------------------

PPU8_10_1_0
;;case 00010000
;;mode : 00010000 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		str		R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_11_1_0
;;case 00010001
;;mode : 00010001 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_12_1_0
;;case 00010010
;;mode : 00010010 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strh	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_13_1_0
;;case 00010011
;;mode : 00010011 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strh	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_14_1_0
;;case 00010100
;;mode : 00010100 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_15_1_0
;;case 00010101
;;mode : 00010101 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_16_1_0
;;case 00010110
;;mode : 00010110 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_17_1_0
;;case 00010111
;;mode : 00010111 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_18_1_0
;;case 00011000
;;mode : 00011000 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#5
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_19_1_0
;;case 00011001
;;mode : 00011001 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#5
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_1A_1_0
;;case 00011010
;;mode : 00011010 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#5
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_1B_1_0
;;case 00011011
;;mode : 00011011 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#5
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_1C_1_0
;;case 00011100
;;mode : 00011100 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 3
		ldmia	R11,{R0}
		add		R11,R11,#6
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#4
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_1D_1_0
;;case 00011101
;;mode : 00011101 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 3
		ldmia	R11,{R0}
		add		R11,R11,#6
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#4
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_1E_1_0
;;case 00011110
;;mode : 00011110 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 4
		ldmia	R11,{R0}
		add		R11,R11,#7
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#5
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_1F_1_0
;;case 00011111
;;mode : 00011111 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 5
		ldmia	R11,{R0}
		add		R11,R11,#8
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#6
		NEXT_COL8
;;----------------------------------------

PPU8_20_1_0
;;case 00100000
;;mode : 00100000 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strh	R0,[R12],#3
	;;Pos : 3, Pix opaque : 5, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
	ldmia	R11!,{R0}
		str		R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_21_1_0
;;case 00100001
;;mode : 00100001 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strh	R0,[R12],#3
	;;Pos : 3, Pix opaque : 4, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_22_1_0
;;case 00100010
;;mode : 00100010 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strh	R0,[R12],#3
	;;Pos : 3, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strh	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_23_1_0
;;case 00100011
;;mode : 00100011 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strh	R0,[R12],#3
	;;Pos : 3, Pix opaque : 3, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strh	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_24_1_0
;;case 00100100
;;mode : 00100100 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strh	R0,[R12],#3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_25_1_0
;;case 00100101
;;mode : 00100101 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strh	R0,[R12],#3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_26_1_0
;;case 00100110
;;mode : 00100110 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strh	R0,[R12],#3
	;;Pos : 3, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_27_1_0
;;case 00100111
;;mode : 00100111 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strh	R0,[R12],#3
	;;Pos : 3, Pix opaque : 2, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_28_1_0
;;case 00101000
;;mode : 00101000 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strh	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_29_1_0
;;case 00101001
;;mode : 00101001 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strh	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_2A_1_0
;;case 00101010
;;mode : 00101010 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strh	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_2B_1_0
;;case 00101011
;;mode : 00101011 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strh	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_2C_1_0
;;case 00101100
;;mode : 00101100 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strh	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_2D_1_0
;;case 00101101
;;mode : 00101101 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strh	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_2E_1_0
;;case 00101110
;;mode : 00101110 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strh	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_2F_1_0
;;case 00101111
;;mode : 00101111 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strh	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
		NEXT_COL8
;;----------------------------------------

PPU8_30_1_0
;;case 00110000
;;mode : 00110000 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strh	R0,[R12],#4
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		str		R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_31_1_0
;;case 00110001
;;mode : 00110001 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strh	R0,[R12],#4
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_32_1_0
;;case 00110010
;;mode : 00110010 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strh	R0,[R12],#4
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strh	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_33_1_0
;;case 00110011
;;mode : 00110011 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strh	R0,[R12],#4
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strh	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_34_1_0
;;case 00110100
;;mode : 00110100 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strh	R0,[R12],#4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_35_1_0
;;case 00110101
;;mode : 00110101 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strh	R0,[R12],#4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_36_1_0
;;case 00110110
;;mode : 00110110 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strh	R0,[R12],#4
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_37_1_0
;;case 00110111
;;mode : 00110111 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strh	R0,[R12],#4
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_38_1_0
;;case 00111000
;;mode : 00111000 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 3
		ldrh	R0,[R11]
		add		R11,R11,#5
		strh	R0,[R12],#5
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_39_1_0
;;case 00111001
;;mode : 00111001 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 3
		ldrh	R0,[R11]
		add		R11,R11,#5
		strh	R0,[R12],#5
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_3A_1_0
;;case 00111010
;;mode : 00111010 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 3
		ldrh	R0,[R11]
		add		R11,R11,#5
		strh	R0,[R12],#5
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_3B_1_0
;;case 00111011
;;mode : 00111011 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 3
		ldrh	R0,[R11]
		add		R11,R11,#5
		strh	R0,[R12],#5
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_3C_1_0
;;case 00111100
;;mode : 00111100 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 4
		ldrh	R0,[R11]
		add		R11,R11,#6
		strh	R0,[R12],#6
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_3D_1_0
;;case 00111101
;;mode : 00111101 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 4
		ldrh	R0,[R11]
		add		R11,R11,#6
		strh	R0,[R12],#6
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_3E_1_0
;;case 00111110
;;mode : 00111110 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 5
		ldrh	R0,[R11]
		add		R11,R11,#7
		strh	R0,[R12],#7
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_3F_1_0
;;case 00111111
;;mode : 00111111 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 6
		ldrh	R0,[R11]
		add		R11,R11,#8
		strh	R0,[R12],#8
		NEXT_COL8
;;----------------------------------------

PPU8_40_1_0
;;case 01000000
;;mode : 01000000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 6, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
	ldmia	R11!,{R0}
		str		R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_41_1_0
;;case 01000001
;;mode : 01000001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 5, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_42_1_0
;;case 01000010
;;mode : 01000010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 4, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strh	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_43_1_0
;;case 01000011
;;mode : 01000011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 4, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strh	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_44_1_0
;;case 01000100
;;mode : 01000100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_45_1_0
;;case 01000101
;;mode : 01000101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_46_1_0
;;case 01000110
;;mode : 01000110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 3, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_47_1_0
;;case 01000111
;;mode : 01000111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 3, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_48_1_0
;;case 01001000
;;mode : 01001000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_49_1_0
;;case 01001001
;;mode : 01001001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_4A_1_0
;;case 01001010
;;mode : 01001010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_4B_1_0
;;case 01001011
;;mode : 01001011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_4C_1_0
;;case 01001100
;;mode : 01001100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_4D_1_0
;;case 01001101
;;mode : 01001101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_4E_1_0
;;case 01001110
;;mode : 01001110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 2, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_4F_1_0
;;case 01001111
;;mode : 01001111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 2, Pix transp : 4
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
		NEXT_COL8
;;----------------------------------------

PPU8_50_1_0
;;case 01010000
;;mode : 01010000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		str		R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_51_1_0
;;case 01010001
;;mode : 01010001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_52_1_0
;;case 01010010
;;mode : 01010010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strh	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_53_1_0
;;case 01010011
;;mode : 01010011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strh	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_54_1_0
;;case 01010100
;;mode : 01010100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_55_1_0
;;case 01010101
;;mode : 01010101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_56_1_0
;;case 01010110
;;mode : 01010110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_57_1_0
;;case 01010111
;;mode : 01010111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_58_1_0
;;case 01011000
;;mode : 01011000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_59_1_0
;;case 01011001
;;mode : 01011001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_5A_1_0
;;case 01011010
;;mode : 01011010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_5B_1_0
;;case 01011011
;;mode : 01011011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_5C_1_0
;;case 01011100
;;mode : 01011100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_5D_1_0
;;case 01011101
;;mode : 01011101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_5E_1_0
;;case 01011110
;;mode : 01011110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_5F_1_0
;;case 01011111
;;mode : 01011111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 5
		ldrb	R0,[R11],#6
		strb	R0,[R12],#6
		NEXT_COL8
;;----------------------------------------

PPU8_60_1_0
;;case 01100000
;;mode : 01100000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 5, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
	ldmia	R11!,{R0}
		str		R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_61_1_0
;;case 01100001
;;mode : 01100001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 4, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_62_1_0
;;case 01100010
;;mode : 01100010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strh	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_63_1_0
;;case 01100011
;;mode : 01100011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 3, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strh	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_64_1_0
;;case 01100100
;;mode : 01100100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_65_1_0
;;case 01100101
;;mode : 01100101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_66_1_0
;;case 01100110
;;mode : 01100110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_67_1_0
;;case 01100111
;;mode : 01100111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 2, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_68_1_0
;;case 01101000
;;mode : 01101000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_69_1_0
;;case 01101001
;;mode : 01101001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_6A_1_0
;;case 01101010
;;mode : 01101010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_6B_1_0
;;case 01101011
;;mode : 01101011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_6C_1_0
;;case 01101100
;;mode : 01101100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_6D_1_0
;;case 01101101
;;mode : 01101101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_6E_1_0
;;case 01101110
;;mode : 01101110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_6F_1_0
;;case 01101111
;;mode : 01101111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
		NEXT_COL8
;;----------------------------------------

PPU8_70_1_0
;;case 01110000
;;mode : 01110000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		str		R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_71_1_0
;;case 01110001
;;mode : 01110001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_72_1_0
;;case 01110010
;;mode : 01110010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strh	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_73_1_0
;;case 01110011
;;mode : 01110011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strh	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_74_1_0
;;case 01110100
;;mode : 01110100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_75_1_0
;;case 01110101
;;mode : 01110101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_76_1_0
;;case 01110110
;;mode : 01110110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_77_1_0
;;case 01110111
;;mode : 01110111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_78_1_0
;;case 01111000
;;mode : 01111000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#5
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_79_1_0
;;case 01111001
;;mode : 01111001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#5
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_7A_1_0
;;case 01111010
;;mode : 01111010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#5
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_7B_1_0
;;case 01111011
;;mode : 01111011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#5
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_7C_1_0
;;case 01111100
;;mode : 01111100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 5
		ldrb	R0,[R11]
		add		R11,R11,#6
		strb	R0,[R12],#6
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_7D_1_0
;;case 01111101
;;mode : 01111101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 5
		ldrb	R0,[R11]
		add		R11,R11,#6
		strb	R0,[R12],#6
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_7E_1_0
;;case 01111110
;;mode : 01111110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 6
		ldrb	R0,[R11]
		add		R11,R11,#7
		strb	R0,[R12],#7
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_7F_1_0
;;case 01111111
;;mode : 01111111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 7
		ldrb	R0,[R11]
		add		R11,R11,#8
		strb	R0,[R12],#8
		NEXT_COL8
;;----------------------------------------


PPU8_80_1_0
;;case 10000000
;;mode : 10000000 => first pix:1
	;;Pos : 1, Pix opaque : 7, Pix transp : 0
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
	ldmia	R11!,{R0}
		str		R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_81_1_0
;;case 10000001
;;mode : 10000001 => first pix:1
	;;Pos : 1, Pix opaque : 6, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_82_1_0
;;case 10000010
;;mode : 10000010 => first pix:1
	;;Pos : 1, Pix opaque : 5, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strh	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_83_1_0
;;case 10000011
;;mode : 10000011 => first pix:1
	;;Pos : 1, Pix opaque : 5, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strh	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_84_1_0
;;case 10000100
;;mode : 10000100 => first pix:1
	;;Pos : 1, Pix opaque : 4, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_85_1_0
;;case 10000101
;;mode : 10000101 => first pix:1
	;;Pos : 1, Pix opaque : 4, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_86_1_0
;;case 10000110
;;mode : 10000110 => first pix:1
	;;Pos : 1, Pix opaque : 4, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_87_1_0
;;case 10000111
;;mode : 10000111 => first pix:1
	;;Pos : 1, Pix opaque : 4, Pix transp : 3
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_88_1_0
;;case 10001000
;;mode : 10001000 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_89_1_0
;;case 10001001
;;mode : 10001001 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_8A_1_0
;;case 10001010
;;mode : 10001010 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_8B_1_0
;;case 10001011
;;mode : 10001011 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_8C_1_0
;;case 10001100
;;mode : 10001100 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_8D_1_0
;;case 10001101
;;mode : 10001101 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_8E_1_0
;;case 10001110
;;mode : 10001110 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 3
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_8F_1_0
;;case 10001111
;;mode : 10001111 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 4
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
		NEXT_COL8
;;----------------------------------------

PPU8_90_1_0
;;case 10010000
;;mode : 10010000 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		str		R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_91_1_0
;;case 10010001
;;mode : 10010001 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_92_1_0
;;case 10010010
;;mode : 10010010 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strh	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_93_1_0
;;case 10010011
;;mode : 10010011 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strh	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_94_1_0
;;case 10010100
;;mode : 10010100 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_95_1_0
;;case 10010101
;;mode : 10010101 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_96_1_0
;;case 10010110
;;mode : 10010110 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_97_1_0
;;case 10010111
;;mode : 10010111 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_98_1_0
;;case 10011000
;;mode : 10011000 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_99_1_0
;;case 10011001
;;mode : 10011001 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_9A_1_0
;;case 10011010
;;mode : 10011010 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_9B_1_0
;;case 10011011
;;mode : 10011011 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_9C_1_0
;;case 10011100
;;mode : 10011100 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 3
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_9D_1_0
;;case 10011101
;;mode : 10011101 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 3
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_9E_1_0
;;case 10011110
;;mode : 10011110 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 4
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_9F_1_0
;;case 10011111
;;mode : 10011111 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 5
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#6
		strb	R0,[R12],#6
		NEXT_COL8
;;----------------------------------------

PPU8_A0_1_0
;;case 10100000
;;mode : 10100000 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 5, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
	ldmia	R11!,{R0}
		str		R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_A1_1_0
;;case 10100001
;;mode : 10100001 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 4, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_A2_1_0
;;case 10100010
;;mode : 10100010 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strh	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_A3_1_0
;;case 10100011
;;mode : 10100011 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 3, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strh	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_A4_1_0
;;case 10100100
;;mode : 10100100 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_A5_1_0
;;case 10100101
;;mode : 10100101 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_A6_1_0
;;case 10100110
;;mode : 10100110 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_A7_1_0
;;case 10100111
;;mode : 10100111 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 2, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_A8_1_0
;;case 10101000
;;mode : 10101000 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_A9_1_0
;;case 10101001
;;mode : 10101001 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_AA_1_0
;;case 10101010
;;mode : 10101010 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_AB_1_0
;;case 10101011
;;mode : 10101011 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_AC_1_0
;;case 10101100
;;mode : 10101100 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_AD_1_0
;;case 10101101
;;mode : 10101101 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_AE_1_0
;;case 10101110
;;mode : 10101110 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_AF_1_0
;;case 10101111
;;mode : 10101111 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
		NEXT_COL8
;;----------------------------------------

PPU8_B0_1_0
;;case 10110000
;;mode : 10110000 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		str		R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_B1_1_0
;;case 10110001
;;mode : 10110001 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_B2_1_0
;;case 10110010
;;mode : 10110010 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strh	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_B3_1_0
;;case 10110011
;;mode : 10110011 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strh	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_B4_1_0
;;case 10110100
;;mode : 10110100 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_B5_1_0
;;case 10110101
;;mode : 10110101 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_B6_1_0
;;case 10110110
;;mode : 10110110 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_B7_1_0
;;case 10110111
;;mode : 10110111 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_B8_1_0
;;case 10111000
;;mode : 10111000 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_B9_1_0
;;case 10111001
;;mode : 10111001 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_BA_1_0
;;case 10111010
;;mode : 10111010 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_BB_1_0
;;case 10111011
;;mode : 10111011 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_BC_1_0
;;case 10111100
;;mode : 10111100 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 4
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_BD_1_0
;;case 10111101
;;mode : 10111101 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 4
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_BE_1_0
;;case 10111110
;;mode : 10111110 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 5
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#6
		strb	R0,[R12],#6
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_BF_1_0
;;case 10111111
;;mode : 10111111 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 6
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#7
		strb	R0,[R12],#7
		NEXT_COL8
;;----------------------------------------

PPU8_C0_1_0
;;case 11000000
;;mode : 11000000 => first pix:2
	;;Pos : 2, Pix opaque : 6, Pix transp : 0
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
	ldmia	R11!,{R0}
		str		R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_C1_1_0
;;case 11000001
;;mode : 11000001 => first pix:2
	;;Pos : 2, Pix opaque : 5, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_C2_1_0
;;case 11000010
;;mode : 11000010 => first pix:2
	;;Pos : 2, Pix opaque : 4, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strh	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_C3_1_0
;;case 11000011
;;mode : 11000011 => first pix:2
	;;Pos : 2, Pix opaque : 4, Pix transp : 2
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strh	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_C4_1_0
;;case 11000100
;;mode : 11000100 => first pix:2
	;;Pos : 2, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_C5_1_0
;;case 11000101
;;mode : 11000101 => first pix:2
	;;Pos : 2, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_C6_1_0
;;case 11000110
;;mode : 11000110 => first pix:2
	;;Pos : 2, Pix opaque : 3, Pix transp : 2
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_C7_1_0
;;case 11000111
;;mode : 11000111 => first pix:2
	;;Pos : 2, Pix opaque : 3, Pix transp : 3
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_C8_1_0
;;case 11001000
;;mode : 11001000 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_C9_1_0
;;case 11001001
;;mode : 11001001 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_CA_1_0
;;case 11001010
;;mode : 11001010 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_CB_1_0
;;case 11001011
;;mode : 11001011 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_CC_1_0
;;case 11001100
;;mode : 11001100 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_CD_1_0
;;case 11001101
;;mode : 11001101 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_CE_1_0
;;case 11001110
;;mode : 11001110 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 3
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_CF_1_0
;;case 11001111
;;mode : 11001111 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 4
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
		NEXT_COL8
;;----------------------------------------

PPU8_D0_1_0
;;case 11010000
;;mode : 11010000 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		str		R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_D1_1_0
;;case 11010001
;;mode : 11010001 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_D2_1_0
;;case 11010010
;;mode : 11010010 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strh	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_D3_1_0
;;case 11010011
;;mode : 11010011 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strh	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_D4_1_0
;;case 11010100
;;mode : 11010100 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_D5_1_0
;;case 11010101
;;mode : 11010101 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_D6_1_0
;;case 11010110
;;mode : 11010110 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_D7_1_0
;;case 11010111
;;mode : 11010111 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_D8_1_0
;;case 11011000
;;mode : 11011000 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_D9_1_0
;;case 11011001
;;mode : 11011001 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_DA_1_0
;;case 11011010
;;mode : 11011010 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_DB_1_0
;;case 11011011
;;mode : 11011011 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_DC_1_0
;;case 11011100
;;mode : 11011100 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_DD_1_0
;;case 11011101
;;mode : 11011101 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_DE_1_0
;;case 11011110
;;mode : 11011110 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 4
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_DF_1_0
;;case 11011111
;;mode : 11011111 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 5
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#6
		strb	R0,[R12],#6
		NEXT_COL8
;;----------------------------------------

PPU8_E0_1_0
;;case 11100000
;;mode : 11100000 => first pix:3
	;;Pos : 3, Pix opaque : 5, Pix transp : 0
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
	ldmia	R11!,{R0}
		str		R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_E1_1_0
;;case 11100001
;;mode : 11100001 => first pix:3
	;;Pos : 3, Pix opaque : 4, Pix transp : 1
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_E2_1_0
;;case 11100010
;;mode : 11100010 => first pix:3
	;;Pos : 3, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strh	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_E3_1_0
;;case 11100011
;;mode : 11100011 => first pix:3
	;;Pos : 3, Pix opaque : 3, Pix transp : 2
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strh	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_E4_1_0
;;case 11100100
;;mode : 11100100 => first pix:3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_E5_1_0
;;case 11100101
;;mode : 11100101 => first pix:3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_E6_1_0
;;case 11100110
;;mode : 11100110 => first pix:3
	;;Pos : 3, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_E7_1_0
;;case 11100111
;;mode : 11100111 => first pix:3
	;;Pos : 3, Pix opaque : 2, Pix transp : 3
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_E8_1_0
;;case 11101000
;;mode : 11101000 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_E9_1_0
;;case 11101001
;;mode : 11101001 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_EA_1_0
;;case 11101010
;;mode : 11101010 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_EB_1_0
;;case 11101011
;;mode : 11101011 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_EC_1_0
;;case 11101100
;;mode : 11101100 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_ED_1_0
;;case 11101101
;;mode : 11101101 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_EE_1_0
;;case 11101110
;;mode : 11101110 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_EF_1_0
;;case 11101111
;;mode : 11101111 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 4
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
		NEXT_COL8
;;----------------------------------------

PPU8_F0_1_0
;;case 11110000
;;mode : 11110000 => first pix:4
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
		add	R11,R11,#4
		add	R12,R12,#4
	ldmia	R11!,{R0}
		str		R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_F1_1_0
;;case 11110001
;;mode : 11110001 => first pix:4
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#4
		add	R12,R12,#4
		ldmia	R11,{R0}
		add		R11,R11,#4
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_F2_1_0
;;case 11110010
;;mode : 11110010 => first pix:4
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#4
		add	R12,R12,#4
		ldrh	R0,[R11]
		add		R11,R11,#3
		strh	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_F3_1_0
;;case 11110011
;;mode : 11110011 => first pix:4
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#4
		add	R12,R12,#4
		ldrh	R0,[R11]
		add		R11,R11,#4
		strh	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_F4_1_0
;;case 11110100
;;mode : 11110100 => first pix:4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#4
		add	R12,R12,#4
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_F5_1_0
;;case 11110101
;;mode : 11110101 => first pix:4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#4
		add	R12,R12,#4
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_F6_1_0
;;case 11110110
;;mode : 11110110 => first pix:4
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#4
		add	R12,R12,#4
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_F7_1_0
;;case 11110111
;;mode : 11110111 => first pix:4
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#4
		add	R12,R12,#4
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_F8_1_0
;;case 11111000
;;mode : 11111000 => first pix:5
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		add	R11,R11,#5
		add	R12,R12,#5
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_F9_1_0
;;case 11111001
;;mode : 11111001 => first pix:5
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#5
		add	R12,R12,#5
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_FA_1_0
;;case 11111010
;;mode : 11111010 => first pix:5
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#5
		add	R12,R12,#5
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_FB_1_0
;;case 11111011
;;mode : 11111011 => first pix:5
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#5
		add	R12,R12,#5
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_FC_1_0
;;case 11111100
;;mode : 11111100 => first pix:6
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		add	R11,R11,#6
		add	R12,R12,#6
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_FD_1_0
;;case 11111101
;;mode : 11111101 => first pix:6
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#6
		add	R12,R12,#6
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_FE_1_0
;;case 11111110
;;mode : 11111110 => first pix:7
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		add	R11,R11,#7
		add	R12,R12,#7
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_FF_1_0
;;case 11111111
		add		R11,R11,#8
		add		R12,R12,#8
		NEXT_COL8
;;----------------------------------------
jumptable_ppu810
		DCD		PPU8_00_1_0
		DCD		PPU8_01_1_0
		DCD		PPU8_02_1_0
		DCD		PPU8_03_1_0
		DCD		PPU8_04_1_0
		DCD		PPU8_05_1_0
		DCD		PPU8_06_1_0
		DCD		PPU8_07_1_0
		DCD		PPU8_08_1_0
		DCD		PPU8_09_1_0
		DCD		PPU8_0A_1_0
		DCD		PPU8_0B_1_0
		DCD		PPU8_0C_1_0
		DCD		PPU8_0D_1_0
		DCD		PPU8_0E_1_0
		DCD		PPU8_0F_1_0
		DCD		PPU8_10_1_0
		DCD		PPU8_11_1_0
		DCD		PPU8_12_1_0
		DCD		PPU8_13_1_0
		DCD		PPU8_14_1_0
		DCD		PPU8_15_1_0
		DCD		PPU8_16_1_0
		DCD		PPU8_17_1_0
		DCD		PPU8_18_1_0
		DCD		PPU8_19_1_0
		DCD		PPU8_1A_1_0
		DCD		PPU8_1B_1_0
		DCD		PPU8_1C_1_0
		DCD		PPU8_1D_1_0
		DCD		PPU8_1E_1_0
		DCD		PPU8_1F_1_0
		DCD		PPU8_20_1_0
		DCD		PPU8_21_1_0
		DCD		PPU8_22_1_0
		DCD		PPU8_23_1_0
		DCD		PPU8_24_1_0
		DCD		PPU8_25_1_0
		DCD		PPU8_26_1_0
		DCD		PPU8_27_1_0
		DCD		PPU8_28_1_0
		DCD		PPU8_29_1_0
		DCD		PPU8_2A_1_0
		DCD		PPU8_2B_1_0
		DCD		PPU8_2C_1_0
		DCD		PPU8_2D_1_0
		DCD		PPU8_2E_1_0
		DCD		PPU8_2F_1_0
		DCD		PPU8_30_1_0
		DCD		PPU8_31_1_0
		DCD		PPU8_32_1_0
		DCD		PPU8_33_1_0
		DCD		PPU8_34_1_0
		DCD		PPU8_35_1_0
		DCD		PPU8_36_1_0
		DCD		PPU8_37_1_0
		DCD		PPU8_38_1_0
		DCD		PPU8_39_1_0
		DCD		PPU8_3A_1_0
		DCD		PPU8_3B_1_0
		DCD		PPU8_3C_1_0
		DCD		PPU8_3D_1_0
		DCD		PPU8_3E_1_0
		DCD		PPU8_3F_1_0
		DCD		PPU8_40_1_0
		DCD		PPU8_41_1_0
		DCD		PPU8_42_1_0
		DCD		PPU8_43_1_0
		DCD		PPU8_44_1_0
		DCD		PPU8_45_1_0
		DCD		PPU8_46_1_0
		DCD		PPU8_47_1_0
		DCD		PPU8_48_1_0
		DCD		PPU8_49_1_0
		DCD		PPU8_4A_1_0
		DCD		PPU8_4B_1_0
		DCD		PPU8_4C_1_0
		DCD		PPU8_4D_1_0
		DCD		PPU8_4E_1_0
		DCD		PPU8_4F_1_0
		DCD		PPU8_50_1_0
		DCD		PPU8_51_1_0
		DCD		PPU8_52_1_0
		DCD		PPU8_53_1_0
		DCD		PPU8_54_1_0
		DCD		PPU8_55_1_0
		DCD		PPU8_56_1_0
		DCD		PPU8_57_1_0
		DCD		PPU8_58_1_0
		DCD		PPU8_59_1_0
		DCD		PPU8_5A_1_0
		DCD		PPU8_5B_1_0
		DCD		PPU8_5C_1_0
		DCD		PPU8_5D_1_0
		DCD		PPU8_5E_1_0
		DCD		PPU8_5F_1_0
		DCD		PPU8_60_1_0
		DCD		PPU8_61_1_0
		DCD		PPU8_62_1_0
		DCD		PPU8_63_1_0
		DCD		PPU8_64_1_0
		DCD		PPU8_65_1_0
		DCD		PPU8_66_1_0
		DCD		PPU8_67_1_0
		DCD		PPU8_68_1_0
		DCD		PPU8_69_1_0
		DCD		PPU8_6A_1_0
		DCD		PPU8_6B_1_0
		DCD		PPU8_6C_1_0
		DCD		PPU8_6D_1_0
		DCD		PPU8_6E_1_0
		DCD		PPU8_6F_1_0
		DCD		PPU8_70_1_0
		DCD		PPU8_71_1_0
		DCD		PPU8_72_1_0
		DCD		PPU8_73_1_0
		DCD		PPU8_74_1_0
		DCD		PPU8_75_1_0
		DCD		PPU8_76_1_0
		DCD		PPU8_77_1_0
		DCD		PPU8_78_1_0
		DCD		PPU8_79_1_0
		DCD		PPU8_7A_1_0
		DCD		PPU8_7B_1_0
		DCD		PPU8_7C_1_0
		DCD		PPU8_7D_1_0
		DCD		PPU8_7E_1_0
		DCD		PPU8_7F_1_0
		DCD		PPU8_80_1_0
		DCD		PPU8_81_1_0
		DCD		PPU8_82_1_0
		DCD		PPU8_83_1_0
		DCD		PPU8_84_1_0
		DCD		PPU8_85_1_0
		DCD		PPU8_86_1_0
		DCD		PPU8_87_1_0
		DCD		PPU8_88_1_0
		DCD		PPU8_89_1_0
		DCD		PPU8_8A_1_0
		DCD		PPU8_8B_1_0
		DCD		PPU8_8C_1_0
		DCD		PPU8_8D_1_0
		DCD		PPU8_8E_1_0
		DCD		PPU8_8F_1_0
		DCD		PPU8_90_1_0
		DCD		PPU8_91_1_0
		DCD		PPU8_92_1_0
		DCD		PPU8_93_1_0
		DCD		PPU8_94_1_0
		DCD		PPU8_95_1_0
		DCD		PPU8_96_1_0
		DCD		PPU8_97_1_0
		DCD		PPU8_98_1_0
		DCD		PPU8_99_1_0
		DCD		PPU8_9A_1_0
		DCD		PPU8_9B_1_0
		DCD		PPU8_9C_1_0
		DCD		PPU8_9D_1_0
		DCD		PPU8_9E_1_0
		DCD		PPU8_9F_1_0
		DCD		PPU8_A0_1_0
		DCD		PPU8_A1_1_0
		DCD		PPU8_A2_1_0
		DCD		PPU8_A3_1_0
		DCD		PPU8_A4_1_0
		DCD		PPU8_A5_1_0
		DCD		PPU8_A6_1_0
		DCD		PPU8_A7_1_0
		DCD		PPU8_A8_1_0
		DCD		PPU8_A9_1_0
		DCD		PPU8_AA_1_0
		DCD		PPU8_AB_1_0
		DCD		PPU8_AC_1_0
		DCD		PPU8_AD_1_0
		DCD		PPU8_AE_1_0
		DCD		PPU8_AF_1_0
		DCD		PPU8_B0_1_0
		DCD		PPU8_B1_1_0
		DCD		PPU8_B2_1_0
		DCD		PPU8_B3_1_0
		DCD		PPU8_B4_1_0
		DCD		PPU8_B5_1_0
		DCD		PPU8_B6_1_0
		DCD		PPU8_B7_1_0
		DCD		PPU8_B8_1_0
		DCD		PPU8_B9_1_0
		DCD		PPU8_BA_1_0
		DCD		PPU8_BB_1_0
		DCD		PPU8_BC_1_0
		DCD		PPU8_BD_1_0
		DCD		PPU8_BE_1_0
		DCD		PPU8_BF_1_0
		DCD		PPU8_C0_1_0
		DCD		PPU8_C1_1_0
		DCD		PPU8_C2_1_0
		DCD		PPU8_C3_1_0
		DCD		PPU8_C4_1_0
		DCD		PPU8_C5_1_0
		DCD		PPU8_C6_1_0
		DCD		PPU8_C7_1_0
		DCD		PPU8_C8_1_0
		DCD		PPU8_C9_1_0
		DCD		PPU8_CA_1_0
		DCD		PPU8_CB_1_0
		DCD		PPU8_CC_1_0
		DCD		PPU8_CD_1_0
		DCD		PPU8_CE_1_0
		DCD		PPU8_CF_1_0
		DCD		PPU8_D0_1_0
		DCD		PPU8_D1_1_0
		DCD		PPU8_D2_1_0
		DCD		PPU8_D3_1_0
		DCD		PPU8_D4_1_0
		DCD		PPU8_D5_1_0
		DCD		PPU8_D6_1_0
		DCD		PPU8_D7_1_0
		DCD		PPU8_D8_1_0
		DCD		PPU8_D9_1_0
		DCD		PPU8_DA_1_0
		DCD		PPU8_DB_1_0
		DCD		PPU8_DC_1_0
		DCD		PPU8_DD_1_0
		DCD		PPU8_DE_1_0
		DCD		PPU8_DF_1_0
		DCD		PPU8_E0_1_0
		DCD		PPU8_E1_1_0
		DCD		PPU8_E2_1_0
		DCD		PPU8_E3_1_0
		DCD		PPU8_E4_1_0
		DCD		PPU8_E5_1_0
		DCD		PPU8_E6_1_0
		DCD		PPU8_E7_1_0
		DCD		PPU8_E8_1_0
		DCD		PPU8_E9_1_0
		DCD		PPU8_EA_1_0
		DCD		PPU8_EB_1_0
		DCD		PPU8_EC_1_0
		DCD		PPU8_ED_1_0
		DCD		PPU8_EE_1_0
		DCD		PPU8_EF_1_0
		DCD		PPU8_F0_1_0
		DCD		PPU8_F1_1_0
		DCD		PPU8_F2_1_0
		DCD		PPU8_F3_1_0
		DCD		PPU8_F4_1_0
		DCD		PPU8_F5_1_0
		DCD		PPU8_F6_1_0
		DCD		PPU8_F7_1_0
		DCD		PPU8_F8_1_0
		DCD		PPU8_F9_1_0
		DCD		PPU8_FA_1_0
		DCD		PPU8_FB_1_0
		DCD		PPU8_FC_1_0
		DCD		PPU8_FD_1_0
		DCD		PPU8_FE_1_0
		DCD		PPU8_FF_1_0


PPU8_00_0_1
;;case 00000000
;;mode : 00000000 => first pix:0
	;;Pos : 0, Pix opaque : 8, Pix transp : 0
		ldmia	R11!,{R0,R1}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		strb	R1,[R12],#-1
		mov		R1,R1,lsr #8
		strb	R1,[R12],#-1
		mov		R1,R1,lsr #8
		strb	R1,[R12],#-1
		mov		R1,R1,lsr #8
		strb	R1,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_01_0_1
;;case 00000001
;;mode : 00000001 => first pix:0
	;;Pos : 0, Pix opaque : 7, Pix transp : 1
		ldmia	R11!,{R0,R1}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		strb	R1,[R12],#-1
		mov		R1,R1,lsr #8
		strb	R1,[R12],#-1
		mov		R1,R1,lsr #8
		strb	R1,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_02_0_1
;;case 00000010
;;mode : 00000010 => first pix:0
	;;Pos : 0, Pix opaque : 6, Pix transp : 1
		ldmia	R11,{R0,R1}
		add		R11,R11,#7
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		strb	R1,[R12],#-1
		mov		R1,R1,lsr #8
		strb	R1,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_03_0_1
;;case 00000011
;;mode : 00000011 => first pix:0
	;;Pos : 0, Pix opaque : 6, Pix transp : 2
		ldmia	R11,{R0,R1}
		add		R11,R11,#8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		strb	R1,[R12],#-1
		mov		R1,R1,lsr #8
		strb	R1,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_04_0_1
;;case 00000100
;;mode : 00000100 => first pix:0
	;;Pos : 0, Pix opaque : 5, Pix transp : 1
		ldmia	R11,{R0,R1}
		add		R11,R11,#6
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		strb	R1,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_05_0_1
;;case 00000101
;;mode : 00000101 => first pix:0
	;;Pos : 0, Pix opaque : 5, Pix transp : 1
		ldmia	R11,{R0,R1}
		add		R11,R11,#6
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		strb	R1,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_06_0_1
;;case 00000110
;;mode : 00000110 => first pix:0
	;;Pos : 0, Pix opaque : 5, Pix transp : 2
		ldmia	R11,{R0,R1}
		add		R11,R11,#7
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		strb	R1,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_07_0_1
;;case 00000111
;;mode : 00000111 => first pix:0
	;;Pos : 0, Pix opaque : 5, Pix transp : 3
		ldmia	R11,{R0,R1}
		add		R11,R11,#8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		strb	R1,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_08_0_1
;;case 00001000
;;mode : 00001000 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_09_0_1
;;case 00001001
;;mode : 00001001 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_0A_0_1
;;case 00001010
;;mode : 00001010 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_0B_0_1
;;case 00001011
;;mode : 00001011 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_0C_0_1
;;case 00001100
;;mode : 00001100 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#6
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_0D_0_1
;;case 00001101
;;mode : 00001101 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#6
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_0E_0_1
;;case 00001110
;;mode : 00001110 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 3
		ldmia	R11,{R0}
		add		R11,R11,#7
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_0F_0_1
;;case 00001111
;;mode : 00001111 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 4
		ldmia	R11,{R0}
		add		R11,R11,#8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-5
		NEXT_COL8
;;----------------------------------------

PPU8_10_0_1
;;case 00010000
;;mode : 00010000 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_11_0_1
;;case 00010001
;;mode : 00010001 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_12_0_1
;;case 00010010
;;mode : 00010010 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_13_0_1
;;case 00010011
;;mode : 00010011 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_14_0_1
;;case 00010100
;;mode : 00010100 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_15_0_1
;;case 00010101
;;mode : 00010101 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_16_0_1
;;case 00010110
;;mode : 00010110 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_17_0_1
;;case 00010111
;;mode : 00010111 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_18_0_1
;;case 00011000
;;mode : 00011000 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_19_0_1
;;case 00011001
;;mode : 00011001 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_1A_0_1
;;case 00011010
;;mode : 00011010 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_1B_0_1
;;case 00011011
;;mode : 00011011 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_1C_0_1
;;case 00011100
;;mode : 00011100 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 3
		ldmia	R11,{R0}
		add		R11,R11,#6
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-4
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_1D_0_1
;;case 00011101
;;mode : 00011101 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 3
		ldmia	R11,{R0}
		add		R11,R11,#6
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-4
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_1E_0_1
;;case 00011110
;;mode : 00011110 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 4
		ldmia	R11,{R0}
		add		R11,R11,#7
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-5
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_1F_0_1
;;case 00011111
;;mode : 00011111 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 5
		ldmia	R11,{R0}
		add		R11,R11,#8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-6
		NEXT_COL8
;;----------------------------------------

PPU8_20_0_1
;;case 00100000
;;mode : 00100000 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 5, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_21_0_1
;;case 00100001
;;mode : 00100001 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 4, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_22_0_1
;;case 00100010
;;mode : 00100010 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_23_0_1
;;case 00100011
;;mode : 00100011 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 3, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_24_0_1
;;case 00100100
;;mode : 00100100 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_25_0_1
;;case 00100101
;;mode : 00100101 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_26_0_1
;;case 00100110
;;mode : 00100110 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_27_0_1
;;case 00100111
;;mode : 00100111 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 2, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_28_0_1
;;case 00101000
;;mode : 00101000 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_29_0_1
;;case 00101001
;;mode : 00101001 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_2A_0_1
;;case 00101010
;;mode : 00101010 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_2B_0_1
;;case 00101011
;;mode : 00101011 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_2C_0_1
;;case 00101100
;;mode : 00101100 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_2D_0_1
;;case 00101101
;;mode : 00101101 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_2E_0_1
;;case 00101110
;;mode : 00101110 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_2F_0_1
;;case 00101111
;;mode : 00101111 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
		NEXT_COL8
;;----------------------------------------

PPU8_30_0_1
;;case 00110000
;;mode : 00110000 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_31_0_1
;;case 00110001
;;mode : 00110001 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_32_0_1
;;case 00110010
;;mode : 00110010 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_33_0_1
;;case 00110011
;;mode : 00110011 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_34_0_1
;;case 00110100
;;mode : 00110100 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_35_0_1
;;case 00110101
;;mode : 00110101 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_36_0_1
;;case 00110110
;;mode : 00110110 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_37_0_1
;;case 00110111
;;mode : 00110111 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_38_0_1
;;case 00111000
;;mode : 00111000 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 3
		ldrh	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-4
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_39_0_1
;;case 00111001
;;mode : 00111001 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 3
		ldrh	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-4
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_3A_0_1
;;case 00111010
;;mode : 00111010 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 3
		ldrh	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-4
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_3B_0_1
;;case 00111011
;;mode : 00111011 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 3
		ldrh	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-4
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_3C_0_1
;;case 00111100
;;mode : 00111100 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 4
		ldrh	R0,[R11]
		add		R11,R11,#6
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-5
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_3D_0_1
;;case 00111101
;;mode : 00111101 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 4
		ldrh	R0,[R11]
		add		R11,R11,#6
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-5
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_3E_0_1
;;case 00111110
;;mode : 00111110 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 5
		ldrh	R0,[R11]
		add		R11,R11,#7
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-6
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_3F_0_1
;;case 00111111
;;mode : 00111111 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 6
		ldrh	R0,[R11]
		add		R11,R11,#8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-7
		NEXT_COL8
;;----------------------------------------

PPU8_40_0_1
;;case 01000000
;;mode : 01000000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 6, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_41_0_1
;;case 01000001
;;mode : 01000001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 5, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_42_0_1
;;case 01000010
;;mode : 01000010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 4, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_43_0_1
;;case 01000011
;;mode : 01000011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 4, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_44_0_1
;;case 01000100
;;mode : 01000100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_45_0_1
;;case 01000101
;;mode : 01000101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_46_0_1
;;case 01000110
;;mode : 01000110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 3, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_47_0_1
;;case 01000111
;;mode : 01000111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 3, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_48_0_1
;;case 01001000
;;mode : 01001000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_49_0_1
;;case 01001001
;;mode : 01001001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_4A_0_1
;;case 01001010
;;mode : 01001010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_4B_0_1
;;case 01001011
;;mode : 01001011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_4C_0_1
;;case 01001100
;;mode : 01001100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_4D_0_1
;;case 01001101
;;mode : 01001101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_4E_0_1
;;case 01001110
;;mode : 01001110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 2, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_4F_0_1
;;case 01001111
;;mode : 01001111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 2, Pix transp : 4
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
		NEXT_COL8
;;----------------------------------------

PPU8_50_0_1
;;case 01010000
;;mode : 01010000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_51_0_1
;;case 01010001
;;mode : 01010001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_52_0_1
;;case 01010010
;;mode : 01010010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_53_0_1
;;case 01010011
;;mode : 01010011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_54_0_1
;;case 01010100
;;mode : 01010100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_55_0_1
;;case 01010101
;;mode : 01010101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_56_0_1
;;case 01010110
;;mode : 01010110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_57_0_1
;;case 01010111
;;mode : 01010111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_58_0_1
;;case 01011000
;;mode : 01011000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_59_0_1
;;case 01011001
;;mode : 01011001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_5A_0_1
;;case 01011010
;;mode : 01011010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_5B_0_1
;;case 01011011
;;mode : 01011011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_5C_0_1
;;case 01011100
;;mode : 01011100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_5D_0_1
;;case 01011101
;;mode : 01011101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_5E_0_1
;;case 01011110
;;mode : 01011110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_5F_0_1
;;case 01011111
;;mode : 01011111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 5
		ldrb	R0,[R11],#6
		strb	R0,[R12],#-6
		NEXT_COL8
;;----------------------------------------

PPU8_60_0_1
;;case 01100000
;;mode : 01100000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 5, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_61_0_1
;;case 01100001
;;mode : 01100001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 4, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_62_0_1
;;case 01100010
;;mode : 01100010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_63_0_1
;;case 01100011
;;mode : 01100011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 3, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_64_0_1
;;case 01100100
;;mode : 01100100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_65_0_1
;;case 01100101
;;mode : 01100101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_66_0_1
;;case 01100110
;;mode : 01100110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_67_0_1
;;case 01100111
;;mode : 01100111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 2, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_68_0_1
;;case 01101000
;;mode : 01101000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_69_0_1
;;case 01101001
;;mode : 01101001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_6A_0_1
;;case 01101010
;;mode : 01101010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_6B_0_1
;;case 01101011
;;mode : 01101011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_6C_0_1
;;case 01101100
;;mode : 01101100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_6D_0_1
;;case 01101101
;;mode : 01101101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_6E_0_1
;;case 01101110
;;mode : 01101110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_6F_0_1
;;case 01101111
;;mode : 01101111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
		NEXT_COL8
;;----------------------------------------

PPU8_70_0_1
;;case 01110000
;;mode : 01110000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_71_0_1
;;case 01110001
;;mode : 01110001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_72_0_1
;;case 01110010
;;mode : 01110010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_73_0_1
;;case 01110011
;;mode : 01110011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_74_0_1
;;case 01110100
;;mode : 01110100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_75_0_1
;;case 01110101
;;mode : 01110101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_76_0_1
;;case 01110110
;;mode : 01110110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_77_0_1
;;case 01110111
;;mode : 01110111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_78_0_1
;;case 01111000
;;mode : 01111000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#-5
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_79_0_1
;;case 01111001
;;mode : 01111001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#-5
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_7A_0_1
;;case 01111010
;;mode : 01111010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#-5
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_7B_0_1
;;case 01111011
;;mode : 01111011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#-5
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_7C_0_1
;;case 01111100
;;mode : 01111100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 5
		ldrb	R0,[R11]
		add		R11,R11,#6
		strb	R0,[R12],#-6
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_7D_0_1
;;case 01111101
;;mode : 01111101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 5
		ldrb	R0,[R11]
		add		R11,R11,#6
		strb	R0,[R12],#-6
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_7E_0_1
;;case 01111110
;;mode : 01111110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 6
		ldrb	R0,[R11]
		add		R11,R11,#7
		strb	R0,[R12],#-7
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_7F_0_1
;;case 01111111
;;mode : 01111111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 7
		ldrb	R0,[R11]
		add		R11,R11,#8
		strb	R0,[R12],#-8
		NEXT_COL8
;;----------------------------------------


PPU8_80_0_1
;;case 10000000
;;mode : 10000000 => first pix:1
	;;Pos : 1, Pix opaque : 7, Pix transp : 0
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_81_0_1
;;case 10000001
;;mode : 10000001 => first pix:1
	;;Pos : 1, Pix opaque : 6, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_82_0_1
;;case 10000010
;;mode : 10000010 => first pix:1
	;;Pos : 1, Pix opaque : 5, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_83_0_1
;;case 10000011
;;mode : 10000011 => first pix:1
	;;Pos : 1, Pix opaque : 5, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_84_0_1
;;case 10000100
;;mode : 10000100 => first pix:1
	;;Pos : 1, Pix opaque : 4, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_85_0_1
;;case 10000101
;;mode : 10000101 => first pix:1
	;;Pos : 1, Pix opaque : 4, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_86_0_1
;;case 10000110
;;mode : 10000110 => first pix:1
	;;Pos : 1, Pix opaque : 4, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_87_0_1
;;case 10000111
;;mode : 10000111 => first pix:1
	;;Pos : 1, Pix opaque : 4, Pix transp : 3
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_88_0_1
;;case 10001000
;;mode : 10001000 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_89_0_1
;;case 10001001
;;mode : 10001001 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_8A_0_1
;;case 10001010
;;mode : 10001010 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_8B_0_1
;;case 10001011
;;mode : 10001011 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_8C_0_1
;;case 10001100
;;mode : 10001100 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_8D_0_1
;;case 10001101
;;mode : 10001101 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_8E_0_1
;;case 10001110
;;mode : 10001110 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 3
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_8F_0_1
;;case 10001111
;;mode : 10001111 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 4
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
		NEXT_COL8
;;----------------------------------------

PPU8_90_0_1
;;case 10010000
;;mode : 10010000 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_91_0_1
;;case 10010001
;;mode : 10010001 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_92_0_1
;;case 10010010
;;mode : 10010010 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_93_0_1
;;case 10010011
;;mode : 10010011 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_94_0_1
;;case 10010100
;;mode : 10010100 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_95_0_1
;;case 10010101
;;mode : 10010101 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_96_0_1
;;case 10010110
;;mode : 10010110 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_97_0_1
;;case 10010111
;;mode : 10010111 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_98_0_1
;;case 10011000
;;mode : 10011000 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_99_0_1
;;case 10011001
;;mode : 10011001 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_9A_0_1
;;case 10011010
;;mode : 10011010 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_9B_0_1
;;case 10011011
;;mode : 10011011 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_9C_0_1
;;case 10011100
;;mode : 10011100 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 3
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_9D_0_1
;;case 10011101
;;mode : 10011101 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 3
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_9E_0_1
;;case 10011110
;;mode : 10011110 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 4
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_9F_0_1
;;case 10011111
;;mode : 10011111 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 5
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#6
		strb	R0,[R12],#-6
		NEXT_COL8
;;----------------------------------------

PPU8_A0_0_1
;;case 10100000
;;mode : 10100000 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 5, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_A1_0_1
;;case 10100001
;;mode : 10100001 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 4, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_A2_0_1
;;case 10100010
;;mode : 10100010 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_A3_0_1
;;case 10100011
;;mode : 10100011 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 3, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_A4_0_1
;;case 10100100
;;mode : 10100100 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_A5_0_1
;;case 10100101
;;mode : 10100101 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_A6_0_1
;;case 10100110
;;mode : 10100110 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_A7_0_1
;;case 10100111
;;mode : 10100111 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 2, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_A8_0_1
;;case 10101000
;;mode : 10101000 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_A9_0_1
;;case 10101001
;;mode : 10101001 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_AA_0_1
;;case 10101010
;;mode : 10101010 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_AB_0_1
;;case 10101011
;;mode : 10101011 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_AC_0_1
;;case 10101100
;;mode : 10101100 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_AD_0_1
;;case 10101101
;;mode : 10101101 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_AE_0_1
;;case 10101110
;;mode : 10101110 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_AF_0_1
;;case 10101111
;;mode : 10101111 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
		NEXT_COL8
;;----------------------------------------

PPU8_B0_0_1
;;case 10110000
;;mode : 10110000 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_B1_0_1
;;case 10110001
;;mode : 10110001 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_B2_0_1
;;case 10110010
;;mode : 10110010 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_B3_0_1
;;case 10110011
;;mode : 10110011 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_B4_0_1
;;case 10110100
;;mode : 10110100 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_B5_0_1
;;case 10110101
;;mode : 10110101 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_B6_0_1
;;case 10110110
;;mode : 10110110 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_B7_0_1
;;case 10110111
;;mode : 10110111 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_B8_0_1
;;case 10111000
;;mode : 10111000 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_B9_0_1
;;case 10111001
;;mode : 10111001 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_BA_0_1
;;case 10111010
;;mode : 10111010 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_BB_0_1
;;case 10111011
;;mode : 10111011 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_BC_0_1
;;case 10111100
;;mode : 10111100 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 4
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_BD_0_1
;;case 10111101
;;mode : 10111101 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 4
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_BE_0_1
;;case 10111110
;;mode : 10111110 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 5
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#6
		strb	R0,[R12],#-6
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_BF_0_1
;;case 10111111
;;mode : 10111111 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 6
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#7
		strb	R0,[R12],#-7
		NEXT_COL8
;;----------------------------------------

PPU8_C0_0_1
;;case 11000000
;;mode : 11000000 => first pix:2
	;;Pos : 2, Pix opaque : 6, Pix transp : 0
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_C1_0_1
;;case 11000001
;;mode : 11000001 => first pix:2
	;;Pos : 2, Pix opaque : 5, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_C2_0_1
;;case 11000010
;;mode : 11000010 => first pix:2
	;;Pos : 2, Pix opaque : 4, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_C3_0_1
;;case 11000011
;;mode : 11000011 => first pix:2
	;;Pos : 2, Pix opaque : 4, Pix transp : 2
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_C4_0_1
;;case 11000100
;;mode : 11000100 => first pix:2
	;;Pos : 2, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_C5_0_1
;;case 11000101
;;mode : 11000101 => first pix:2
	;;Pos : 2, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_C6_0_1
;;case 11000110
;;mode : 11000110 => first pix:2
	;;Pos : 2, Pix opaque : 3, Pix transp : 2
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_C7_0_1
;;case 11000111
;;mode : 11000111 => first pix:2
	;;Pos : 2, Pix opaque : 3, Pix transp : 3
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_C8_0_1
;;case 11001000
;;mode : 11001000 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_C9_0_1
;;case 11001001
;;mode : 11001001 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_CA_0_1
;;case 11001010
;;mode : 11001010 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_CB_0_1
;;case 11001011
;;mode : 11001011 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_CC_0_1
;;case 11001100
;;mode : 11001100 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_CD_0_1
;;case 11001101
;;mode : 11001101 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_CE_0_1
;;case 11001110
;;mode : 11001110 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 3
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_CF_0_1
;;case 11001111
;;mode : 11001111 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 4
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
		NEXT_COL8
;;----------------------------------------

PPU8_D0_0_1
;;case 11010000
;;mode : 11010000 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_D1_0_1
;;case 11010001
;;mode : 11010001 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_D2_0_1
;;case 11010010
;;mode : 11010010 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_D3_0_1
;;case 11010011
;;mode : 11010011 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_D4_0_1
;;case 11010100
;;mode : 11010100 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_D5_0_1
;;case 11010101
;;mode : 11010101 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_D6_0_1
;;case 11010110
;;mode : 11010110 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_D7_0_1
;;case 11010111
;;mode : 11010111 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_D8_0_1
;;case 11011000
;;mode : 11011000 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_D9_0_1
;;case 11011001
;;mode : 11011001 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_DA_0_1
;;case 11011010
;;mode : 11011010 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_DB_0_1
;;case 11011011
;;mode : 11011011 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_DC_0_1
;;case 11011100
;;mode : 11011100 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_DD_0_1
;;case 11011101
;;mode : 11011101 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_DE_0_1
;;case 11011110
;;mode : 11011110 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 4
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_DF_0_1
;;case 11011111
;;mode : 11011111 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 5
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#6
		strb	R0,[R12],#-6
		NEXT_COL8
;;----------------------------------------

PPU8_E0_0_1
;;case 11100000
;;mode : 11100000 => first pix:3
	;;Pos : 3, Pix opaque : 5, Pix transp : 0
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_E1_0_1
;;case 11100001
;;mode : 11100001 => first pix:3
	;;Pos : 3, Pix opaque : 4, Pix transp : 1
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_E2_0_1
;;case 11100010
;;mode : 11100010 => first pix:3
	;;Pos : 3, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_E3_0_1
;;case 11100011
;;mode : 11100011 => first pix:3
	;;Pos : 3, Pix opaque : 3, Pix transp : 2
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_E4_0_1
;;case 11100100
;;mode : 11100100 => first pix:3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_E5_0_1
;;case 11100101
;;mode : 11100101 => first pix:3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_E6_0_1
;;case 11100110
;;mode : 11100110 => first pix:3
	;;Pos : 3, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_E7_0_1
;;case 11100111
;;mode : 11100111 => first pix:3
	;;Pos : 3, Pix opaque : 2, Pix transp : 3
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_E8_0_1
;;case 11101000
;;mode : 11101000 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_E9_0_1
;;case 11101001
;;mode : 11101001 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_EA_0_1
;;case 11101010
;;mode : 11101010 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_EB_0_1
;;case 11101011
;;mode : 11101011 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_EC_0_1
;;case 11101100
;;mode : 11101100 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_ED_0_1
;;case 11101101
;;mode : 11101101 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_EE_0_1
;;case 11101110
;;mode : 11101110 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_EF_0_1
;;case 11101111
;;mode : 11101111 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 4
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
		NEXT_COL8
;;----------------------------------------

PPU8_F0_0_1
;;case 11110000
;;mode : 11110000 => first pix:4
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
		add	R11,R11,#4
		sub	R12,R12,#4
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_F1_0_1
;;case 11110001
;;mode : 11110001 => first pix:4
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#4
		sub	R12,R12,#4
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_F2_0_1
;;case 11110010
;;mode : 11110010 => first pix:4
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#4
		sub	R12,R12,#4
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_F3_0_1
;;case 11110011
;;mode : 11110011 => first pix:4
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#4
		sub	R12,R12,#4
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_F4_0_1
;;case 11110100
;;mode : 11110100 => first pix:4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#4
		sub	R12,R12,#4
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_F5_0_1
;;case 11110101
;;mode : 11110101 => first pix:4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#4
		sub	R12,R12,#4
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_F6_0_1
;;case 11110110
;;mode : 11110110 => first pix:4
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#4
		sub	R12,R12,#4
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_F7_0_1
;;case 11110111
;;mode : 11110111 => first pix:4
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#4
		sub	R12,R12,#4
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_F8_0_1
;;case 11111000
;;mode : 11111000 => first pix:5
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		add	R11,R11,#5
		sub	R12,R12,#5
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_F9_0_1
;;case 11111001
;;mode : 11111001 => first pix:5
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#5
		sub	R12,R12,#5
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_FA_0_1
;;case 11111010
;;mode : 11111010 => first pix:5
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#5
		sub	R12,R12,#5
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_FB_0_1
;;case 11111011
;;mode : 11111011 => first pix:5
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#5
		sub	R12,R12,#5
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_FC_0_1
;;case 11111100
;;mode : 11111100 => first pix:6
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		add	R11,R11,#6
		sub	R12,R12,#6
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_FD_0_1
;;case 11111101
;;mode : 11111101 => first pix:6
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#6
		sub	R12,R12,#6
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_FE_0_1
;;case 11111110
;;mode : 11111110 => first pix:7
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		add	R11,R11,#7
		sub	R12,R12,#7
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_FF_0_1
;;case 11111111
		add		R11,R11,#8
		sub		R12,R12,#8
		NEXT_COL8
;;----------------------------------------
jumptable_ppu801
		DCD		PPU8_00_0_1
		DCD		PPU8_01_0_1
		DCD		PPU8_02_0_1
		DCD		PPU8_03_0_1
		DCD		PPU8_04_0_1
		DCD		PPU8_05_0_1
		DCD		PPU8_06_0_1
		DCD		PPU8_07_0_1
		DCD		PPU8_08_0_1
		DCD		PPU8_09_0_1
		DCD		PPU8_0A_0_1
		DCD		PPU8_0B_0_1
		DCD		PPU8_0C_0_1
		DCD		PPU8_0D_0_1
		DCD		PPU8_0E_0_1
		DCD		PPU8_0F_0_1
		DCD		PPU8_10_0_1
		DCD		PPU8_11_0_1
		DCD		PPU8_12_0_1
		DCD		PPU8_13_0_1
		DCD		PPU8_14_0_1
		DCD		PPU8_15_0_1
		DCD		PPU8_16_0_1
		DCD		PPU8_17_0_1
		DCD		PPU8_18_0_1
		DCD		PPU8_19_0_1
		DCD		PPU8_1A_0_1
		DCD		PPU8_1B_0_1
		DCD		PPU8_1C_0_1
		DCD		PPU8_1D_0_1
		DCD		PPU8_1E_0_1
		DCD		PPU8_1F_0_1
		DCD		PPU8_20_0_1
		DCD		PPU8_21_0_1
		DCD		PPU8_22_0_1
		DCD		PPU8_23_0_1
		DCD		PPU8_24_0_1
		DCD		PPU8_25_0_1
		DCD		PPU8_26_0_1
		DCD		PPU8_27_0_1
		DCD		PPU8_28_0_1
		DCD		PPU8_29_0_1
		DCD		PPU8_2A_0_1
		DCD		PPU8_2B_0_1
		DCD		PPU8_2C_0_1
		DCD		PPU8_2D_0_1
		DCD		PPU8_2E_0_1
		DCD		PPU8_2F_0_1
		DCD		PPU8_30_0_1
		DCD		PPU8_31_0_1
		DCD		PPU8_32_0_1
		DCD		PPU8_33_0_1
		DCD		PPU8_34_0_1
		DCD		PPU8_35_0_1
		DCD		PPU8_36_0_1
		DCD		PPU8_37_0_1
		DCD		PPU8_38_0_1
		DCD		PPU8_39_0_1
		DCD		PPU8_3A_0_1
		DCD		PPU8_3B_0_1
		DCD		PPU8_3C_0_1
		DCD		PPU8_3D_0_1
		DCD		PPU8_3E_0_1
		DCD		PPU8_3F_0_1
		DCD		PPU8_40_0_1
		DCD		PPU8_41_0_1
		DCD		PPU8_42_0_1
		DCD		PPU8_43_0_1
		DCD		PPU8_44_0_1
		DCD		PPU8_45_0_1
		DCD		PPU8_46_0_1
		DCD		PPU8_47_0_1
		DCD		PPU8_48_0_1
		DCD		PPU8_49_0_1
		DCD		PPU8_4A_0_1
		DCD		PPU8_4B_0_1
		DCD		PPU8_4C_0_1
		DCD		PPU8_4D_0_1
		DCD		PPU8_4E_0_1
		DCD		PPU8_4F_0_1
		DCD		PPU8_50_0_1
		DCD		PPU8_51_0_1
		DCD		PPU8_52_0_1
		DCD		PPU8_53_0_1
		DCD		PPU8_54_0_1
		DCD		PPU8_55_0_1
		DCD		PPU8_56_0_1
		DCD		PPU8_57_0_1
		DCD		PPU8_58_0_1
		DCD		PPU8_59_0_1
		DCD		PPU8_5A_0_1
		DCD		PPU8_5B_0_1
		DCD		PPU8_5C_0_1
		DCD		PPU8_5D_0_1
		DCD		PPU8_5E_0_1
		DCD		PPU8_5F_0_1
		DCD		PPU8_60_0_1
		DCD		PPU8_61_0_1
		DCD		PPU8_62_0_1
		DCD		PPU8_63_0_1
		DCD		PPU8_64_0_1
		DCD		PPU8_65_0_1
		DCD		PPU8_66_0_1
		DCD		PPU8_67_0_1
		DCD		PPU8_68_0_1
		DCD		PPU8_69_0_1
		DCD		PPU8_6A_0_1
		DCD		PPU8_6B_0_1
		DCD		PPU8_6C_0_1
		DCD		PPU8_6D_0_1
		DCD		PPU8_6E_0_1
		DCD		PPU8_6F_0_1
		DCD		PPU8_70_0_1
		DCD		PPU8_71_0_1
		DCD		PPU8_72_0_1
		DCD		PPU8_73_0_1
		DCD		PPU8_74_0_1
		DCD		PPU8_75_0_1
		DCD		PPU8_76_0_1
		DCD		PPU8_77_0_1
		DCD		PPU8_78_0_1
		DCD		PPU8_79_0_1
		DCD		PPU8_7A_0_1
		DCD		PPU8_7B_0_1
		DCD		PPU8_7C_0_1
		DCD		PPU8_7D_0_1
		DCD		PPU8_7E_0_1
		DCD		PPU8_7F_0_1
		DCD		PPU8_80_0_1
		DCD		PPU8_81_0_1
		DCD		PPU8_82_0_1
		DCD		PPU8_83_0_1
		DCD		PPU8_84_0_1
		DCD		PPU8_85_0_1
		DCD		PPU8_86_0_1
		DCD		PPU8_87_0_1
		DCD		PPU8_88_0_1
		DCD		PPU8_89_0_1
		DCD		PPU8_8A_0_1
		DCD		PPU8_8B_0_1
		DCD		PPU8_8C_0_1
		DCD		PPU8_8D_0_1
		DCD		PPU8_8E_0_1
		DCD		PPU8_8F_0_1
		DCD		PPU8_90_0_1
		DCD		PPU8_91_0_1
		DCD		PPU8_92_0_1
		DCD		PPU8_93_0_1
		DCD		PPU8_94_0_1
		DCD		PPU8_95_0_1
		DCD		PPU8_96_0_1
		DCD		PPU8_97_0_1
		DCD		PPU8_98_0_1
		DCD		PPU8_99_0_1
		DCD		PPU8_9A_0_1
		DCD		PPU8_9B_0_1
		DCD		PPU8_9C_0_1
		DCD		PPU8_9D_0_1
		DCD		PPU8_9E_0_1
		DCD		PPU8_9F_0_1
		DCD		PPU8_A0_0_1
		DCD		PPU8_A1_0_1
		DCD		PPU8_A2_0_1
		DCD		PPU8_A3_0_1
		DCD		PPU8_A4_0_1
		DCD		PPU8_A5_0_1
		DCD		PPU8_A6_0_1
		DCD		PPU8_A7_0_1
		DCD		PPU8_A8_0_1
		DCD		PPU8_A9_0_1
		DCD		PPU8_AA_0_1
		DCD		PPU8_AB_0_1
		DCD		PPU8_AC_0_1
		DCD		PPU8_AD_0_1
		DCD		PPU8_AE_0_1
		DCD		PPU8_AF_0_1
		DCD		PPU8_B0_0_1
		DCD		PPU8_B1_0_1
		DCD		PPU8_B2_0_1
		DCD		PPU8_B3_0_1
		DCD		PPU8_B4_0_1
		DCD		PPU8_B5_0_1
		DCD		PPU8_B6_0_1
		DCD		PPU8_B7_0_1
		DCD		PPU8_B8_0_1
		DCD		PPU8_B9_0_1
		DCD		PPU8_BA_0_1
		DCD		PPU8_BB_0_1
		DCD		PPU8_BC_0_1
		DCD		PPU8_BD_0_1
		DCD		PPU8_BE_0_1
		DCD		PPU8_BF_0_1
		DCD		PPU8_C0_0_1
		DCD		PPU8_C1_0_1
		DCD		PPU8_C2_0_1
		DCD		PPU8_C3_0_1
		DCD		PPU8_C4_0_1
		DCD		PPU8_C5_0_1
		DCD		PPU8_C6_0_1
		DCD		PPU8_C7_0_1
		DCD		PPU8_C8_0_1
		DCD		PPU8_C9_0_1
		DCD		PPU8_CA_0_1
		DCD		PPU8_CB_0_1
		DCD		PPU8_CC_0_1
		DCD		PPU8_CD_0_1
		DCD		PPU8_CE_0_1
		DCD		PPU8_CF_0_1
		DCD		PPU8_D0_0_1
		DCD		PPU8_D1_0_1
		DCD		PPU8_D2_0_1
		DCD		PPU8_D3_0_1
		DCD		PPU8_D4_0_1
		DCD		PPU8_D5_0_1
		DCD		PPU8_D6_0_1
		DCD		PPU8_D7_0_1
		DCD		PPU8_D8_0_1
		DCD		PPU8_D9_0_1
		DCD		PPU8_DA_0_1
		DCD		PPU8_DB_0_1
		DCD		PPU8_DC_0_1
		DCD		PPU8_DD_0_1
		DCD		PPU8_DE_0_1
		DCD		PPU8_DF_0_1
		DCD		PPU8_E0_0_1
		DCD		PPU8_E1_0_1
		DCD		PPU8_E2_0_1
		DCD		PPU8_E3_0_1
		DCD		PPU8_E4_0_1
		DCD		PPU8_E5_0_1
		DCD		PPU8_E6_0_1
		DCD		PPU8_E7_0_1
		DCD		PPU8_E8_0_1
		DCD		PPU8_E9_0_1
		DCD		PPU8_EA_0_1
		DCD		PPU8_EB_0_1
		DCD		PPU8_EC_0_1
		DCD		PPU8_ED_0_1
		DCD		PPU8_EE_0_1
		DCD		PPU8_EF_0_1
		DCD		PPU8_F0_0_1
		DCD		PPU8_F1_0_1
		DCD		PPU8_F2_0_1
		DCD		PPU8_F3_0_1
		DCD		PPU8_F4_0_1
		DCD		PPU8_F5_0_1
		DCD		PPU8_F6_0_1
		DCD		PPU8_F7_0_1
		DCD		PPU8_F8_0_1
		DCD		PPU8_F9_0_1
		DCD		PPU8_FA_0_1
		DCD		PPU8_FB_0_1
		DCD		PPU8_FC_0_1
		DCD		PPU8_FD_0_1
		DCD		PPU8_FE_0_1
		DCD		PPU8_FF_0_1


PPU8_00_1_1
;;case 00000000
;;mode : 00000000 => first pix:0
	;;Pos : 0, Pix opaque : 8, Pix transp : 0
		ldmia	R11!,{R0,R1}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		orr		R0,R0,R1,lsl #8
		mov		R1,R1,lsr #24
		str		R0,[R12],#4
		strb	R1,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_01_1_1
;;case 00000001
;;mode : 00000001 => first pix:0
	;;Pos : 0, Pix opaque : 7, Pix transp : 1
		ldmia	R11!,{R0,R1}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		orr		R0,R0,R1,lsl #8
		str		R0,[R12],#5
		NEXT_COL8
;;----------------------------------------

PPU8_02_1_1
;;case 00000010
;;mode : 00000010 => first pix:0
	;;Pos : 0, Pix opaque : 6, Pix transp : 1
		ldmia	R11,{R0,R1}
		add		R11,R11,#7
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		orr		R0,R0,R1,lsl #8
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_03_1_1
;;case 00000011
;;mode : 00000011 => first pix:0
	;;Pos : 0, Pix opaque : 6, Pix transp : 2
		ldmia	R11,{R0,R1}
		add		R11,R11,#8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		orr		R0,R0,R1,lsl #8
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_04_1_1
;;case 00000100
;;mode : 00000100 => first pix:0
	;;Pos : 0, Pix opaque : 5, Pix transp : 1
		ldmia	R11,{R0,R1}
		add		R11,R11,#6
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		orr		R0,R0,R1,lsl #8
		strh	R0,[R12],#3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_05_1_1
;;case 00000101
;;mode : 00000101 => first pix:0
	;;Pos : 0, Pix opaque : 5, Pix transp : 1
		ldmia	R11,{R0,R1}
		add		R11,R11,#6
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		orr		R0,R0,R1,lsl #8
		strh	R0,[R12],#3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_06_1_1
;;case 00000110
;;mode : 00000110 => first pix:0
	;;Pos : 0, Pix opaque : 5, Pix transp : 2
		ldmia	R11,{R0,R1}
		add		R11,R11,#7
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		orr		R0,R0,R1,lsl #8
		strh	R0,[R12],#4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_07_1_1
;;case 00000111
;;mode : 00000111 => first pix:0
	;;Pos : 0, Pix opaque : 5, Pix transp : 3
		ldmia	R11,{R0,R1}
		add		R11,R11,#8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		orr		R0,R0,R1,lsl #8
		strh	R0,[R12],#5
		NEXT_COL8
;;----------------------------------------

PPU8_08_1_1
;;case 00001000
;;mode : 00001000 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_09_1_1
;;case 00001001
;;mode : 00001001 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_0A_1_1
;;case 00001010
;;mode : 00001010 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_0B_1_1
;;case 00001011
;;mode : 00001011 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_0C_1_1
;;case 00001100
;;mode : 00001100 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#6
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_0D_1_1
;;case 00001101
;;mode : 00001101 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#6
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_0E_1_1
;;case 00001110
;;mode : 00001110 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 3
		ldmia	R11,{R0}
		add		R11,R11,#7
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_0F_1_1
;;case 00001111
;;mode : 00001111 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 4
		ldmia	R11,{R0}
		add		R11,R11,#8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#5
		NEXT_COL8
;;----------------------------------------

PPU8_10_1_1
;;case 00010000
;;mode : 00010000 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_11_1_1
;;case 00010001
;;mode : 00010001 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_12_1_1
;;case 00010010
;;mode : 00010010 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_13_1_1
;;case 00010011
;;mode : 00010011 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_14_1_1
;;case 00010100
;;mode : 00010100 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_15_1_1
;;case 00010101
;;mode : 00010101 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_16_1_1
;;case 00010110
;;mode : 00010110 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_17_1_1
;;case 00010111
;;mode : 00010111 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_18_1_1
;;case 00011000
;;mode : 00011000 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_19_1_1
;;case 00011001
;;mode : 00011001 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_1A_1_1
;;case 00011010
;;mode : 00011010 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_1B_1_1
;;case 00011011
;;mode : 00011011 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_1C_1_1
;;case 00011100
;;mode : 00011100 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 3
		ldmia	R11,{R0}
		add		R11,R11,#6
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#4
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_1D_1_1
;;case 00011101
;;mode : 00011101 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 3
		ldmia	R11,{R0}
		add		R11,R11,#6
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#4
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_1E_1_1
;;case 00011110
;;mode : 00011110 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 4
		ldmia	R11,{R0}
		add		R11,R11,#7
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#5
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_1F_1_1
;;case 00011111
;;mode : 00011111 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 5
		ldmia	R11,{R0}
		add		R11,R11,#8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#6
		NEXT_COL8
;;----------------------------------------

PPU8_20_1_1
;;case 00100000
;;mode : 00100000 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 5, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_21_1_1
;;case 00100001
;;mode : 00100001 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 4, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_22_1_1
;;case 00100010
;;mode : 00100010 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_23_1_1
;;case 00100011
;;mode : 00100011 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 3, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_24_1_1
;;case 00100100
;;mode : 00100100 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_25_1_1
;;case 00100101
;;mode : 00100101 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_26_1_1
;;case 00100110
;;mode : 00100110 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_27_1_1
;;case 00100111
;;mode : 00100111 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 2, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_28_1_1
;;case 00101000
;;mode : 00101000 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_29_1_1
;;case 00101001
;;mode : 00101001 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_2A_1_1
;;case 00101010
;;mode : 00101010 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_2B_1_1
;;case 00101011
;;mode : 00101011 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_2C_1_1
;;case 00101100
;;mode : 00101100 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_2D_1_1
;;case 00101101
;;mode : 00101101 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_2E_1_1
;;case 00101110
;;mode : 00101110 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_2F_1_1
;;case 00101111
;;mode : 00101111 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
		NEXT_COL8
;;----------------------------------------

PPU8_30_1_1
;;case 00110000
;;mode : 00110000 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_31_1_1
;;case 00110001
;;mode : 00110001 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_32_1_1
;;case 00110010
;;mode : 00110010 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_33_1_1
;;case 00110011
;;mode : 00110011 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_34_1_1
;;case 00110100
;;mode : 00110100 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_35_1_1
;;case 00110101
;;mode : 00110101 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_36_1_1
;;case 00110110
;;mode : 00110110 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_37_1_1
;;case 00110111
;;mode : 00110111 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_38_1_1
;;case 00111000
;;mode : 00111000 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 3
		ldrh	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#4
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_39_1_1
;;case 00111001
;;mode : 00111001 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 3
		ldrh	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#4
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_3A_1_1
;;case 00111010
;;mode : 00111010 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 3
		ldrh	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#4
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_3B_1_1
;;case 00111011
;;mode : 00111011 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 3
		ldrh	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#4
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_3C_1_1
;;case 00111100
;;mode : 00111100 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 4
		ldrh	R0,[R11]
		add		R11,R11,#6
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#5
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_3D_1_1
;;case 00111101
;;mode : 00111101 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 4
		ldrh	R0,[R11]
		add		R11,R11,#6
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#5
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_3E_1_1
;;case 00111110
;;mode : 00111110 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 5
		ldrh	R0,[R11]
		add		R11,R11,#7
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#6
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_3F_1_1
;;case 00111111
;;mode : 00111111 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 6
		ldrh	R0,[R11]
		add		R11,R11,#8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#7
		NEXT_COL8
;;----------------------------------------

PPU8_40_1_1
;;case 01000000
;;mode : 01000000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 6, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_41_1_1
;;case 01000001
;;mode : 01000001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 5, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_42_1_1
;;case 01000010
;;mode : 01000010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 4, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_43_1_1
;;case 01000011
;;mode : 01000011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 4, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_44_1_1
;;case 01000100
;;mode : 01000100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_45_1_1
;;case 01000101
;;mode : 01000101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_46_1_1
;;case 01000110
;;mode : 01000110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 3, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_47_1_1
;;case 01000111
;;mode : 01000111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 3, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_48_1_1
;;case 01001000
;;mode : 01001000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_49_1_1
;;case 01001001
;;mode : 01001001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_4A_1_1
;;case 01001010
;;mode : 01001010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_4B_1_1
;;case 01001011
;;mode : 01001011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_4C_1_1
;;case 01001100
;;mode : 01001100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_4D_1_1
;;case 01001101
;;mode : 01001101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_4E_1_1
;;case 01001110
;;mode : 01001110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 2, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_4F_1_1
;;case 01001111
;;mode : 01001111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 2, Pix transp : 4
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
		NEXT_COL8
;;----------------------------------------

PPU8_50_1_1
;;case 01010000
;;mode : 01010000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_51_1_1
;;case 01010001
;;mode : 01010001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_52_1_1
;;case 01010010
;;mode : 01010010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_53_1_1
;;case 01010011
;;mode : 01010011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_54_1_1
;;case 01010100
;;mode : 01010100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_55_1_1
;;case 01010101
;;mode : 01010101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_56_1_1
;;case 01010110
;;mode : 01010110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_57_1_1
;;case 01010111
;;mode : 01010111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_58_1_1
;;case 01011000
;;mode : 01011000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_59_1_1
;;case 01011001
;;mode : 01011001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_5A_1_1
;;case 01011010
;;mode : 01011010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_5B_1_1
;;case 01011011
;;mode : 01011011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_5C_1_1
;;case 01011100
;;mode : 01011100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_5D_1_1
;;case 01011101
;;mode : 01011101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_5E_1_1
;;case 01011110
;;mode : 01011110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_5F_1_1
;;case 01011111
;;mode : 01011111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 5
		ldrb	R0,[R11],#6
		strb	R0,[R12],#6
		NEXT_COL8
;;----------------------------------------

PPU8_60_1_1
;;case 01100000
;;mode : 01100000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 5, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_61_1_1
;;case 01100001
;;mode : 01100001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 4, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_62_1_1
;;case 01100010
;;mode : 01100010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_63_1_1
;;case 01100011
;;mode : 01100011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 3, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_64_1_1
;;case 01100100
;;mode : 01100100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_65_1_1
;;case 01100101
;;mode : 01100101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_66_1_1
;;case 01100110
;;mode : 01100110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_67_1_1
;;case 01100111
;;mode : 01100111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 2, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_68_1_1
;;case 01101000
;;mode : 01101000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_69_1_1
;;case 01101001
;;mode : 01101001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_6A_1_1
;;case 01101010
;;mode : 01101010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_6B_1_1
;;case 01101011
;;mode : 01101011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_6C_1_1
;;case 01101100
;;mode : 01101100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_6D_1_1
;;case 01101101
;;mode : 01101101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_6E_1_1
;;case 01101110
;;mode : 01101110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_6F_1_1
;;case 01101111
;;mode : 01101111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
		NEXT_COL8
;;----------------------------------------

PPU8_70_1_1
;;case 01110000
;;mode : 01110000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_71_1_1
;;case 01110001
;;mode : 01110001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_72_1_1
;;case 01110010
;;mode : 01110010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_73_1_1
;;case 01110011
;;mode : 01110011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_74_1_1
;;case 01110100
;;mode : 01110100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_75_1_1
;;case 01110101
;;mode : 01110101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_76_1_1
;;case 01110110
;;mode : 01110110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_77_1_1
;;case 01110111
;;mode : 01110111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_78_1_1
;;case 01111000
;;mode : 01111000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#5
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_79_1_1
;;case 01111001
;;mode : 01111001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#5
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_7A_1_1
;;case 01111010
;;mode : 01111010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#5
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_7B_1_1
;;case 01111011
;;mode : 01111011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#5
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_7C_1_1
;;case 01111100
;;mode : 01111100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 5
		ldrb	R0,[R11]
		add		R11,R11,#6
		strb	R0,[R12],#6
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_7D_1_1
;;case 01111101
;;mode : 01111101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 5
		ldrb	R0,[R11]
		add		R11,R11,#6
		strb	R0,[R12],#6
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_7E_1_1
;;case 01111110
;;mode : 01111110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 6
		ldrb	R0,[R11]
		add		R11,R11,#7
		strb	R0,[R12],#7
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_7F_1_1
;;case 01111111
;;mode : 01111111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 7
		ldrb	R0,[R11]
		add		R11,R11,#8
		strb	R0,[R12],#8
		NEXT_COL8
;;----------------------------------------


PPU8_80_1_1
;;case 10000000
;;mode : 10000000 => first pix:1
	;;Pos : 1, Pix opaque : 7, Pix transp : 0
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_81_1_1
;;case 10000001
;;mode : 10000001 => first pix:1
	;;Pos : 1, Pix opaque : 6, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_82_1_1
;;case 10000010
;;mode : 10000010 => first pix:1
	;;Pos : 1, Pix opaque : 5, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_83_1_1
;;case 10000011
;;mode : 10000011 => first pix:1
	;;Pos : 1, Pix opaque : 5, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_84_1_1
;;case 10000100
;;mode : 10000100 => first pix:1
	;;Pos : 1, Pix opaque : 4, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_85_1_1
;;case 10000101
;;mode : 10000101 => first pix:1
	;;Pos : 1, Pix opaque : 4, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_86_1_1
;;case 10000110
;;mode : 10000110 => first pix:1
	;;Pos : 1, Pix opaque : 4, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_87_1_1
;;case 10000111
;;mode : 10000111 => first pix:1
	;;Pos : 1, Pix opaque : 4, Pix transp : 3
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_88_1_1
;;case 10001000
;;mode : 10001000 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_89_1_1
;;case 10001001
;;mode : 10001001 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_8A_1_1
;;case 10001010
;;mode : 10001010 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_8B_1_1
;;case 10001011
;;mode : 10001011 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_8C_1_1
;;case 10001100
;;mode : 10001100 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_8D_1_1
;;case 10001101
;;mode : 10001101 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_8E_1_1
;;case 10001110
;;mode : 10001110 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 3
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_8F_1_1
;;case 10001111
;;mode : 10001111 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 4
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
		NEXT_COL8
;;----------------------------------------

PPU8_90_1_1
;;case 10010000
;;mode : 10010000 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_91_1_1
;;case 10010001
;;mode : 10010001 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_92_1_1
;;case 10010010
;;mode : 10010010 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_93_1_1
;;case 10010011
;;mode : 10010011 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_94_1_1
;;case 10010100
;;mode : 10010100 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_95_1_1
;;case 10010101
;;mode : 10010101 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_96_1_1
;;case 10010110
;;mode : 10010110 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_97_1_1
;;case 10010111
;;mode : 10010111 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_98_1_1
;;case 10011000
;;mode : 10011000 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_99_1_1
;;case 10011001
;;mode : 10011001 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_9A_1_1
;;case 10011010
;;mode : 10011010 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_9B_1_1
;;case 10011011
;;mode : 10011011 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_9C_1_1
;;case 10011100
;;mode : 10011100 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 3
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_9D_1_1
;;case 10011101
;;mode : 10011101 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 3
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_9E_1_1
;;case 10011110
;;mode : 10011110 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 4
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_9F_1_1
;;case 10011111
;;mode : 10011111 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 5
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#6
		strb	R0,[R12],#6
		NEXT_COL8
;;----------------------------------------

PPU8_A0_1_1
;;case 10100000
;;mode : 10100000 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 5, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_A1_1_1
;;case 10100001
;;mode : 10100001 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 4, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_A2_1_1
;;case 10100010
;;mode : 10100010 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_A3_1_1
;;case 10100011
;;mode : 10100011 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 3, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_A4_1_1
;;case 10100100
;;mode : 10100100 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_A5_1_1
;;case 10100101
;;mode : 10100101 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_A6_1_1
;;case 10100110
;;mode : 10100110 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_A7_1_1
;;case 10100111
;;mode : 10100111 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 2, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_A8_1_1
;;case 10101000
;;mode : 10101000 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_A9_1_1
;;case 10101001
;;mode : 10101001 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_AA_1_1
;;case 10101010
;;mode : 10101010 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_AB_1_1
;;case 10101011
;;mode : 10101011 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_AC_1_1
;;case 10101100
;;mode : 10101100 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_AD_1_1
;;case 10101101
;;mode : 10101101 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_AE_1_1
;;case 10101110
;;mode : 10101110 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_AF_1_1
;;case 10101111
;;mode : 10101111 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
		NEXT_COL8
;;----------------------------------------

PPU8_B0_1_1
;;case 10110000
;;mode : 10110000 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_B1_1_1
;;case 10110001
;;mode : 10110001 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_B2_1_1
;;case 10110010
;;mode : 10110010 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_B3_1_1
;;case 10110011
;;mode : 10110011 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_B4_1_1
;;case 10110100
;;mode : 10110100 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_B5_1_1
;;case 10110101
;;mode : 10110101 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_B6_1_1
;;case 10110110
;;mode : 10110110 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_B7_1_1
;;case 10110111
;;mode : 10110111 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_B8_1_1
;;case 10111000
;;mode : 10111000 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_B9_1_1
;;case 10111001
;;mode : 10111001 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_BA_1_1
;;case 10111010
;;mode : 10111010 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_BB_1_1
;;case 10111011
;;mode : 10111011 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_BC_1_1
;;case 10111100
;;mode : 10111100 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 4
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_BD_1_1
;;case 10111101
;;mode : 10111101 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 4
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_BE_1_1
;;case 10111110
;;mode : 10111110 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 5
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#6
		strb	R0,[R12],#6
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_BF_1_1
;;case 10111111
;;mode : 10111111 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 6
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#7
		strb	R0,[R12],#7
		NEXT_COL8
;;----------------------------------------

PPU8_C0_1_1
;;case 11000000
;;mode : 11000000 => first pix:2
	;;Pos : 2, Pix opaque : 6, Pix transp : 0
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_C1_1_1
;;case 11000001
;;mode : 11000001 => first pix:2
	;;Pos : 2, Pix opaque : 5, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_C2_1_1
;;case 11000010
;;mode : 11000010 => first pix:2
	;;Pos : 2, Pix opaque : 4, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_C3_1_1
;;case 11000011
;;mode : 11000011 => first pix:2
	;;Pos : 2, Pix opaque : 4, Pix transp : 2
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_C4_1_1
;;case 11000100
;;mode : 11000100 => first pix:2
	;;Pos : 2, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_C5_1_1
;;case 11000101
;;mode : 11000101 => first pix:2
	;;Pos : 2, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_C6_1_1
;;case 11000110
;;mode : 11000110 => first pix:2
	;;Pos : 2, Pix opaque : 3, Pix transp : 2
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_C7_1_1
;;case 11000111
;;mode : 11000111 => first pix:2
	;;Pos : 2, Pix opaque : 3, Pix transp : 3
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_C8_1_1
;;case 11001000
;;mode : 11001000 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_C9_1_1
;;case 11001001
;;mode : 11001001 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_CA_1_1
;;case 11001010
;;mode : 11001010 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_CB_1_1
;;case 11001011
;;mode : 11001011 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_CC_1_1
;;case 11001100
;;mode : 11001100 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_CD_1_1
;;case 11001101
;;mode : 11001101 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_CE_1_1
;;case 11001110
;;mode : 11001110 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 3
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_CF_1_1
;;case 11001111
;;mode : 11001111 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 4
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
		NEXT_COL8
;;----------------------------------------

PPU8_D0_1_1
;;case 11010000
;;mode : 11010000 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_D1_1_1
;;case 11010001
;;mode : 11010001 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_D2_1_1
;;case 11010010
;;mode : 11010010 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_D3_1_1
;;case 11010011
;;mode : 11010011 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_D4_1_1
;;case 11010100
;;mode : 11010100 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_D5_1_1
;;case 11010101
;;mode : 11010101 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_D6_1_1
;;case 11010110
;;mode : 11010110 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_D7_1_1
;;case 11010111
;;mode : 11010111 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_D8_1_1
;;case 11011000
;;mode : 11011000 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_D9_1_1
;;case 11011001
;;mode : 11011001 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_DA_1_1
;;case 11011010
;;mode : 11011010 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_DB_1_1
;;case 11011011
;;mode : 11011011 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_DC_1_1
;;case 11011100
;;mode : 11011100 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_DD_1_1
;;case 11011101
;;mode : 11011101 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_DE_1_1
;;case 11011110
;;mode : 11011110 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 4
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_DF_1_1
;;case 11011111
;;mode : 11011111 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 5
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#6
		strb	R0,[R12],#6
		NEXT_COL8
;;----------------------------------------

PPU8_E0_1_1
;;case 11100000
;;mode : 11100000 => first pix:3
	;;Pos : 3, Pix opaque : 5, Pix transp : 0
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_E1_1_1
;;case 11100001
;;mode : 11100001 => first pix:3
	;;Pos : 3, Pix opaque : 4, Pix transp : 1
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_E2_1_1
;;case 11100010
;;mode : 11100010 => first pix:3
	;;Pos : 3, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_E3_1_1
;;case 11100011
;;mode : 11100011 => first pix:3
	;;Pos : 3, Pix opaque : 3, Pix transp : 2
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_E4_1_1
;;case 11100100
;;mode : 11100100 => first pix:3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_E5_1_1
;;case 11100101
;;mode : 11100101 => first pix:3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_E6_1_1
;;case 11100110
;;mode : 11100110 => first pix:3
	;;Pos : 3, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_E7_1_1
;;case 11100111
;;mode : 11100111 => first pix:3
	;;Pos : 3, Pix opaque : 2, Pix transp : 3
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_E8_1_1
;;case 11101000
;;mode : 11101000 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_E9_1_1
;;case 11101001
;;mode : 11101001 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_EA_1_1
;;case 11101010
;;mode : 11101010 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_EB_1_1
;;case 11101011
;;mode : 11101011 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_EC_1_1
;;case 11101100
;;mode : 11101100 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_ED_1_1
;;case 11101101
;;mode : 11101101 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_EE_1_1
;;case 11101110
;;mode : 11101110 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_EF_1_1
;;case 11101111
;;mode : 11101111 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 4
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
		NEXT_COL8
;;----------------------------------------

PPU8_F0_1_1
;;case 11110000
;;mode : 11110000 => first pix:4
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
		add	R11,R11,#4
		add	R12,R12,#4
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_F1_1_1
;;case 11110001
;;mode : 11110001 => first pix:4
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#4
		add	R12,R12,#4
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_F2_1_1
;;case 11110010
;;mode : 11110010 => first pix:4
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#4
		add	R12,R12,#4
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_F3_1_1
;;case 11110011
;;mode : 11110011 => first pix:4
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#4
		add	R12,R12,#4
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_F4_1_1
;;case 11110100
;;mode : 11110100 => first pix:4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#4
		add	R12,R12,#4
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_F5_1_1
;;case 11110101
;;mode : 11110101 => first pix:4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#4
		add	R12,R12,#4
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_F6_1_1
;;case 11110110
;;mode : 11110110 => first pix:4
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#4
		add	R12,R12,#4
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_F7_1_1
;;case 11110111
;;mode : 11110111 => first pix:4
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#4
		add	R12,R12,#4
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_F8_1_1
;;case 11111000
;;mode : 11111000 => first pix:5
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		add	R11,R11,#5
		add	R12,R12,#5
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_F9_1_1
;;case 11111001
;;mode : 11111001 => first pix:5
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#5
		add	R12,R12,#5
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_FA_1_1
;;case 11111010
;;mode : 11111010 => first pix:5
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#5
		add	R12,R12,#5
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_FB_1_1
;;case 11111011
;;mode : 11111011 => first pix:5
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#5
		add	R12,R12,#5
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_FC_1_1
;;case 11111100
;;mode : 11111100 => first pix:6
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		add	R11,R11,#6
		add	R12,R12,#6
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_FD_1_1
;;case 11111101
;;mode : 11111101 => first pix:6
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#6
		add	R12,R12,#6
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_FE_1_1
;;case 11111110
;;mode : 11111110 => first pix:7
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		add	R11,R11,#7
		add	R12,R12,#7
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_FF_1_1
;;case 11111111
		add		R11,R11,#8
		add		R12,R12,#8
		NEXT_COL8
;;----------------------------------------
jumptable_ppu811
		DCD		PPU8_00_1_1
		DCD		PPU8_01_1_1
		DCD		PPU8_02_1_1
		DCD		PPU8_03_1_1
		DCD		PPU8_04_1_1
		DCD		PPU8_05_1_1
		DCD		PPU8_06_1_1
		DCD		PPU8_07_1_1
		DCD		PPU8_08_1_1
		DCD		PPU8_09_1_1
		DCD		PPU8_0A_1_1
		DCD		PPU8_0B_1_1
		DCD		PPU8_0C_1_1
		DCD		PPU8_0D_1_1
		DCD		PPU8_0E_1_1
		DCD		PPU8_0F_1_1
		DCD		PPU8_10_1_1
		DCD		PPU8_11_1_1
		DCD		PPU8_12_1_1
		DCD		PPU8_13_1_1
		DCD		PPU8_14_1_1
		DCD		PPU8_15_1_1
		DCD		PPU8_16_1_1
		DCD		PPU8_17_1_1
		DCD		PPU8_18_1_1
		DCD		PPU8_19_1_1
		DCD		PPU8_1A_1_1
		DCD		PPU8_1B_1_1
		DCD		PPU8_1C_1_1
		DCD		PPU8_1D_1_1
		DCD		PPU8_1E_1_1
		DCD		PPU8_1F_1_1
		DCD		PPU8_20_1_1
		DCD		PPU8_21_1_1
		DCD		PPU8_22_1_1
		DCD		PPU8_23_1_1
		DCD		PPU8_24_1_1
		DCD		PPU8_25_1_1
		DCD		PPU8_26_1_1
		DCD		PPU8_27_1_1
		DCD		PPU8_28_1_1
		DCD		PPU8_29_1_1
		DCD		PPU8_2A_1_1
		DCD		PPU8_2B_1_1
		DCD		PPU8_2C_1_1
		DCD		PPU8_2D_1_1
		DCD		PPU8_2E_1_1
		DCD		PPU8_2F_1_1
		DCD		PPU8_30_1_1
		DCD		PPU8_31_1_1
		DCD		PPU8_32_1_1
		DCD		PPU8_33_1_1
		DCD		PPU8_34_1_1
		DCD		PPU8_35_1_1
		DCD		PPU8_36_1_1
		DCD		PPU8_37_1_1
		DCD		PPU8_38_1_1
		DCD		PPU8_39_1_1
		DCD		PPU8_3A_1_1
		DCD		PPU8_3B_1_1
		DCD		PPU8_3C_1_1
		DCD		PPU8_3D_1_1
		DCD		PPU8_3E_1_1
		DCD		PPU8_3F_1_1
		DCD		PPU8_40_1_1
		DCD		PPU8_41_1_1
		DCD		PPU8_42_1_1
		DCD		PPU8_43_1_1
		DCD		PPU8_44_1_1
		DCD		PPU8_45_1_1
		DCD		PPU8_46_1_1
		DCD		PPU8_47_1_1
		DCD		PPU8_48_1_1
		DCD		PPU8_49_1_1
		DCD		PPU8_4A_1_1
		DCD		PPU8_4B_1_1
		DCD		PPU8_4C_1_1
		DCD		PPU8_4D_1_1
		DCD		PPU8_4E_1_1
		DCD		PPU8_4F_1_1
		DCD		PPU8_50_1_1
		DCD		PPU8_51_1_1
		DCD		PPU8_52_1_1
		DCD		PPU8_53_1_1
		DCD		PPU8_54_1_1
		DCD		PPU8_55_1_1
		DCD		PPU8_56_1_1
		DCD		PPU8_57_1_1
		DCD		PPU8_58_1_1
		DCD		PPU8_59_1_1
		DCD		PPU8_5A_1_1
		DCD		PPU8_5B_1_1
		DCD		PPU8_5C_1_1
		DCD		PPU8_5D_1_1
		DCD		PPU8_5E_1_1
		DCD		PPU8_5F_1_1
		DCD		PPU8_60_1_1
		DCD		PPU8_61_1_1
		DCD		PPU8_62_1_1
		DCD		PPU8_63_1_1
		DCD		PPU8_64_1_1
		DCD		PPU8_65_1_1
		DCD		PPU8_66_1_1
		DCD		PPU8_67_1_1
		DCD		PPU8_68_1_1
		DCD		PPU8_69_1_1
		DCD		PPU8_6A_1_1
		DCD		PPU8_6B_1_1
		DCD		PPU8_6C_1_1
		DCD		PPU8_6D_1_1
		DCD		PPU8_6E_1_1
		DCD		PPU8_6F_1_1
		DCD		PPU8_70_1_1
		DCD		PPU8_71_1_1
		DCD		PPU8_72_1_1
		DCD		PPU8_73_1_1
		DCD		PPU8_74_1_1
		DCD		PPU8_75_1_1
		DCD		PPU8_76_1_1
		DCD		PPU8_77_1_1
		DCD		PPU8_78_1_1
		DCD		PPU8_79_1_1
		DCD		PPU8_7A_1_1
		DCD		PPU8_7B_1_1
		DCD		PPU8_7C_1_1
		DCD		PPU8_7D_1_1
		DCD		PPU8_7E_1_1
		DCD		PPU8_7F_1_1
		DCD		PPU8_80_1_1
		DCD		PPU8_81_1_1
		DCD		PPU8_82_1_1
		DCD		PPU8_83_1_1
		DCD		PPU8_84_1_1
		DCD		PPU8_85_1_1
		DCD		PPU8_86_1_1
		DCD		PPU8_87_1_1
		DCD		PPU8_88_1_1
		DCD		PPU8_89_1_1
		DCD		PPU8_8A_1_1
		DCD		PPU8_8B_1_1
		DCD		PPU8_8C_1_1
		DCD		PPU8_8D_1_1
		DCD		PPU8_8E_1_1
		DCD		PPU8_8F_1_1
		DCD		PPU8_90_1_1
		DCD		PPU8_91_1_1
		DCD		PPU8_92_1_1
		DCD		PPU8_93_1_1
		DCD		PPU8_94_1_1
		DCD		PPU8_95_1_1
		DCD		PPU8_96_1_1
		DCD		PPU8_97_1_1
		DCD		PPU8_98_1_1
		DCD		PPU8_99_1_1
		DCD		PPU8_9A_1_1
		DCD		PPU8_9B_1_1
		DCD		PPU8_9C_1_1
		DCD		PPU8_9D_1_1
		DCD		PPU8_9E_1_1
		DCD		PPU8_9F_1_1
		DCD		PPU8_A0_1_1
		DCD		PPU8_A1_1_1
		DCD		PPU8_A2_1_1
		DCD		PPU8_A3_1_1
		DCD		PPU8_A4_1_1
		DCD		PPU8_A5_1_1
		DCD		PPU8_A6_1_1
		DCD		PPU8_A7_1_1
		DCD		PPU8_A8_1_1
		DCD		PPU8_A9_1_1
		DCD		PPU8_AA_1_1
		DCD		PPU8_AB_1_1
		DCD		PPU8_AC_1_1
		DCD		PPU8_AD_1_1
		DCD		PPU8_AE_1_1
		DCD		PPU8_AF_1_1
		DCD		PPU8_B0_1_1
		DCD		PPU8_B1_1_1
		DCD		PPU8_B2_1_1
		DCD		PPU8_B3_1_1
		DCD		PPU8_B4_1_1
		DCD		PPU8_B5_1_1
		DCD		PPU8_B6_1_1
		DCD		PPU8_B7_1_1
		DCD		PPU8_B8_1_1
		DCD		PPU8_B9_1_1
		DCD		PPU8_BA_1_1
		DCD		PPU8_BB_1_1
		DCD		PPU8_BC_1_1
		DCD		PPU8_BD_1_1
		DCD		PPU8_BE_1_1
		DCD		PPU8_BF_1_1
		DCD		PPU8_C0_1_1
		DCD		PPU8_C1_1_1
		DCD		PPU8_C2_1_1
		DCD		PPU8_C3_1_1
		DCD		PPU8_C4_1_1
		DCD		PPU8_C5_1_1
		DCD		PPU8_C6_1_1
		DCD		PPU8_C7_1_1
		DCD		PPU8_C8_1_1
		DCD		PPU8_C9_1_1
		DCD		PPU8_CA_1_1
		DCD		PPU8_CB_1_1
		DCD		PPU8_CC_1_1
		DCD		PPU8_CD_1_1
		DCD		PPU8_CE_1_1
		DCD		PPU8_CF_1_1
		DCD		PPU8_D0_1_1
		DCD		PPU8_D1_1_1
		DCD		PPU8_D2_1_1
		DCD		PPU8_D3_1_1
		DCD		PPU8_D4_1_1
		DCD		PPU8_D5_1_1
		DCD		PPU8_D6_1_1
		DCD		PPU8_D7_1_1
		DCD		PPU8_D8_1_1
		DCD		PPU8_D9_1_1
		DCD		PPU8_DA_1_1
		DCD		PPU8_DB_1_1
		DCD		PPU8_DC_1_1
		DCD		PPU8_DD_1_1
		DCD		PPU8_DE_1_1
		DCD		PPU8_DF_1_1
		DCD		PPU8_E0_1_1
		DCD		PPU8_E1_1_1
		DCD		PPU8_E2_1_1
		DCD		PPU8_E3_1_1
		DCD		PPU8_E4_1_1
		DCD		PPU8_E5_1_1
		DCD		PPU8_E6_1_1
		DCD		PPU8_E7_1_1
		DCD		PPU8_E8_1_1
		DCD		PPU8_E9_1_1
		DCD		PPU8_EA_1_1
		DCD		PPU8_EB_1_1
		DCD		PPU8_EC_1_1
		DCD		PPU8_ED_1_1
		DCD		PPU8_EE_1_1
		DCD		PPU8_EF_1_1
		DCD		PPU8_F0_1_1
		DCD		PPU8_F1_1_1
		DCD		PPU8_F2_1_1
		DCD		PPU8_F3_1_1
		DCD		PPU8_F4_1_1
		DCD		PPU8_F5_1_1
		DCD		PPU8_F6_1_1
		DCD		PPU8_F7_1_1
		DCD		PPU8_F8_1_1
		DCD		PPU8_F9_1_1
		DCD		PPU8_FA_1_1
		DCD		PPU8_FB_1_1
		DCD		PPU8_FC_1_1
		DCD		PPU8_FD_1_1
		DCD		PPU8_FE_1_1
		DCD		PPU8_FF_1_1


PPU8_00_0_2
;;case 00000000
;;mode : 00000000 => first pix:0
	;;Pos : 0, Pix opaque : 8, Pix transp : 0
		ldmia	R11!,{R0,R1}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		strb	R1,[R12],#-1
		mov		R1,R1,lsr #8
		strb	R1,[R12],#-1
		mov		R1,R1,lsr #8
		strb	R1,[R12],#-1
		mov		R1,R1,lsr #8
		strb	R1,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_01_0_2
;;case 00000001
;;mode : 00000001 => first pix:0
	;;Pos : 0, Pix opaque : 7, Pix transp : 1
		ldmia	R11!,{R0,R1}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		strb	R1,[R12],#-1
		mov		R1,R1,lsr #8
		strb	R1,[R12],#-1
		mov		R1,R1,lsr #8
		strb	R1,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_02_0_2
;;case 00000010
;;mode : 00000010 => first pix:0
	;;Pos : 0, Pix opaque : 6, Pix transp : 1
		ldmia	R11,{R0,R1}
		add		R11,R11,#7
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		strb	R1,[R12],#-1
		mov		R1,R1,lsr #8
		strb	R1,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_03_0_2
;;case 00000011
;;mode : 00000011 => first pix:0
	;;Pos : 0, Pix opaque : 6, Pix transp : 2
		ldmia	R11,{R0,R1}
		add		R11,R11,#8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		strb	R1,[R12],#-1
		mov		R1,R1,lsr #8
		strb	R1,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_04_0_2
;;case 00000100
;;mode : 00000100 => first pix:0
	;;Pos : 0, Pix opaque : 5, Pix transp : 1
		ldmia	R11,{R0,R1}
		add		R11,R11,#6
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		strb	R1,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_05_0_2
;;case 00000101
;;mode : 00000101 => first pix:0
	;;Pos : 0, Pix opaque : 5, Pix transp : 1
		ldmia	R11,{R0,R1}
		add		R11,R11,#6
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		strb	R1,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_06_0_2
;;case 00000110
;;mode : 00000110 => first pix:0
	;;Pos : 0, Pix opaque : 5, Pix transp : 2
		ldmia	R11,{R0,R1}
		add		R11,R11,#7
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		strb	R1,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_07_0_2
;;case 00000111
;;mode : 00000111 => first pix:0
	;;Pos : 0, Pix opaque : 5, Pix transp : 3
		ldmia	R11,{R0,R1}
		add		R11,R11,#8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		strb	R1,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_08_0_2
;;case 00001000
;;mode : 00001000 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_09_0_2
;;case 00001001
;;mode : 00001001 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_0A_0_2
;;case 00001010
;;mode : 00001010 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_0B_0_2
;;case 00001011
;;mode : 00001011 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_0C_0_2
;;case 00001100
;;mode : 00001100 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#6
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_0D_0_2
;;case 00001101
;;mode : 00001101 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#6
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_0E_0_2
;;case 00001110
;;mode : 00001110 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 3
		ldmia	R11,{R0}
		add		R11,R11,#7
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_0F_0_2
;;case 00001111
;;mode : 00001111 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 4
		ldmia	R11,{R0}
		add		R11,R11,#8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-5
		NEXT_COL8
;;----------------------------------------

PPU8_10_0_2
;;case 00010000
;;mode : 00010000 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_11_0_2
;;case 00010001
;;mode : 00010001 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_12_0_2
;;case 00010010
;;mode : 00010010 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_13_0_2
;;case 00010011
;;mode : 00010011 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_14_0_2
;;case 00010100
;;mode : 00010100 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_15_0_2
;;case 00010101
;;mode : 00010101 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_16_0_2
;;case 00010110
;;mode : 00010110 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_17_0_2
;;case 00010111
;;mode : 00010111 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_18_0_2
;;case 00011000
;;mode : 00011000 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_19_0_2
;;case 00011001
;;mode : 00011001 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_1A_0_2
;;case 00011010
;;mode : 00011010 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_1B_0_2
;;case 00011011
;;mode : 00011011 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_1C_0_2
;;case 00011100
;;mode : 00011100 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 3
		ldmia	R11,{R0}
		add		R11,R11,#6
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-4
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_1D_0_2
;;case 00011101
;;mode : 00011101 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 3
		ldmia	R11,{R0}
		add		R11,R11,#6
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-4
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_1E_0_2
;;case 00011110
;;mode : 00011110 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 4
		ldmia	R11,{R0}
		add		R11,R11,#7
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-5
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_1F_0_2
;;case 00011111
;;mode : 00011111 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 5
		ldmia	R11,{R0}
		add		R11,R11,#8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-6
		NEXT_COL8
;;----------------------------------------

PPU8_20_0_2
;;case 00100000
;;mode : 00100000 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 5, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_21_0_2
;;case 00100001
;;mode : 00100001 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 4, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_22_0_2
;;case 00100010
;;mode : 00100010 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_23_0_2
;;case 00100011
;;mode : 00100011 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 3, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_24_0_2
;;case 00100100
;;mode : 00100100 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_25_0_2
;;case 00100101
;;mode : 00100101 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_26_0_2
;;case 00100110
;;mode : 00100110 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_27_0_2
;;case 00100111
;;mode : 00100111 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 2, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_28_0_2
;;case 00101000
;;mode : 00101000 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_29_0_2
;;case 00101001
;;mode : 00101001 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_2A_0_2
;;case 00101010
;;mode : 00101010 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_2B_0_2
;;case 00101011
;;mode : 00101011 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_2C_0_2
;;case 00101100
;;mode : 00101100 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_2D_0_2
;;case 00101101
;;mode : 00101101 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_2E_0_2
;;case 00101110
;;mode : 00101110 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_2F_0_2
;;case 00101111
;;mode : 00101111 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
		NEXT_COL8
;;----------------------------------------

PPU8_30_0_2
;;case 00110000
;;mode : 00110000 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_31_0_2
;;case 00110001
;;mode : 00110001 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_32_0_2
;;case 00110010
;;mode : 00110010 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_33_0_2
;;case 00110011
;;mode : 00110011 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_34_0_2
;;case 00110100
;;mode : 00110100 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_35_0_2
;;case 00110101
;;mode : 00110101 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_36_0_2
;;case 00110110
;;mode : 00110110 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_37_0_2
;;case 00110111
;;mode : 00110111 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_38_0_2
;;case 00111000
;;mode : 00111000 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 3
		ldrh	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-4
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_39_0_2
;;case 00111001
;;mode : 00111001 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 3
		ldrh	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-4
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_3A_0_2
;;case 00111010
;;mode : 00111010 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 3
		ldrh	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-4
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_3B_0_2
;;case 00111011
;;mode : 00111011 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 3
		ldrh	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-4
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_3C_0_2
;;case 00111100
;;mode : 00111100 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 4
		ldrh	R0,[R11]
		add		R11,R11,#6
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-5
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_3D_0_2
;;case 00111101
;;mode : 00111101 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 4
		ldrh	R0,[R11]
		add		R11,R11,#6
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-5
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_3E_0_2
;;case 00111110
;;mode : 00111110 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 5
		ldrh	R0,[R11]
		add		R11,R11,#7
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-6
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_3F_0_2
;;case 00111111
;;mode : 00111111 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 6
		ldrh	R0,[R11]
		add		R11,R11,#8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-7
		NEXT_COL8
;;----------------------------------------

PPU8_40_0_2
;;case 01000000
;;mode : 01000000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 6, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_41_0_2
;;case 01000001
;;mode : 01000001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 5, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_42_0_2
;;case 01000010
;;mode : 01000010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 4, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_43_0_2
;;case 01000011
;;mode : 01000011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 4, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_44_0_2
;;case 01000100
;;mode : 01000100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_45_0_2
;;case 01000101
;;mode : 01000101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_46_0_2
;;case 01000110
;;mode : 01000110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 3, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_47_0_2
;;case 01000111
;;mode : 01000111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 3, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_48_0_2
;;case 01001000
;;mode : 01001000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_49_0_2
;;case 01001001
;;mode : 01001001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_4A_0_2
;;case 01001010
;;mode : 01001010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_4B_0_2
;;case 01001011
;;mode : 01001011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_4C_0_2
;;case 01001100
;;mode : 01001100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_4D_0_2
;;case 01001101
;;mode : 01001101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_4E_0_2
;;case 01001110
;;mode : 01001110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 2, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_4F_0_2
;;case 01001111
;;mode : 01001111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 2, Pix transp : 4
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
		NEXT_COL8
;;----------------------------------------

PPU8_50_0_2
;;case 01010000
;;mode : 01010000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_51_0_2
;;case 01010001
;;mode : 01010001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_52_0_2
;;case 01010010
;;mode : 01010010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_53_0_2
;;case 01010011
;;mode : 01010011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_54_0_2
;;case 01010100
;;mode : 01010100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_55_0_2
;;case 01010101
;;mode : 01010101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_56_0_2
;;case 01010110
;;mode : 01010110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_57_0_2
;;case 01010111
;;mode : 01010111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_58_0_2
;;case 01011000
;;mode : 01011000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_59_0_2
;;case 01011001
;;mode : 01011001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_5A_0_2
;;case 01011010
;;mode : 01011010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_5B_0_2
;;case 01011011
;;mode : 01011011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_5C_0_2
;;case 01011100
;;mode : 01011100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_5D_0_2
;;case 01011101
;;mode : 01011101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_5E_0_2
;;case 01011110
;;mode : 01011110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_5F_0_2
;;case 01011111
;;mode : 01011111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 5
		ldrb	R0,[R11],#6
		strb	R0,[R12],#-6
		NEXT_COL8
;;----------------------------------------

PPU8_60_0_2
;;case 01100000
;;mode : 01100000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 5, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_61_0_2
;;case 01100001
;;mode : 01100001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 4, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_62_0_2
;;case 01100010
;;mode : 01100010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_63_0_2
;;case 01100011
;;mode : 01100011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 3, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_64_0_2
;;case 01100100
;;mode : 01100100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_65_0_2
;;case 01100101
;;mode : 01100101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_66_0_2
;;case 01100110
;;mode : 01100110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_67_0_2
;;case 01100111
;;mode : 01100111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 2, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_68_0_2
;;case 01101000
;;mode : 01101000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_69_0_2
;;case 01101001
;;mode : 01101001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_6A_0_2
;;case 01101010
;;mode : 01101010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_6B_0_2
;;case 01101011
;;mode : 01101011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_6C_0_2
;;case 01101100
;;mode : 01101100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_6D_0_2
;;case 01101101
;;mode : 01101101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_6E_0_2
;;case 01101110
;;mode : 01101110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_6F_0_2
;;case 01101111
;;mode : 01101111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
		NEXT_COL8
;;----------------------------------------

PPU8_70_0_2
;;case 01110000
;;mode : 01110000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_71_0_2
;;case 01110001
;;mode : 01110001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_72_0_2
;;case 01110010
;;mode : 01110010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_73_0_2
;;case 01110011
;;mode : 01110011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_74_0_2
;;case 01110100
;;mode : 01110100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_75_0_2
;;case 01110101
;;mode : 01110101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_76_0_2
;;case 01110110
;;mode : 01110110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_77_0_2
;;case 01110111
;;mode : 01110111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_78_0_2
;;case 01111000
;;mode : 01111000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#-5
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_79_0_2
;;case 01111001
;;mode : 01111001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#-5
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_7A_0_2
;;case 01111010
;;mode : 01111010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#-5
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_7B_0_2
;;case 01111011
;;mode : 01111011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#-5
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_7C_0_2
;;case 01111100
;;mode : 01111100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 5
		ldrb	R0,[R11]
		add		R11,R11,#6
		strb	R0,[R12],#-6
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_7D_0_2
;;case 01111101
;;mode : 01111101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 5
		ldrb	R0,[R11]
		add		R11,R11,#6
		strb	R0,[R12],#-6
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_7E_0_2
;;case 01111110
;;mode : 01111110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 6
		ldrb	R0,[R11]
		add		R11,R11,#7
		strb	R0,[R12],#-7
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_7F_0_2
;;case 01111111
;;mode : 01111111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 7
		ldrb	R0,[R11]
		add		R11,R11,#8
		strb	R0,[R12],#-8
		NEXT_COL8
;;----------------------------------------


PPU8_80_0_2
;;case 10000000
;;mode : 10000000 => first pix:1
	;;Pos : 1, Pix opaque : 7, Pix transp : 0
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_81_0_2
;;case 10000001
;;mode : 10000001 => first pix:1
	;;Pos : 1, Pix opaque : 6, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_82_0_2
;;case 10000010
;;mode : 10000010 => first pix:1
	;;Pos : 1, Pix opaque : 5, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_83_0_2
;;case 10000011
;;mode : 10000011 => first pix:1
	;;Pos : 1, Pix opaque : 5, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_84_0_2
;;case 10000100
;;mode : 10000100 => first pix:1
	;;Pos : 1, Pix opaque : 4, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_85_0_2
;;case 10000101
;;mode : 10000101 => first pix:1
	;;Pos : 1, Pix opaque : 4, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_86_0_2
;;case 10000110
;;mode : 10000110 => first pix:1
	;;Pos : 1, Pix opaque : 4, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_87_0_2
;;case 10000111
;;mode : 10000111 => first pix:1
	;;Pos : 1, Pix opaque : 4, Pix transp : 3
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_88_0_2
;;case 10001000
;;mode : 10001000 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_89_0_2
;;case 10001001
;;mode : 10001001 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_8A_0_2
;;case 10001010
;;mode : 10001010 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_8B_0_2
;;case 10001011
;;mode : 10001011 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_8C_0_2
;;case 10001100
;;mode : 10001100 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_8D_0_2
;;case 10001101
;;mode : 10001101 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_8E_0_2
;;case 10001110
;;mode : 10001110 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 3
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_8F_0_2
;;case 10001111
;;mode : 10001111 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 4
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
		NEXT_COL8
;;----------------------------------------

PPU8_90_0_2
;;case 10010000
;;mode : 10010000 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_91_0_2
;;case 10010001
;;mode : 10010001 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_92_0_2
;;case 10010010
;;mode : 10010010 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_93_0_2
;;case 10010011
;;mode : 10010011 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_94_0_2
;;case 10010100
;;mode : 10010100 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_95_0_2
;;case 10010101
;;mode : 10010101 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_96_0_2
;;case 10010110
;;mode : 10010110 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_97_0_2
;;case 10010111
;;mode : 10010111 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_98_0_2
;;case 10011000
;;mode : 10011000 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_99_0_2
;;case 10011001
;;mode : 10011001 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_9A_0_2
;;case 10011010
;;mode : 10011010 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_9B_0_2
;;case 10011011
;;mode : 10011011 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_9C_0_2
;;case 10011100
;;mode : 10011100 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 3
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_9D_0_2
;;case 10011101
;;mode : 10011101 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 3
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_9E_0_2
;;case 10011110
;;mode : 10011110 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 4
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_9F_0_2
;;case 10011111
;;mode : 10011111 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 5
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#6
		strb	R0,[R12],#-6
		NEXT_COL8
;;----------------------------------------

PPU8_A0_0_2
;;case 10100000
;;mode : 10100000 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 5, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_A1_0_2
;;case 10100001
;;mode : 10100001 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 4, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_A2_0_2
;;case 10100010
;;mode : 10100010 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_A3_0_2
;;case 10100011
;;mode : 10100011 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 3, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_A4_0_2
;;case 10100100
;;mode : 10100100 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_A5_0_2
;;case 10100101
;;mode : 10100101 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_A6_0_2
;;case 10100110
;;mode : 10100110 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_A7_0_2
;;case 10100111
;;mode : 10100111 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 2, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_A8_0_2
;;case 10101000
;;mode : 10101000 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_A9_0_2
;;case 10101001
;;mode : 10101001 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_AA_0_2
;;case 10101010
;;mode : 10101010 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_AB_0_2
;;case 10101011
;;mode : 10101011 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_AC_0_2
;;case 10101100
;;mode : 10101100 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_AD_0_2
;;case 10101101
;;mode : 10101101 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_AE_0_2
;;case 10101110
;;mode : 10101110 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_AF_0_2
;;case 10101111
;;mode : 10101111 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
		NEXT_COL8
;;----------------------------------------

PPU8_B0_0_2
;;case 10110000
;;mode : 10110000 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_B1_0_2
;;case 10110001
;;mode : 10110001 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_B2_0_2
;;case 10110010
;;mode : 10110010 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_B3_0_2
;;case 10110011
;;mode : 10110011 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_B4_0_2
;;case 10110100
;;mode : 10110100 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_B5_0_2
;;case 10110101
;;mode : 10110101 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_B6_0_2
;;case 10110110
;;mode : 10110110 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_B7_0_2
;;case 10110111
;;mode : 10110111 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_B8_0_2
;;case 10111000
;;mode : 10111000 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_B9_0_2
;;case 10111001
;;mode : 10111001 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_BA_0_2
;;case 10111010
;;mode : 10111010 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_BB_0_2
;;case 10111011
;;mode : 10111011 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_BC_0_2
;;case 10111100
;;mode : 10111100 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 4
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_BD_0_2
;;case 10111101
;;mode : 10111101 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 4
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_BE_0_2
;;case 10111110
;;mode : 10111110 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 5
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#6
		strb	R0,[R12],#-6
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_BF_0_2
;;case 10111111
;;mode : 10111111 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 6
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#7
		strb	R0,[R12],#-7
		NEXT_COL8
;;----------------------------------------

PPU8_C0_0_2
;;case 11000000
;;mode : 11000000 => first pix:2
	;;Pos : 2, Pix opaque : 6, Pix transp : 0
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_C1_0_2
;;case 11000001
;;mode : 11000001 => first pix:2
	;;Pos : 2, Pix opaque : 5, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_C2_0_2
;;case 11000010
;;mode : 11000010 => first pix:2
	;;Pos : 2, Pix opaque : 4, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_C3_0_2
;;case 11000011
;;mode : 11000011 => first pix:2
	;;Pos : 2, Pix opaque : 4, Pix transp : 2
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_C4_0_2
;;case 11000100
;;mode : 11000100 => first pix:2
	;;Pos : 2, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_C5_0_2
;;case 11000101
;;mode : 11000101 => first pix:2
	;;Pos : 2, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_C6_0_2
;;case 11000110
;;mode : 11000110 => first pix:2
	;;Pos : 2, Pix opaque : 3, Pix transp : 2
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_C7_0_2
;;case 11000111
;;mode : 11000111 => first pix:2
	;;Pos : 2, Pix opaque : 3, Pix transp : 3
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_C8_0_2
;;case 11001000
;;mode : 11001000 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_C9_0_2
;;case 11001001
;;mode : 11001001 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_CA_0_2
;;case 11001010
;;mode : 11001010 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_CB_0_2
;;case 11001011
;;mode : 11001011 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_CC_0_2
;;case 11001100
;;mode : 11001100 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_CD_0_2
;;case 11001101
;;mode : 11001101 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_CE_0_2
;;case 11001110
;;mode : 11001110 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 3
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_CF_0_2
;;case 11001111
;;mode : 11001111 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 4
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
		NEXT_COL8
;;----------------------------------------

PPU8_D0_0_2
;;case 11010000
;;mode : 11010000 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_D1_0_2
;;case 11010001
;;mode : 11010001 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_D2_0_2
;;case 11010010
;;mode : 11010010 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_D3_0_2
;;case 11010011
;;mode : 11010011 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_D4_0_2
;;case 11010100
;;mode : 11010100 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_D5_0_2
;;case 11010101
;;mode : 11010101 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_D6_0_2
;;case 11010110
;;mode : 11010110 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_D7_0_2
;;case 11010111
;;mode : 11010111 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_D8_0_2
;;case 11011000
;;mode : 11011000 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_D9_0_2
;;case 11011001
;;mode : 11011001 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_DA_0_2
;;case 11011010
;;mode : 11011010 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_DB_0_2
;;case 11011011
;;mode : 11011011 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_DC_0_2
;;case 11011100
;;mode : 11011100 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_DD_0_2
;;case 11011101
;;mode : 11011101 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_DE_0_2
;;case 11011110
;;mode : 11011110 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 4
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_DF_0_2
;;case 11011111
;;mode : 11011111 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 5
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#6
		strb	R0,[R12],#-6
		NEXT_COL8
;;----------------------------------------

PPU8_E0_0_2
;;case 11100000
;;mode : 11100000 => first pix:3
	;;Pos : 3, Pix opaque : 5, Pix transp : 0
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_E1_0_2
;;case 11100001
;;mode : 11100001 => first pix:3
	;;Pos : 3, Pix opaque : 4, Pix transp : 1
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_E2_0_2
;;case 11100010
;;mode : 11100010 => first pix:3
	;;Pos : 3, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_E3_0_2
;;case 11100011
;;mode : 11100011 => first pix:3
	;;Pos : 3, Pix opaque : 3, Pix transp : 2
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_E4_0_2
;;case 11100100
;;mode : 11100100 => first pix:3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_E5_0_2
;;case 11100101
;;mode : 11100101 => first pix:3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_E6_0_2
;;case 11100110
;;mode : 11100110 => first pix:3
	;;Pos : 3, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_E7_0_2
;;case 11100111
;;mode : 11100111 => first pix:3
	;;Pos : 3, Pix opaque : 2, Pix transp : 3
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_E8_0_2
;;case 11101000
;;mode : 11101000 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_E9_0_2
;;case 11101001
;;mode : 11101001 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_EA_0_2
;;case 11101010
;;mode : 11101010 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_EB_0_2
;;case 11101011
;;mode : 11101011 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_EC_0_2
;;case 11101100
;;mode : 11101100 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_ED_0_2
;;case 11101101
;;mode : 11101101 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_EE_0_2
;;case 11101110
;;mode : 11101110 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_EF_0_2
;;case 11101111
;;mode : 11101111 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 4
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
		NEXT_COL8
;;----------------------------------------

PPU8_F0_0_2
;;case 11110000
;;mode : 11110000 => first pix:4
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
		add	R11,R11,#4
		sub	R12,R12,#4
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_F1_0_2
;;case 11110001
;;mode : 11110001 => first pix:4
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#4
		sub	R12,R12,#4
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_F2_0_2
;;case 11110010
;;mode : 11110010 => first pix:4
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#4
		sub	R12,R12,#4
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_F3_0_2
;;case 11110011
;;mode : 11110011 => first pix:4
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#4
		sub	R12,R12,#4
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_F4_0_2
;;case 11110100
;;mode : 11110100 => first pix:4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#4
		sub	R12,R12,#4
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_F5_0_2
;;case 11110101
;;mode : 11110101 => first pix:4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#4
		sub	R12,R12,#4
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_F6_0_2
;;case 11110110
;;mode : 11110110 => first pix:4
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#4
		sub	R12,R12,#4
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_F7_0_2
;;case 11110111
;;mode : 11110111 => first pix:4
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#4
		sub	R12,R12,#4
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_F8_0_2
;;case 11111000
;;mode : 11111000 => first pix:5
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		add	R11,R11,#5
		sub	R12,R12,#5
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_F9_0_2
;;case 11111001
;;mode : 11111001 => first pix:5
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#5
		sub	R12,R12,#5
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_FA_0_2
;;case 11111010
;;mode : 11111010 => first pix:5
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#5
		sub	R12,R12,#5
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_FB_0_2
;;case 11111011
;;mode : 11111011 => first pix:5
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#5
		sub	R12,R12,#5
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_FC_0_2
;;case 11111100
;;mode : 11111100 => first pix:6
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		add	R11,R11,#6
		sub	R12,R12,#6
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_FD_0_2
;;case 11111101
;;mode : 11111101 => first pix:6
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#6
		sub	R12,R12,#6
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_FE_0_2
;;case 11111110
;;mode : 11111110 => first pix:7
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		add	R11,R11,#7
		sub	R12,R12,#7
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_FF_0_2
;;case 11111111
		add		R11,R11,#8
		sub		R12,R12,#8
		NEXT_COL8
;;----------------------------------------
jumptable_ppu802
		DCD		PPU8_00_0_2
		DCD		PPU8_01_0_2
		DCD		PPU8_02_0_2
		DCD		PPU8_03_0_2
		DCD		PPU8_04_0_2
		DCD		PPU8_05_0_2
		DCD		PPU8_06_0_2
		DCD		PPU8_07_0_2
		DCD		PPU8_08_0_2
		DCD		PPU8_09_0_2
		DCD		PPU8_0A_0_2
		DCD		PPU8_0B_0_2
		DCD		PPU8_0C_0_2
		DCD		PPU8_0D_0_2
		DCD		PPU8_0E_0_2
		DCD		PPU8_0F_0_2
		DCD		PPU8_10_0_2
		DCD		PPU8_11_0_2
		DCD		PPU8_12_0_2
		DCD		PPU8_13_0_2
		DCD		PPU8_14_0_2
		DCD		PPU8_15_0_2
		DCD		PPU8_16_0_2
		DCD		PPU8_17_0_2
		DCD		PPU8_18_0_2
		DCD		PPU8_19_0_2
		DCD		PPU8_1A_0_2
		DCD		PPU8_1B_0_2
		DCD		PPU8_1C_0_2
		DCD		PPU8_1D_0_2
		DCD		PPU8_1E_0_2
		DCD		PPU8_1F_0_2
		DCD		PPU8_20_0_2
		DCD		PPU8_21_0_2
		DCD		PPU8_22_0_2
		DCD		PPU8_23_0_2
		DCD		PPU8_24_0_2
		DCD		PPU8_25_0_2
		DCD		PPU8_26_0_2
		DCD		PPU8_27_0_2
		DCD		PPU8_28_0_2
		DCD		PPU8_29_0_2
		DCD		PPU8_2A_0_2
		DCD		PPU8_2B_0_2
		DCD		PPU8_2C_0_2
		DCD		PPU8_2D_0_2
		DCD		PPU8_2E_0_2
		DCD		PPU8_2F_0_2
		DCD		PPU8_30_0_2
		DCD		PPU8_31_0_2
		DCD		PPU8_32_0_2
		DCD		PPU8_33_0_2
		DCD		PPU8_34_0_2
		DCD		PPU8_35_0_2
		DCD		PPU8_36_0_2
		DCD		PPU8_37_0_2
		DCD		PPU8_38_0_2
		DCD		PPU8_39_0_2
		DCD		PPU8_3A_0_2
		DCD		PPU8_3B_0_2
		DCD		PPU8_3C_0_2
		DCD		PPU8_3D_0_2
		DCD		PPU8_3E_0_2
		DCD		PPU8_3F_0_2
		DCD		PPU8_40_0_2
		DCD		PPU8_41_0_2
		DCD		PPU8_42_0_2
		DCD		PPU8_43_0_2
		DCD		PPU8_44_0_2
		DCD		PPU8_45_0_2
		DCD		PPU8_46_0_2
		DCD		PPU8_47_0_2
		DCD		PPU8_48_0_2
		DCD		PPU8_49_0_2
		DCD		PPU8_4A_0_2
		DCD		PPU8_4B_0_2
		DCD		PPU8_4C_0_2
		DCD		PPU8_4D_0_2
		DCD		PPU8_4E_0_2
		DCD		PPU8_4F_0_2
		DCD		PPU8_50_0_2
		DCD		PPU8_51_0_2
		DCD		PPU8_52_0_2
		DCD		PPU8_53_0_2
		DCD		PPU8_54_0_2
		DCD		PPU8_55_0_2
		DCD		PPU8_56_0_2
		DCD		PPU8_57_0_2
		DCD		PPU8_58_0_2
		DCD		PPU8_59_0_2
		DCD		PPU8_5A_0_2
		DCD		PPU8_5B_0_2
		DCD		PPU8_5C_0_2
		DCD		PPU8_5D_0_2
		DCD		PPU8_5E_0_2
		DCD		PPU8_5F_0_2
		DCD		PPU8_60_0_2
		DCD		PPU8_61_0_2
		DCD		PPU8_62_0_2
		DCD		PPU8_63_0_2
		DCD		PPU8_64_0_2
		DCD		PPU8_65_0_2
		DCD		PPU8_66_0_2
		DCD		PPU8_67_0_2
		DCD		PPU8_68_0_2
		DCD		PPU8_69_0_2
		DCD		PPU8_6A_0_2
		DCD		PPU8_6B_0_2
		DCD		PPU8_6C_0_2
		DCD		PPU8_6D_0_2
		DCD		PPU8_6E_0_2
		DCD		PPU8_6F_0_2
		DCD		PPU8_70_0_2
		DCD		PPU8_71_0_2
		DCD		PPU8_72_0_2
		DCD		PPU8_73_0_2
		DCD		PPU8_74_0_2
		DCD		PPU8_75_0_2
		DCD		PPU8_76_0_2
		DCD		PPU8_77_0_2
		DCD		PPU8_78_0_2
		DCD		PPU8_79_0_2
		DCD		PPU8_7A_0_2
		DCD		PPU8_7B_0_2
		DCD		PPU8_7C_0_2
		DCD		PPU8_7D_0_2
		DCD		PPU8_7E_0_2
		DCD		PPU8_7F_0_2
		DCD		PPU8_80_0_2
		DCD		PPU8_81_0_2
		DCD		PPU8_82_0_2
		DCD		PPU8_83_0_2
		DCD		PPU8_84_0_2
		DCD		PPU8_85_0_2
		DCD		PPU8_86_0_2
		DCD		PPU8_87_0_2
		DCD		PPU8_88_0_2
		DCD		PPU8_89_0_2
		DCD		PPU8_8A_0_2
		DCD		PPU8_8B_0_2
		DCD		PPU8_8C_0_2
		DCD		PPU8_8D_0_2
		DCD		PPU8_8E_0_2
		DCD		PPU8_8F_0_2
		DCD		PPU8_90_0_2
		DCD		PPU8_91_0_2
		DCD		PPU8_92_0_2
		DCD		PPU8_93_0_2
		DCD		PPU8_94_0_2
		DCD		PPU8_95_0_2
		DCD		PPU8_96_0_2
		DCD		PPU8_97_0_2
		DCD		PPU8_98_0_2
		DCD		PPU8_99_0_2
		DCD		PPU8_9A_0_2
		DCD		PPU8_9B_0_2
		DCD		PPU8_9C_0_2
		DCD		PPU8_9D_0_2
		DCD		PPU8_9E_0_2
		DCD		PPU8_9F_0_2
		DCD		PPU8_A0_0_2
		DCD		PPU8_A1_0_2
		DCD		PPU8_A2_0_2
		DCD		PPU8_A3_0_2
		DCD		PPU8_A4_0_2
		DCD		PPU8_A5_0_2
		DCD		PPU8_A6_0_2
		DCD		PPU8_A7_0_2
		DCD		PPU8_A8_0_2
		DCD		PPU8_A9_0_2
		DCD		PPU8_AA_0_2
		DCD		PPU8_AB_0_2
		DCD		PPU8_AC_0_2
		DCD		PPU8_AD_0_2
		DCD		PPU8_AE_0_2
		DCD		PPU8_AF_0_2
		DCD		PPU8_B0_0_2
		DCD		PPU8_B1_0_2
		DCD		PPU8_B2_0_2
		DCD		PPU8_B3_0_2
		DCD		PPU8_B4_0_2
		DCD		PPU8_B5_0_2
		DCD		PPU8_B6_0_2
		DCD		PPU8_B7_0_2
		DCD		PPU8_B8_0_2
		DCD		PPU8_B9_0_2
		DCD		PPU8_BA_0_2
		DCD		PPU8_BB_0_2
		DCD		PPU8_BC_0_2
		DCD		PPU8_BD_0_2
		DCD		PPU8_BE_0_2
		DCD		PPU8_BF_0_2
		DCD		PPU8_C0_0_2
		DCD		PPU8_C1_0_2
		DCD		PPU8_C2_0_2
		DCD		PPU8_C3_0_2
		DCD		PPU8_C4_0_2
		DCD		PPU8_C5_0_2
		DCD		PPU8_C6_0_2
		DCD		PPU8_C7_0_2
		DCD		PPU8_C8_0_2
		DCD		PPU8_C9_0_2
		DCD		PPU8_CA_0_2
		DCD		PPU8_CB_0_2
		DCD		PPU8_CC_0_2
		DCD		PPU8_CD_0_2
		DCD		PPU8_CE_0_2
		DCD		PPU8_CF_0_2
		DCD		PPU8_D0_0_2
		DCD		PPU8_D1_0_2
		DCD		PPU8_D2_0_2
		DCD		PPU8_D3_0_2
		DCD		PPU8_D4_0_2
		DCD		PPU8_D5_0_2
		DCD		PPU8_D6_0_2
		DCD		PPU8_D7_0_2
		DCD		PPU8_D8_0_2
		DCD		PPU8_D9_0_2
		DCD		PPU8_DA_0_2
		DCD		PPU8_DB_0_2
		DCD		PPU8_DC_0_2
		DCD		PPU8_DD_0_2
		DCD		PPU8_DE_0_2
		DCD		PPU8_DF_0_2
		DCD		PPU8_E0_0_2
		DCD		PPU8_E1_0_2
		DCD		PPU8_E2_0_2
		DCD		PPU8_E3_0_2
		DCD		PPU8_E4_0_2
		DCD		PPU8_E5_0_2
		DCD		PPU8_E6_0_2
		DCD		PPU8_E7_0_2
		DCD		PPU8_E8_0_2
		DCD		PPU8_E9_0_2
		DCD		PPU8_EA_0_2
		DCD		PPU8_EB_0_2
		DCD		PPU8_EC_0_2
		DCD		PPU8_ED_0_2
		DCD		PPU8_EE_0_2
		DCD		PPU8_EF_0_2
		DCD		PPU8_F0_0_2
		DCD		PPU8_F1_0_2
		DCD		PPU8_F2_0_2
		DCD		PPU8_F3_0_2
		DCD		PPU8_F4_0_2
		DCD		PPU8_F5_0_2
		DCD		PPU8_F6_0_2
		DCD		PPU8_F7_0_2
		DCD		PPU8_F8_0_2
		DCD		PPU8_F9_0_2
		DCD		PPU8_FA_0_2
		DCD		PPU8_FB_0_2
		DCD		PPU8_FC_0_2
		DCD		PPU8_FD_0_2
		DCD		PPU8_FE_0_2
		DCD		PPU8_FF_0_2


PPU8_00_1_2
;;case 00000000
;;mode : 00000000 => first pix:0
	;;Pos : 0, Pix opaque : 8, Pix transp : 0
		ldmia	R11!,{R0,R1}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		orr		R0,R0,R1,lsl #16
		mov		R1,R1,lsr #16
		str		R0,[R12],#4
		strh	R1,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_01_1_2
;;case 00000001
;;mode : 00000001 => first pix:0
	;;Pos : 0, Pix opaque : 7, Pix transp : 1
		ldmia	R11!,{R0,R1}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		orr		R0,R0,R1,lsl #16
		mov		R1,R1,lsr #16
		str		R0,[R12],#4
		strb	R1,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_02_1_2
;;case 00000010
;;mode : 00000010 => first pix:0
	;;Pos : 0, Pix opaque : 6, Pix transp : 1
		ldmia	R11,{R0,R1}
		add		R11,R11,#7
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		orr		R0,R0,R1,lsl #16
		str		R0,[R12],#5
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_03_1_2
;;case 00000011
;;mode : 00000011 => first pix:0
	;;Pos : 0, Pix opaque : 6, Pix transp : 2
		ldmia	R11,{R0,R1}
		add		R11,R11,#8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		orr		R0,R0,R1,lsl #16
		str		R0,[R12],#6
		NEXT_COL8
;;----------------------------------------

PPU8_04_1_2
;;case 00000100
;;mode : 00000100 => first pix:0
	;;Pos : 0, Pix opaque : 5, Pix transp : 1
		ldmia	R11,{R0,R1}
		add		R11,R11,#6
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		orr		R0,R0,R1,lsl #16
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_05_1_2
;;case 00000101
;;mode : 00000101 => first pix:0
	;;Pos : 0, Pix opaque : 5, Pix transp : 1
		ldmia	R11,{R0,R1}
		add		R11,R11,#6
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		orr		R0,R0,R1,lsl #16
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_06_1_2
;;case 00000110
;;mode : 00000110 => first pix:0
	;;Pos : 0, Pix opaque : 5, Pix transp : 2
		ldmia	R11,{R0,R1}
		add		R11,R11,#7
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		orr		R0,R0,R1,lsl #16
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_07_1_2
;;case 00000111
;;mode : 00000111 => first pix:0
	;;Pos : 0, Pix opaque : 5, Pix transp : 3
		ldmia	R11,{R0,R1}
		add		R11,R11,#8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		orr		R0,R0,R1,lsl #16
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_08_1_2
;;case 00001000
;;mode : 00001000 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#3
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_09_1_2
;;case 00001001
;;mode : 00001001 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#3
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_0A_1_2
;;case 00001010
;;mode : 00001010 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#3
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_0B_1_2
;;case 00001011
;;mode : 00001011 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#3
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_0C_1_2
;;case 00001100
;;mode : 00001100 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#6
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#4
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_0D_1_2
;;case 00001101
;;mode : 00001101 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#6
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#4
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_0E_1_2
;;case 00001110
;;mode : 00001110 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 3
		ldmia	R11,{R0}
		add		R11,R11,#7
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#5
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_0F_1_2
;;case 00001111
;;mode : 00001111 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 4
		ldmia	R11,{R0}
		add		R11,R11,#8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#6
		NEXT_COL8
;;----------------------------------------

PPU8_10_1_2
;;case 00010000
;;mode : 00010000 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_11_1_2
;;case 00010001
;;mode : 00010001 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_12_1_2
;;case 00010010
;;mode : 00010010 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_13_1_2
;;case 00010011
;;mode : 00010011 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_14_1_2
;;case 00010100
;;mode : 00010100 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_15_1_2
;;case 00010101
;;mode : 00010101 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_16_1_2
;;case 00010110
;;mode : 00010110 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_17_1_2
;;case 00010111
;;mode : 00010111 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_18_1_2
;;case 00011000
;;mode : 00011000 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_19_1_2
;;case 00011001
;;mode : 00011001 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_1A_1_2
;;case 00011010
;;mode : 00011010 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_1B_1_2
;;case 00011011
;;mode : 00011011 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_1C_1_2
;;case 00011100
;;mode : 00011100 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 3
		ldmia	R11,{R0}
		add		R11,R11,#6
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#4
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_1D_1_2
;;case 00011101
;;mode : 00011101 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 3
		ldmia	R11,{R0}
		add		R11,R11,#6
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#4
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_1E_1_2
;;case 00011110
;;mode : 00011110 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 4
		ldmia	R11,{R0}
		add		R11,R11,#7
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#5
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_1F_1_2
;;case 00011111
;;mode : 00011111 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 5
		ldmia	R11,{R0}
		add		R11,R11,#8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#6
		NEXT_COL8
;;----------------------------------------

PPU8_20_1_2
;;case 00100000
;;mode : 00100000 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 5, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_21_1_2
;;case 00100001
;;mode : 00100001 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 4, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_22_1_2
;;case 00100010
;;mode : 00100010 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_23_1_2
;;case 00100011
;;mode : 00100011 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 3, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_24_1_2
;;case 00100100
;;mode : 00100100 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_25_1_2
;;case 00100101
;;mode : 00100101 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_26_1_2
;;case 00100110
;;mode : 00100110 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_27_1_2
;;case 00100111
;;mode : 00100111 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 2, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_28_1_2
;;case 00101000
;;mode : 00101000 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_29_1_2
;;case 00101001
;;mode : 00101001 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_2A_1_2
;;case 00101010
;;mode : 00101010 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_2B_1_2
;;case 00101011
;;mode : 00101011 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_2C_1_2
;;case 00101100
;;mode : 00101100 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_2D_1_2
;;case 00101101
;;mode : 00101101 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_2E_1_2
;;case 00101110
;;mode : 00101110 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_2F_1_2
;;case 00101111
;;mode : 00101111 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
		NEXT_COL8
;;----------------------------------------

PPU8_30_1_2
;;case 00110000
;;mode : 00110000 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_31_1_2
;;case 00110001
;;mode : 00110001 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_32_1_2
;;case 00110010
;;mode : 00110010 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_33_1_2
;;case 00110011
;;mode : 00110011 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_34_1_2
;;case 00110100
;;mode : 00110100 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_35_1_2
;;case 00110101
;;mode : 00110101 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_36_1_2
;;case 00110110
;;mode : 00110110 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_37_1_2
;;case 00110111
;;mode : 00110111 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_38_1_2
;;case 00111000
;;mode : 00111000 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 3
		ldrh	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#4
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_39_1_2
;;case 00111001
;;mode : 00111001 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 3
		ldrh	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#4
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_3A_1_2
;;case 00111010
;;mode : 00111010 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 3
		ldrh	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#4
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_3B_1_2
;;case 00111011
;;mode : 00111011 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 3
		ldrh	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#4
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_3C_1_2
;;case 00111100
;;mode : 00111100 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 4
		ldrh	R0,[R11]
		add		R11,R11,#6
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#5
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_3D_1_2
;;case 00111101
;;mode : 00111101 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 4
		ldrh	R0,[R11]
		add		R11,R11,#6
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#5
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_3E_1_2
;;case 00111110
;;mode : 00111110 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 5
		ldrh	R0,[R11]
		add		R11,R11,#7
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#6
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_3F_1_2
;;case 00111111
;;mode : 00111111 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 6
		ldrh	R0,[R11]
		add		R11,R11,#8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#7
		NEXT_COL8
;;----------------------------------------

PPU8_40_1_2
;;case 01000000
;;mode : 01000000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 6, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_41_1_2
;;case 01000001
;;mode : 01000001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 5, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_42_1_2
;;case 01000010
;;mode : 01000010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 4, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_43_1_2
;;case 01000011
;;mode : 01000011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 4, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_44_1_2
;;case 01000100
;;mode : 01000100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_45_1_2
;;case 01000101
;;mode : 01000101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_46_1_2
;;case 01000110
;;mode : 01000110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 3, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_47_1_2
;;case 01000111
;;mode : 01000111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 3, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_48_1_2
;;case 01001000
;;mode : 01001000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_49_1_2
;;case 01001001
;;mode : 01001001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_4A_1_2
;;case 01001010
;;mode : 01001010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_4B_1_2
;;case 01001011
;;mode : 01001011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_4C_1_2
;;case 01001100
;;mode : 01001100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_4D_1_2
;;case 01001101
;;mode : 01001101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_4E_1_2
;;case 01001110
;;mode : 01001110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 2, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_4F_1_2
;;case 01001111
;;mode : 01001111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 2, Pix transp : 4
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
		NEXT_COL8
;;----------------------------------------

PPU8_50_1_2
;;case 01010000
;;mode : 01010000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_51_1_2
;;case 01010001
;;mode : 01010001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_52_1_2
;;case 01010010
;;mode : 01010010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_53_1_2
;;case 01010011
;;mode : 01010011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_54_1_2
;;case 01010100
;;mode : 01010100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_55_1_2
;;case 01010101
;;mode : 01010101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_56_1_2
;;case 01010110
;;mode : 01010110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_57_1_2
;;case 01010111
;;mode : 01010111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_58_1_2
;;case 01011000
;;mode : 01011000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_59_1_2
;;case 01011001
;;mode : 01011001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_5A_1_2
;;case 01011010
;;mode : 01011010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_5B_1_2
;;case 01011011
;;mode : 01011011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_5C_1_2
;;case 01011100
;;mode : 01011100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_5D_1_2
;;case 01011101
;;mode : 01011101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_5E_1_2
;;case 01011110
;;mode : 01011110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_5F_1_2
;;case 01011111
;;mode : 01011111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 5
		ldrb	R0,[R11],#6
		strb	R0,[R12],#6
		NEXT_COL8
;;----------------------------------------

PPU8_60_1_2
;;case 01100000
;;mode : 01100000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 5, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_61_1_2
;;case 01100001
;;mode : 01100001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 4, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_62_1_2
;;case 01100010
;;mode : 01100010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_63_1_2
;;case 01100011
;;mode : 01100011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 3, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_64_1_2
;;case 01100100
;;mode : 01100100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_65_1_2
;;case 01100101
;;mode : 01100101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_66_1_2
;;case 01100110
;;mode : 01100110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_67_1_2
;;case 01100111
;;mode : 01100111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 2, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_68_1_2
;;case 01101000
;;mode : 01101000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_69_1_2
;;case 01101001
;;mode : 01101001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_6A_1_2
;;case 01101010
;;mode : 01101010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_6B_1_2
;;case 01101011
;;mode : 01101011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_6C_1_2
;;case 01101100
;;mode : 01101100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_6D_1_2
;;case 01101101
;;mode : 01101101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_6E_1_2
;;case 01101110
;;mode : 01101110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_6F_1_2
;;case 01101111
;;mode : 01101111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
		NEXT_COL8
;;----------------------------------------

PPU8_70_1_2
;;case 01110000
;;mode : 01110000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_71_1_2
;;case 01110001
;;mode : 01110001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_72_1_2
;;case 01110010
;;mode : 01110010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_73_1_2
;;case 01110011
;;mode : 01110011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_74_1_2
;;case 01110100
;;mode : 01110100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_75_1_2
;;case 01110101
;;mode : 01110101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_76_1_2
;;case 01110110
;;mode : 01110110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_77_1_2
;;case 01110111
;;mode : 01110111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_78_1_2
;;case 01111000
;;mode : 01111000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#5
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_79_1_2
;;case 01111001
;;mode : 01111001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#5
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_7A_1_2
;;case 01111010
;;mode : 01111010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#5
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_7B_1_2
;;case 01111011
;;mode : 01111011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#5
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_7C_1_2
;;case 01111100
;;mode : 01111100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 5
		ldrb	R0,[R11]
		add		R11,R11,#6
		strb	R0,[R12],#6
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_7D_1_2
;;case 01111101
;;mode : 01111101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 5
		ldrb	R0,[R11]
		add		R11,R11,#6
		strb	R0,[R12],#6
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_7E_1_2
;;case 01111110
;;mode : 01111110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 6
		ldrb	R0,[R11]
		add		R11,R11,#7
		strb	R0,[R12],#7
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_7F_1_2
;;case 01111111
;;mode : 01111111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 7
		ldrb	R0,[R11]
		add		R11,R11,#8
		strb	R0,[R12],#8
		NEXT_COL8
;;----------------------------------------


PPU8_80_1_2
;;case 10000000
;;mode : 10000000 => first pix:1
	;;Pos : 1, Pix opaque : 7, Pix transp : 0
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_81_1_2
;;case 10000001
;;mode : 10000001 => first pix:1
	;;Pos : 1, Pix opaque : 6, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_82_1_2
;;case 10000010
;;mode : 10000010 => first pix:1
	;;Pos : 1, Pix opaque : 5, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_83_1_2
;;case 10000011
;;mode : 10000011 => first pix:1
	;;Pos : 1, Pix opaque : 5, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_84_1_2
;;case 10000100
;;mode : 10000100 => first pix:1
	;;Pos : 1, Pix opaque : 4, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_85_1_2
;;case 10000101
;;mode : 10000101 => first pix:1
	;;Pos : 1, Pix opaque : 4, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_86_1_2
;;case 10000110
;;mode : 10000110 => first pix:1
	;;Pos : 1, Pix opaque : 4, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_87_1_2
;;case 10000111
;;mode : 10000111 => first pix:1
	;;Pos : 1, Pix opaque : 4, Pix transp : 3
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_88_1_2
;;case 10001000
;;mode : 10001000 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_89_1_2
;;case 10001001
;;mode : 10001001 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_8A_1_2
;;case 10001010
;;mode : 10001010 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_8B_1_2
;;case 10001011
;;mode : 10001011 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_8C_1_2
;;case 10001100
;;mode : 10001100 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_8D_1_2
;;case 10001101
;;mode : 10001101 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_8E_1_2
;;case 10001110
;;mode : 10001110 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 3
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_8F_1_2
;;case 10001111
;;mode : 10001111 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 4
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
		NEXT_COL8
;;----------------------------------------

PPU8_90_1_2
;;case 10010000
;;mode : 10010000 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_91_1_2
;;case 10010001
;;mode : 10010001 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_92_1_2
;;case 10010010
;;mode : 10010010 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_93_1_2
;;case 10010011
;;mode : 10010011 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_94_1_2
;;case 10010100
;;mode : 10010100 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_95_1_2
;;case 10010101
;;mode : 10010101 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_96_1_2
;;case 10010110
;;mode : 10010110 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_97_1_2
;;case 10010111
;;mode : 10010111 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_98_1_2
;;case 10011000
;;mode : 10011000 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_99_1_2
;;case 10011001
;;mode : 10011001 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_9A_1_2
;;case 10011010
;;mode : 10011010 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_9B_1_2
;;case 10011011
;;mode : 10011011 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_9C_1_2
;;case 10011100
;;mode : 10011100 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 3
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_9D_1_2
;;case 10011101
;;mode : 10011101 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 3
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_9E_1_2
;;case 10011110
;;mode : 10011110 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 4
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_9F_1_2
;;case 10011111
;;mode : 10011111 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 5
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#6
		strb	R0,[R12],#6
		NEXT_COL8
;;----------------------------------------

PPU8_A0_1_2
;;case 10100000
;;mode : 10100000 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 5, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_A1_1_2
;;case 10100001
;;mode : 10100001 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 4, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_A2_1_2
;;case 10100010
;;mode : 10100010 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_A3_1_2
;;case 10100011
;;mode : 10100011 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 3, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_A4_1_2
;;case 10100100
;;mode : 10100100 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_A5_1_2
;;case 10100101
;;mode : 10100101 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_A6_1_2
;;case 10100110
;;mode : 10100110 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_A7_1_2
;;case 10100111
;;mode : 10100111 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 2, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_A8_1_2
;;case 10101000
;;mode : 10101000 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_A9_1_2
;;case 10101001
;;mode : 10101001 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_AA_1_2
;;case 10101010
;;mode : 10101010 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_AB_1_2
;;case 10101011
;;mode : 10101011 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_AC_1_2
;;case 10101100
;;mode : 10101100 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_AD_1_2
;;case 10101101
;;mode : 10101101 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_AE_1_2
;;case 10101110
;;mode : 10101110 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_AF_1_2
;;case 10101111
;;mode : 10101111 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
		NEXT_COL8
;;----------------------------------------

PPU8_B0_1_2
;;case 10110000
;;mode : 10110000 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_B1_1_2
;;case 10110001
;;mode : 10110001 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_B2_1_2
;;case 10110010
;;mode : 10110010 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_B3_1_2
;;case 10110011
;;mode : 10110011 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_B4_1_2
;;case 10110100
;;mode : 10110100 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_B5_1_2
;;case 10110101
;;mode : 10110101 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_B6_1_2
;;case 10110110
;;mode : 10110110 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_B7_1_2
;;case 10110111
;;mode : 10110111 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_B8_1_2
;;case 10111000
;;mode : 10111000 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_B9_1_2
;;case 10111001
;;mode : 10111001 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_BA_1_2
;;case 10111010
;;mode : 10111010 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_BB_1_2
;;case 10111011
;;mode : 10111011 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_BC_1_2
;;case 10111100
;;mode : 10111100 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 4
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_BD_1_2
;;case 10111101
;;mode : 10111101 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 4
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_BE_1_2
;;case 10111110
;;mode : 10111110 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 5
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#6
		strb	R0,[R12],#6
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_BF_1_2
;;case 10111111
;;mode : 10111111 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 6
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#7
		strb	R0,[R12],#7
		NEXT_COL8
;;----------------------------------------

PPU8_C0_1_2
;;case 11000000
;;mode : 11000000 => first pix:2
	;;Pos : 2, Pix opaque : 6, Pix transp : 0
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_C1_1_2
;;case 11000001
;;mode : 11000001 => first pix:2
	;;Pos : 2, Pix opaque : 5, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_C2_1_2
;;case 11000010
;;mode : 11000010 => first pix:2
	;;Pos : 2, Pix opaque : 4, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_C3_1_2
;;case 11000011
;;mode : 11000011 => first pix:2
	;;Pos : 2, Pix opaque : 4, Pix transp : 2
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_C4_1_2
;;case 11000100
;;mode : 11000100 => first pix:2
	;;Pos : 2, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_C5_1_2
;;case 11000101
;;mode : 11000101 => first pix:2
	;;Pos : 2, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_C6_1_2
;;case 11000110
;;mode : 11000110 => first pix:2
	;;Pos : 2, Pix opaque : 3, Pix transp : 2
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_C7_1_2
;;case 11000111
;;mode : 11000111 => first pix:2
	;;Pos : 2, Pix opaque : 3, Pix transp : 3
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_C8_1_2
;;case 11001000
;;mode : 11001000 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_C9_1_2
;;case 11001001
;;mode : 11001001 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_CA_1_2
;;case 11001010
;;mode : 11001010 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_CB_1_2
;;case 11001011
;;mode : 11001011 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_CC_1_2
;;case 11001100
;;mode : 11001100 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_CD_1_2
;;case 11001101
;;mode : 11001101 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_CE_1_2
;;case 11001110
;;mode : 11001110 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 3
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_CF_1_2
;;case 11001111
;;mode : 11001111 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 4
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
		NEXT_COL8
;;----------------------------------------

PPU8_D0_1_2
;;case 11010000
;;mode : 11010000 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_D1_1_2
;;case 11010001
;;mode : 11010001 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_D2_1_2
;;case 11010010
;;mode : 11010010 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_D3_1_2
;;case 11010011
;;mode : 11010011 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_D4_1_2
;;case 11010100
;;mode : 11010100 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_D5_1_2
;;case 11010101
;;mode : 11010101 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_D6_1_2
;;case 11010110
;;mode : 11010110 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_D7_1_2
;;case 11010111
;;mode : 11010111 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_D8_1_2
;;case 11011000
;;mode : 11011000 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_D9_1_2
;;case 11011001
;;mode : 11011001 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_DA_1_2
;;case 11011010
;;mode : 11011010 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_DB_1_2
;;case 11011011
;;mode : 11011011 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_DC_1_2
;;case 11011100
;;mode : 11011100 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_DD_1_2
;;case 11011101
;;mode : 11011101 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_DE_1_2
;;case 11011110
;;mode : 11011110 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 4
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_DF_1_2
;;case 11011111
;;mode : 11011111 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 5
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#6
		strb	R0,[R12],#6
		NEXT_COL8
;;----------------------------------------

PPU8_E0_1_2
;;case 11100000
;;mode : 11100000 => first pix:3
	;;Pos : 3, Pix opaque : 5, Pix transp : 0
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_E1_1_2
;;case 11100001
;;mode : 11100001 => first pix:3
	;;Pos : 3, Pix opaque : 4, Pix transp : 1
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_E2_1_2
;;case 11100010
;;mode : 11100010 => first pix:3
	;;Pos : 3, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_E3_1_2
;;case 11100011
;;mode : 11100011 => first pix:3
	;;Pos : 3, Pix opaque : 3, Pix transp : 2
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_E4_1_2
;;case 11100100
;;mode : 11100100 => first pix:3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_E5_1_2
;;case 11100101
;;mode : 11100101 => first pix:3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_E6_1_2
;;case 11100110
;;mode : 11100110 => first pix:3
	;;Pos : 3, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_E7_1_2
;;case 11100111
;;mode : 11100111 => first pix:3
	;;Pos : 3, Pix opaque : 2, Pix transp : 3
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_E8_1_2
;;case 11101000
;;mode : 11101000 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_E9_1_2
;;case 11101001
;;mode : 11101001 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_EA_1_2
;;case 11101010
;;mode : 11101010 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_EB_1_2
;;case 11101011
;;mode : 11101011 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_EC_1_2
;;case 11101100
;;mode : 11101100 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_ED_1_2
;;case 11101101
;;mode : 11101101 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_EE_1_2
;;case 11101110
;;mode : 11101110 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_EF_1_2
;;case 11101111
;;mode : 11101111 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 4
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
		NEXT_COL8
;;----------------------------------------

PPU8_F0_1_2
;;case 11110000
;;mode : 11110000 => first pix:4
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
		add	R11,R11,#4
		add	R12,R12,#4
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_F1_1_2
;;case 11110001
;;mode : 11110001 => first pix:4
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#4
		add	R12,R12,#4
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_F2_1_2
;;case 11110010
;;mode : 11110010 => first pix:4
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#4
		add	R12,R12,#4
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_F3_1_2
;;case 11110011
;;mode : 11110011 => first pix:4
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#4
		add	R12,R12,#4
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_F4_1_2
;;case 11110100
;;mode : 11110100 => first pix:4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#4
		add	R12,R12,#4
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_F5_1_2
;;case 11110101
;;mode : 11110101 => first pix:4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#4
		add	R12,R12,#4
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_F6_1_2
;;case 11110110
;;mode : 11110110 => first pix:4
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#4
		add	R12,R12,#4
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_F7_1_2
;;case 11110111
;;mode : 11110111 => first pix:4
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#4
		add	R12,R12,#4
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_F8_1_2
;;case 11111000
;;mode : 11111000 => first pix:5
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		add	R11,R11,#5
		add	R12,R12,#5
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_F9_1_2
;;case 11111001
;;mode : 11111001 => first pix:5
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#5
		add	R12,R12,#5
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_FA_1_2
;;case 11111010
;;mode : 11111010 => first pix:5
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#5
		add	R12,R12,#5
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_FB_1_2
;;case 11111011
;;mode : 11111011 => first pix:5
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#5
		add	R12,R12,#5
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_FC_1_2
;;case 11111100
;;mode : 11111100 => first pix:6
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		add	R11,R11,#6
		add	R12,R12,#6
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_FD_1_2
;;case 11111101
;;mode : 11111101 => first pix:6
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#6
		add	R12,R12,#6
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_FE_1_2
;;case 11111110
;;mode : 11111110 => first pix:7
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		add	R11,R11,#7
		add	R12,R12,#7
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_FF_1_2
;;case 11111111
		add		R11,R11,#8
		add		R12,R12,#8
		NEXT_COL8
;;----------------------------------------
jumptable_ppu812
		DCD		PPU8_00_1_2
		DCD		PPU8_01_1_2
		DCD		PPU8_02_1_2
		DCD		PPU8_03_1_2
		DCD		PPU8_04_1_2
		DCD		PPU8_05_1_2
		DCD		PPU8_06_1_2
		DCD		PPU8_07_1_2
		DCD		PPU8_08_1_2
		DCD		PPU8_09_1_2
		DCD		PPU8_0A_1_2
		DCD		PPU8_0B_1_2
		DCD		PPU8_0C_1_2
		DCD		PPU8_0D_1_2
		DCD		PPU8_0E_1_2
		DCD		PPU8_0F_1_2
		DCD		PPU8_10_1_2
		DCD		PPU8_11_1_2
		DCD		PPU8_12_1_2
		DCD		PPU8_13_1_2
		DCD		PPU8_14_1_2
		DCD		PPU8_15_1_2
		DCD		PPU8_16_1_2
		DCD		PPU8_17_1_2
		DCD		PPU8_18_1_2
		DCD		PPU8_19_1_2
		DCD		PPU8_1A_1_2
		DCD		PPU8_1B_1_2
		DCD		PPU8_1C_1_2
		DCD		PPU8_1D_1_2
		DCD		PPU8_1E_1_2
		DCD		PPU8_1F_1_2
		DCD		PPU8_20_1_2
		DCD		PPU8_21_1_2
		DCD		PPU8_22_1_2
		DCD		PPU8_23_1_2
		DCD		PPU8_24_1_2
		DCD		PPU8_25_1_2
		DCD		PPU8_26_1_2
		DCD		PPU8_27_1_2
		DCD		PPU8_28_1_2
		DCD		PPU8_29_1_2
		DCD		PPU8_2A_1_2
		DCD		PPU8_2B_1_2
		DCD		PPU8_2C_1_2
		DCD		PPU8_2D_1_2
		DCD		PPU8_2E_1_2
		DCD		PPU8_2F_1_2
		DCD		PPU8_30_1_2
		DCD		PPU8_31_1_2
		DCD		PPU8_32_1_2
		DCD		PPU8_33_1_2
		DCD		PPU8_34_1_2
		DCD		PPU8_35_1_2
		DCD		PPU8_36_1_2
		DCD		PPU8_37_1_2
		DCD		PPU8_38_1_2
		DCD		PPU8_39_1_2
		DCD		PPU8_3A_1_2
		DCD		PPU8_3B_1_2
		DCD		PPU8_3C_1_2
		DCD		PPU8_3D_1_2
		DCD		PPU8_3E_1_2
		DCD		PPU8_3F_1_2
		DCD		PPU8_40_1_2
		DCD		PPU8_41_1_2
		DCD		PPU8_42_1_2
		DCD		PPU8_43_1_2
		DCD		PPU8_44_1_2
		DCD		PPU8_45_1_2
		DCD		PPU8_46_1_2
		DCD		PPU8_47_1_2
		DCD		PPU8_48_1_2
		DCD		PPU8_49_1_2
		DCD		PPU8_4A_1_2
		DCD		PPU8_4B_1_2
		DCD		PPU8_4C_1_2
		DCD		PPU8_4D_1_2
		DCD		PPU8_4E_1_2
		DCD		PPU8_4F_1_2
		DCD		PPU8_50_1_2
		DCD		PPU8_51_1_2
		DCD		PPU8_52_1_2
		DCD		PPU8_53_1_2
		DCD		PPU8_54_1_2
		DCD		PPU8_55_1_2
		DCD		PPU8_56_1_2
		DCD		PPU8_57_1_2
		DCD		PPU8_58_1_2
		DCD		PPU8_59_1_2
		DCD		PPU8_5A_1_2
		DCD		PPU8_5B_1_2
		DCD		PPU8_5C_1_2
		DCD		PPU8_5D_1_2
		DCD		PPU8_5E_1_2
		DCD		PPU8_5F_1_2
		DCD		PPU8_60_1_2
		DCD		PPU8_61_1_2
		DCD		PPU8_62_1_2
		DCD		PPU8_63_1_2
		DCD		PPU8_64_1_2
		DCD		PPU8_65_1_2
		DCD		PPU8_66_1_2
		DCD		PPU8_67_1_2
		DCD		PPU8_68_1_2
		DCD		PPU8_69_1_2
		DCD		PPU8_6A_1_2
		DCD		PPU8_6B_1_2
		DCD		PPU8_6C_1_2
		DCD		PPU8_6D_1_2
		DCD		PPU8_6E_1_2
		DCD		PPU8_6F_1_2
		DCD		PPU8_70_1_2
		DCD		PPU8_71_1_2
		DCD		PPU8_72_1_2
		DCD		PPU8_73_1_2
		DCD		PPU8_74_1_2
		DCD		PPU8_75_1_2
		DCD		PPU8_76_1_2
		DCD		PPU8_77_1_2
		DCD		PPU8_78_1_2
		DCD		PPU8_79_1_2
		DCD		PPU8_7A_1_2
		DCD		PPU8_7B_1_2
		DCD		PPU8_7C_1_2
		DCD		PPU8_7D_1_2
		DCD		PPU8_7E_1_2
		DCD		PPU8_7F_1_2
		DCD		PPU8_80_1_2
		DCD		PPU8_81_1_2
		DCD		PPU8_82_1_2
		DCD		PPU8_83_1_2
		DCD		PPU8_84_1_2
		DCD		PPU8_85_1_2
		DCD		PPU8_86_1_2
		DCD		PPU8_87_1_2
		DCD		PPU8_88_1_2
		DCD		PPU8_89_1_2
		DCD		PPU8_8A_1_2
		DCD		PPU8_8B_1_2
		DCD		PPU8_8C_1_2
		DCD		PPU8_8D_1_2
		DCD		PPU8_8E_1_2
		DCD		PPU8_8F_1_2
		DCD		PPU8_90_1_2
		DCD		PPU8_91_1_2
		DCD		PPU8_92_1_2
		DCD		PPU8_93_1_2
		DCD		PPU8_94_1_2
		DCD		PPU8_95_1_2
		DCD		PPU8_96_1_2
		DCD		PPU8_97_1_2
		DCD		PPU8_98_1_2
		DCD		PPU8_99_1_2
		DCD		PPU8_9A_1_2
		DCD		PPU8_9B_1_2
		DCD		PPU8_9C_1_2
		DCD		PPU8_9D_1_2
		DCD		PPU8_9E_1_2
		DCD		PPU8_9F_1_2
		DCD		PPU8_A0_1_2
		DCD		PPU8_A1_1_2
		DCD		PPU8_A2_1_2
		DCD		PPU8_A3_1_2
		DCD		PPU8_A4_1_2
		DCD		PPU8_A5_1_2
		DCD		PPU8_A6_1_2
		DCD		PPU8_A7_1_2
		DCD		PPU8_A8_1_2
		DCD		PPU8_A9_1_2
		DCD		PPU8_AA_1_2
		DCD		PPU8_AB_1_2
		DCD		PPU8_AC_1_2
		DCD		PPU8_AD_1_2
		DCD		PPU8_AE_1_2
		DCD		PPU8_AF_1_2
		DCD		PPU8_B0_1_2
		DCD		PPU8_B1_1_2
		DCD		PPU8_B2_1_2
		DCD		PPU8_B3_1_2
		DCD		PPU8_B4_1_2
		DCD		PPU8_B5_1_2
		DCD		PPU8_B6_1_2
		DCD		PPU8_B7_1_2
		DCD		PPU8_B8_1_2
		DCD		PPU8_B9_1_2
		DCD		PPU8_BA_1_2
		DCD		PPU8_BB_1_2
		DCD		PPU8_BC_1_2
		DCD		PPU8_BD_1_2
		DCD		PPU8_BE_1_2
		DCD		PPU8_BF_1_2
		DCD		PPU8_C0_1_2
		DCD		PPU8_C1_1_2
		DCD		PPU8_C2_1_2
		DCD		PPU8_C3_1_2
		DCD		PPU8_C4_1_2
		DCD		PPU8_C5_1_2
		DCD		PPU8_C6_1_2
		DCD		PPU8_C7_1_2
		DCD		PPU8_C8_1_2
		DCD		PPU8_C9_1_2
		DCD		PPU8_CA_1_2
		DCD		PPU8_CB_1_2
		DCD		PPU8_CC_1_2
		DCD		PPU8_CD_1_2
		DCD		PPU8_CE_1_2
		DCD		PPU8_CF_1_2
		DCD		PPU8_D0_1_2
		DCD		PPU8_D1_1_2
		DCD		PPU8_D2_1_2
		DCD		PPU8_D3_1_2
		DCD		PPU8_D4_1_2
		DCD		PPU8_D5_1_2
		DCD		PPU8_D6_1_2
		DCD		PPU8_D7_1_2
		DCD		PPU8_D8_1_2
		DCD		PPU8_D9_1_2
		DCD		PPU8_DA_1_2
		DCD		PPU8_DB_1_2
		DCD		PPU8_DC_1_2
		DCD		PPU8_DD_1_2
		DCD		PPU8_DE_1_2
		DCD		PPU8_DF_1_2
		DCD		PPU8_E0_1_2
		DCD		PPU8_E1_1_2
		DCD		PPU8_E2_1_2
		DCD		PPU8_E3_1_2
		DCD		PPU8_E4_1_2
		DCD		PPU8_E5_1_2
		DCD		PPU8_E6_1_2
		DCD		PPU8_E7_1_2
		DCD		PPU8_E8_1_2
		DCD		PPU8_E9_1_2
		DCD		PPU8_EA_1_2
		DCD		PPU8_EB_1_2
		DCD		PPU8_EC_1_2
		DCD		PPU8_ED_1_2
		DCD		PPU8_EE_1_2
		DCD		PPU8_EF_1_2
		DCD		PPU8_F0_1_2
		DCD		PPU8_F1_1_2
		DCD		PPU8_F2_1_2
		DCD		PPU8_F3_1_2
		DCD		PPU8_F4_1_2
		DCD		PPU8_F5_1_2
		DCD		PPU8_F6_1_2
		DCD		PPU8_F7_1_2
		DCD		PPU8_F8_1_2
		DCD		PPU8_F9_1_2
		DCD		PPU8_FA_1_2
		DCD		PPU8_FB_1_2
		DCD		PPU8_FC_1_2
		DCD		PPU8_FD_1_2
		DCD		PPU8_FE_1_2
		DCD		PPU8_FF_1_2


PPU8_00_0_3
;;case 00000000
;;mode : 00000000 => first pix:0
	;;Pos : 0, Pix opaque : 8, Pix transp : 0
		ldmia	R11!,{R0,R1}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		strb	R1,[R12],#-1
		mov		R1,R1,lsr #8
		strb	R1,[R12],#-1
		mov		R1,R1,lsr #8
		strb	R1,[R12],#-1
		mov		R1,R1,lsr #8
		strb	R1,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_01_0_3
;;case 00000001
;;mode : 00000001 => first pix:0
	;;Pos : 0, Pix opaque : 7, Pix transp : 1
		ldmia	R11!,{R0,R1}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		strb	R1,[R12],#-1
		mov		R1,R1,lsr #8
		strb	R1,[R12],#-1
		mov		R1,R1,lsr #8
		strb	R1,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_02_0_3
;;case 00000010
;;mode : 00000010 => first pix:0
	;;Pos : 0, Pix opaque : 6, Pix transp : 1
		ldmia	R11,{R0,R1}
		add		R11,R11,#7
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		strb	R1,[R12],#-1
		mov		R1,R1,lsr #8
		strb	R1,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_03_0_3
;;case 00000011
;;mode : 00000011 => first pix:0
	;;Pos : 0, Pix opaque : 6, Pix transp : 2
		ldmia	R11,{R0,R1}
		add		R11,R11,#8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		strb	R1,[R12],#-1
		mov		R1,R1,lsr #8
		strb	R1,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_04_0_3
;;case 00000100
;;mode : 00000100 => first pix:0
	;;Pos : 0, Pix opaque : 5, Pix transp : 1
		ldmia	R11,{R0,R1}
		add		R11,R11,#6
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		strb	R1,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_05_0_3
;;case 00000101
;;mode : 00000101 => first pix:0
	;;Pos : 0, Pix opaque : 5, Pix transp : 1
		ldmia	R11,{R0,R1}
		add		R11,R11,#6
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		strb	R1,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_06_0_3
;;case 00000110
;;mode : 00000110 => first pix:0
	;;Pos : 0, Pix opaque : 5, Pix transp : 2
		ldmia	R11,{R0,R1}
		add		R11,R11,#7
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		strb	R1,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_07_0_3
;;case 00000111
;;mode : 00000111 => first pix:0
	;;Pos : 0, Pix opaque : 5, Pix transp : 3
		ldmia	R11,{R0,R1}
		add		R11,R11,#8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		strb	R1,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_08_0_3
;;case 00001000
;;mode : 00001000 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_09_0_3
;;case 00001001
;;mode : 00001001 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_0A_0_3
;;case 00001010
;;mode : 00001010 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_0B_0_3
;;case 00001011
;;mode : 00001011 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_0C_0_3
;;case 00001100
;;mode : 00001100 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#6
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_0D_0_3
;;case 00001101
;;mode : 00001101 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#6
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_0E_0_3
;;case 00001110
;;mode : 00001110 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 3
		ldmia	R11,{R0}
		add		R11,R11,#7
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_0F_0_3
;;case 00001111
;;mode : 00001111 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 4
		ldmia	R11,{R0}
		add		R11,R11,#8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-5
		NEXT_COL8
;;----------------------------------------

PPU8_10_0_3
;;case 00010000
;;mode : 00010000 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_11_0_3
;;case 00010001
;;mode : 00010001 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_12_0_3
;;case 00010010
;;mode : 00010010 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_13_0_3
;;case 00010011
;;mode : 00010011 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_14_0_3
;;case 00010100
;;mode : 00010100 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_15_0_3
;;case 00010101
;;mode : 00010101 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_16_0_3
;;case 00010110
;;mode : 00010110 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_17_0_3
;;case 00010111
;;mode : 00010111 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_18_0_3
;;case 00011000
;;mode : 00011000 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_19_0_3
;;case 00011001
;;mode : 00011001 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_1A_0_3
;;case 00011010
;;mode : 00011010 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_1B_0_3
;;case 00011011
;;mode : 00011011 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_1C_0_3
;;case 00011100
;;mode : 00011100 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 3
		ldmia	R11,{R0}
		add		R11,R11,#6
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-4
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_1D_0_3
;;case 00011101
;;mode : 00011101 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 3
		ldmia	R11,{R0}
		add		R11,R11,#6
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-4
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_1E_0_3
;;case 00011110
;;mode : 00011110 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 4
		ldmia	R11,{R0}
		add		R11,R11,#7
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-5
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_1F_0_3
;;case 00011111
;;mode : 00011111 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 5
		ldmia	R11,{R0}
		add		R11,R11,#8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-6
		NEXT_COL8
;;----------------------------------------

PPU8_20_0_3
;;case 00100000
;;mode : 00100000 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 5, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_21_0_3
;;case 00100001
;;mode : 00100001 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 4, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_22_0_3
;;case 00100010
;;mode : 00100010 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_23_0_3
;;case 00100011
;;mode : 00100011 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 3, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_24_0_3
;;case 00100100
;;mode : 00100100 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_25_0_3
;;case 00100101
;;mode : 00100101 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_26_0_3
;;case 00100110
;;mode : 00100110 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_27_0_3
;;case 00100111
;;mode : 00100111 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 2, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_28_0_3
;;case 00101000
;;mode : 00101000 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_29_0_3
;;case 00101001
;;mode : 00101001 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_2A_0_3
;;case 00101010
;;mode : 00101010 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_2B_0_3
;;case 00101011
;;mode : 00101011 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_2C_0_3
;;case 00101100
;;mode : 00101100 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_2D_0_3
;;case 00101101
;;mode : 00101101 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_2E_0_3
;;case 00101110
;;mode : 00101110 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_2F_0_3
;;case 00101111
;;mode : 00101111 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
		NEXT_COL8
;;----------------------------------------

PPU8_30_0_3
;;case 00110000
;;mode : 00110000 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_31_0_3
;;case 00110001
;;mode : 00110001 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_32_0_3
;;case 00110010
;;mode : 00110010 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_33_0_3
;;case 00110011
;;mode : 00110011 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_34_0_3
;;case 00110100
;;mode : 00110100 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_35_0_3
;;case 00110101
;;mode : 00110101 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_36_0_3
;;case 00110110
;;mode : 00110110 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_37_0_3
;;case 00110111
;;mode : 00110111 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_38_0_3
;;case 00111000
;;mode : 00111000 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 3
		ldrh	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-4
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_39_0_3
;;case 00111001
;;mode : 00111001 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 3
		ldrh	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-4
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_3A_0_3
;;case 00111010
;;mode : 00111010 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 3
		ldrh	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-4
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_3B_0_3
;;case 00111011
;;mode : 00111011 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 3
		ldrh	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-4
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_3C_0_3
;;case 00111100
;;mode : 00111100 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 4
		ldrh	R0,[R11]
		add		R11,R11,#6
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-5
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_3D_0_3
;;case 00111101
;;mode : 00111101 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 4
		ldrh	R0,[R11]
		add		R11,R11,#6
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-5
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_3E_0_3
;;case 00111110
;;mode : 00111110 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 5
		ldrh	R0,[R11]
		add		R11,R11,#7
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-6
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_3F_0_3
;;case 00111111
;;mode : 00111111 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 6
		ldrh	R0,[R11]
		add		R11,R11,#8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-7
		NEXT_COL8
;;----------------------------------------

PPU8_40_0_3
;;case 01000000
;;mode : 01000000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 6, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_41_0_3
;;case 01000001
;;mode : 01000001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 5, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_42_0_3
;;case 01000010
;;mode : 01000010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 4, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_43_0_3
;;case 01000011
;;mode : 01000011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 4, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_44_0_3
;;case 01000100
;;mode : 01000100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_45_0_3
;;case 01000101
;;mode : 01000101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_46_0_3
;;case 01000110
;;mode : 01000110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 3, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_47_0_3
;;case 01000111
;;mode : 01000111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 3, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_48_0_3
;;case 01001000
;;mode : 01001000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_49_0_3
;;case 01001001
;;mode : 01001001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_4A_0_3
;;case 01001010
;;mode : 01001010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_4B_0_3
;;case 01001011
;;mode : 01001011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_4C_0_3
;;case 01001100
;;mode : 01001100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_4D_0_3
;;case 01001101
;;mode : 01001101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_4E_0_3
;;case 01001110
;;mode : 01001110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 2, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_4F_0_3
;;case 01001111
;;mode : 01001111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 2, Pix transp : 4
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
		NEXT_COL8
;;----------------------------------------

PPU8_50_0_3
;;case 01010000
;;mode : 01010000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_51_0_3
;;case 01010001
;;mode : 01010001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_52_0_3
;;case 01010010
;;mode : 01010010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_53_0_3
;;case 01010011
;;mode : 01010011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_54_0_3
;;case 01010100
;;mode : 01010100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_55_0_3
;;case 01010101
;;mode : 01010101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_56_0_3
;;case 01010110
;;mode : 01010110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_57_0_3
;;case 01010111
;;mode : 01010111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_58_0_3
;;case 01011000
;;mode : 01011000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_59_0_3
;;case 01011001
;;mode : 01011001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_5A_0_3
;;case 01011010
;;mode : 01011010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_5B_0_3
;;case 01011011
;;mode : 01011011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_5C_0_3
;;case 01011100
;;mode : 01011100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_5D_0_3
;;case 01011101
;;mode : 01011101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_5E_0_3
;;case 01011110
;;mode : 01011110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_5F_0_3
;;case 01011111
;;mode : 01011111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 2, Pix opaque : 1, Pix transp : 5
		ldrb	R0,[R11],#6
		strb	R0,[R12],#-6
		NEXT_COL8
;;----------------------------------------

PPU8_60_0_3
;;case 01100000
;;mode : 01100000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 5, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_61_0_3
;;case 01100001
;;mode : 01100001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 4, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_62_0_3
;;case 01100010
;;mode : 01100010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_63_0_3
;;case 01100011
;;mode : 01100011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 3, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_64_0_3
;;case 01100100
;;mode : 01100100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_65_0_3
;;case 01100101
;;mode : 01100101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_66_0_3
;;case 01100110
;;mode : 01100110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_67_0_3
;;case 01100111
;;mode : 01100111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 2, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_68_0_3
;;case 01101000
;;mode : 01101000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_69_0_3
;;case 01101001
;;mode : 01101001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_6A_0_3
;;case 01101010
;;mode : 01101010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_6B_0_3
;;case 01101011
;;mode : 01101011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_6C_0_3
;;case 01101100
;;mode : 01101100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_6D_0_3
;;case 01101101
;;mode : 01101101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_6E_0_3
;;case 01101110
;;mode : 01101110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_6F_0_3
;;case 01101111
;;mode : 01101111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 3, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
		NEXT_COL8
;;----------------------------------------

PPU8_70_0_3
;;case 01110000
;;mode : 01110000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_71_0_3
;;case 01110001
;;mode : 01110001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_72_0_3
;;case 01110010
;;mode : 01110010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_73_0_3
;;case 01110011
;;mode : 01110011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_74_0_3
;;case 01110100
;;mode : 01110100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_75_0_3
;;case 01110101
;;mode : 01110101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_76_0_3
;;case 01110110
;;mode : 01110110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_77_0_3
;;case 01110111
;;mode : 01110111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_78_0_3
;;case 01111000
;;mode : 01111000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#-5
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_79_0_3
;;case 01111001
;;mode : 01111001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#-5
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_7A_0_3
;;case 01111010
;;mode : 01111010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#-5
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_7B_0_3
;;case 01111011
;;mode : 01111011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#-5
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_7C_0_3
;;case 01111100
;;mode : 01111100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 5
		ldrb	R0,[R11]
		add		R11,R11,#6
		strb	R0,[R12],#-6
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_7D_0_3
;;case 01111101
;;mode : 01111101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 5
		ldrb	R0,[R11]
		add		R11,R11,#6
		strb	R0,[R12],#-6
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_7E_0_3
;;case 01111110
;;mode : 01111110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 6
		ldrb	R0,[R11]
		add		R11,R11,#7
		strb	R0,[R12],#-7
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_7F_0_3
;;case 01111111
;;mode : 01111111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 7
		ldrb	R0,[R11]
		add		R11,R11,#8
		strb	R0,[R12],#-8
		NEXT_COL8
;;----------------------------------------


PPU8_80_0_3
;;case 10000000
;;mode : 10000000 => first pix:1
	;;Pos : 1, Pix opaque : 7, Pix transp : 0
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_81_0_3
;;case 10000001
;;mode : 10000001 => first pix:1
	;;Pos : 1, Pix opaque : 6, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_82_0_3
;;case 10000010
;;mode : 10000010 => first pix:1
	;;Pos : 1, Pix opaque : 5, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_83_0_3
;;case 10000011
;;mode : 10000011 => first pix:1
	;;Pos : 1, Pix opaque : 5, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_84_0_3
;;case 10000100
;;mode : 10000100 => first pix:1
	;;Pos : 1, Pix opaque : 4, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_85_0_3
;;case 10000101
;;mode : 10000101 => first pix:1
	;;Pos : 1, Pix opaque : 4, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_86_0_3
;;case 10000110
;;mode : 10000110 => first pix:1
	;;Pos : 1, Pix opaque : 4, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_87_0_3
;;case 10000111
;;mode : 10000111 => first pix:1
	;;Pos : 1, Pix opaque : 4, Pix transp : 3
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_88_0_3
;;case 10001000
;;mode : 10001000 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_89_0_3
;;case 10001001
;;mode : 10001001 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_8A_0_3
;;case 10001010
;;mode : 10001010 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_8B_0_3
;;case 10001011
;;mode : 10001011 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_8C_0_3
;;case 10001100
;;mode : 10001100 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_8D_0_3
;;case 10001101
;;mode : 10001101 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_8E_0_3
;;case 10001110
;;mode : 10001110 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 3
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_8F_0_3
;;case 10001111
;;mode : 10001111 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 4
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
		NEXT_COL8
;;----------------------------------------

PPU8_90_0_3
;;case 10010000
;;mode : 10010000 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_91_0_3
;;case 10010001
;;mode : 10010001 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_92_0_3
;;case 10010010
;;mode : 10010010 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_93_0_3
;;case 10010011
;;mode : 10010011 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_94_0_3
;;case 10010100
;;mode : 10010100 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_95_0_3
;;case 10010101
;;mode : 10010101 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_96_0_3
;;case 10010110
;;mode : 10010110 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_97_0_3
;;case 10010111
;;mode : 10010111 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_98_0_3
;;case 10011000
;;mode : 10011000 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_99_0_3
;;case 10011001
;;mode : 10011001 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_9A_0_3
;;case 10011010
;;mode : 10011010 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_9B_0_3
;;case 10011011
;;mode : 10011011 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_9C_0_3
;;case 10011100
;;mode : 10011100 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 3
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_9D_0_3
;;case 10011101
;;mode : 10011101 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 3
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_9E_0_3
;;case 10011110
;;mode : 10011110 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 4
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_9F_0_3
;;case 10011111
;;mode : 10011111 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 5
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#6
		strb	R0,[R12],#-6
		NEXT_COL8
;;----------------------------------------

PPU8_A0_0_3
;;case 10100000
;;mode : 10100000 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 5, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_A1_0_3
;;case 10100001
;;mode : 10100001 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 4, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_A2_0_3
;;case 10100010
;;mode : 10100010 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_A3_0_3
;;case 10100011
;;mode : 10100011 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 3, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_A4_0_3
;;case 10100100
;;mode : 10100100 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_A5_0_3
;;case 10100101
;;mode : 10100101 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_A6_0_3
;;case 10100110
;;mode : 10100110 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_A7_0_3
;;case 10100111
;;mode : 10100111 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 2, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_A8_0_3
;;case 10101000
;;mode : 10101000 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_A9_0_3
;;case 10101001
;;mode : 10101001 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_AA_0_3
;;case 10101010
;;mode : 10101010 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_AB_0_3
;;case 10101011
;;mode : 10101011 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_AC_0_3
;;case 10101100
;;mode : 10101100 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_AD_0_3
;;case 10101101
;;mode : 10101101 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_AE_0_3
;;case 10101110
;;mode : 10101110 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_AF_0_3
;;case 10101111
;;mode : 10101111 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 3, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
		NEXT_COL8
;;----------------------------------------

PPU8_B0_0_3
;;case 10110000
;;mode : 10110000 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_B1_0_3
;;case 10110001
;;mode : 10110001 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_B2_0_3
;;case 10110010
;;mode : 10110010 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_B3_0_3
;;case 10110011
;;mode : 10110011 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_B4_0_3
;;case 10110100
;;mode : 10110100 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_B5_0_3
;;case 10110101
;;mode : 10110101 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_B6_0_3
;;case 10110110
;;mode : 10110110 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_B7_0_3
;;case 10110111
;;mode : 10110111 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_B8_0_3
;;case 10111000
;;mode : 10111000 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_B9_0_3
;;case 10111001
;;mode : 10111001 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_BA_0_3
;;case 10111010
;;mode : 10111010 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_BB_0_3
;;case 10111011
;;mode : 10111011 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_BC_0_3
;;case 10111100
;;mode : 10111100 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 4
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_BD_0_3
;;case 10111101
;;mode : 10111101 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 4
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_BE_0_3
;;case 10111110
;;mode : 10111110 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 5
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#6
		strb	R0,[R12],#-6
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_BF_0_3
;;case 10111111
;;mode : 10111111 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 6
		add	R11,R11,#1
		sub	R12,R12,#1
		ldrb	R0,[R11],#7
		strb	R0,[R12],#-7
		NEXT_COL8
;;----------------------------------------

PPU8_C0_0_3
;;case 11000000
;;mode : 11000000 => first pix:2
	;;Pos : 2, Pix opaque : 6, Pix transp : 0
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_C1_0_3
;;case 11000001
;;mode : 11000001 => first pix:2
	;;Pos : 2, Pix opaque : 5, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_C2_0_3
;;case 11000010
;;mode : 11000010 => first pix:2
	;;Pos : 2, Pix opaque : 4, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_C3_0_3
;;case 11000011
;;mode : 11000011 => first pix:2
	;;Pos : 2, Pix opaque : 4, Pix transp : 2
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_C4_0_3
;;case 11000100
;;mode : 11000100 => first pix:2
	;;Pos : 2, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_C5_0_3
;;case 11000101
;;mode : 11000101 => first pix:2
	;;Pos : 2, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_C6_0_3
;;case 11000110
;;mode : 11000110 => first pix:2
	;;Pos : 2, Pix opaque : 3, Pix transp : 2
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_C7_0_3
;;case 11000111
;;mode : 11000111 => first pix:2
	;;Pos : 2, Pix opaque : 3, Pix transp : 3
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_C8_0_3
;;case 11001000
;;mode : 11001000 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_C9_0_3
;;case 11001001
;;mode : 11001001 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_CA_0_3
;;case 11001010
;;mode : 11001010 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_CB_0_3
;;case 11001011
;;mode : 11001011 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_CC_0_3
;;case 11001100
;;mode : 11001100 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_CD_0_3
;;case 11001101
;;mode : 11001101 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_CE_0_3
;;case 11001110
;;mode : 11001110 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 3
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_CF_0_3
;;case 11001111
;;mode : 11001111 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 4
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
		NEXT_COL8
;;----------------------------------------

PPU8_D0_0_3
;;case 11010000
;;mode : 11010000 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_D1_0_3
;;case 11010001
;;mode : 11010001 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_D2_0_3
;;case 11010010
;;mode : 11010010 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_D3_0_3
;;case 11010011
;;mode : 11010011 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_D4_0_3
;;case 11010100
;;mode : 11010100 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_D5_0_3
;;case 11010101
;;mode : 11010101 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_D6_0_3
;;case 11010110
;;mode : 11010110 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_D7_0_3
;;case 11010111
;;mode : 11010111 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_D8_0_3
;;case 11011000
;;mode : 11011000 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_D9_0_3
;;case 11011001
;;mode : 11011001 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_DA_0_3
;;case 11011010
;;mode : 11011010 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_DB_0_3
;;case 11011011
;;mode : 11011011 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_DC_0_3
;;case 11011100
;;mode : 11011100 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_DD_0_3
;;case 11011101
;;mode : 11011101 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_DE_0_3
;;case 11011110
;;mode : 11011110 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 4
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_DF_0_3
;;case 11011111
;;mode : 11011111 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 5
		add	R11,R11,#2
		sub	R12,R12,#2
		ldrb	R0,[R11],#6
		strb	R0,[R12],#-6
		NEXT_COL8
;;----------------------------------------

PPU8_E0_0_3
;;case 11100000
;;mode : 11100000 => first pix:3
	;;Pos : 3, Pix opaque : 5, Pix transp : 0
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_E1_0_3
;;case 11100001
;;mode : 11100001 => first pix:3
	;;Pos : 3, Pix opaque : 4, Pix transp : 1
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_E2_0_3
;;case 11100010
;;mode : 11100010 => first pix:3
	;;Pos : 3, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_E3_0_3
;;case 11100011
;;mode : 11100011 => first pix:3
	;;Pos : 3, Pix opaque : 3, Pix transp : 2
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_E4_0_3
;;case 11100100
;;mode : 11100100 => first pix:3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_E5_0_3
;;case 11100101
;;mode : 11100101 => first pix:3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_E6_0_3
;;case 11100110
;;mode : 11100110 => first pix:3
	;;Pos : 3, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_E7_0_3
;;case 11100111
;;mode : 11100111 => first pix:3
	;;Pos : 3, Pix opaque : 2, Pix transp : 3
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_E8_0_3
;;case 11101000
;;mode : 11101000 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_E9_0_3
;;case 11101001
;;mode : 11101001 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_EA_0_3
;;case 11101010
;;mode : 11101010 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_EB_0_3
;;case 11101011
;;mode : 11101011 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_EC_0_3
;;case 11101100
;;mode : 11101100 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_ED_0_3
;;case 11101101
;;mode : 11101101 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_EE_0_3
;;case 11101110
;;mode : 11101110 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#-4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_EF_0_3
;;case 11101111
;;mode : 11101111 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 4
		add	R11,R11,#3
		sub	R12,R12,#3
		ldrb	R0,[R11],#5
		strb	R0,[R12],#-5
		NEXT_COL8
;;----------------------------------------

PPU8_F0_0_3
;;case 11110000
;;mode : 11110000 => first pix:4
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
		add	R11,R11,#4
		sub	R12,R12,#4
	ldmia	R11!,{R0}
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_F1_0_3
;;case 11110001
;;mode : 11110001 => first pix:4
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#4
		sub	R12,R12,#4
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_F2_0_3
;;case 11110010
;;mode : 11110010 => first pix:4
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#4
		sub	R12,R12,#4
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_F3_0_3
;;case 11110011
;;mode : 11110011 => first pix:4
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#4
		sub	R12,R12,#4
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_F4_0_3
;;case 11110100
;;mode : 11110100 => first pix:4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#4
		sub	R12,R12,#4
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_F5_0_3
;;case 11110101
;;mode : 11110101 => first pix:4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#4
		sub	R12,R12,#4
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#-2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_F6_0_3
;;case 11110110
;;mode : 11110110 => first pix:4
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#4
		sub	R12,R12,#4
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#-3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_F7_0_3
;;case 11110111
;;mode : 11110111 => first pix:4
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#4
		sub	R12,R12,#4
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#-4
		NEXT_COL8
;;----------------------------------------

PPU8_F8_0_3
;;case 11111000
;;mode : 11111000 => first pix:5
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		add	R11,R11,#5
		sub	R12,R12,#5
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_F9_0_3
;;case 11111001
;;mode : 11111001 => first pix:5
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#5
		sub	R12,R12,#5
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_FA_0_3
;;case 11111010
;;mode : 11111010 => first pix:5
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#5
		sub	R12,R12,#5
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_FB_0_3
;;case 11111011
;;mode : 11111011 => first pix:5
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#5
		sub	R12,R12,#5
		ldrb	R0,[R11],#3
		strb	R0,[R12],#-3
		NEXT_COL8
;;----------------------------------------

PPU8_FC_0_3
;;case 11111100
;;mode : 11111100 => first pix:6
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		add	R11,R11,#6
		sub	R12,R12,#6
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_FD_0_3
;;case 11111101
;;mode : 11111101 => first pix:6
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#6
		sub	R12,R12,#6
		ldrb	R0,[R11],#2
		strb	R0,[R12],#-2
		NEXT_COL8
;;----------------------------------------

PPU8_FE_0_3
;;case 11111110
;;mode : 11111110 => first pix:7
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		add	R11,R11,#7
		sub	R12,R12,#7
		ldrb	R0,[R11],#1
		strb	R0,[R12],#-1
		NEXT_COL8
;;----------------------------------------

PPU8_FF_0_3
;;case 11111111
		add		R11,R11,#8
		sub		R12,R12,#8
		NEXT_COL8
;;----------------------------------------
jumptable_ppu803
		DCD		PPU8_00_0_3
		DCD		PPU8_01_0_3
		DCD		PPU8_02_0_3
		DCD		PPU8_03_0_3
		DCD		PPU8_04_0_3
		DCD		PPU8_05_0_3
		DCD		PPU8_06_0_3
		DCD		PPU8_07_0_3
		DCD		PPU8_08_0_3
		DCD		PPU8_09_0_3
		DCD		PPU8_0A_0_3
		DCD		PPU8_0B_0_3
		DCD		PPU8_0C_0_3
		DCD		PPU8_0D_0_3
		DCD		PPU8_0E_0_3
		DCD		PPU8_0F_0_3
		DCD		PPU8_10_0_3
		DCD		PPU8_11_0_3
		DCD		PPU8_12_0_3
		DCD		PPU8_13_0_3
		DCD		PPU8_14_0_3
		DCD		PPU8_15_0_3
		DCD		PPU8_16_0_3
		DCD		PPU8_17_0_3
		DCD		PPU8_18_0_3
		DCD		PPU8_19_0_3
		DCD		PPU8_1A_0_3
		DCD		PPU8_1B_0_3
		DCD		PPU8_1C_0_3
		DCD		PPU8_1D_0_3
		DCD		PPU8_1E_0_3
		DCD		PPU8_1F_0_3
		DCD		PPU8_20_0_3
		DCD		PPU8_21_0_3
		DCD		PPU8_22_0_3
		DCD		PPU8_23_0_3
		DCD		PPU8_24_0_3
		DCD		PPU8_25_0_3
		DCD		PPU8_26_0_3
		DCD		PPU8_27_0_3
		DCD		PPU8_28_0_3
		DCD		PPU8_29_0_3
		DCD		PPU8_2A_0_3
		DCD		PPU8_2B_0_3
		DCD		PPU8_2C_0_3
		DCD		PPU8_2D_0_3
		DCD		PPU8_2E_0_3
		DCD		PPU8_2F_0_3
		DCD		PPU8_30_0_3
		DCD		PPU8_31_0_3
		DCD		PPU8_32_0_3
		DCD		PPU8_33_0_3
		DCD		PPU8_34_0_3
		DCD		PPU8_35_0_3
		DCD		PPU8_36_0_3
		DCD		PPU8_37_0_3
		DCD		PPU8_38_0_3
		DCD		PPU8_39_0_3
		DCD		PPU8_3A_0_3
		DCD		PPU8_3B_0_3
		DCD		PPU8_3C_0_3
		DCD		PPU8_3D_0_3
		DCD		PPU8_3E_0_3
		DCD		PPU8_3F_0_3
		DCD		PPU8_40_0_3
		DCD		PPU8_41_0_3
		DCD		PPU8_42_0_3
		DCD		PPU8_43_0_3
		DCD		PPU8_44_0_3
		DCD		PPU8_45_0_3
		DCD		PPU8_46_0_3
		DCD		PPU8_47_0_3
		DCD		PPU8_48_0_3
		DCD		PPU8_49_0_3
		DCD		PPU8_4A_0_3
		DCD		PPU8_4B_0_3
		DCD		PPU8_4C_0_3
		DCD		PPU8_4D_0_3
		DCD		PPU8_4E_0_3
		DCD		PPU8_4F_0_3
		DCD		PPU8_50_0_3
		DCD		PPU8_51_0_3
		DCD		PPU8_52_0_3
		DCD		PPU8_53_0_3
		DCD		PPU8_54_0_3
		DCD		PPU8_55_0_3
		DCD		PPU8_56_0_3
		DCD		PPU8_57_0_3
		DCD		PPU8_58_0_3
		DCD		PPU8_59_0_3
		DCD		PPU8_5A_0_3
		DCD		PPU8_5B_0_3
		DCD		PPU8_5C_0_3
		DCD		PPU8_5D_0_3
		DCD		PPU8_5E_0_3
		DCD		PPU8_5F_0_3
		DCD		PPU8_60_0_3
		DCD		PPU8_61_0_3
		DCD		PPU8_62_0_3
		DCD		PPU8_63_0_3
		DCD		PPU8_64_0_3
		DCD		PPU8_65_0_3
		DCD		PPU8_66_0_3
		DCD		PPU8_67_0_3
		DCD		PPU8_68_0_3
		DCD		PPU8_69_0_3
		DCD		PPU8_6A_0_3
		DCD		PPU8_6B_0_3
		DCD		PPU8_6C_0_3
		DCD		PPU8_6D_0_3
		DCD		PPU8_6E_0_3
		DCD		PPU8_6F_0_3
		DCD		PPU8_70_0_3
		DCD		PPU8_71_0_3
		DCD		PPU8_72_0_3
		DCD		PPU8_73_0_3
		DCD		PPU8_74_0_3
		DCD		PPU8_75_0_3
		DCD		PPU8_76_0_3
		DCD		PPU8_77_0_3
		DCD		PPU8_78_0_3
		DCD		PPU8_79_0_3
		DCD		PPU8_7A_0_3
		DCD		PPU8_7B_0_3
		DCD		PPU8_7C_0_3
		DCD		PPU8_7D_0_3
		DCD		PPU8_7E_0_3
		DCD		PPU8_7F_0_3
		DCD		PPU8_80_0_3
		DCD		PPU8_81_0_3
		DCD		PPU8_82_0_3
		DCD		PPU8_83_0_3
		DCD		PPU8_84_0_3
		DCD		PPU8_85_0_3
		DCD		PPU8_86_0_3
		DCD		PPU8_87_0_3
		DCD		PPU8_88_0_3
		DCD		PPU8_89_0_3
		DCD		PPU8_8A_0_3
		DCD		PPU8_8B_0_3
		DCD		PPU8_8C_0_3
		DCD		PPU8_8D_0_3
		DCD		PPU8_8E_0_3
		DCD		PPU8_8F_0_3
		DCD		PPU8_90_0_3
		DCD		PPU8_91_0_3
		DCD		PPU8_92_0_3
		DCD		PPU8_93_0_3
		DCD		PPU8_94_0_3
		DCD		PPU8_95_0_3
		DCD		PPU8_96_0_3
		DCD		PPU8_97_0_3
		DCD		PPU8_98_0_3
		DCD		PPU8_99_0_3
		DCD		PPU8_9A_0_3
		DCD		PPU8_9B_0_3
		DCD		PPU8_9C_0_3
		DCD		PPU8_9D_0_3
		DCD		PPU8_9E_0_3
		DCD		PPU8_9F_0_3
		DCD		PPU8_A0_0_3
		DCD		PPU8_A1_0_3
		DCD		PPU8_A2_0_3
		DCD		PPU8_A3_0_3
		DCD		PPU8_A4_0_3
		DCD		PPU8_A5_0_3
		DCD		PPU8_A6_0_3
		DCD		PPU8_A7_0_3
		DCD		PPU8_A8_0_3
		DCD		PPU8_A9_0_3
		DCD		PPU8_AA_0_3
		DCD		PPU8_AB_0_3
		DCD		PPU8_AC_0_3
		DCD		PPU8_AD_0_3
		DCD		PPU8_AE_0_3
		DCD		PPU8_AF_0_3
		DCD		PPU8_B0_0_3
		DCD		PPU8_B1_0_3
		DCD		PPU8_B2_0_3
		DCD		PPU8_B3_0_3
		DCD		PPU8_B4_0_3
		DCD		PPU8_B5_0_3
		DCD		PPU8_B6_0_3
		DCD		PPU8_B7_0_3
		DCD		PPU8_B8_0_3
		DCD		PPU8_B9_0_3
		DCD		PPU8_BA_0_3
		DCD		PPU8_BB_0_3
		DCD		PPU8_BC_0_3
		DCD		PPU8_BD_0_3
		DCD		PPU8_BE_0_3
		DCD		PPU8_BF_0_3
		DCD		PPU8_C0_0_3
		DCD		PPU8_C1_0_3
		DCD		PPU8_C2_0_3
		DCD		PPU8_C3_0_3
		DCD		PPU8_C4_0_3
		DCD		PPU8_C5_0_3
		DCD		PPU8_C6_0_3
		DCD		PPU8_C7_0_3
		DCD		PPU8_C8_0_3
		DCD		PPU8_C9_0_3
		DCD		PPU8_CA_0_3
		DCD		PPU8_CB_0_3
		DCD		PPU8_CC_0_3
		DCD		PPU8_CD_0_3
		DCD		PPU8_CE_0_3
		DCD		PPU8_CF_0_3
		DCD		PPU8_D0_0_3
		DCD		PPU8_D1_0_3
		DCD		PPU8_D2_0_3
		DCD		PPU8_D3_0_3
		DCD		PPU8_D4_0_3
		DCD		PPU8_D5_0_3
		DCD		PPU8_D6_0_3
		DCD		PPU8_D7_0_3
		DCD		PPU8_D8_0_3
		DCD		PPU8_D9_0_3
		DCD		PPU8_DA_0_3
		DCD		PPU8_DB_0_3
		DCD		PPU8_DC_0_3
		DCD		PPU8_DD_0_3
		DCD		PPU8_DE_0_3
		DCD		PPU8_DF_0_3
		DCD		PPU8_E0_0_3
		DCD		PPU8_E1_0_3
		DCD		PPU8_E2_0_3
		DCD		PPU8_E3_0_3
		DCD		PPU8_E4_0_3
		DCD		PPU8_E5_0_3
		DCD		PPU8_E6_0_3
		DCD		PPU8_E7_0_3
		DCD		PPU8_E8_0_3
		DCD		PPU8_E9_0_3
		DCD		PPU8_EA_0_3
		DCD		PPU8_EB_0_3
		DCD		PPU8_EC_0_3
		DCD		PPU8_ED_0_3
		DCD		PPU8_EE_0_3
		DCD		PPU8_EF_0_3
		DCD		PPU8_F0_0_3
		DCD		PPU8_F1_0_3
		DCD		PPU8_F2_0_3
		DCD		PPU8_F3_0_3
		DCD		PPU8_F4_0_3
		DCD		PPU8_F5_0_3
		DCD		PPU8_F6_0_3
		DCD		PPU8_F7_0_3
		DCD		PPU8_F8_0_3
		DCD		PPU8_F9_0_3
		DCD		PPU8_FA_0_3
		DCD		PPU8_FB_0_3
		DCD		PPU8_FC_0_3
		DCD		PPU8_FD_0_3
		DCD		PPU8_FE_0_3
		DCD		PPU8_FF_0_3


PPU8_00_1_3
;;case 00000000
;;mode : 00000000 => first pix:0
	;;Pos : 0, Pix opaque : 8, Pix transp : 0
		ldmia	R11!,{R0,R1}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		orr		R0,R0,R1,lsl #24
		mov		R1,R1,lsr #8
		str		R0,[R12],#4
		strh	R1,[R12],#2
		mov		R1,R1,lsr #16
		strb	R1,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_01_1_3
;;case 00000001
;;mode : 00000001 => first pix:0
	;;Pos : 0, Pix opaque : 7, Pix transp : 1
		ldmia	R11!,{R0,R1}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		orr		R0,R0,R1,lsl #24
		mov		R1,R1,lsr #8
		str		R0,[R12],#4
		strh	R1,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_02_1_3
;;case 00000010
;;mode : 00000010 => first pix:0
	;;Pos : 0, Pix opaque : 6, Pix transp : 1
		ldmia	R11,{R0,R1}
		add		R11,R11,#7
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		orr		R0,R0,R1,lsl #24
		mov		R1,R1,lsr #8
		str		R0,[R12],#4
		strb	R1,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_03_1_3
;;case 00000011
;;mode : 00000011 => first pix:0
	;;Pos : 0, Pix opaque : 6, Pix transp : 2
		ldmia	R11,{R0,R1}
		add		R11,R11,#8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		orr		R0,R0,R1,lsl #24
		mov		R1,R1,lsr #8
		str		R0,[R12],#4
		strb	R1,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_04_1_3
;;case 00000100
;;mode : 00000100 => first pix:0
	;;Pos : 0, Pix opaque : 5, Pix transp : 1
		ldmia	R11,{R0,R1}
		add		R11,R11,#6
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		orr		R0,R0,R1,lsl #24
		str		R0,[R12],#5
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_05_1_3
;;case 00000101
;;mode : 00000101 => first pix:0
	;;Pos : 0, Pix opaque : 5, Pix transp : 1
		ldmia	R11,{R0,R1}
		add		R11,R11,#6
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		orr		R0,R0,R1,lsl #24
		str		R0,[R12],#5
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_06_1_3
;;case 00000110
;;mode : 00000110 => first pix:0
	;;Pos : 0, Pix opaque : 5, Pix transp : 2
		ldmia	R11,{R0,R1}
		add		R11,R11,#7
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		orr		R0,R0,R1,lsl #24
		str		R0,[R12],#6
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_07_1_3
;;case 00000111
;;mode : 00000111 => first pix:0
	;;Pos : 0, Pix opaque : 5, Pix transp : 3
		ldmia	R11,{R0,R1}
		add		R11,R11,#8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		orr		R0,R0,R1,lsl #24
		str		R0,[R12],#7
		NEXT_COL8
;;----------------------------------------

PPU8_08_1_3
;;case 00001000
;;mode : 00001000 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_09_1_3
;;case 00001001
;;mode : 00001001 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_0A_1_3
;;case 00001010
;;mode : 00001010 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_0B_1_3
;;case 00001011
;;mode : 00001011 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_0C_1_3
;;case 00001100
;;mode : 00001100 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#6
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_0D_1_3
;;case 00001101
;;mode : 00001101 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#6
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_0E_1_3
;;case 00001110
;;mode : 00001110 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 3
		ldmia	R11,{R0}
		add		R11,R11,#7
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_0F_1_3
;;case 00001111
;;mode : 00001111 => first pix:0
	;;Pos : 0, Pix opaque : 4, Pix transp : 4
		ldmia	R11,{R0}
		add		R11,R11,#8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#5
		NEXT_COL8
;;----------------------------------------

PPU8_10_1_3
;;case 00010000
;;mode : 00010000 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#3
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_11_1_3
;;case 00010001
;;mode : 00010001 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#3
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_12_1_3
;;case 00010010
;;mode : 00010010 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#3
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_13_1_3
;;case 00010011
;;mode : 00010011 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#3
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_14_1_3
;;case 00010100
;;mode : 00010100 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#3
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_15_1_3
;;case 00010101
;;mode : 00010101 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#3
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_16_1_3
;;case 00010110
;;mode : 00010110 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#3
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_17_1_3
;;case 00010111
;;mode : 00010111 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#3
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_18_1_3
;;case 00011000
;;mode : 00011000 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#4
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_19_1_3
;;case 00011001
;;mode : 00011001 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#4
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_1A_1_3
;;case 00011010
;;mode : 00011010 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#4
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_1B_1_3
;;case 00011011
;;mode : 00011011 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 2
		ldmia	R11,{R0}
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#4
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_1C_1_3
;;case 00011100
;;mode : 00011100 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 3
		ldmia	R11,{R0}
		add		R11,R11,#6
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#5
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_1D_1_3
;;case 00011101
;;mode : 00011101 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 3
		ldmia	R11,{R0}
		add		R11,R11,#6
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#5
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_1E_1_3
;;case 00011110
;;mode : 00011110 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 4
		ldmia	R11,{R0}
		add		R11,R11,#7
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#6
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_1F_1_3
;;case 00011111
;;mode : 00011111 => first pix:0
	;;Pos : 0, Pix opaque : 3, Pix transp : 5
		ldmia	R11,{R0}
		add		R11,R11,#8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#7
		NEXT_COL8
;;----------------------------------------

PPU8_20_1_3
;;case 00100000
;;mode : 00100000 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 5, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_21_1_3
;;case 00100001
;;mode : 00100001 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 4, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_22_1_3
;;case 00100010
;;mode : 00100010 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_23_1_3
;;case 00100011
;;mode : 00100011 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 3, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_24_1_3
;;case 00100100
;;mode : 00100100 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_25_1_3
;;case 00100101
;;mode : 00100101 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_26_1_3
;;case 00100110
;;mode : 00100110 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_27_1_3
;;case 00100111
;;mode : 00100111 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 2, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_28_1_3
;;case 00101000
;;mode : 00101000 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_29_1_3
;;case 00101001
;;mode : 00101001 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_2A_1_3
;;case 00101010
;;mode : 00101010 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_2B_1_3
;;case 00101011
;;mode : 00101011 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_2C_1_3
;;case 00101100
;;mode : 00101100 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_2D_1_3
;;case 00101101
;;mode : 00101101 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_2E_1_3
;;case 00101110
;;mode : 00101110 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_2F_1_3
;;case 00101111
;;mode : 00101111 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
		NEXT_COL8
;;----------------------------------------

PPU8_30_1_3
;;case 00110000
;;mode : 00110000 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_31_1_3
;;case 00110001
;;mode : 00110001 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_32_1_3
;;case 00110010
;;mode : 00110010 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_33_1_3
;;case 00110011
;;mode : 00110011 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_34_1_3
;;case 00110100
;;mode : 00110100 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_35_1_3
;;case 00110101
;;mode : 00110101 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_36_1_3
;;case 00110110
;;mode : 00110110 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_37_1_3
;;case 00110111
;;mode : 00110111 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_38_1_3
;;case 00111000
;;mode : 00111000 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 3
		ldrh	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#4
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_39_1_3
;;case 00111001
;;mode : 00111001 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 3
		ldrh	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#4
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_3A_1_3
;;case 00111010
;;mode : 00111010 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 3
		ldrh	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#4
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_3B_1_3
;;case 00111011
;;mode : 00111011 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 3
		ldrh	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#4
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_3C_1_3
;;case 00111100
;;mode : 00111100 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 4
		ldrh	R0,[R11]
		add		R11,R11,#6
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#5
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_3D_1_3
;;case 00111101
;;mode : 00111101 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 4
		ldrh	R0,[R11]
		add		R11,R11,#6
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#5
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_3E_1_3
;;case 00111110
;;mode : 00111110 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 5
		ldrh	R0,[R11]
		add		R11,R11,#7
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#6
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_3F_1_3
;;case 00111111
;;mode : 00111111 => first pix:0
	;;Pos : 0, Pix opaque : 2, Pix transp : 6
		ldrh	R0,[R11]
		add		R11,R11,#8
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#7
		NEXT_COL8
;;----------------------------------------

PPU8_40_1_3
;;case 01000000
;;mode : 01000000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 6, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_41_1_3
;;case 01000001
;;mode : 01000001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 5, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_42_1_3
;;case 01000010
;;mode : 01000010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 4, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_43_1_3
;;case 01000011
;;mode : 01000011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 4, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_44_1_3
;;case 01000100
;;mode : 01000100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_45_1_3
;;case 01000101
;;mode : 01000101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_46_1_3
;;case 01000110
;;mode : 01000110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 3, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_47_1_3
;;case 01000111
;;mode : 01000111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 3, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_48_1_3
;;case 01001000
;;mode : 01001000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_49_1_3
;;case 01001001
;;mode : 01001001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_4A_1_3
;;case 01001010
;;mode : 01001010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_4B_1_3
;;case 01001011
;;mode : 01001011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_4C_1_3
;;case 01001100
;;mode : 01001100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_4D_1_3
;;case 01001101
;;mode : 01001101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_4E_1_3
;;case 01001110
;;mode : 01001110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 2, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_4F_1_3
;;case 01001111
;;mode : 01001111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 2, Pix transp : 4
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
		NEXT_COL8
;;----------------------------------------

PPU8_50_1_3
;;case 01010000
;;mode : 01010000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_51_1_3
;;case 01010001
;;mode : 01010001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_52_1_3
;;case 01010010
;;mode : 01010010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_53_1_3
;;case 01010011
;;mode : 01010011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_54_1_3
;;case 01010100
;;mode : 01010100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_55_1_3
;;case 01010101
;;mode : 01010101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_56_1_3
;;case 01010110
;;mode : 01010110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_57_1_3
;;case 01010111
;;mode : 01010111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_58_1_3
;;case 01011000
;;mode : 01011000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_59_1_3
;;case 01011001
;;mode : 01011001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_5A_1_3
;;case 01011010
;;mode : 01011010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_5B_1_3
;;case 01011011
;;mode : 01011011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_5C_1_3
;;case 01011100
;;mode : 01011100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_5D_1_3
;;case 01011101
;;mode : 01011101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_5E_1_3
;;case 01011110
;;mode : 01011110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_5F_1_3
;;case 01011111
;;mode : 01011111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 2, Pix opaque : 1, Pix transp : 5
		ldrb	R0,[R11],#6
		strb	R0,[R12],#6
		NEXT_COL8
;;----------------------------------------

PPU8_60_1_3
;;case 01100000
;;mode : 01100000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 5, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_61_1_3
;;case 01100001
;;mode : 01100001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 4, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_62_1_3
;;case 01100010
;;mode : 01100010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_63_1_3
;;case 01100011
;;mode : 01100011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 3, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_64_1_3
;;case 01100100
;;mode : 01100100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_65_1_3
;;case 01100101
;;mode : 01100101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_66_1_3
;;case 01100110
;;mode : 01100110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_67_1_3
;;case 01100111
;;mode : 01100111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 2, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_68_1_3
;;case 01101000
;;mode : 01101000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_69_1_3
;;case 01101001
;;mode : 01101001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_6A_1_3
;;case 01101010
;;mode : 01101010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_6B_1_3
;;case 01101011
;;mode : 01101011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_6C_1_3
;;case 01101100
;;mode : 01101100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_6D_1_3
;;case 01101101
;;mode : 01101101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_6E_1_3
;;case 01101110
;;mode : 01101110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_6F_1_3
;;case 01101111
;;mode : 01101111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 3, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
		NEXT_COL8
;;----------------------------------------

PPU8_70_1_3
;;case 01110000
;;mode : 01110000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_71_1_3
;;case 01110001
;;mode : 01110001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_72_1_3
;;case 01110010
;;mode : 01110010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_73_1_3
;;case 01110011
;;mode : 01110011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_74_1_3
;;case 01110100
;;mode : 01110100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_75_1_3
;;case 01110101
;;mode : 01110101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_76_1_3
;;case 01110110
;;mode : 01110110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_77_1_3
;;case 01110111
;;mode : 01110111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_78_1_3
;;case 01111000
;;mode : 01111000 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#5
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_79_1_3
;;case 01111001
;;mode : 01111001 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#5
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_7A_1_3
;;case 01111010
;;mode : 01111010 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#5
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_7B_1_3
;;case 01111011
;;mode : 01111011 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11]
		add		R11,R11,#5
		strb	R0,[R12],#5
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_7C_1_3
;;case 01111100
;;mode : 01111100 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 5
		ldrb	R0,[R11]
		add		R11,R11,#6
		strb	R0,[R12],#6
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_7D_1_3
;;case 01111101
;;mode : 01111101 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 5
		ldrb	R0,[R11]
		add		R11,R11,#6
		strb	R0,[R12],#6
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_7E_1_3
;;case 01111110
;;mode : 01111110 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 6
		ldrb	R0,[R11]
		add		R11,R11,#7
		strb	R0,[R12],#7
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_7F_1_3
;;case 01111111
;;mode : 01111111 => first pix:0
	;;Pos : 0, Pix opaque : 1, Pix transp : 7
		ldrb	R0,[R11]
		add		R11,R11,#8
		strb	R0,[R12],#8
		NEXT_COL8
;;----------------------------------------


PPU8_80_1_3
;;case 10000000
;;mode : 10000000 => first pix:1
	;;Pos : 1, Pix opaque : 7, Pix transp : 0
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_81_1_3
;;case 10000001
;;mode : 10000001 => first pix:1
	;;Pos : 1, Pix opaque : 6, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_82_1_3
;;case 10000010
;;mode : 10000010 => first pix:1
	;;Pos : 1, Pix opaque : 5, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_83_1_3
;;case 10000011
;;mode : 10000011 => first pix:1
	;;Pos : 1, Pix opaque : 5, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_84_1_3
;;case 10000100
;;mode : 10000100 => first pix:1
	;;Pos : 1, Pix opaque : 4, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_85_1_3
;;case 10000101
;;mode : 10000101 => first pix:1
	;;Pos : 1, Pix opaque : 4, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_86_1_3
;;case 10000110
;;mode : 10000110 => first pix:1
	;;Pos : 1, Pix opaque : 4, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_87_1_3
;;case 10000111
;;mode : 10000111 => first pix:1
	;;Pos : 1, Pix opaque : 4, Pix transp : 3
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_88_1_3
;;case 10001000
;;mode : 10001000 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_89_1_3
;;case 10001001
;;mode : 10001001 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_8A_1_3
;;case 10001010
;;mode : 10001010 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_8B_1_3
;;case 10001011
;;mode : 10001011 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_8C_1_3
;;case 10001100
;;mode : 10001100 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_8D_1_3
;;case 10001101
;;mode : 10001101 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_8E_1_3
;;case 10001110
;;mode : 10001110 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 3
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_8F_1_3
;;case 10001111
;;mode : 10001111 => first pix:1
	;;Pos : 1, Pix opaque : 3, Pix transp : 4
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
		NEXT_COL8
;;----------------------------------------

PPU8_90_1_3
;;case 10010000
;;mode : 10010000 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_91_1_3
;;case 10010001
;;mode : 10010001 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_92_1_3
;;case 10010010
;;mode : 10010010 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_93_1_3
;;case 10010011
;;mode : 10010011 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_94_1_3
;;case 10010100
;;mode : 10010100 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_95_1_3
;;case 10010101
;;mode : 10010101 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_96_1_3
;;case 10010110
;;mode : 10010110 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_97_1_3
;;case 10010111
;;mode : 10010111 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_98_1_3
;;case 10011000
;;mode : 10011000 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_99_1_3
;;case 10011001
;;mode : 10011001 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_9A_1_3
;;case 10011010
;;mode : 10011010 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_9B_1_3
;;case 10011011
;;mode : 10011011 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_9C_1_3
;;case 10011100
;;mode : 10011100 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 3
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_9D_1_3
;;case 10011101
;;mode : 10011101 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 3
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_9E_1_3
;;case 10011110
;;mode : 10011110 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 4
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_9F_1_3
;;case 10011111
;;mode : 10011111 => first pix:1
	;;Pos : 1, Pix opaque : 2, Pix transp : 5
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#6
		strb	R0,[R12],#6
		NEXT_COL8
;;----------------------------------------

PPU8_A0_1_3
;;case 10100000
;;mode : 10100000 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 5, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_A1_1_3
;;case 10100001
;;mode : 10100001 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 4, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_A2_1_3
;;case 10100010
;;mode : 10100010 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 3, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_A3_1_3
;;case 10100011
;;mode : 10100011 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 3, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_A4_1_3
;;case 10100100
;;mode : 10100100 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_A5_1_3
;;case 10100101
;;mode : 10100101 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_A6_1_3
;;case 10100110
;;mode : 10100110 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 2, Pix transp : 2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_A7_1_3
;;case 10100111
;;mode : 10100111 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 2, Pix transp : 3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_A8_1_3
;;case 10101000
;;mode : 10101000 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_A9_1_3
;;case 10101001
;;mode : 10101001 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_AA_1_3
;;case 10101010
;;mode : 10101010 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_AB_1_3
;;case 10101011
;;mode : 10101011 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_AC_1_3
;;case 10101100
;;mode : 10101100 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_AD_1_3
;;case 10101101
;;mode : 10101101 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_AE_1_3
;;case 10101110
;;mode : 10101110 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_AF_1_3
;;case 10101111
;;mode : 10101111 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 3, Pix opaque : 1, Pix transp : 4
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
		NEXT_COL8
;;----------------------------------------

PPU8_B0_1_3
;;case 10110000
;;mode : 10110000 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_B1_1_3
;;case 10110001
;;mode : 10110001 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_B2_1_3
;;case 10110010
;;mode : 10110010 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_B3_1_3
;;case 10110011
;;mode : 10110011 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_B4_1_3
;;case 10110100
;;mode : 10110100 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_B5_1_3
;;case 10110101
;;mode : 10110101 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_B6_1_3
;;case 10110110
;;mode : 10110110 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_B7_1_3
;;case 10110111
;;mode : 10110111 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_B8_1_3
;;case 10111000
;;mode : 10111000 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_B9_1_3
;;case 10111001
;;mode : 10111001 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_BA_1_3
;;case 10111010
;;mode : 10111010 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_BB_1_3
;;case 10111011
;;mode : 10111011 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_BC_1_3
;;case 10111100
;;mode : 10111100 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 4
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_BD_1_3
;;case 10111101
;;mode : 10111101 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 4
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_BE_1_3
;;case 10111110
;;mode : 10111110 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 5
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#6
		strb	R0,[R12],#6
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_BF_1_3
;;case 10111111
;;mode : 10111111 => first pix:1
	;;Pos : 1, Pix opaque : 1, Pix transp : 6
		add	R11,R11,#1
		add	R12,R12,#1
		ldrb	R0,[R11],#7
		strb	R0,[R12],#7
		NEXT_COL8
;;----------------------------------------

PPU8_C0_1_3
;;case 11000000
;;mode : 11000000 => first pix:2
	;;Pos : 2, Pix opaque : 6, Pix transp : 0
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_C1_1_3
;;case 11000001
;;mode : 11000001 => first pix:2
	;;Pos : 2, Pix opaque : 5, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_C2_1_3
;;case 11000010
;;mode : 11000010 => first pix:2
	;;Pos : 2, Pix opaque : 4, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_C3_1_3
;;case 11000011
;;mode : 11000011 => first pix:2
	;;Pos : 2, Pix opaque : 4, Pix transp : 2
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_C4_1_3
;;case 11000100
;;mode : 11000100 => first pix:2
	;;Pos : 2, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_C5_1_3
;;case 11000101
;;mode : 11000101 => first pix:2
	;;Pos : 2, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_C6_1_3
;;case 11000110
;;mode : 11000110 => first pix:2
	;;Pos : 2, Pix opaque : 3, Pix transp : 2
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_C7_1_3
;;case 11000111
;;mode : 11000111 => first pix:2
	;;Pos : 2, Pix opaque : 3, Pix transp : 3
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_C8_1_3
;;case 11001000
;;mode : 11001000 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_C9_1_3
;;case 11001001
;;mode : 11001001 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_CA_1_3
;;case 11001010
;;mode : 11001010 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_CB_1_3
;;case 11001011
;;mode : 11001011 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_CC_1_3
;;case 11001100
;;mode : 11001100 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_CD_1_3
;;case 11001101
;;mode : 11001101 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_CE_1_3
;;case 11001110
;;mode : 11001110 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 3
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_CF_1_3
;;case 11001111
;;mode : 11001111 => first pix:2
	;;Pos : 2, Pix opaque : 2, Pix transp : 4
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
		NEXT_COL8
;;----------------------------------------

PPU8_D0_1_3
;;case 11010000
;;mode : 11010000 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_D1_1_3
;;case 11010001
;;mode : 11010001 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_D2_1_3
;;case 11010010
;;mode : 11010010 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_D3_1_3
;;case 11010011
;;mode : 11010011 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_D4_1_3
;;case 11010100
;;mode : 11010100 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_D5_1_3
;;case 11010101
;;mode : 11010101 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_D6_1_3
;;case 11010110
;;mode : 11010110 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_D7_1_3
;;case 11010111
;;mode : 11010111 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_D8_1_3
;;case 11011000
;;mode : 11011000 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_D9_1_3
;;case 11011001
;;mode : 11011001 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_DA_1_3
;;case 11011010
;;mode : 11011010 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_DB_1_3
;;case 11011011
;;mode : 11011011 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_DC_1_3
;;case 11011100
;;mode : 11011100 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_DD_1_3
;;case 11011101
;;mode : 11011101 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_DE_1_3
;;case 11011110
;;mode : 11011110 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 4
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_DF_1_3
;;case 11011111
;;mode : 11011111 => first pix:2
	;;Pos : 2, Pix opaque : 1, Pix transp : 5
		add	R11,R11,#2
		add	R12,R12,#2
		ldrb	R0,[R11],#6
		strb	R0,[R12],#6
		NEXT_COL8
;;----------------------------------------

PPU8_E0_1_3
;;case 11100000
;;mode : 11100000 => first pix:3
	;;Pos : 3, Pix opaque : 5, Pix transp : 0
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_E1_1_3
;;case 11100001
;;mode : 11100001 => first pix:3
	;;Pos : 3, Pix opaque : 4, Pix transp : 1
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_E2_1_3
;;case 11100010
;;mode : 11100010 => first pix:3
	;;Pos : 3, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_E3_1_3
;;case 11100011
;;mode : 11100011 => first pix:3
	;;Pos : 3, Pix opaque : 3, Pix transp : 2
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_E4_1_3
;;case 11100100
;;mode : 11100100 => first pix:3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_E5_1_3
;;case 11100101
;;mode : 11100101 => first pix:3
	;;Pos : 3, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_E6_1_3
;;case 11100110
;;mode : 11100110 => first pix:3
	;;Pos : 3, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_E7_1_3
;;case 11100111
;;mode : 11100111 => first pix:3
	;;Pos : 3, Pix opaque : 2, Pix transp : 3
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_E8_1_3
;;case 11101000
;;mode : 11101000 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_E9_1_3
;;case 11101001
;;mode : 11101001 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_EA_1_3
;;case 11101010
;;mode : 11101010 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_EB_1_3
;;case 11101011
;;mode : 11101011 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_EC_1_3
;;case 11101100
;;mode : 11101100 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_ED_1_3
;;case 11101101
;;mode : 11101101 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_EE_1_3
;;case 11101110
;;mode : 11101110 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#4
		strb	R0,[R12],#4
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_EF_1_3
;;case 11101111
;;mode : 11101111 => first pix:3
	;;Pos : 3, Pix opaque : 1, Pix transp : 4
		add	R11,R11,#3
		add	R12,R12,#3
		ldrb	R0,[R11],#5
		strb	R0,[R12],#5
		NEXT_COL8
;;----------------------------------------

PPU8_F0_1_3
;;case 11110000
;;mode : 11110000 => first pix:4
	;;Pos : 4, Pix opaque : 4, Pix transp : 0
		add	R11,R11,#4
		add	R12,R12,#4
	ldmia	R11!,{R0}
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#2
		mov		R0,R0,lsr #16
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_F1_1_3
;;case 11110001
;;mode : 11110001 => first pix:4
	;;Pos : 4, Pix opaque : 3, Pix transp : 1
		add	R11,R11,#4
		add	R12,R12,#4
		ldmia	R11,{R0}
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strh	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_F2_1_3
;;case 11110010
;;mode : 11110010 => first pix:4
	;;Pos : 4, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#4
		add	R12,R12,#4
		ldrh	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_F3_1_3
;;case 11110011
;;mode : 11110011 => first pix:4
	;;Pos : 4, Pix opaque : 2, Pix transp : 2
		add	R11,R11,#4
		add	R12,R12,#4
		ldrh	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#1
		mov		R0,R0,lsr #8
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_F4_1_3
;;case 11110100
;;mode : 11110100 => first pix:4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#4
		add	R12,R12,#4
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_F5_1_3
;;case 11110101
;;mode : 11110101 => first pix:4
	;;Pos : 4, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#4
		add	R12,R12,#4
		ldrb	R0,[R11]
		add		R11,R11,#2
		strb	R0,[R12],#2
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_F6_1_3
;;case 11110110
;;mode : 11110110 => first pix:4
	;;Pos : 4, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#4
		add	R12,R12,#4
		ldrb	R0,[R11]
		add		R11,R11,#3
		strb	R0,[R12],#3
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_F7_1_3
;;case 11110111
;;mode : 11110111 => first pix:4
	;;Pos : 4, Pix opaque : 1, Pix transp : 3
		add	R11,R11,#4
		add	R12,R12,#4
		ldrb	R0,[R11]
		add		R11,R11,#4
		strb	R0,[R12],#4
		NEXT_COL8
;;----------------------------------------

PPU8_F8_1_3
;;case 11111000
;;mode : 11111000 => first pix:5
	;;Pos : 5, Pix opaque : 3, Pix transp : 0
		add	R11,R11,#5
		add	R12,R12,#5
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_F9_1_3
;;case 11111001
;;mode : 11111001 => first pix:5
	;;Pos : 5, Pix opaque : 2, Pix transp : 1
		add	R11,R11,#5
		add	R12,R12,#5
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_FA_1_3
;;case 11111010
;;mode : 11111010 => first pix:5
	;;Pos : 5, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#5
		add	R12,R12,#5
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_FB_1_3
;;case 11111011
;;mode : 11111011 => first pix:5
	;;Pos : 5, Pix opaque : 1, Pix transp : 2
		add	R11,R11,#5
		add	R12,R12,#5
		ldrb	R0,[R11],#3
		strb	R0,[R12],#3
		NEXT_COL8
;;----------------------------------------

PPU8_FC_1_3
;;case 11111100
;;mode : 11111100 => first pix:6
	;;Pos : 6, Pix opaque : 2, Pix transp : 0
		add	R11,R11,#6
		add	R12,R12,#6
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_FD_1_3
;;case 11111101
;;mode : 11111101 => first pix:6
	;;Pos : 6, Pix opaque : 1, Pix transp : 1
		add	R11,R11,#6
		add	R12,R12,#6
		ldrb	R0,[R11],#2
		strb	R0,[R12],#2
		NEXT_COL8
;;----------------------------------------

PPU8_FE_1_3
;;case 11111110
;;mode : 11111110 => first pix:7
	;;Pos : 7, Pix opaque : 1, Pix transp : 0
		add	R11,R11,#7
		add	R12,R12,#7
		ldrb	R0,[R11],#1
		strb	R0,[R12],#1
		NEXT_COL8
;;----------------------------------------

PPU8_FF_1_3
;;case 11111111
		add		R11,R11,#8
		add		R12,R12,#8
		NEXT_COL8
;;----------------------------------------
jumptable_ppu813
		DCD		PPU8_00_1_3
		DCD		PPU8_01_1_3
		DCD		PPU8_02_1_3
		DCD		PPU8_03_1_3
		DCD		PPU8_04_1_3
		DCD		PPU8_05_1_3
		DCD		PPU8_06_1_3
		DCD		PPU8_07_1_3
		DCD		PPU8_08_1_3
		DCD		PPU8_09_1_3
		DCD		PPU8_0A_1_3
		DCD		PPU8_0B_1_3
		DCD		PPU8_0C_1_3
		DCD		PPU8_0D_1_3
		DCD		PPU8_0E_1_3
		DCD		PPU8_0F_1_3
		DCD		PPU8_10_1_3
		DCD		PPU8_11_1_3
		DCD		PPU8_12_1_3
		DCD		PPU8_13_1_3
		DCD		PPU8_14_1_3
		DCD		PPU8_15_1_3
		DCD		PPU8_16_1_3
		DCD		PPU8_17_1_3
		DCD		PPU8_18_1_3
		DCD		PPU8_19_1_3
		DCD		PPU8_1A_1_3
		DCD		PPU8_1B_1_3
		DCD		PPU8_1C_1_3
		DCD		PPU8_1D_1_3
		DCD		PPU8_1E_1_3
		DCD		PPU8_1F_1_3
		DCD		PPU8_20_1_3
		DCD		PPU8_21_1_3
		DCD		PPU8_22_1_3
		DCD		PPU8_23_1_3
		DCD		PPU8_24_1_3
		DCD		PPU8_25_1_3
		DCD		PPU8_26_1_3
		DCD		PPU8_27_1_3
		DCD		PPU8_28_1_3
		DCD		PPU8_29_1_3
		DCD		PPU8_2A_1_3
		DCD		PPU8_2B_1_3
		DCD		PPU8_2C_1_3
		DCD		PPU8_2D_1_3
		DCD		PPU8_2E_1_3
		DCD		PPU8_2F_1_3
		DCD		PPU8_30_1_3
		DCD		PPU8_31_1_3
		DCD		PPU8_32_1_3
		DCD		PPU8_33_1_3
		DCD		PPU8_34_1_3
		DCD		PPU8_35_1_3
		DCD		PPU8_36_1_3
		DCD		PPU8_37_1_3
		DCD		PPU8_38_1_3
		DCD		PPU8_39_1_3
		DCD		PPU8_3A_1_3
		DCD		PPU8_3B_1_3
		DCD		PPU8_3C_1_3
		DCD		PPU8_3D_1_3
		DCD		PPU8_3E_1_3
		DCD		PPU8_3F_1_3
		DCD		PPU8_40_1_3
		DCD		PPU8_41_1_3
		DCD		PPU8_42_1_3
		DCD		PPU8_43_1_3
		DCD		PPU8_44_1_3
		DCD		PPU8_45_1_3
		DCD		PPU8_46_1_3
		DCD		PPU8_47_1_3
		DCD		PPU8_48_1_3
		DCD		PPU8_49_1_3
		DCD		PPU8_4A_1_3
		DCD		PPU8_4B_1_3
		DCD		PPU8_4C_1_3
		DCD		PPU8_4D_1_3
		DCD		PPU8_4E_1_3
		DCD		PPU8_4F_1_3
		DCD		PPU8_50_1_3
		DCD		PPU8_51_1_3
		DCD		PPU8_52_1_3
		DCD		PPU8_53_1_3
		DCD		PPU8_54_1_3
		DCD		PPU8_55_1_3
		DCD		PPU8_56_1_3
		DCD		PPU8_57_1_3
		DCD		PPU8_58_1_3
		DCD		PPU8_59_1_3
		DCD		PPU8_5A_1_3
		DCD		PPU8_5B_1_3
		DCD		PPU8_5C_1_3
		DCD		PPU8_5D_1_3
		DCD		PPU8_5E_1_3
		DCD		PPU8_5F_1_3
		DCD		PPU8_60_1_3
		DCD		PPU8_61_1_3
		DCD		PPU8_62_1_3
		DCD		PPU8_63_1_3
		DCD		PPU8_64_1_3
		DCD		PPU8_65_1_3
		DCD		PPU8_66_1_3
		DCD		PPU8_67_1_3
		DCD		PPU8_68_1_3
		DCD		PPU8_69_1_3
		DCD		PPU8_6A_1_3
		DCD		PPU8_6B_1_3
		DCD		PPU8_6C_1_3
		DCD		PPU8_6D_1_3
		DCD		PPU8_6E_1_3
		DCD		PPU8_6F_1_3
		DCD		PPU8_70_1_3
		DCD		PPU8_71_1_3
		DCD		PPU8_72_1_3
		DCD		PPU8_73_1_3
		DCD		PPU8_74_1_3
		DCD		PPU8_75_1_3
		DCD		PPU8_76_1_3
		DCD		PPU8_77_1_3
		DCD		PPU8_78_1_3
		DCD		PPU8_79_1_3
		DCD		PPU8_7A_1_3
		DCD		PPU8_7B_1_3
		DCD		PPU8_7C_1_3
		DCD		PPU8_7D_1_3
		DCD		PPU8_7E_1_3
		DCD		PPU8_7F_1_3
		DCD		PPU8_80_1_3
		DCD		PPU8_81_1_3
		DCD		PPU8_82_1_3
		DCD		PPU8_83_1_3
		DCD		PPU8_84_1_3
		DCD		PPU8_85_1_3
		DCD		PPU8_86_1_3
		DCD		PPU8_87_1_3
		DCD		PPU8_88_1_3
		DCD		PPU8_89_1_3
		DCD		PPU8_8A_1_3
		DCD		PPU8_8B_1_3
		DCD		PPU8_8C_1_3
		DCD		PPU8_8D_1_3
		DCD		PPU8_8E_1_3
		DCD		PPU8_8F_1_3
		DCD		PPU8_90_1_3
		DCD		PPU8_91_1_3
		DCD		PPU8_92_1_3
		DCD		PPU8_93_1_3
		DCD		PPU8_94_1_3
		DCD		PPU8_95_1_3
		DCD		PPU8_96_1_3
		DCD		PPU8_97_1_3
		DCD		PPU8_98_1_3
		DCD		PPU8_99_1_3
		DCD		PPU8_9A_1_3
		DCD		PPU8_9B_1_3
		DCD		PPU8_9C_1_3
		DCD		PPU8_9D_1_3
		DCD		PPU8_9E_1_3
		DCD		PPU8_9F_1_3
		DCD		PPU8_A0_1_3
		DCD		PPU8_A1_1_3
		DCD		PPU8_A2_1_3
		DCD		PPU8_A3_1_3
		DCD		PPU8_A4_1_3
		DCD		PPU8_A5_1_3
		DCD		PPU8_A6_1_3
		DCD		PPU8_A7_1_3
		DCD		PPU8_A8_1_3
		DCD		PPU8_A9_1_3
		DCD		PPU8_AA_1_3
		DCD		PPU8_AB_1_3
		DCD		PPU8_AC_1_3
		DCD		PPU8_AD_1_3
		DCD		PPU8_AE_1_3
		DCD		PPU8_AF_1_3
		DCD		PPU8_B0_1_3
		DCD		PPU8_B1_1_3
		DCD		PPU8_B2_1_3
		DCD		PPU8_B3_1_3
		DCD		PPU8_B4_1_3
		DCD		PPU8_B5_1_3
		DCD		PPU8_B6_1_3
		DCD		PPU8_B7_1_3
		DCD		PPU8_B8_1_3
		DCD		PPU8_B9_1_3
		DCD		PPU8_BA_1_3
		DCD		PPU8_BB_1_3
		DCD		PPU8_BC_1_3
		DCD		PPU8_BD_1_3
		DCD		PPU8_BE_1_3
		DCD		PPU8_BF_1_3
		DCD		PPU8_C0_1_3
		DCD		PPU8_C1_1_3
		DCD		PPU8_C2_1_3
		DCD		PPU8_C3_1_3
		DCD		PPU8_C4_1_3
		DCD		PPU8_C5_1_3
		DCD		PPU8_C6_1_3
		DCD		PPU8_C7_1_3
		DCD		PPU8_C8_1_3
		DCD		PPU8_C9_1_3
		DCD		PPU8_CA_1_3
		DCD		PPU8_CB_1_3
		DCD		PPU8_CC_1_3
		DCD		PPU8_CD_1_3
		DCD		PPU8_CE_1_3
		DCD		PPU8_CF_1_3
		DCD		PPU8_D0_1_3
		DCD		PPU8_D1_1_3
		DCD		PPU8_D2_1_3
		DCD		PPU8_D3_1_3
		DCD		PPU8_D4_1_3
		DCD		PPU8_D5_1_3
		DCD		PPU8_D6_1_3
		DCD		PPU8_D7_1_3
		DCD		PPU8_D8_1_3
		DCD		PPU8_D9_1_3
		DCD		PPU8_DA_1_3
		DCD		PPU8_DB_1_3
		DCD		PPU8_DC_1_3
		DCD		PPU8_DD_1_3
		DCD		PPU8_DE_1_3
		DCD		PPU8_DF_1_3
		DCD		PPU8_E0_1_3
		DCD		PPU8_E1_1_3
		DCD		PPU8_E2_1_3
		DCD		PPU8_E3_1_3
		DCD		PPU8_E4_1_3
		DCD		PPU8_E5_1_3
		DCD		PPU8_E6_1_3
		DCD		PPU8_E7_1_3
		DCD		PPU8_E8_1_3
		DCD		PPU8_E9_1_3
		DCD		PPU8_EA_1_3
		DCD		PPU8_EB_1_3
		DCD		PPU8_EC_1_3
		DCD		PPU8_ED_1_3
		DCD		PPU8_EE_1_3
		DCD		PPU8_EF_1_3
		DCD		PPU8_F0_1_3
		DCD		PPU8_F1_1_3
		DCD		PPU8_F2_1_3
		DCD		PPU8_F3_1_3
		DCD		PPU8_F4_1_3
		DCD		PPU8_F5_1_3
		DCD		PPU8_F6_1_3
		DCD		PPU8_F7_1_3
		DCD		PPU8_F8_1_3
		DCD		PPU8_F9_1_3
		DCD		PPU8_FA_1_3
		DCD		PPU8_FB_1_3
		DCD		PPU8_FC_1_3
		DCD		PPU8_FD_1_3
		DCD		PPU8_FE_1_3
		DCD		PPU8_FF_1_3

		END
