#include "snes9x.h"
#include "apu.h"
#include "ppu.h"
#include "dsp1.h"
#include "cpuexec.h"
#include "sa1.h"
#include "cpuops.h"

#include "os9x_asm_cpu.h"

#ifdef __ZODIAC__
#include "TapWave.h"
#endif

//#define __debug_c_irq__
//#define __debug_c_nmi__
//#define __debug_c_hblank__
//#define __debug_c_io__

START_EXTERN_C

#ifdef __ZODIAC__
#include "LJZmenu.h"
#endif

void asm_S9xMainLoop(void)
{
	S9xPackStatus();
	asmMainLoop(&CPU);
	S9xUnpackStatus();	
	
//	menu_confirm("okokk");
}

uint8 asm_S9xGetByte(uint32 Address)
{
#ifdef __debug_c_io__
	menu_confirm("gb");
#endif	
	return S9xGetByte(Address);	
}

uint16 asm_S9xGetWord(uint32 Address)
{
#ifdef __debug_c_io__
	menu_confirm("gw");
#endif	
	return S9xGetWord(Address);	
}


void asm_S9xSetByte(uint32 Address,uint8 value)
{	
#ifdef __debug_c_io__
	menu_confirm("sb");		
#endif
	S9xSetByte(value,Address);	
}

void asm_S9xSetWord(uint32 Address,uint16 value)
{	
#ifdef __debug_c_io__
	menu_confirm("sw");
#endif	
	S9xSetWord(value,Address);
}



void asm_S9xSetPCBase(uint32 Address)
{
#ifdef __debug_c_setpc__
	menu_confirm("spcb");
#endif	
	S9xSetPCBase(Address);	
}


void asm_S9xOpcode_NMI(void)
{	
#ifdef __debug_c_nmi__
	menu_confirm("nmi");
#endif	
	S9xUnpackStatus();
	S9xOpcode_NMI();
	S9xPackStatus();		
}

void asm_S9xOpcode_IRQ(void)
{	
#ifdef __debug_c_irq__
	menu_confirm("irq");
#endif	
	S9xUnpackStatus();
	S9xOpcode_IRQ();	
	S9xPackStatus();
}

void asm_S9xDoHBlankProcessing(void)
{	
#ifdef __debug_c_hblank__
	menu_confirm("hblank");
#endif	
	S9xUnpackStatus();
	S9xDoHBlankProcessing();	
	S9xPackStatus();	
}

void asm_APU_EXECUTE(void)
{
#ifdef __debug_c_apuex__	
	menu_confirm("apuexec");
#endif	
	while (APU.Cycles <= CPU.Cycles)
	{
		APU_EXECUTE1();
	}
}

void asm_APU_EXECUTE2(void)
{
	ICPU.CPUExecuting = FALSE;
	do
	{
	    APU_EXECUTE1();
	} while (APU.Cycles < CPU.NextEvent);
	ICPU.CPUExecuting = TRUE;
}

END_EXTERN_C
