#include "snes9x.h"

#include "special_file.h"
extern "C"
{
#include "gpmodplay.h"
}

MODPlay modplayer;
char *mod_data;
int mod_play_running=0;

void Mod_StopMod(void)
{
#ifdef _Mod_Support_
	if (!mod_play_running) return;
	MODPlay_Stop ( &modplayer );
    MODPlay_Unload ( &modplayer );
	free(mod_data);
	mod_play_running=0;
#endif	
}
int Mod_LoadMod(int num_mod)
{
#ifdef _Mod_Support_	
	switch (num_mod)
	{
		case 0:if (SF_LoadData(2,&mod_data)) return 1;break;
		case 1:if (SF_LoadData(3,&mod_data)) return 1;break;		
		case 2:if (SF_LoadData(9,&mod_data)) return 1;break;		
	}
	/* Init et lancement du player de mod*/
	MODPlay_Init(&modplayer);	
	MODPlay_SetStereo ( &modplayer, TRUE );
	MODPlay_SetPlayFreq ( &modplayer, 22050 );
	modplayer.soundBuf.samples=1024;
	modplayer.soundBuf.pollfreq=4*22050/modplayer.soundBuf.samples;
		
	if (MODPlay_SetMOD(&modplayer,(u8*)mod_data))
	{
			return 1;
	}
	mod_play_running=1;	
#endif	
}	

void Mod_SetVolume(int vol)
{
#ifdef _Mod_Support_
	if (!mod_play_running) return;
	modplayer.mod.musicvolume=vol;
#endif	
}

void Mod_Start(void)
{
#ifdef _Mod_Support_
	if (mod_play_running) MODPlay_Start ( &modplayer );	
#endif	
}

void Mod_Pause(int p)
{
#ifdef _Mod_Support_
	MODPlay_Pause ( &modplayer,p );
#endif	
}