/*
Copyright (c) 2002,2003, Christian Nowak <chnowak@web.de>
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are 
permitted provided that the following conditions are met:

- Redistributions of source code must retain the above copyright notice, this list of 
  conditions and the following disclaimer. 
- Redistributions in binary form must reproduce the above copyright notice, this list 
  of conditions and the following disclaimer in the documentation and/or other 
  materials provided with the distribution. 
- The names of the contributors may not be used to endorse or promote products derived 
  from this software without specific prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL 
THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF 
THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef __MODPLAYPP_H__
#define __MODPLAYPP_H__

#include "gpmodplay.h"

class CMODPlay
  {
    private:
      MODPlay * modplay;
      u8 * getNoteData(int pattern, int row, int chan);
      int numSFXChannels;
    public:
      CMODPlay(void);
      ~CMODPlay(void);
      int triggerNote ( int, u8, u16, u8 );
      int allocSFXChannels ( int );
      int getNumSFXChannels (void);
      int load(char * fname);
      void unload(void);
      int start(void);
      int stop(void);
      int setMOD(u8 * mem); /* Plays the MOD from the memory */
      int pause(BOOL p);
      BOOL isPaused(void);
      BOOL isPlaying(void);
      void setStereo ( BOOL );
      BOOL isStereo(void);
      int setPlayFreq ( int );
      int getPlayFreq(void);
      MOD * getMODStruct(void);
      MODPlay * getMODPlayStruct(void);
      
      int getSpeed(void);
      int getBPM(void);
      int getPatternLine(void);
      int getPatternNum(void);
      int getSongPos(void);
      
      int getNoteFreq ( int pattern, int row, int chan );
      int getEffect ( int pattern, int row, int chan );
      int getEffectOp ( int pattern, int row, int chan );
      int getInstrument ( int pattern, int row, int chan );
      
      int getNoteFreq ( int chan );
      int getEffect ( int chan );
      int getEffectOp ( int chan );
      int getInstrument ( int chan );
  };

#endif

