/*
Copyright (c) 2002,2003, Christian Nowak <chnowak@web.de>
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are 
permitted provided that the following conditions are met:

- Redistributions of source code must retain the above copyright notice, this list of 
  conditions and the following disclaimer. 
- Redistributions in binary form must reproduce the above copyright notice, this list 
  of conditions and the following disclaimer in the documentation and/or other 
  materials provided with the distribution. 
- The names of the contributors may not be used to endorse or promote products derived 
  from this software without specific prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL 
THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF 
THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef __GPMODPLAY_H__
#define __GPMODPLAY_H__


#define _Mod_Support_

#ifdef __cplusplus
extern "C" {
#endif

#include "gpmm.h"
#include "modplay.h"

typedef struct MODSOUNDBBUF
  {
    PCM_SR freq;              /* Taken from gpmm.h */
    PCM_BIT format;           /* Taken from gpmm.h */
    unsigned int samples;     /* Buffer length (in samples) */
    void * userdata;          /* Userdata which gets passed to the callback function */
    void (*callback)(         /* Callback function (just like in SDL) */
          void * userdata,    /* GPSOUNDBUF.userdata */
          u8 * stream,        /* Pointer to the buffer which needs to be refilled */
          int len);           /* Length of the buffer in bytes */
    unsigned int pollfreq;    /* Frequency of the timer interrupt which polls the playing position
                               * recommended value: 2*(playingfreq in Hz/GPSOUNDBUF.samples) */
    unsigned int samplesize;  /* Size of one sample (8bit mono->1, 16bit stereo->4) - don't touch this */
  } MODSOUNDBUF;

typedef struct MODPlay
  {
    MOD mod;
    
    BOOL playing;
    int playfreq;
    BOOL bits;
    BOOL stereo;
    BOOL paused;
    int numSFXChannels;
    MODSOUNDBUF soundBuf;
    BOOL manual_polling;
  } MODPlay;

void MODPlay_Init ( MODPlay * );
int  MODPlay_AllocSFXChannels ( MODPlay*, int );
int  MODPlay_Load ( MODPlay*, char * fname );
void MODPlay_Unload ( MODPlay* );
int  MODPlay_Start ( MODPlay* );
int  MODPlay_Stop ( MODPlay* );
int  MODPlay_SetMOD ( MODPlay*, u8* );
int  MODPlay_Pause ( MODPlay*, BOOL );
void MODPlay_SetStereo ( MODPlay*, BOOL );
int  MODPlay_SetPlayFreq ( MODPlay*, int );
int  MODPlay_TriggerNote ( MODPlay*, int channel, u8 instnum, u16 freq, u8 vol );
void MODPlay_PollSound ( MODPlay* );

#ifdef __cplusplus
  }
#endif

#endif

