/*
 * Snes9x - Portable Super Nintendo Entertainment System (TM) emulator.
 *
 * (c) Copyright 1996 - 2000 Gary Henderson (gary@daniver.demon.co.uk) and
 *                           Jerremy Koot (jkoot@snes9x.com)
 *
 * Super FX C emulator code 
 * (c) Copyright 1997 - 1999 Ivar (Ivar@snes9x.com) and
 *                           Gary Henderson.
 * Super FX assembler emulator code (c) Copyright 1998 zsKnight and _Demo_.
 *
 * DSP1 emulator code (c) Copyright 1998 Ivar, _Demo_ and Gary Henderson.
 * DOS port code contains the works of other authors. See headers in
 * individual files.
 *
 * Snes9x homepage: www.snes9x.com
 *
 * Permission to use, copy, modify and distribute Snes9x in both binary and
 * source form, for non-commercial purposes, is hereby granted without fee,
 * providing that this license information and copyright notice appear with
 * all copies and any derived work.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event shall the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Snes9x is freeware for PERSONAL USE only. Commercial users should
 * seek permission of the copyright holders first. Commercial use includes
 * charging money for Snes9x or software derived from Snes9x.
 *
 * The copyright holders request that bug fixes and improvements to the code
 * should be forwarded to them so everyone can benefit from the modifications
 * in future versions.
 *
 * Super NES and Super Nintendo Entertainment System are trademarks of
 * Nintendo Co., Limited and its subsidiary companies.
 */
 
 

//#define TESTING
#define TESTING_ROMPATH "gp:\\gpmm\\snes\\rom1.zip"
//#define __SAVE_ZSNES_FILE__ "gp:\\gpmm\\snes\\rom1.zst"
//mariok.zip
//mmanx2.zip
//mmanx3.zip
//romtest.zip
//zelda_j.zip
//scastle4.zip

#define _MAX_SKIP_FRAME_ 5

//#define _BPP8MODE_
#define __LONG_PRESS_VAL__ 10   //(between 0 & 31)

/***********************************************/
/* SNES9X headers */
#include "snes9x.h"
#include "memmap.h"
//#include "debug.h"
#include "cpuexec.h"
#include "ppu.h"
#include "snapshot.h"
#include "apu.h"
#include "display.h"
#include "gfx.h"
#include "soundux.h"
#include "cheats.h"
#include "font.h"

#include "gammatab.h"
/***********************************************/
#include "os9xgp_openspc.h"


#include "gui_fx.h"
#include "menu.h"
/************************/
//profiling stuff
#ifdef PROFILING
#define MAX_PROF_FUNC 16
uint32 gp32_prof_call[MAX_PROF_FUNC];
uint32 gp32_prof_ctime[MAX_PROF_FUNC];
uint32 gp32_prof_time[MAX_PROF_FUNC];
char *gp32_prof_name[MAX_PROF_FUNC]={
"S9xMainLoop", //0
"S9xOpcodes", //1
"S9xSyncSpeed", //2
"", //3
"", //4
"", //5
"", //6
"", //7
"S9xUpdateScreen", //8
"  updatescr setup", //9
"  tile cache reset", //10
"  buffers reset", //11
"  layers&objs drawing", //12
"", //13
"", //14
"XlatSNESBuffer" //15
};
#endif
/*****************************/
/* y3DEngine */
#include "3dngine.h"

extern int y3DE_rendermode,y3DE_movemode;
extern int y3DE_ax,y3DE_ay,y3DE_az;
extern int32 y3DE_posX,y3DE_posY,y3DE_posZ;

int framecpto=0;

/* File browser */
#include "gpfilereq.h"
/* ID checker */
#include "checkID.h"
/* Compression lib */
#include "zlib.h"
/* Mod player*/
#include "mod_play.h"

#include "gp32_func.h"

#include "file_dialog.h"
/***********************************************/

/* Special stuff for "merged at the end" files */
#include "special_file.h"
/*****************/
/* Some C stuff*/
extern "C"
{
#include "gfxlib.h"
#include "bioslib.h"
#include "gp32.h"
}
/****************/

#ifdef TITLE
#undef TITLE
#define TITLE "OpenSNES9XGP"
#endif

/****************/

/* timing stuff*/
uint32 gp32_frame;
volatile int gp32_timertps_running;
volatile int gp32_timersnd_running;
volatile uint32 gp32_frametimer;
uint32 gp32_framerendered;
uint32 gp32_framecomputed;
uint32 gp32_frameBeginTime;

/***************/
//debug
/*************/
extern void init_logop(void);
extern void close_logop(void);
/************************/
/* emu options */

uint32 gp32_gammavalue;

extern unsigned char gammatab[10][32];

int32 gp32_fastmode;
int32 gp32_fskipvalue;
int gp32_showfps;
int32 gp32_ShowSub;
int32 gp32_PalBrightness;
int gp32_apuenabled;

int gp32_syncmode;
int gp32_fastsprite;

int gp32_BG_Forced;
int gp32_DisableIRQ;
int gp32_DisableHDMA;
int gp32_CyclesPercentage;
/************************/
int gp32_tmp8bitmode;

int gp32_emupaused;

/* not used yet*/
/*8bit mode*/

/************************/
/*sound stuff*/
int gp32_soundenabled;

/*volatile uint32 gp32_sndThSample_Int,gp32_sndThSample_Dec;
volatile uint32 gp32_sndThSample_Int_Incr,gp32_sndThSample_Dec_Incr;
volatile uint32 gp32_sndRealSample;*/

uint8 *gp32_sndBuffer;
uint8 *gp32_sndBufferpos,*gp32_sndBufferend;
uint32 gp32_sndSz;
int gp32_sndFrequency;
char gp32_sndStereo;
char gp32_snd16bits;
int gp32_sndBuffsize;
volatile int gp32_sndPlaychan;
int *gp32_sndPlaypos;
#define __gp32_NBBUFFERS 8
/************************/
/* video */

GP_PALETTEENTRY	gp32_snespalentry[256];


/* inputs */
#define GP_A 0
#define GP_B 1
#define GP_L 2
#define GP_R 3
#define GP_START 4
#define GP_SELECT 5
uint32 gp32_keyconfig[3][6];
uint32 gp32_activeconf,gp32_activeconf_showdelay;
int lastkey[32];
volatile char gp32_exitemu;

/* gp32 func def*/
int gp32_pause(void);

int gp32_ShowGUI(void);
int gp32_ShowVideo(char *bg_img);
int gp32_ShowInput(char *bg_img);
int gp32_ShowHack(char *bg_img);
int gp32_ShowSound(char *bg_img);
int gp32_ShowState(char *bg_img);
int gp32_ShowCredits(char *bg);

int gp32_checkstate(int slot,char *mini_img);

void gp32_GpTextOut(uint8 *buffer,int X,int Y,char *A,int col,int bold);
/* some usefull macros*/
#define Msg(X,Y,A,col) \
  {gp32_GpTextOut(currentbuffer,X,Y,A,col,0);}
#define MsgBold(X,Y,A,col) \
  {gp32_GpTextOut(currentbuffer,X,Y,A,col,1);}
#define MsgBoldBig(X,Y,A,col) \
  {gp32_GpTextOutBig(currentbuffer,X,Y,A,col,1);}
#define MsgAll(X,Y,A,col) \
  {gp32_GpTextOut(listbuffer[0],X,Y,A,col,0); \
  gp32_GpTextOut(listbuffer[1],X,Y,A,col,0); \
  if (listbuffer[2]) gp32_GpTextOut(listbuffer[2],X,Y,A,col,0); \
}

#define Cls(Col) {\
  gm_memset(currentbuffer,Col,320*240);}
  
#define ClsAll(Col) {\
  gm_memset(listbuffer[0],Col,320*240);\
  gm_memset(listbuffer[1],Col,320*240);\
  if (listbuffer[2]) gm_memset(listbuffer[2],Col,320*240);}

#define Cls16(Col) {\
  gm_memset(currentbuffer,Col,320*240*2);}
  
#define ClsAll16(Col) {\
  gm_memset(listbuffer[0],Col,320*240*2);\
  gm_memset(listbuffer[1],Col,320*240*2);\
  if (listbuffer[2]) gm_memset(listbuffer[2],Col,320*240*2);}  
  
extern "C" void XlatSNESBuffer8(uint8 *src,uint8 *dst,int linestodraw,int src_pitch);
extern "C" void XlatSNESBuffer16(uint8 *src,uint8 *dst,int linestodraw,int src_pitch);
extern "C" void XlatVBuffer(uint8 *src,uint8 *dst);
extern "C" void XlatVBuffer2(uint8 *src,uint8 *dst);
extern "C" uint32 asmgetID(void);


/****************/
char rom_filename[512];
char gp32_romsdir[512];
/****************/



const char *S9xGetFilename (const char *ex);

void S9xLoadSDD1Data ()
{
}

void gp32_timertps(void) 
{		
   if (gp32_timertps_running) return;
   gp32_timertps_running=1;
   gp32_frametimer++;
/*   gp32_sndThSample_Int+=gp32_sndThSample_Int_Incr;
   gp32_sndThSample_Dec+=gp32_sndThSample_Dec_Incr;
   if (gp32_sndThSample_Dec>=1024)
   {
	   gp32_sndThSample_Dec-=1024;
	   gp32_sndThSample_Int++;
   }      */
   gp32_timertps_running=0;
}

void gp32_timersnd(void)
{
   if (gp32_timersnd_running||(gp32_soundenabled!=1)||gp32_emupaused) return;
   gp32_timersnd_running=1;      
   //if (gp32_sndRealSample<gp32_sndThSample_Int)
   {   	   
	   unsigned int pp,pw,dist;
	   uint32 snd_posdiff;
	   	   
	   S9xMixSamples(gp32_sndBufferpos,gp32_sndBuffsize);
	   if (gp32_snd16bits) {char *p=(char*)gp32_sndBufferpos+1; for (int i=gp32_sndBuffsize;i;i--,p+=2) *p^=0x80;}
	   gp32_sndBufferpos+=gp32_sndBuffsize<<(gp32_snd16bits);
   	   if (gp32_sndBufferpos>=gp32_sndBufferend) 
	   {
	   		if (gp32_sndBufferpos>gp32_sndBufferend) 
	   		{
		   		snd_posdiff=gp32_sndBufferpos-gp32_sndBufferend;
		   		gm_memcpy(gp32_sndBuffer,gp32_sndBufferend,snd_posdiff);
		   		gp32_sndBufferpos=gp32_sndBuffer+snd_posdiff;
		   	}
		   	else gp32_sndBufferpos=gp32_sndBuffer;
	   }
//	   gp32_sndRealSample+=gp32_sndBuffsize;   	   
	   
	   
	   pp=((unsigned int)*gp32_sndPlaypos);
	   pw=((unsigned int)gp32_sndBufferpos);
	   if (pw>pp) dist=(pw-pp);
	   else dist=((pw+gp32_sndSz)-pp);	  
	   dist=dist>>(gp32_snd16bits);
	   	   	   
	   
   	   if ( dist<(gp32_sndBuffsize*__gp32_NBBUFFERS/2) ) 
   	   {
		   S9xMixSamples(gp32_sndBufferpos,gp32_sndBuffsize);
		   if (gp32_snd16bits) {char *p=(char*)gp32_sndBufferpos+1; for (int i=gp32_sndBuffsize;i;i--,p+=2) *p^=0x80;}
		   gp32_sndBufferpos+=gp32_sndBuffsize<<gp32_snd16bits;
	   	   if (gp32_sndBufferpos>=gp32_sndBufferend)
		   {
			    if (gp32_sndBufferpos>=gp32_sndBufferend)
			    {
			   		snd_posdiff=gp32_sndBufferpos-gp32_sndBufferend;
			   		gm_memcpy(gp32_sndBuffer,gp32_sndBufferend,snd_posdiff);
			   		gp32_sndBufferpos=gp32_sndBuffer+snd_posdiff;
			   	}
		   		else gp32_sndBufferpos=gp32_sndBuffer;
		   }
//		   gp32_sndRealSample+=gp32_sndBuffsize;   	   
	   }
   }
   gp32_timersnd_running=0;
}


int gp32_pause(void)
{
	int result,r;
  while (GpKeyGet())
  	{
	}			
  while (!GpKeyGet())
  	{
	}		
  while (r=GpKeyGet())
  	{
  		result=r;
	}		  
	return result;
}



void OutOfMemory()
{
  S9xMessage(0,0,"Out of memory ...\n");
  gp32_pause();
  GpAppExit();
}

/*
  Initialisation des variables systemes de la SNES
*/

const char *S9xBasename (const char *f)
{
  const char *p;
  if ((p = strrchr (f, '/')) != NULL || (p = strrchr (f, '\\')) != NULL)
    return (p + 1);
  return (f);
}

void S9xExtraUsage (){}
void S9xGraphicsMode (){}
void S9xTextMode (){}

bool8 S9xInitUpdate ()
{
  if (gp32_8bitmode) GFX.Screen = vrambuffer+32*240-(Settings.PAL?0:8);
  else GFX.Screen = vrambuffer+32*240*2-(Settings.PAL?0:8*2);
  return(TRUE);
}

bool8 S9xDeinitUpdate (int Width, int Height, bool8 sixteen_bit)
{
  int i,j;  
  if (Width==256) 
	{
		if (Height<=240)
		{		 
#ifdef PROFILING	 
PROF_START(15);
#endif
		  currentbuffer = vrambuffer;		  
		  vrambuffer = swapBuffer(&lcd,gp32_syncmode/*0/*3*/);
		  gp32_framerendered++;		  
#ifdef PROFILING
PROF_END(15);
#endif		  
 
 
#ifdef PROFILING
PROF_START(11);
#endif		  
		  if (!gp32_fastsprite) 
		  {
		  	gm_memset(GFX.ZBuffer,0xFF,256*240);
		  }
		  
#ifdef PROFILING
PROF_END(11);
#endif		   

/*	char str[256];
	framecpto++;
	sprintf(str,"\n\nfr : %d\n%d %d %d %d %d\n%d %d\n",
		framecpto,
		SoundData.channels[0].state,
		SoundData.channels[0].hertz,
		SoundData.channels[0].frequency,
		SoundData.channels[0].count,
		SoundData.channels[0].envx,
		SoundData.channels[0].left_vol_level,
		SoundData.channels[0].right_vol_level
		);
			if (SoundData.channels[0].left_vol_level||SoundData.channels[0].right_vol_level)
		{
		S9xMessage(0,0,str);
		gp32_pause();
		}
*/
		

		  return(TRUE);
		}	      
	}    	
  S9xMessage(0,0,"Video mode not handled now");
  gp32_pause();
  return(TRUE);
}

void S9xDeinitDisplay ()
{
  free(GFX.ZBuffer);
  free(GFX.SubZBuffer);
  free(GFX.SubScreen);
  S9xGraphicsDeinit();
}

void S9xInitDisplay ()
{
  GFX.Screen = vrambuffer+32*240*(gp32_8bitmode?1:2);
  GFX.Pitch = GFX.RealPitch = 240*(gp32_8bitmode?1:2);
  GFX.SubScreen = (uint8 *)malloc(256*240*2);    
  GFX.ZBuffer = (uint8 *)malloc(256*240);  
  GFX.SubZBuffer = (uint8 *)malloc(256*240);
  GFX.Delta = (GFX.SubScreen - GFX.Screen) >> 1;
  GFX.PPL = GFX.Pitch >> 1;
  GFX.PPLx2 = GFX.Pitch;
  GFX.ZPitch = GFX.Pitch >> 1;  
}

void S9xMessage (int type, int number, const char *message)
{	
	if (type==0)
	{
	if (gp32_8bitmode) Cls(0)
	else Cls16(0)
	}
	MsgAll(0,number,(char*)message,0xFFFF);
}


/*void Snes_Sound_CallBack(void *udata, Uint8 *stream, int len)
{
  if ((len!=(buffsize<<(so.sixteen_bit+so.stereo)))&&(!badsoundbuff)) 
    {
      badsoundbuff=1;
      printf("Sound buffer has incorrect size, try the -buff n options!\n");
    }
  S9xMixSamples(stream,len>>Sound16bits);
}*/


bool8 S9xOpenSoundDevice(int mode, bool8 stereo, int buffer_size)
{   
  enum PCM_SR freq;
  enum PCM_BIT resSample;
  if (gp32_sndBuffer) free(gp32_sndBuffer);    
  
  gp32_sndBuffsize=500;//max 1024 //gp32_sndFrequency/(Settings.PAL?50:60)+1;
  gp32_sndBuffsize<<=gp32_sndStereo;
  
  
  //if (gp32_soundenabled!=1) return(gp32_soundenabled==2);  

  
  gp32_sndBuffer = (uint8*)malloc(gp32_sndBuffsize*(__gp32_NBBUFFERS<<gp32_snd16bits));
  gp32_sndBufferend=gp32_sndBuffer+ (gp32_sndBuffsize*(__gp32_NBBUFFERS<<gp32_snd16bits));
  gp32_sndSz=gp32_sndBuffsize*__gp32_NBBUFFERS<<(gp32_snd16bits);

  if (gp32_snd16bits) resSample=PCM_16BIT;
  else resSample= PCM_8BIT ;
  switch (gp32_sndFrequency/1000)
  {
  	case 11:if (gp32_sndStereo) freq=PCM_S11;
			   else freq=PCM_M11;
			   break;
	case 22:if (gp32_sndStereo) freq=PCM_S22;
			   else freq=PCM_M22;
			   break;
	case 44:if (gp32_sndStereo) freq=PCM_S44;
			   else freq=PCM_M44;
			   break;			   			   
  }			   
  GpPcmInit(freq,resSample);
  
/*  gp32_sndThSample_Int_Incr=gp32_sndFrequency/(Settings.PAL?50:60);
  gp32_sndThSample_Dec_Incr=(gp32_sndFrequency-gp32_sndThSample_Int_Incr*(Settings.PAL?50:60))*(Settings.PAL?50:60);	*/
  
  so.stereo = gp32_sndStereo;
  so.sixteen_bit = gp32_snd16bits;
  so.playback_rate = gp32_sndFrequency;
  so.buffer_size = gp32_sndBuffsize;
  if (so.sixteen_bit) so.buffer_size*=2;
  so.encoded = FALSE;
  return(TRUE);
}


uint32 S9xReadJoypad (int which1_0_to_4)
{
  uint32 val=0x80000000;  
  int i=GpKeyGet(); 
  if (which1_0_to_4==0)
  {
  	if (gp32_activeconf==2)
	{
		if (i&GPC_VK_LEFT) val|=SNES_LEFT_MASK;
		if (i&GPC_VK_RIGHT) val|=SNES_RIGHT_MASK;
		if (i&GPC_VK_DOWN) val|=SNES_DOWN_MASK;
		if (i&GPC_VK_UP) val|=SNES_UP_MASK;
		if (i&GPC_VK_START) val|=gp32_keyconfig[2][GP_START];
		if (i&GPC_VK_SELECT) val|=gp32_keyconfig[2][GP_SELECT];
		if (i&GPC_VK_FR) val|=gp32_keyconfig[2][GP_R];
		if (i&GPC_VK_FA) val|=gp32_keyconfig[2][GP_A];
		if (i&GPC_VK_FL) val|=gp32_keyconfig[2][GP_L];
		if (i&GPC_VK_FB) val|=gp32_keyconfig[2][GP_B];
	}
	else
	{
		if (i&GPC_VK_LEFT) val|=SNES_LEFT_MASK;
		if (i&GPC_VK_RIGHT) val|=SNES_RIGHT_MASK;
		if (i&GPC_VK_DOWN) val|=SNES_DOWN_MASK;
		if (i&GPC_VK_UP) val|=SNES_UP_MASK;
		if (i&GPC_VK_START) val|=gp32_keyconfig[gp32_activeconf][GP_START];
		if (i&GPC_VK_FR) val|=gp32_keyconfig[gp32_activeconf][GP_R];
		if (i&GPC_VK_FA) val|=gp32_keyconfig[gp32_activeconf][GP_A];
		if (i&GPC_VK_FL) val|=gp32_keyconfig[gp32_activeconf][GP_L];
		if (i&GPC_VK_FB) val|=gp32_keyconfig[gp32_activeconf][GP_B];
  	}
  }
  return(val);
}

bool8 S9xReadMousePosition (int which1_0_to_1, int &x, int &y, uint32 &buttons)
{ 
  x=0;
  y=0;
  buttons=0;
  //return(TRUE);
  return(FALSE);
}
bool8 S9xReadSuperScopePosition (int &x, int &y, uint32 &buttons)
{
  return(FALSE);
}

extern unsigned char gammatab[10][32];
void S9xSetPalette ()
{
	if (gp32_8bitmode)
	{			
		uint8 *cgamma=(uint8*)gammatab[gp32_gammavalue];
		unsigned long *pal=(unsigned long*)PALETTE;
		unsigned long val;
		if (gp32_PalBrightness)
		{
			IPPU.XB = mul_brightness [PPU.Brightness];
			for (int i = 0; i < 256; i++)
    	    {	
                val = ((uint32)(cgamma[  IPPU.XB[(PPU.CGDATA [i]      ) & 0x1f ]]))<<11;
                val |= ((uint32)(cgamma[ IPPU.XB[(PPU.CGDATA [i] >> 5 ) & 0x1f ]]))<<6;
                val |= ((uint32)(cgamma[ IPPU.XB[(PPU.CGDATA [i] >> 10) & 0x1f ]]))<<1;
                *pal++=val|1;				
	        }
		}
		else
		{
			for (int i = 0; i < 256; i++)
    	    {	
                val = ((uint32)(cgamma[ (PPU.CGDATA [i] & 0x1f)]))<<11;
                val |= ((uint32)(cgamma[ ((PPU.CGDATA [i] >> 5) & 0x1f) ]))<<6;
                val |= ((uint32)(cgamma[ ((PPU.CGDATA [i] >> 10) & 0x1f) ]))<<1;
                *pal++=val|1;				
	        }
		}
	}
}

void S9xSyncSpeed ()
{
   int haswait=0;   
      
   S9xProcessEvents(FALSE);      
         
   gp32_frame++;
   gp32_framecomputed++;	      
   if (Settings.SkipFrames== AUTO_FRAMERATE)
    {    
       while (gp32_frametimer<=gp32_frame)
	   {
    	 haswait=1;	     
		 __asm { nop; nop; nop; nop; nop;}
	
	   }
	   if (IPPU.SkippedFrames>_MAX_SKIP_FRAME_) 
	   {
	   	gp32_frame=gp32_frametimer+1;
	   	haswait=1;
	   }
       if (!haswait) 
    	{
		  IPPU.RenderThisFrame=FALSE;
		  IPPU.SkippedFrames++;
		}
	      else
		{
		  IPPU.RenderThisFrame = TRUE;
		  IPPU.SkippedFrames = 0;
	    }
    }
  else
    {
      if (++IPPU.FrameSkip > Settings.SkipFrames)
	{	
	  while (gp32_frametimer<=gp32_frame)
	   {
    	 haswait=1;
  	     __asm { nop; nop; nop; nop; nop;}
	   }
	  IPPU.RenderThisFrame=TRUE;
	  IPPU.FrameSkip=0;
	}
      else
	{
	  IPPU.RenderThisFrame=FALSE;
	}
    }
  
  if (gp32_GpTickCountGet()-gp32_frameBeginTime>=1000) //update fps info every second
  {  
  		if (gp32_showfps)
  		{	    
  			char msg_buffer[16];
	   		sprintf(msg_buffer,"%2d\n%3d",gp32_framerendered,gp32_framecomputed*100/(Settings.PAL?50:60));   		
	   		if (gp32_8bitmode)
   			{   	
	   			if (listbuffer[2]) 
	   			{
	   				for (int i=0+0;i<0+3*7+4;i++) 
			   		for (int j=200+0;j<200+8*2;j++)
   					{
  						listbuffer[0][((239-j)+i*240)]=0xFF;
		  				listbuffer[1][((239-j)+i*240)]=0xFF;
		  				listbuffer[2][((239-j)+i*240)]=0xFF;
					}
				}
				else
				{
					for (int i=0+0;i<0+3*7+4;i++) 
			   		for (int j=200+0;j<200+8*2;j++)
   					{
  						listbuffer[0][((239-j)+i*240)]=0xFF;
		  				listbuffer[1][((239-j)+i*240)]=0xFF;		  			
					}
				}
	   		}
   			else
	   		{
	   			if (listbuffer[2])
	   			{
	   				for (int i=0+0;i<0+3*7+4;i++) 
		   			for (int j=200+0;j<200+8*2+2;j++)
   					{
	  					listbuffer[0][((239-j)+i*240)<<1]=0xFF;
						listbuffer[0][(((239-j)+i*240)<<1) | 1]=0xFF;
						listbuffer[1][((239-j)+i*240)<<1]=0xFF;
						listbuffer[1][(((239-j)+i*240)<<1) | 1]=0xFF;
						listbuffer[2][((239-j)+i*240)<<1]=0xFF;
						listbuffer[2][(((239-j)+i*240)<<1) | 1]=0xFF;
					}
				}
				else
				{
					for (int i=0+0;i<0+3*7+4;i++) 
		   			for (int j=200+0;j<200+8*2+2;j++)
   					{
	  					listbuffer[0][((239-j)+i*240)<<1]=0xFF;
						listbuffer[0][(((239-j)+i*240)<<1) | 1]=0xFF;
						listbuffer[1][((239-j)+i*240)<<1]=0xFF;
						listbuffer[1][(((239-j)+i*240)<<1) | 1]=0xFF;
					}
				}
			}
   			MsgAll(0+2,200+1,msg_buffer,0x3131);
   		}
   
   		gp32_frameBeginTime=gp32_GpTickCountGet();
	   	gp32_framerendered=0;
	   	gp32_framecomputed=0;
	   	
	   	if (gp32_activeconf_showdelay)
	   	{
    	   	gp32_activeconf_showdelay--;
    	   	if (!gp32_activeconf_showdelay)
    	   	{
	    	   	if (gp32_8bitmode)
	    	   	{
	    	   		if (listbuffer[2])
		   			{
  						for (int i=0+0;i<0+1*6;i++) 
				   		for (int j=0;j<10;j++)
   						{
  							listbuffer[0][((239-j)+i*240)]=0;
							listbuffer[1][((239-j)+i*240)]=0;
							listbuffer[2][((239-j)+i*240)]=0;
						}
					}
					else
					{
						for (int i=0+0;i<0+1*6;i++) 
				   		for (int j=0;j<10;j++)
   						{
  							listbuffer[0][((239-j)+i*240)]=0;
							listbuffer[1][((239-j)+i*240)]=0;
						}
					}
				}
				else
				{
					if (listbuffer[2])
		   			{
						for (int i=0+0;i<0+1*6;i++) 
				   		for (int j=0;j<10;j++)
   						{
  							listbuffer[0][((239-j)+i*240)<<1]=0;
							listbuffer[0][(((239-j)+i*240)<<1) | 1]=0;
							listbuffer[1][((239-j)+i*240)<<1]=0;
							listbuffer[1][(((239-j)+i*240)<<1) | 1]=0;
							listbuffer[2][((239-j)+i*240)<<1]=0;
							listbuffer[2][(((239-j)+i*240)<<1) | 1]=0;
						}
					}
					else
					{
						for (int i=0+0;i<0+1*6;i++) 
				   		for (int j=0;j<10;j++)
   						{
  							listbuffer[0][((239-j)+i*240)<<1]=0;
							listbuffer[0][(((239-j)+i*240)<<1) | 1]=0;
							listbuffer[1][((239-j)+i*240)<<1]=0;
							listbuffer[1][(((239-j)+i*240)<<1) | 1]=0;
						}
					}
				}				
			}
  		}   
   }   
}

void S9xInitInputDevices()
{
}

void S9xSetTitle(char *title)
{
}

char *GetSnapName()
{  
  return(NULL);
}

void gp32_S9xSoundPause(int pause)
{
	if (gp32_soundenabled!=1) return;
	if (!pause)
	{
/*		gp32_sndThSample_Int=gp32_sndThSample_Dec=gp32_sndRealSample=0;				*/
		gp32_sndBufferpos=gp32_sndBuffer+ (gp32_sndBuffsize*(__gp32_NBBUFFERS<<gp32_snd16bits))/2;       		
		gm_memset(gp32_sndBuffer,0x80,gp32_sndBuffsize*(__gp32_NBBUFFERS<<gp32_snd16bits));
	    GpPcmPlay((unsigned short*)gp32_sndBuffer, gp32_sndBuffsize*(__gp32_NBBUFFERS<<gp32_snd16bits),1);
	    GpPcmLock((unsigned short*)gp32_sndBuffer,(int *)&gp32_sndPlaychan,(unsigned int *)&gp32_sndPlaypos);	    	    
	}
	else
	{		
		GpPcmStop();
		
	}
}

void Snes_Close_ROM()
{  
  gp32_S9xSoundPause(1);  	  
  GpTimerKill(0);  
  GpTimerKill(1);
  free(gp32_sndBuffer);
  
  if (Settings.APUEnabled) S9xSetSoundMute (TRUE);  
  Memory.SaveSRAM (S9xGetFilename (".srm"));
  //S9xSaveCheatFile (S9xGetFilename (".cht"));
  S9xDeinitDisplay ();  
  S9xDeinitAPU ();
  Memory.Deinit ();
}

void S9xReinitsound()
{
  if (S9xOpenSoundDevice)
  {
  	  S9xSetSoundMute(TRUE);  
	  S9xOpenSoundDevice(gp32_sndFrequency,gp32_sndStereo,gp32_sndBuffsize);
	  S9xSetSoundMute(FALSE);					
  }
}


void S9xProcessEvents (bool8 block)
{  
  char str[512];
  int i,tmp;
/* get key and update buffer*/
  for (i=0;i<31;i++) lastkey[i]=lastkey[i+1];
  GpKeyGetEx(&lastkey[31]);
    
#ifdef PROFILING  
  if ( ((lastkey[31]&GPC_VK_START)&&(lastkey[31]&GPC_VK_FL)&&(lastkey[31]&GPC_VK_FR))||((gp32_frame>60*20)) )
  {
/*save profiling info*/  
  	STREAM ProfFile;
  	char fname[256];
  	
  	sprintf(fname,"gp:\\gpetc\\prof%s.txt",(gp32_8bitmode?"8":"16"));
  	
	if ((ProfFile = OPEN_STREAM (fname, "wb")))
	{
		for (i=0;i<MAX_PROF_FUNC;i++)
		{
			if (strlen(gp32_prof_name[i]))
			{
				sprintf(str,"Func %s, called %d time %d\n",gp32_prof_name[i],gp32_prof_call[i],gp32_prof_time[i]);
				WRITE_STREAM(str,strlen(str),ProfFile);
			}
		}
/*		str[0]=0;
		WRITE_STREAM(str,1,ProfFile);*/
		CLOSE_STREAM(ProfFile);
	}    
	sprintf (str, "\"%s\" %s: %s.%s\n\nSaving SRAM if available...\n", Memory.ROMName, TITLE, VERSION_MAJOR, VERSION_MINOR);
	S9xMessage(0,0,str);
	Memory.SaveSRAM (S9xGetFilename (".srm"));  		
	Snes_Close_ROM();
    GpAppExit();
  }
#endif	
/* if 5 buttons mode*/
  if ((gp32_activeconf<2)&&(lastkey[30]&GPC_VK_SELECT)&&(!(lastkey[31]&GPC_VK_SELECT) ))
  	{
  		gp32_activeconf^=1;
  		gp32_activeconf_showdelay=2;
 	   	sprintf(str,"%d",gp32_activeconf);
 	   	if (gp32_8bitmode)
 	   	{
 	   		if (listbuffer[2])
 	   		{
		 	   	for (i=0+0;i<0+1*6;i++) 
		   		for (int j=0;j<10;j++)
   				{
  					listbuffer[0][((239-j)+i*240)]=0xFF;
					listbuffer[1][((239-j)+i*240)]=0xFF;
					listbuffer[2][((239-j)+i*240)]=0xFF;
				}
			}
			else
			{
		 	   	for (i=0+0;i<0+1*6;i++) 
		   		for (int j=0;j<10;j++)
   				{
  					listbuffer[0][((239-j)+i*240)]=0xFF;
					listbuffer[1][((239-j)+i*240)]=0xFF;
				}
			}
 	   	}
 	   	else
 	   	{
	 	   	if (listbuffer[2])
 	   		{
  				for (i=0+0;i<0+1*6;i++) 
		   		for (int j=0;j<10;j++)
   				{
	  				listbuffer[0][((239-j)+i*240)<<1]=0xFF;
					listbuffer[0][(((239-j)+i*240)<<1) | 1]=0xFF;
					listbuffer[1][((239-j)+i*240)<<1]=0xFF;
					listbuffer[1][(((239-j)+i*240)<<1) | 1]=0xFF;
					listbuffer[2][((239-j)+i*240)<<1]=0xFF;
					listbuffer[2][(((239-j)+i*240)<<1) | 1]=0xFF;
				}
			}
			else
			{
  				for (i=0+0;i<0+1*6;i++) 
		   		for (int j=0;j<10;j++)
   				{
	  				listbuffer[0][((239-j)+i*240)<<1]=0xFF;
					listbuffer[0][(((239-j)+i*240)<<1) | 1]=0xFF;
					listbuffer[1][((239-j)+i*240)<<1]=0xFF;
					listbuffer[1][(((239-j)+i*240)<<1) | 1]=0xFF;
				}
			}
		}
  		MsgAll(0,0,str,0x3131);
  	}
  	
  if (gp32_activeconf<2)
  {
	  tmp=0;        
	  for (i=__LONG_PRESS_VAL__;(i<31)&&(!tmp);i++) if (!(lastkey[i]&GPC_VK_SELECT)) tmp=1;
  }        
  if (tmp) tmp=!((lastkey[30]&GPC_VK_START)&&(lastkey[30]&GPC_VK_SELECT));
	  
/* if long press on select*/
  if (!tmp)
  {  			
/*  	char str[128];
  	sprintf(str,"\n\nYo : ram = %d",gm_availablesize());
  	S9xMessage(0,0,str);
  	gp32_pause();*/
  
	gp32_emupaused=1;	
	gp32_S9xSoundPause(1);
	Memory.TEMP_DeInit();	  		
	
	
	gp32_tmp8bitmode=gp32_8bitmode;
    gp32_8bitmode=0;        
    
	gp32_setupvideomode();    
   	int retcode=gp32_ShowGUI();
   	
   	gp32_8bitmode=gp32_tmp8bitmode;
   	Settings.SixteenBit = !gp32_8bitmode;
	gp32_setupvideomode();
	//reinit pal & 16bpp table
	S9xFixColourBrightness();	
	S9xSetPalette ();	
	//clear key buffer
   	gm_memset((char*)lastkey,0,32*4);
	//reinit tile cache stuff   	
   	Memory.TEMP_ReInit();   	
	//clear screen	  					
	gp32_clearAllScreens();
	//wait for button release
    while (GpKeyGet());
  	gp32_frametimer=gp32_frame;  	
  	
	//and reinit sound output if mod was playing
	S9xReinitsound();  	
  	
  	if (retcode==1) gp32_exitemu=1;
  	  	
  	gp32_emupaused=0;
  	gp32_S9xSoundPause(0);
  }  
}

void S9xGenerateSound ()
{
}

void S9xExit ()
{ 
  S9xSetSoundMute (TRUE);
  S9xDeinitDisplay ();
  Memory.SaveSRAM (S9xGetFilename (".srm"));
  //S9xSaveCheatFile (S9xGetFilename (".cht"));
  Memory.Deinit ();
  S9xDeinitAPU ();

  GpAppExit();
}

void _makepath (char *path, const char *, const char *dir,
		const char *fname, const char *ext)
{
  if (dir && *dir)
    {
      strcpy (path, dir);
      strcat (path, SLASH_STR);
    }
  else
    *path = 0;
  strcat (path, fname);
  if (ext && *ext)
    {
      strcat (path, ".");
      strcat (path, ext);
    }
}

void _splitpath (const char *path, char *drive, char *dir, char *fname,
		 char *ext)
{
  *drive = 0;

  char *slash = strrchr (path, '/');
  if (!slash)
    slash = strrchr (path, '\\');

  char *dot = strrchr (path, '.');

  if (dot && slash && dot < slash)
    dot = NULL;

  if (!slash)
    {
      strcpy (dir, "");
      strcpy (fname, path);
      if (dot)
        {
	  *(fname + (dot - path)) = 0;
	  strcpy (ext, dot + 1);
        }
      else
	strcpy (ext, "");
    }
  else
    {
      strcpy (dir, path);
      *(dir + (slash - path)) = 0;
      strcpy (fname, slash + 1);
      if (dot)
	{
	  *(fname + (dot - slash) - 1) = 0;
	  strcpy (ext, dot + 1);
	}
      else
	strcpy (ext, "");
    }
}

void S9xAutoSaveSRAM ()
{
  Memory.SaveSRAM (S9xGetFilename (".srm"));
}

const char *GetHomeDirectory ()
{
  return (getenv ("HOME"));
}

const char *S9xGetDirectory ()
{
  const char *snapshot;
    
  return (gp32_romsdir);
}

const char *S9xGetFilename (const char *ex)
{
  static char filename [PATH_MAX];
  char drive [_MAX_DRIVE];
  char dir [_MAX_DIR];
  char fname [_MAX_FNAME];
  char ext [_MAX_EXT];

  _splitpath (rom_filename/*Memory.ROMFilename*/, drive, dir, fname, ext);
  strcpy (filename, S9xGetDirectory ());
  strcat (filename, fname);
  strcat (filename, ex);

  return (filename);
}

const char *S9xGetROMDirectory ()
{
  return (gp32_romsdir);
}

const char *S9xChooseFilename (bool8 read_only,uint8 num)
{  
  return (NULL);
}

bool8 S9xOpenSnapshotFile (const char *fname, bool8 read_only, STREAM *file)
{
  char filename [PATH_MAX];
  char drive [_MAX_DRIVE];
  char dir [_MAX_DIR];
  char ext [_MAX_EXT];

  strcpy(filename,fname);
      
  if (read_only)
    {
      if (*file = OPEN_STREAM(filename,"rb")) return(TRUE);
    }
  else
    {
      if (*file = OPEN_STREAM(filename,"wb")) return(TRUE);
    }
  return (FALSE);
}

void S9xCloseSnapshotFile (STREAM file)
{
  CLOSE_STREAM (file);
}

extern int32 dsp_opcode[256];
void Snes9X_Start()
{  

  gm_memset(dsp_opcode,0,256*4);

#ifdef PROFILING

  gm_memset((uint32*)gp32_prof_call,0,MAX_PROF_FUNC*4);
  gm_memset((uint32*)gp32_prof_ctime,0,MAX_PROF_FUNC*4);
  gm_memset((uint32*)gp32_prof_time,0,MAX_PROF_FUNC*4);    
#endif

  gp32_frameBeginTime=gp32_GpTickCountGet();
  gp32_frame=0;
  gp32_frametimer=0;
  gp32_framerendered=0;
  
  gp32_timertps_running=0;
  gp32_timersnd_running=0;
  gp32_emupaused=1;
  
  GpTimerOptSet(0, (Settings.PAL?50:60)*gp32_timermul>>8, 0, gp32_timertps);
  GpTimerSet(0);  
  GpTimerOptSet(1, /*(Settings.PAL?50:60)*/ (gp32_sndFrequency/gp32_sndBuffsize)*gp32_timermul>>8, 0, gp32_timersnd);
  GpTimerSet(1);
          
  gp32_S9xSoundPause(0);  
    
  gp32_exitemu=0;
  gp32_emupaused=0;
  
#ifdef __SAVE_ZSNES_FILE__
	S9xUnfreezeGame(__SAVE_ZSNES_FILE__);
#endif
#ifdef TESTING
  init_logop();
#endif  
  
  while (!gp32_exitemu)
  {
      if (!Settings.Paused) S9xMainLoop (); 

      if ((Settings.Paused)&&(Settings.APUEnabled))
	  {
		  S9xSetSoundMute (TRUE);
	  }

      if ((!Settings.Paused)&&(Settings.APUEnabled))
	  {
	      S9xSetSoundMute (FALSE);
	  }    
  }
#ifdef TESTING  
  close_logop();
#endif    
}



typedef struct 
{
  int32  version_major,version_minor,
  cfgp32_clockspeed;
  char cfgp32_romsdir[256];
  char cfgp32_rom_filename[16];
} os9x_sysconfig;
#define OS9X_SYSCONFIG_SIZE 3*4+256+16

int os9xgp_sysparamLoad(const char *parmFile)
{
  int err_code;
  F_HANDLE f;
  os9x_sysconfig conf;  
  unsigned long filesize;
  unsigned long bread;

  GpFileGetSize(parmFile, &filesize);  
  if (filesize==OS9X_SYSCONFIG_SIZE)
  {
    if (GpFileOpen(parmFile, OPEN_R, &f)==SM_OK)
    {  	    	    	
    	if (GpFileRead(f, &conf,OS9X_SYSCONFIG_SIZE,&bread)==SM_OK)
    	{
    		int i,j;
    		if ((conf.version_major==VERSION_MAJOR)&&
    			(conf.version_minor==VERSION_MINOR))
    		{
    			gp32_clockfreq=conf.cfgp32_clockspeed;
	    		strcpy(gp32_romsdir,conf.cfgp32_romsdir);
				strcpy(rom_filename,conf.cfgp32_rom_filename);
			}
			else
			{
				char text[256];
				sprintf(text,"Bad version for sysconfig\nPlease delete file :\n-> '%s'\n\nPress a key",parmFile);
				S9xMessage(0,0,text);
				gp32_pause();
				if (gp32_8bitmode) {ClsAll(0);}
				else {ClsAll16(0);}
				GpFileClose(f);
				return 2;
			}
    	}
    	GpFileClose(f);
    }    
  }
  else return 1; //bad size
/*  {    	
  	GpFileRemove(parmFile);
  }        		*/
  return 0;
}

int os9xgp_sysparamSave(const char *parmFile)
{
  int err_code;
  F_HANDLE f;
  os9x_sysconfig conf;  
  unsigned long filesize;
  unsigned long bread;

  if (GpFileCreate(parmFile, ALWAYS_CREATE, &f)!=SM_OK)
  {
     return 1;
  }
  else
  {
   		int i,j;
  		conf.version_major=VERSION_MAJOR;
		conf.version_minor=VERSION_MINOR;
   		conf.cfgp32_clockspeed=gp32_clockfreq;
   		strcpy(conf.cfgp32_romsdir,gp32_romsdir);
		strcpy(conf.cfgp32_rom_filename,rom_filename);
		
		GpFileWrite(f, &conf,OS9X_SYSCONFIG_SIZE);
	    GpFileClose(f);
  }
  return 0;
}



typedef struct 
{
  int32  version_major,version_minor,
  /*gfx*/
  cfgp32_gammavalue,
  cfgp32_showfps,
  cfgp32_tmp8bitmode,
  cfgp32_syncmode,
  cfgp32_fskipvalue,
  cfgp32_fastmode,
  /*input*/ 
  cfgp32_keyconfig[3][6],
  cfgp32_activeconf,
  /*hack*/
  cfgp32_ShowSub,
  cfgp32_PalBrightness,
  cfgp32_fastsprite,
  cfgp32_BG_Forced,
  cfgp32_DisableIRQ,
  cfgp32_DisableHDMA,
  cfgp32_CyclesPercentage,  
  /*sound*/
  cfgp32_soundenabled,
  cfgp32_sampledecoder,
  cfgp32_sndFrequency,
  cfgp32_sndStereo,
  cfgp32_snd16bits,
  cfgp32_reserved [25]; //for extension
} os9x_config;
#define OS9X_CONFIG_SIZE 64*4

int os9xgp_paramLoad(const char *parmFile)
{
  int err_code;
  F_HANDLE f;
  os9x_config conf;  
  unsigned long filesize;
  unsigned long bread;

  GpFileGetSize(parmFile, &filesize);  
  if (filesize==OS9X_CONFIG_SIZE)
  {
    if (GpFileOpen(parmFile, OPEN_R, &f)==SM_OK)
    {  	    	    	
    	if (GpFileRead(f, &conf,OS9X_CONFIG_SIZE,&bread)==SM_OK)
    	{
    		int i,j;
    		if ((conf.version_major==VERSION_MAJOR)&&
    			(conf.version_minor==VERSION_MINOR))
    		{
    			/*gfx*/
    			gp32_gammavalue=conf.cfgp32_gammavalue;
	    		gp32_showfps=conf.cfgp32_showfps;
				gp32_tmp8bitmode=conf.cfgp32_tmp8bitmode;
	  			gp32_syncmode=conf.cfgp32_syncmode;
	  			gp32_fskipvalue=conf.cfgp32_fskipvalue;
	  			gp32_fastmode=conf.cfgp32_fastmode;
				/*input*/ 
			  	for (i=0;i<3;i++)
			  	for (j=0;j<6;j++) gp32_keyconfig[i][j]=conf.cfgp32_keyconfig[i][j];
	  			gp32_activeconf=conf.cfgp32_activeconf;
				/*hack*/
				gp32_ShowSub=conf.cfgp32_ShowSub;
				gp32_PalBrightness=conf.cfgp32_PalBrightness;
				gp32_fastsprite=conf.cfgp32_fastsprite;
				gp32_BG_Forced=conf.cfgp32_BG_Forced;
				gp32_DisableIRQ=conf.cfgp32_DisableIRQ;
				gp32_DisableHDMA=conf.cfgp32_DisableHDMA;
				gp32_CyclesPercentage=conf.cfgp32_CyclesPercentage;
				/*sound*/
				gp32_soundenabled=conf.cfgp32_soundenabled;

				gp32_sndFrequency=conf.cfgp32_sndFrequency;
				gp32_sndStereo=conf.cfgp32_sndStereo;
				gp32_snd16bits=conf.cfgp32_snd16bits;
			}
			else
			{
				char text[256];
				sprintf(text,"Bad version for sysconfig\nPlease delete file :\n-> '%s'\n\nPress a key",parmFile);
				S9xMessage(0,0,text);
				gp32_pause();
				if (gp32_8bitmode) {ClsAll(0);}
				else {ClsAll16(0);}
				GpFileClose(f);
				return 2;
			}
    	}
    	GpFileClose(f);
    }    
  }
  else return 1; //bad size
/*  {    	
  	GpFileRemove(parmFile);
  }        		*/
  return 0;
}

int os9xgp_paramSave(const char *parmFile)
{
  int err_code;
  F_HANDLE f;
  os9x_config conf;  
  unsigned long filesize;
  unsigned long bread;

  if (GpFileCreate(parmFile, ALWAYS_CREATE, &f)!=SM_OK)
  {
     return 1;
  }
  else
  {
   		int i,j;
  		conf.version_major=VERSION_MAJOR;
		conf.version_minor=VERSION_MINOR;
		/*gfx*/
    	conf.cfgp32_gammavalue=gp32_gammavalue;
    	conf.cfgp32_showfps=gp32_showfps;
		conf.cfgp32_tmp8bitmode=gp32_tmp8bitmode;
  		conf.cfgp32_syncmode=gp32_syncmode;
  		conf.cfgp32_fskipvalue=gp32_fskipvalue;
  		conf.cfgp32_fastmode=gp32_fastmode;
		/*input*/ 
		for (i=0;i<3;i++)
		for (j=0;j<6;j++) conf.cfgp32_keyconfig[i][j]=gp32_keyconfig[i][j];
  		conf.cfgp32_activeconf=gp32_activeconf;
		/*hack*/
		conf.cfgp32_PalBrightness=gp32_PalBrightness;
		conf.cfgp32_ShowSub=gp32_ShowSub;
		conf.cfgp32_fastsprite=gp32_fastsprite;
		conf.cfgp32_BG_Forced=gp32_BG_Forced;
		conf.cfgp32_DisableIRQ=gp32_DisableIRQ;
		conf.cfgp32_DisableHDMA=gp32_DisableHDMA;
		conf.cfgp32_CyclesPercentage=gp32_CyclesPercentage;
		/*sound*/
		conf.cfgp32_soundenabled=gp32_soundenabled;

		conf.cfgp32_sndFrequency=gp32_sndFrequency;
		conf.cfgp32_sndStereo=gp32_sndStereo;
		conf.cfgp32_snd16bits=gp32_snd16bits;
		
		GpFileWrite(f, &conf,OS9X_CONFIG_SIZE);
	    GpFileClose(f);
  }
  return 0;
}

void os9xgp_paramInit(void)
{  

  //try to load specific game ini file
  if (!os9xgp_paramLoad(S9xGetFilename(".cfg"))) return;
 
  //try to load generic emulator ini file
  if (!os9xgp_paramLoad("gp:\\gpetc\\os9xgp.cfg")) return;
  
  //default values
  /*gfx*/
  gp32_gammavalue=2;
  gp32_showfps=0;
  gp32_tmp8bitmode=1;
  gp32_syncmode=0;
  gp32_fskipvalue=2;
  gp32_fastmode=1;
  /*input*/ 
  gp32_keyconfig[0][GP_START]=SNES_START_MASK;  
  gp32_keyconfig[0][GP_A]=SNES_Y_MASK;
  gp32_keyconfig[0][GP_B]=SNES_B_MASK;
  gp32_keyconfig[0][GP_L]=SNES_X_MASK;
  gp32_keyconfig[0][GP_R]=SNES_A_MASK;
  gp32_keyconfig[1][GP_START]=SNES_SELECT_MASK;
  gp32_keyconfig[1][GP_A]=SNES_Y_MASK;
  gp32_keyconfig[1][GP_B]=SNES_B_MASK;
  gp32_keyconfig[1][GP_L]=SNES_TL_MASK;
  gp32_keyconfig[1][GP_R]=SNES_TR_MASK;  
  gp32_keyconfig[2][GP_SELECT]=SNES_SELECT_MASK;
  gp32_keyconfig[2][GP_START]=SNES_START_MASK;  
  gp32_keyconfig[2][GP_A]=SNES_Y_MASK;
  gp32_keyconfig[2][GP_B]=SNES_B_MASK;
  gp32_keyconfig[2][GP_L]=SNES_X_MASK;
  gp32_keyconfig[2][GP_R]=SNES_A_MASK;  
  gp32_activeconf=0;
  /*hack*/
  gp32_ShowSub=0;
  gp32_PalBrightness=0;
  gp32_fastsprite=0;
  gp32_BG_Forced=0;
  gp32_DisableIRQ=0;
  gp32_DisableHDMA=0;
  gp32_CyclesPercentage=100;
  /*sound*/
  gp32_soundenabled=0;

  gp32_sndFrequency=22050;
  gp32_sndStereo=0;
  gp32_snd16bits=1;       
  
}

int gpsnes9x_Init(void)
{
  int i;
  char str[256];
   
  gm_memset((char*)lastkey,0,32*4);
  gp32_activeconf_showdelay=0;  
  gp32_sndBuffer=NULL;  
  
  /*emu parameters ini*/
  os9xgp_paramInit();
 /*********************/ 
  
      
#if defined(PROFILING)||defined(TESTING)
  gp32_fskipvalue=2;
  gp32_soundenabled=0;
  gp32_syncmode=0;
  gp32_tmp8bitmode=0;
#endif
  
  gp32_apuenabled=gp32_soundenabled;  
      
    
  ZeroMemory (&Settings, sizeof (Settings));

  // ROM Options
    memset (&Settings, 0, sizeof (Settings));

    Settings.ForceLoROM = false;
    Settings.ForceInterleaved = false;

    Settings.ForceNotInterleaved = false;
    Settings.ForceInterleaved = false;
    Settings.ForceInterleaved2 = false;

    Settings.ForcePAL = false;
    Settings.ForceNTSC = false;
    Settings.ForceHeader = false;
    Settings.ForceNoHeader = false;

    // Sound options
    Settings.SoundSync = FALSE; //TRUE;
    Settings.InterpolatedSound = TRUE;
    Settings.SoundEnvelopeHeightReading = TRUE;
    Settings.DisableSoundEcho = FALSE;
    Settings.DisableMasterVolume = FALSE;
    Settings.Mute = FALSE;
    Settings.SoundSkipMethod = 0;
    Settings.SoundPlaybackRate = gp32_sndFrequency;
    Settings.SixteenBitSound = gp32_snd16bits;//TRUE;
    Settings.Stereo = gp32_sndStereo;//TRUE;
    Settings.AltSampleDecode = 1;//gp32_sampledecoder;//FALSE;
    Settings.ReverseStereo = FALSE;
//    Settings.SoundDriver = WIN_SNES9X_DIRECT_SOUND_DRIVER;
    Settings.SoundBufferSize = 0;
    Settings.SoundMixInterval = 0;
#ifdef __GP32_APUCACHE__    
    Settings.DisableSampleCaching = 0;
#else    
    Settings.DisableSampleCaching = TRUE;
#endif    
    
    Settings.FixFrequency = FALSE;

    // Tracing options
    Settings.TraceDMA = false;
    Settings.TraceHDMA = false;
    Settings.TraceVRAM = false;
    Settings.TraceUnknownRegisters = false;
    Settings.TraceDSP = false;

    // Joystick options
    Settings.SwapJoypads = false;
    Settings.JoystickEnabled = false;

    // ROM timing options (see also H_Max above)
    Settings.PAL = false;
    Settings.FrameTimePAL = 20;
    Settings.FrameTimeNTSC = 17;
    Settings.FrameTime = 17;

    // CPU options 
    Settings.CyclesPercentage = gp32_CyclesPercentage;
    Settings.Shutdown = true;
    Settings.ShutdownMaster = true;
    
    Settings.NextAPUEnabled = Settings.APUEnabled = gp32_apuenabled;
    Settings.DisableIRQ = gp32_DisableIRQ;
    Settings.Paused = false;
    Settings.H_Max = SNES_CYCLES_PER_SCANLINE;
    Settings.HBlankStart = (256 * Settings.H_Max) / SNES_HCOUNTER_MAX;
	Settings.SkipFrames = (gp32_fskipvalue==-1?AUTO_FRAMERATE:gp32_fskipvalue);


    // ROM image and peripheral options
    Settings.ForceSuperFX = false;
    Settings.ForceNoSuperFX = true;
    Settings.MultiPlayer5 = true;
    Settings.Mouse = true;
    Settings.SuperScope = true;
    Settings.MultiPlayer5Master = true;
    Settings.SuperScopeMaster = true;
    Settings.MouseMaster = true;
    Settings.SuperFX = false;
 
    // SNES graphics options
    Settings.BGLayering = false;
    Settings.DisableGraphicWindows = false;
    Settings.ForceTransparency = false;
    Settings.ForceNoTransparency = false;
    Settings.DisableHDMA = gp32_DisableHDMA;
    Settings.Mode7Interpolate = false;
    Settings.DisplayFrameRate = false;
    
    Settings.SixteenBit = !gp32_8bitmode;
    Settings.Transparency = 0;
    Settings.SupportHiRes = false;

    Settings.AutoSaveDelay = 0;
    Settings.ApplyCheats = true;

    Settings.TurboMode = false;
    Settings.TurboSkipFrames = 15;
    Settings.AutoMaxSkipFrames = 10;

    Settings.Port = 1996;




  Settings.ForcedPause = 0;
  Settings.StopEmulation = TRUE;
  Settings.Paused = FALSE;
     
  
  Settings.HBlankStart = (256 * Settings.H_Max) / SNES_HCOUNTER_MAX;
  
  //S9xMessage(0,0,"Init Memory");


  if (!Memory.Init ())
    OutOfMemory ();
    
    
  //S9xMessage(0,0,"Init Display");


  S9xInitDisplay ();
  

  //S9xMessage(0,0,"Init Graphics");


  if (!S9xGraphicsInit ())
    OutOfMemory ();
        
  //S9xMessage(0,0,"Init APU");

  if (!S9xInitAPU())
    OutOfMemory ();
        
  //S9xMessage(0,0,"Init Sound");


  S9xInitSound (Settings.SoundPlaybackRate, Settings.Stereo,Settings.SoundBufferSize);
  if (!Settings.APUEnabled)
	
    {
      printf("Sound off\n");
      S9xSetSoundMute (TRUE);
    }
  uint32 saved_flags = CPU.Flags;

  if (rom_filename)
    {      
    
      gp32_loadscr("Loading game...",2);
    
      if (!Memory.LoadROM (rom_filename))
	{
	  char dir [_MAX_DIR];
	  char drive [_MAX_DRIVE];
	  char name [_MAX_FNAME];
	  char ext [_MAX_EXT];
	  char fname [_MAX_PATH];

	  _splitpath (rom_filename, drive, dir, name, ext);
	  _makepath (fname, drive, dir, name, ext);

	  strcpy (fname, S9xGetROMDirectory ());
	  strcat (fname, name);
	  if (ext [0])
	    {
	      strcat (fname, ".");
	      strcat (fname, ext);
	    }
	  _splitpath (fname, drive, dir, name, ext);
	  _makepath (fname, drive, dir, name, ext);
	  if (!Memory.LoadROM (fname))
	    {
	      //printf ("Error opening: %s\n", rom_filename);
	      S9xMessage(0,0,"Could not load ROM\nPress a button to return to Browser");
	      gp32_pause();
	      Snes_Close_ROM();
	      return -1;
	    }
	}
//      Memory.LoadSRAM (S9xGetFilename (".srm"));
      //S9xLoadCheatFile (S9xGetFilename (".cht"));


    }
  else
    {
      S9xReset ();
      Settings.Paused |= 2;
    }
  CPU.Flags = saved_flags;
    
  if (!Settings.APUEnabled)
    S9xSetSoundMute (FALSE);



//  sprintf (str, "\"%s\" %s: %s\n\nFreq %dMhz Mem available : %d\nPress a button or wait...", Memory.ROMName, TITLE, VERSION,gp32_clockfreq,gm_availablesize());
//  gp32_GpTextOut(vrambuffer,0,130,str,0xFFFF,1);
//  gp32_pause();
  int curtime=gp32_time();
  i=0;
  while ((gp32_time()-curtime<1000)&&(!(i=GpKeyGet())));
  if (i) while (GpKeyGet());
  
  /*if (gp32_8bitmode) {ClsAll(0);}
  else {ClsAll16(0);}
  gp32_8bitmode=gp32_tmp8bitmode;    
  gp32_setupvideomode(); 
  gp32_clearAllScreens();  */
  
  gp32_8bitmode=gp32_tmp8bitmode;
  Settings.SixteenBit = !gp32_8bitmode;
  gp32_setupvideomode();
  //reinit pal & 16bpp table
  S9xFixColourBrightness();	
  S9xSetPalette ();	
  gp32_clearAllScreens();
  gp32_frametimer=gp32_frame;  	

  /*last init before start (needed to be done after S9xReset*/
  PPU.BG_Forced=gp32_BG_Forced;

  Snes9X_Start();

  Snes_Close_ROM();
  return(0);
}

void S9xParseArg (char **argv, int &index, int argc)
{	
}



void gp32_Printc(uint32 x,uint32 y,char c,uint8 *scr,int col,int bold)
{
  int indice=c-32; //index in the font.h array
  int indicex,indicey;  
  uint32 i,j;
  int colB = ((((col>>1)&31)>>1)<<1)|((((col>>6)&31)>>1)<<6)|((((col>>11)&31)>>1)<<11)|1;
  

  if (indice>=96) indice=0;
  if (indice<0) indice=0;
  indicey=(indice>>4)*9;
  indicex=(indice&0xf)<<3;
  
  if (gp32_8bitmode)
  {
	  if (bold)
	  {
		  for (i=0;i<8;i++)
		  for (j=0;j<9;j++) 
		    if (font[j+indicey][i+indicex]!=' ') 
				((uint8 *)(scr))[(239-(y+j)+((i+x)*240))]=col;
			else ((uint8 *)(scr))[(239-(y+j)+((i+x)*240))]=col;
	  }
	  else
	  {
		  for (i=0;i<8;i++)
		  for (j=0;j<9;j++) 
		    if (font[j+indicey][i+indicex]=='#') 			
				((uint8 *)(scr))[(239-(y+j)+((i+x)*240))]=col;			  
	   }
  }  
  else
  {
  	if (bold)
  	{
		  for (i=0;i<8;i++)
	      for (j=0;j<9;j++) 
	      {
		    if (font[j+indicey][i+indicex]=='#') 
			{
				((uint8 *)(scr))[(239-(y+j)+((i+x)*240))<<1]=col&0xFE;
				((uint8 *)(scr))[(239-(y+j)+((i+x)*240))<<1|1]=col>>8;
			}			
			if (font[j+indicey][i+indicex]=='.')
			{
				((uint8 *)(scr))[(239-(y+j)+((i+x)*240))<<1]=colB&0xFE;
				((uint8 *)(scr))[(239-(y+j)+((i+x)*240))<<1|1]=colB>>8;
			}
		  }
	}
	else
	{
		  for (i=0;i<8;i++)
	      for (j=0;j<9;j++) 
		    if (font[j+indicey][i+indicex]=='#') 
			{
				((uint8 *)(scr))[(239-(y+j)+((i+x)*240))<<1]=col&0xFE;
				((uint8 *)(scr))[(239-(y+j)+((i+x)*240))<<1|1]=col>>8;
			}  	
	}
  }
}

void gp32_GpTextOut(uint8 *buffer,int X,int Y,char *A,int col,int bold)
{
		int l;
	    int k;
		int msg_x,msg_y;  		
		if (A)
		{
			l=strlen(A);
			msg_x=X;
			msg_y=Y;
			k=0;   
			while (k<l)
			{
				if (A[k]!='\n') 
				{
					gp32_Printc(msg_x,msg_y,A[k],buffer,col,bold);
					msg_x+=7;
				}	
				else 
				{
				    msg_y+=8;
					msg_x=X;
				}
				if (msg_x>=(320-7))
				{
					msg_y+=8;
					msg_x=0;
				}
				if (msg_y>=(240-8))
				{
					msg_x=0;
					msg_y=0;	      
				}
				k++;
			}
		}				
}


void gp32_PrintcBig(uint32 x,uint32 y,char c,uint8 *scr,int col,int bold)
{
  int indice=c-32; //index in the font.h array
  int indicex,indicey;  
  uint32 i,j;
  int colB = ((((col>>1)&31)>>1)<<1)|((((col>>6)&31)>>1)<<6)|((((col>>11)&31)>>1)<<11)|1;
  

  if (indice>=96) indice=0;
  if (indice<0) indice=0;
  indicey=(indice>>4)*9;
  indicex=(indice&0xf)<<3;
  
  if (gp32_8bitmode)
  {
	  if (bold)
	  {
		  for (i=0;i<8;i++)
		  for (j=0;j<9;j++) 
		    if (font[j+indicey][i+indicex]!=' ') 
			{
				((uint8 *)(scr))[(239-(y+j*2)+((i*2+x)*240))]=col;
				((uint8 *)(scr))[(239-(y+j*2+1)+((i*2+x)*240))]=col;
				((uint8 *)(scr))[(239-(y+j*2)+((i*2+1+x)*240))]=col;
				((uint8 *)(scr))[(239-(y+j*2+1)+((i*2+1+x)*240))]=col;
			}
			else 
			{
				((uint8 *)(scr))[(239-(y+j*2)+((i*2+x)*240))]=col;
				((uint8 *)(scr))[(239-(y+j*2+1)+((i*2+x)*240))]=col;
				((uint8 *)(scr))[(239-(y+j*2)+((i*2+1+x)*240))]=col;
				((uint8 *)(scr))[(239-(y+j*2+1)+((i*2+1+x)*240))]=col;
			}
	  }
	  else
	  {
		  for (i=0;i<8;i++)
		  for (j=0;j<9;j++) 
		    if (font[j+indicey][i+indicex]=='#') 			
		    {
				((uint8 *)(scr))[(239-(y+j*2)+((i*2+x)*240))]=col;			  
				((uint8 *)(scr))[(239-(y+j*2+1)+((i*2+x)*240))]=col;			  
				((uint8 *)(scr))[(239-(y+j*2)+((i*2+1+x)*240))]=col;			  
				((uint8 *)(scr))[(239-(y+j*2+1)+((i*2+1+x)*240))]=col;			  
			}
	   }
  }  
  else
  {
  	if (bold)
  	{
		  for (i=0;i<8;i++)
	      for (j=0;j<9;j++) 
	      {
		    if (font[j+indicey][i+indicex]=='#') 
			{
				((uint8 *)(scr))[(239-(y+j*2)+((i*2+x)*240))<<1]=col&0xFE;
				((uint8 *)(scr))[(239-(y+j*2+1)+((i*2+x)*240))<<1]=col&0xFE;
				((uint8 *)(scr))[(239-(y+j*2)+((i*2+1+x)*240))<<1]=col&0xFE;
				((uint8 *)(scr))[(239-(y+j*2+1)+((i*2+1+x)*240))<<1]=col&0xFE;
				
				((uint8 *)(scr))[(239-(y+j*2)+((i*2+x)*240))<<1|1]=col>>8;
				((uint8 *)(scr))[(239-(y+j*2+1)+((i*2+x)*240))<<1|1]=col>>8;
				((uint8 *)(scr))[(239-(y+j*2)+((i*2+1+x)*240))<<1|1]=col>>8;
				((uint8 *)(scr))[(239-(y+j*2+1)+((i*2+1+x)*240))<<1|1]=col>>8;
			}			
			if (font[j+indicey][i+indicex]=='.')
			{
				((uint8 *)(scr))[(239-(y+j*2)+((i*2+x)*240))<<1]=colB&0xFE;
				((uint8 *)(scr))[(239-(y+j*2+1)+((i*2+x)*240))<<1]=colB&0xFE;
				((uint8 *)(scr))[(239-(y+j*2)+((i*2+1+x)*240))<<1]=colB&0xFE;
				((uint8 *)(scr))[(239-(y+j*2+1)+((i*2+1+x)*240))<<1]=colB&0xFE;
				
				((uint8 *)(scr))[(239-(y+j*2)+((i*2+x)*240))<<1|1]=colB>>8;
				((uint8 *)(scr))[(239-(y+j*2+1)+((i*2+x)*240))<<1|1]=colB>>8;
				((uint8 *)(scr))[(239-(y+j*2)+((i*2+1+x)*240))<<1|1]=colB>>8;
				((uint8 *)(scr))[(239-(y+j*2+1)+((i*2+1+x)*240))<<1|1]=colB>>8;
			}
		  }
	}
	else
	{
		  for (i=0;i<8;i++)
	      for (j=0;j<9;j++) 
		    if (font[j+indicey][i+indicex]=='#') 
			{
				((uint8 *)(scr))[(239-(y+j*2)+((i*2+x)*240))<<1]=col&0xFE;
				((uint8 *)(scr))[(239-(y+j*2+1)+((i*2+x)*240))<<1]=col&0xFE;
				((uint8 *)(scr))[(239-(y+j*2)+((i*2+1+x)*240))<<1]=col&0xFE;
				((uint8 *)(scr))[(239-(y+j*2+1)+((i*2+1+x)*240))<<1]=col&0xFE;
				((uint8 *)(scr))[(239-(y+j*2)+((i*2+x)*240))<<1|1]=col>>8;
				((uint8 *)(scr))[(239-(y+j*2+1)+((i*2+x)*240))<<1|1]=col>>8;
				((uint8 *)(scr))[(239-(y+j*2)+((i*2+1+x)*240))<<1|1]=col>>8;
				((uint8 *)(scr))[(239-(y+j*2+1)+((i*2+1+x)*240))<<1|1]=col>>8;				
			}  	
	}
  }
}

void gp32_GpTextOutBig(uint8 *buffer,int X,int Y,char *A,int col,int bold)
{
		int l;
	    int k;
		int msg_x,msg_y;  		
		if (A)
		{
			l=strlen(A);
			msg_x=X;
			msg_y=Y;
			k=0;   
			while (k<l)
			{
				if (A[k]!='\n') 
				{
					gp32_PrintcBig(msg_x,msg_y,A[k],buffer,col,bold);
					msg_x+=14;
				}	
				else 
				{
				    msg_y+=16;
					msg_x=X;
				}
				if (msg_x>=(320-14))
				{
					msg_y+=16;
					msg_x=0;
				}
				if (msg_y>=(240-16))
				{
					msg_x=0;
					msg_y=0;	      
				}
				k++;
			}
		}				
}


void gp32_printf(char *a)
{
	S9xMessage(0,0,a);
}

#ifdef PROFILING
void gp32_profile_start(int a)
{
	gp32_prof_call[a]++;
	gp32_prof_ctime[a]=gp32_time();	
}

void gp32_profile_end(int a)
{
	gp32_prof_time[a]+=gp32_time()-gp32_prof_ctime[a];	
}
#endif


int gp32_ShowCredits(char *bgimg)
{
//	char str[64];
//wait no buttons
  while (GpKeyGet());
  
  gp32_loadscr("Loading credits...",0);
  currentbuffer = vrambuffer;		  
	  vrambuffer = swapBuffer(&lcd,3/*3*/);
   
//init 3DEngine  
  y3DEngine_Init(0,1);  
//choose rendering options  
  y3DE_rendermode=6;
  y3DE_movemode=4;
  y3DE_ax=0;y3DE_ay=0;y3DE_az=0;
  y3DE_posX=0*65536;y3DE_posY=100*65536;y3DE_posZ=-30*65536;        
//go  
//start music

 
  
  Mod_LoadMod(1);
  Mod_SetVolume(16);
  Mod_Start();

  int interact_mode=2;
  do 
  {	  
	  currentbuffer = vrambuffer;		  
	  vrambuffer = swapBuffer(&lcd,3/*3*/);
	  
/*       sprintf(str,"Mem avail %d",gm_availablesize());
 	  MsgBold(4,200,str,(31<<11)|(30<<6)|(30<<1)|1);*/
	  
      gm_memset((char*)vrambuffer,0,320*240*2);      
      //gm_memcpy((char*)currentbuffer,y3DE_bg_logo,320*240*2);      

  }
  while (!y3DEngine_Render(vrambuffer,&interact_mode));      
  //close 3DEgine  
  y3DEngine_Close();
  //stop & free music
  Mod_StopMod();  
  return 0;
}

/* code retour 
/* 0 : ok */
/* 1 : on quitte emulation*/
int gp32_ShowGUI()
{
	stMenu main_menu;
	static int main_menu_current_line=0;
	int loop_menu;
	int ret_code,result;	
	char *bg_img;
	char str[256];
		
/*allocate mem*/				
	bg_img=(char*)malloc(320*240*2);
/*init*/		
	if (gp32_tmp8bitmode)
	{
		//conv to 16pp
		uint8 *p=(uint8*)vrambuffer;
		uint16 *q=(uint16*)bg_img;
		int32 i,r,v,b,c;
		for (i=0;i<320*240;i++,p++,q++)
		{
			c=*p;
			r = PPU.CGDATA [c] & 0x1f;
            v = (PPU.CGDATA [c] >> 5) & 0x1f;
            b = (PPU.CGDATA [c] >> 10) & 0x1f;
			*q=(r<<11)|(v<<6)|(b<<1)|1;
		}
		memcpy(vrambuffer,bg_img,320*240*2);
	}
	else memcpy(bg_img,vrambuffer,320*240*2);
	currentbuffer = vrambuffer;
 	vrambuffer = swapBuffer(&lcd,3);
 	
 	
	sprintf (str, "\"%s\" %s: %s.%s\n\nSaving SRAM if available...\nRAM : %d", Memory.ROMName, TITLE, VERSION_MAJOR, VERSION_MINOR);
	S9xMessage(0,0,str);

	
	Memory.SaveSRAM (S9xGetFilename (".srm"));

 	
 	/***/
/* 	gp32_GpTextOut(currentbuffer,0,0,"Ok you're in ",0xFFFF,1); 	
 	while (GpKeyGet());
 	Cls16(0)
 	
 	
 	int i,j,k;
 	str[0]=0;
 	j=k=0;
 	for (i=0;i<255;i++)
 	{
 		if (dsp_opcode[i]) 
 		{
 			sprintf(str,"%s%02X-%d ",str,i,dsp_opcode[i]); 			
 			j++;
 			if (j>=4)
 			{
	 			gp32_GpTextOut(currentbuffer,0,k*10,str,0xFFFF,1);
	 			str[0]=0;
 				j=0;
 				k++;
 				if (k>=24)
 				{
	 				while (!GpKeyGet());
	 				while (GpKeyGet());
	 				j=k=0;
	 				Cls16(0)
 				} 				
 			}
 		}
 	}
 	if (str[0]) gp32_GpTextOut(currentbuffer,0,k*10,str,0xFFFF,1);
 	
 	while (!GpKeyGet());*/
 	 	 		 	
/*init fx*/	
	InitWater(bg_img);	
/*init menu*/ 	 	  
    fill_main_menu(&main_menu);    	        
    main_menu.Cls_Menu=UpdateWater;
	loop_menu=1;
	ret_code=0;
	
	main_menu.selected=main_menu_current_line;
	
    while (loop_menu)
    {
	  result=run_menu(&main_menu,1,0);
	  switch(result)
	  {
		case MENU_MAIN_RETURN:loop_menu=0;break;
		case MENU_MAIN_EXIT_AND_SAVE:loop_menu=0;ret_code=1;break;
		case MENU_MAIN_RESET:S9xReset();loop_menu=0;break;
		case MENU_MAIN_STATE:CloseWater();if (gp32_ShowState(bg_img)) loop_menu=0; ret_code=0; ReInitWater();while (GpKeyGet());break;
		case MENU_MAIN_VIDEO:CloseWater();gp32_ShowVideo(bg_img);ReInitWater();while (GpKeyGet()) ;break;
		case MENU_MAIN_INPUT:CloseWater();gp32_ShowInput(bg_img);ReInitWater();while (GpKeyGet()) ;break;
		case MENU_MAIN_HACK:CloseWater();gp32_ShowHack(bg_img);ReInitWater();while (GpKeyGet());break;
		case MENU_MAIN_SOUND:CloseWater();gp32_ShowSound(bg_img);ReInitWater();while (GpKeyGet());break;						
		case MENU_MAIN_CREDITS:CloseWater();gp32_ShowCredits(bg_img);ReInitWater();while (GpKeyGet());break;
		case MENU_MAIN_PARAMGENSAVE:
			if (!os9xgp_paramSave("gp:\\gpetc\\os9xgp.cfg"))
				{MsgBold(0,210,"Settings saved to gp:\\gpetc\\os9xgp.cfg.",0xFFFF);}
			else 
				{MsgBold(0,210,"Settings could not be saved!",0xFFFF);}
			gp32_frame=gp32_frametimer;
			while (gp32_frametimer-gp32_frame<30) ;
			
			break;
		case MENU_MAIN_PARAMSPESAVE:
			sprintf(str,"%s",S9xGetFilename(".cfg"));
			if (!os9xgp_paramSave(str))  
				{sprintf(str,"Settings saved to %s.",str); MsgBold(0,210,str,0xFFFF);}
			else 
				{MsgBold(0,210,"Settings could not be saved!",0xFFFF);}
			gp32_frame=gp32_frametimer;
			while (gp32_frametimer-gp32_frame<30) ;
			
			break;
		case MENU_MAIN_REBOOT:
			GpAppExit();
			break;
	  }	  
    }
    
    CloseWater();
    free(bg_img);
    
	main_menu_current_line=main_menu.selected;    

    return ret_code;
}

int gp32_ShowSound(char *bg_img)
{
	stMenu sound_menu;
	static int sound_menu_current_line=0;
	int    loop_menu,ret_code,result;
	
	
	/*init fx*/	
	InitWater(bg_img);	
	/*init menu*/ 	 	  
    fill_sound_menu(&sound_menu);    	        
    sound_menu.Cls_Menu=UpdateWater;
	loop_menu=1;
	ret_code=0;
	
	sound_menu.selected=sound_menu_current_line;	
	sound_menu.options[MENU_SOUND_MODE].selected=gp32_soundenabled;
	switch (gp32_sndFrequency)
	{
		case 11025:sound_menu.options[MENU_SOUND_FREQUENCY].selected=0;break;
		case 22050:sound_menu.options[MENU_SOUND_FREQUENCY].selected=1;break;
		case 44100:sound_menu.options[MENU_SOUND_FREQUENCY].selected=2;break;
	}
	sound_menu.options[MENU_SOUND_STEREO].selected=gp32_sndStereo;
	sound_menu.options[MENU_SOUND_16BITS].selected=gp32_snd16bits;
	
    while (loop_menu)
    {
	  result=run_menu(&sound_menu,1,0);
	  switch(result)
	  {
		case MENU_SOUND_RETURN:loop_menu=0;break;
	  }
	}
	CloseWater();
	
	sound_menu_current_line=sound_menu.selected;
	Settings.NextAPUEnabled=Settings.APUEnabled=gp32_apuenabled=gp32_soundenabled=sound_menu.options[MENU_SOUND_MODE].selected;
	
	
	switch (sound_menu.options[MENU_SOUND_FREQUENCY].selected)
	{
		case 0:gp32_sndFrequency=11025;break;
		case 1:gp32_sndFrequency=22050;break;
		case 2:gp32_sndFrequency=44100;break;
	}
	gp32_sndStereo=sound_menu.options[MENU_SOUND_STEREO].selected;
	gp32_snd16bits=sound_menu.options[MENU_SOUND_16BITS].selected;
	return 0;
}


int gp32_ShowState(char *bg_img)
{
	stMenu state_menu;
	static int state_menu_current_line=0;
	int    loop_menu,ret_code,result;

	char   str[512];				
	static int slotstate=0;

	
	/*init fx*/	
	InitWater(bg_img);	
	/*init menu*/ 	 	  
    fill_state_menu(&state_menu);    	        
    state_menu.Cls_Menu=UpdateWater;
	loop_menu=1;
	ret_code=0;
	
	state_menu.selected=state_menu_current_line;
	state_menu.options[MENU_STATE_SLOT_STATE].selected=slotstate;	
	
    while (loop_menu)
    {
	  result=run_menu(&state_menu,1,1);
	  switch(result)
	  {
		case MENU_STATE_RETURN:loop_menu=0;break;
		case MENU_STATE_LOAD_STATE:
			slotstate=state_menu.options[MENU_STATE_SLOT_STATE].selected;
			CloseWater();
			MsgBold(0,210,"Loading",0xFFFF);
			// First try to load a compressed save
			sprintf(str,".za%.1d",slotstate);
			if (gp32_stateuncompress((char*)S9xGetFilename (str),"gp:\\gpmm\\os9xgp.tmp"))
			{
				// Compressed save not available, try a normal savestate
				sprintf(str,".sa%.1d",slotstate);
				result=S9xUnfreezeGame(S9xGetFilename (str));
				if (!result)
				{
					if (slotstate) sprintf(str,".zs%.1d",slotstate);
					else sprintf(str,".zst");
					result=S9xUnfreezeGame(S9xGetFilename (str));
				}
			}
			else 
			{
				// Compressed save found & uncompress, now loading ...
				result=S9xUnfreezeGame("gp:\\gpmm\\os9xgp.tmp");
				// And cleaning!
				GpFileRemove("gp:\\gpmm\\os9xgp.tmp");
			}
			if (result) 
			{				
 				//free(bg_img);			
 				MsgBold(250,210,"Done",0xFFFF);
			 	gp32_frame=gp32_frametimer;
				while (gp32_frametimer-gp32_frame<30) ;
				return 1;
			}
			else 
			{
				MsgBold(160,210,"Error",0xFFFF);				  			
				gp32_frame=gp32_frametimer;
				while (gp32_frametimer-gp32_frame<60) ;
				InitWater(bg_img);
			}				  	
			break;
		case MENU_STATE_SAVE_STATE:			
			if (gp32_checkstate((state_menu.options[MENU_STATE_SLOT_STATE]).selected,NULL))
			{
				int i;
				while (GpKeyGet());
				
				DrawWindowSlow(currentbuffer, 90,150, 140, 40 , (31<<11)|(31<<6)|(28<<1)|1,(24<<11)|(24<<6)|(15<<1)|1);
				MsgBold(111,155,"Please confirm",0xFFFF);	
				MsgBold(97 ,165,"Press A to confirm",0xFFFF);	
				MsgBold(104,175,"Others to cancel",0xFFFF);	
				while (!(i=GpKeyGet()));
				i&=GPC_VK_FA;				
				if (!i) break;
			}
			
			slotstate=state_menu.options[MENU_STATE_SLOT_STATE].selected;
			CloseWater();
			MsgBold(0,210,"Saving",0xFFFF);
			sprintf(str,".za%.1d",slotstate);
			// First to a normal save in tmp file
			result=S9xFreezeGame("gp:\\gpmm\\os9xgp.tmp");
		  	if (result) 
			{				  			
				// Then compress 
				MsgBold(60,210," & zipping ...",0xFFFF);				  			
				if (!gp32_statecompress("gp:\\gpmm\\os9xgp.tmp",(char*)S9xGetFilename (str),bg_img))
				{// And clean!
				  	GpFileRemove("gp:\\gpmm\\os9xgp.tmp");
	  				//free(bg_img);
					MsgBold(250,210,"Done",0xFFFF);
			  		gp32_frame=gp32_frametimer;
					while (gp32_frametimer-gp32_frame<30) ;
	  				return 1;
	  			}
	  			else result=0;
			} 		  						  				
			InitWater(bg_img);
			MsgBold(250,210,"Error",0xFFFF);
		 	gp32_frame=gp32_frametimer;
			while (gp32_frametimer-gp32_frame<60) ;						
			break;
	  }
	}
	CloseWater();
	
	slotstate=state_menu.options[MENU_STATE_SLOT_STATE].selected;	
	state_menu_current_line=state_menu.selected;
	
	return 0;
}

int translate_snes_mapping(uint32 snes_mask)
{
	switch (snes_mask)
	{
		case SNES_A_MASK:return 0;
		case SNES_B_MASK:return 1;
		case SNES_X_MASK:return 2;
		case SNES_Y_MASK:return 3;
		case SNES_TL_MASK:return 4;
		case SNES_TR_MASK:return 5;
		case SNES_START_MASK:return 6;
		case SNES_SELECT_MASK:return 7;		
	}
	return 0;
}

uint32 translate_gp32_mapping(int gpkey)
{
	switch (gpkey)
	{
		case 0:return SNES_A_MASK;
		case 1:return SNES_B_MASK;
		case 2:return SNES_X_MASK;
		case 3:return SNES_Y_MASK;
		case 4:return SNES_TL_MASK;
		case 5:return SNES_TR_MASK;
		case 6:return SNES_START_MASK;
		case 7:return SNES_SELECT_MASK;
	}
	return 0;
}


int gp32_ShowInput(char *bg_img)
{
	stMenu input_menu;
	static int input_menu_current_line=0;
	int    loop_menu,ret_code,result;
	/*init fx*/	
	InitWater(bg_img);	
	/*init menu*/ 	 	  
    fill_input_menu(&input_menu);    	        
    input_menu.Cls_Menu=UpdateWater;
	loop_menu=1;
	ret_code=0;
	
	input_menu.selected=input_menu_current_line;
	
    input_menu.options[MENU_INPUT_CONFSELECT].selected=gp32_activeconf;
	input_menu.options[MENU_INPUT_BUTTONA].selected=translate_snes_mapping(gp32_keyconfig[gp32_activeconf][GP_A]);
	input_menu.options[MENU_INPUT_BUTTONB].selected=translate_snes_mapping(gp32_keyconfig[gp32_activeconf][GP_B]);
	input_menu.options[MENU_INPUT_BUTTONL].selected=translate_snes_mapping(gp32_keyconfig[gp32_activeconf][GP_L]);
	input_menu.options[MENU_INPUT_BUTTONR].selected=translate_snes_mapping(gp32_keyconfig[gp32_activeconf][GP_R]);
	input_menu.options[MENU_INPUT_BUTTONSTART].selected=translate_snes_mapping(gp32_keyconfig[gp32_activeconf][GP_START]);
	input_menu.options[MENU_INPUT_BUTTONSELECT].selected=translate_snes_mapping(gp32_keyconfig[gp32_activeconf][GP_SELECT]);				
	input_menu.options[MENU_INPUT_BUTTONSELECT].disact=gp32_activeconf<2;
	
    while (loop_menu)
    {
	  result=run_menu(&input_menu,1,0);
	  switch(result)
	  {
		case MENU_INPUT_RETURN:loop_menu=0;break;
		case MENU_INPUT_CONFSELECT:			
			gp32_activeconf=input_menu.options[MENU_INPUT_CONFSELECT].selected;
			input_menu.options[MENU_INPUT_BUTTONA].selected=translate_snes_mapping(gp32_keyconfig[gp32_activeconf][GP_A]);
			input_menu.options[MENU_INPUT_BUTTONB].selected=translate_snes_mapping(gp32_keyconfig[gp32_activeconf][GP_B]);
			input_menu.options[MENU_INPUT_BUTTONL].selected=translate_snes_mapping(gp32_keyconfig[gp32_activeconf][GP_L]);
			input_menu.options[MENU_INPUT_BUTTONR].selected=translate_snes_mapping(gp32_keyconfig[gp32_activeconf][GP_R]);
			input_menu.options[MENU_INPUT_BUTTONSTART].selected=translate_snes_mapping(gp32_keyconfig[gp32_activeconf][GP_START]);
			input_menu.options[MENU_INPUT_BUTTONSELECT].selected=translate_snes_mapping(gp32_keyconfig[gp32_activeconf][GP_SELECT]);				
			input_menu.options[MENU_INPUT_BUTTONSELECT].disact=gp32_activeconf<2;
			break;
	  }
	}
	CloseWater();
	
	input_menu_current_line=input_menu.selected;
	gp32_activeconf=input_menu.options[MENU_INPUT_CONFSELECT].selected;	
	gp32_keyconfig[gp32_activeconf][GP_A]=translate_gp32_mapping(input_menu.options[MENU_INPUT_BUTTONA].selected);
	gp32_keyconfig[gp32_activeconf][GP_B]=translate_gp32_mapping(input_menu.options[MENU_INPUT_BUTTONB].selected);
	gp32_keyconfig[gp32_activeconf][GP_L]=translate_gp32_mapping(input_menu.options[MENU_INPUT_BUTTONL].selected);
	gp32_keyconfig[gp32_activeconf][GP_R]=translate_gp32_mapping(input_menu.options[MENU_INPUT_BUTTONR].selected);
	gp32_keyconfig[gp32_activeconf][GP_START]=translate_gp32_mapping(input_menu.options[MENU_INPUT_BUTTONSTART].selected);
	gp32_keyconfig[gp32_activeconf][GP_SELECT]=translate_gp32_mapping(input_menu.options[MENU_INPUT_BUTTONSELECT].selected);	
	
	return 0;
}

int gp32_ShowVideo(char *bg_img)
{
	stMenu video_menu;
	static int video_menu_current_line=0;
	int    loop_menu,ret_code,result;
	/*init fx*/	
	InitWater(bg_img);	
	/*init menu*/ 	 	  
    fill_video_menu(&video_menu);    	        
    video_menu.Cls_Menu=UpdateWater;
	loop_menu=1;
	ret_code=0;
	
	
	video_menu.options[MENU_VIDEO_SHOW_FPS].selected=gp32_showfps;		
	video_menu.options[MENU_VIDEO_GAMMA].selected=gp32_gammavalue;	
	video_menu.options[MENU_VIDEO_FRAMESKIP].selected = (gp32_fskipvalue==AUTO_FRAMERATE?10:gp32_fskipvalue);
	video_menu.options[MENU_VIDEO_MODE].selected = gp32_tmp8bitmode;
	video_menu.options[MENU_VIDEO_SYNC].selected = (gp32_syncmode?1:0);
	video_menu.options[MENU_VIDEO_FASTMODE].selected = (gp32_fastmode?1:0);
	
	video_menu.selected=video_menu_current_line;
    while (loop_menu)
    {
	  result=run_menu(&video_menu,1,0);
	  switch(result)
	  {
		case MENU_VIDEO_RETURN:loop_menu=0;break;
	  }
	}
	CloseWater();
		
	video_menu_current_line=video_menu.selected;
	gp32_showfps=video_menu.options[MENU_VIDEO_SHOW_FPS].selected;
	gp32_gammavalue=video_menu.options[MENU_VIDEO_GAMMA].selected;
	
	gp32_fskipvalue=Settings.SkipFrames=video_menu.options[MENU_VIDEO_FRAMESKIP].selected;
	if (Settings.SkipFrames==10)
	{
		gp32_fskipvalue=Settings.SkipFrames=AUTO_FRAMERATE;
	}
	gp32_tmp8bitmode=video_menu.options[MENU_VIDEO_MODE].selected;
	gp32_syncmode=(video_menu.options[MENU_VIDEO_SYNC].selected?3:0);
	gp32_fastmode=video_menu.options[MENU_VIDEO_FASTMODE].selected;
		
	return 0;
}

int gp32_ShowHack(char *bg_img)
{
	stMenu hack_menu;
	static int hack_menu_current_line=0;
	int    loop_menu,ret_code,result;
	/*init fx*/	
	InitWater(bg_img);	
	/*init menu*/ 	 	  
    fill_hack_menu(&hack_menu);    	        
    hack_menu.Cls_Menu=UpdateWater;
	loop_menu=1;
	ret_code=0;
	
	hack_menu.selected=hack_menu_current_line;
	hack_menu.options[MENU_HACK_TRANSPARENCY].selected=gp32_ShowSub;	
	hack_menu.options[MENU_HACK_PALETTEBRIGHTNESS].selected=gp32_PalBrightness;
	hack_menu.options[MENU_HACK_BG0].selected=!(PPU.BG_Forced&(1<<0));
	hack_menu.options[MENU_HACK_BG1].selected=!(PPU.BG_Forced&(1<<1));
	hack_menu.options[MENU_HACK_BG2].selected=!(PPU.BG_Forced&(1<<2));
	hack_menu.options[MENU_HACK_BG3].selected=!(PPU.BG_Forced&(1<<3));
	hack_menu.options[MENU_HACK_OBJS].selected=!(PPU.BG_Forced&(1<<4));
	
	hack_menu.options[MENU_HACK_HDMA].selected=!Settings.DisableHDMA;
	hack_menu.options[MENU_HACK_IRQ].selected=!Settings.DisableIRQ;
	hack_menu.options[MENU_HACK_FASTSPRITES].selected=gp32_fastsprite;
	hack_menu.options[MENU_HACK_CPUCYCLE].selected=(Settings.CyclesPercentage-100)/5+5;
	
    while (loop_menu)
    {
	  result=run_menu(&hack_menu,1,0);
	  switch(result)
	  {
		case MENU_HACK_RETURN:loop_menu=0;break;
	  }
	}
	CloseWater();
			
	hack_menu_current_line=hack_menu.selected;
	gp32_ShowSub=hack_menu.options[MENU_HACK_TRANSPARENCY].selected;
	gp32_PalBrightness=hack_menu.options[MENU_HACK_PALETTEBRIGHTNESS].selected;
	
	PPU.BG_Forced=(hack_menu.options[MENU_HACK_BG0].selected?0:1<<0);
	PPU.BG_Forced|=(hack_menu.options[MENU_HACK_BG1].selected?0:1<<1);
	PPU.BG_Forced|=(hack_menu.options[MENU_HACK_BG2].selected?0:1<<2);
	PPU.BG_Forced|=(hack_menu.options[MENU_HACK_BG3].selected?0:1<<3);
	PPU.BG_Forced|=(hack_menu.options[MENU_HACK_OBJS].selected?0:1<<4);
	gp32_BG_Forced=PPU.BG_Forced;
	
	gp32_DisableHDMA=Settings.DisableHDMA=!hack_menu.options[MENU_HACK_HDMA].selected;
	gp32_DisableIRQ=Settings.DisableIRQ=!hack_menu.options[MENU_HACK_IRQ].selected;
	gp32_fastsprite=hack_menu.options[MENU_HACK_FASTSPRITES].selected;	
	gp32_CyclesPercentage=Settings.CyclesPercentage=100+5*(hack_menu.options[MENU_HACK_CPUCYCLE].selected-5);	
	Settings.H_Max = (SNES_CYCLES_PER_SCANLINE*Settings.CyclesPercentage)/100;
	Settings.HBlankStart = (256 * Settings.H_Max) / SNES_HCOUNTER_MAX;
	
	return 0;
}


START_EXTERN_C

void gpsnes9x_main(void)
{ 
	FSEL filesel;
	uint8 *realvbuffer;
    char *pext,ext[5];
    int sysparam_loaded;
    long start_timer;
    int skip_intro;
  
    GpFatInit();
  
    
    
    
    gp32_8bitmode=0; 
    gp32_setupvideomode();	
  
  
  
  if(ReadID())
  {
  	S9xMessage(0,0,"Cannot read eeprom");
  	gp32_pause();
  	GpAppExit();
  }
  /*if(
     CheckID(0x4B,0x49,0x31,0xFA,0x3F,0x84)// ThunderZ
   &&CheckID(0xBE,0xB1,0xB8,0xB4,0xAC,0xBE)//GeePee32
   &&CheckID(0x4B,0x49,0x31,0xdb,0x60,0x76)//GeePee32
   &&CheckID(0x4B,0x49,0x31,0x09,0x52,0x54)//Yo) 
   )
  {
  	S9xMessage(0,0,"Unauthorized user!");
  	gp32_pause();
  	GpAppExit();
  }*/
  
  gp32_tmp8bitmode=0;
  int redrawopt=1;  
  char str[256];
  int i;
  currentbuffer = swapBuffer(&lcd,3);    
  
  
  sysparam_loaded=0;
  /*init sys options*/
  if (os9xgp_sysparamLoad("gp:\\gpetc\\os9xgp.sys")) 
  {
	gp32_clockfreq=133;  
	strcpy(gp32_romsdir,"gp:\\gpmm\\snes\\");
    rom_filename[0]=0;    
  }
  else sysparam_loaded=1;
  gp32_updateClockSpeed();
  start_timer=gp32_time();
  
  
  for (;;)
  {
#ifdef TESTING
	break;
#endif	
	   if (redrawopt)
	   {
		   redrawopt=0;		   
			int r,v,b,j;
		   for (i=0;i<320;i++)
	  		{	r=v=b=0;
		  		for (j=0;j<240;j++) 
		  		{
					b=j>>3;
					if (j>=150)
					{
						r=(j-150)>>3;
						v=(j-150)>>3;
					}
					else{r=0;v=0;}
					if (i>=200)
					{
     					b+=(i-200)>>3;
     					if (i>=250)
     					{
							r+=(i-250)>>3;
							v+=(i-250)>>3;						
						}
					}					
					if (r>31) r=31;if (v>31) v=31;if (b>31) b=31;
		  			((uint16*)currentbuffer)[i*240+239-j]=(r<<11)|(v<<6)|(b<<1)|1;
		  		}
		  	}
		  	sprintf(str,"[OpenSNES9xGP v%d.%d]",VERSION_MAJOR,VERSION_MINOR);
		  	MsgBoldBig(4,4,str,(31<<11)|(30<<6)|(31<<1)|1);
		  	sprintf(str,"Based on SNES9X 1.39a\n\
Modlib by CHN\nDouble buffer GFX code by Mr.Spiv\nSPC powered by Kode54 openSPC++\nMusic by Tip, AudioMonster & Jogeir\n\
Icon & splash screen by Antiriad\n\n\
GP32 port by YoyoFR, ThunderZ, Laxer3a\n\n");
 		    MsgBold(4,30,str,(28<<11)|(28<<6)|(31<<1)|1);
sprintf(str,"Press 'SELECT' to change clock speed\n\n\
Current freq : ");
 		    MsgBold(4,110,str,(28<<11)|(31<<6)|(30<<1)|1); 		    
 		    sprintf(str,"%dMhz",gp32_clockfreq);
 		    MsgBold(110,126,str,(20<<11)|(31<<6)|(24<<1)|1);
 		    			 		     		     		    
 		    sprintf(str,"Hold SELECT during emulation to access GUI");
/* 		    int32 dd,x,y;
 		    x=(394)<<16;
 		    y=(1000)<<16;
 		    SMULT1616(dd,x,y)
 		    dd=((int64)dd<<16)/y;
 		    sprintf(str,"x=%d y=%d dd=%d",x,y,dd);*/
 		    MsgBold(4,150,str,(28<<11)|(28<<6)|(31<<1)|1);
 		    
sprintf(str,"Press 'A' to start, 'START' to skip intro\n\n\
Mem avail %d",gm_availablesize());
 		    MsgBold(4,200,str,(31<<11)|(30<<6)|(30<<1)|1); 		     		    
sprintf(str,"'A'");
 		    MsgBold(4+6*7,200,str,(31<<11)|(20<<6)|(20<<1)|1);
 		
	 		vrambuffer = currentbuffer;		    
	        currentbuffer = swapBuffer(&lcd,3);    
	   }
	   
	  
	  

      while (GpKeyGet());
	  while (!(i=GpKeyGet()))
	  {
	  	if (sysparam_loaded)
	  	{
	  		if (gp32_time()-start_timer>2000) break;
	  	}
	  }
	  
	  if (sysparam_loaded)
	  	{
	  		if (gp32_time()-start_timer>2000) break;
	  	}
	  
	  sysparam_loaded=0;
	  
	  if (i&GPC_VK_SELECT)
	  {
	  	  redrawopt=1;
	  	  switch (gp32_clockfreq)
	  	  {	  	  
		  	case 133:
		  		gp32_clockfreq=140;
		  		break;
		  	case 140:
		  		gp32_clockfreq=150;
		  		break;
		  	case 150:
			  	gp32_clockfreq=156;
		  		break;
		  	case 156:
			  	gp32_clockfreq=160;
		  		break;
		  	case 160:
		  		gp32_clockfreq=166;
		  		break;
		  	case 166:
	 	 	    gp32_clockfreq=133;
		  		break;
		   }
	  }
	  if (i&(GPC_VK_START|GPC_VK_FA))
	  {
		  break;
	  }
	  while (GpKeyGet());
  }
  if (i&GPC_VK_START) skip_intro=1;
  else skip_intro=0;
  
  gp32_updateClockSpeed();
  

#ifndef TESTING
#ifndef	_BPP8MODE_  
#ifndef PROFILING    
  while (GpKeyGet());
    
  gp32_fadeout();
  if (!skip_intro)
  {
	  gp32_loadscr("Loading intro...",0);  	  
	  
	  char *bg_tmp,*y3DE_bg_logo;
	  if (SF_LoadData(8,&bg_tmp))
	  {
	  	y3DE_bg_logo=(char*)malloc(320*240*2);
	   	int i;
	   	for (i=0;i<320*240;i++)     	
	   	    	((uint16*)y3DE_bg_logo)[i]=(((i/240)&31)<<11)|((((i/320))&31)<<6)|((i&31)<<1)|1;
	  }
	  else
	   {
	   	y3DE_bg_logo=(char*)malloc(320*240*2);
	   	int i,j,r,v,b,k;
	   	for (i=0;i<320;i++)
	    for (j=0;j<240;j++) 
	    {
	    	k=((uint16*)bg_tmp)[i+j*320];
	    	r=(k>>11)&31;v=(k>>6)&31;b=(k>>1)&31;	     	
	    	((uint16*)y3DE_bg_logo)[i*240+239-j]=(r<<11)|(v<<6)|(b<<1)|1;
	    }
	    free(bg_tmp);
	    
	   }
	  
	  Mod_LoadMod(0);
	  Mod_SetVolume(16);
	  Mod_Start();  
	  
	  y3DEngine_Init(1,0);
	  
	  
	        
	  int interact_mode=2;
	  do 
	  {	  
		  currentbuffer = swapBuffer(&lcd,3);	
	      //gm_memset((char*)currentbuffer,0,320*240*2);      
	      gm_memcpy((char*)currentbuffer,y3DE_bg_logo,320*240*2);      
	  }
	  while (!y3DEngine_Render(currentbuffer,&interact_mode));        
	  free(y3DE_bg_logo);      
	  y3DEngine_Close();
	  Mod_StopMod();
	  
	  gp32_fadeout();
  }
#endif  
#endif
#endif
  
  

  for (;;)
  {  
  
  gp32_updateClockSpeed();
  
  gp32_8bitmode=0;
  gp32_setupvideomode();    
  gp32_clearAllScreens();  
  gp32_loadscr("Loading browser...",1);
  currentbuffer = vrambuffer;		  
  vrambuffer = swapBuffer(&lcd,3/*3*/);

  Mod_LoadMod(2);
  Mod_SetVolume(16);
  Mod_Start();  
  
  
    
  filesel.bgcolor=(31<<11)|(31<<6)|(31<<1)|1;
  filesel.bgcolor2=(29<<11)|(29<<6)|(29<<1)|1;
  filesel.curdircolor=(15<<11)|(31<<6)|(10<<1)|1;
  filesel.dircolor=(0<<11)|(24<<6)|(7<<1)|1;
  filesel.dirselcolor=(15<<11)|(31<<6)|(15<<1)|1;
  filesel.filecolor=(3<<11)|(3<<6)|(24<<1)|1;
  filesel.fileselcolor=(28<<11)|(16<<6)|(31<<1)|1;
  filesel.fname=rom_filename;
  filesel.vbuffer=currentbuffer;
  filesel.bppmul=2;      
#ifndef TESTING  
#ifndef PROFILING  

  FileRequest ( &filesel,gp32_romsdir, 0);
  memcpy(vrambuffer,currentbuffer,320*240*2);
  gp32_fadeout();
  
  os9xgp_sysparamSave("gp:\\gpetc\\os9xgp.sys"); 
    
  Mod_StopMod();
  
#else  
 //profiling
  strcpy(rom_filename,TESTING_ROMPATH);
#endif  
#else
  //testing
  strcpy(rom_filename,TESTING_ROMPATH);  
#endif   

  
  pext = strrchr(rom_filename, '.');
  if (pext) 
  {      
	strncpy(ext, pext,sizeof(ext)-1);
	strlwr(ext);
  }
  else ext[0]=0;							
  
  if (strcmp(ext, ".spc") == 0)
  {  
	gp32_8bitmode=0;
	gp32_setupvideomode();    
    gp32_clearAllScreens();  
    currentbuffer = swapBuffer(&lcd,3);	
    vrambuffer = swapBuffer(&lcd,3);    
  	OSPC_Play(rom_filename);
  	gp32_fadeout();
  }
  else gpsnes9x_Init();  
  
  
  
  }
}

END_EXTERN_C
/*********************/

char *gp32_getfilename(char *ext)
{
	return (char*)S9xGetFilename (ext);
}

int gp32_checkstate(int slot,char *mini_img)
{
	char strtmp[256];	
	uLong fsize;
	char mini_img_avail;
	sprintf(strtmp,".za%.1d",slot);
	if (GpFileGetSize((char*)gp32_getfilename(strtmp),&fsize)==SM_OK)
	{
		if (fsize>0)
		{
			CloseWater();
	    	int ret_code=gp32_stateuncompress_snap((char*)gp32_getfilename(strtmp),mini_img);
   			if (!ret_code) mini_img_avail=1;
			else mini_img_avail=0;
			ReInitWater();
		}else mini_img_avail=0;
	} else mini_img_avail=0;
	
	return mini_img_avail;
}

int yo_rand_val=0;
int yo_rand(void)
{
	yo_rand_val++;
	return yo_rand_val;
}
