#ifndef __gp32_func_h__
#define __gp32_func_h__

#define SMULT1616(res,a,b) {\
	__asm { smull r0,r1,a,b; \
			mov r0,r0,lsr 16; orr r0,r0,r1,lsl 16;mov res,r0;} }
	
#define UMULT1616(res,a,b) {\
	__asm { umull r0,r1,a,b; \
			mov r0,r0,lsr 16; orr r0,r0,r1,lsl 16;mov res,r0;} }
			
#define SMULT32(res,a,b) {\
	__asm { smull r0,r1,a,b; \
			mov res,r1;} }
	
#define UMULT32(res,a,b) {\
	__asm { umull r0,r1,a,b; \
			mov res,r1;} }
			
#define UADDMULT1616(res,a,b,c,d) {\
	__asm { umull r0,r1,a,b; umlal r0,r1,c,d; \
			mov r0,r0,lsr 16; orr r0,r0,r1,lsl 16;mov res,r0;} }
			
#define SADDMULT1616(res,a,b,c,d) {\
	__asm { smull r0,r1,a,b; smlal r0,r1,c,d; \
			mov r0,r0,lsr 16; orr r0,r0,r1,lsl 16;mov res,r0;} }

#define SADDMULT32(res,a,b,c,d) {\
	__asm { smull r0,r1,a,b; smlal r0,r1,c,d; \
			mov res,r1;} }
			
#define UADDMULT32(res,a,b,c,d) {\
	__asm { umull r0,r1,a,b; umlal r0,r1,c,d; \
			mov res,r1;} }			
			
			
	
//res=(a*b+c*d)>>32


extern struct LCDinfo lcd;
extern unsigned char *fbuf;
extern char gp32_8bitmode;
extern unsigned char *vrambuffer,*currentbuffer,*listbuffer[3];
extern int32 gp32_timermul;
extern int32 gp32_clockfreq;

void gp32_setupvideomode();
void gp32_clearAllScreens();

long gp32_time(void);
int gp32_strcasecmp(const char *s1, const char *s2 );
int  gp32_strncasecmp(const char *s1, const char *s2, unsigned n);
char gp32_toupper(char c);
char *gp32_strupr(char *s);
char *gp32_strlwr(char *s);
int gp32_atoi(char *s);
int gp32_memcmp(char *s1,char *s2, int lg);
int gp32_strncmp(char *s1,char *s2, int lg);
char *gp32_strrchr(char *s, char c);
void gp32_fseek (long position,int from_ref,F_HANDLE *s);
void gp32_fclose (F_HANDLE *s);
F_HANDLE *gp32_fopen (char *fname,char *mode);
long gp32_fwrite (unsigned char *ptr,long lg,F_HANDLE *s);
long gp32_fread (unsigned char *ptr,long lg,F_HANDLE *s);
long gp32_GpTickCountGet();
void gp32_wait(long n);

int gp32_stateuncompress_snap(char *source,char *img);
int gp32_stateuncompress(char *source,char *dest);
int gp32_statecompress(char *source,char *dest,char *img);

void gp32_updateClockSpeed(void);

void gp32_fadeout(void);

void gp32_loadscr(char *title,int col);

#endif
