#include "snes9x.h"

#define MAX_STATE_SIZE 512*1024
#define MAX_ZIPPED_STATE_SIZE 192*1024

extern "C"
{
#include "gfxlib.h"
#include "bioslib.h"
#include "gp32.h"
}

#include "zlib.h"

#define BUFFERSIZE 320*240*2*3 //2

struct LCDinfo lcd;

static unsigned char fbuf[BUFFERSIZE+4096];
unsigned char *vrambuffer,*currentbuffer,*listbuffer[3];


int gp32_8bitmode;
int32 gp32_timermul;
int32 gp32_clockfreq;

void gp32_clearAllScreens()
{
	gm_memset(listbuffer[0],0,320*240*(gp32_8bitmode?1:2));
	gm_memset(listbuffer[1],0,320*240*(gp32_8bitmode?1:2));
	if (listbuffer[2])
		gm_memset(listbuffer[2],0,320*240*(gp32_8bitmode?1:2));
}

void gp32_setupvideomode()
{
	unsigned char *buffer;

	
	ARMDisableInterruptSpiv();
    buffer =  (unsigned char *)(((long)(fbuf+4095) & ~4095));
	if (gp32_8bitmode)
	{
		GpGraphicModeSet(8, NULL);  
		setup8bppMode(&lcd,buffer,3);
		lcd.clkval = 8;
		lcd.posx = 0;
		lcd.posy = 0;
		lcd.x = 120;
		lcd.y = 320;
		lcd.offx = 0;
		lcd.offy = 0;
		setupLCDMode(&lcd,1);		
		//becoz it doesn't work well
		//GpGraphicModeSet(8, NULL);  
	
	}
	else
	{
		GpGraphicModeSet(16, NULL);  	
		setup16bppMode(&lcd,buffer,3/*2*/);
		lcd.clkval = 8;
		lcd.posx = 0;
		lcd.posy = 0;
		lcd.x = 240;
		lcd.y = 320;
		lcd.offx = 0;
		lcd.offy = 0;
		setupLCDMode(&lcd,1);		
		//becoz it doesn't work well
		//GpGraphicModeSet(16, NULL);  	
		gp32_8bitmode=0;
	}
	initBufferDMA(&lcd,DMA0_INT,NULL);
	cache_invalidate_all();
	mmuChange(buffer,buffer+BUFFERSIZE,CACHE_CNW);
	vrambuffer = swapBuffer(&lcd,3);
	listbuffer[0]=vrambuffer;	
	vrambuffer = swapBuffer(&lcd,3);	
	listbuffer[1]=vrambuffer;
	if (gp32_8bitmode)
	{
		vrambuffer = swapBuffer(&lcd,3);
		listbuffer[2]=vrambuffer;
		currentbuffer = listbuffer[1];
	}
	else
	{
/*		listbuffer[2]=NULL;
		currentbuffer = listbuffer[0];*/
		
		vrambuffer = swapBuffer(&lcd,3);
		listbuffer[2]=vrambuffer;
		currentbuffer = listbuffer[1];
	}
	
	
	ARMEnableInterruptSpiv();
}

long gp32_fread (unsigned char *ptr,long lg,F_HANDLE *s)
{
	unsigned long readbytes;
	GpFileRead(*s,ptr,lg,&readbytes);
	return (long)readbytes;
}
long gp32_fwrite (unsigned char *ptr,long lg,F_HANDLE *s)
{
	if (GpFileWrite(*s,ptr,lg)!=SM_OK) return -1;
	return 0;
}

F_HANDLE *gp32_fopen (char *fname,char *mode)
{
	int i=0;
	int readmode=1;
	F_HANDLE *file;
	while (mode[i])
	{
		if (mode[i]=='w') readmode=0;
		i++;
	}
	if (readmode) 
	{
		file=(F_HANDLE *)malloc(sizeof(F_HANDLE));
		if (GpFileOpen(fname,OPEN_R,file)==SM_OK) return file;
		free(file);
		return NULL;
	}
	else
	{
		file=(F_HANDLE *)malloc(sizeof(F_HANDLE));
		if (GpFileCreate(fname,ALWAYS_CREATE,file)==SM_OK) return file;
		free(file);
		return NULL;
	}
}

void gp32_fclose (F_HANDLE *s)
{
	if (s!=NULL)
	{
		GpFileClose(*s);
		free(s);
	}
}

void gp32_fseek (long position,int from_ref,F_HANDLE *s)
{
	if (s!=NULL)
	{
		if (from_ref==SEEK_SET) from_ref=FROM_BEGIN;
		else if (from_ref==SEEK_CUR) from_ref=FROM_CURRENT;
		else from_ref=FROM_END;
		GpFileSeek(*s,from_ref,position,NULL);
	}
}

char *gp32_strrchr(char *s, char c)
{
	int i;
	if ((s==NULL)||(!s[0])) return NULL;
	i=0;
	while (s[i]) i++;
	while (i && (s[i]!=c) ) i--;
	if (s[i]!=c) return NULL;
	return (char*)(s+i);
}

int gp32_strncmp(char *s1,char *s2, int lg)
{
	int i;
	if ((s1==NULL)||(s2==NULL)) return -1;
	i=0;
	while ((s1[i]==s2[i])&&((i+1)<lg))
	{
		if ((!s1[i])||(!s2[i])) break;
		i++;
	}
	return s1[i]-s2[i];
}


int gp32_memcmp(char *s1,char *s2, int lg)
{
	int i;
	if (!lg) return 0;
	if ((s1==NULL)||(s2==NULL)) return -1;
	i=0;
	while ((s1[i]==s2[i])&&(i<lg-1))
	{		
		i++;
	}
	return s1[i]-s2[i];
}

int gp32_atoi(char *s)
{
	int i,r;
	if (s==NULL) return 0;
	i=0;
	r=0;
	while (s[i])
	{
	 if ((s[i]>='0')&&(s[i]<='9')) r=r*10+(s[i]-'0');
	 i++;
	}
	return r;
}

char *gp32_strlwr(char *s)
{
   int i;
   if(s==NULL) return s;
   i=0;
   while (s[i])
   {
   	if ((s[i]>='A') && (s[i]<='Z')) s[i]+='a'-'A';
   	i++;
   }
   return s;
}

char *gp32_strupr(char *s)
{
   int i;
   if(s==NULL) return s;
   i=0;
   while (s[i])
   {
   	if ((s[i]>='a') && (s[i]<='z')) s[i]+='A'-'a';
   	i++;
   }
   return s;
}


char gp32_toupper(char c)
{
   if ((c>='a') && (c<='z')) return c+'A'-'a';
   return c;
}

int  gp32_strncasecmp(const char *s1, const char *s2, unsigned n)
{
	int i;
	char c1,c2;
	if ((s1==NULL)||(s2==NULL)) return -1;
	i=0;
	while ((i+1)<n)
	{
		c1=s1[i];
		c2=s2[i];
		if ((!c1)||(!c2)) break;
		if ((c1>='A')&&(c1<='Z')) c1+='a'-'A';
		if ((c2>='A')&&(c2<='Z')) c2+='a'-'A';
		if (c1!=c2) break;		
		i++;
	}
	return c1-c2;	
}
int gp32_strcasecmp(const char *s1, const char *s2 )
{
	int i;
	char c1,c2;
	if ((s1==NULL)||(s2==NULL)) return -1;
	i=0;
	while (1)
	{
		c1=s1[i];
		c2=s2[i];
		if ((!c1)||(!c2)) break;
		if ((c1>='A')&&(c1<='Z')) c1+='a'-'A';
		if ((c2>='A')&&(c2<='Z')) c2+='a'-'A';
		if (c1!=c2) break;		
		i++;
	}
	return c1-c2;	
}

long gp32_time(void)
{
	return (GpTickCountGet()*gp32_timermul>>8);
}

long gp32_GpTickCountGet()
{
	return GpTickCountGet()*gp32_timermul>>8;
}

int gp32_statecompress(char *source,char *dest,char *img)
{
	z_stream c_stream; /* compression stream */	
    int err;
    uLong len;    
	//Byte *compr;    
	Byte *compr;
    uint32 comprLen;
    Byte *uncompr;
    uLong uncomprLen;
    int i,j;
//    char str[256];
	F_HANDLE f;
		
	err=GpFileGetSize(source,&uncomprLen);
	if (err!=SM_OK) return -1;
	
/*	sprintf(str,"mem avail : %d",gm_availablesize());
	MsgBold(160,0,str,0xFFFF);
	gp32_pause();*/
			
	uncompr=(Byte*)malloc(uncomprLen+60*64*2);
	if (!uncompr) return 1;
	
	
	err=GpFileOpen(source,OPEN_R,&f);
	if (err!=SM_OK) 
	{
		free(uncompr);
		return -1;
	}
	err=GpFileRead(f,uncompr,uncomprLen,&len);
	if ((err!=SM_OK)||(len!=uncomprLen)) 
	{
		free(uncompr);
		GpFileClose(f);
		return -1;
	}
	GpFileClose(f);
	
	if (img)
	{
		for (i=0;i<64;i++)
		for (j=0;j<60;j++) 
		{
			uncompr[uncomprLen+((i*60+j)<<1)]=img[(32*240+i*4*240+j*4)<<1];
			uncompr[uncomprLen+(((i*60+j)<<1)|1)]=img[((32*240+i*4*240+j*4)<<1)|1];
		}
		uncomprLen+=60*64*2;
	}
		
	comprLen=MAX_ZIPPED_STATE_SIZE; //should be enough for a savestate
	compr=(Byte*)malloc(comprLen);
	if (!uncompr) 
	{
		free(compr);
		return 2;
	}
	
    c_stream.zalloc = (alloc_func)0;
    c_stream.zfree = (free_func)0;
    c_stream.opaque = (voidpf)0;
    
    c_stream.next_in  = (Bytef*)uncompr;
    c_stream.next_out = compr;
    c_stream.avail_in = (uInt)uncomprLen;
    c_stream.avail_out = (uInt)comprLen;
    
/*    sprintf(str,"mem avail : %d err %d",gm_availablesize(),err);
	MsgBold(160,10,str,0xFFFF);
	gp32_pause();*/

    err = deflateInit(&c_stream, Z_BEST_COMPRESSION/*Z_DEFAULT_COMPRESSION*/);
//    CHECK_ERR(err, "deflateInit");
	if (err) 
	{
		free(compr);
		free(uncompr);
		return 2;
	}
	
/*	sprintf(str,"mem avail : %d err %d",gm_availablesize(),err);
	MsgBold(160,20,str,0xFFFF);
	gp32_pause();*/

/*	sprintf(str,"mem avail : %d err %d",gm_availablesize(),err);
	MsgBold(160,20,str,0xFFFF);
	gp32_pause();	    */
    
    err = deflate(&c_stream, Z_NO_FLUSH);
    //CHECK_ERR(err, "deflate");
    if (c_stream.avail_in != 0) {
      //  fprintf(stderr, "deflate not greedy\n");
		return 1;
    }
    err = deflate(&c_stream, Z_FINISH);
    if (err != Z_STREAM_END) {
    //    fprintf(stderr, "deflate should report Z_STREAM_END\n");
	//exit(1);
		return 1;
    }

    err = deflateEnd(&c_stream);
    
    //sprintf(str,"original size : %d\ncompressed size : %d",c_stream.total_in,/*i*/c_stream.total_out);
    //S9xMessage(0,0,str);
                
	free(uncompr);
			
	err=GpFileCreate(dest,ALWAYS_CREATE,&f);
	if (err!=SM_OK) 
	{
		free(compr);
		return -2;
	}
	err=GpFileWrite(f,compr,c_stream.total_out);
	if (err!=SM_OK)
	{
		free(compr);
		GpFileClose(f);
		return -2;
	}   
	free(compr);
	GpFileClose(f); 
	return 0;
}


int gp32_stateuncompress(char *source,char *dest)
{
	z_stream d_stream; /* compression stream */	
    int err;
    uLong len;    
	//Byte *compr;    
	Byte *compr;
    uLong comprLen;
    Byte *uncompr;
    uLong uncomprLen;
//    char str[256];
	F_HANDLE f;
	
	//S9xMessage(0,0,"Reading file");	

	err=GpFileGetSize(source,&comprLen);
	if (err!=SM_OK) return -1;
	
	compr=(Byte*)malloc(comprLen);
	
	err=GpFileOpen(source,OPEN_R,&f);
	if (err!=SM_OK) 
	{
		free(compr);
		return -1;
	}
	err=GpFileRead(f,compr,comprLen,&len);
	if ((err!=SM_OK)||(len!=comprLen)) 
	{
		free(compr);
		GpFileClose(f);
		return -1;
	}
	GpFileClose(f);
	
	//S9xMessage(0,0,"Decompressing");
	
	uncompr=(Byte*)malloc(MAX_STATE_SIZE);
	uncomprLen=MAX_STATE_SIZE;


    d_stream.zalloc = (alloc_func)0;
    d_stream.zfree = (free_func)0;
    d_stream.opaque = (voidpf)0;

    d_stream.next_in  = compr;
    d_stream.avail_in = 0;
    d_stream.next_out = uncompr;

    err = inflateInit(&d_stream);
//    CHECK_ERR(err, "inflateInit");

	d_stream.avail_in = (uInt)comprLen;
    for (;;) {
        d_stream.next_out = uncompr;            /* discard the output */
		d_stream.avail_out = (uInt)uncomprLen;
        err = inflate(&d_stream, Z_NO_FLUSH);
        if (err == Z_STREAM_END) break;
        //CHECK_ERR(err, "large inflate");
    }

    err = inflateEnd(&d_stream);
  //  CHECK_ERR(err, "inflateEnd");
  
	//S9xMessage(0,0,"done");
	free(compr);
			
	err=GpFileCreate(dest,ALWAYS_CREATE,&f);
	if (err!=SM_OK) 
	{
		free(uncompr);
		return -2;
	}
	err=GpFileWrite(f,uncompr,d_stream.total_out);
	if (err!=SM_OK)
	{
		free(uncompr);
		GpFileClose(f);
		return -2;
	}   
	free(uncompr);
	GpFileClose(f); 
	return 0;
}


int gp32_stateuncompress_snap(char *source,char *img)
{
	z_stream d_stream; /* compression stream */	
    int err;
    uLong len;    
	//Byte *compr;    
	Byte *compr;
    uLong comprLen;
    Byte *uncompr;
    uLong uncomprLen;
    char str[256];
	F_HANDLE f;
	
	
	err=GpFileGetSize(source,&comprLen);	
	if (err!=SM_OK) return -1;
	
	
	compr=(Byte*)malloc(comprLen);	
	if (!compr) return -1;
	
	err=GpFileOpen(source,OPEN_R,&f);
	if (err!=SM_OK) 
	{
		free(compr);
		return -2;
	}
	err=GpFileRead(f,compr,comprLen,&len);
	if ((err!=SM_OK)||(len!=comprLen)) 
	{
		free(compr);
		GpFileClose(f);
		return -3;
	}
	GpFileClose(f);

	uncomprLen=MAX_STATE_SIZE;			
	uncompr=(Byte*)malloc(uncomprLen);
	if (!uncompr) 
	{
		free(compr);
		GpFileClose(f);
		return -3;
	}

    d_stream.zalloc = (alloc_func)0;
    d_stream.zfree = (free_func)0;
    d_stream.opaque = (voidpf)0;

    d_stream.next_in  = compr;
    d_stream.avail_in = 0;
    d_stream.next_out = uncompr;

    err = inflateInit(&d_stream);
	if (err) 
	{
		free(compr);
		free(uncompr);	
		return -5;
	}
	
/*	sprintf(str,"now ram=%d",gm_availablesize());
	gp32_GpTextOut(currentbuffer,0,50,str,0xFFFF,1);
	gp32_pause();*/
	
	d_stream.avail_in = (uInt)comprLen;
    for (;;) {
        d_stream.next_out = uncompr;            /* discard the output */
		d_stream.avail_out = (uInt)uncomprLen;
        err = inflate(&d_stream, Z_NO_FLUSH);
        
        if (err == Z_STREAM_END) break;
        if (err) 
		{
			free(compr);
			free(uncompr);
			return -6;
		}
    }
    
    err = inflateEnd(&d_stream);
    if (err) 
	{
		free(compr);
		free(uncompr);
		return -7;
	}
	free(compr);
	
	if (img&&(d_stream.total_out>=60*64*2)) gm_memcpy(img,uncompr+d_stream.total_out-60*64*2,60*64*2);
	free(uncompr);
	return 0;
}

void gp32_wait(long n)
{
	long start=gp32_GpTickCountGet();
	long real_n=(n*gp32_timermul)>>8;
	while (gp32_GpTickCountGet()-start<real_n) ;
}

void gp32_updateClockSpeed(void)
{
	switch (gp32_clockfreq)
  {	
  	case 133:
   		GpClockSpeedChange(132000000, 0x3a011, 3); 
	   	gp32_timermul=(67800*256/132000);
	   	break;
	case 140:
   		GpClockSpeedChange(140000000, 0x3e011, 3); 
	   	gp32_timermul=(67800*256/140000);
	   	break;
	case 150:
	    GpClockSpeedChange(150000000, 0x43011, 3); 
	    gp32_timermul=(67800*256/150000);
	    break;
	case 156:
	    GpClockSpeedChange(156000000, 0x46011, 3); 
	    gp32_timermul=(67800*256/156000);
	    break;
	case 160:
	    GpClockSpeedChange(160000000, 0x48011, 3);
	    gp32_timermul=(67800*256/160000);
	    break;
	case 166:
	   GpClockSpeedChange (166000000, 0x4b011, 3);
	    gp32_timermul=(67800*256/166000);
	    break;
  }
 }
 
void gp32_fadeout(void)
{
	int i,k,r,v,b,j;
	uint16 *p,*q;	
	for (i=0;i<32;i++)
	{		
		p=(uint16*)vrambuffer;
		q=(uint16*)currentbuffer;
		for (j=0;j<320*240;j++,p++,q++)
		{
			k=*p;
			r=(k>>11)&31;v=(k>>6)&31;b=(k>>1)&31;
			if (r>0) r--;
			if (v>0) v--;
			if (b>0) b--;
			*q=(r<<11)|(v<<6)|(b<<1)|1;
		}
		vrambuffer = currentbuffer;
		currentbuffer = swapBuffer(&lcd,3);
	}
}

void gp32_loadscr(char *title,int col=0)
{
	int i,k,r,v,b,j;
	uint16 *p,*q;	
	if (gp32_8bitmode) return;
	
	memset(vrambuffer,0,320*240*2);
	for (i=0;i<8;i++)
	{		
		switch (col)
		{		
			case 0:
			if (i<4) k=((((i>>2)<<2)*8)<<11)|((((i>>2)<<2)*8)<<6)|((i*10)<<1)|1;
			else k=(((((7-i)>>2)<<2)*8)<<11)|(((((7-i)>>2)<<2)*8)<<6)|(((7-i)*10)<<1)|1;		
			break;
			case 1:
			if (i<4) k=((i*10)<<11)|((((i>>2)<<2)*10)<<6)|((((i>>2)<<2)*10)<<1)|1;
			else k=(((7-i)*10)<<11)|(((((7-i)>>2)<<2)*8)<<6)|(((((7-i)>>2)<<2)*8)<<1)|1;		
			break;
			case 2:
			if (i<4) k=((i*10)<<6)|((((i>>1)<<1)*10)<<11)|((((i>>1)<<1)*8)<<1)|1;
			else k=(((7-i)*10)<<6)|(((((7-i)>>1)<<1)*10)<<11)|(((((7-i)>>1)<<1)*8)<<1)|1;		
			break;
		}
		p=(uint16*)vrambuffer+239-(120-4+i);
		for (j=0;j<320;j++,p+=240) *p=k;
	}
	gp32_GpTextOut(vrambuffer,160-(strlen(title)>>1)*7,108,title,0xFFFF,1);
}