/*   
   Generate PPU tiles routines in ARM assembly.
   Syntax used is ARM ADS 1.2
   
   8 Bits version

   Author      : YoyoFR
   Last update : 16-Dec-2003
*/

/************************************************************

  Registers usage :
	R12 = OfsGP32 (ram video)
	R11 = Cache Pixel
	R10 = Cache Header
	R9  = Ofs jumptable
	R8  = Column counter
	R7  = 240 (ofsgp32 adder)
	R6  = Clipping value to add to header value

*************************************************************/


#include "stdio.h"
#include "stdlib.h"


void func_begin(char *src,unsigned char mode,int flipping,int align)
{
	sprintf(src,"%s\nPPU8_%02X_%d_%d\n;;case %c%c%c%c%c%c%c%c\n",src,mode,flipping,align,
		48+((mode>>7)&1),48+((mode>>6)&1),48+((mode>>5)&1),48+((mode>>4)&1),
		48+((mode>>3)&1),48+((mode>>2)&1),48+((mode>>1)&1),48+((mode>>0)&1));
		
}

void func_end(char *src,unsigned char mode,int flipping)
{	
	if (mode==0xFF)
	{
		//next cache col
		sprintf(src,"%s		add		R11,R11,#8\n",src); 
		//next vram col, based on vertical flipping
		if (flipping&1) sprintf(src,"%s		add		R12,R12,#8\n",src); 
		else sprintf(src,"%s		sub		R12,R12,#8\n",src);  
	}
	sprintf(src,"%s		NEXT_COL8\n;;----------------------------------------\n",src);
}

void func_index(char *src,int flipping,int align)
{	
	int i;
	sprintf(src,"%sjumptable_ppu8%d%d\n",src,flipping,align);
	for (i=0;i<=255;i++)
	{
		sprintf(src,"%s		DCD		PPU8_%02X_%d_%d\n",src,i,flipping,align);
	}
}

void func_base(char *src)
{
	sprintf(src,"%s		AREA		ppuasm8, CODE, READONLY\n",src);
	sprintf(src,"%s		EXPORT		asmDrawTile8\n\n\n",src);
	sprintf(src,"%s		EXPORT		asmDrawTileClipped8\n\n\n",src);

	sprintf(src,"%s	;;R12 = OfsGP32 (ram video)\n",src);
	sprintf(src,"%s	;;R11 = Cache Pixel\n",src);
	sprintf(src,"%s	;;R10 = Cache Header\n",src);
	sprintf(src,"%s	;;R9  = Ofs jumptable\n",src);
	sprintf(src,"%s	;;R8  = Column counter\n",src);
	sprintf(src,"%s	;;R7  = 240 (ofsgp32 adder)\n",src);
	sprintf(src,"%s	;;R6  = Clipping value to add to header value\n\n\n",src);


	sprintf(src,"%s		MACRO\n",src);
	sprintf(src,"%s$label		NEXT_COL8\n",src);
	sprintf(src,"%s		subs		R8,R8,#1\n",src);
	sprintf(src,"%s		ldrneb		R0,[R10],#1\n",src);
	sprintf(src,"%s		addne		R12,R12,R7\n",src);
	sprintf(src,"%s		orrne		R0,R0,R6\n",src);	
	sprintf(src,"%s		ldrne		PC,[R9,R0,lsl #2]\n",src);
	sprintf(src,"%s		ldmfd		R13!,{R4-R11}\n",src);
	sprintf(src,"%s		mov			PC,LR\n",src);
	sprintf(src,"%s		MEND\n\n\n",src);

	sprintf(src,"%s		MACRO\n",src);
	sprintf(src,"%s$label		INIT_TILER8\n",src);
	sprintf(src,"%s		and		R0,R12,#3\n",src);
	sprintf(src,"%s		cmp		R0,#0\n",src);
	sprintf(src,"%s		bne		%%f10		;not_aligned8_A\n",src);
//aligned on 0
	sprintf(src,"%s		cmp		R3,#0\n",src);
	sprintf(src,"%s		bne		%%f01		;flip_not0_aligned8\n",src);
	sprintf(src,"%s		ldr		R9,= jumptable_ppu800\n",src);
	sprintf(src,"%s		ldrb	R0,[R10],#1\n",src);
	sprintf(src,"%s		orr		R0,R0,R6\n",src);
	sprintf(src,"%s		ldr		R7, = 248\n",src);
	sprintf(src,"%s		ldr		PC,[R9,R0,lsl #2]\n",src);
	sprintf(src,"%s01		;flip_not0_aligned8\n",src);
	sprintf(src,"%s		cmp		R3,#1\n",src);
	sprintf(src,"%s		bne		%%f02		;flip_not1_aligned8\n",src);
	sprintf(src,"%s		ldr		R9,= jumptable_ppu811\n",src);
	sprintf(src,"%s		ldrb	R0,[R10],#1\n",src);
	sprintf(src,"%s		orr		R0,R0,R6\n",src);
	sprintf(src,"%s		ldr		R7, = 232\n",src);
	sprintf(src,"%s		sub		R12,R12,#7\n",src);
	sprintf(src,"%s		ldr		PC,[R9,R0,lsl #2]\n",src);
	sprintf(src,"%s02		;flip_not1_aligned8\n",src);
	sprintf(src,"%s		cmp		R3,#2\n",src);
	sprintf(src,"%s		bne		%%f03		;flip_not2_aligned8\n",src);
	sprintf(src,"%s		ldr		R9,= jumptable_ppu800\n",src);
	sprintf(src,"%s		ldrb	R0,[R10],#1\n",src);
	sprintf(src,"%s		orr		R0,R0,R6\n",src);
	sprintf(src,"%s		ldr		R7, = -232\n",src);
	sprintf(src,"%s		ldr		PC,[R9,R0,lsl #2]\n",src);
	sprintf(src,"%s03		;flip_not2_aligned8\n",src);
	sprintf(src,"%s		ldr		R9,= jumptable_ppu811\n",src);
	sprintf(src,"%s		ldrb	R0,[R10],#1\n",src);
	sprintf(src,"%s		orr		R0,R0,R6\n",src);
	sprintf(src,"%s		ldr		R7, = -248\n",src);
	sprintf(src,"%s		sub		R12,R12,#7\n",src);
	sprintf(src,"%s		ldr		PC,[R9,R0,lsl #2]\n",src);

	sprintf(src,"%s10		;not_aligned8_A\n",src);
	sprintf(src,"%s		cmp		R0,#1\n",src);
	sprintf(src,"%s		bne		%%f20		;not_aligned8_B\n",src);
//aligned on 1
	sprintf(src,"%s		cmp		R3,#0\n",src);
	sprintf(src,"%s		bne		%%f11		;flip_not0_not_aligned8_A\n",src);
	sprintf(src,"%s		ldr		R9,= jumptable_ppu801\n",src);
	sprintf(src,"%s		ldrb	R0,[R10],#1\n",src);
	sprintf(src,"%s		orr		R0,R0,R6\n",src);
	sprintf(src,"%s		ldr		R7, = 248\n",src);
	sprintf(src,"%s		ldr		PC,[R9,R0,lsl #2]\n",src);
	sprintf(src,"%s11		;flip_not0_not_aligned8_A\n",src);
	sprintf(src,"%s		cmp		R3,#1\n",src);
	sprintf(src,"%s		bne		%%f12		;flip_not1_not_aligned8_A\n",src);	
	sprintf(src,"%s		ldr		R9,= jumptable_ppu812\n",src);
	sprintf(src,"%s		ldrb	R0,[R10],#1\n",src);
	sprintf(src,"%s		orr		R0,R0,R6\n",src);
	sprintf(src,"%s		ldr		R7, = 232\n",src);	
	sprintf(src,"%s		sub		R12,R12,#7\n",src);	
	sprintf(src,"%s		ldr		PC,[R9,R0,lsl #2]\n",src);
	sprintf(src,"%s12		;flip_not1_not_aligned8_A\n",src);
	sprintf(src,"%s		cmp		R3,#2\n",src);
	sprintf(src,"%s		bne		%%f13		;flip_not2_not_aligned8_A\n",src);
	sprintf(src,"%s		ldr		R9,= jumptable_ppu801\n",src);
	sprintf(src,"%s		ldrb	R0,[R10],#1\n",src);
	sprintf(src,"%s		orr		R0,R0,R6\n",src);
	sprintf(src,"%s		ldr		R7, = -232\n",src);	
	sprintf(src,"%s		ldr		PC,[R9,R0,lsl #2]\n",src);
	sprintf(src,"%s13		;flip_not2_not_aligned8_A\n",src);
	sprintf(src,"%s		ldr		R9,= jumptable_ppu812\n",src);
	sprintf(src,"%s		ldrb	R0,[R10],#1\n",src);
	sprintf(src,"%s		orr		R0,R0,R6\n",src);
	sprintf(src,"%s		ldr		R7, = -248\n",src);
	sprintf(src,"%s		sub		R12,R12,#7\n",src);
	sprintf(src,"%s		ldr		PC,[R9,R0,lsl #2]\n",src);

	sprintf(src,"%s20		;not_aligned8_B\n",src);
	sprintf(src,"%s		cmp		R0,#2\n",src);
	sprintf(src,"%s		bne		%%f30		;not_aligned8_C\n",src);
//aligned on 2
	sprintf(src,"%s		cmp		R3,#0\n",src);
	sprintf(src,"%s		bne		%%f21		;flip_not0_not_aligned8_B\n",src);
	sprintf(src,"%s		ldr		R9,= jumptable_ppu802\n",src);
	sprintf(src,"%s		ldrb	R0,[R10],#1\n",src);
	sprintf(src,"%s		orr		R0,R0,R6\n",src);
	sprintf(src,"%s		ldr		R7, = 248\n",src);
	sprintf(src,"%s		ldr		PC,[R9,R0,lsl #2]\n",src);
	sprintf(src,"%s21		;flip_not0_not_aligned8_B\n",src);
	sprintf(src,"%s		cmp		R3,#1\n",src);
	sprintf(src,"%s		bne		%%f22		;flip_not1_not_aligned8_B\n",src);	
	sprintf(src,"%s		ldr		R9,= jumptable_ppu813\n",src);
	sprintf(src,"%s		ldrb	R0,[R10],#1\n",src);
	sprintf(src,"%s		orr		R0,R0,R6\n",src);
	sprintf(src,"%s		ldr		R7, = 232\n",src);	
	sprintf(src,"%s		sub		R12,R12,#7\n",src);	
	sprintf(src,"%s		ldr		PC,[R9,R0,lsl #2]\n",src);
	sprintf(src,"%s22		;flip_not1_not_aligned8_B\n",src);
	sprintf(src,"%s		cmp		R3,#2\n",src);
	sprintf(src,"%s		bne		%%f23		;flip_not2_not_aligned8_B\n",src);
	sprintf(src,"%s		ldr		R9,= jumptable_ppu802\n",src);
	sprintf(src,"%s		ldrb	R0,[R10],#1\n",src);
	sprintf(src,"%s		orr		R0,R0,R6\n",src);
	sprintf(src,"%s		ldr		R7, = -232\n",src);	
	sprintf(src,"%s		ldr		PC,[R9,R0,lsl #2]\n",src);
	sprintf(src,"%s23		;flip_not2_not_aligned8_B\n",src);
	sprintf(src,"%s		ldr		R9,= jumptable_ppu813\n",src);
	sprintf(src,"%s		ldrb	R0,[R10],#1\n",src);
	sprintf(src,"%s		orr		R0,R0,R6\n",src);
	sprintf(src,"%s		ldr		R7, = -248\n",src);
	sprintf(src,"%s		sub		R12,R12,#7\n",src);
	sprintf(src,"%s		ldr		PC,[R9,R0,lsl #2]\n",src);


	sprintf(src,"%s30		;not_aligned8_C\n",src);
//aligned on 3
	sprintf(src,"%s		cmp		R3,#0\n",src);
	sprintf(src,"%s		bne		%%f31		;flip_not0_not_aligned8_C\n",src);
	sprintf(src,"%s		ldr		R9,= jumptable_ppu803\n",src);
	sprintf(src,"%s		ldrb	R0,[R10],#1\n",src);
	sprintf(src,"%s		orr		R0,R0,R6\n",src);
	sprintf(src,"%s		ldr		R7, = 248\n",src);
	sprintf(src,"%s		ldr		PC,[R9,R0,lsl #2]\n",src);
	sprintf(src,"%s31		;flip_not0_not_aligned8_C\n",src);
	sprintf(src,"%s		cmp		R3,#1\n",src);
	sprintf(src,"%s		bne		%%f32		;flip_not1_not_aligned8_C\n",src);	
	sprintf(src,"%s		ldr		R9,= jumptable_ppu810\n",src);
	sprintf(src,"%s		ldrb	R0,[R10],#1\n",src);
	sprintf(src,"%s		orr		R0,R0,R6\n",src);
	sprintf(src,"%s		ldr		R7, = 232\n",src);	
	sprintf(src,"%s		sub		R12,R12,#7\n",src);	
	sprintf(src,"%s		ldr		PC,[R9,R0,lsl #2]\n",src);
	sprintf(src,"%s32		;flip_not1_not_aligned8_C\n",src);
	sprintf(src,"%s		cmp		R3,#2\n",src);
	sprintf(src,"%s		bne		%%f33		;flip_not2_not_aligned8_C\n",src);
	sprintf(src,"%s		ldr		R9,= jumptable_ppu803\n",src);
	sprintf(src,"%s		ldrb	R0,[R10],#1\n",src);
	sprintf(src,"%s		orr		R0,R0,R6\n",src);
	sprintf(src,"%s		ldr		R7, = -232\n",src);	
	sprintf(src,"%s		ldr		PC,[R9,R0,lsl #2]\n",src);
	sprintf(src,"%s33		;flip_not2_not_aligned8_C\n",src);
	sprintf(src,"%s		ldr		R9,= jumptable_ppu810\n",src);
	sprintf(src,"%s		ldrb	R0,[R10],#1\n",src);
	sprintf(src,"%s		orr		R0,R0,R6\n",src);
	sprintf(src,"%s		ldr		R7, = -248\n",src);
	sprintf(src,"%s		sub		R12,R12,#7\n",src);
	sprintf(src,"%s		ldr		PC,[R9,R0,lsl #2]\n",src);
	sprintf(src,"%s		MEND\n\n\n",src);


	
	sprintf(src,"%s;;main funcs\n",src);
	sprintf(src,"%sasmDrawTile8	PROC\n",src);
	sprintf(src,"%s;; asmDrawTile( cache,solidbuf,OffsetGP32,Flip) \n",src);
	sprintf(src,"%s;;               R0    R1       R2         R3 \n",src);
	sprintf(src,"%s;; Flip : 0,1,2,3 -> None,VFLIP,HFLIP,VFLIP&HFLIP \n",src);
	sprintf(src,"%s		stmfd		R13!,{R4-R11}\n",src);
	sprintf(src,"%s		mov		R12,R2\n",src);
	sprintf(src,"%s		mov		R10,R0\n",src);	
	sprintf(src,"%s		add		R11,R0,#8\n",src);	
	sprintf(src,"%s		mov		R8,#8\n",src);
	sprintf(src,"%s		mov		R6,R1\n",src);	

	sprintf(src,"%s		INIT_TILER8\n",src);	
	
	sprintf(src,"%s	ENDP\n\n",src);

	sprintf(src,"%sasmDrawTileClipped8	PROC\n",src);
	sprintf(src,"%s		;; asmDrawTileClipped( cache,start<<16 width<<8 solidbuf,OffsetGP32,Flip) \n",src);
	sprintf(src,"%s		;;                      R0             R1                 R2         R3 \n",src);
	sprintf(src,"%s		;; Flip : 0,1,2,3 -> None,VFLIP,HFLIP,VFLIP&HFLIP \n\n",src);
	sprintf(src,"%s		stmfd		R13!,{R4-R11}\n",src);
	sprintf(src,"%s		mov		R12,R2\n",src);
	sprintf(src,"%s		mov		R10,R0\n",src);
	sprintf(src,"%s		add		R11,R0,#8\n\n",src);
		
	sprintf(src,"%s		mov		R0,R1,lsr #8\n",src);
	sprintf(src,"%s		and		R8,R0,#0xFF				\n",src);
	sprintf(src,"%s		mov		R0,R0,lsr #8			\n",src);
	sprintf(src,"%s		add		R10,R10,R0\n",src);
	sprintf(src,"%s		add		R11,R11,R0,lsl #3\n\n",src);		
	sprintf(src,"%s		and		R6,R1,#0xFF\n\n",src);

	sprintf(src,"%s		INIT_TILER8\n",src);	
		
	
	sprintf(src,"%s		ENDP\n\n",src);

	sprintf(src,"%s	LTORG\n\n",src);
}

void draw_pix(char *src,int skipval,int flipping)
{
	if (flipping&1)
		sprintf(src,"%s		ldrh	R0,[R11,#%d]\n		strh	R0,[R12,#-%d]\n",src,skipval,(7-skipval));	
	else	
		sprintf(src,"%s		ldrh	R0,[R11,#%d]\n		strh	R0,[R12,#-%d]\n",src,skipval,skipval);

}

void draw_pix2(char *src,int counter,int count_opaque,int count_transp,int first,int flipping,int align)
{
	int unalignedDes=(align+counter)&3;
	int unalignedSrc=counter&3;
	int to_draw;
	int drawn;
	char reg[3];

	if (first&&counter)
	{
		sprintf(src,"%s		add	R11,R11,#%d\n",src,counter);
		if (flipping&1) sprintf(src,"%s		add	R12,R12,#%d\n",src,counter);
		else sprintf(src,"%s		sub	R12,R12,#%d\n",src,counter);
	}
	
	while (count_opaque)
	{
		if (unalignedSrc)
		{
			if (count_opaque>1) 
			{				
				sprintf(src,"%s		ldrb	R0,[R11],#1\n",src);
				sprintf(src,"%s		strb	R0,[R12],#%d\n",src,(flipping&1?1:-1));
				unalignedSrc++;
				unalignedDes+=(flipping&1?1:-1);
			}
			else 
			{
				sprintf(src,"%s		ldrb	R0,[R11],#%d\n",src,count_transp+1);
				sprintf(src,"%s		strb	R0,[R12],#%d\n",src,(flipping&1?count_transp*1+1:-(count_transp*1+1)));
				unalignedSrc+=count_transp+1;
				unalignedDes+=(flipping&1?count_transp*1+1:-(count_transp*1+1));
			}
			count_opaque--;
			
			unalignedSrc&=3;			
			unalignedDes&=3;
		}
		else
		{
			to_draw=count_opaque;
			switch (count_opaque)
			{
				case 8:
					sprintf(src,"%s		ldmia	R11!,{R0,R1}\n",src);					
					break;
				case 7:
					if (count_transp)
					{
						//count_transp=1 for sure
						sprintf(src,"%s		ldmia	R11!,{R0,R1}\n",src);						
					}
					else
					{
						sprintf(src,"%s		ldmia	R11,{R0,R1}\n",src);
						sprintf(src,"%s		add	R11,R11,#%d\n",src,7);
					}
					break;
				case 6:
					sprintf(src,"%s		ldmia	R11,{R0,R1}\n",src);
					sprintf(src,"%s		add		R11,R11,#%d\n",src,count_transp+6);					
					break;
				case 5:
					sprintf(src,"%s		ldmia	R11,{R0,R1}\n",src);
					sprintf(src,"%s		add		R11,R11,#%d\n",src,count_transp+5);
					break;
				case 4:
					if (count_transp)
					{
						sprintf(src,"%s		ldmia	R11,{R0}\n",src);
						sprintf(src,"%s		add		R11,R11,#%d\n",src,count_transp+4);
					}
					else sprintf(src,"%s	ldmia	R11!,{R0}\n",src);
					
					break;
				case 3:
					sprintf(src,"%s		ldmia	R11,{R0}\n",src);
					sprintf(src,"%s		add		R11,R11,#%d\n",src,count_transp+3);
					break;
				case 2:
					if (count_transp) 
					{
						sprintf(src,"%s		ldrh	R0,[R11]\n",src);
						sprintf(src,"%s		add		R11,R11,#%d\n",src,count_transp+2);
					}
					else sprintf(src,"%s	ldrh	R0,[R11]!\n",src);
					
					break;
				case 1:
					if (count_transp)
					{
						sprintf(src,"%s		ldrb	R0,[R11]\n",src);
						sprintf(src,"%s		add		R11,R11,#%d\n",src,count_transp+1);
					}
					else sprintf(src,"%s	ldrb	R0,[R11]!\n",src);
					break;
			}
			count_opaque=0;

			
			sprintf(reg,"R0");
			drawn=0;						
			while ( ( unalignedDes || (!(flipping&1)) )  &&(drawn<to_draw))
			{				
				if (drawn==(to_draw-1))  
				{
					sprintf(src,"%s		strb	%s,[R12],#%d\n",src,reg,(flipping&1?1+count_transp:-1-count_transp));
					unalignedDes+=(flipping&1?1+count_transp:-1-count_transp);
				}
				else 
				{
					sprintf(src,"%s		strb	%s,[R12],#%d\n",src,reg,(flipping&1?1:-1));
					unalignedDes+=(flipping&1?1:-1);
				}
				drawn++;
				
				if (drawn<to_draw)
				{
					if (drawn==4) sprintf(reg,"R1");
					else sprintf(src,"%s		mov		%s,%s,lsr #8\n",src,reg,reg); 
				}
				
				unalignedDes&=3;
			}			
			to_draw-=drawn;			
			
			switch (to_draw)
			{
			case 8:
				// cas 8 align des le depart
				if (flipping&1)
				{
					sprintf(src,"%s		stmia	R12!,{R0,R1}\n",src);
				}
				break;
			case 7:
			
				if (flipping&1)
				{
					if (drawn)
					{  //cas 8 a dessiner, 1 etait non align
						sprintf(src,"%s		orr		R0,R0,R1,lsl #24\n",src);
						sprintf(src,"%s		mov		R1,R1,lsr #8\n",src);						
					}
					
					//cas 7 a dessiner, align des le dpart						
					sprintf(src,"%s		str		R0,[R12],#4\n",src);
					sprintf(src,"%s		strh	R1,[R12],#2\n",src);
					sprintf(src,"%s		mov		R1,R1,lsr #16\n",src);
					sprintf(src,"%s		strb	R1,[R12],#%d\n",src,1+count_transp);										
				}
				break;
			case 6:					
				if (flipping&1)
				{					
					switch (drawn)
					{
						case 2:
							sprintf(src,"%s		orr		R0,R0,R1,lsl #16\n",src);
							sprintf(src,"%s		mov		R1,R1,lsr #16\n",src);
							break;
						case 1:
							sprintf(src,"%s		orr		R0,R0,R1,lsl #24\n",src);
							sprintf(src,"%s		mov		R1,R1,lsr #8\n",src);
							break;
					}
					//cas 6 a dessiner, align des le dpart						
					sprintf(src,"%s		str		R0,[R12],#4\n",src);						
					sprintf(src,"%s		strh	R1,[R12],#%d\n",src,2+count_transp);						
				}
				break;
			case 5:	
				if (flipping&1)
				{
					switch (drawn)
					{						
						case 3:
							sprintf(src,"%s		orr		R0,R0,R1,lsl #8\n",src);
							sprintf(src,"%s		mov		R1,R1,lsr #24\n",src);
							break;
						case 2:
							sprintf(src,"%s		orr		R0,R0,R1,lsl #16\n",src);
							sprintf(src,"%s		mov		R1,R1,lsr #16\n",src);
							break;
						case 1:
							sprintf(src,"%s		orr		R0,R0,R1,lsl #24\n",src);
							sprintf(src,"%s		mov		R1,R1,lsr #8\n",src);
							break;
					}
					//cas 4 a dessiner, align des le dpart												
					sprintf(src,"%s		str		R0,[R12],#4\n",src);
					sprintf(src,"%s		strb	R1,[R12],#%d\n",src,1+count_transp);
				}	
				break;
			case 4:
			
				if (flipping&1)
				{
					switch (drawn)
					{
						case 4:							
							break;
						case 3:
							sprintf(src,"%s		orr		R0,R0,R1,lsl #8\n",src);
							//sprintf(src,"%s		mov		R1,R1,lsr #24\n",src);
							break;
						case 2:
							sprintf(src,"%s		orr		R0,R0,R1,lsl #16\n",src);
							//sprintf(src,"%s		mov		R1,R1,lsr #16\n",src);
							break;
						case 1:
							sprintf(src,"%s		orr		R0,R0,R1,lsl #24\n",src);
							//sprintf(src,"%s		mov		R1,R1,lsr #8\n",src);
							break;
					}
					//cas 4 a dessiner, align des le dpart												
					sprintf(src,"%s		str		%s,[R12],#%d\n",src,reg,4+count_transp);						
				}	
				break;
			case 3:		
				if (flipping&1)
				{
					switch (drawn)
					{
						case 5:															
						case 4:							
							break;
						case 3:
							sprintf(src,"%s		orr		R0,R0,R1,lsl #8\n",src);
							//sprintf(src,"%s		mov		R1,R1,lsr #24\n",src);
							break;
						case 2:
							sprintf(src,"%s		orr		R0,R0,R1,lsl #16\n",src);
							//sprintf(src,"%s		mov		R1,R1,lsr #16\n",src);
							break;
						case 1:
							//sprintf(src,"%s		orr		R0,R0,R1,lsl #24\n",src);
							//sprintf(src,"%s		mov		R1,R1,lsr #8\n",src);
							break;
					}
					 //cas 3 a dessiner, align des le dpart												
					sprintf(src,"%s		strh	%s,[R12],#2\n",src,reg);
					sprintf(src,"%s		mov		%s,%s,lsr #16\n",src,reg,reg);
					sprintf(src,"%s		strb	%s,[R12],#%d\n",src,reg,1+count_transp);
				}	
				break;
			case 2:
		
				if (flipping&1)
				{
					switch (drawn)
					{
						case 6:						
						case 5:					
						case 4:							
							break;
						case 3:
							sprintf(src,"%s		orr		R0,R0,R1,lsl #8\n",src);
							//sprintf(src,"%s		mov		R1,R1,lsr #24\n",src);
							break;
						case 2:
							//sprintf(src,"%s		orr		R0,R0,R1,lsl #16\n",src);
							//sprintf(src,"%s		mov		R1,R1,lsr #16\n",src);
							break;
						case 1:
							//sprintf(src,"%s		orr		R0,R0,R1,lsl #24\n",src);
							//sprintf(src,"%s		mov		R1,R1,lsr #8\n",src);
							break;
					}
					//cas 6 a dessiner, align des le dpart										
					sprintf(src,"%s		strh	%s,[R12],#%d\n",src,reg,2+count_transp);						
				}	
				break;
			case 1:	
				
				if (flipping&1)
				{
					//cas 6 a dessiner, align des le dpart										
					sprintf(src,"%s		strb	%s,[R12],#%d\n",src,reg,1+count_transp);
				}
				break;			
			

			}

			
		}
	}		
}

char *generate_code8(char *filename)
{
	int mode;
	char *code_src;
	int count_transp,count_opaque,shifter,counter,flipping,cur_align,dep_align,first;
	char moving_char[4]={'-','\\','|','/'};
	FILE *f;


	f=fopen(filename,"w+t");
	
		
	code_src=malloc(4*1024*1024); //4*Mo of text data should be enough
	code_src[0]=0;
	func_base(code_src);
	//mode 0 is fully opaque
	//mode 0xFF is fully transparent
	
	for (dep_align=0;dep_align<=3;dep_align++)
	{		
		for (flipping=0;flipping<=1;flipping++)
		{
			printf("\ngenerating align:%d / flipping:%s  ",dep_align,(flipping&1?"on":"off"));
			for (mode=0;mode<=0xFF;mode++)		
			{	
				if (mode==0x80)
				{
					fprintf(f,"%s\n",code_src);
					code_src[0]=0;
				}

				if (!(mode&3))
					printf("\b%c",moving_char[(mode>>2)&3]);

				func_begin(code_src,mode,flipping,dep_align);
				
				shifter=7;
				counter=0;
				first=1;
				//cherche le 1er pix opaque
				while ((shifter>=0)&&( (mode>>shifter)&1 ) )
				{
					shifter--;
					counter++;
				}
				if (shifter>=0) sprintf(code_src,"%s;;mode : %c%c%c%c%c%c%c%c => first pix:%d\n",code_src,
					48+((mode>>7)&1),48+((mode>>6)&1),48+((mode>>5)&1),48+((mode>>4)&1),
					48+((mode>>3)&1),48+((mode>>2)&1),48+((mode>>1)&1),48+((mode>>0)&1),
					counter);
				while (shifter>=0)
				{
					count_opaque=0;
					//on compte le nombre de pix opaque
					while ((shifter>=0)&&(!((mode>>shifter)&1)))
					{
						count_opaque++;
						shifter--;
					}
					count_transp=0;
					
					while ((shifter>=0)&&((mode>>shifter)&1))
					{
						count_transp++;
						shifter--;
					}
					
					sprintf(code_src,"%s	;;Pos : %d, Pix opaque : %d, Pix transp : %d\n",code_src,counter,count_opaque,count_transp);
					draw_pix2(code_src,counter,count_opaque,count_transp,first,flipping,dep_align);
					counter+=count_opaque+count_transp;
					first=0;
				}				

				func_end(code_src,mode,flipping);
			}
			func_index(code_src,flipping,dep_align);
			fprintf(f,"%s\n",code_src);
			code_src[0]=0;
		}
	}
	sprintf(code_src,"%s		END\n",code_src);

	fprintf(f,"%s",code_src);

	fclose(f);

	return code_src;
}

void show(char *src)
{
	printf("%s",src);
}

void pause(void)
{
	printf("Press [enter]...");
	getchar();
}

void main(int argc,char **argv)
{	
	generate_code8("ppuasmfunc8.S");

//	pause();
}