		AREA    arm65C816asm, CODE, READONLY

;		EXPORT
; ==========================================================================================================
;    PROJECT MANAGEMENT
;    PROJECT MANAGEMENT
;    PROJECT MANAGEMENT
; ==========================================================================================================


;//TO DO :
;//- Logic to swap AL / AW / AH when changing the CPU mode., also for X,Y
;//- CPU Shutdown ?
;//- A_ROL16,A_ROL8
;//- A_ROR16,A_ROR8
;//- ROL16, ROL8
;//- ROR8, ROR16
;//- ADC16, SBC16, SBC8
;//- ADC8 : serious check
;//- Op40 : to finish
;//- BIT16 and BIT8 : C original code seems strange for setting snes N flag.
;//- S9xGetWordRegStatus	in:rscratch (0x00hhmmll) out:reg      (0xhhll0000)
;//- S9xGetByteRegStatus 	in:rscratch (0x00hhmmll) out:reg      (0xll000000)
;//- S9xGetWordReg reg 		in:rscratch (0x00hhmmll) out:reg      (0xhhll0000)
;//- S9xGetByteReg reg 		in:rscratch (0x00hhmmll) out:reg      (0xll000000)
;//- S9xGetWord 		in:rscratch (0x00hhmmll) out:rscratch (0xhhll0000)
;//- S9xGetByte 		in:rscratch (0x00hhmmll) out:rscratch (0xll000000)
;//- S9xGetWordLow		in:rscratch (0x00hhmmll) out:rscratch (0x0000hhll)
;//- S9xGetWordLowReg		in:rscratch (0x00hhmmll) out:reg      (0x0000hhll)

;//- S9xSetWord			in:scratch2 (0xhhll0000) in:scratch   (0x00hhmmll)
;//- S9xSetByte			in:scratch2 (0xll000000) in:scratch   (0x00hhmmll)
;//- S9xSetByteZero		in:scratch  (0x00hhmmll)
;//- S9xSetWordZero		in:scratch  (0x00hhmmll)
;//- S9xSetWordLow		in:scratch2 (0x0000hhll) in:scratch   (0x00hhmmll)
;//- S9xSetByteLow		in:scratch2 (0x0000ll00) in:scratch   (0x00hhmmll)
;//- SetCarry
;//- CheckEmulation():boolean
;//- SetFlags (xx);
;//- SetIRQ
;//- CheckIRQ
;//- S9xFixCycles()
;//- CheckIndex ():boolean
;//- BranchCheck0
;//- BranchCheck1
;//- BranchCheck2
;//- PushB
;//- PushW
;//- PushBLow
;//- PushWLow
;//S9xOpcode_IRQ
;//S9xOpcode_NMI

			MACRO
$label		ADDONECYCLE
			nop
			MEND
			
			MACRO
$label		ADDTWOCYCLE
			nop
			MEND
			
			MACRO
$label		ADDMEMSPEED1CYCLE
			nop
			MEND						
			
			MACRO
$label		ADDMEMSPEED2CYCLE
			nop
			MEND
			
			MACRO
$label		ADDMEMSPEED
			nop
			MEND
			
			MACRO
$label		ADDMEMSPEED2
			nop
			MEND
			
			MACRO
$label		ADDMEMSPEED3
			nop
			MEND
			

			MACRO
$label		PushBLow	$reg 
			mov			$reg,$reg
			MEND
			
			MACRO
$label		PushWLow	$reg 
			mov			$reg,$reg
			MEND			

			MACRO
$label		ClearDecimal
			nop
			MEND			
			
			MACRO
$label		SetIRQ
			nop
			MEND						
						
			MACRO
$label		CPUShutdown
			nop
			MEND						
			
			MACRO
$label		BranchCheck0
			nop
			MEND									
			
			MACRO
$label		BranchCheck1
			nop
			MEND									
			
			MACRO
$label		BranchCheck2
			nop
			MEND
			
			MACRO
$label		S9xSetPCBase	$reg
			nop
			MEND		
			


;//TODO : OpFC, OpFB, OpE2, OpCB, OpC2, Op9A, Op02, Op00
;//???? : OpF8, OpEA, OpEB, OpE0X1, OpE0X0, OpC9M0, OpC9M1, OpC0X0, OpC0X1

;//R0  (======:	free) (reg
;//R1  R_PCSnes	(rpc)
;//R2  Reg Etat	(rstatus)
;//R3  A / AL /	AH (regA)
;//R4  free
;//R5  X (regX)
;//R6  Y (regY)
;//R7  DataBank	(data reg ?) (regDBank)
;//R8  DirectD (regD)
;//R9  ProgramBank (regPBank)
;//R10 Stack (regS)
;//R11 Opcode /	OpAddress / (regOpcode/rscratch/rsOpAddress)
;//R12 Adresse PC base snes. regpcbase
;//R13 reg struct
;//R14 (======:	free)<-- stack if we need to switch.
;//
;//note	: if AND rn,rn,	#0xffff	or AND rn,rn,#0xFFFFFF is not possible.
;//	  instead of running two instruction and load the value, do :
;//	  (2 cycles exec + 2 Cycle load)
;//	  MOV	rn, rn 	LSL #16
;//	  MOV	rn, rn	LSR #16
;//
;//	  probably better than the following : eliminate a bus load (2 instr+data) and a register use
;//	  (2 cycles exec + 3 cycle load)
;//	  LDRW	rn, =constant from memory
;//	  AND	rm, rm,	rn

;//To check : x,y upper	side of	register.
;//To check : access to	L or H in 16 bit mode for A,X,Y
;//SETBYTE and SETWORD use 0xHHLLxxxx format.
;//Alignment in	return of GetByte and SetByte
;//all the ????	mark
;//register overwrite issues.
;//ADC8	/ ADC16	/ ...	  (grosse instruction)

rpc				RN R1;
rstatus			RN R2;
regA			RN R3;	;//format : 0xhhll0000 or 0xll000000
regX			RN R5;	;//format : 0xhhll0000 or 0xll000000
regY			RN R6;	;//format : 0xhhll0000 or 0xll000000
regDBank		RN R7;	;//format : 0x000000ll
regD			RN R8;	;//format : 0x0000hhll
regPBank		RN R9;	;//format : 0x000000ll
regS			RN R10;	;//format : 0x0000hhll

rscratch		RN R11;	;//format : 0xhhll0000 if data and calculation or return of S9XREADBYTE	or WORD
rsOpAddress		RN R11;	;//format : 0x00hhmmll (24 bit)
regopcode		RN R11;	;//format : 0x000000ll

regpcbase		RN R12;	;//??????
regStruct		RN R13;	;//Pointer 32 bit on a struct.
rscratch2		RN R0;	;//format : 0xhhll for calculation and value
rscratch3		RN R4;	;//??????
rscratch4		RN R14;	;//stack if needed to switch


ANDMASK_EMULATION	EQU 256
;#define Carry       1
;#define Zero        2
;#define IRQ         4
;#define Decimal     8
;#define IndexFlag  16
;#define MemoryFlag 32
;#define Overflow   64
;#define Negative  128
;#define Emulation 256


; ==========================================================================================================
;    ASM CODE START
;    ASM CODE START
;    ASM CODE START
; ==========================================================================================================


			MACRO
$label			UPDATE_C
			; CC : ARM Carry Clear
			ANDCC	rstatus, rstatus, #ANDSETMASK_CARRY  ;	0 : AND	mask 11111011111 : set C to zero
			; CS : ARM Carry Set
			ORRCS	rstatus, rstatus, #ORMASK_CARRY      ;	1 : OR	mask 00000100000 : set C to one
			MEND


			MACRO
$label			UPDATE_ZN
			; NE : ARM Zero Clear
			ANDNE	rstatus, rstatus, #ANDSETMASK_ZERO	 ; 0 : AND mask	11111011111 : set Z to zero
			; EQ : ARM Zero Set
			ORREQ	rstatus, rstatus, #ORMASK_ZERO	 ; 1 : OR  mask	00000100000  : set Z to	one

			; PL : ARM Neg Clear
			ANDPL	rstatus, rstatus, #ANDSETMASK_NEG	; 0 : AND mask 11111011111 : set N to zero
			; MI : ARM Neg Set
			ORRMI	rstatus, rstatus, #ORMASK_NEG	; 1 : OR  mask 00000100000 : set N to one
			MEND

			MACRO
$label			A_ASL8
			; 7	instr
			ADDONECYCLE
			MOVS	regA, regA LSL #1
			UPDATE_C
			UPDATE_ZN
			MEND


			MACRO
$label			A_ASL16
			; 7	instr
			ADDONECYCLE
			MOVS	regA, regA LSL #1
			UPDATE_C
			UPDATE_ZN
			MEND

			MACRO
$label			A_INC8
			ADDONECYCLE
			ADDS	regA, regA, #0x01000000
			UPDATE_ZN
			MEND

			MACRO
$label			A_INC16
			ADDONECYCLE
			ADDS	regA, regA, #0x00010000
			UPDATE_ZN
			MEND

			MACRO
$label			A_DEC8
			ADDONECYCLE
			SUBS	regA, regA, #0x01000000
			UPDATE_ZN
			MEND

			MACRO
$label			A_DEC16
			ADDONECYCLE
			SUBS 	regA, regA, #0x00010000
			UPDATE_ZN
			MEND

			MACRO
$label			A_LSR8
			ADDONECYCLE
			;
			TST	regA, #0x01000000
			; Low bit is 0
			ANDEQ	rstatus, rstatus, #ANDSETMASK_CARRY  ; 0 :	AND mask 11111011111 : set C to	zero
			; Low bit is 1
			ORRNE	rstatus, rstatus, #ORMASK_CARRY	  ; 1 :	OR  mask 00000100000 : set C to	one

			; N	is zero	obviously , .AL	defined	as U8, with arithmetic or logical shift	: 0
			AND	rstatus, rstatus, #ANDSETMASK_NEG	 ; 0 : AND mask	11111011111 : set N to zero
			MOVS	regA, regA LSR #25		 ; llllllll 00000000 00000000 00000000 -> 00000000 00000000 00000000 0lllllll
			; Update Zero
			ANDNE	rstatus, rstatus, #ANDSETMASK_ZERO	 ; 0 : AND mask	11111011111 : set Z to zero
			MOV	regA, regA LSL #24			; -> 00000000 00000000 00000000	0lllllll
			ORREQ	rstatus, rstatus, #ORMASK_ZERO	 ; 1 : OR  mask	00000100000  : set Z to	one
			; Note : the two MOV are included between instruction, to optimize
			; the pipeline.
			MEND

			MACRO
$label			A_LSR16
			ADDONECYCLE
			TST	regA, #0x00010000
			ANDEQ	rstatus, rstatus, #ANDSETMASK_CARRY  ; 0 :	AND mask 11111011111 : set C to	zero
			ORRNE	rstatus, rstatus, #ORMASK_CARRY	  ; 1 :	OR  mask 00000100000 : set C to	one

			AND	rstatus, rstatus, #ANDSETMASK_NEG	 ; 0 : AND mask	11111011111 : set N to zero
			MOVS	regA, regA LSR #17		 ; hhhhhhhh llllllll 00000000 00000000 -> 00000000 00000000 0hhhhhhh hlllllll
			; Update Zero
			ANDNE	rstatus, rstatus, #ANDSETMASK_ZERO	 ; 0 : AND mask	11111011111 : set Z to zero
			MOV	regA, regA LSL #16			; -> 0lllllll 00000000 00000000	00000000
			ORREQ	rstatus, rstatus, #ORMASK_ZERO	 ; 1 : OR  mask	00000100000  : set Z to	one
			; Note : the two MOV are included between instruction, to optimize
			; the pipeline.
			MEND

			MACRO
$label			ADC8
			; 1	call
			; +	25 - 27	instruction in decimal mode
			; +	22 - 19	instruction in non decimal mode
			; Not really optimized, could be better if understood
			;
			; Work8 = S9xGetByte (OpAddress);
			S9xGetByte
			; regscratch now contains Work8

			; if (CheckDecimal ())
			TST	rstatus,	#MASKCHECKDECIMAL
			BEQ	$label.isnotdecimal

			; a1 = regA	& 0x0f + Work8 & 0x0f
			MOV	rscratch2, regA LSL #4
			ADD	rscratch2, rscratch2, rscratch LSL #4
			; May need a SWP if	R14 is used
			; a2 = regA	0xf0 >>	4
			MOV	r14, regA LSR #28
			; a1 += CheckCarry()
			TST	rstatus, #MASKCHECK_CARRY
			ADDNE	rscratch2, rscratch2, #0x01000000
			; if a1 > 9
			CMP	rscratch2, #0x90000000
			; then a1 -= 10
			SUBGT	rscratch2, rscratch2, #0x0A000000
			; then a2++
			ADDGT	r14, r14, #1

			; a2 += (Work8 >> 4) & 0xf
			ADDS	r14, r14, rscratch LSR #4
			; if a2 > 9
			CMP	r14, #0x9
			; then a2 -= 10;
			SUBGT	r14, r14, #10
			; then SetCarry()
			ORRGT	rstatus, rstatus, #ORMASK_CARRY	     ; 1 : OR  mask 00000100000	: set C	to one
			; else ClearCarry()
			ANDLE	rstatus, rstatus, #ANDSETMASK_CARRY  ; 0 : AND mask 11111011111	: set C	to zero

			; gather r14 and rscratch2 into ans8
			; r14 : 0x0000000z
			; rscr: 0xm0000000
			; -> 0x000000zm
			MOV	rscratch2, rscratch2 LSR #28
			ORR	scratch2, rscratch2, r14 LSL #4

			; (register.AL ^ Work8) = 0, not(x)	= 1, z=1, EQ executed
			EORS	r14, regA, rscratch LSL #24
			; (Work8 ^ Ans8)
			ANDNE	rstatus, rstatus, #ANDSETMASK_OVERFLOW	; 0 : AND mask 11111011111 : set C to zero
			BNE	$label.jump1adc8
			EOREQ	r14, rscratch2, rscratch
			TSTEQ	r14, #0x80
			ORRNE	rstatus, rstatus, #ORMASK_OVERFLOW	; 1 : OR  mask 00000100000 : set C to one
$label.jump1adc8
			MOVS	regA, rscratch2 LSL #24
			UPDATE_ZN
			B		$label.endadc8
$label.isnotdecimaladc8
			; ans16  = regAL + Work8
			;
			ADD	rscratch2, regA LSR #1
			ADD	rscratch2, rscratch2, rscratch LSL #23
			; ans16 += Carry()
			TST	rstatus,	#MASKCHECK_CARRY
			ADDNE	rscratch2, rscratch2, #0x00800000
			MOVEQ	rscratch2, rscratch2, #0x00000000
			;ICPU._Carry = Ans16 >=	0x100; ;//??????????
			CMP	rscratch2, #0x800
			ANDLT	rstatus, rstatus, #ANDSETMASK_OVERFLOW	     ; 0 : AND mask 11111011111	: set C	to zero
			ORRGE	rstatus, rstatus, #ORMASK_OVERFLOW	     ; 1 : OR  mask 00000100000	: set C	to one

			MOV	rscratch2, rscratch LSL #1		     ; (u8)Ans16 -> 0xdd000000

			; (register.AL ^ Work8) = 0, not(x)	= 1, z=1, EQ executed
			EORS	r14, regA, rscratch LSL #24
			; ClearOverflow
			ANDNE	rstatus, rstatus, #ANDSETMASK_OVERFLOW	     ; 0 : AND mask 11111011111	: set C	to zero
			BNE	$label.jump2adc8
			; and if (Work8^Ans16) & 0x80
			EOREQS	r14, rscratch2, rscratch	LSL #24
			; =	1 -> SetOverFlow
			ORRMI	rstatus, rstatus, #ORMASK_OVERFLOW	     ; 1 : OR  mask 00000100000	: set C	to one
			ANDPL	rstatus, rstatus, #ANDSETMASK_OVERFLOW	     ; 0 : AND mask 11111011111	: set C	to zero
$label.jump2adc8
			MOVS	regA, rscratch2
			UPDATE_ZN
$label.endadc8
			; finish
			MEND

			MACRO
$label			ADC16
;			Work16 = S9xGetWord	(OpAddress);

;			if (CheckDecimal ())
;			{
			; A1 = (Registers.A.W) & 0xF; A2 = (Registers.A.W >> 4)	& 0xF; A3 = (Registers.A.W >> 8) & 0xF;A4 = (Registers.A.W >> 12) & 0xF;
			; W1 = Work16 &	0xF; W2	= (Work16 >> 4)	& 0xF; W3 = (Work16 >> 8) & 0xF; W4 = (Work16 >> 12) & 0xF;
			; 0x0d0d0d0d ( <- a4, a3, a2, a1 )
			; 0x0p0p0p0p ( <- w4  w3  w2  w1
			; a	+ b + CheckCarry() (0x1/0x0)
			; CMP #0x09000000, Ref<<24
			; SUBGT Ref, Ref, #0x000A
			; ADDGT Ref, Ref, #0x0100
			; -> Combine into one add
			; CMP #0x09000000, Ref<<16
			; SUBGT Ref, Ref, #0x0A00
			; ADDGT Ref, Ref, #0x010000
			; CMP #0x09000000, Ref<<8
			; SUBGT Ref, Ref, #0x0A0000
			; ADDGT Ref, Ref, #0x01000000
			; CMP #0x09000000, Ref
			; SUBGT Ref, Ref, #0x0A000000
			; SetCarryGT
			; ClearCarryLE
			; 0x0a0b0c0d -> 0x0000abcd
;			Ans16 =	(A4 << 12) | (A3 << 8) | (A2 <<	4) | (A1);
;			if (~(Registers.A.W ^ Work16) &
;			(Work16 ^ Ans16) & 0x8000)
;			SetOverflow();
;			else
;			ClearOverflow();
;			Registers.A.W =	Ans16;
;			SetZN16	(Registers.A.W);
;			}
;			else
;			{
;			Ans32 =	Registers.A.W +	Work16 + CheckCarry();

;			ICPU._Carry = Ans32 >= 0x10000;

;			if (~(Registers.A.W ^ Work16) &
;			(Work16 ^ (uint16) Ans32) &	0x8000)
;			SetOverflow();
;			else
;			ClearOverflow();
;			Registers.A.W =	(uint16) Ans32;
;			SetZN16	(Registers.A.W);
;			}

			MEND

			MACRO
$label			AND16
			S9xGetWord
			ANDS	regA, rscratch
			UPDATE_ZN
			MEND

			MACRO
$label			AND8
			S9xGetByte
			ANDS	regA, rscratch
			UPDATE_ZN
			MEND

			MACRO
$label			ASL16
			ADDONECYCLE
			S9xGetWordReg rscratch2	      ;	do not destroy Opadress	in rscratch
			MOVS	scratch2, rscratch2 LSL #1
			UPDATE_C
			UPDATE_ZN
			S9xSetWord rscratch2, rscratch
			MEND

			MACRO
$label			ASL8
			ADDONECYCLE
			S9xGetByteReg rscratch2	      ;	do not destroy Opadress	in rscratch
			MOVS	scratch2, rscratch2 LSL #1
			UPDATE_C
			UPDATE_ZN
			S9xSetByte rscratch2, rscratch
			MEND

			MACRO
$label			BIT8
			S9xGetByte

			MOVS	scratch2, rscratch LSL #1
			; Trick in ASM : shift one more bit	: ARM C	= Snes N
			;					  ARM N	= Snes V

			; If Carry Set, then Set Neg in SNES
			ANDCC	rstatus, rstatus, #ANDSETMASK_NEG	; 0 : AND mask 11111011111 : set C to zero
			ORRCS	rstatus, rstatus, #ORMASK_NEG	; 1 : OR  mask 00000100000 : set C to one
			; If Neg Set, then Set Overflow in SNES
			ANDPL	rstatus, rstatus, #ANDSETMASK_OVERFLOW  ; 0 : AND mask 11111011111	: set N	to zero
			ORRMI	rstatus, rstatus, #ORMASK_OVERFLOW	     ; 1 : OR  mask 00000100000	: set N	to one

			; Now do a real AND	with A register
			; Set Zero Flag, bit test
			ANDS	regA,    rscratch
			ANDNE	rstatus, rstatus, #ANDSETMASK_ZERO	 ; 0 : AND mask	11111011111 : set Z to zero
			ORREQ	rstatus, rstatus, #ORMASK_ZERO	 ; 1 : OR  mask	00000100000  : set Z to	one
			MEND

			MACRO
$label			BIT16
			S9xGetWord

			MOVS	scratch2, rscratch LSL #1
			; Trick in ASM : shift one more bit	: ARM C	= Snes N
			;					  ARM N	= Snes V

			; If Carry Set, then Set Neg in SNES
			ANDCC	rstatus, rstatus, #ANDSETMASK_NEG	; 0 : AND mask 11111011111 : set N to zero
			ORRCS	rstatus, rstatus, #ORMASK_NEG	; 1 : OR  mask 00000100000 : set N to one
			; If Neg Set, then Set Overflow in SNES
			ANDPL	rstatus, rstatus, #ANDSETMASK_OVERFLOW  ; 0 : AND mask 11111011111	: set V	to zero
			ORRMI	rstatus, rstatus, #ORMASK_OVERFLOW	     ; 1 : OR  mask 00000100000	: set V	to one

			; Now do a real AND	with A register
			; Set Zero Flag, bit test
			ANDS	regA,    rscratch
			; Bit set  ->Z=0->xxxNE Clear flag
			ANDNE	rstatus, rstatus, #ANDSETMASK_ZERO	 ; 0 : AND mask	11111011111 : set Z to zero
			; Bit clear->Z=1->xxxEQ Set flag
			ORREQ	rstatus, rstatus, #ORMASK_ZERO	 ; 1 : OR  mask	00000100000  : set Z to	one
			MEND

			MACRO
$label			CMP8
			S9xGetByte
			SUBS	rscratch, regA, rscratch  ; see comment CMP16,	no prob	here with garbage in low bits
			; <	0   Flag Carry Clear
			ANDLT	rstatus, rstatus, #ANDSETMASK_CARRY  ; 0 :	AND mask 11111011111 : set C to	zero
			; >=0   > Flag Carry Set
			ORRGE	rstatus, rstatus, #ORMASK_CARRY	  ; 1 :	OR  mask 00000100000 : set C to	one
			UPDATE_ZN
			MEND

			MACRO
$label			CMP16
			S9xGetWord
			SUBS	rscratch, regA, rscratch  ; rscratch could be parasited	by 0xdddd fffff	<- low bit to 1, but not rscratch not save,OK
			; <	0   Flag Carry Clear
			ANDLT	rstatus, rstatus, #ANDSETMASK_CARRY  ; 0 :	AND mask 11111011111 : set C to	zero
			; >=0   > Flag Carry Set
			ORRGE	rstatus, rstatus, #ORMASK_CARRY	  ; 1 :	OR  mask 00000100000 : set C to	one
			UPDATE_ZN
			MEND

			MACRO
$label			CMX16
			S9xGetWord
			SUBS	rscratch, regX, rscratch      ; See CMP16 comment, same.
			; <	0   Flag Carry Clear
			ANDLT	rstatus, rstatus, #ANDSETMASK_CARRY  ; 0 :	AND mask 11111011111 : set C to	zero
			; >=0   > Flag Carry Set
			ORRGE	rstatus, rstatus, #ORMASK_CARRY	  ; 1 :	OR  mask 00000100000 : set C to	one
			UPDATE_ZN
			MEND

			MACRO
$label			CMX8
			S9xGetByte
			SUBS	rscratch, regX, rscratch      ; See CMP16 comment, same
			; <	0   Flag Carry Clear
			ANDLT	rstatus, rstatus, #ANDSETMASK_CARRY  ; 0 :	AND mask 11111011111 : set C to	zero
			; >=0   > Flag Carry Set
			ORRGE	rstatus, rstatus, #ORMASK_CARRY	  ; 1 :	OR  mask 00000100000 : set C to	one
			UPDATE_ZN
			MEND

			MACRO
$label			CMY16
			S9xGetWord
			SUBS	rscratch, regY, rscratch      ; CMP16 Comment
			; <	0   Flag Carry Clear
			ANDLT	rstatus, rstatus, #ANDSETMASK_CARRY  ; 0 :	AND mask 11111011111 : set C to	zero
			; >=0   > Flag Carry Set
			ORRGE	rstatus, rstatus, #ORMASK_CARRY	  ; 1 :	OR  mask 00000100000 : set C to	one
			UPDATE_ZN
			MEND

			MACRO
$label			CMY8
			S9xGetByte
			SUBS	rscratch, regY, rscratch      ; CMP16 Comment
			; <	0   Flag Carry Clear
			ANDLT	rstatus, rstatus, #ANDSETMASK_CARRY  ; 0 :	AND mask 11111011111 : set C to	zero
			; >=0   > Flag Carry Set
			ORRGE	rstatus, rstatus, #ORMASK_CARRY	  ; 1 :	OR  mask 00000100000 : set C to	one
			UPDATE_ZN
			MEND

			MACRO
$label			DEC16
			; 5	Instruction + 2	Call
			ADDONECYCLE
			S9xGetWordReg rscratch2	       ; do not	destroy	Opadress in rscratch
			SUBS	rscratch2, rscratch2, #0x00010000
			UPDATE_ZN
			S9xSetWord rscratch2, rscratch
			MEND

			MACRO
$label			DEC8
			; 2	call + 5 instructions
			ADDONECYCLE
			S9xGetByteReg rscratch2	       ; do not	destroy	Opadress in rscratch
			SUBS	rscratch2, rscratch2, #0x01000000
			UPDATE_ZN
			S9xSetByte rscratch2, rscratch
			MEND

			MACRO
$label			EOR16
			S9xGetWord
			EORS	regA, regA, rscratch
			UPDATE_ZN
			MEND

			MACRO
$label			EOR8
			; 5	instructions + 1 call
			; Registers.A.L ^= S9xGetByte (OpAddress);
			; SetZN16 (Registers.A.W);
			S9xGetByte
			EORS	regA, regA, rscratch
			UPDATE_ZN
			MEND

			MACRO
$label			INC16
			; 5	instruction + 2	call
			ADDONECYCLE
			S9xGetWordReg rscratch2	       ; do not	destroy	Opadress in rscratch
			ADDS	rscratch2, rscratch2, #0x00010000
			UPDATE_ZN
			S9xSetWord rscratch2, rscratch
			MEND

			MACRO
$label			INC8
			; 5	instruction + 2	call
			ADDONECYCLE
			S9xGetByteReg rscratch2	       ; do not	destroy	Opadress in rscratch
			ADDS	rscratch2, rscratch2, #0x01000000
			UPDATE_ZN
			S9xSetByte rscratch2, rscratch
			MEND

			MACRO
$label			LDA16
			S9xGetWordRegStatus regA
			UPDATE_ZN
			MEND

			MACRO
$label			LDA8
			S9xGetByteRegStatus regA
			UPDATE_ZN
			MEND

			MACRO
$label			LDX16
			S9xGetWordRegStatus RegX
			UPDATE_ZN
			MEND

			MACRO
$label			LDX8
			S9xGetByteRegStatus RegX
			UPDATE_ZN
			MEND

			MACRO
$label			LDY16
			S9xGetWordRegStatus RegY
			UPDATE_ZN
			MEND

			MACRO
$label			LDY8
			S9xGetByteRegStatus RegY
			UPDATE_ZN
			MEND

			MACRO
$label			LSR16
			ADDONECYCLE
			S9xGetWordReg rscratch2
			TST	rscratch2, #0x00010000
			ANDEQ	rstatus, rstatus, #ANDSETMASK_CARRY  ; 0 :	AND mask 11111011111 : set C to	zero
			ORRNE	rstatus, rstatus, #ORMASK_CARRY	  ; 1 :	OR  mask 00000100000 : set C to	one

			; N set to zero by >> 1 LSR
			AND	rstatus, rstatus, #ANDSETMASK_NEG	 ; 0 : AND mask	11111011111 : set N to zero

			MOVS	rscratch2, rscratch2 LSR #17		   ; llllllll 00000000 00000000	00000000 -> 00000000 00000000 00000000 0lllllll
			; Update Zero
			ANDNE	rstatus, rstatus, #ANDSETMASK_ZERO	 ; 0 : AND mask	11111011111 : set Z to zero
			ORREQ	rstatus, rstatus, #ORMASK_ZERO	 ; 1 : OR  mask	00000100000  : set Z to	one
			; No need for MOV is S9xSetWordLow exist.
			; MOV	rscratch2, rscratch2 LSL #16		  ; -> 0lllllll	00000000 00000000 00000000
			S9xSetWordLow rscratch2, rscratch
			MEND

			MACRO
$label			LSR8
			ADDONECYCLE
			S9xGetByteReg rscratch2
			TST	rscratch2,	#0x01000000
			ANDEQ	rstatus,  rstatus,  #ANDSETMASK_CARRY  ; 0 :	AND mask 11111011111 : set C to	zero
			ORRNE	rstatus,  rstatus,  #ORMASK_CARRY	  ; 1 :	OR  mask 00000100000 : set C to	one

			; N is 0 -> LSR 1 is UINT >> 1
			AND	rstatus,   rstatus,  #ANDSETMASK_NEG	 ; 0 : AND mask	11111011111 : set N to zero
			MOVS	rscratch2, rscratch2 LSR #25		   ; llllllll 00000000 00000000	00000000 -> 00000000 00000000 00000000 0lllllll
			; Update Zero
			ANDNE	rstatus,   rstatus,  #ANDSETMASK_ZERO	 ; 0 : AND mask	11111011111 : set Z to zero
			ORREQ	rstatus,   rstatus,  #ORMASK_ZERO	 ; 1 : OR  mask	00000100000  : set Z to	one
			; No need for MOV is S9xSetByteLow exist.
			; MOV	rscratch2, rscratch2 LSL #24		  ; -> 0lllllll	00000000 00000000 00000000
			S9xSetByteLow rscratch2, rscratch
			MEND

			MACRO
$label			ORA16
			S9xGetWord
			ORRS	regA, regA, rscratch
			UPDATE_ZN
			MEND

			MACRO
$label			ORA8
			S9xGetByte
			ORRS	regA, regA, rscratch
			UPDATE_ZN
			MEND

			MACRO
$label			A_ROL16
			; CPU.Cycles +=	ONE_CYCLE;
			ADDONECYCLE
			; Work32 = (Registers.A.W << 1)	| CheckCarry();
			; ICPU._Carry =	Work32 >= 0x10000;
			; Registers.A.W	= (uint16) Work32;
			; SetZN16 ((uint16) Work32);
			; ???? TO DO
			MEND

			MACRO
$label			A_ROL8
			; CPU.Cycles +=	ONE_CYCLE;
			ADDONECYCLE
			; Work32 = (Registers.A.W << 1)	| CheckCarry();
			; ICPU._Carry =	Work32 >= 0x10000;
			; Registers.A.W	= (uint16) Work32;
			; SetZN16 ((uint16) Work32);
			; ???? TO DO
			MEND

			MACRO
$label			STA16
			S9xSetWord	regA,	scratch
			MEND

			MACRO
$label			STA8
			S9xSetByte	regA,	scratch
			MEND

			MACRO
$label			STX16
			S9xSetWord	RegX,	scratch
			MEND

			MACRO
$label			STX8
			S9xSetByte	RegX,	scratch
			MEND

			MACRO
$label			STY16
			S9xSetWord	RegY,	scratch
			MEND

			MACRO
$label			STY8
			S9xSetByte	RegY,	scratch
			MEND

			MACRO
$label			STZ16
			S9xSetWordZero  rscratch
			MEND

			MACRO
$label			STZ8
			S9xSetByteZero  rscratch
			MEND

			MACRO
$label			TSB16
			ADDONECYCLE
			S9xGetWordReg rscratch2
			TST	regA, rscratch2
			ANDNE	rstatus, rstatus, #ANDSETMASK_ZERO	 ; 0 : AND mask	11111011111 : set Z to zero
			ORREQ	rstatus, rstatus, #ORMASK_ZERO	 ; 1 : OR  mask	00000100000  : set Z to	one
			; Work16 |= Registers.A.W;
			ORR	scratch2, regA, rscratch2
			; S9xSetWord (Work16, OpAddress);
			S9xSetWord rscratch2, rscratch
			MEND

			MACRO
$label			TSB8
			; CPU.Cycles +=	ONE_CYCLE;
			ADDONECYCLE
			; Work8	= S9xGetByte (OpAddress);
			; ICPU._Zero = Work8 & Registers.AL; //	Why ?????? Different from TSB16
			; Work8 |= Registers.AL;
			;S9xSetByte (Work8, OpAddress);
			S9xGetByteReg rscratch2
			TST	regA, rscratch2
			ANDNE	rstatus, rstatus, #ANDSETMASK_ZERO	 ; 0 : AND mask	11111011111 : set Z to zero
			ORREQ	rstatus, rstatus, #ORMASK_ZERO	 ; 1 : OR  mask	00000100000  : set Z to	one

			ORR	rscratch2, regA, rscratch2
			; S9xSetWord (Work16, OpAddress);
			S9xSetWord rscratch2, rscratch
			MEND

			MACRO
$label			TRB16
			; CPU.Cycles +=	ONE_CYCLE;
			ADDONECYCLE
			; Work16 = S9xGetWord (OpAddress);
			; ICPU._Zero = (Work16 & Registers.A.W)	!= 0;
			; Work16 &= ~Registers.A.W;
			; S9xSetWord (Work16, OpAddress);
			S9xGetWordReg rscratch2
			TST	r14, regA, rscratch2
			ANDNE	rstatus, rstatus, #ANDSETMASK_ZERO	 ; 0 : AND mask	11111011111 : set Z to zero
			ORREQ	rstatus, rstatus, #ORMASK_ZERO	 ; 1 : OR  mask	00000100000  : set Z to	one
			NOT	r14, regA
			AND	scratch2, r14, rscratch2
			S9xSetWord rscratch2, rscratch
			MEND

			MACRO
$label			TRB8
			; CPU.Cycles +=	ONE_CYCLE;
			; Work8	= S9xGetByte (OpAddress);
			; ICPU._Zero = Work8 & Registers.AL;
			; Work8	&= ~Registers.AL;
			; S9xSetByte (Work8, OpAddress);
			ADDONECYCLE
			S9xGetByteReg rscratch2
			TST	regA, rscratch2
			ANDNE	rstatus, rstatus, #ANDSETMASK_ZERO	 ; 0 : AND mask	11111011111 : set Z to zero
			ORREQ	rstatus, rstatus, #ORMASK_ZERO	 ; 1 : OR  mask	00000100000  : set Z to	one
			NOT	r14, regA
			AND	scratch2, r14, rscratch2
			S9xSetByte rscratch2, rscratch
			MEND

			; Routine
			; ==========================
			; PullB ();
			; PullW ();
			; PushB
			; PushW


			; ===========================================
			; ===========================================
			; Memory Access
			; ===========================================
			; ===========================================
			
			MACRO
$label		S9xGetWordRegStatus	$regaddr,$regstatus
			; in  : rscratch (0x00hhmmll) 
			; out : reg      (0xhhll0000)
			nop
			MEND 
			
 			MACRO 			
$label		S9xGetByteRegStatus	$regaddr,$regstatus
			; in  : rscratch (0x00hhmmll)
			; out : reg      (0xll000000)
			nop
			MEND


			MACRO
$label		S9xGetWord	$regaddr,$regval
			; in  : rscratch (0x00hhmmll)
			; out : rscratch (0xll000000)
			nop			
			MEND
			
			MACRO
$label		S9xGetByte $regaddr,$regval
			; in  : rscratch (0x00hhmmll) 
			; out : rscratch (0xll000000)
			nop
			MEND
									
			
			MACRO
$label		S9xGetWordLow $regaddr,$regval
			; in  : rscratch (0x00hhmmll)
			; out : rscratch (0x0000hhll)
			nop
			MEND
			
			
			MACRO
$label		S9xSetWord $regaddr,$regval
			; in  : scratch2  (0xhhll0000)
			; in  : scratch   (0x00hhmmll)
			nop
			MEND
			
			MACRO
$label		S9xSetByte $regaddr,$regval
			; in  : scratch2  (0xll000000)
			; in  : scratch   (0x00hhmmll)
			nop
			MEND
			
			MACRO
$label		S9xSetByteZero $regaddr
			; in  : scratch  (0x00hhmmll)
			nop
			MEND
			
			MACRO
$label		S9xSetWordZero $regaddr
			; in  : scratch  (0x00hhmmll)
			nop
			MEND
			
			MACRO
$label		S9xSetWordLow $regaddr,$regval
			; in  : scratch2 (0x0000hhll)
			; in  : scratch   (0x00hhmmll)
			nop
			MEND
			
			MACRO
$label		S9xSetByteLow $regaddr,$regval
			; in  : scratch2 (0x0000hhll)
			; in  : scratch   (0x00hhmmll)
			nop
			MEND


			; ===========================================
			; ===========================================
			; Adressing mode
			; ===========================================
			; ===========================================

			MACRO
$label			Absolute
			; 4 instruction
			; OpAddress = *CPU.PC +	(*(CPU.PC + 1) << 8) + ICPU.ShiftedDB;
			; CPU.PC += 2;
			; CPU.Cycles +=	CPU.MemSpeedx2;
			ADDMEMSPEED2
			; Because of ARM Alignment problem we must read	byte by	byte :-(
			LDRB	rscratch    , [rpc, #1]!			; *CPU.PC++
			LDRB	rscratch2   , [rpc, #1]!			; + *CPU.PC++ << 8
			ADD	rscratch    , rscratch,	rscratch2 LSL #8
			ADD	rscratch    , rscratch,	regPBank LSL #16
			MEND

			MACRO
$label			AbsoluteIndexedIndirect
			ADDMEMSPEED2
			; Because of ARM Alignment problem we must read	byte by	byte :-(
			LDRB	rscratch    , [rpc, #1]!			; *CPU.PC++
			LDRB	rscratch2   , [rpc, #1]!			; + *CPU.PC++ << 8
			ADD	rscratch    , rscratch,	rscratch2 LSL #8
			ADD	rscratch    , rscratch,	regX LSR #16			; + Register.X.W
			AND	rscratch    , rscratch,	#0xFFFF			; ?? May be not	possible ??
			ADD	rscratch    , rscratch,	regPBank LSL #16
			S9xGetWordLow						; Call function	or inline
			; rscratch have	value 2	byte. 0x0000hhll
			MEND

			MACRO
$label			AbsoluteIndirectLong
			; 5 + 2xCall
			; OpAddress = *CPU.PC +	(*(CPU.PC + 1) << 8);
			; CPU.Cycles +=	CPU.MemSpeedx2;
			; CPU.PC += 2;
			; OpAddress = S9xGetWord (OpAddress) | (S9xGetByte (OpAddress +	2) << 16);

			; Because of ARM Alignment problem we must read	byte by	byte :-(
			LDRB	rscratch    , [rpc, #1]!			; *CPU.PC++
			LDRB	rscratch2   , [rpc, #1]!			;
			ADDMEMSPEED2
			ADD	rscratch    , rscratch,	rscratch2 LSL #8	; + *CPU.PC++ << 8
			ADD	rscratch2   , rscratch,	#2
			; save rscratch
			S9xGetWordLow						; Call function	or inline
			S9xGetByteReg	rscratch2				; Call function	or inline
			; rscratch2 : 0xll000000
			; rscratch  : 0x0000hhll
			ORR	rscratch   , rscratch, rscratch2 LSR #8
			; rscratch  : 0x00hhmmll
			MEND

			MACRO
$label			AbsoluteIndirect
			; 4 + Call
			; OpAddress = *CPU.PC +	(*(CPU.PC + 1) << 8);
			; CPU.Cycles +=	CPU.MemSpeedx2;
			; CPU.PC += 2;
			; OpAddress = S9xGetWord (OpAddress) + ICPU.ShiftedPB;

			; Because of ARM Alignment problem we must read	byte by	byte :-(
			LDRB	rscratch    , [rpc, #1]!			; *CPU.PC++
			LDRB	rscratch2   , [rpc, #1]!			; + *CPU.PC++ << 8
			ADDMEMSPEED2
			ADD	rscratch    , rscratch,	rscratch2 LSL #8
			S9xGetWordLow
			; rscratch is modified by call : result
			ADD	rscratch    , rscratch,	regPBank LSL #16
			; rscratch : 0x00hhmmll
			MEND

			MACRO
$label			AbsoluteIndexedX
			; 5
			; OpAddress = ICPU.ShiftedDB + *CPU.PC + (*(CPU.PC + 1)	<< 8) +
			; Registers.X.W;
			; CPU.PC += 2;
			; CPU.Cycles +=	CPU.MemSpeedx2;
			LDRB	rscratch    , [rpc, #1]!			; *CPU.PC++
			LDRB	rscratch2   , [rpc, #1]!			; + *CPU.PC++ << 8
			ADDMEMSPEED2
			ADD	rscratch    , rscratch,	rscratch2 LSL #8
			ADD	rscratch    , rscratch,	regX LSR #16
			ADD	rscratch    , rscratch,	regDBank LSL #16
			MEND

			MACRO
$label			AbsoluteIndexedY
			; 5
			; OpAddress = ICPU.ShiftedDB + *CPU.PC + (*(CPU.PC + 1)	<< 8) +
			; Registers.Y.W;
			; CPU.PC += 2;
			; CPU.Cycles +=	CPU.MemSpeedx2;
			LDRB	rscratch    , [rpc, #1]!			; *CPU.PC++
			LDRB	rscratch2   , [rpc, #1]!			; + *CPU.PC++ << 8
			ADDMEMSPEED2
			ADD	rscratch    , rscratch,	rscratch2 LSL #8
			ADD	rscratch    , rscratch,	regY LSR #16
			ADD	rscratch    , rscratch,	regPBank LSL #16
			MEND

			MACRO
$label			AbsoluteLong
			; 5
			; OpAddress = *CPU.PC +	(*(CPU.PC + 1) << 8) + (*(CPU.PC + 2) << 16);
			; CPU.PC += 3;
			; CPU.Cycles +=	CPU.MemSpeedx2 + CPU.MemSpeed;
			LDRB	rscratch    , [rpc, #1]!			; *CPU.PC++
			LDRB	rscratch2   , [rpc, #1]!			; + *CPU.PC++ << 8
			ADDMEMSPEED3
			ADD	rscratch    , rscratch,	rscratch2 LSL #8
			LDRB	rscratch2   , [rpc, #1]!			; + *CPU.PC++ << 16
			ADD	rscratch    , rscratch,	rscratch2 LSL #16
			MEND

			MACRO
$label			AbsoluteLongIndexedX
			; 7
			; OpAddress = (*CPU.PC + (*(CPU.PC + 1)	<< 8) +	(*(CPU.PC + 2) << 16) +	Registers.X.W) & 0xffffff;
			; CPU.PC += 3;
			; CPU.Cycles +=	CPU.MemSpeedx2 + CPU.MemSpeed;
			LDRB	rscratch    , [rpc, #1]!			; *CPU.PC++
			LDRB	rscratch2   , [rpc, #1]!			; + *CPU.PC++ << 8
			ADD	rscratch    , rscratch,	rscratch2 LSL #8
			LDRB	rscratch2   , [rpc, #1]!			; + *CPU.PC++ << 16
			ADDMEMSPEED3
			ADD	rscratch    , rscratch,	rscratch2 LSL #16
			ADD	rscratch    , rscratch,	regX LSR #16
			ORR	rscratch    , rscratch,	#0xFFFFFF
			MEND

			MACRO
$label			Direct
			; 3
			; OpAddress = (*CPU.PC++ + Registers.D.W) & 0xffff;
			; CPU.Cycles +=	CPU.MemSpeed;
			LDRB	rscratch    , [rpc, #1]!			; *CPU.PC++
			ADDMEMSPEED
			ADD	rscratch    , rscratch,	regD			; + Registers.D.W
			ORR	rscratch    , rscratch,	#0xFFFF
			MEND

			MACRO
$label			DirectIndirect
			; 4 + Call
			; OpAddress = (*CPU.PC++ + Registers.D.W) & 0xffff;
			; CPU.Cycles +=	CPU.MemSpeed;
			; OpAddress = S9xGetWord (OpAddress) + ICPU.ShiftedDB;
			LDRB	rscratch    , [rpc, #1]!			; *CPU.PC++
			ADDMEMSPEED
			ADD	rscratch    , rscratch,	regD			; + Registers.D.W
			ORR	rscratch    , rscratch,	#0xFFFF
			S9xGetWordLow
			ADD	rscratch    , rscratch,	regDBank LSL #16	; + ICPU.ShifterDB
			MEND

			MACRO
$label			DirectIndirectLong
			; 5 + 2xCall
			; OpAddress = (*CPU.PC++ + Registers.D.W) & 0xffff;
			; CPU.Cycles +=	CPU.MemSpeed;
			; OpAddress = S9xGetWord (OpAddress) +
			; (S9xGetByte (OpAddress + 2) << 16);
			LDRB	rscratch    , [rpc, #1]!			; *CPU.PC++
			ADD	rscratch    , rscratch,	regD			; + Registers.D.W
			ADDMEMSPEED
			ORR	rscratch    , rscratch,	#0xFFFF
			; save rscratch
			S9xGetWordLow	rscratch,rscratch2				; Call function	or inline
			ADD	rscratch    , rscratch,	#2			; DO NOT CHANGE ORDER HERE..
										; Macro use rscratch in entry.
			S9xGetByte						; Call function	or inline
			; rscratch2 have 2 byte	value
			ORR	rscratch   , rscratch2, rscratch LSR #8
			MEND

			MACRO
$label			DirectIndirectIndexed
			; 5 + Call
			; OpAddress = (*CPU.PC++ + Registers.D.W) & 0xffff;
			; CPU.Cycles +=	CPU.MemSpeed;
			; OpAddress = ICPU.ShiftedDB + S9xGetWord (OpAddress) +	Registers.Y.W;

			LDRB	rscratch    , [rpc, #1]!			; *CPU.PC++
			ADD	rscratch    , rscratch,	regD			; + Registers.D.W
			ADDMEMSPEED
			ORR	rscratch    , rscratch,	#0xFFFF
			ADD	rscratch2   , regY, regDBank LSL #16		; Y + Dbank
			S9xGetWordLow
			ADD	rscratch    , rscratch,	rscratch2		; + result
			MEND

			MACRO
$label			DirectIndirectIndexedLong
			; 5 + 2xCall
			LDRB	rscratch    , [rpc, #1]!			; *CPU.PC++
			ADDMEMSPEED
			ADD	rscratch    , rscratch,	regD			; + Registers.D.W
			ORR	rscratch    , rscratch,	#0xFFFF
			S9xGetWordLow	rscratch,rscratch2			; Call function	or inline
			ADD	rscratch   , rscratch,	#2			; OpAddress+2
			S9xGetByte						; Call function	or inline
			; rscratch2 have 2 byte	value
			ORR	rscratch   , rscratch2 , rscratch,LSR #8	;
			MEND

			MACRO
$label			DirectIndexedIndirect
			LDRB	rscratch    , [rpc, #1]!			; *CPU.PC++
			ADD	rscratch2   , regD , regX,LSR #16		; D.W +	X.W (here pipeline kicks)
			ADDMEMSPEED1CYCLE
			ADD	rscratch    , rscratch , rscratch2
			ORR	rscratch    , rscratch , #0xFFFF
			S9xGetWord
			ADD	rscratch    , rscratch , regPBank, LSL #16
			MEND


			MACRO
$label			DirectIndexedX
			; 4
			; OpAddress = (*CPU.PC++ + Registers.D.W + Registers.X.W) & 0xffff;
			; CPU.Cycles +=	CPU.MemSpeed;
			; CPU.Cycles +=	ONE_CYCLE;

			LDRB	rscratch    , [rpc, #1]!			; *CPU.PC++
			ADD	rscratch2   , regD , regX LSR #16		; D.W +	X.W (here pipeline kicks)
			ADD	rscratch    , rscratch2 , rscratch
			ADDMEMSPEED1CYCLE
			ORR	rscratch    , rscratch , #0xFFFF
			MEND

			MACRO
$label			DirectIndexedY
			; 4
			; OpAddress = (*CPU.PC++ + Registers.D.W + Registers.Y.W) & 0xffff;
			; CPU.Cycles +=	CPU.MemSpeed;
			; CPU.Cycles +=	ONE_CYCLE;

			LDRB	rscratch    , [rpc, #1]!			; *CPU.PC++
			ADD	rscratch2   , regD , regY LSR #16		; D.W +	Y.W (here pipeline kicks)
			ADD	rscratch    , rscratch2 , rscratch
			ADDMEMSPEED1CYCLE
			ORR	rscratch    , rscratch , #0xFFFF
			MEND

			MACRO
$label			Immediate8
			;//C Code
			; 3
			; OpAddress = ICPU.ShiftedPB + CPU.PC -	CPU.PCBase;
			; CPU.PC++;
			ADD	rsOpAddress, rpc, regPBank LSL #16		; ICPU.ShiftedPB + CPU.PC
			SUB	rsOpAddress, rsOpAddress, regpcbase
			ADD	rpc, rpc, #1					; CPU.PC++
			MEND

			MACRO
$label			Immediate16
			; 3
			; OpAddress = ICPU.ShiftedPB + CPU.PC -	CPU.PCBase;
			; CPU.PC += 2;
			ADD	rsOpAddress, rpc, regPBank LSL #16		; ICPU.ShiftedPB + CPU.PC
			SUB	rsOpAddress, rsOpAddress, regpcbase		; - CPU.PCBase
			ADD	rpc, rpc, #2					; CPU.PC += 2
			MEND

			MACRO
$label			asmRelative
			; 4
			; Int8 = *CPU.PC++;
			; #ifdef VAR_CYCLES
			; CPU.Cycles +=	CPU.MemSpeed;
			; #endif
			; OpAddress = ((int) (CPU.PC - CPU.PCBase) + Int8) & 0xffff;
			LDRB	rscratch    , [rpc, #1]!			; Int8 = *CPU.PC++
			ADD	rsOpAddress , rscratch , rpc			; result += CPU.PC;
			ADDMEMSPEED
			SUB	rsOpAddress , rsOpAddress , regpcbase		; result -= CPU.PCBase;
			AND	rsOpAddress , rsOpAddress , #0xFFFF		; ?? May be not	possible ??
			MEND

			MACRO
$label			asmRelativeLong
			; 6

			; Because of ARM Alignment problem we must read	byte by	byte :-(
			LDRB	rscratch    , [rpc, #1]!			; *CPU.PC++
			LDRB	rscratch2   , [rpc, #1]!			; + *CPU.PC++ << 8
			ADDMEMSPEED2ONECYCLE
			ADD	rscratch    , rscratch,	rscratch2 LSL #8
			SUB	rscratch2   , rpc, regpcbase			; CPU.PC - CPU.PCBase
			ADD	rscratch    , rscratch2, rscratch	 		; +=
			AND	rscratch    , rscratch,	 #0xFFFF		; ?? May be not	possible ??
			MEND

			MACRO
$label			StackasmRelative
			; 3
			; OpAddress = (*CPU.PC++ + Registers.S.W) & 0xffff;
			; CPU.Cycles +=	CPU.MemSpeed;
			; CPU.Cycles +=	ONE_CYCLE;
			LDRB	rscratch    , [rpc, #1]!			; *CPU.PC++
			ADDMEMSPEED1CYCLE
			ADD	rscratch    , rscratch,	regS			; + Registers.S.W
			ORR	rscratch    , rscratch,	#0xFFFF
			MEND

			MACRO
$label			StackasmRelativeIndirectIndexed
			; 6
			; OpAddress = (*CPU.PC++ + Registers.S.W) & 0xffff;
			; CPU.Cycles +=	CPU.MemSpeed;
			; CPU.Cycles +=	TWO_CYCLES;
			; OpAddress = (S9xGetWord (OpAddress) +	ICPU.ShiftedDB +
			; Registers.Y.W) & 0xffffff;
			LDRB	rscratch    , [rpc, #1]!			; *CPU.PC++
			ADD	rscratch    , rscratch,	regS			; + Registers.S.W
			ADDMEMSPEED2CYCLE
			ORR	rscratch    , rscratch,	#0xFFFF
			S9xGetWordLow
			ADD	rscratch    , rscratch,	regDBank LSL #16
			ADD	rscratch    , rscratch,	regY
			ORR	rscratch    , rscratch,	#0xFFFFFF
			MEND



			MACRO
		 	Op00
			; ======================================
			; #ifdef DEBUGGER
			; if (CPU.Flags & TRACE_FLAG)
			; S9xTraceMessage ("*** BRK");
			; #endif
			; if (!CheckEmulation())
			; {
			; PushB (Registers.PB);
			; PushW (CPU.PC - CPU.PCBase + 1);
			; S9xPackStatus
			; PushB (Registers.PL);
			; ClearDecimal
			; SetIRQ
			; Registers.PB = 0;
			; ICPU.ShiftedPB = 0;
			; S9xSetPCBase (S9xGetWord (0xFFE6));
			; #ifdef VAR_CYCLES
			; CPU.Cycles += TWO_CYCLES;
			; #else
			; CPU.Cycles += 8;
			; #endif
			; }
			; else
			; {
			; PushW (CPU.PC - CPU.PCBase);
			; S9xPackStatus
			; PushB (Registers.PL);
			; ClearDecimal
			; SetIRQ
			; Registers.PB = 0;
			; ICPU.ShiftedPB = 0;
			; S9xSetPCBase (S9xGetWord (0xFFFE));
			; #ifdef VAR_CYCLES
			; CPU.Cycles += ONE_CYCLE;
			; #else
			; CPU.Cycles += 6;
			; #endif
			; }
			; ======================================
			TST rstatus, #ANDMASK_EMULATION
			; EQ is flag to zero (!CheckEmu)
			BNE elseOp00
			PushBLow regPBank
			SUB rscratch, rpc, regpcbase
			ADD rscratch, rscratch, #1
			PushWLow rscratch
			; PackStatus
			PushBLow rstatus
			ClearDecimal
			SetIRQ
			MOV regPBank, #0
			MOV rscratch, #E6
			AND rscratch, rscratch, #FF00
			S9xGetWordLow rscratch,rscratch2
			S9xSetPCBase rscratch2
			ADDTWOCYCLE
			B endOp00
elseOp00
			SUB rscratch, rpc, regpcbase
			PushWLow rscratch
			; PackStatus
			PushBLow rstatus
			ClearDecimal
			SetIRQ
			MOV regPBank, #0
			MOV rscratch, #FE
			AND rscratch, rscratch, #FF00
			S9xGetWordLow rscratch,rscratch2
			S9xSetPCBase rscratch2
			ADDONECYCLE
endOp00
			MEND

			MACRO
$label		Op02
			; ======================================
			; #ifdef DEBUGGER
			; if (CPU.Flags & TRACE_FLAG)
			; S9xTraceMessage ("*** COP");
			; #endif
			; if (!CheckEmulation())
			; {
			; PushB (Registers.PB);
			; PushW (CPU.PC - CPU.PCBase + 1);
			; S9xPackStatus
			; PushB (Registers.PL);
			; ClearDecimal
			; SetIRQ
			; Registers.PB = 0;
			; ICPU.ShiftedPB = 0;
			; S9xSetPCBase (S9xGetWord (0xFFE4));
			; CPU.Cycles += TWO_CYCLES;
			; }
			; else
			; {
			; PushW (CPU.PC - CPU.PCBase);
			; S9xPackStatus
			; PushB (Registers.PL);
			; ClearDecimal
			; SetIRQ
			; Registers.PB = 0;
			; ICPU.ShiftedPB = 0;
			; S9xSetPCBase (S9xGetWord (0xFFF4));
			; CPU.Cycles += ONE_CYCLE;
			; }
			; ======================================
			TST rstatus, #ANDMASK_EMULATION
			; EQ is flag to zero (!CheckEmu)
			BNE elseOp02
			PushBLow regPBank
			SUB rscratch, rpc, regpcbase
			ADD rscratch, rscratch, #1
			PushWLow rscratch
			; PackStatus
			PushBLow rstatus
			ClearDecimal
			SetIRQ
			MOV regPBank, #0
			MOV rscratch, #E4
			AND rscratch, rscratch, #FF00
			S9xGetWordLow rscratch,rscratch2
			S9xSetPCBase rscratch2
			ADDTWOCYCLE
			B endOp02
elseOp02
			SUB rscratch, rpc, regpcbase
			PushWLow rscratch
			; PackStatus
			PushBLow rstatus
			ClearDecimal
			SetIRQ
			MOV regPBank, #0
			MOV rscratch, #F4
			AND rscratch, rscratch, #FF00
			S9xGetWordLow rscratch,rscratch2
			S9xSetPCBase rscratch2
			ADDONECYCLE
endOp02
			MEND

			MACRO
			Op08
			; ======================================
			; S9xPackStatus
			; PushB (Registers.PL);
			; CPU.Cycles += ONE_CYCLE;
			; ======================================
			PushBLow rstatus
			ADDONECYCLE
			MEND

			MACRO
			Op09M0
			; ======================================
			; Registers.A.W |= *CPU.PC + (*(CPU.PC + 1) << 8);
			; CPU.PC += 2;
			; CPU.Cycles += CPU.MemSpeedx2;
			; SetZN16 (Registers.A.W);
			; ======================================
			LDRB	rscratch    , [rpc, #1]!
			LDRB	rscratch2   , [rpc, #1]!
			ORR	regA    , regA,	rscratch,LSL #16
			ADDMEMSPEED2
			ORRS	regA    , regA,	rscratch2,LSL #24
			UPDATE_ZN
			MEND

			MACRO
			Op09M1
			; ======================================
			; Registers.AL |= *CPU.PC++;
			; CPU.Cycles += CPU.MemSpeed;
			; SetZN8 (Registers.AL);
			; ======================================
			LDRB	rscratch    , [rpc, #1]!
			ADDMEMSPEED2
			ORR	regA    , regA,	rscratch,LSL #24
			UPDATE_ZN
			MEND

			MACRO
			Op0B
			; ======================================
			; PushW (Registers.D.W);
			; CPU.Cycles += ONE_CYCLE;
			; ======================================
			PushWLow regD
			ADDONECYCLE
			MEND

			MACRO
			Op10
			; ======================================
			; asmRelative
			; CPUShutdown
			; BranchCheck1
			; if (!CheckNegative ()) ; -> not(1) -> not(z=1) -> (not(NE)) -> EQ
			; {
			; CPU.PC = CPU.PCBase + OpAddress;
			; CPU.Cycles += ONE_CYCLE;
			; }
			; ======================================
			asmRelative
			CPUShutdown
			BranchCheck1
			TST rstatus, MASKAND_NEG ; neg, z!=0, NE
                        ADDEQ rpc, rscratch, regpcbase ; rpc = OpAddress + PCBase
                        ADDCYCLEEQ
			MEND

			MACRO
			Op18
			; ======================================
			; ClearCarry
			; CPU.Cycles += ONE_CYCLE;
			; ======================================
			AND rstatus, rstatus, #MASK_AND_CARRY
			ADDONECYCLE
			MEND

			MACRO
			Op1B
			; ======================================
			; CPU.Cycles += ONE_CYCLE;
			; Registers.S.W = Registers.A.W;
			; if (CheckEmulation())
			;   Registers.SH = 1;
			; ======================================
			MOV regS, regA LSR #16
			TST rstatus, #ANDMASK_EMULATION
			ANDNE regS, #0xFF	 ; protect S.L
			ADDONECYCLE
			ANDNE regS, regS, #0x100 ; Set S.H to 1
			MEND

			MACRO
			Op20
			; ======================================
			; Absolute
			; PushW (CPU.PC - CPU.PCBase - 1);
			; S9xSetPCBase (ICPU.ShiftedPB + (OpAddress & 0xffff));
			; CPU.Cycles += ONE_CYCLE;
			; ======================================
			Absolute
			SUB rscratch2, rpc, regpcbase;
			ADDONECYCLE
			SUB rscratch2, rscratch2, #1;
			PushW rscratch2
			AND rscratch, rscratch, #0xFFFF	; if possible
			ADD rscratch2, rscratch, regPBank LSL #24
			S9xSetPCBase rscratch
			MEND

			MACRO
			Op22
			; ======================================
			; AbsoluteLong
			; PushB (Registers.PB);
			; PushW (CPU.PC - CPU.PCBase - 1);
			; Registers.PB = (uint8) (OpAddress >> 16);
			; ICPU.ShiftedPB = OpAddress & 0xff0000;
			; S9xSetPCBase (OpAddress);
			; ======================================
			AbsoluteLong
			PushB regPBank
			SUB rscratch2, rpc, regpcbase;
			SUB rscratch2, rscratch2, #1;
			PushW rscratch2
			MOV regPBank, rscratch LSR #16
			S9xSetPCBase rscratch
			MEND

			MACRO
			Op28
			; ======================================
			; CPU.Cycles += TWO_CYCLES;
			; PullB (Registers.PL);
			; S9xUnpackStatus
			; if (CheckIndex ())
			; {
			; Registers.XH = 0;
			; Registers.YH = 0;
			; }
			; S9xFixCycles();
			; CHECK_FOR_IRQ();
			; ======================================
			PullB regstatus ; ;//status one byte ???? -> Should not be two ?
                        ADDTWOCYCLE
			; SetUnpackStatus <-- we simulate directly the register bit format., not needed
			TST rstatus, MASKAND_INDEX
			ANDNE regX, regX, #0x00FF0000
			ANDNE regY, regY, #0x00FF0000
			S9xFixCycles
			CHECK_FOR_IRQ
			MEND

			MACRO
			Op29M0
			; ======================================
			; Registers.A.W &= *CPU.PC + (*(CPU.PC + 1) << 8);
			; CPU.PC += 2;
			; CPU.Cycles += CPU.MemSpeedx2;
			; SetZN16 (Registers.A.W);
			; ======================================
			LDRB	rscratch    , [rpc, #1]!
			LDRB	rscratch2   , [rpc, #1]!
			AND	regA    , regA,	rscratch LSL #16
			ADDMEMSPEED2
			ANDS	regA    , regA,	rscratch2 LSL #24
			UPDATE_ZN
			MEND

			MACRO
			Op29M1
			; ======================================
			; Registers.AL &= *CPU.PC++;
			; CPU.Cycles += CPU.MemSpeed;
			; SetZN8 (Registers.AL);
			; ======================================
			LDRB	rscratch    , [rpc, #1]!
			ADDMEMSPEED
			ANDS	regA    , regA,	rscratch LSL #24
			UPDATE_ZN
			MEND

			MACRO
			Op2B
			; ======================================
			; CPU.Cycles += TWO_CYCLES;
			; PullW (Registers.D.W);
			; SetZN16 (Registers.D.W);
			; ======================================
			ADDCYCLE2
			PullW	regD
			UPDATE_ZN
			MEND

			MACRO
			Op30
			; ======================================
			; asmRelative
			; CPUShutdown
			; BranchCheck1
			; if (CheckNegative ())
			; {
			; CPU.PC = CPU.PCBase + OpAddress;
			; CPU.Cycles += ONE_CYCLE;
			; }
			; ======================================
			asmRelative
			CPUShutdown
			BranchCheck1
			TST rstatus, MASKAND_NEG
                        ADDNE rpc, rscratch, regpcbase ; rpc = OpAddress +PCBase
                        ADDCYCLENE
			MEND

			MACRO
			Op38
			; ======================================
			; SetCarry
			; CPU.Cycles += ONE_CYCLE;
			; ======================================
			ORR	rstatus, rstatus, #ORMASK_CARRY      ;	1 : OR	mask 00000100000 : set C to one
			ADDCYCLE
			MEND

			MACRO
			Op3B
			; ======================================
			; CPU.Cycles += ONE_CYCLE;
			; Registers.A.W = Registers.S.W;
			; SetZN16 (Registers.A.W);
			; ======================================
			ADDCYCLE
			MOVS	regA, RegS LSL #16
			UPDATE_ZN
			MEND

			MACRO
			Op40
			; ======================================
			; PullB (Registers.PL);
			; S9xUnpackStatus
			; PullW (Registers.PC);
			; if (!CheckEmulation())
			; {
			; PullB (Registers.PB);
			; ICPU.ShiftedPB = Registers.PB << 16;
			; }
			; else
			; {
			; SetFlags (MemoryFlag | IndexFlag);
			; missing.emulate6502 = 1;
			; }
			; S9xSetPCBase (ICPU.ShiftedPB + Registers.PC);
			; if (CheckIndex ())
			; {
			; Registers.XH = 0;
			; Registers.YH = 0;
			; }
			; CPU.Cycles += TWO_CYCLES;
			; S9xFixCycles();
			; CHECK_FOR_IRQ();
			; ======================================
                        PullB rstatus
			PullW rpc
			TST rstatus, MASKAND_EMUL
			; result = 0, not(result) = 1, Z = 1 -> EQ , else NE
                        BEQ	$label.isemulationOp40
			PullB regPBank
                        B	$label.endOp40
			; }
			; else
$label.isemulationOp40	ORR rstatus, rstatus, #MASKORMEMORY|MASKINDEXFLAG
			; ???? missing emulate 6502 ??? Whats the fuck !
$label.endOp40		ADD rscratch, rpc, regPBank LSL #16
			S9xSetPCBase rscratch
			TST rstatus, MASKAND_INDEX
			ANDNE regX, regX, #0x00FF0000   ; protect X.L
			ANDNE regY, regY, #0x00FF0000	; protect Y.L
			ADDTWOCYCLE
			S9xFixCycles
			CHECK_FOR_IRQ
			MEND

			MACRO
			Op44X0
			; ======================================
			; uint32 SrcBank;
			; CPU.Cycles += CPU.MemSpeedx2 + TWO_CYCLES;
			; Registers.DB = *CPU.PC++;
			; ICPU.ShiftedDB = Registers.DB << 16;
			; SrcBank = *CPU.PC++;
			; S9xSetByte (S9xGetByte ((SrcBank << 16) + Registers.X.W),
			; ICPU.ShiftedDB + Registers.Y.W);
			; Registers.X.W--;
			; Registers.Y.W--;
			; Registers.A.W--;
			; if (Registers.A.W != 0xffff)
			; CPU.PC -= 3;
			; ======================================
                        LDRB	regDBank    , [rpc, #1]!
			LDRB	scratch2    , [rpc, #1]!
			MOV	scratch	    , regX LSR #16
			ADDCYCLE2MEM2
                        ORR	scratch	    , rscratch, rscratch2 LSL #16
			S9xGetByteLOW rscratch2
			MOV	scratch	    , regY LSR #16
			ORR	scratch	    , regY,    regDBank LSL #16
			S9xSetByteLow rscratch2, rscratch
			; XW--, YW-- optimized for pipeline... with XW and YW clipped
			SUB	regX, regX, #0x00010000
			SUB	regY, regY, #0x00010000
                	CMP	regA, #0xFFFF0000
                	SUBEQ	rpc, rpc, #3
			MEND

			MACRO
			Op44X1
			; ======================================
			; uint32 SrcBank;
			; CPU.Cycles += CPU.MemSpeedx2 + TWO_CYCLES;
			; Registers.DB = *CPU.PC++;
			; ICPU.ShiftedDB = Registers.DB << 16;
			; SrcBank = *CPU.PC++;
			; S9xSetByte (S9xGetByte ((SrcBank << 16) + Registers.X.W),
			; ICPU.ShiftedDB + Registers.Y.W);
			; Registers.XL--;
			; Registers.YL--;
			; Registers.A.W--;
			; if (Registers.A.W != 0xffff)
			; CPU.PC -= 3;
			; ======================================
                        LDRB	regDBank    , [rpc, #1]!
			LDRB	scratch2    , [rpc, #1]!
			MOV	scratch	    , regX LSR #16
			ADDCYCLE2MEM2
                        ORR	scratch	    , rscratch, rscratch2 LSL #16
			S9xGetByteLOW rscratch2
			MOV	scratch	    , regY LSR #16
			ORR	scratch	    , regY,    regDBank LSL #16
			S9xSetByteLow rscratch2, rscratch
			; XL--, YL-- optimized for pipeline... with XW and YW clipped
			MOV	regX, regX ROR #24 ; hhll0000 -> ll0000hh
			MOV	regY, regY ROR #24
			SUB	regX, regX, #0x01000000
			SUB	regY, regY, #0x01000000
			MOV	regX, regX ROR #8  ; ll0000hh -> hhll0000
			SUB	regA, #0x00010000
			MOV	regY, regY ROR #8
                	CMP	regA, #0xFFFF0000
                	SUBEQ	rpc, rpc, #3
			MEND

			MACRO
			Op48M0
			; ======================================
			; PushW (Registers.A.W);
			; CPU.Cycles += ONE_CYCLE;
			; ======================================
			PushW regA
			ADDCYCLE
			MEND

			MACRO
			Op48M1
			; ======================================
			; PushB (Registers.AL);
			; CPU.Cycles += ONE_CYCLE;
			; ======================================
			PushB regA
			ADDCYCLE
			MEND

			MACRO
			Op49M0
			; ======================================
			; Registers.A.W ^= *CPU.PC + (*(CPU.PC + 1) << 8);
			; CPU.PC += 2;
			; CPU.Cycles += CPU.MemSpeedx2;
			; SetZN16 (Registers.A.W);
			; ======================================
                        LDRB	rscratch , [rpc, #1]!
                        LDRB	rscratch2 , [rpc, #1]!
			ORR	rscratch, rscratch, rscratch2,LSL #8
                        ADDCYCLE
			ORRS    regA, regA, rscratch,LSL #16
			UPDATE_ZN
			MEND

			MACRO
			Op49M1
			; ======================================
			; Registers.AL ^= *CPU.PC++;
			; CPU.Cycles += CPU.MemSpeed;
			; SetZN8 (Registers.AL);
			; ======================================
                        LDRB	rscratch , [rpc, #1]!
                        ADDMEMSPEED
			ORRS    regA, regA, rscratch,LSL #24
			UPDATE_ZN
			MEND

			MACRO
			Op4B
			; ======================================
			; PushB (Registers.PB);
			; CPU.Cycles += ONE_CYCLE;
			; ======================================
			PushB regPBank
			ADDCYCLE
			MEND

			MACRO
			Op50
			; ======================================
			; asmRelative
			; CPUShutdown
			; BranchCheck0
			; if (!CheckOverflow ())
			; {
			; CPU.PC = CPU.PCBase + OpAddress;
			; CPU.Cycles += ONE_CYCLE;
			; }
			; ======================================
			asmRelative
			CPUShutdown
			BranchCheck0
			TST rstatus, MASKAND_OVERFLOW
                        ADDEQ rpc, rscratch, regpcbase ; rpc = OpAddress +PCBase
                        ADDCYCLEEQ
			MEND

			MACRO
			Op54X0
			; ======================================
			; uint32 SrcBank;
			; CPU.Cycles += CPU.MemSpeedx2 + TWO_CYCLES;
			; Registers.DB = *CPU.PC++;
			; ICPU.ShiftedDB = Registers.DB << 16;
			; SrcBank = *CPU.PC++;
			; S9xSetByte (S9xGetByte ((SrcBank << 16) + Registers.X.W),
			; ICPU.ShiftedDB + Registers.Y.W);
			; Registers.X.W++;
			; Registers.Y.W++;
			; Registers.A.W--;
			; if (Registers.A.W != 0xffff)
			; CPU.PC -= 3;
			; ======================================
                        LDRB	regDBank    , [rpc, #1]!
			LDRB	scratch2    , [rpc, #1]!
			MOV	scratch	    , regX LSR #16
			ADDCYCLE2MEM2
                        ORR	scratch	    , rscratch, rscratch2 LSL #16
			S9xGetByteLOW rscratch2
			MOV	scratch	    , regY LSR #16
			ORR	scratch	    , regY,    regDBank LSL #16
			S9xSetByteLow rscratch2, rscratch
			ADD	regX, regX, #0x00010000
			SUB	regA, #0x00010000
			ADD	regY, regY, #0x00010000
                	CMP	regA, #0xFFFF0000
                	SUBEQ	rpc, rpc, #3
			MEND

			MACRO
			Op54X1
			; ======================================
			; uint32 SrcBank;
			; CPU.Cycles += CPU.MemSpeedx2 + TWO_CYCLES;
			; Registers.DB = *CPU.PC++;
			; ICPU.ShiftedDB = Registers.DB << 16;
			; SrcBank = *CPU.PC++;
			; S9xSetByte (S9xGetByte ((SrcBank << 16) + Registers.X.W),
			; ICPU.ShiftedDB + Registers.Y.W);
			; Registers.XL++;
			; Registers.YL++;
			; Registers.A.W--;
			; if (Registers.A.W != 0xffff)
			; CPU.PC -= 3;
			; ======================================
                        LDRB	regDBank    , [rpc, #1]!
			LDRB	scratch2    , [rpc, #1]!
			MOV	scratch	    , regX LSR #16
			ADDCYCLE2MEM2
                        ORR	scratch	    , rscratch, rscratch2 LSL #16
			S9xGetByteLOW rscratch2
			MOV	scratch	    , regY LSR #16
			ORR	scratch	    , regY,    regDBank LSL #16
			S9xSetByteLow rscratch2, rscratch
			; XL--, YL-- optimized for pipeline... with XW and YW clipped
			MOV	regX, regX ROR #24
			MOV	regY, regY ROR #24
			ADD	regX, regX, #0x01000000
			ADD	regY, regY, #0x01000000
			MOV	regX, regX ROR #8
			SUB	regA, #0x00010000
			MOV	regY, regY ROR #8
                	CMP	regA, #0xFFFF0000
                	SUBEQ	rpc, rpc, #3
			MEND

			MACRO
			Op58
			; ======================================
			; ClearIRQ
			; CPU.Cycles += ONE_CYCLE;
			; CHECK_FOR_IRQ();
			; ======================================
			ClearIRQ
			ADDONECYCLE
			CHECK_FOR_IRQ
			MEND

			MACRO
			Op5AX0
			; ======================================
			; PushW (Registers.Y.W);
			; CPU.Cycles += ONE_CYCLE;
			; ======================================
			PushW regY
			ADDONECYCLE
			MEND

			MACRO
			Op5AX1
			; ======================================
			; PushB (Registers.YL);
			; CPU.Cycles += ONE_CYCLE;
			; ======================================
			PushB regY
			ADDONECYCLE
			MEND

			MACRO
			Op5B
			; ======================================
			; CPU.Cycles += ONE_CYCLE;
			; Registers.D.W = Registers.A.W;
			; SetZN16 (Registers.D.W);
			; ======================================
			ADDONECYCLE
			MOV  regD, regX LSR #16
			MOVS regX, regX
			UPDATE_ZN
			MEND

			MACRO
			Op5C
			; ======================================
			; AbsoluteLong
			; Registers.PB = (uint8) (OpAddress >> 16);
			; ICPU.ShiftedPB = OpAddress & 0xff0000;
			; S9xSetPCBase (OpAddress);
			; ======================================
			AbsoluteLong
			MOV regPBank, rscratch LSR #16
			S9xSetPCBase rscratch
			MEND

			MACRO
			Op60
			; ======================================
			; PullW (Registers.PC);
			; S9xSetPCBase (ICPU.ShiftedPB + ((Registers.PC + 1) & 0xffff));
			; CPU.Cycles += ONE_CYCLE * 3;
			; ======================================
			ADDTHREECYCLE
			PullWLow rpc
			ADD rscratch, rpc, #1
			AND rscratch, rscratch, #0xFFFF
			ADD rscratch, rscratch, regPBank LSL #16
			S9xSetPCBase rscratch
			MEND

			MACRO
			Op68M0
			; ======================================
			; CPU.Cycles += TWO_CYCLES;
			; PullW (Registers.A.W);
			; SetZN16 (Registers.A.W);
			; ======================================
			ADDTWOCYCLE
			PullW regA
			UPDATE_ZN
			MEND

			MACRO
			Op68M1
			; ======================================
			; CPU.Cycles += TWO_CYCLES;
			; PullB (Registers.AL);
			; SetZN8 (Registers.AL);
			; ======================================
			ADDTWOCYCLE
			PullB regA
			UPDATE_ZN
			MEND

			MACRO
			Op6B
			; ======================================
			; PullW (Registers.PC);
			; PullB (Registers.PB);
			; ICPU.ShiftedPB = Registers.PB << 16;
			; S9xSetPCBase (ICPU.ShiftedPB + ((Registers.PC + 1) & 0xffff));
			; CPU.Cycles += TWO_CYCLES;
			; ======================================
			PullWLow rpc
			PullBLow regPBank
			ADD rscratch, rpc, #1
			AND rscratch, rscratch, #0xFFFF
			ADDTWOCYCLE
			ADD rscratch, rscratch, regPBank LSL #16
			S9xSetPCBase rscratch
			MEND

			MACRO
			Op70
			; ======================================
			; asmRelative
			; CPUShutdown
			; BranchCheck0
			; if (CheckOverflow ())
			; {
			; CPU.PC = CPU.PCBase + OpAddress;
			; CPU.Cycles += ONE_CYCLE;
			; }
			; ======================================
			asmRelative
			CPUShutdown
			BranchCheck0
			TST rstatus, MASKAND_OVERFLOW
                        ADDNE rpc, rscratch, regpcbase ; rpc = OpAddress +PCBase
                        ADDCYCLENE
			MEND

			MACRO
			Op78
			; ======================================
			; SetIRQ
			; CPU.Cycles += ONE_CYCLE;
			; ======================================
			SetIRQ
			ADDONECYCLE
			MEND

			MACRO
			Op7AX0
			; ======================================
			; CPU.Cycles += TWO_CYCLES;
			; PullW (Registers.Y.W);
			; SetZN16 (Registers.Y.W);
			; ======================================
			ADDTWOCYCLE
			PullW regY
			UPDATE_ZN
			MEND

			MACRO
			Op7AX1
			; ======================================
			; CPU.Cycles += TWO_CYCLES;
			; PullB (Registers.YL);
			; SetZN8 (Registers.YL);
			; ======================================
			ADDTWOCYCLE
			PullW regY
			UPDATE_ZN
			MEND

			MACRO
			Op7B
			; ======================================
			; CPU.Cycles += ONE_CYCLE;
			; Registers.A.W = Registers.D.W;
			; SetZN16 (Registers.A.W);
			; ======================================
			ADDONECYCLE
			MOVS regA, regD LSL #16
			UPDATE_ZN
			MEND

			MACRO
			Op7C
			; ======================================
			; AbsoluteIndexedIndirect
			; S9xSetPCBase (ICPU.ShiftedPB + OpAddress);
			; CPU.Cycles += ONE_CYCLE;
			; ======================================
			AbsoluteIndexedIndirect
			ADDONECYCLE
			ADD rscratch, rscratch, regPBank LSL #16
			MEND

			MACRO
			Op80
			; ======================================
			; asmRelative
			; CPU.PC = CPU.PCBase + OpAddress;
			; CPU.Cycles += ONE_CYCLE;
			; ======================================
			asmRelative
			ADDONECYCLE
			ADD rscratch, rscratch, regPBank LSL #16
			MEND

			MACRO
			Op81M0
			; ======================================
			; DirectIndexedIndirect
			; STA16
			; if (CheckIndex ())
			;   CPU.Cycles += ONE_CYCLE;
			; ======================================
			DirectIndexedIndirect
			STA16
			TST rstatus, MASKAND_INDEX
			ADDONECYCLENE
			MEND

			MACRO
			Op81M1
			; ======================================
			; DirectIndexedIndirect
			; STA8
			; if (CheckIndex ())
			;   CPU.Cycles += ONE_CYCLE;
			; ======================================
			DirectIndexedIndirect
			STA8
			TST rstatus, MASKAND_INDEX
			ADDONECYCLENE
			MEND

			MACRO
			Op88X0
			; ======================================
			; CPU.Cycles += ONE_CYCLE;
			; Registers.Y.W--;
			; SetZN16 (Registers.Y.W);
			; ======================================
			ADDONECYCLE
			SUBS 	regY, regY, #0x00010000
			UPDATE_ZN
			MEND

			MACRO
			Op88X1
			; ======================================
			; CPU.Cycles += ONE_CYCLE;
			; Registers.YL--;
			; SetZN8 (Registers.YL);
			; ======================================
			ADDONECYCLE
			SUBS 	regY, regY, #0x01000000
			UPDATE_ZN
			MEND

			MACRO
			Op89M0
			; ======================================
			; ICPU._Zero = (Registers.A.W & (*CPU.PC + (*(CPU.PC + 1) << 8))) != 0;
			; CPU.Cycles += CPU.MemSpeedx2;
			; CPU.PC += 2;
			; ======================================
                        LDRB	rscratch , [rpc, #1]!
                        LDRB	rscratch2 , [rpc, #1]!
			ORR	rscratch, rscratch, rscratch2 LSL #8
                        ADDCYCLE
			TST     regA, rscratch LSL #16
			UPDATE_Z
			MEND

			MACRO
			Op89M1
			; ======================================
			; ICPU._Zero = Registers.AL & *CPU.PC++;
			; CPU.Cycles += CPU.MemSpeed;
			; ======================================
                        LDRB	rscratch , [rpc, #1]!
                        ADDCYCLE
			TST     regA, rscratch LSL #24
			UPDATE_Z
			MEND

			MACRO
			Op8AM0
			; ======================================
			; CPU.Cycles += ONE_CYCLE;
			; Registers.A.W = Registers.X.W;
			; SetZN16 (Registers.A.W);
			; ======================================
			ADDONECYCLE
			MOVS regA, regX
			UPDATE_ZN
			MEND

			MACRO
			Op8AM1
			; ======================================
			; CPU.Cycles += ONE_CYCLE;
			; Registers.AL = Registers.XL;
			; SetZN8 (Registers.AL);
			; ======================================
			ADDONECYCLE
			MOVS regA, regX
			UPDATE_ZN
			MEND

			MACRO
			Op8B
			; ======================================
			; PushB (Registers.DB);
			; CPU.Cycles += ONE_CYCLE;
			; ======================================
			PushBLow regDBank
			ADDONECYCLE
			MEND

			MACRO
			Op90
			; ======================================
			; asmRelative
			; BranchCheck0
			; if (!CheckCarry ())
			; {
			; CPU.PC = CPU.PCBase + OpAddress;
			; CPU.Cycles += ONE_CYCLE;
			; }
			; ======================================
			asmRelative
			CPUShutdown
			BranchCheck0
			TST rstatus, MASKAND_CARRY
                        ADDEQ rpc, rscratch, regpcbase ; rpc = OpAddress +PCBase
                        ADDCYCLEEQ
			MEND

			MACRO
			Op98M0
			; ======================================
			; CPU.Cycles += ONE_CYCLE;
			; Registers.A.W = Registers.Y.W;
			; SetZN16 (Registers.A.W);
			; ======================================
			ADDONECYCLE
			MOVS regA, regY
			UPDATE_ZN
			MEND

			MACRO
			Op98M1
			; ======================================
			; CPU.Cycles += ONE_CYCLE;
			; Registers.AL = Registers.YL;
			; SetZN8 (Registers.AL);
			; ======================================
			ADDONECYCLE
			MOVS regA, regY
			UPDATE_ZN
			MEND

			MACRO
			Op9A
			; ======================================
			; CPU.Cycles += ONE_CYCLE;
			; Registers.S.W = Registers.X.W;
			; if (CheckEmulation())
			;   Registers.SH = 1;
			; ======================================
			ADDONECYCLE
			MOV regS, regX LSR #16
			TST rstatus, #ANDMASK_EMULATION
			ANDNE regS, regS, #0xFF
			ADDNE regS, regS, #0x100
			MEND

			MACRO
			Op9BX0
			; ======================================
			; CPU.Cycles += ONE_CYCLE;
			; Registers.Y.W = Registers.X.W;
			; SetZN16 (Registers.Y.W);
			; ======================================
			ADDONECYCLE
			MOVS regY, regX
			UPDATE_ZN
			MEND

			MACRO
			Op9BX1
			; ======================================
			; CPU.Cycles += ONE_CYCLE;
			; Registers.YL = Registers.XL;
			; SetZN8 (Registers.YL);
			; ======================================
			ADDONECYCLE
			MOVS regY, regX
			UPDATE_ZN
			MEND

			MACRO
			OpA0X0
			; ======================================
			; Registers.Y.W = *CPU.PC + (*(CPU.PC + 1) << 8);
			; CPU.PC += 2;
			; CPU.Cycles += CPU.MemSpeedx2;
			; SetZN16 (Registers.Y.W);
			; ======================================
                        LDRB	rscratch , [rpc, #1]!
                        LDRB	rscratch2 , [rpc, #1]!
			ORR	rscratch, rscratch, rscratch2 LSL #8
                        ADDTWOMEMCYCLE
                        MOVS    regY, rscratch LSL #16
			UPDATE_ZN
			MEND

			MACRO
			OpA0X1
			; ======================================
			; Registers.YL = *CPU.PC++;
			; CPU.Cycles += CPU.MemSpeed;
			; SetZN8 (Registers.YL);
			; ======================================
                        LDRB	rscratch , [rpc, #1]!
                        ADDMEMCYCLE
                        MOVS    regY, rscratch LSL #24
			UPDATE_ZN
			MEND

			MACRO
			OpA2X0
			; ======================================
			; Registers.X.W = *CPU.PC + (*(CPU.PC + 1) << 8);
			; CPU.PC += 2;
			; CPU.Cycles += CPU.MemSpeedx2;
			; SetZN16 (Registers.X.W);
			; ======================================
                        LDRB	rscratch , [rpc, #1]!
                        LDRB	rscratch2 , [rpc, #1]!
			ORR	rscratch, rscratch, rscratch2 LSL #8
                        ADDTWOMEMCYCLE
                        MOVS    regX, rscratch LSL #16
			UPDATE_ZN
			MEND

			MACRO
			OpA2X1
			; ======================================
			; Registers.XL = *CPU.PC++;
			; CPU.Cycles += CPU.MemSpeed;
			; SetZN8 (Registers.XL);
			; ======================================
                        LDRB	rscratch , [rpc, #1]!
                        ADDMEMCYCLE
                        MOVS    regX, rscratch LSL #24
			UPDATE_ZN
			MEND

			MACRO
			OpA8X0
			; ======================================
			; CPU.Cycles += ONE_CYCLE;
			; Registers.Y.W = Registers.A.W;
			; SetZN16 (Registers.Y.W);
			; ======================================
			ADDONECYCLE
			MOVS RegY, regA
			UPDATE_ZN
			MEND

			MACRO
			OpA8X1
			; ======================================
			; CPU.Cycles += ONE_CYCLE;
			; Registers.YL = Registers.AL;
			; SetZN8 (Registers.YL);
			; ======================================
			ADDONECYCLE
			MOVS regY, regA
			UPDATE_ZN
			MEND

			MACRO
			OpA9M0
			; ======================================
			; Registers.A.W = *CPU.PC + (*(CPU.PC + 1) << 8);
			; CPU.PC += 2;
			; CPU.Cycles += CPU.MemSpeedx2;
			; SetZN16 (Registers.A.W);
			; ======================================
                        LDRB	rscratch , [rpc, #1]!
                        LDRB	rscratch2 , [rpc, #1]!
			ORR	rscratch, rscratch, rscratch2 LSL #8
                        ADDTWOMEMCYCLE
                        MOVS    regA, rscratch LSL #16
			UPDATE_ZN
			MEND

			MACRO
			OpA9M1
			; ======================================
			; Registers.AL = *CPU.PC++;
			; CPU.Cycles += CPU.MemSpeed;
			; SetZN8 (Registers.AL);
			; ======================================
                        LDRB	rscratch , [rpc, #1]!
                        ADDMEMCYCLE
                        MOVS    regA, rscratch LSL #24
			UPDATE_ZN
			MEND

			MACRO
			OpAAX0
			; ======================================
			; CPU.Cycles += ONE_CYCLE;
			; Registers.X.W = Registers.A.W;
			; SetZN16 (Registers.X.W);
			; ======================================
			ADDONECYCLE
			MOVS regX, regA
			UPDATE_ZN
			MEND

			MACRO
			OpAAX1
			; ======================================
			; CPU.Cycles += ONE_CYCLE;
			; Registers.XL = Registers.AL;
			; SetZN8 (Registers.XL);
			; ======================================
			ADDONECYCLE
			MOVS regX, regA
			UPDATE_ZN
			MEND

			MACRO
			OpAB
			; ======================================
			; CPU.Cycles += TWO_CYCLES;
			; PullB (Registers.DB);
			; SetZN8 (Registers.DB);
			; ICPU.ShiftedDB = Registers.DB << 16;
			; ======================================
			ADDONECYCLE
			PullBLow regDBank
			UPADTE_ZN
			MEND

			MACRO
			OpB0
			; ======================================
			; asmRelative
			; BranchCheck0
			; if (CheckCarry ())
			; {
			; CPU.PC = CPU.PCBase + OpAddress;
			; CPU.Cycles += ONE_CYCLE;
			; }
			; ======================================
			asmRelative
			CPUShutdown
			BranchCheck0
			TST rstatus, MASKAND_CARRY
                        ADDNE rpc, rscratch, regpcbase ; rpc = OpAddress + PCBase
                        ADDCYCLENE
			MEND

			MACRO
			OpB8
			; ======================================
			; ClearOverflow ();
			; CPU.Cycles += ONE_CYCLE;
			; ======================================
			AND rstatus, rstatus, #MASKAND_OVERFLOW
			ADDCYCLE
                        MEND

			MACRO
			OpBAX0
			; ======================================
			; CPU.Cycles += ONE_CYCLE;
			; Registers.X.W = Registers.S.W;
			; SetZN16 (Registers.X.W);
			; ======================================
			ADDONECYCLE
			MOVS regX, regS LSL #16
			UPDATE_ZN
			MEND

			MACRO
			OpBAX1
			; ======================================
			; CPU.Cycles += ONE_CYCLE;
			; Registers.XL = Registers.SL;
			; SetZN8 (Registers.XL);
			; ======================================
			ADDONECYCLE
			MOVS regX, regS LSL #24
			UPDATE_ZN
			MEND

			MACRO
			OpBBX0
			; ======================================
			; CPU.Cycles += ONE_CYCLE;
			; Registers.X.W = Registers.Y.W;
			; SetZN16 (Registers.X.W);
			; ======================================
			ADDONECYCLE
			MOVS regX, regY
			UPDATE_ZN
			MEND

			MACRO
			OpBBX1
			; ======================================
			; CPU.Cycles += ONE_CYCLE;
			; Registers.XL = Registers.YL;
			; SetZN8 (Registers.XL);
			; ======================================
			ADDONECYCLE
			MOVS regX, regY
			UPDATE_ZN
			MEND

			MACRO
			OpC0X0
			; ======================================
			; Int32 = (long) Registers.Y.W -
			; (long) (*CPU.PC + (*(CPU.PC + 1) << 8));
			; ICPU._Carry = Int32 >= 0;
			; SetZN16 ((uint16) Int32);
			; CPU.PC += 2;
			; CPU.Cycles += CPU.MemSpeedx2;
			; ======================================
			LDRB	rscratch    , [rpc, #1]!
			LDRB	rscratch2   , [rpc, #1]!
			ADDMEMSPEED2
			ORR	rscratch, rscratch, rscratch2 LSL #8
			SUBS	rscratch2   , regY, rscratch LSL #16
			UPDATE_ZN
			; ???? CHECK CARRY ?
			UPDATE_C
			MEND

			MACRO
			OpC0X1
			; ======================================
			; Int32 = (int) Registers.YL - (int) *CPU.PC++;
			; ICPU._Carry = Int32 >= 0;
			; SetZN8 ((uint8) Int32);
			; CPU.Cycles += CPU.MemSpeed;
			; ======================================
			LDRB	rscratch    , [rpc, #1]!
			ADDMEMSPEED
			SUBS	rscratch2   , regY , rscratch LSL #24
			UPDATE_ZN
			; ???? CHECK CARRY ?
			UPDATE_C
			MEND

			MACRO
			OpC2
			; ======================================
			; TO DO C->ASM
			; Work8 = ~*CPU.PC++;
			; Registers.PL &= Work8;
			; ICPU._Carry &= Work8;
			; ICPU._Overflow &= (Work8 >> 6);
			; ICPU._Negative &= Work8;
			; ICPU._Zero |= ~Work8 & Zero;
			; CPU.Cycles += CPU.MemSpeed + ONE_CYCLE;
			; if (CheckEmulation())
			; {
			; SetFlags (MemoryFlag | IndexFlag);
			; missing.emulate6502 = 1;
			; }
			; if (CheckIndex ())
			; {
			; Registers.XH = 0;
			; Registers.YH = 0;
			; }
			; S9xFixCycles();
			; CHECK_FOR_IRQ();
			; ======================================
			LDRB	rscratch    , [rpc, #1]!
			MVN	rscratch, rscratch







			MEND

			MACRO
			OpC8X0
			; ======================================
			; CPU.Cycles += ONE_CYCLE;
			; Registers.Y.W++;
			; SetZN16 (Registers.Y.W);
			; ======================================
			ADDONECYCLE
			ADDS regY, regY, 0x00010000
			UPDATE_ZN
			MEND

			MACRO
			OpC8X1
			; ======================================
			; CPU.Cycles += ONE_CYCLE;
			; Registers.YL++;
			; SetZN8 (Registers.YL);
			; ======================================
			ADDONECYCLE
			ADDS regY, regY, 0x01000000
			UPDATE_ZN
			MEND

			MACRO
			OpC9M0
			; ======================================
			; Int32 = (long) Registers.A.W -
			; (long) (*CPU.PC + (*(CPU.PC + 1) << 8));
			; ICPU._Carry = Int32 >= 0;
			; SetZN16 ((uint16) Int32);
			; CPU.PC += 2;
			; CPU.Cycles += CPU.MemSpeedx2;
			; ======================================
			LDRB	rscratch    , [rpc, #1]!
			LDRB	rscratch2   , [rpc, #1]!
			ADDMEMSPEED2
			ORR	rscratch, rscratch, rscratch2 LSL #8
			SUBS	rscratch2   , regA, rscratch LSL #16
			UPDATE_ZN
			; ???? CHECK CARRY ?
			UPDATE_C
			MEND

			MACRO
			OpC9M1
			; ======================================
			; Int32 = (int) Registers.AL - (int) *CPU.PC++;
			; ICPU._Carry = Int32 >= 0;
			; SetZN8 ((uint8) Int32);
			; CPU.Cycles += CPU.MemSpeed;
			; ======================================
			LDRB	rscratch    , [rpc, #1]!
			ADDMEMSPEED
			SUBS	rscratch2   , regA , rscratch LSL #24
			UPDATE_ZN
			; ???? CHECK CARRY ?
			UPDATE_C
			MEND

			MACRO
			OpCAX0
			; ======================================
			; CPU.Cycles += ONE_CYCLE;
			; Registers.X.W--;
			; SetZN16 (Registers.X.W);
			; ======================================
			ADDONECYCLE
			SUBS regX, regX, 0x00010000
			UPDATE_ZN
			MEND

			MACRO
			OpCAX1
			; ======================================
			; CPU.Cycles += ONE_CYCLE;
			; Registers.XL--;
			; SetZN8 (Registers.XL);
			; ======================================
			ADDONECYCLE
			SUBS regX, regX, 0x01000000
			UPDATE_ZN
			MEND

			MACRO
			OpCB
			; ======================================
			; TO DO C->ASM
			; if (CPU.IRQActive)
			;   CPU.Cycles += TWO_CYCLES;
			; else
			; {
			;  CPU.WaitingForInterrupt = TRUE;
			;  CPU.PC--;
			;  if (Settings.Shutdown)
			;  {
			;   CPU.Cycles = CPU.NextEvent;
			;   if (IAPU.APUExecuting)
			;   {
			;    ICPU.CPUExecuting = FALSE;
			;    do
			;    {
			;     APU_EXECUTE1
			;    }
			;    while (APU.Cycles < CPU.NextEvent); ;//multithread ? empty loop ?
			;    ICPU.CPUExecuting = TRUE;
			;   }
			;  }
			; }
			; ======================================
			MEND

			MACRO
			OpD0
			; ======================================
			; asmRelative
			; CPUShutdown
			; BranchCheck1
			; if (!CheckZero ())
			; {
			; CPU.PC = CPU.PCBase + OpAddress;
			; CPU.Cycles += ONE_CYCLE;
			; }
			; ======================================
			asmRelative
			CPUShutdown
			BranchCheck1
			TST rstatus, MASKAND_ZERO
                        ADDEQ rpc, rscratch, regpcbase ; rpc = OpAddress + PCBase
                        ADDCYCLEEQ
			MEND

			MACRO
			OpD8
			; ======================================
			; ClearDecimal
			; CPU.Cycles += ONE_CYCLE;
			; ======================================
			ClearDecimal
			ADDONECYCLE
			MEND

			MACRO
			OpDAX0
			; ======================================
			; PushW (Registers.X.W);
			; CPU.Cycles += ONE_CYCLE;
			; ======================================
			PushW regX
			ADDONECYCLE
			MEND

			MACRO
			OpDAX1
			; ======================================
			; PushB (Registers.XL);
			; CPU.Cycles += ONE_CYCLE;
			; ======================================
			PushB regX
			ADDONECYCLE
			MEND

			MACRO
			OpDC
			; ======================================
			; AbsoluteIndirectLong
			; Registers.PB = (uint8) (OpAddress >> 16);
			; ICPU.ShiftedPB = OpAddress & 0xff0000;
			; S9xSetPCBase (OpAddress);
			; CPU.Cycles += TWO_CYCLES;
			; ======================================
			AbsoluteIndirectLong
			MOV regPBank, rscratch LSR #16
			S9xSetPCBase rscratch
			ADDTWOCYCLE
			MEND

			MACRO
			OpE0X0
			; ======================================
			; Int32 = (long) Registers.X.W -
			; (long) (*CPU.PC + (*(CPU.PC + 1) << 8));
			; ICPU._Carry = Int32 >= 0;
			; SetZN16 ((uint16) Int32);
			; CPU.PC += 2;
			; CPU.Cycles += CPU.MemSpeedx2;
			; ======================================
			LDRB	rscratch    , [rpc, #1]!
			LDRB	rscratch2   , [rpc, #1]!
			ADDMEMSPEED2
			ORR	rscratch, rscratch, rscratch2 LSL #8
			SUBS	rscratch2   , regX, rscratch LSL #16
			UPDATE_ZN
			; ???? CHECK CARRY ?
			UPDATE_C
			MEND

			MACRO
			OpE0X1
			; ======================================
			; Int32 = (int) Registers.XL - (int) *CPU.PC++;
			; ICPU._Carry = Int32 >= 0;
			; SetZN8 ((uint8) Int32);
			; CPU.Cycles += CPU.MemSpeed;
			; ======================================
			LDRB	rscratch    , [rpc, #1]!
			ADDMEMSPEED
			SUBS	rscratch2   , regX , rscratch LSL #24
			UPDATE_ZN
			; ???? CHECK CARRY ?
			UPDATE_C
			MEND

			MACRO
			OpE2
			; ======================================
			; TO DO C->ASM
			; Work8 = *CPU.PC++;
			; Registers.PL |= Work8;
			; ICPU._Carry |= Work8 & 1;
			; ICPU._Overflow |= (Work8 >> 6) & 1;
			; ICPU._Negative |= Work8;
			; if (Work8 & Zero)
			; ICPU._Zero = 0;
			; CPU.Cycles += CPU.MemSpeed + ONE_CYCLE;
			; if (CheckEmulation())
			; {
			; SetFlags (MemoryFlag | IndexFlag);
			; missing.emulate6502 = 1;
			; }
			; if (CheckIndex ())
			; {
			; Registers.XH = 0;
			; Registers.YH = 0;
			; }
			; S9xFixCycles();
			; ======================================
			LDRB	rscratch    , [rpc, #1]!
			; TO DO ????
			MEND

			MACRO
			OpE8X0
			; ======================================
			; CPU.Cycles += ONE_CYCLE;
			; Registers.X.W++;
			; SetZN16 (Registers.X.W);
			; ======================================
			ADDONECYCLE
			ADDS regX, regX, 0x00010000
			UPDATE_ZN
			MEND

			MACRO
			OpE8X1
			; ======================================
			; CPU.Cycles += ONE_CYCLE;
			; Registers.XL++;
			; SetZN8 (Registers.XL);
			; ======================================
			ADDONECYCLE
			ADDS regX, regX, 0x01000000
			UPDATE_ZN
			MEND

			MACRO
			OpEA
			; ======================================
			; TO DO C->ASM
			; CPU.Cycles += ONE_CYCLE;
			; ======================================
			ADDONECCYCLE
			; ???? NOT A NOP ????
			MEND

			MACRO
			OpEB
			; ======================================
			; Work8 = Registers.AL;
			; Registers.AL = Registers.AH;
			; Registers.AH = Work8;
			; SetZN8 (Registers.AL);
			; CPU.Cycles += TWO_CYCLES;
			; ======================================
			; hhll0000 -> llhh0000
			; hhll
			MOV rscratch, regA ROR #24 ; ll0000hh
			AND rscratch, rscratch, regA LSR #8; ll0000hh + 00hhll00 -> llhhllhh
			MOVS rscratch, rscratch LSL #16; llhhllhh -> llhh0000
			ADDTWOCYCLE
			; ???? TO DO : SetZN8 ?!?!?!
			MEND

			MACRO
			OpF0
			; ======================================
			; asmRelative
			; CPUShutdown
			; BranchCheck2
			; if (CheckZero ())
			; {
			; CPU.PC = CPU.PCBase + OpAddress;
			; CPU.Cycles += ONE_CYCLE;
			; }
			; ======================================
			asmRelative
			CPUShutdown
			BranchCheck2
			TST rstatus, MASKAND_ZERO
                        ADDNE rpc, rscratch, regpcbase; rpc = OpAddress +PCBase
                        ADDCYCLENE
			MEND

			MACRO
			OpF8
			; ======================================
			; SetDecimal
			; CPU.Cycles += ONE_CYCLE;
			; missing.decimal_mode = 1;
			; ======================================
			SetDecimal
			ADDONECYCLE
			; missing.decimal_mode ???? whats the fuck again ????
			MEND

			MACRO
			OpFAX0
			; ======================================
			; CPU.Cycles += TWO_CYCLES;
			; PullW (Registers.X.W);
			; SetZN16 (Registers.X.W);
			; ======================================
			PullW regX
			UPDATE_ZN
			ADDTWOCYCLE
			MEND

			MACRO
			OpFAX1
			; ======================================
			; CPU.Cycles += TWO_CYCLES;
			; PullB (Registers.XL);
			; SetZN8 (Registers.XL);
			; ======================================
			PullB regX
			UPDATE_ZN
			ADDTWOCYCLE
			MEND

			MACRO
			OpFB
			; ======================================
			; TO DO C->ASM
			; CPU.Cycles += ONE_CYCLE;
			; A1 = ICPU._Carry;
			; A2 = Registers.PH;
			; ICPU._Carry = A2 & 1;
			; Registers.PH = A1;
			; if (CheckEmulation())
			; {
			; SetFlags (MemoryFlag | IndexFlag);
			; Registers.SH = 1;
			; missing.emulate6502 = 1;
			; }
			; if (CheckIndex ())
			; {
			; Registers.XH = 0;
			; Registers.YH = 0;
			; }
			; S9xFixCycles();
			; ======================================
			MEND

			MACRO
			OpFC
			; ======================================
			; TO DO C->ASM
			; AbsoluteIndexedIndirect
			; PushW (CPU.PC - CPU.PCBase - 1);
			; S9xSetPCBase (ICPU.ShiftedPB + OpAddress);
			; CPU.Cycles += ONE_CYCLE;
			; ======================================
			MEND


nextinstructionmod1
			; Empty	for the	moment...
executeinstructionmod1
			LDRB	regopcode, [rpc], #1		; Load opcode, snespc++
			LDR	PC, [PC, regopcode,lsl #2]	; Go to	execute	correct	routine
			; From here jump table that modify the PC
			MOV	R0,R0	; Dummy	instruction NOP	 DO NOT	REMOVE
						; align	jmptbl with ARM	PC, never executed
jumptable1		DCD	Op00mod1
			DCD	Op01M1mod1
			DCD	Op02mod1
			DCD	Op03M1mod1
			DCD	Op04M1mod1
			DCD	Op05M1mod1
			DCD	Op06M1mod1
			DCD	Op07M1mod1
			DCD	Op08mod1
			DCD	Op09M1mod1
			DCD	Op0AM1mod1
			DCD	Op0Bmod1
			DCD	Op0CM1mod1
			DCD	Op0DM1mod1
			DCD	Op0EM1mod1
			DCD	Op0FM1mod1
			DCD	Op10mod1
			DCD	Op11M1mod1
			DCD	Op12M1mod1
			DCD	Op13M1mod1
			DCD	Op14M1mod1
			DCD	Op15M1mod1
			DCD	Op16M1mod1
			DCD	Op17M1mod1
			DCD	Op18mod1
			DCD	Op19M1mod1
			DCD	Op1AM1mod1
			DCD	Op1Bmod1
			DCD	Op1CM1mod1
			DCD	Op1DM1mod1
			DCD	Op1EM1mod1
			DCD	Op1FM1mod1
			DCD	Op20mod1
			DCD	Op21M1mod1
			DCD	Op22mod1
			DCD	Op23M1mod1
			DCD	Op24M1mod1
			DCD	Op25M1mod1
			DCD	Op26M1mod1
			DCD	Op27M1mod1
			DCD	Op28mod1
			DCD	Op29M1mod1
			DCD	Op2AM1mod1
			DCD	Op2Bmod1
			DCD	Op2CM1mod1
			DCD	Op2DM1mod1
			DCD	Op2EM1mod1
			DCD	Op2FM1mod1
			DCD	Op30mod1
			DCD	Op31M1mod1
			DCD	Op32M1mod1
			DCD	Op33M1mod1
			DCD	Op34M1mod1
			DCD	Op35M1mod1
			DCD	Op36M1mod1
			DCD	Op37M1mod1
			DCD	Op38mod1
			DCD	Op39M1mod1
			DCD	Op3AM1mod1
			DCD	Op3Bmod1
			DCD	Op3CM1mod1
			DCD	Op3DM1mod1
			DCD	Op3EM1mod1
			DCD	Op3FM1mod1
			DCD	Op40mod1
			DCD	Op41M1mod1
			DCD	Op42mod1
			DCD	Op43M1mod1
			DCD	Op44X1mod1
			DCD	Op45M1mod1
			DCD	Op46M1mod1
			DCD	Op47M1mod1
			DCD	Op48M1mod1
			DCD	Op49M1mod1
			DCD	Op4AM1mod1
			DCD	Op4Bmod1
			DCD	Op4Cmod1
			DCD	Op4DM1mod1
			DCD	Op4EM1mod1
			DCD	Op4FM1mod1
			DCD	Op50mod1
			DCD	Op51M1mod1
			DCD	Op52M1mod1
			DCD	Op53M1mod1
			DCD	Op54X1mod1
			DCD	Op55M1mod1
			DCD	Op56M1mod1
			DCD	Op57M1mod1
			DCD	Op58mod1
			DCD	Op59M1mod1
			DCD	Op5AX1mod1
			DCD	Op5Bmod1
			DCD	Op5Cmod1
			DCD	Op5DM1mod1
			DCD	Op5EM1mod1
			DCD	Op5FM1mod1
			DCD	Op60mod1
			DCD	Op61M1mod1
			DCD	Op62mod1
			DCD	Op63M1mod1
			DCD	Op64M1mod1
			DCD	Op65M1mod1
			DCD	Op66M1mod1
			DCD	Op67M1mod1
			DCD	Op68M1mod1
			DCD	Op69M1mod1
			DCD	Op6AM1mod1
			DCD	Op6Bmod1
			DCD	Op6Cmod1
			DCD	Op6DM1mod1
			DCD	Op6EM1mod1
			DCD	Op6FM1mod1
			DCD	Op70mod1
			DCD	Op71M1mod1
			DCD	Op72M1mod1
			DCD	Op73M1mod1
			DCD	Op74M1mod1
			DCD	Op75M1mod1
			DCD	Op76M1mod1
			DCD	Op77M1mod1
			DCD	Op78mod1
			DCD	Op79M1mod1
			DCD	Op7AX1mod1
			DCD	Op7Bmod1
			DCD	Op7Cmod1
			DCD	Op7DM1mod1
			DCD	Op7EM1mod1
			DCD	Op7FM1mod1
			DCD	Op80mod1
			DCD	Op81M1mod1
			DCD	Op82mod1
			DCD	Op83M1mod1
			DCD	Op84X1mod1
			DCD	Op85M1mod1
			DCD	Op86X1mod1
			DCD	Op87M1mod1
			DCD	Op88X1mod1
			DCD	Op89M1mod1
			DCD	Op8AM1mod1
			DCD	Op8Bmod1
			DCD	Op8CX1mod1
			DCD	Op8DM1mod1
			DCD	Op8EX1mod1
			DCD	Op8FM1mod1
			DCD	Op90mod1
			DCD	Op91M1mod1
			DCD	Op92M1mod1
			DCD	Op93M1mod1
			DCD	Op94X1mod1
			DCD	Op95M1mod1
			DCD	Op96X1mod1
			DCD	Op97M1mod1
			DCD	Op98M1mod1
			DCD	Op99M1mod1
			DCD	Op9Amod1
			DCD	Op9BX1mod1
			DCD	Op9CM1mod1
			DCD	Op9DM1mod1
			DCD	Op9EM1mod1
			DCD	Op9FM1mod1
			DCD	OpA0X1mod1
			DCD	OpA1M1mod1
			DCD	OpA2X1mod1
			DCD	OpA3M1mod1
			DCD	OpA4X1mod1
			DCD	OpA5M1mod1
			DCD	OpA6X1mod1
			DCD	OpA7M1mod1
			DCD	OpA8X1mod1
			DCD	OpA9M1mod1
			DCD	OpAAX1mod1
			DCD	OpABmod1
			DCD	OpACX1mod1
			DCD	OpADM1mod1
			DCD	OpAEX1mod1
			DCD	OpAFM1mod1
			DCD	OpB0mod1
			DCD	OpB1M1mod1
			DCD	OpB2M1mod1
			DCD	OpB3M1mod1
			DCD	OpB4X1mod1
			DCD	OpB5M1mod1
			DCD	OpB6X1mod1
			DCD	OpB7M1mod1
			DCD	OpB8mod1
			DCD	OpB9M1mod1
			DCD	OpBAX1mod1
			DCD	OpBBX1mod1
			DCD	OpBCX1mod1
			DCD	OpBDM1mod1
			DCD	OpBEX1mod1
			DCD	OpBFM1mod1
			DCD	OpC0X1mod1
			DCD	OpC1M1mod1
			DCD	OpC2mod1
			DCD	OpC3M1mod1
			DCD	OpC4X1mod1
			DCD	OpC5M1mod1
			DCD	OpC6M1mod1
			DCD	OpC7M1mod1
			DCD	OpC8X1mod1
			DCD	OpC9M1mod1
			DCD	OpCAX1mod1
			DCD	OpCBmod1
			DCD	OpCCX1mod1
			DCD	OpCDM1mod1
			DCD	OpCEM1mod1
			DCD	OpCFM1mod1
			DCD	OpD0mod1
			DCD	OpD1M1mod1
			DCD	OpD2M1mod1
			DCD	OpD3M1mod1
			DCD	OpD4mod1
			DCD	OpD5M1mod1
			DCD	OpD6M1mod1
			DCD	OpD7M1mod1
			DCD	OpD8mod1
			DCD	OpD9M1mod1
			DCD	OpDAX1mod1
			DCD	OpDBmod1
			DCD	OpDCmod1
			DCD	OpDDM1mod1
			DCD	OpDEM1mod1
			DCD	OpDFM1mod1
			DCD	OpE0X1mod1
			DCD	OpE1M1mod1
			DCD	OpE2mod1
			DCD	OpE3M1mod1
			DCD	OpE4X1mod1
			DCD	OpE5M1mod1
			DCD	OpE6M1mod1
			DCD	OpE7M1mod1
			DCD	OpE8X1mod1
			DCD	OpE9M1mod1
			DCD	OpEAmod1
			DCD	OpEBmod1
			DCD	OpECX1mod1
			DCD	OpEDM1mod1
			DCD	OpEEM1mod1
			DCD	OpEFM1mod1
			DCD	OpF0mod1
			DCD	OpF1M1mod1
			DCD	OpF2M1mod1
			DCD	OpF3M1mod1
			DCD	OpF4mod1
			DCD	OpF5M1mod1
			DCD	OpF6M1mod1
			DCD	OpF7M1mod1
			DCD	OpF8mod1
			DCD	OpF9M1mod1
			DCD	OpFAX1mod1
			DCD	OpFBmod1
			DCD	OpFCmod1
			DCD	OpFDM1mod1
			DCD	OpFEM1mod1
			DCD	OpFFM1mod1
Op00mod1
lbl00mod1		Op00
			B	nextinstructionmod1
Op01M1mod1
lbl01mod1a		DirectIndexedIndirect
lbl01mod1b		ORA8
			B	nextinstructionmod1
Op02mod1
lbl02mod1		Op02
			B	nextinstructionmod1
Op03M1mod1
lbl03mod1a		StackasmRelative
lbl03mod1b		ORA8
			B	nextinstructionmod1
Op04M1mod1
lbl04mod1a		Direct
lbl04mod1b		TSB8
			B	nextinstructionmod1
Op05M1mod1
lbl05mod1a		Direct
lbl05mod1b		ORA8
			B	nextinstructionmod1
Op06M1mod1
lbl06mod1a		Direct
lbl06mod1b		ASL8
			B	nextinstructionmod1
Op07M1mod1
lbl07mod1a		DirectIndirectLong
lbl07mod1b		ORA8
			B	nextinstructionmod1
Op08mod1
lbl08mod1		Op08
			B	nextinstructionmod1
Op09M1mod1
lbl09mod1		Op09M1
			B	nextinstructionmod1
Op0AM1mod1
lbl0Amod1a		A_ASL8
			B	nextinstructionmod1
Op0Bmod1
lbl0Bmod1		Op0B
			B	nextinstructionmod1
Op0CM1mod1
lbl0Cmod1a		Absolute
lbl0Cmod1b		TSB8
			B	nextinstructionmod1
Op0DM1mod1
lbl0Dmod1a		Absolute
lbl0Dmod1b		ORA8
			B	nextinstructionmod1
Op0EM1mod1
lbl0Emod1a		Absolute
lbl0Emod1b		ASL8
			B	nextinstructionmod1
Op0FM1mod1
lbl0Fmod1a		AbsoluteLong
lbl0Fmod1b		ORA8
			B	nextinstructionmod1
Op10mod1
lbl10mod1		Op10
			B	nextinstructionmod1
Op11M1mod1
lbl11mod1a		DirectIndirectIndexed
lbl11mod1b		ORA8
			B	nextinstructionmod1
Op12M1mod1
lbl12mod1a		DirectIndirect
lbl12mod1b		ORA8
			B	nextinstructionmod1
Op13M1mod1
lbl13mod1a		StackasmRelativeIndirectIndexed
lbl13mod1b		ORA8
			B	nextinstructionmod1
Op14M1mod1
lbl14mod1a		Direct
lbl14mod1b		TRB8
			B	nextinstructionmod1
Op15M1mod1
lbl15mod1a		DirectIndexedX
lbl15mod1b		ORA8
			B	nextinstructionmod1
Op16M1mod1
lbl16mod1a		DirectIndexedX
lbl16mod1b		ASL8
			B	nextinstructionmod1
Op17M1mod1
lbl17mod1a		DirectIndirectIndexedLong
lbl17mod1b		ORA8
			B	nextinstructionmod1
Op18mod1
lbl18mod1		Op18
			B	nextinstructionmod1
Op19M1mod1
lbl19mod1a		AbsoluteIndexedY
lbl19mod1b		ORA8
			B	nextinstructionmod1
Op1AM1mod1
lbl1Amod1a		A_INC8
			B	nextinstructionmod1
Op1Bmod1
lbl1Bmod1		Op1B
			B	nextinstructionmod1
Op1CM1mod1
lbl1Cmod1a		Absolute
lbl1Cmod1b		TRB8
			B	nextinstructionmod1
Op1DM1mod1
lbl1Dmod1a		AbsoluteIndexedX
lbl1Dmod1b		ORA8
			B	nextinstructionmod1
Op1EM1mod1
lbl1Emod1a		AbsoluteIndexedX
lbl1Emod1b		ASL8
			B	nextinstructionmod1
Op1FM1mod1
lbl1Fmod1a		AbsoluteLongIndexedX
lbl1Fmod1b		ORA8
			B	nextinstructionmod1
Op20mod1
lbl20mod1		Op20
			B	nextinstructionmod1
Op21M1mod1
lbl21mod1a		DirectIndexedIndirect
lbl21mod1b		AND8
			B	nextinstructionmod1
Op22mod1
lbl22mod1		Op22
			B	nextinstructionmod1
Op23M1mod1
lbl23mod1a		StackasmRelative
lbl23mod1b		AND8
			B	nextinstructionmod1
Op24M1mod1
lbl24mod1a		Direct
lbl24mod1b		BIT8
			B	nextinstructionmod1
Op25M1mod1
lbl25mod1a		Direct
lbl25mod1b		AND8
			B	nextinstructionmod1
Op26M1mod1
lbl26mod1a		Direct
lbl26mod1b		ROL8
			B	nextinstructionmod1
Op27M1mod1
lbl27mod1a		DirectIndirectLong
lbl27mod1b		AND8
			B	nextinstructionmod1
Op28mod1
lbl28mod1		Op28
			B	nextinstructionmod1
Op29M1mod1
lbl29mod1		Op29M1
			B	nextinstructionmod1
Op2AM1mod1
lbl2Amod1a		A_ROL8
			B	nextinstructionmod1
Op2Bmod1
lbl2Bmod1		Op2B
			B	nextinstructionmod1
Op2CM1mod1
lbl2Cmod1a		Absolute
lbl2Cmod1b		BIT8
			B	nextinstructionmod1
Op2DM1mod1
lbl2Dmod1a		Absolute
lbl2Dmod1b		AND8
			B	nextinstructionmod1
Op2EM1mod1
lbl2Emod1a		Absolute
lbl2Emod1b		ROL8
			B	nextinstructionmod1
Op2FM1mod1
lbl2Fmod1a		AbsoluteLong
lbl2Fmod1b		AND8
			B	nextinstructionmod1
Op30mod1
lbl30mod1		Op30
			B	nextinstructionmod1
Op31M1mod1
lbl31mod1a		DirectIndirectIndexed
lbl31mod1b		AND8
			B	nextinstructionmod1
Op32M1mod1
lbl32mod1a		DirectIndirect
lbl32mod1b		AND8
			B	nextinstructionmod1
Op33M1mod1
lbl33mod1a		StackasmRelativeIndirectIndexed
lbl33mod1b		AND8
			B	nextinstructionmod1
Op34M1mod1
lbl34mod1a		DirectIndexedX
lbl34mod1b		BIT8
			B	nextinstructionmod1
Op35M1mod1
lbl35mod1a		DirectIndexedX
lbl35mod1b		AND8
			B	nextinstructionmod1
Op36M1mod1
lbl36mod1a		DirectIndexedX
lbl36mod1b		ROL8
			B	nextinstructionmod1
Op37M1mod1
lbl37mod1a		DirectIndirectIndexedLong
lbl37mod1b		AND8
			B	nextinstructionmod1
Op38mod1
lbl38mod1		Op38
			B	nextinstructionmod1
Op39M1mod1
lbl39mod1a		AbsoluteIndexedY
lbl39mod1b		AND8
			B	nextinstructionmod1
Op3AM1mod1
lbl3Amod1a		A_DEC8
			B	nextinstructionmod1
Op3Bmod1
lbl3Bmod1		Op3B
			B	nextinstructionmod1
Op3CM1mod1
lbl3Cmod1a		AbsoluteIndexedX
lbl3Cmod1b		BIT8
			B	nextinstructionmod1
Op3DM1mod1
lbl3Dmod1a		AbsoluteIndexedX
lbl3Dmod1b		AND8
			B	nextinstructionmod1
Op3EM1mod1
lbl3Emod1a		AbsoluteIndexedX
lbl3Emod1b		ROL8
			B	nextinstructionmod1
Op3FM1mod1
lbl3Fmod1a		AbsoluteLongIndexedX
lbl3Fmod1b		AND8
			B	nextinstructionmod1
Op40mod1
lbl40mod1		Op40
			B	nextinstructionmod1
Op41M1mod1
lbl41mod1a		DirectIndexedIndirect
lbl41mod1b		EOR8
			B	nextinstructionmod1
Op42mod1
lbl42mod1a
			B	nextinstructionmod1
Op43M1mod1
lbl43mod1a		StackasmRelative
lbl43mod1b		EOR8
			B	nextinstructionmod1
Op44X1mod1
lbl44mod1		Op44X1
			B	nextinstructionmod1
Op45M1mod1
lbl45mod1a		Direct
lbl45mod1b		EOR8
			B	nextinstructionmod1
Op46M1mod1
lbl46mod1a		Direct
lbl46mod1b		LSR8
			B	nextinstructionmod1
Op47M1mod1
lbl47mod1a		DirectIndirectLong
lbl47mod1b		EOR8
			B	nextinstructionmod1
Op48M1mod1
lbl48mod1		Op48M1
			B	nextinstructionmod1
Op49M1mod1
lbl49mod1		Op49M1
			B	nextinstructionmod1
Op4AM1mod1
lbl4Amod1a		A_LSR8
			B	nextinstructionmod1
Op4Bmod1
lbl4Bmod1		Op4B
			B	nextinstructionmod1
Op4Cmod1
lbl4Cmod1a		Absolute
lbl4Cmod1b		S9xSetPCBase (ICPU.ShiftedPB + (OpAddress & 0xffff));
			B	nextinstructionmod1
Op4DM1mod1
lbl4Dmod1a		Absolute
lbl4Dmod1b		EOR8
			B	nextinstructionmod1
Op4EM1mod1
lbl4Emod1a		Absolute
lbl4Emod1b		LSR8
			B	nextinstructionmod1
Op4FM1mod1
lbl4Fmod1a		AbsoluteLong
lbl4Fmod1b		EOR8
			B	nextinstructionmod1
Op50mod1
lbl50mod1		Op50
			B	nextinstructionmod1
Op51M1mod1
lbl51mod1a		DirectIndirectIndexed
lbl51mod1b		EOR8
			B	nextinstructionmod1
Op52M1mod1
lbl52mod1a		DirectIndirect
lbl52mod1b		EOR8
			B	nextinstructionmod1
Op53M1mod1
lbl53mod1a		StackasmRelativeIndirectIndexed
lbl53mod1b		EOR8
			B	nextinstructionmod1
Op54X1mod1
lbl54mod1		Op54X1
			B	nextinstructionmod1
Op55M1mod1
lbl55mod1a		DirectIndexedX
lbl55mod1b		EOR8
			B	nextinstructionmod1
Op56M1mod1
lbl56mod1a		DirectIndexedX
lbl56mod1b		LSR8
			B	nextinstructionmod1
Op57M1mod1
lbl57mod1a		DirectIndirectIndexedLong
lbl57mod1b		EOR8
			B	nextinstructionmod1
Op58mod1
lbl58mod1		Op58
			B	nextinstructionmod1
Op59M1mod1
lbl59mod1a		AbsoluteIndexedY
lbl59mod1b		EOR8
			B	nextinstructionmod1
Op5AX1mod1
lbl5Amod1		Op5AX1
			B	nextinstructionmod1
Op5Bmod1
lbl5Bmod1		Op5B
			B	nextinstructionmod1
Op5Cmod1
lbl5Cmod1		Op5C
			B	nextinstructionmod1
Op5DM1mod1
lbl5Dmod1a		AbsoluteIndexedX
lbl5Dmod1b		EOR8
			B	nextinstructionmod1
Op5EM1mod1
lbl5Emod1a		AbsoluteIndexedX
lbl5Emod1b		LSR8
			B	nextinstructionmod1
Op5FM1mod1
lbl5Fmod1a		AbsoluteLongIndexedX
lbl5Fmod1b		EOR8
			B	nextinstructionmod1
Op60mod1
lbl60mod1		Op60
			B	nextinstructionmod1
Op61M1mod1
lbl61mod1a		DirectIndexedIndirect
lbl61mod1b		ADC8
			B	nextinstructionmod1
Op62mod1
lbl62mod1a		asmRelativeLong
lbl62mod1b		PushW (OpAddress);
			B	nextinstructionmod1
Op63M1mod1
lbl63mod1a		StackasmRelative
lbl63mod1b		ADC8
			B	nextinstructionmod1
Op64M1mod1
lbl64mod1a		Direct
lbl64mod1b		STZ8
			B	nextinstructionmod1
Op65M1mod1
lbl65mod1a		Direct
lbl65mod1b		ADC8
			B	nextinstructionmod1
Op66M1mod1
lbl66mod1a		Direct
lbl66mod1b		ROR8
			B	nextinstructionmod1
Op67M1mod1
lbl67mod1a		DirectIndirectLong
lbl67mod1b		ADC8
			B	nextinstructionmod1
Op68M1mod1
lbl68mod1		Op68M1
			B	nextinstructionmod1
Op69M1mod1
lbl69mod1a		Immediate8
lbl69mod1b		ADC8
			B	nextinstructionmod1
Op6AM1mod1
lbl6Amod1a		A_ROR8
			B	nextinstructionmod1
Op6Bmod1
lbl6Bmod1		Op6B
			B	nextinstructionmod1
Op6Cmod1
lbl6Cmod1a		AbsoluteIndirect
lbl6Cmod1b		S9xSetPCBase (ICPU.ShiftedPB + (OpAddress & 0xffff));
			B	nextinstructionmod1
Op6DM1mod1
lbl6Dmod1a		Absolute
lbl6Dmod1b		ADC8
			B	nextinstructionmod1
Op6EM1mod1
lbl6Emod1a		Absolute
lbl6Emod1b		ROR8
			B	nextinstructionmod1
Op6FM1mod1
lbl6Fmod1a		AbsoluteLong
lbl6Fmod1b		ADC8
			B	nextinstructionmod1
Op70mod1
lbl70mod1		Op70
			B	nextinstructionmod1
Op71M1mod1
lbl71mod1a		DirectIndirectIndexed
lbl71mod1b		ADC8
			B	nextinstructionmod1
Op72M1mod1
lbl72mod1a		DirectIndirect
lbl72mod1b		ADC8
			B	nextinstructionmod1
Op73M1mod1
lbl73mod1a		StackasmRelativeIndirectIndexed
lbl73mod1b		ADC8
			B	nextinstructionmod1
Op74M1mod1
lbl74mod1a		DirectIndexedX
lbl74mod1b		STZ8
			B	nextinstructionmod1
Op75M1mod1
lbl75mod1a		DirectIndexedX
lbl75mod1b		ADC8
			B	nextinstructionmod1
Op76M1mod1
lbl76mod1a		DirectIndexedX
lbl76mod1b		ROR8
			B	nextinstructionmod1
Op77M1mod1
lbl77mod1a		DirectIndirectIndexedLong
lbl77mod1b		ADC8
			B	nextinstructionmod1
Op78mod1
lbl78mod1		Op78
			B	nextinstructionmod1
Op79M1mod1
lbl79mod1a		AbsoluteIndexedY
lbl79mod1b		ADC8
			B	nextinstructionmod1
Op7AX1mod1
lbl7Amod1		Op7AX1
			B	nextinstructionmod1
Op7Bmod1
lbl7Bmod1		Op7B
			B	nextinstructionmod1
Op7Cmod1
lbl7Cmod1		Op7C
			B	nextinstructionmod1
Op7DM1mod1
lbl7Dmod1a		AbsoluteIndexedX
lbl7Dmod1b		ADC8
			B	nextinstructionmod1
Op7EM1mod1
lbl7Emod1a		AbsoluteIndexedX
lbl7Emod1b		ROR8
			B	nextinstructionmod1
Op7FM1mod1
lbl7Fmod1a		AbsoluteLongIndexedX
lbl7Fmod1b		ADC8
			B	nextinstructionmod1
Op80mod1
lbl80mod1		Op80
			B	nextinstructionmod1
Op81M1mod1
lbl81mod1		Op81M1
			B	nextinstructionmod1
Op82mod1
lbl82mod1a		asmRelativeLong
lbl82mod1b		S9xSetPCBase (ICPU.ShiftedPB + OpAddress);
			B	nextinstructionmod1
Op83M1mod1
lbl83mod1a		StackasmRelative
lbl83mod1b		STA8
			B	nextinstructionmod1
Op84X1mod1
lbl84mod1a		Direct
lbl84mod1b		STY8
			B	nextinstructionmod1
Op85M1mod1
lbl85mod1a		Direct
lbl85mod1b		STA8
			B	nextinstructionmod1
Op86X1mod1
lbl86mod1a		Direct
lbl86mod1b		STX8
			B	nextinstructionmod1
Op87M1mod1
lbl87mod1a		DirectIndirectLong
lbl87mod1b		STA8
			B	nextinstructionmod1
Op88X1mod1
lbl88mod1		Op88X1
			B	nextinstructionmod1
Op89M1mod1
lbl89mod1		Op89M1
			B	nextinstructionmod1
Op8AM1mod1
lbl8Amod1		Op8AM1
			B	nextinstructionmod1
Op8Bmod1
lbl8Bmod1		Op8B
			B	nextinstructionmod1
Op8CX1mod1
lbl8Cmod1a		Absolute
lbl8Cmod1b		STY8
			B	nextinstructionmod1
Op8DM1mod1
lbl8Dmod1a		Absolute
lbl8Dmod1b		STA8
			B	nextinstructionmod1
Op8EX1mod1
lbl8Emod1a		Absolute
lbl8Emod1b		STX8
			B	nextinstructionmod1
Op8FM1mod1
lbl8Fmod1a		AbsoluteLong
lbl8Fmod1b		STA8
			B	nextinstructionmod1
Op90mod1
lbl90mod1		Op90
			B	nextinstructionmod1
Op91M1mod1
lbl91mod1a		DirectIndirectIndexed
lbl91mod1b		STA8
			B	nextinstructionmod1
Op92M1mod1
lbl92mod1a		DirectIndirect
lbl92mod1b		STA8
			B	nextinstructionmod1
Op93M1mod1
lbl93mod1a		StackasmRelativeIndirectIndexed
lbl93mod1b		STA8
			B	nextinstructionmod1
Op94X1mod1
lbl94mod1a		DirectIndexedX
lbl94mod1b		STY8
			B	nextinstructionmod1
Op95M1mod1
lbl95mod1a		DirectIndexedX
lbl95mod1b		STA8
			B	nextinstructionmod1
Op96X1mod1
lbl96mod1a		DirectIndexedY
lbl96mod1b		STX8
			B	nextinstructionmod1
Op97M1mod1
lbl97mod1a		DirectIndirectIndexedLong
lbl97mod1b		STA8
			B	nextinstructionmod1
Op98M1mod1
lbl98mod1		Op98M1
			B	nextinstructionmod1
Op99M1mod1
lbl99mod1a		AbsoluteIndexedY
lbl99mod1b		STA8
			B	nextinstructionmod1
Op9Amod1
lbl9Amod1		Op9A
			B	nextinstructionmod1
Op9BX1mod1
lbl9Bmod1		Op9BX1
			B	nextinstructionmod1
Op9CM1mod1
lbl9Cmod1a		Absolute
lbl9Cmod1b		STZ8
			B	nextinstructionmod1
Op9DM1mod1
lbl9Dmod1a		AbsoluteIndexedX
lbl9Dmod1b		STA8
			B	nextinstructionmod1
Op9EM1mod1
lbl9Emod1a		AbsoluteIndexedX
lbl9Emod1b		STZ8
			B	nextinstructionmod1
Op9FM1mod1
lbl9Fmod1a		AbsoluteLongIndexedX
lbl9Fmod1b		STA8
			B	nextinstructionmod1
OpA0X1mod1
lblA0mod1		OpA0X1
			B	nextinstructionmod1
OpA1M1mod1
lblA1mod1a		DirectIndexedIndirect
lblA1mod1b		LDA8
			B	nextinstructionmod1
OpA2X1mod1
lblA2mod1		OpA2X1
			B	nextinstructionmod1
OpA3M1mod1
lblA3mod1a		StackasmRelative
lblA3mod1b		LDA8
			B	nextinstructionmod1
OpA4X1mod1
lblA4mod1a		Direct
lblA4mod1b		LDY8
			B	nextinstructionmod1
OpA5M1mod1
lblA5mod1a		Direct
lblA5mod1b		LDA8
			B	nextinstructionmod1
OpA6X1mod1
lblA6mod1a		Direct
lblA6mod1b		LDX8
			B	nextinstructionmod1
OpA7M1mod1
lblA7mod1a		DirectIndirectLong
lblA7mod1b		LDA8
			B	nextinstructionmod1
OpA8X1mod1
lblA8mod1		OpA8X1
			B	nextinstructionmod1
OpA9M1mod1
lblA9mod1		OpA9M1
			B	nextinstructionmod1
OpAAX1mod1
lblAAmod1		OpAAX1
			B	nextinstructionmod1
OpABmod1
lblABmod1		OpAB
			B	nextinstructionmod1
OpACX1mod1
lblACmod1a		Absolute
lblACmod1b		LDY8
			B	nextinstructionmod1
OpADM1mod1
lblADmod1a		Absolute
lblADmod1b		LDA8
			B	nextinstructionmod1
OpAEX1mod1
lblAEmod1a		Absolute
lblAEmod1b		LDX8
			B	nextinstructionmod1
OpAFM1mod1
lblAFmod1a		AbsoluteLong
lblAFmod1b		LDA8
			B	nextinstructionmod1
OpB0mod1
lblB0mod1		OpB0
			B	nextinstructionmod1
OpB1M1mod1
lblB1mod1a		DirectIndirectIndexed
lblB1mod1b		LDA8
			B	nextinstructionmod1
OpB2M1mod1
lblB2mod1a		DirectIndirect
lblB2mod1b		LDA8
			B	nextinstructionmod1
OpB3M1mod1
lblB3mod1a		StackasmRelativeIndirectIndexed
lblB3mod1b		LDA8
			B	nextinstructionmod1
OpB4X1mod1
lblB4mod1a		DirectIndexedX
lblB4mod1b		LDY8
			B	nextinstructionmod1
OpB5M1mod1
lblB5mod1a		DirectIndexedX
lblB5mod1b		LDA8
			B	nextinstructionmod1
OpB6X1mod1
lblB6mod1a		DirectIndexedY
lblB6mod1b		LDX8
			B	nextinstructionmod1
OpB7M1mod1
lblB7mod1a		DirectIndirectIndexedLong
lblB7mod1b		LDA8
			B	nextinstructionmod1
OpB8mod1
lblB8mod1		OpB8
			B	nextinstructionmod1
OpB9M1mod1
lblB9mod1a		AbsoluteIndexedY
lblB9mod1b		LDA8
			B	nextinstructionmod1
OpBAX1mod1
lblBAmod1		OpBAX1
			B	nextinstructionmod1
OpBBX1mod1
lblBBmod1		OpBBX1
			B	nextinstructionmod1
OpBCX1mod1
lblBCmod1a		AbsoluteIndexedX
lblBCmod1b		LDY8
			B	nextinstructionmod1
OpBDM1mod1
lblBDmod1a		AbsoluteIndexedX
lblBDmod1b		LDA8
			B	nextinstructionmod1
OpBEX1mod1
lblBEmod1a		AbsoluteIndexedY
lblBEmod1b		LDX8
			B	nextinstructionmod1
OpBFM1mod1
lblBFmod1a		AbsoluteLongIndexedX
lblBFmod1b		LDA8
			B	nextinstructionmod1
OpC0X1mod1
lblC0mod1		OpC0X1
			B	nextinstructionmod1
OpC1M1mod1
lblC1mod1a		DirectIndexedIndirect
lblC1mod1b		CMP8
			B	nextinstructionmod1
OpC2mod1
lblC2mod1		OpC2
			B	nextinstructionmod1
OpC3M1mod1
lblC3mod1a		StackasmRelative
lblC3mod1b		CMP8
			B	nextinstructionmod1
OpC4X1mod1
lblC4mod1a		Direct
lblC4mod1b		CMY8
			B	nextinstructionmod1
OpC5M1mod1
lblC5mod1a		Direct
lblC5mod1b		CMP8
			B	nextinstructionmod1
OpC6M1mod1
lblC6mod1a		Direct
lblC6mod1b		DEC8
			B	nextinstructionmod1
OpC7M1mod1
lblC7mod1a		DirectIndirectLong
lblC7mod1b		CMP8
			B	nextinstructionmod1
OpC8X1mod1
lblC8mod1		OpC8X1
			B	nextinstructionmod1
OpC9M1mod1
lblC9mod1		OpC9M1
			B	nextinstructionmod1
OpCAX1mod1
lblCAmod1		OpCAX1
			B	nextinstructionmod1
OpCBmod1
lblCBmod1		OpCB
			B	nextinstructionmod1
OpCCX1mod1
lblCCmod1a		Absolute
lblCCmod1b		CMY8
			B	nextinstructionmod1
OpCDM1mod1
lblCDmod1a		Absolute
lblCDmod1b		CMP8
			B	nextinstructionmod1
OpCEM1mod1
lblCEmod1a		Absolute
lblCEmod1b		DEC8
			B	nextinstructionmod1
OpCFM1mod1
lblCFmod1a		AbsoluteLong
lblCFmod1b		CMP8
			B	nextinstructionmod1
OpD0mod1
lblD0mod1		OpD0
			B	nextinstructionmod1
OpD1M1mod1
lblD1mod1a		DirectIndirectIndexed
lblD1mod1b		CMP8
			B	nextinstructionmod1
OpD2M1mod1
lblD2mod1a		DirectIndirect
lblD2mod1b		CMP8
			B	nextinstructionmod1
OpD3M1mod1
lblD3mod1a		StackasmRelativeIndirectIndexed
lblD3mod1b		CMP8
			B	nextinstructionmod1
OpD4mod1
lblD4mod1a		DirectIndirect
lblD4mod1b		PushW (OpAddress);
			B	nextinstructionmod1
OpD5M1mod1
lblD5mod1a		DirectIndexedX
lblD5mod1b		CMP8
			B	nextinstructionmod1
OpD6M1mod1
lblD6mod1a		DirectIndexedX
lblD6mod1b		DEC8
			B	nextinstructionmod1
OpD7M1mod1
lblD7mod1a		DirectIndirectIndexedLong
lblD7mod1b		CMP8
			B	nextinstructionmod1
OpD8mod1
lblD8mod1		OpD8
			B	nextinstructionmod1
OpD9M1mod1
lblD9mod1a		AbsoluteIndexedY
lblD9mod1b		CMP8
			B	nextinstructionmod1
OpDAX1mod1
lblDAmod1		OpDAX1
			B	nextinstructionmod1
OpDBmod1
lblDBmod1a		CPU.PC--;
lblDBmod1b		CPU.Flags |= DEBUG_MODE_FLAG;
			B	nextinstructionmod1
OpDCmod1
lblDCmod1		OpDC
			B	nextinstructionmod1
OpDDM1mod1
lblDDmod1a		AbsoluteIndexedX
lblDDmod1b		CMP8
			B	nextinstructionmod1
OpDEM1mod1
lblDEmod1a		AbsoluteIndexedX
lblDEmod1b		DEC8
			B	nextinstructionmod1
OpDFM1mod1
lblDFmod1a		AbsoluteLongIndexedX
lblDFmod1b		CMP8
			B	nextinstructionmod1
OpE0X1mod1
lblE0mod1		OpE0X1
			B	nextinstructionmod1
OpE1M1mod1
lblE1mod1a		DirectIndexedIndirect
lblE1mod1b		SBC8
			B	nextinstructionmod1
OpE2mod1
lblE2mod1		OpE2
			B	nextinstructionmod1
OpE3M1mod1
lblE3mod1a		StackasmRelative
lblE3mod1b		SBC8
			B	nextinstructionmod1
OpE4X1mod1
lblE4mod1a		Direct
lblE4mod1b		CMX8
			B	nextinstructionmod1
OpE5M1mod1
lblE5mod1a		Direct
lblE5mod1b		SBC8
			B	nextinstructionmod1
OpE6M1mod1
lblE6mod1a		Direct
lblE6mod1b		INC8
			B	nextinstructionmod1
OpE7M1mod1
lblE7mod1a		DirectIndirectLong
lblE7mod1b		SBC8
			B	nextinstructionmod1
OpE8X1mod1
lblE8mod1		OpE8X1
			B	nextinstructionmod1
OpE9M1mod1
lblE9mod1a		Immediate8
lblE9mod1b		SBC8
			B	nextinstructionmod1
OpEAmod1
lblEAmod1		OpEA
			B	nextinstructionmod1
OpEBmod1
lblEBmod1		OpEB
			B	nextinstructionmod1
OpECX1mod1
lblECmod1a		Absolute
lblECmod1b		CMX8
			B	nextinstructionmod1
OpEDM1mod1
lblEDmod1a		Absolute
lblEDmod1b		SBC8
			B	nextinstructionmod1
OpEEM1mod1
lblEEmod1a		Absolute
lblEEmod1b		INC8
			B	nextinstructionmod1
OpEFM1mod1
lblEFmod1a		AbsoluteLong
lblEFmod1b		SBC8
			B	nextinstructionmod1
OpF0mod1
lblF0mod1		OpF0
			B	nextinstructionmod1
OpF1M1mod1
lblF1mod1a		DirectIndirectIndexed
lblF1mod1b		SBC8
			B	nextinstructionmod1
OpF2M1mod1
lblF2mod1a		DirectIndirect
lblF2mod1b		SBC8
			B	nextinstructionmod1
OpF3M1mod1
lblF3mod1a		StackasmRelativeIndirectIndexed
lblF3mod1b		SBC8
			B	nextinstructionmod1
OpF4mod1
lblF4mod1a		Absolute
lblF4mod1b		PushW (OpAddress);
			B	nextinstructionmod1
OpF5M1mod1
lblF5mod1a		DirectIndexedX
lblF5mod1b		SBC8
			B	nextinstructionmod1
OpF6M1mod1
lblF6mod1a		DirectIndexedX
lblF6mod1b		INC8
			B	nextinstructionmod1
OpF7M1mod1
lblF7mod1a		DirectIndirectIndexedLong
lblF7mod1b		SBC8
			B	nextinstructionmod1
OpF8mod1
lblF8mod1		OpF8
			B	nextinstructionmod1
OpF9M1mod1
lblF9mod1a		AbsoluteIndexedY
lblF9mod1b		SBC8
			B	nextinstructionmod1
OpFAX1mod1
lblFAmod1		OpFAX1
			B	nextinstructionmod1
OpFBmod1
lblFBmod1		OpFB
			B	nextinstructionmod1
OpFCmod1
lblFCmod1		OpFC
			B	nextinstructionmod1
OpFDM1mod1
lblFDmod1a		AbsoluteIndexedX
lblFDmod1b		SBC8
			B	nextinstructionmod1
OpFEM1mod1
lblFEmod1a		AbsoluteIndexedX
lblFEmod1b		INC8
			B	nextinstructionmod1
OpFFM1mod1
lblFFmod1a		AbsoluteLongIndexedX
lblFFmod1b		SBC8
			B	nextinstructionmod1


nextinstructionmod2
			; Empty	for the	moment...
executeinstructionmod2
			LDRB	regopcode, [rpc], #1		; Load opcode, snespc++
			LDR	PC, [PC, regopcode LSL #2]	; Go to	execute	correct	routine
			; From here jump table that modify the PC
			MOV	R0,R0,R0	; Dummy	instruction NOP	 DO NOT	REMOVE
						; align	jmptbl with ARM	PC, never executed
jumptable2		DCD	Op00mod2
			DCD	Op01M1mod2
			DCD	Op02mod2
			DCD	Op03M1mod2
			DCD	Op04M1mod2
			DCD	Op05M1mod2
			DCD	Op06M1mod2
			DCD	Op07M1mod2
			DCD	Op08mod2
			DCD	Op09M1mod2
			DCD	Op0AM1mod2
			DCD	Op0Bmod2
			DCD	Op0CM1mod2
			DCD	Op0DM1mod2
			DCD	Op0EM1mod2
			DCD	Op0FM1mod2
			DCD	Op10mod2
			DCD	Op11M1mod2
			DCD	Op12M1mod2
			DCD	Op13M1mod2
			DCD	Op14M1mod2
			DCD	Op15M1mod2
			DCD	Op16M1mod2
			DCD	Op17M1mod2
			DCD	Op18mod2
			DCD	Op19M1mod2
			DCD	Op1AM1mod2
			DCD	Op1Bmod2
			DCD	Op1CM1mod2
			DCD	Op1DM1mod2
			DCD	Op1EM1mod2
			DCD	Op1FM1mod2
			DCD	Op20mod2
			DCD	Op21M1mod2
			DCD	Op22mod2
			DCD	Op23M1mod2
			DCD	Op24M1mod2
			DCD	Op25M1mod2
			DCD	Op26M1mod2
			DCD	Op27M1mod2
			DCD	Op28mod2
			DCD	Op29M1mod2
			DCD	Op2AM1mod2
			DCD	Op2Bmod2
			DCD	Op2CM1mod2
			DCD	Op2DM1mod2
			DCD	Op2EM1mod2
			DCD	Op2FM1mod2
			DCD	Op30mod2
			DCD	Op31M1mod2
			DCD	Op32M1mod2
			DCD	Op33M1mod2
			DCD	Op34M1mod2
			DCD	Op35M1mod2
			DCD	Op36M1mod2
			DCD	Op37M1mod2
			DCD	Op38mod2
			DCD	Op39M1mod2
			DCD	Op3AM1mod2
			DCD	Op3Bmod2
			DCD	Op3CM1mod2
			DCD	Op3DM1mod2
			DCD	Op3EM1mod2
			DCD	Op3FM1mod2
			DCD	Op40mod2
			DCD	Op41M1mod2
			DCD	Op42mod2
			DCD	Op43M1mod2
			DCD	Op44X0mod2
			DCD	Op45M1mod2
			DCD	Op46M1mod2
			DCD	Op47M1mod2
			DCD	Op48M1mod2
			DCD	Op49M1mod2
			DCD	Op4AM1mod2
			DCD	Op4Bmod2
			DCD	Op4Cmod2
			DCD	Op4DM1mod2
			DCD	Op4EM1mod2
			DCD	Op4FM1mod2
			DCD	Op50mod2
			DCD	Op51M1mod2
			DCD	Op52M1mod2
			DCD	Op53M1mod2
			DCD	Op54X0mod2
			DCD	Op55M1mod2
			DCD	Op56M1mod2
			DCD	Op57M1mod2
			DCD	Op58mod2
			DCD	Op59M1mod2
			DCD	Op5AX0mod2
			DCD	Op5Bmod2
			DCD	Op5Cmod2
			DCD	Op5DM1mod2
			DCD	Op5EM1mod2
			DCD	Op5FM1mod2
			DCD	Op60mod2
			DCD	Op61M1mod2
			DCD	Op62mod2
			DCD	Op63M1mod2
			DCD	Op64M1mod2
			DCD	Op65M1mod2
			DCD	Op66M1mod2
			DCD	Op67M1mod2
			DCD	Op68M1mod2
			DCD	Op69M1mod2
			DCD	Op6AM1mod2
			DCD	Op6Bmod2
			DCD	Op6Cmod2
			DCD	Op6DM1mod2
			DCD	Op6EM1mod2
			DCD	Op6FM1mod2
			DCD	Op70mod2
			DCD	Op71M1mod2
			DCD	Op72M1mod2
			DCD	Op73M1mod2
			DCD	Op74M1mod2
			DCD	Op75M1mod2
			DCD	Op76M1mod2
			DCD	Op77M1mod2
			DCD	Op78mod2
			DCD	Op79M1mod2
			DCD	Op7AX0mod2
			DCD	Op7Bmod2
			DCD	Op7Cmod2
			DCD	Op7DM1mod2
			DCD	Op7EM1mod2
			DCD	Op7FM1mod2
			DCD	Op80mod2
			DCD	Op81M1mod2
			DCD	Op82mod2
			DCD	Op83M1mod2
			DCD	Op84X0mod2
			DCD	Op85M1mod2
			DCD	Op86X0mod2
			DCD	Op87M1mod2
			DCD	Op88X0mod2
			DCD	Op89M1mod2
			DCD	Op8AM1mod2
			DCD	Op8Bmod2
			DCD	Op8CX0mod2
			DCD	Op8DM1mod2
			DCD	Op8EX0mod2
			DCD	Op8FM1mod2
			DCD	Op90mod2
			DCD	Op91M1mod2
			DCD	Op92M1mod2
			DCD	Op93M1mod2
			DCD	Op94X0mod2
			DCD	Op95M1mod2
			DCD	Op96X0mod2
			DCD	Op97M1mod2
			DCD	Op98M1mod2
			DCD	Op99M1mod2
			DCD	Op9Amod2
			DCD	Op9BX0mod2
			DCD	Op9CM1mod2
			DCD	Op9DM1mod2
			DCD	Op9EM1mod2
			DCD	Op9FM1mod2
			DCD	OpA0X0mod2
			DCD	OpA1M1mod2
			DCD	OpA2X0mod2
			DCD	OpA3M1mod2
			DCD	OpA4X0mod2
			DCD	OpA5M1mod2
			DCD	OpA6X0mod2
			DCD	OpA7M1mod2
			DCD	OpA8X0mod2
			DCD	OpA9M1mod2
			DCD	OpAAX0mod2
			DCD	OpABmod2
			DCD	OpACX0mod2
			DCD	OpADM1mod2
			DCD	OpAEX0mod2
			DCD	OpAFM1mod2
			DCD	OpB0mod2
			DCD	OpB1M1mod2
			DCD	OpB2M1mod2
			DCD	OpB3M1mod2
			DCD	OpB4X0mod2
			DCD	OpB5M1mod2
			DCD	OpB6X0mod2
			DCD	OpB7M1mod2
			DCD	OpB8mod2
			DCD	OpB9M1mod2
			DCD	OpBAX0mod2
			DCD	OpBBX0mod2
			DCD	OpBCX0mod2
			DCD	OpBDM1mod2
			DCD	OpBEX0mod2
			DCD	OpBFM1mod2
			DCD	OpC0X0mod2
			DCD	OpC1M1mod2
			DCD	OpC2mod2
			DCD	OpC3M1mod2
			DCD	OpC4X0mod2
			DCD	OpC5M1mod2
			DCD	OpC6M1mod2
			DCD	OpC7M1mod2
			DCD	OpC8X0mod2
			DCD	OpC9M1mod2
			DCD	OpCAX0mod2
			DCD	OpCBmod2
			DCD	OpCCX0mod2
			DCD	OpCDM1mod2
			DCD	OpCEM1mod2
			DCD	OpCFM1mod2
			DCD	OpD0mod2
			DCD	OpD1M1mod2
			DCD	OpD2M1mod2
			DCD	OpD3M1mod2
			DCD	OpD4mod2
			DCD	OpD5M1mod2
			DCD	OpD6M1mod2
			DCD	OpD7M1mod2
			DCD	OpD8mod2
			DCD	OpD9M1mod2
			DCD	OpDAX0mod2
			DCD	OpDBmod2
			DCD	OpDCmod2
			DCD	OpDDM1mod2
			DCD	OpDEM1mod2
			DCD	OpDFM1mod2
			DCD	OpE0X0mod2
			DCD	OpE1M1mod2
			DCD	OpE2mod2
			DCD	OpE3M1mod2
			DCD	OpE4X0mod2
			DCD	OpE5M1mod2
			DCD	OpE6M1mod2
			DCD	OpE7M1mod2
			DCD	OpE8X0mod2
			DCD	OpE9M1mod2
			DCD	OpEAmod2
			DCD	OpEBmod2
			DCD	OpECX0mod2
			DCD	OpEDM1mod2
			DCD	OpEEM1mod2
			DCD	OpEFM1mod2
			DCD	OpF0mod2
			DCD	OpF1M1mod2
			DCD	OpF2M1mod2
			DCD	OpF3M1mod2
			DCD	OpF4mod2
			DCD	OpF5M1mod2
			DCD	OpF6M1mod2
			DCD	OpF7M1mod2
			DCD	OpF8mod2
			DCD	OpF9M1mod2
			DCD	OpFAX0mod2
			DCD	OpFBmod2
			DCD	OpFCmod2
			DCD	OpFDM1mod2
			DCD	OpFEM1mod2
			DCD	OpFFM1mod2
Op00mod2
lbl00mod2		Op00
			B	nextinstructionmod2
Op01M1mod2
lbl01mod2a		DirectIndexedIndirect
lbl01mod2b		ORA8
			B	nextinstructionmod2
Op02mod2
lbl02mod2		Op02
			B	nextinstructionmod2
Op03M1mod2
lbl03mod2a		StackasmRelative
lbl03mod2b		ORA8
			B	nextinstructionmod2
Op04M1mod2
lbl04mod2a		Direct
lbl04mod2b		TSB8
			B	nextinstructionmod2
Op05M1mod2
lbl05mod2a		Direct
lbl05mod2b		ORA8
			B	nextinstructionmod2
Op06M1mod2
lbl06mod2a		Direct
lbl06mod2b		ASL8
			B	nextinstructionmod2
Op07M1mod2
lbl07mod2a		DirectIndirectLong
lbl07mod2b		ORA8
			B	nextinstructionmod2
Op08mod2
lbl08mod2		Op08
			B	nextinstructionmod2
Op09M1mod2
lbl09mod2		Op09M1
			B	nextinstructionmod2
Op0AM1mod2
lbl0Amod2a		A_ASL8
			B	nextinstructionmod2
Op0Bmod2
lbl0Bmod2		Op0B
			B	nextinstructionmod2
Op0CM1mod2
lbl0Cmod2a		Absolute
lbl0Cmod2b		TSB8
			B	nextinstructionmod2
Op0DM1mod2
lbl0Dmod2a		Absolute
lbl0Dmod2b		ORA8
			B	nextinstructionmod2
Op0EM1mod2
lbl0Emod2a		Absolute
lbl0Emod2b		ASL8
			B	nextinstructionmod2
Op0FM1mod2
lbl0Fmod2a		AbsoluteLong
lbl0Fmod2b		ORA8
			B	nextinstructionmod2
Op10mod2
lbl10mod2		Op10
			B	nextinstructionmod2
Op11M1mod2
lbl11mod2a		DirectIndirectIndexed
lbl11mod2b		ORA8
			B	nextinstructionmod2
Op12M1mod2
lbl12mod2a		DirectIndirect
lbl12mod2b		ORA8
			B	nextinstructionmod2
Op13M1mod2
lbl13mod2a		StackasmRelativeIndirectIndexed
lbl13mod2b		ORA8
			B	nextinstructionmod2
Op14M1mod2
lbl14mod2a		Direct
lbl14mod2b		TRB8
			B	nextinstructionmod2
Op15M1mod2
lbl15mod2a		DirectIndexedX
lbl15mod2b		ORA8
			B	nextinstructionmod2
Op16M1mod2
lbl16mod2a		DirectIndexedX
lbl16mod2b		ASL8
			B	nextinstructionmod2
Op17M1mod2
lbl17mod2a		DirectIndirectIndexedLong
lbl17mod2b		ORA8
			B	nextinstructionmod2
Op18mod2
lbl18mod2		Op18
			B	nextinstructionmod2
Op19M1mod2
lbl19mod2a		AbsoluteIndexedY
lbl19mod2b		ORA8
			B	nextinstructionmod2
Op1AM1mod2
lbl1Amod2a		A_INC8
			B	nextinstructionmod2
Op1Bmod2
lbl1Bmod2		Op1B
			B	nextinstructionmod2
Op1CM1mod2
lbl1Cmod2a		Absolute
lbl1Cmod2b		TRB8
			B	nextinstructionmod2
Op1DM1mod2
lbl1Dmod2a		AbsoluteIndexedX
lbl1Dmod2b		ORA8
			B	nextinstructionmod2
Op1EM1mod2
lbl1Emod2a		AbsoluteIndexedX
lbl1Emod2b		ASL8
			B	nextinstructionmod2
Op1FM1mod2
lbl1Fmod2a		AbsoluteLongIndexedX
lbl1Fmod2b		ORA8
			B	nextinstructionmod2
Op20mod2
lbl20mod2		Op20
			B	nextinstructionmod2
Op21M1mod2
lbl21mod2a		DirectIndexedIndirect
lbl21mod2b		AND8
			B	nextinstructionmod2
Op22mod2
lbl22mod2		Op22
			B	nextinstructionmod2
Op23M1mod2
lbl23mod2a		StackasmRelative
lbl23mod2b		AND8
			B	nextinstructionmod2
Op24M1mod2
lbl24mod2a		Direct
lbl24mod2b		BIT8
			B	nextinstructionmod2
Op25M1mod2
lbl25mod2a		Direct
lbl25mod2b		AND8
			B	nextinstructionmod2
Op26M1mod2
lbl26mod2a		Direct
lbl26mod2b		ROL8
			B	nextinstructionmod2
Op27M1mod2
lbl27mod2a		DirectIndirectLong
lbl27mod2b		AND8
			B	nextinstructionmod2
Op28mod2
lbl28mod2		Op28
			B	nextinstructionmod2
Op29M1mod2
lbl29mod2		Op29M1
			B	nextinstructionmod2
Op2AM1mod2
lbl2Amod2a		A_ROL8
			B	nextinstructionmod2
Op2Bmod2
lbl2Bmod2		Op2B
			B	nextinstructionmod2
Op2CM1mod2
lbl2Cmod2a		Absolute
lbl2Cmod2b		BIT8
			B	nextinstructionmod2
Op2DM1mod2
lbl2Dmod2a		Absolute
lbl2Dmod2b		AND8
			B	nextinstructionmod2
Op2EM1mod2
lbl2Emod2a		Absolute
lbl2Emod2b		ROL8
			B	nextinstructionmod2
Op2FM1mod2
lbl2Fmod2a		AbsoluteLong
lbl2Fmod2b		AND8
			B	nextinstructionmod2
Op30mod2
lbl30mod2		Op30
			B	nextinstructionmod2
Op31M1mod2
lbl31mod2a		DirectIndirectIndexed
lbl31mod2b		AND8
			B	nextinstructionmod2
Op32M1mod2
lbl32mod2a		DirectIndirect
lbl32mod2b		AND8
			B	nextinstructionmod2
Op33M1mod2
lbl33mod2a		StackasmRelativeIndirectIndexed
lbl33mod2b		AND8
			B	nextinstructionmod2
Op34M1mod2
lbl34mod2a		DirectIndexedX
lbl34mod2b		BIT8
			B	nextinstructionmod2
Op35M1mod2
lbl35mod2a		DirectIndexedX
lbl35mod2b		AND8
			B	nextinstructionmod2
Op36M1mod2
lbl36mod2a		DirectIndexedX
lbl36mod2b		ROL8
			B	nextinstructionmod2
Op37M1mod2
lbl37mod2a		DirectIndirectIndexedLong
lbl37mod2b		AND8
			B	nextinstructionmod2
Op38mod2
lbl38mod2		Op38
			B	nextinstructionmod2
Op39M1mod2
lbl39mod2a		AbsoluteIndexedY
lbl39mod2b		AND8
			B	nextinstructionmod2
Op3AM1mod2
lbl3Amod2a		A_DEC8
			B	nextinstructionmod2
Op3Bmod2
lbl3Bmod2		Op3B
			B	nextinstructionmod2
Op3CM1mod2
lbl3Cmod2a		AbsoluteIndexedX
lbl3Cmod2b		BIT8
			B	nextinstructionmod2
Op3DM1mod2
lbl3Dmod2a		AbsoluteIndexedX
lbl3Dmod2b		AND8
			B	nextinstructionmod2
Op3EM1mod2
lbl3Emod2a		AbsoluteIndexedX
lbl3Emod2b		ROL8
			B	nextinstructionmod2
Op3FM1mod2
lbl3Fmod2a		AbsoluteLongIndexedX
lbl3Fmod2b		AND8
			B	nextinstructionmod2
Op40mod2
lbl40mod2		Op40
			B	nextinstructionmod2
Op41M1mod2
lbl41mod2a		DirectIndexedIndirect
lbl41mod2b		EOR8
			B	nextinstructionmod2
Op42mod2
lbl42mod2a
			B	nextinstructionmod2
Op43M1mod2
lbl43mod2a		StackasmRelative
lbl43mod2b		EOR8
			B	nextinstructionmod2
Op44X0mod2
lbl44mod2		Op44X0
			B	nextinstructionmod2
Op45M1mod2
lbl45mod2a		Direct
lbl45mod2b		EOR8
			B	nextinstructionmod2
Op46M1mod2
lbl46mod2a		Direct
lbl46mod2b		LSR8
			B	nextinstructionmod2
Op47M1mod2
lbl47mod2a		DirectIndirectLong
lbl47mod2b		EOR8
			B	nextinstructionmod2
Op48M1mod2
lbl48mod2		Op48M1
			B	nextinstructionmod2
Op49M1mod2
lbl49mod2		Op49M1
			B	nextinstructionmod2
Op4AM1mod2
lbl4Amod2a		A_LSR8
			B	nextinstructionmod2
Op4Bmod2
lbl4Bmod2		Op4B
			B	nextinstructionmod2
Op4Cmod2
lbl4Cmod2a		Absolute
lbl4Cmod2b		S9xSetPCBase (ICPU.ShiftedPB + (OpAddress & 0xffff));
			B	nextinstructionmod2
Op4DM1mod2
lbl4Dmod2a		Absolute
lbl4Dmod2b		EOR8
			B	nextinstructionmod2
Op4EM1mod2
lbl4Emod2a		Absolute
lbl4Emod2b		LSR8
			B	nextinstructionmod2
Op4FM1mod2
lbl4Fmod2a		AbsoluteLong
lbl4Fmod2b		EOR8
			B	nextinstructionmod2
Op50mod2
lbl50mod2		Op50
			B	nextinstructionmod2
Op51M1mod2
lbl51mod2a		DirectIndirectIndexed
lbl51mod2b		EOR8
			B	nextinstructionmod2
Op52M1mod2
lbl52mod2a		DirectIndirect
lbl52mod2b		EOR8
			B	nextinstructionmod2
Op53M1mod2
lbl53mod2a		StackasmRelativeIndirectIndexed
lbl53mod2b		EOR8
			B	nextinstructionmod2
Op54X0mod2
lbl54mod2		Op54X0
			B	nextinstructionmod2
Op55M1mod2
lbl55mod2a		DirectIndexedX
lbl55mod2b		EOR8
			B	nextinstructionmod2
Op56M1mod2
lbl56mod2a		DirectIndexedX
lbl56mod2b		LSR8
			B	nextinstructionmod2
Op57M1mod2
lbl57mod2a		DirectIndirectIndexedLong
lbl57mod2b		EOR8
			B	nextinstructionmod2
Op58mod2
lbl58mod2		Op58
			B	nextinstructionmod2
Op59M1mod2
lbl59mod2a		AbsoluteIndexedY
lbl59mod2b		EOR8
			B	nextinstructionmod2
Op5AX0mod2
lbl5Amod2		Op5AX0
			B	nextinstructionmod2
Op5Bmod2
lbl5Bmod2		Op5B
			B	nextinstructionmod2
Op5Cmod2
lbl5Cmod2		Op5C
			B	nextinstructionmod2
Op5DM1mod2
lbl5Dmod2a		AbsoluteIndexedX
lbl5Dmod2b		EOR8
			B	nextinstructionmod2
Op5EM1mod2
lbl5Emod2a		AbsoluteIndexedX
lbl5Emod2b		LSR8
			B	nextinstructionmod2
Op5FM1mod2
lbl5Fmod2a		AbsoluteLongIndexedX
lbl5Fmod2b		EOR8
			B	nextinstructionmod2
Op60mod2
lbl60mod2		Op60
			B	nextinstructionmod2
Op61M1mod2
lbl61mod2a		DirectIndexedIndirect
lbl61mod2b		ADC8
			B	nextinstructionmod2
Op62mod2
lbl62mod2a		asmRelativeLong
lbl62mod2b		PushW (OpAddress);
			B	nextinstructionmod2
Op63M1mod2
lbl63mod2a		StackasmRelative
lbl63mod2b		ADC8
			B	nextinstructionmod2
Op64M1mod2
lbl64mod2a		Direct
lbl64mod2b		STZ8
			B	nextinstructionmod2
Op65M1mod2
lbl65mod2a		Direct
lbl65mod2b		ADC8
			B	nextinstructionmod2
Op66M1mod2
lbl66mod2a		Direct
lbl66mod2b		ROR8
			B	nextinstructionmod2
Op67M1mod2
lbl67mod2a		DirectIndirectLong
lbl67mod2b		ADC8
			B	nextinstructionmod2
Op68M1mod2
lbl68mod2		Op68M1
			B	nextinstructionmod2
Op69M1mod2
lbl69mod2a		Immediate8
lbl69mod2b		ADC8
			B	nextinstructionmod2
Op6AM1mod2
lbl6Amod2a		A_ROR8
			B	nextinstructionmod2
Op6Bmod2
lbl6Bmod2		Op6B
			B	nextinstructionmod2
Op6Cmod2
lbl6Cmod2a		AbsoluteIndirect
lbl6Cmod2b		S9xSetPCBase (ICPU.ShiftedPB + (OpAddress & 0xffff));
			B	nextinstructionmod2
Op6DM1mod2
lbl6Dmod2a		Absolute
lbl6Dmod2b		ADC8
			B	nextinstructionmod2
Op6EM1mod2
lbl6Emod2a		Absolute
lbl6Emod2b		ROR8
			B	nextinstructionmod2
Op6FM1mod2
lbl6Fmod2a		AbsoluteLong
lbl6Fmod2b		ADC8
			B	nextinstructionmod2
Op70mod2
lbl70mod2		Op70
			B	nextinstructionmod2
Op71M1mod2
lbl71mod2a		DirectIndirectIndexed
lbl71mod2b		ADC8
			B	nextinstructionmod2
Op72M1mod2
lbl72mod2a		DirectIndirect
lbl72mod2b		ADC8
			B	nextinstructionmod2
Op73M1mod2
lbl73mod2a		StackasmRelativeIndirectIndexed
lbl73mod2b		ADC8
			B	nextinstructionmod2
Op74M1mod2
lbl74mod2a		DirectIndexedX
lbl74mod2b		STZ8
			B	nextinstructionmod2
Op75M1mod2
lbl75mod2a		DirectIndexedX
lbl75mod2b		ADC8
			B	nextinstructionmod2
Op76M1mod2
lbl76mod2a		DirectIndexedX
lbl76mod2b		ROR8
			B	nextinstructionmod2
Op77M1mod2
lbl77mod2a		DirectIndirectIndexedLong
lbl77mod2b		ADC8
			B	nextinstructionmod2
Op78mod2
lbl78mod2		Op78
			B	nextinstructionmod2
Op79M1mod2
lbl79mod2a		AbsoluteIndexedY
lbl79mod2b		ADC8
			B	nextinstructionmod2
Op7AX0mod2
lbl7Amod2		Op7AX0
			B	nextinstructionmod2
Op7Bmod2
lbl7Bmod2		Op7B
			B	nextinstructionmod2
Op7Cmod2
lbl7Cmod2		Op7C
			B	nextinstructionmod2
Op7DM1mod2
lbl7Dmod2a		AbsoluteIndexedX
lbl7Dmod2b		ADC8
			B	nextinstructionmod2
Op7EM1mod2
lbl7Emod2a		AbsoluteIndexedX
lbl7Emod2b		ROR8
			B	nextinstructionmod2
Op7FM1mod2
lbl7Fmod2a		AbsoluteLongIndexedX
lbl7Fmod2b		ADC8
			B	nextinstructionmod2
Op80mod2
lbl80mod2		Op80
			B	nextinstructionmod2
Op81M1mod2
lbl81mod2		Op81M1
			B	nextinstructionmod2
Op82mod2
lbl82mod2a		asmRelativeLong
lbl82mod2b		S9xSetPCBase (ICPU.ShiftedPB + OpAddress);
			B	nextinstructionmod2
Op83M1mod2
lbl83mod2a		StackasmRelative
lbl83mod2b		STA8
			B	nextinstructionmod2
Op84X0mod2
lbl84mod2a		Direct
lbl84mod2b		STY16
			B	nextinstructionmod2
Op85M1mod2
lbl85mod2a		Direct
lbl85mod2b		STA8
			B	nextinstructionmod2
Op86X0mod2
lbl86mod2a		Direct
lbl86mod2b		STX16
			B	nextinstructionmod2
Op87M1mod2
lbl87mod2a		DirectIndirectLong
lbl87mod2b		STA8
			B	nextinstructionmod2
Op88X0mod2
lbl88mod2		Op88X0
			B	nextinstructionmod2
Op89M1mod2
lbl89mod2		Op89M1
			B	nextinstructionmod2
Op8AM1mod2
lbl8Amod2		Op8AM1
			B	nextinstructionmod2
Op8Bmod2
lbl8Bmod2		Op8B
			B	nextinstructionmod2
Op8CX0mod2
lbl8Cmod2a		Absolute
lbl8Cmod2b		STY16
			B	nextinstructionmod2
Op8DM1mod2
lbl8Dmod2a		Absolute
lbl8Dmod2b		STA8
			B	nextinstructionmod2
Op8EX0mod2
lbl8Emod2a		Absolute
lbl8Emod2b		STX16
			B	nextinstructionmod2
Op8FM1mod2
lbl8Fmod2a		AbsoluteLong
lbl8Fmod2b		STA8
			B	nextinstructionmod2
Op90mod2
lbl90mod2		Op90
			B	nextinstructionmod2
Op91M1mod2
lbl91mod2a		DirectIndirectIndexed
lbl91mod2b		STA8
			B	nextinstructionmod2
Op92M1mod2
lbl92mod2a		DirectIndirect
lbl92mod2b		STA8
			B	nextinstructionmod2
Op93M1mod2
lbl93mod2a		StackasmRelativeIndirectIndexed
lbl93mod2b		STA8
			B	nextinstructionmod2
Op94X0mod2
lbl94mod2a		DirectIndexedX
lbl94mod2b		STY16
			B	nextinstructionmod2
Op95M1mod2
lbl95mod2a		DirectIndexedX
lbl95mod2b		STA8
			B	nextinstructionmod2
Op96X0mod2
lbl96mod2a		DirectIndexedY
lbl96mod2b		STX16
			B	nextinstructionmod2
Op97M1mod2
lbl97mod2a		DirectIndirectIndexedLong
lbl97mod2b		STA8
			B	nextinstructionmod2
Op98M1mod2
lbl98mod2		Op98M1
			B	nextinstructionmod2
Op99M1mod2
lbl99mod2a		AbsoluteIndexedY
lbl99mod2b		STA8
			B	nextinstructionmod2
Op9Amod2
lbl9Amod2		Op9A
			B	nextinstructionmod2
Op9BX0mod2
lbl9Bmod2		Op9BX0
			B	nextinstructionmod2
Op9CM1mod2
lbl9Cmod2a		Absolute
lbl9Cmod2b		STZ8
			B	nextinstructionmod2
Op9DM1mod2
lbl9Dmod2a		AbsoluteIndexedX
lbl9Dmod2b		STA8
			B	nextinstructionmod2
Op9EM1mod2
lbl9Emod2a		AbsoluteIndexedX
lbl9Emod2b		STZ8
			B	nextinstructionmod2
Op9FM1mod2
lbl9Fmod2a		AbsoluteLongIndexedX
lbl9Fmod2b		STA8
			B	nextinstructionmod2
OpA0X0mod2
lblA0mod2		OpA0X0
			B	nextinstructionmod2
OpA1M1mod2
lblA1mod2a		DirectIndexedIndirect
lblA1mod2b		LDA8
			B	nextinstructionmod2
OpA2X0mod2
lblA2mod2		OpA2X0
			B	nextinstructionmod2
OpA3M1mod2
lblA3mod2a		StackasmRelative
lblA3mod2b		LDA8
			B	nextinstructionmod2
OpA4X0mod2
lblA4mod2a		Direct
lblA4mod2b		LDY16
			B	nextinstructionmod2
OpA5M1mod2
lblA5mod2a		Direct
lblA5mod2b		LDA8
			B	nextinstructionmod2
OpA6X0mod2
lblA6mod2a		Direct
lblA6mod2b		LDX16
			B	nextinstructionmod2
OpA7M1mod2
lblA7mod2a		DirectIndirectLong
lblA7mod2b		LDA8
			B	nextinstructionmod2
OpA8X0mod2
lblA8mod2		OpA8X0
			B	nextinstructionmod2
OpA9M1mod2
lblA9mod2		OpA9M1
			B	nextinstructionmod2
OpAAX0mod2
lblAAmod2		OpAAX0
			B	nextinstructionmod2
OpABmod2
lblABmod2		OpAB
			B	nextinstructionmod2
OpACX0mod2
lblACmod2a		Absolute
lblACmod2b		LDY16
			B	nextinstructionmod2
OpADM1mod2
lblADmod2a		Absolute
lblADmod2b		LDA8
			B	nextinstructionmod2
OpAEX0mod2
lblAEmod2a		Absolute
lblAEmod2b		LDX16
			B	nextinstructionmod2
OpAFM1mod2
lblAFmod2a		AbsoluteLong
lblAFmod2b		LDA8
			B	nextinstructionmod2
OpB0mod2
lblB0mod2		OpB0
			B	nextinstructionmod2
OpB1M1mod2
lblB1mod2a		DirectIndirectIndexed
lblB1mod2b		LDA8
			B	nextinstructionmod2
OpB2M1mod2
lblB2mod2a		DirectIndirect
lblB2mod2b		LDA8
			B	nextinstructionmod2
OpB3M1mod2
lblB3mod2a		StackasmRelativeIndirectIndexed
lblB3mod2b		LDA8
			B	nextinstructionmod2
OpB4X0mod2
lblB4mod2a		DirectIndexedX
lblB4mod2b		LDY16
			B	nextinstructionmod2
OpB5M1mod2
lblB5mod2a		DirectIndexedX
lblB5mod2b		LDA8
			B	nextinstructionmod2
OpB6X0mod2
lblB6mod2a		DirectIndexedY
lblB6mod2b		LDX16
			B	nextinstructionmod2
OpB7M1mod2
lblB7mod2a		DirectIndirectIndexedLong
lblB7mod2b		LDA8
			B	nextinstructionmod2
OpB8mod2
lblB8mod2		OpB8
			B	nextinstructionmod2
OpB9M1mod2
lblB9mod2a		AbsoluteIndexedY
lblB9mod2b		LDA8
			B	nextinstructionmod2
OpBAX0mod2
lblBAmod2		OpBAX0
			B	nextinstructionmod2
OpBBX0mod2
lblBBmod2		OpBBX0
			B	nextinstructionmod2
OpBCX0mod2
lblBCmod2a		AbsoluteIndexedX
lblBCmod2b		LDY16
			B	nextinstructionmod2
OpBDM1mod2
lblBDmod2a		AbsoluteIndexedX
lblBDmod2b		LDA8
			B	nextinstructionmod2
OpBEX0mod2
lblBEmod2a		AbsoluteIndexedY
lblBEmod2b		LDX16
			B	nextinstructionmod2
OpBFM1mod2
lblBFmod2a		AbsoluteLongIndexedX
lblBFmod2b		LDA8
			B	nextinstructionmod2
OpC0X0mod2
lblC0mod2		OpC0X0
			B	nextinstructionmod2
OpC1M1mod2
lblC1mod2a		DirectIndexedIndirect
lblC1mod2b		CMP8
			B	nextinstructionmod2
OpC2mod2
lblC2mod2		OpC2
			B	nextinstructionmod2
OpC3M1mod2
lblC3mod2a		StackasmRelative
lblC3mod2b		CMP8
			B	nextinstructionmod2
OpC4X0mod2
lblC4mod2a		Direct
lblC4mod2b		CMY16
			B	nextinstructionmod2
OpC5M1mod2
lblC5mod2a		Direct
lblC5mod2b		CMP8
			B	nextinstructionmod2
OpC6M1mod2
lblC6mod2a		Direct
lblC6mod2b		DEC8
			B	nextinstructionmod2
OpC7M1mod2
lblC7mod2a		DirectIndirectLong
lblC7mod2b		CMP8
			B	nextinstructionmod2
OpC8X0mod2
lblC8mod2		OpC8X0
			B	nextinstructionmod2
OpC9M1mod2
lblC9mod2		OpC9M1
			B	nextinstructionmod2
OpCAX0mod2
lblCAmod2		OpCAX0
			B	nextinstructionmod2
OpCBmod2
lblCBmod2		OpCB
			B	nextinstructionmod2
OpCCX0mod2
lblCCmod2a		Absolute
lblCCmod2b		CMY16
			B	nextinstructionmod2
OpCDM1mod2
lblCDmod2a		Absolute
lblCDmod2b		CMP8
			B	nextinstructionmod2
OpCEM1mod2
lblCEmod2a		Absolute
lblCEmod2b		DEC8
			B	nextinstructionmod2
OpCFM1mod2
lblCFmod2a		AbsoluteLong
lblCFmod2b		CMP8
			B	nextinstructionmod2
OpD0mod2
lblD0mod2		OpD0
			B	nextinstructionmod2
OpD1M1mod2
lblD1mod2a		DirectIndirectIndexed
lblD1mod2b		CMP8
			B	nextinstructionmod2
OpD2M1mod2
lblD2mod2a		DirectIndirect
lblD2mod2b		CMP8
			B	nextinstructionmod2
OpD3M1mod2
lblD3mod2a		StackasmRelativeIndirectIndexed
lblD3mod2b		CMP8
			B	nextinstructionmod2
OpD4mod2
lblD4mod2a		DirectIndirect
lblD4mod2b		PushW (OpAddress);
			B	nextinstructionmod2
OpD5M1mod2
lblD5mod2a		DirectIndexedX
lblD5mod2b		CMP8
			B	nextinstructionmod2
OpD6M1mod2
lblD6mod2a		DirectIndexedX
lblD6mod2b		DEC8
			B	nextinstructionmod2
OpD7M1mod2
lblD7mod2a		DirectIndirectIndexedLong
lblD7mod2b		CMP8
			B	nextinstructionmod2
OpD8mod2
lblD8mod2		OpD8
			B	nextinstructionmod2
OpD9M1mod2
lblD9mod2a		AbsoluteIndexedY
lblD9mod2b		CMP8
			B	nextinstructionmod2
OpDAX0mod2
lblDAmod2		OpDAX0
			B	nextinstructionmod2
OpDBmod2
lblDBmod2a		CPU.PC--;
lblDBmod2b		CPU.Flags |= DEBUG_MODE_FLAG;
			B	nextinstructionmod2
OpDCmod2
lblDCmod2		OpDC
			B	nextinstructionmod2
OpDDM1mod2
lblDDmod2a		AbsoluteIndexedX
lblDDmod2b		CMP8
			B	nextinstructionmod2
OpDEM1mod2
lblDEmod2a		AbsoluteIndexedX
lblDEmod2b		DEC8
			B	nextinstructionmod2
OpDFM1mod2
lblDFmod2a		AbsoluteLongIndexedX
lblDFmod2b		CMP8
			B	nextinstructionmod2
OpE0X0mod2
lblE0mod2		OpE0X0
			B	nextinstructionmod2
OpE1M1mod2
lblE1mod2a		DirectIndexedIndirect
lblE1mod2b		SBC8
			B	nextinstructionmod2
OpE2mod2
lblE2mod2		OpE2
			B	nextinstructionmod2
OpE3M1mod2
lblE3mod2a		StackasmRelative
lblE3mod2b		SBC8
			B	nextinstructionmod2
OpE4X0mod2
lblE4mod2a		Direct
lblE4mod2b		CMX16
			B	nextinstructionmod2
OpE5M1mod2
lblE5mod2a		Direct
lblE5mod2b		SBC8
			B	nextinstructionmod2
OpE6M1mod2
lblE6mod2a		Direct
lblE6mod2b		INC8
			B	nextinstructionmod2
OpE7M1mod2
lblE7mod2a		DirectIndirectLong
lblE7mod2b		SBC8
			B	nextinstructionmod2
OpE8X0mod2
lblE8mod2		OpE8X0
			B	nextinstructionmod2
OpE9M1mod2
lblE9mod2a		Immediate8
lblE9mod2b		SBC8
			B	nextinstructionmod2
OpEAmod2
lblEAmod2		OpEA
			B	nextinstructionmod2
OpEBmod2
lblEBmod2		OpEB
			B	nextinstructionmod2
OpECX0mod2
lblECmod2a		Absolute
lblECmod2b		CMX16
			B	nextinstructionmod2
OpEDM1mod2
lblEDmod2a		Absolute
lblEDmod2b		SBC8
			B	nextinstructionmod2
OpEEM1mod2
lblEEmod2a		Absolute
lblEEmod2b		INC8
			B	nextinstructionmod2
OpEFM1mod2
lblEFmod2a		AbsoluteLong
lblEFmod2b		SBC8
			B	nextinstructionmod2
OpF0mod2
lblF0mod2		OpF0
			B	nextinstructionmod2
OpF1M1mod2
lblF1mod2a		DirectIndirectIndexed
lblF1mod2b		SBC8
			B	nextinstructionmod2
OpF2M1mod2
lblF2mod2a		DirectIndirect
lblF2mod2b		SBC8
			B	nextinstructionmod2
OpF3M1mod2
lblF3mod2a		StackasmRelativeIndirectIndexed
lblF3mod2b		SBC8
			B	nextinstructionmod2
OpF4mod2
lblF4mod2a		Absolute
lblF4mod2b		PushW (OpAddress);
			B	nextinstructionmod2
OpF5M1mod2
lblF5mod2a		DirectIndexedX
lblF5mod2b		SBC8
			B	nextinstructionmod2
OpF6M1mod2
lblF6mod2a		DirectIndexedX
lblF6mod2b		INC8
			B	nextinstructionmod2
OpF7M1mod2
lblF7mod2a		DirectIndirectIndexedLong
lblF7mod2b		SBC8
			B	nextinstructionmod2
OpF8mod2
lblF8mod2		OpF8
			B	nextinstructionmod2
OpF9M1mod2
lblF9mod2a		AbsoluteIndexedY
lblF9mod2b		SBC8
			B	nextinstructionmod2
OpFAX0mod2
lblFAmod2		OpFAX0
			B	nextinstructionmod2
OpFBmod2
lblFBmod2		OpFB
			B	nextinstructionmod2
OpFCmod2
lblFCmod2		OpFC
			B	nextinstructionmod2
OpFDM1mod2
lblFDmod2a		AbsoluteIndexedX
lblFDmod2b		SBC8
			B	nextinstructionmod2
OpFEM1mod2
lblFEmod2a		AbsoluteIndexedX
lblFEmod2b		INC8
			B	nextinstructionmod2
OpFFM1mod2
lblFFmod2a		AbsoluteLongIndexedX
lblFFmod2b		SBC8
			B	nextinstructionmod2





nextinstructionmod3
			; Empty	for the	moment...
executeinstructionmod3
			LDRB	regopcode, [rpc], #1		; Load opcode, snespc++
			LDR	PC, [PC, regopcode LSL #2]	; Go to	execute	correct	routine
			; From here jump table that modify the PC
			MOV	R0,R0,R0	; Dummy	instruction NOP	 DO NOT	REMOVE
						; align	jmptbl with ARM	PC, never executed
jumptable3		DCD	Op00mod3
			DCD	Op01M0mod3
			DCD	Op02mod3
			DCD	Op03M0mod3
			DCD	Op04M0mod3
			DCD	Op05M0mod3
			DCD	Op06M0mod3
			DCD	Op07M0mod3
			DCD	Op08mod3
			DCD	Op09M0mod3
			DCD	Op0AM0mod3
			DCD	Op0Bmod3
			DCD	Op0CM0mod3
			DCD	Op0DM0mod3
			DCD	Op0EM0mod3
			DCD	Op0FM0mod3
			DCD	Op10mod3
			DCD	Op11M0mod3
			DCD	Op12M0mod3
			DCD	Op13M0mod3
			DCD	Op14M0mod3
			DCD	Op15M0mod3
			DCD	Op16M0mod3
			DCD	Op17M0mod3
			DCD	Op18mod3
			DCD	Op19M0mod3
			DCD	Op1AM0mod3
			DCD	Op1Bmod3
			DCD	Op1CM0mod3
			DCD	Op1DM0mod3
			DCD	Op1EM0mod3
			DCD	Op1FM0mod3
			DCD	Op20mod3
			DCD	Op21M0mod3
			DCD	Op22mod3
			DCD	Op23M0mod3
			DCD	Op24M0mod3
			DCD	Op25M0mod3
			DCD	Op26M0mod3
			DCD	Op27M0mod3
			DCD	Op28mod3
			DCD	Op29M0mod3
			DCD	Op2AM0mod3
			DCD	Op2Bmod3
			DCD	Op2CM0mod3
			DCD	Op2DM0mod3
			DCD	Op2EM0mod3
			DCD	Op2FM0mod3
			DCD	Op30mod3
			DCD	Op31M0mod3
			DCD	Op32M0mod3
			DCD	Op33M0mod3
			DCD	Op34M0mod3
			DCD	Op35M0mod3
			DCD	Op36M0mod3
			DCD	Op37M0mod3
			DCD	Op38mod3
			DCD	Op39M0mod3
			DCD	Op3AM0mod3
			DCD	Op3Bmod3
			DCD	Op3CM0mod3
			DCD	Op3DM0mod3
			DCD	Op3EM0mod3
			DCD	Op3FM0mod3
			DCD	Op40mod3
			DCD	Op41M0mod3
			DCD	Op42mod3
			DCD	Op43M0mod3
			DCD	Op44X0mod3
			DCD	Op45M0mod3
			DCD	Op46M0mod3
			DCD	Op47M0mod3
			DCD	Op48M0mod3
			DCD	Op49M0mod3
			DCD	Op4AM0mod3
			DCD	Op4Bmod3
			DCD	Op4Cmod3
			DCD	Op4DM0mod3
			DCD	Op4EM0mod3
			DCD	Op4FM0mod3
			DCD	Op50mod3
			DCD	Op51M0mod3
			DCD	Op52M0mod3
			DCD	Op53M0mod3
			DCD	Op54X0mod3
			DCD	Op55M0mod3
			DCD	Op56M0mod3
			DCD	Op57M0mod3
			DCD	Op58mod3
			DCD	Op59M0mod3
			DCD	Op5AX0mod3
			DCD	Op5Bmod3
			DCD	Op5Cmod3
			DCD	Op5DM0mod3
			DCD	Op5EM0mod3
			DCD	Op5FM0mod3
			DCD	Op60mod3
			DCD	Op61M0mod3
			DCD	Op62mod3
			DCD	Op63M0mod3
			DCD	Op64M0mod3
			DCD	Op65M0mod3
			DCD	Op66M0mod3
			DCD	Op67M0mod3
			DCD	Op68M0mod3
			DCD	Op69M0mod3
			DCD	Op6AM0mod3
			DCD	Op6Bmod3
			DCD	Op6Cmod3
			DCD	Op6DM0mod3
			DCD	Op6EM0mod3
			DCD	Op6FM0mod3
			DCD	Op70mod3
			DCD	Op71M0mod3
			DCD	Op72M0mod3
			DCD	Op73M0mod3
			DCD	Op74M0mod3
			DCD	Op75M0mod3
			DCD	Op76M0mod3
			DCD	Op77M0mod3
			DCD	Op78mod3
			DCD	Op79M0mod3
			DCD	Op7AX0mod3
			DCD	Op7Bmod3
			DCD	Op7Cmod3
			DCD	Op7DM0mod3
			DCD	Op7EM0mod3
			DCD	Op7FM0mod3
			DCD	Op80mod3
			DCD	Op81M0mod3
			DCD	Op82mod3
			DCD	Op83M0mod3
			DCD	Op84X0mod3
			DCD	Op85M0mod3
			DCD	Op86X0mod3
			DCD	Op87M0mod3
			DCD	Op88X0mod3
			DCD	Op89M0mod3
			DCD	Op8AM0mod3
			DCD	Op8Bmod3
			DCD	Op8CX0mod3
			DCD	Op8DM0mod3
			DCD	Op8EX0mod3
			DCD	Op8FM0mod3
			DCD	Op90mod3
			DCD	Op91M0mod3
			DCD	Op92M0mod3
			DCD	Op93M0mod3
			DCD	Op94X0mod3
			DCD	Op95M0mod3
			DCD	Op96X0mod3
			DCD	Op97M0mod3
			DCD	Op98M0mod3
			DCD	Op99M0mod3
			DCD	Op9Amod3
			DCD	Op9BX0mod3
			DCD	Op9CM0mod3
			DCD	Op9DM0mod3
			DCD	Op9EM0mod3
			DCD	Op9FM0mod3
			DCD	OpA0X0mod3
			DCD	OpA1M0mod3
			DCD	OpA2X0mod3
			DCD	OpA3M0mod3
			DCD	OpA4X0mod3
			DCD	OpA5M0mod3
			DCD	OpA6X0mod3
			DCD	OpA7M0mod3
			DCD	OpA8X0mod3
			DCD	OpA9M0mod3
			DCD	OpAAX0mod3
			DCD	OpABmod3
			DCD	OpACX0mod3
			DCD	OpADM0mod3
			DCD	OpAEX0mod3
			DCD	OpAFM0mod3
			DCD	OpB0mod3
			DCD	OpB1M0mod3
			DCD	OpB2M0mod3
			DCD	OpB3M0mod3
			DCD	OpB4X0mod3
			DCD	OpB5M0mod3
			DCD	OpB6X0mod3
			DCD	OpB7M0mod3
			DCD	OpB8mod3
			DCD	OpB9M0mod3
			DCD	OpBAX0mod3
			DCD	OpBBX0mod3
			DCD	OpBCX0mod3
			DCD	OpBDM0mod3
			DCD	OpBEX0mod3
			DCD	OpBFM0mod3
			DCD	OpC0X0mod3
			DCD	OpC1M0mod3
			DCD	OpC2mod3
			DCD	OpC3M0mod3
			DCD	OpC4X0mod3
			DCD	OpC5M0mod3
			DCD	OpC6M0mod3
			DCD	OpC7M0mod3
			DCD	OpC8X0mod3
			DCD	OpC9M0mod3
			DCD	OpCAX0mod3
			DCD	OpCBmod3
			DCD	OpCCX0mod3
			DCD	OpCDM0mod3
			DCD	OpCEM0mod3
			DCD	OpCFM0mod3
			DCD	OpD0mod3
			DCD	OpD1M0mod3
			DCD	OpD2M0mod3
			DCD	OpD3M0mod3
			DCD	OpD4mod3
			DCD	OpD5M0mod3
			DCD	OpD6M0mod3
			DCD	OpD7M0mod3
			DCD	OpD8mod3
			DCD	OpD9M0mod3
			DCD	OpDAX0mod3
			DCD	OpDBmod3
			DCD	OpDCmod3
			DCD	OpDDM0mod3
			DCD	OpDEM0mod3
			DCD	OpDFM0mod3
			DCD	OpE0X0mod3
			DCD	OpE1M0mod3
			DCD	OpE2mod3
			DCD	OpE3M0mod3
			DCD	OpE4X0mod3
			DCD	OpE5M0mod3
			DCD	OpE6M0mod3
			DCD	OpE7M0mod3
			DCD	OpE8X0mod3
			DCD	OpE9M0mod3
			DCD	OpEAmod3
			DCD	OpEBmod3
			DCD	OpECX0mod3
			DCD	OpEDM0mod3
			DCD	OpEEM0mod3
			DCD	OpEFM0mod3
			DCD	OpF0mod3
			DCD	OpF1M0mod3
			DCD	OpF2M0mod3
			DCD	OpF3M0mod3
			DCD	OpF4mod3
			DCD	OpF5M0mod3
			DCD	OpF6M0mod3
			DCD	OpF7M0mod3
			DCD	OpF8mod3
			DCD	OpF9M0mod3
			DCD	OpFAX0mod3
			DCD	OpFBmod3
			DCD	OpFCmod3
			DCD	OpFDM0mod3
			DCD	OpFEM0mod3
			DCD	OpFFM0mod3
Op00mod3
lbl00mod3		Op00
			B	nextinstructionmod3
Op01M0mod3
lbl01mod3a		DirectIndexedIndirect
lbl01mod3b		ORA16
			B	nextinstructionmod3
Op02mod3
lbl02mod3		Op02
			B	nextinstructionmod3
Op03M0mod3
lbl03mod3a		StackasmRelative
lbl03mod3b		ORA16
			B	nextinstructionmod3
Op04M0mod3
lbl04mod3a		Direct
lbl04mod3b		TSB16
			B	nextinstructionmod3
Op05M0mod3
lbl05mod3a		Direct
lbl05mod3b		ORA16
			B	nextinstructionmod3
Op06M0mod3
lbl06mod3a		Direct
lbl06mod3b		ASL16
			B	nextinstructionmod3
Op07M0mod3
lbl07mod3a		DirectIndirectLong
lbl07mod3b		ORA16
			B	nextinstructionmod3
Op08mod3
lbl08mod3		Op08
			B	nextinstructionmod3
Op09M0mod3
lbl09mod3		Op09M0
			B	nextinstructionmod3
Op0AM0mod3
lbl0Amod3a		A_ASL16
			B	nextinstructionmod3
Op0Bmod3
lbl0Bmod3		Op0B
			B	nextinstructionmod3
Op0CM0mod3
lbl0Cmod3a		Absolute
lbl0Cmod3b		TSB16
			B	nextinstructionmod3
Op0DM0mod3
lbl0Dmod3a		Absolute
lbl0Dmod3b		ORA16
			B	nextinstructionmod3
Op0EM0mod3
lbl0Emod3a		Absolute
lbl0Emod3b		ASL16
			B	nextinstructionmod3
Op0FM0mod3
lbl0Fmod3a		AbsoluteLong
lbl0Fmod3b		ORA16
			B	nextinstructionmod3
Op10mod3
lbl10mod3		Op10
			B	nextinstructionmod3
Op11M0mod3
lbl11mod3a		DirectIndirectIndexed
lbl11mod3b		ORA16
			B	nextinstructionmod3
Op12M0mod3
lbl12mod3a		DirectIndirect
lbl12mod3b		ORA16
			B	nextinstructionmod3
Op13M0mod3
lbl13mod3a		StackasmRelativeIndirectIndexed
lbl13mod3b		ORA16
			B	nextinstructionmod3
Op14M0mod3
lbl14mod3a		Direct
lbl14mod3b		TRB16
			B	nextinstructionmod3
Op15M0mod3
lbl15mod3a		DirectIndexedX
lbl15mod3b		ORA16
			B	nextinstructionmod3
Op16M0mod3
lbl16mod3a		DirectIndexedX
lbl16mod3b		ASL16
			B	nextinstructionmod3
Op17M0mod3
lbl17mod3a		DirectIndirectIndexedLong
lbl17mod3b		ORA16
			B	nextinstructionmod3
Op18mod3
lbl18mod3		Op18
			B	nextinstructionmod3
Op19M0mod3
lbl19mod3a		AbsoluteIndexedY
lbl19mod3b		ORA16
			B	nextinstructionmod3
Op1AM0mod3
lbl1Amod3a		A_INC16
			B	nextinstructionmod3
Op1Bmod3
lbl1Bmod3		Op1B
			B	nextinstructionmod3
Op1CM0mod3
lbl1Cmod3a		Absolute
lbl1Cmod3b		TRB16
			B	nextinstructionmod3
Op1DM0mod3
lbl1Dmod3a		AbsoluteIndexedX
lbl1Dmod3b		ORA16
			B	nextinstructionmod3
Op1EM0mod3
lbl1Emod3a		AbsoluteIndexedX
lbl1Emod3b		ASL16
			B	nextinstructionmod3
Op1FM0mod3
lbl1Fmod3a		AbsoluteLongIndexedX
lbl1Fmod3b		ORA16
			B	nextinstructionmod3
Op20mod3
lbl20mod3		Op20
			B	nextinstructionmod3
Op21M0mod3
lbl21mod3a		DirectIndexedIndirect
lbl21mod3b		AND16
			B	nextinstructionmod3
Op22mod3
lbl22mod3		Op22
			B	nextinstructionmod3
Op23M0mod3
lbl23mod3a		StackasmRelative
lbl23mod3b		AND16
			B	nextinstructionmod3
Op24M0mod3
lbl24mod3a		Direct
lbl24mod3b		BIT16
			B	nextinstructionmod3
Op25M0mod3
lbl25mod3a		Direct
lbl25mod3b		AND16
			B	nextinstructionmod3
Op26M0mod3
lbl26mod3a		Direct
lbl26mod3b		ROL16
			B	nextinstructionmod3
Op27M0mod3
lbl27mod3a		DirectIndirectLong
lbl27mod3b		AND16
			B	nextinstructionmod3
Op28mod3
lbl28mod3		Op28
			B	nextinstructionmod3
Op29M0mod3
lbl29mod3		Op29M0
			B	nextinstructionmod3
Op2AM0mod3
lbl2Amod3a		A_ROL16
			B	nextinstructionmod3
Op2Bmod3
lbl2Bmod3		Op2B
			B	nextinstructionmod3
Op2CM0mod3
lbl2Cmod3a		Absolute
lbl2Cmod3b		BIT16
			B	nextinstructionmod3
Op2DM0mod3
lbl2Dmod3a		Absolute
lbl2Dmod3b		AND16
			B	nextinstructionmod3
Op2EM0mod3
lbl2Emod3a		Absolute
lbl2Emod3b		ROL16
			B	nextinstructionmod3
Op2FM0mod3
lbl2Fmod3a		AbsoluteLong
lbl2Fmod3b		AND16
			B	nextinstructionmod3
Op30mod3
lbl30mod3		Op30
			B	nextinstructionmod3
Op31M0mod3
lbl31mod3a		DirectIndirectIndexed
lbl31mod3b		AND16
			B	nextinstructionmod3
Op32M0mod3
lbl32mod3a		DirectIndirect
lbl32mod3b		AND16
			B	nextinstructionmod3
Op33M0mod3
lbl33mod3a		StackasmRelativeIndirectIndexed
lbl33mod3b		AND16
			B	nextinstructionmod3
Op34M0mod3
lbl34mod3a		DirectIndexedX
lbl34mod3b		BIT16
			B	nextinstructionmod3
Op35M0mod3
lbl35mod3a		DirectIndexedX
lbl35mod3b		AND16
			B	nextinstructionmod3
Op36M0mod3
lbl36mod3a		DirectIndexedX
lbl36mod3b		ROL16
			B	nextinstructionmod3
Op37M0mod3
lbl37mod3a		DirectIndirectIndexedLong
lbl37mod3b		AND16
			B	nextinstructionmod3
Op38mod3
lbl38mod3		Op38
			B	nextinstructionmod3
Op39M0mod3
lbl39mod3a		AbsoluteIndexedY
lbl39mod3b		AND16
			B	nextinstructionmod3
Op3AM0mod3
lbl3Amod3a		A_DEC16
			B	nextinstructionmod3
Op3Bmod3
lbl3Bmod3		Op3B
			B	nextinstructionmod3
Op3CM0mod3
lbl3Cmod3a		AbsoluteIndexedX
lbl3Cmod3b		BIT16
			B	nextinstructionmod3
Op3DM0mod3
lbl3Dmod3a		AbsoluteIndexedX
lbl3Dmod3b		AND16
			B	nextinstructionmod3
Op3EM0mod3
lbl3Emod3a		AbsoluteIndexedX
lbl3Emod3b		ROL16
			B	nextinstructionmod3
Op3FM0mod3
lbl3Fmod3a		AbsoluteLongIndexedX
lbl3Fmod3b		AND16
			B	nextinstructionmod3
Op40mod3
lbl40mod3		Op40
			B	nextinstructionmod3
Op41M0mod3
lbl41mod3a		DirectIndexedIndirect
lbl41mod3b		EOR16
			B	nextinstructionmod3
Op42mod3
lbl42mod3a
			B	nextinstructionmod3
Op43M0mod3
lbl43mod3a		StackasmRelative
lbl43mod3b		EOR16
			B	nextinstructionmod3
Op44X0mod3
lbl44mod3		Op44X0
			B	nextinstructionmod3
Op45M0mod3
lbl45mod3a		Direct
lbl45mod3b		EOR16
			B	nextinstructionmod3
Op46M0mod3
lbl46mod3a		Direct
lbl46mod3b		LSR16
			B	nextinstructionmod3
Op47M0mod3
lbl47mod3a		DirectIndirectLong
lbl47mod3b		EOR16
			B	nextinstructionmod3
Op48M0mod3
lbl48mod3		Op48M0
			B	nextinstructionmod3
Op49M0mod3
lbl49mod3		Op49M0
			B	nextinstructionmod3
Op4AM0mod3
lbl4Amod3a		A_LSR16
			B	nextinstructionmod3
Op4Bmod3
lbl4Bmod3		Op4B
			B	nextinstructionmod3
Op4Cmod3
lbl4Cmod3a		Absolute
lbl4Cmod3b		S9xSetPCBase (ICPU.ShiftedPB + (OpAddress & 0xffff));
			B	nextinstructionmod3
Op4DM0mod3
lbl4Dmod3a		Absolute
lbl4Dmod3b		EOR16
			B	nextinstructionmod3
Op4EM0mod3
lbl4Emod3a		Absolute
lbl4Emod3b		LSR16
			B	nextinstructionmod3
Op4FM0mod3
lbl4Fmod3a		AbsoluteLong
lbl4Fmod3b		EOR16
			B	nextinstructionmod3
Op50mod3
lbl50mod3		Op50
			B	nextinstructionmod3
Op51M0mod3
lbl51mod3a		DirectIndirectIndexed
lbl51mod3b		EOR16
			B	nextinstructionmod3
Op52M0mod3
lbl52mod3a		DirectIndirect
lbl52mod3b		EOR16
			B	nextinstructionmod3
Op53M0mod3
lbl53mod3a		StackasmRelativeIndirectIndexed
lbl53mod3b		EOR16
			B	nextinstructionmod3
Op54X0mod3
lbl54mod3		Op54X0
			B	nextinstructionmod3
Op55M0mod3
lbl55mod3a		DirectIndexedX
lbl55mod3b		EOR16
			B	nextinstructionmod3
Op56M0mod3
lbl56mod3a		DirectIndexedX
lbl56mod3b		LSR16
			B	nextinstructionmod3
Op57M0mod3
lbl57mod3a		DirectIndirectIndexedLong
lbl57mod3b		EOR16
			B	nextinstructionmod3
Op58mod3
lbl58mod3		Op58
			B	nextinstructionmod3
Op59M0mod3
lbl59mod3a		AbsoluteIndexedY
lbl59mod3b		EOR16
			B	nextinstructionmod3
Op5AX0mod3
lbl5Amod3		Op5AX0
			B	nextinstructionmod3
Op5Bmod3
lbl5Bmod3		Op5B
			B	nextinstructionmod3
Op5Cmod3
lbl5Cmod3		Op5C
			B	nextinstructionmod3
Op5DM0mod3
lbl5Dmod3a		AbsoluteIndexedX
lbl5Dmod3b		EOR16
			B	nextinstructionmod3
Op5EM0mod3
lbl5Emod3a		AbsoluteIndexedX
lbl5Emod3b		LSR16
			B	nextinstructionmod3
Op5FM0mod3
lbl5Fmod3a		AbsoluteLongIndexedX
lbl5Fmod3b		EOR16
			B	nextinstructionmod3
Op60mod3
lbl60mod3		Op60
			B	nextinstructionmod3
Op61M0mod3
lbl61mod3a		DirectIndexedIndirect
lbl61mod3b		ADC16
			B	nextinstructionmod3
Op62mod3
lbl62mod3a		asmRelativeLong
lbl62mod3b		PushW (OpAddress);
			B	nextinstructionmod3
Op63M0mod3
lbl63mod3a		StackasmRelative
lbl63mod3b		ADC16
			B	nextinstructionmod3
Op64M0mod3
lbl64mod3a		Direct
lbl64mod3b		STZ16
			B	nextinstructionmod3
Op65M0mod3
lbl65mod3a		Direct
lbl65mod3b		ADC16
			B	nextinstructionmod3
Op66M0mod3
lbl66mod3a		Direct
lbl66mod3b		ROR16
			B	nextinstructionmod3
Op67M0mod3
lbl67mod3a		DirectIndirectLong
lbl67mod3b		ADC16
			B	nextinstructionmod3
Op68M0mod3
lbl68mod3		Op68M0
			B	nextinstructionmod3
Op69M0mod3
lbl69mod3a		Immediate16
lbl69mod3b		ADC16
			B	nextinstructionmod3
Op6AM0mod3
lbl6Amod3a		A_ROR16
			B	nextinstructionmod3
Op6Bmod3
lbl6Bmod3		Op6B
			B	nextinstructionmod3
Op6Cmod3
lbl6Cmod3a		AbsoluteIndirect
lbl6Cmod3b		S9xSetPCBase (ICPU.ShiftedPB + (OpAddress & 0xffff));
			B	nextinstructionmod3
Op6DM0mod3
lbl6Dmod3a		Absolute
lbl6Dmod3b		ADC16
			B	nextinstructionmod3
Op6EM0mod3
lbl6Emod3a		Absolute
lbl6Emod3b		ROR16
			B	nextinstructionmod3
Op6FM0mod3
lbl6Fmod3a		AbsoluteLong
lbl6Fmod3b		ADC16
			B	nextinstructionmod3
Op70mod3
lbl70mod3		Op70
			B	nextinstructionmod3
Op71M0mod3
lbl71mod3a		DirectIndirectIndexed
lbl71mod3b		ADC16
			B	nextinstructionmod3
Op72M0mod3
lbl72mod3a		DirectIndirect
lbl72mod3b		ADC16
			B	nextinstructionmod3
Op73M0mod3
lbl73mod3a		StackasmRelativeIndirectIndexed
lbl73mod3b		ADC16
			B	nextinstructionmod3
Op74M0mod3
lbl74mod3a		DirectIndexedX
lbl74mod3b		STZ16
			B	nextinstructionmod3
Op75M0mod3
lbl75mod3a		DirectIndexedX
lbl75mod3b		ADC16
			B	nextinstructionmod3
Op76M0mod3
lbl76mod3a		DirectIndexedX
lbl76mod3b		ROR16
			B	nextinstructionmod3
Op77M0mod3
lbl77mod3a		DirectIndirectIndexedLong
lbl77mod3b		ADC16
			B	nextinstructionmod3
Op78mod3
lbl78mod3		Op78
			B	nextinstructionmod3
Op79M0mod3
lbl79mod3a		AbsoluteIndexedY
lbl79mod3b		ADC16
			B	nextinstructionmod3
Op7AX0mod3
lbl7Amod3		Op7AX0
			B	nextinstructionmod3
Op7Bmod3
lbl7Bmod3		Op7B
			B	nextinstructionmod3
Op7Cmod3
lbl7Cmod3		Op7C
			B	nextinstructionmod3
Op7DM0mod3
lbl7Dmod3a		AbsoluteIndexedX
lbl7Dmod3b		ADC16
			B	nextinstructionmod3
Op7EM0mod3
lbl7Emod3a		AbsoluteIndexedX
lbl7Emod3b		ROR16
			B	nextinstructionmod3
Op7FM0mod3
lbl7Fmod3a		AbsoluteLongIndexedX
lbl7Fmod3b		ADC16
			B	nextinstructionmod3
Op80mod3
lbl80mod3		Op80
			B	nextinstructionmod3
Op81M0mod3
lbl81mod3		Op81M0
			B	nextinstructionmod3
Op82mod3
lbl82mod3a		asmRelativeLong
lbl82mod3b		S9xSetPCBase (ICPU.ShiftedPB + OpAddress);
			B	nextinstructionmod3
Op83M0mod3
lbl83mod3a		StackasmRelative
lbl83mod3b		STA16
			B	nextinstructionmod3
Op84X0mod3
lbl84mod3a		Direct
lbl84mod3b		STY16
			B	nextinstructionmod3
Op85M0mod3
lbl85mod3a		Direct
lbl85mod3b		STA16
			B	nextinstructionmod3
Op86X0mod3
lbl86mod3a		Direct
lbl86mod3b		STX16
			B	nextinstructionmod3
Op87M0mod3
lbl87mod3a		DirectIndirectLong
lbl87mod3b		STA16
			B	nextinstructionmod3
Op88X0mod3
lbl88mod3		Op88X0
			B	nextinstructionmod3
Op89M0mod3
lbl89mod3		Op89M0
			B	nextinstructionmod3
Op8AM0mod3
lbl8Amod3		Op8AM0
			B	nextinstructionmod3
Op8Bmod3
lbl8Bmod3		Op8B
			B	nextinstructionmod3
Op8CX0mod3
lbl8Cmod3a		Absolute
lbl8Cmod3b		STY16
			B	nextinstructionmod3
Op8DM0mod3
lbl8Dmod3a		Absolute
lbl8Dmod3b		STA16
			B	nextinstructionmod3
Op8EX0mod3
lbl8Emod3a		Absolute
lbl8Emod3b		STX16
			B	nextinstructionmod3
Op8FM0mod3
lbl8Fmod3a		AbsoluteLong
lbl8Fmod3b		STA16
			B	nextinstructionmod3
Op90mod3
lbl90mod3		Op90
			B	nextinstructionmod3
Op91M0mod3
lbl91mod3a		DirectIndirectIndexed
lbl91mod3b		STA16
			B	nextinstructionmod3
Op92M0mod3
lbl92mod3a		DirectIndirect
lbl92mod3b		STA16
			B	nextinstructionmod3
Op93M0mod3
lbl93mod3a		StackasmRelativeIndirectIndexed
lbl93mod3b		STA16
			B	nextinstructionmod3
Op94X0mod3
lbl94mod3a		DirectIndexedX
lbl94mod3b		STY16
			B	nextinstructionmod3
Op95M0mod3
lbl95mod3a		DirectIndexedX
lbl95mod3b		STA16
			B	nextinstructionmod3
Op96X0mod3
lbl96mod3a		DirectIndexedY
lbl96mod3b		STX16
			B	nextinstructionmod3
Op97M0mod3
lbl97mod3a		DirectIndirectIndexedLong
lbl97mod3b		STA16
			B	nextinstructionmod3
Op98M0mod3
lbl98mod3		Op98M0
			B	nextinstructionmod3
Op99M0mod3
lbl99mod3a		AbsoluteIndexedY
lbl99mod3b		STA16
			B	nextinstructionmod3
Op9Amod3
lbl9Amod3		Op9A
			B	nextinstructionmod3
Op9BX0mod3
lbl9Bmod3		Op9BX0
			B	nextinstructionmod3
Op9CM0mod3
lbl9Cmod3a		Absolute
lbl9Cmod3b		STZ16
			B	nextinstructionmod3
Op9DM0mod3
lbl9Dmod3a		AbsoluteIndexedX
lbl9Dmod3b		STA16
			B	nextinstructionmod3
Op9EM0mod3
lbl9Emod3a		AbsoluteIndexedX
lbl9Emod3b		STZ16
			B	nextinstructionmod3
Op9FM0mod3
lbl9Fmod3a		AbsoluteLongIndexedX
lbl9Fmod3b		STA16
			B	nextinstructionmod3
OpA0X0mod3
lblA0mod3		OpA0X0
			B	nextinstructionmod3
OpA1M0mod3
lblA1mod3a		DirectIndexedIndirect
lblA1mod3b		LDA16
			B	nextinstructionmod3
OpA2X0mod3
lblA2mod3		OpA2X0
			B	nextinstructionmod3
OpA3M0mod3
lblA3mod3a		StackasmRelative
lblA3mod3b		LDA16
			B	nextinstructionmod3
OpA4X0mod3
lblA4mod3a		Direct
lblA4mod3b		LDY16
			B	nextinstructionmod3
OpA5M0mod3
lblA5mod3a		Direct
lblA5mod3b		LDA16
			B	nextinstructionmod3
OpA6X0mod3
lblA6mod3a		Direct
lblA6mod3b		LDX16
			B	nextinstructionmod3
OpA7M0mod3
lblA7mod3a		DirectIndirectLong
lblA7mod3b		LDA16
			B	nextinstructionmod3
OpA8X0mod3
lblA8mod3		OpA8X0
			B	nextinstructionmod3
OpA9M0mod3
lblA9mod3		OpA9M0
			B	nextinstructionmod3
OpAAX0mod3
lblAAmod3		OpAAX0
			B	nextinstructionmod3
OpABmod3
lblABmod3		OpAB
			B	nextinstructionmod3
OpACX0mod3
lblACmod3a		Absolute
lblACmod3b		LDY16
			B	nextinstructionmod3
OpADM0mod3
lblADmod3a		Absolute
lblADmod3b		LDA16
			B	nextinstructionmod3
OpAEX0mod3
lblAEmod3a		Absolute
lblAEmod3b		LDX16
			B	nextinstructionmod3
OpAFM0mod3
lblAFmod3a		AbsoluteLong
lblAFmod3b		LDA16
			B	nextinstructionmod3
OpB0mod3
lblB0mod3		OpB0
			B	nextinstructionmod3
OpB1M0mod3
lblB1mod3a		DirectIndirectIndexed
lblB1mod3b		LDA16
			B	nextinstructionmod3
OpB2M0mod3
lblB2mod3a		DirectIndirect
lblB2mod3b		LDA16
			B	nextinstructionmod3
OpB3M0mod3
lblB3mod3a		StackasmRelativeIndirectIndexed
lblB3mod3b		LDA16
			B	nextinstructionmod3
OpB4X0mod3
lblB4mod3a		DirectIndexedX
lblB4mod3b		LDY16
			B	nextinstructionmod3
OpB5M0mod3
lblB5mod3a		DirectIndexedX
lblB5mod3b		LDA16
			B	nextinstructionmod3
OpB6X0mod3
lblB6mod3a		DirectIndexedY
lblB6mod3b		LDX16
			B	nextinstructionmod3
OpB7M0mod3
lblB7mod3a		DirectIndirectIndexedLong
lblB7mod3b		LDA16
			B	nextinstructionmod3
OpB8mod3
lblB8mod3		OpB8
			B	nextinstructionmod3
OpB9M0mod3
lblB9mod3a		AbsoluteIndexedY
lblB9mod3b		LDA16
			B	nextinstructionmod3
OpBAX0mod3
lblBAmod3		OpBAX0
			B	nextinstructionmod3
OpBBX0mod3
lblBBmod3		OpBBX0
			B	nextinstructionmod3
OpBCX0mod3
lblBCmod3a		AbsoluteIndexedX
lblBCmod3b		LDY16
			B	nextinstructionmod3
OpBDM0mod3
lblBDmod3a		AbsoluteIndexedX
lblBDmod3b		LDA16
			B	nextinstructionmod3
OpBEX0mod3
lblBEmod3a		AbsoluteIndexedY
lblBEmod3b		LDX16
			B	nextinstructionmod3
OpBFM0mod3
lblBFmod3a		AbsoluteLongIndexedX
lblBFmod3b		LDA16
			B	nextinstructionmod3
OpC0X0mod3
lblC0mod3		OpC0X0
			B	nextinstructionmod3
OpC1M0mod3
lblC1mod3a		DirectIndexedIndirect
lblC1mod3b		CMP16
			B	nextinstructionmod3
OpC2mod3
lblC2mod3		OpC2
			B	nextinstructionmod3
OpC3M0mod3
lblC3mod3a		StackasmRelative
lblC3mod3b		CMP16
			B	nextinstructionmod3
OpC4X0mod3
lblC4mod3a		Direct
lblC4mod3b		CMY16
			B	nextinstructionmod3
OpC5M0mod3
lblC5mod3a		Direct
lblC5mod3b		CMP16
			B	nextinstructionmod3
OpC6M0mod3
lblC6mod3a		Direct
lblC6mod3b		DEC16
			B	nextinstructionmod3
OpC7M0mod3
lblC7mod3a		DirectIndirectLong
lblC7mod3b		CMP16
			B	nextinstructionmod3
OpC8X0mod3
lblC8mod3		OpC8X0
			B	nextinstructionmod3
OpC9M0mod3
lblC9mod3		OpC9M0
			B	nextinstructionmod3
OpCAX0mod3
lblCAmod3		OpCAX0
			B	nextinstructionmod3
OpCBmod3
lblCBmod3		OpCB
			B	nextinstructionmod3
OpCCX0mod3
lblCCmod3a		Absolute
lblCCmod3b		CMY16
			B	nextinstructionmod3
OpCDM0mod3
lblCDmod3a		Absolute
lblCDmod3b		CMP16
			B	nextinstructionmod3
OpCEM0mod3
lblCEmod3a		Absolute
lblCEmod3b		DEC16
			B	nextinstructionmod3
OpCFM0mod3
lblCFmod3a		AbsoluteLong
lblCFmod3b		CMP16
			B	nextinstructionmod3
OpD0mod3
lblD0mod3		OpD0
			B	nextinstructionmod3
OpD1M0mod3
lblD1mod3a		DirectIndirectIndexed
lblD1mod3b		CMP16
			B	nextinstructionmod3
OpD2M0mod3
lblD2mod3a		DirectIndirect
lblD2mod3b		CMP16
			B	nextinstructionmod3
OpD3M0mod3
lblD3mod3a		StackasmRelativeIndirectIndexed
lblD3mod3b		CMP16
			B	nextinstructionmod3
OpD4mod3
lblD4mod3a		DirectIndirect
lblD4mod3b		PushW (OpAddress);
			B	nextinstructionmod3
OpD5M0mod3
lblD5mod3a		DirectIndexedX
lblD5mod3b		CMP16
			B	nextinstructionmod3
OpD6M0mod3
lblD6mod3a		DirectIndexedX
lblD6mod3b		DEC16
			B	nextinstructionmod3
OpD7M0mod3
lblD7mod3a		DirectIndirectIndexedLong
lblD7mod3b		CMP16
			B	nextinstructionmod3
OpD8mod3
lblD8mod3		OpD8
			B	nextinstructionmod3
OpD9M0mod3
lblD9mod3a		AbsoluteIndexedY
lblD9mod3b		CMP16
			B	nextinstructionmod3
OpDAX0mod3
lblDAmod3		OpDAX0
			B	nextinstructionmod3
OpDBmod3
lblDBmod3a		CPU.PC--;
lblDBmod3b		CPU.Flags |= DEBUG_MODE_FLAG;
			B	nextinstructionmod3
OpDCmod3
lblDCmod3		OpDC
			B	nextinstructionmod3
OpDDM0mod3
lblDDmod3a		AbsoluteIndexedX
lblDDmod3b		CMP16
			B	nextinstructionmod3
OpDEM0mod3
lblDEmod3a		AbsoluteIndexedX
lblDEmod3b		DEC16
			B	nextinstructionmod3
OpDFM0mod3
lblDFmod3a		AbsoluteLongIndexedX
lblDFmod3b		CMP16
			B	nextinstructionmod3
OpE0X0mod3
lblE0mod3		OpE0X0
			B	nextinstructionmod3
OpE1M0mod3
lblE1mod3a		DirectIndexedIndirect
lblE1mod3b		SBC16
			B	nextinstructionmod3
OpE2mod3
lblE2mod3		OpE2
			B	nextinstructionmod3
OpE3M0mod3
lblE3mod3a		StackasmRelative
lblE3mod3b		SBC16
			B	nextinstructionmod3
OpE4X0mod3
lblE4mod3a		Direct
lblE4mod3b		CMX16
			B	nextinstructionmod3
OpE5M0mod3
lblE5mod3a		Direct
lblE5mod3b		SBC16
			B	nextinstructionmod3
OpE6M0mod3
lblE6mod3a		Direct
lblE6mod3b		INC16
			B	nextinstructionmod3
OpE7M0mod3
lblE7mod3a		DirectIndirectLong
lblE7mod3b		SBC16
			B	nextinstructionmod3
OpE8X0mod3
lblE8mod3		OpE8X0
			B	nextinstructionmod3
OpE9M0mod3
lblE9mod3a		Immediate16
lblE9mod3b		SBC16
			B	nextinstructionmod3
OpEAmod3
lblEAmod3		OpEA
			B	nextinstructionmod3
OpEBmod3
lblEBmod3		OpEB
			B	nextinstructionmod3
OpECX0mod3
lblECmod3a		Absolute
lblECmod3b		CMX16
			B	nextinstructionmod3
OpEDM0mod3
lblEDmod3a		Absolute
lblEDmod3b		SBC16
			B	nextinstructionmod3
OpEEM0mod3
lblEEmod3a		Absolute
lblEEmod3b		INC16
			B	nextinstructionmod3
OpEFM0mod3
lblEFmod3a		AbsoluteLong
lblEFmod3b		SBC16
			B	nextinstructionmod3
OpF0mod3
lblF0mod3		OpF0
			B	nextinstructionmod3
OpF1M0mod3
lblF1mod3a		DirectIndirectIndexed
lblF1mod3b		SBC16
			B	nextinstructionmod3
OpF2M0mod3
lblF2mod3a		DirectIndirect
lblF2mod3b		SBC16
			B	nextinstructionmod3
OpF3M0mod3
lblF3mod3a		StackasmRelativeIndirectIndexed
lblF3mod3b		SBC16
			B	nextinstructionmod3
OpF4mod3
lblF4mod3a		Absolute
lblF4mod3b		PushW (OpAddress);
			B	nextinstructionmod3
OpF5M0mod3
lblF5mod3a		DirectIndexedX
lblF5mod3b		SBC16
			B	nextinstructionmod3
OpF6M0mod3
lblF6mod3a		DirectIndexedX
lblF6mod3b		INC16
			B	nextinstructionmod3
OpF7M0mod3
lblF7mod3a		DirectIndirectIndexedLong
lblF7mod3b		SBC16
			B	nextinstructionmod3
OpF8mod3
lblF8mod3		OpF8
			B	nextinstructionmod3
OpF9M0mod3
lblF9mod3a		AbsoluteIndexedY
lblF9mod3b		SBC16
			B	nextinstructionmod3
OpFAX0mod3
lblFAmod3		OpFAX0
			B	nextinstructionmod3
OpFBmod3
lblFBmod3		OpFB
			B	nextinstructionmod3
OpFCmod3
lblFCmod3		OpFC
			B	nextinstructionmod3
OpFDM0mod3
lblFDmod3a		AbsoluteIndexedX
lblFDmod3b		SBC16
			B	nextinstructionmod3
OpFEM0mod3
lblFEmod3a		AbsoluteIndexedX
lblFEmod3b		INC16
			B	nextinstructionmod3
OpFFM0mod3
lblFFmod3a		AbsoluteLongIndexedX
lblFFmod3b		SBC16
			B	nextinstructionmod3


nextinstructionmod4
			; Empty	for the	moment...
executeinstructionmod4
			LDRB	regopcode, [rpc], #1		; Load opcode, snespc++
			LDR	PC, [PC, regopcode LSL #2]	; Go to	execute	correct	routine
			; From here jump table that modify the PC
			MOV	R0,R0,R0	; Dummy	instruction NOP	 DO NOT	REMOVE
						; align	jmptbl with ARM	PC, never executed
jumptable4		DCD	Op00mod4
			DCD	Op01M0mod4
			DCD	Op02mod4
			DCD	Op03M0mod4
			DCD	Op04M0mod4
			DCD	Op05M0mod4
			DCD	Op06M0mod4
			DCD	Op07M0mod4
			DCD	Op08mod4
			DCD	Op09M0mod4
			DCD	Op0AM0mod4
			DCD	Op0Bmod4
			DCD	Op0CM0mod4
			DCD	Op0DM0mod4
			DCD	Op0EM0mod4
			DCD	Op0FM0mod4
			DCD	Op10mod4
			DCD	Op11M0mod4
			DCD	Op12M0mod4
			DCD	Op13M0mod4
			DCD	Op14M0mod4
			DCD	Op15M0mod4
			DCD	Op16M0mod4
			DCD	Op17M0mod4
			DCD	Op18mod4
			DCD	Op19M0mod4
			DCD	Op1AM0mod4
			DCD	Op1Bmod4
			DCD	Op1CM0mod4
			DCD	Op1DM0mod4
			DCD	Op1EM0mod4
			DCD	Op1FM0mod4
			DCD	Op20mod4
			DCD	Op21M0mod4
			DCD	Op22mod4
			DCD	Op23M0mod4
			DCD	Op24M0mod4
			DCD	Op25M0mod4
			DCD	Op26M0mod4
			DCD	Op27M0mod4
			DCD	Op28mod4
			DCD	Op29M0mod4
			DCD	Op2AM0mod4
			DCD	Op2Bmod4
			DCD	Op2CM0mod4
			DCD	Op2DM0mod4
			DCD	Op2EM0mod4
			DCD	Op2FM0mod4
			DCD	Op30mod4
			DCD	Op31M0mod4
			DCD	Op32M0mod4
			DCD	Op33M0mod4
			DCD	Op34M0mod4
			DCD	Op35M0mod4
			DCD	Op36M0mod4
			DCD	Op37M0mod4
			DCD	Op38mod4
			DCD	Op39M0mod4
			DCD	Op3AM0mod4
			DCD	Op3Bmod4
			DCD	Op3CM0mod4
			DCD	Op3DM0mod4
			DCD	Op3EM0mod4
			DCD	Op3FM0mod4
			DCD	Op40mod4
			DCD	Op41M0mod4
			DCD	Op42mod4
			DCD	Op43M0mod4
			DCD	Op44X1mod4
			DCD	Op45M0mod4
			DCD	Op46M0mod4
			DCD	Op47M0mod4
			DCD	Op48M0mod4
			DCD	Op49M0mod4
			DCD	Op4AM0mod4
			DCD	Op4Bmod4
			DCD	Op4Cmod4
			DCD	Op4DM0mod4
			DCD	Op4EM0mod4
			DCD	Op4FM0mod4
			DCD	Op50mod4
			DCD	Op51M0mod4
			DCD	Op52M0mod4
			DCD	Op53M0mod4
			DCD	Op54X1mod4
			DCD	Op55M0mod4
			DCD	Op56M0mod4
			DCD	Op57M0mod4
			DCD	Op58mod4
			DCD	Op59M0mod4
			DCD	Op5AX1mod4
			DCD	Op5Bmod4
			DCD	Op5Cmod4
			DCD	Op5DM0mod4
			DCD	Op5EM0mod4
			DCD	Op5FM0mod4
			DCD	Op60mod4
			DCD	Op61M0mod4
			DCD	Op62mod4
			DCD	Op63M0mod4
			DCD	Op64M0mod4
			DCD	Op65M0mod4
			DCD	Op66M0mod4
			DCD	Op67M0mod4
			DCD	Op68M0mod4
			DCD	Op69M0mod4
			DCD	Op6AM0mod4
			DCD	Op6Bmod4
			DCD	Op6Cmod4
			DCD	Op6DM0mod4
			DCD	Op6EM0mod4
			DCD	Op6FM0mod4
			DCD	Op70mod4
			DCD	Op71M0mod4
			DCD	Op72M0mod4
			DCD	Op73M0mod4
			DCD	Op74M0mod4
			DCD	Op75M0mod4
			DCD	Op76M0mod4
			DCD	Op77M0mod4
			DCD	Op78mod4
			DCD	Op79M0mod4
			DCD	Op7AX1mod4
			DCD	Op7Bmod4
			DCD	Op7Cmod4
			DCD	Op7DM0mod4
			DCD	Op7EM0mod4
			DCD	Op7FM0mod4
			DCD	Op80mod4
			DCD	Op81M0mod4
			DCD	Op82mod4
			DCD	Op83M0mod4
			DCD	Op84X1mod4
			DCD	Op85M0mod4
			DCD	Op86X1mod4
			DCD	Op87M0mod4
			DCD	Op88X1mod4
			DCD	Op89M0mod4
			DCD	Op8AM0mod4
			DCD	Op8Bmod4
			DCD	Op8CX1mod4
			DCD	Op8DM0mod4
			DCD	Op8EX1mod4
			DCD	Op8FM0mod4
			DCD	Op90mod4
			DCD	Op91M0mod4
			DCD	Op92M0mod4
			DCD	Op93M0mod4
			DCD	Op94X1mod4
			DCD	Op95M0mod4
			DCD	Op96X1mod4
			DCD	Op97M0mod4
			DCD	Op98M0mod4
			DCD	Op99M0mod4
			DCD	Op9Amod4
			DCD	Op9BX1mod4
			DCD	Op9CM0mod4
			DCD	Op9DM0mod4
			DCD	Op9EM0mod4
			DCD	Op9FM0mod4
			DCD	OpA0X1mod4
			DCD	OpA1M0mod4
			DCD	OpA2X1mod4
			DCD	OpA3M0mod4
			DCD	OpA4X1mod4
			DCD	OpA5M0mod4
			DCD	OpA6X1mod4
			DCD	OpA7M0mod4
			DCD	OpA8X1mod4
			DCD	OpA9M0mod4
			DCD	OpAAX1mod4
			DCD	OpABmod4
			DCD	OpACX1mod4
			DCD	OpADM0mod4
			DCD	OpAEX1mod4
			DCD	OpAFM0mod4
			DCD	OpB0mod4
			DCD	OpB1M0mod4
			DCD	OpB2M0mod4
			DCD	OpB3M0mod4
			DCD	OpB4X1mod4
			DCD	OpB5M0mod4
			DCD	OpB6X1mod4
			DCD	OpB7M0mod4
			DCD	OpB8mod4
			DCD	OpB9M0mod4
			DCD	OpBAX1mod4
			DCD	OpBBX1mod4
			DCD	OpBCX1mod4
			DCD	OpBDM0mod4
			DCD	OpBEX1mod4
			DCD	OpBFM0mod4
			DCD	OpC0X1mod4
			DCD	OpC1M0mod4
			DCD	OpC2mod4
			DCD	OpC3M0mod4
			DCD	OpC4X1mod4
			DCD	OpC5M0mod4
			DCD	OpC6M0mod4
			DCD	OpC7M0mod4
			DCD	OpC8X1mod4
			DCD	OpC9M0mod4
			DCD	OpCAX1mod4
			DCD	OpCBmod4
			DCD	OpCCX1mod4
			DCD	OpCDM0mod4
			DCD	OpCEM0mod4
			DCD	OpCFM0mod4
			DCD	OpD0mod4
			DCD	OpD1M0mod4
			DCD	OpD2M0mod4
			DCD	OpD3M0mod4
			DCD	OpD4mod4
			DCD	OpD5M0mod4
			DCD	OpD6M0mod4
			DCD	OpD7M0mod4
			DCD	OpD8mod4
			DCD	OpD9M0mod4
			DCD	OpDAX1mod4
			DCD	OpDBmod4
			DCD	OpDCmod4
			DCD	OpDDM0mod4
			DCD	OpDEM0mod4
			DCD	OpDFM0mod4
			DCD	OpE0X1mod4
			DCD	OpE1M0mod4
			DCD	OpE2mod4
			DCD	OpE3M0mod4
			DCD	OpE4X1mod4
			DCD	OpE5M0mod4
			DCD	OpE6M0mod4
			DCD	OpE7M0mod4
			DCD	OpE8X1mod4
			DCD	OpE9M0mod4
			DCD	OpEAmod4
			DCD	OpEBmod4
			DCD	OpECX1mod4
			DCD	OpEDM0mod4
			DCD	OpEEM0mod4
			DCD	OpEFM0mod4
			DCD	OpF0mod4
			DCD	OpF1M0mod4
			DCD	OpF2M0mod4
			DCD	OpF3M0mod4
			DCD	OpF4mod4
			DCD	OpF5M0mod4
			DCD	OpF6M0mod4
			DCD	OpF7M0mod4
			DCD	OpF8mod4
			DCD	OpF9M0mod4
			DCD	OpFAX1mod4
			DCD	OpFBmod4
			DCD	OpFCmod4
			DCD	OpFDM0mod4
			DCD	OpFEM0mod4
			DCD	OpFFM0mod4
Op00mod4
lbl00mod4		Op00
			B	nextinstructionmod4
Op01M0mod4
lbl01mod4a		DirectIndexedIndirect
lbl01mod4b		ORA16
			B	nextinstructionmod4
Op02mod4
lbl02mod4		Op02
			B	nextinstructionmod4
Op03M0mod4
lbl03mod4a		StackasmRelative
lbl03mod4b		ORA16
			B	nextinstructionmod4
Op04M0mod4
lbl04mod4a		Direct
lbl04mod4b		TSB16
			B	nextinstructionmod4
Op05M0mod4
lbl05mod4a		Direct
lbl05mod4b		ORA16
			B	nextinstructionmod4
Op06M0mod4
lbl06mod4a		Direct
lbl06mod4b		ASL16
			B	nextinstructionmod4
Op07M0mod4
lbl07mod4a		DirectIndirectLong
lbl07mod4b		ORA16
			B	nextinstructionmod4
Op08mod4
lbl08mod4		Op08
			B	nextinstructionmod4
Op09M0mod4
lbl09mod4		Op09M0
			B	nextinstructionmod4
Op0AM0mod4
lbl0Amod4a		A_ASL16
			B	nextinstructionmod4
Op0Bmod4
lbl0Bmod4		Op0B
			B	nextinstructionmod4
Op0CM0mod4
lbl0Cmod4a		Absolute
lbl0Cmod4b		TSB16
			B	nextinstructionmod4
Op0DM0mod4
lbl0Dmod4a		Absolute
lbl0Dmod4b		ORA16
			B	nextinstructionmod4
Op0EM0mod4
lbl0Emod4a		Absolute
lbl0Emod4b		ASL16
			B	nextinstructionmod4
Op0FM0mod4
lbl0Fmod4a		AbsoluteLong
lbl0Fmod4b		ORA16
			B	nextinstructionmod4
Op10mod4
lbl10mod4		Op10
			B	nextinstructionmod4
Op11M0mod4
lbl11mod4a		DirectIndirectIndexed
lbl11mod4b		ORA16
			B	nextinstructionmod4
Op12M0mod4
lbl12mod4a		DirectIndirect
lbl12mod4b		ORA16
			B	nextinstructionmod4
Op13M0mod4
lbl13mod4a		StackasmRelativeIndirectIndexed
lbl13mod4b		ORA16
			B	nextinstructionmod4
Op14M0mod4
lbl14mod4a		Direct
lbl14mod4b		TRB16
			B	nextinstructionmod4
Op15M0mod4
lbl15mod4a		DirectIndexedX
lbl15mod4b		ORA16
			B	nextinstructionmod4
Op16M0mod4
lbl16mod4a		DirectIndexedX
lbl16mod4b		ASL16
			B	nextinstructionmod4
Op17M0mod4
lbl17mod4a		DirectIndirectIndexedLong
lbl17mod4b		ORA16
			B	nextinstructionmod4
Op18mod4
lbl18mod4		Op18
			B	nextinstructionmod4
Op19M0mod4
lbl19mod4a		AbsoluteIndexedY
lbl19mod4b		ORA16
			B	nextinstructionmod4
Op1AM0mod4
lbl1Amod4a		A_INC16
			B	nextinstructionmod4
Op1Bmod4
lbl1Bmod4		Op1B
			B	nextinstructionmod4
Op1CM0mod4
lbl1Cmod4a		Absolute
lbl1Cmod4b		TRB16
			B	nextinstructionmod4
Op1DM0mod4
lbl1Dmod4a		AbsoluteIndexedX
lbl1Dmod4b		ORA16
			B	nextinstructionmod4
Op1EM0mod4
lbl1Emod4a		AbsoluteIndexedX
lbl1Emod4b		ASL16
			B	nextinstructionmod4
Op1FM0mod4
lbl1Fmod4a		AbsoluteLongIndexedX
lbl1Fmod4b		ORA16
			B	nextinstructionmod4
Op20mod4
lbl20mod4		Op20
			B	nextinstructionmod4
Op21M0mod4
lbl21mod4a		DirectIndexedIndirect
lbl21mod4b		AND16
			B	nextinstructionmod4
Op22mod4
lbl22mod4		Op22
			B	nextinstructionmod4
Op23M0mod4
lbl23mod4a		StackasmRelative
lbl23mod4b		AND16
			B	nextinstructionmod4
Op24M0mod4
lbl24mod4a		Direct
lbl24mod4b		BIT16
			B	nextinstructionmod4
Op25M0mod4
lbl25mod4a		Direct
lbl25mod4b		AND16
			B	nextinstructionmod4
Op26M0mod4
lbl26mod4a		Direct
lbl26mod4b		ROL16
			B	nextinstructionmod4
Op27M0mod4
lbl27mod4a		DirectIndirectLong
lbl27mod4b		AND16
			B	nextinstructionmod4
Op28mod4
lbl28mod4		Op28
			B	nextinstructionmod4
Op29M0mod4
lbl29mod4		Op29M0
			B	nextinstructionmod4
Op2AM0mod4
lbl2Amod4a		A_ROL16
			B	nextinstructionmod4
Op2Bmod4
lbl2Bmod4		Op2B
			B	nextinstructionmod4
Op2CM0mod4
lbl2Cmod4a		Absolute
lbl2Cmod4b		BIT16
			B	nextinstructionmod4
Op2DM0mod4
lbl2Dmod4a		Absolute
lbl2Dmod4b		AND16
			B	nextinstructionmod4
Op2EM0mod4
lbl2Emod4a		Absolute
lbl2Emod4b		ROL16
			B	nextinstructionmod4
Op2FM0mod4
lbl2Fmod4a		AbsoluteLong
lbl2Fmod4b		AND16
			B	nextinstructionmod4
Op30mod4
lbl30mod4		Op30
			B	nextinstructionmod4
Op31M0mod4
lbl31mod4a		DirectIndirectIndexed
lbl31mod4b		AND16
			B	nextinstructionmod4
Op32M0mod4
lbl32mod4a		DirectIndirect
lbl32mod4b		AND16
			B	nextinstructionmod4
Op33M0mod4
lbl33mod4a		StackasmRelativeIndirectIndexed
lbl33mod4b		AND16
			B	nextinstructionmod4
Op34M0mod4
lbl34mod4a		DirectIndexedX
lbl34mod4b		BIT16
			B	nextinstructionmod4
Op35M0mod4
lbl35mod4a		DirectIndexedX
lbl35mod4b		AND16
			B	nextinstructionmod4
Op36M0mod4
lbl36mod4a		DirectIndexedX
lbl36mod4b		ROL16
			B	nextinstructionmod4
Op37M0mod4
lbl37mod4a		DirectIndirectIndexedLong
lbl37mod4b		AND16
			B	nextinstructionmod4
Op38mod4
lbl38mod4		Op38
			B	nextinstructionmod4
Op39M0mod4
lbl39mod4a		AbsoluteIndexedY
lbl39mod4b		AND16
			B	nextinstructionmod4
Op3AM0mod4
lbl3Amod4a		A_DEC16
			B	nextinstructionmod4
Op3Bmod4
lbl3Bmod4		Op3B
			B	nextinstructionmod4
Op3CM0mod4
lbl3Cmod4a		AbsoluteIndexedX
lbl3Cmod4b		BIT16
			B	nextinstructionmod4
Op3DM0mod4
lbl3Dmod4a		AbsoluteIndexedX
lbl3Dmod4b		AND16
			B	nextinstructionmod4
Op3EM0mod4
lbl3Emod4a		AbsoluteIndexedX
lbl3Emod4b		ROL16
			B	nextinstructionmod4
Op3FM0mod4
lbl3Fmod4a		AbsoluteLongIndexedX
lbl3Fmod4b		AND16
			B	nextinstructionmod4
Op40mod4
lbl40mod4		Op40
			B	nextinstructionmod4
Op41M0mod4
lbl41mod4a		DirectIndexedIndirect
lbl41mod4b		EOR16
			B	nextinstructionmod4
Op42mod4
lbl42mod4a
			B	nextinstructionmod4
Op43M0mod4
lbl43mod4a		StackasmRelative
lbl43mod4b		EOR16
			B	nextinstructionmod4
Op44X1mod4
lbl44mod4		Op44X1
			B	nextinstructionmod4
Op45M0mod4
lbl45mod4a		Direct
lbl45mod4b		EOR16
			B	nextinstructionmod4
Op46M0mod4
lbl46mod4a		Direct
lbl46mod4b		LSR16
			B	nextinstructionmod4
Op47M0mod4
lbl47mod4a		DirectIndirectLong
lbl47mod4b		EOR16
			B	nextinstructionmod4
Op48M0mod4
lbl48mod4		Op48M0
			B	nextinstructionmod4
Op49M0mod4
lbl49mod4		Op49M0
			B	nextinstructionmod4
Op4AM0mod4
lbl4Amod4a		A_LSR16
			B	nextinstructionmod4
Op4Bmod4
lbl4Bmod4		Op4B
			B	nextinstructionmod4
Op4Cmod4
lbl4Cmod4a		Absolute
lbl4Cmod4b		S9xSetPCBase (ICPU.ShiftedPB + (OpAddress & 0xffff));
			B	nextinstructionmod4
Op4DM0mod4
lbl4Dmod4a		Absolute
lbl4Dmod4b		EOR16
			B	nextinstructionmod4
Op4EM0mod4
lbl4Emod4a		Absolute
lbl4Emod4b		LSR16
			B	nextinstructionmod4
Op4FM0mod4
lbl4Fmod4a		AbsoluteLong
lbl4Fmod4b		EOR16
			B	nextinstructionmod4
Op50mod4
lbl50mod4		Op50
			B	nextinstructionmod4
Op51M0mod4
lbl51mod4a		DirectIndirectIndexed
lbl51mod4b		EOR16
			B	nextinstructionmod4
Op52M0mod4
lbl52mod4a		DirectIndirect
lbl52mod4b		EOR16
			B	nextinstructionmod4
Op53M0mod4
lbl53mod4a		StackasmRelativeIndirectIndexed
lbl53mod4b		EOR16
			B	nextinstructionmod4
Op54X1mod4
lbl54mod4		Op54X1
			B	nextinstructionmod4
Op55M0mod4
lbl55mod4a		DirectIndexedX
lbl55mod4b		EOR16
			B	nextinstructionmod4
Op56M0mod4
lbl56mod4a		DirectIndexedX
lbl56mod4b		LSR16
			B	nextinstructionmod4
Op57M0mod4
lbl57mod4a		DirectIndirectIndexedLong
lbl57mod4b		EOR16
			B	nextinstructionmod4
Op58mod4
lbl58mod4		Op58
			B	nextinstructionmod4
Op59M0mod4
lbl59mod4a		AbsoluteIndexedY
lbl59mod4b		EOR16
			B	nextinstructionmod4
Op5AX1mod4
lbl5Amod4		Op5AX1
			B	nextinstructionmod4
Op5Bmod4
lbl5Bmod4		Op5B
			B	nextinstructionmod4
Op5Cmod4
lbl5Cmod4		Op5C
			B	nextinstructionmod4
Op5DM0mod4
lbl5Dmod4a		AbsoluteIndexedX
lbl5Dmod4b		EOR16
			B	nextinstructionmod4
Op5EM0mod4
lbl5Emod4a		AbsoluteIndexedX
lbl5Emod4b		LSR16
			B	nextinstructionmod4
Op5FM0mod4
lbl5Fmod4a		AbsoluteLongIndexedX
lbl5Fmod4b		EOR16
			B	nextinstructionmod4
Op60mod4
lbl60mod4		Op60
			B	nextinstructionmod4
Op61M0mod4
lbl61mod4a		DirectIndexedIndirect
lbl61mod4b		ADC16
			B	nextinstructionmod4
Op62mod4
lbl62mod4a		asmRelativeLong
lbl62mod4b		PushW (OpAddress);
			B	nextinstructionmod4
Op63M0mod4
lbl63mod4a		StackasmRelative
lbl63mod4b		ADC16
			B	nextinstructionmod4
Op64M0mod4
lbl64mod4a		Direct
lbl64mod4b		STZ16
			B	nextinstructionmod4
Op65M0mod4
lbl65mod4a		Direct
lbl65mod4b		ADC16
			B	nextinstructionmod4
Op66M0mod4
lbl66mod4a		Direct
lbl66mod4b		ROR16
			B	nextinstructionmod4
Op67M0mod4
lbl67mod4a		DirectIndirectLong
lbl67mod4b		ADC16
			B	nextinstructionmod4
Op68M0mod4
lbl68mod4		Op68M0
			B	nextinstructionmod4
Op69M0mod4
lbl69mod4a		Immediate16
lbl69mod4b		ADC16
			B	nextinstructionmod4
Op6AM0mod4
lbl6Amod4a		A_ROR16
			B	nextinstructionmod4
Op6Bmod4
lbl6Bmod4		Op6B
			B	nextinstructionmod4
Op6Cmod4
lbl6Cmod4a		AbsoluteIndirect
lbl6Cmod4b		S9xSetPCBase (ICPU.ShiftedPB + (OpAddress & 0xffff));
			B	nextinstructionmod4
Op6DM0mod4
lbl6Dmod4a		Absolute
lbl6Dmod4b		ADC16
			B	nextinstructionmod4
Op6EM0mod4
lbl6Emod4a		Absolute
lbl6Emod4b		ROR16
			B	nextinstructionmod4
Op6FM0mod4
lbl6Fmod4a		AbsoluteLong
lbl6Fmod4b		ADC16
			B	nextinstructionmod4
Op70mod4
lbl70mod4		Op70
			B	nextinstructionmod4
Op71M0mod4
lbl71mod4a		DirectIndirectIndexed
lbl71mod4b		ADC16
			B	nextinstructionmod4
Op72M0mod4
lbl72mod4a		DirectIndirect
lbl72mod4b		ADC16
			B	nextinstructionmod4
Op73M0mod4
lbl73mod4a		StackasmRelativeIndirectIndexed
lbl73mod4b		ADC16
			B	nextinstructionmod4
Op74M0mod4
lbl74mod4a		DirectIndexedX
lbl74mod4b		STZ16
			B	nextinstructionmod4
Op75M0mod4
lbl75mod4a		DirectIndexedX
lbl75mod4b		ADC16
			B	nextinstructionmod4
Op76M0mod4
lbl76mod4a		DirectIndexedX
lbl76mod4b		ROR16
			B	nextinstructionmod4
Op77M0mod4
lbl77mod4a		DirectIndirectIndexedLong
lbl77mod4b		ADC16
			B	nextinstructionmod4
Op78mod4
lbl78mod4		Op78
			B	nextinstructionmod4
Op79M0mod4
lbl79mod4a		AbsoluteIndexedY
lbl79mod4b		ADC16
			B	nextinstructionmod4
Op7AX1mod4
lbl7Amod4		Op7AX1
			B	nextinstructionmod4
Op7Bmod4
lbl7Bmod4		Op7B
			B	nextinstructionmod4
Op7Cmod4
lbl7Cmod4		Op7C
			B	nextinstructionmod4
Op7DM0mod4
lbl7Dmod4a		AbsoluteIndexedX
lbl7Dmod4b		ADC16
			B	nextinstructionmod4
Op7EM0mod4
lbl7Emod4a		AbsoluteIndexedX
lbl7Emod4b		ROR16
			B	nextinstructionmod4
Op7FM0mod4
lbl7Fmod4a		AbsoluteLongIndexedX
lbl7Fmod4b		ADC16
			B	nextinstructionmod4
Op80mod4
lbl80mod4		Op80
			B	nextinstructionmod4
Op81M0mod4
lbl81mod4		Op81M0
			B	nextinstructionmod4
Op82mod4
lbl82mod4a		asmRelativeLong
lbl82mod4b		S9xSetPCBase (ICPU.ShiftedPB + OpAddress);
			B	nextinstructionmod4
Op83M0mod4
lbl83mod4a		StackasmRelative
lbl83mod4b		STA16
			B	nextinstructionmod4
Op84X1mod4
lbl84mod4a		Direct
lbl84mod4b		STY8
			B	nextinstructionmod4
Op85M0mod4
lbl85mod4a		Direct
lbl85mod4b		STA16
			B	nextinstructionmod4
Op86X1mod4
lbl86mod4a		Direct
lbl86mod4b		STX8
			B	nextinstructionmod4
Op87M0mod4
lbl87mod4a		DirectIndirectLong
lbl87mod4b		STA16
			B	nextinstructionmod4
Op88X1mod4
lbl88mod4		Op88X1
			B	nextinstructionmod4
Op89M0mod4
lbl89mod4		Op89M0
			B	nextinstructionmod4
Op8AM0mod4
lbl8Amod4		Op8AM0
			B	nextinstructionmod4
Op8Bmod4
lbl8Bmod4		Op8B
			B	nextinstructionmod4
Op8CX1mod4
lbl8Cmod4a		Absolute
lbl8Cmod4b		STY8
			B	nextinstructionmod4
Op8DM0mod4
lbl8Dmod4a		Absolute
lbl8Dmod4b		STA16
			B	nextinstructionmod4
Op8EX1mod4
lbl8Emod4a		Absolute
lbl8Emod4b		STX8
			B	nextinstructionmod4
Op8FM0mod4
lbl8Fmod4a		AbsoluteLong
lbl8Fmod4b		STA16
			B	nextinstructionmod4
Op90mod4
lbl90mod4		Op90
			B	nextinstructionmod4
Op91M0mod4
lbl91mod4a		DirectIndirectIndexed
lbl91mod4b		STA16
			B	nextinstructionmod4
Op92M0mod4
lbl92mod4a		DirectIndirect
lbl92mod4b		STA16
			B	nextinstructionmod4
Op93M0mod4
lbl93mod4a		StackasmRelativeIndirectIndexed
lbl93mod4b		STA16
			B	nextinstructionmod4
Op94X1mod4
lbl94mod4a		DirectIndexedX
lbl94mod4b		STY8
			B	nextinstructionmod4
Op95M0mod4
lbl95mod4a		DirectIndexedX
lbl95mod4b		STA16
			B	nextinstructionmod4
Op96X1mod4
lbl96mod4a		DirectIndexedY
lbl96mod4b		STX8
			B	nextinstructionmod4
Op97M0mod4
lbl97mod4a		DirectIndirectIndexedLong
lbl97mod4b		STA16
			B	nextinstructionmod4
Op98M0mod4
lbl98mod4		Op98M0
			B	nextinstructionmod4
Op99M0mod4
lbl99mod4a		AbsoluteIndexedY
lbl99mod4b		STA16
			B	nextinstructionmod4
Op9Amod4
lbl9Amod4		Op9A
			B	nextinstructionmod4
Op9BX1mod4
lbl9Bmod4		Op9BX1
			B	nextinstructionmod4
Op9CM0mod4
lbl9Cmod4a		Absolute
lbl9Cmod4b		STZ16
			B	nextinstructionmod4
Op9DM0mod4
lbl9Dmod4a		AbsoluteIndexedX
lbl9Dmod4b		STA16
			B	nextinstructionmod4
Op9EM0mod4
lbl9Emod4a		AbsoluteIndexedX
lbl9Emod4b		STZ16
			B	nextinstructionmod4
Op9FM0mod4
lbl9Fmod4a		AbsoluteLongIndexedX
lbl9Fmod4b		STA16
			B	nextinstructionmod4
OpA0X1mod4
lblA0mod4		OpA0X1
			B	nextinstructionmod4
OpA1M0mod4
lblA1mod4a		DirectIndexedIndirect
lblA1mod4b		LDA16
			B	nextinstructionmod4
OpA2X1mod4
lblA2mod4		OpA2X1
			B	nextinstructionmod4
OpA3M0mod4
lblA3mod4a		StackasmRelative
lblA3mod4b		LDA16
			B	nextinstructionmod4
OpA4X1mod4
lblA4mod4a		Direct
lblA4mod4b		LDY8
			B	nextinstructionmod4
OpA5M0mod4
lblA5mod4a		Direct
lblA5mod4b		LDA16
			B	nextinstructionmod4
OpA6X1mod4
lblA6mod4a		Direct
lblA6mod4b		LDX8
			B	nextinstructionmod4
OpA7M0mod4
lblA7mod4a		DirectIndirectLong
lblA7mod4b		LDA16
			B	nextinstructionmod4
OpA8X1mod4
lblA8mod4		OpA8X1
			B	nextinstructionmod4
OpA9M0mod4
lblA9mod4		OpA9M0
			B	nextinstructionmod4
OpAAX1mod4
lblAAmod4		OpAAX1
			B	nextinstructionmod4
OpABmod4
lblABmod4		OpAB
			B	nextinstructionmod4
OpACX1mod4
lblACmod4a		Absolute
lblACmod4b		LDY8
			B	nextinstructionmod4
OpADM0mod4
lblADmod4a		Absolute
lblADmod4b		LDA16
			B	nextinstructionmod4
OpAEX1mod4
lblAEmod4a		Absolute
lblAEmod4b		LDX8
			B	nextinstructionmod4
OpAFM0mod4
lblAFmod4a		AbsoluteLong
lblAFmod4b		LDA16
			B	nextinstructionmod4
OpB0mod4
lblB0mod4		OpB0
			B	nextinstructionmod4
OpB1M0mod4
lblB1mod4a		DirectIndirectIndexed
lblB1mod4b		LDA16
			B	nextinstructionmod4
OpB2M0mod4
lblB2mod4a		DirectIndirect
lblB2mod4b		LDA16
			B	nextinstructionmod4
OpB3M0mod4
lblB3mod4a		StackasmRelativeIndirectIndexed
lblB3mod4b		LDA16
			B	nextinstructionmod4
OpB4X1mod4
lblB4mod4a		DirectIndexedX
lblB4mod4b		LDY8
			B	nextinstructionmod4
OpB5M0mod4
lblB5mod4a		DirectIndexedX
lblB5mod4b		LDA16
			B	nextinstructionmod4
OpB6X1mod4
lblB6mod4a		DirectIndexedY
lblB6mod4b		LDX8
			B	nextinstructionmod4
OpB7M0mod4
lblB7mod4a		DirectIndirectIndexedLong
lblB7mod4b		LDA16
			B	nextinstructionmod4
OpB8mod4
lblB8mod4		OpB8
			B	nextinstructionmod4
OpB9M0mod4
lblB9mod4a		AbsoluteIndexedY
lblB9mod4b		LDA16
			B	nextinstructionmod4
OpBAX1mod4
lblBAmod4		OpBAX1
			B	nextinstructionmod4
OpBBX1mod4
lblBBmod4		OpBBX1
			B	nextinstructionmod4
OpBCX1mod4
lblBCmod4a		AbsoluteIndexedX
lblBCmod4b		LDY8
			B	nextinstructionmod4
OpBDM0mod4
lblBDmod4a		AbsoluteIndexedX
lblBDmod4b		LDA16
			B	nextinstructionmod4
OpBEX1mod4
lblBEmod4a		AbsoluteIndexedY
lblBEmod4b		LDX8
			B	nextinstructionmod4
OpBFM0mod4
lblBFmod4a		AbsoluteLongIndexedX
lblBFmod4b		LDA16
			B	nextinstructionmod4
OpC0X1mod4
lblC0mod4		OpC0X1
			B	nextinstructionmod4
OpC1M0mod4
lblC1mod4a		DirectIndexedIndirect
lblC1mod4b		CMP16
			B	nextinstructionmod4
OpC2mod4
lblC2mod4		OpC2
			B	nextinstructionmod4
OpC3M0mod4
lblC3mod4a		StackasmRelative
lblC3mod4b		CMP16
			B	nextinstructionmod4
OpC4X1mod4
lblC4mod4a		Direct
lblC4mod4b		CMY8
			B	nextinstructionmod4
OpC5M0mod4
lblC5mod4a		Direct
lblC5mod4b		CMP16
			B	nextinstructionmod4
OpC6M0mod4
lblC6mod4a		Direct
lblC6mod4b		DEC16
			B	nextinstructionmod4
OpC7M0mod4
lblC7mod4a		DirectIndirectLong
lblC7mod4b		CMP16
			B	nextinstructionmod4
OpC8X1mod4
lblC8mod4		OpC8X1
			B	nextinstructionmod4
OpC9M0mod4
lblC9mod4		OpC9M0
			B	nextinstructionmod4
OpCAX1mod4
lblCAmod4		OpCAX1
			B	nextinstructionmod4
OpCBmod4
lblCBmod4		OpCB
			B	nextinstructionmod4
OpCCX1mod4
lblCCmod4a		Absolute
lblCCmod4b		CMY8
			B	nextinstructionmod4
OpCDM0mod4
lblCDmod4a		Absolute
lblCDmod4b		CMP16
			B	nextinstructionmod4
OpCEM0mod4
lblCEmod4a		Absolute
lblCEmod4b		DEC16
			B	nextinstructionmod4
OpCFM0mod4
lblCFmod4a		AbsoluteLong
lblCFmod4b		CMP16
			B	nextinstructionmod4
OpD0mod4
lblD0mod4		OpD0
			B	nextinstructionmod4
OpD1M0mod4
lblD1mod4a		DirectIndirectIndexed
lblD1mod4b		CMP16
			B	nextinstructionmod4
OpD2M0mod4
lblD2mod4a		DirectIndirect
lblD2mod4b		CMP16
			B	nextinstructionmod4
OpD3M0mod4
lblD3mod4a		StackasmRelativeIndirectIndexed
lblD3mod4b		CMP16
			B	nextinstructionmod4
OpD4mod4
lblD4mod4a		DirectIndirect
lblD4mod4b		PushW (OpAddress);
			B	nextinstructionmod4
OpD5M0mod4
lblD5mod4a		DirectIndexedX
lblD5mod4b		CMP16
			B	nextinstructionmod4
OpD6M0mod4
lblD6mod4a		DirectIndexedX
lblD6mod4b		DEC16
			B	nextinstructionmod4
OpD7M0mod4
lblD7mod4a		DirectIndirectIndexedLong
lblD7mod4b		CMP16
			B	nextinstructionmod4
OpD8mod4
lblD8mod4		OpD8
			B	nextinstructionmod4
OpD9M0mod4
lblD9mod4a		AbsoluteIndexedY
lblD9mod4b		CMP16
			B	nextinstructionmod4
OpDAX1mod4
lblDAmod4		OpDAX1
			B	nextinstructionmod4
OpDBmod4
lblDBmod4a		CPU.PC--;
lblDBmod4b		CPU.Flags |= DEBUG_MODE_FLAG;
			B	nextinstructionmod4
OpDCmod4
lblDCmod4		OpDC
			B	nextinstructionmod4
OpDDM0mod4
lblDDmod4a		AbsoluteIndexedX
lblDDmod4b		CMP16
			B	nextinstructionmod4
OpDEM0mod4
lblDEmod4a		AbsoluteIndexedX
lblDEmod4b		DEC16
			B	nextinstructionmod4
OpDFM0mod4
lblDFmod4a		AbsoluteLongIndexedX
lblDFmod4b		CMP16
			B	nextinstructionmod4
OpE0X1mod4
lblE0mod4		OpE0X1
			B	nextinstructionmod4
OpE1M0mod4
lblE1mod4a		DirectIndexedIndirect
lblE1mod4b		SBC16
			B	nextinstructionmod4
OpE2mod4
lblE2mod4		OpE2
			B	nextinstructionmod4
OpE3M0mod4
lblE3mod4a		StackasmRelative
lblE3mod4b		SBC16
			B	nextinstructionmod4
OpE4X1mod4
lblE4mod4a		Direct
lblE4mod4b		CMX8
			B	nextinstructionmod4
OpE5M0mod4
lblE5mod4a		Direct
lblE5mod4b		SBC16
			B	nextinstructionmod4
OpE6M0mod4
lblE6mod4a		Direct
lblE6mod4b		INC16
			B	nextinstructionmod4
OpE7M0mod4
lblE7mod4a		DirectIndirectLong
lblE7mod4b		SBC16
			B	nextinstructionmod4
OpE8X1mod4
lblE8mod4		OpE8X1
			B	nextinstructionmod4
OpE9M0mod4
lblE9mod4a		Immediate16
lblE9mod4b		SBC16
			B	nextinstructionmod4
OpEAmod4
lblEAmod4		OpEA
			B	nextinstructionmod4
OpEBmod4
lblEBmod4		OpEB
			B	nextinstructionmod4
OpECX1mod4
lblECmod4a		Absolute
lblECmod4b		CMX8
			B	nextinstructionmod4
OpEDM0mod4
lblEDmod4a		Absolute
lblEDmod4b		SBC16
			B	nextinstructionmod4
OpEEM0mod4
lblEEmod4a		Absolute
lblEEmod4b		INC16
			B	nextinstructionmod4
OpEFM0mod4
lblEFmod4a		AbsoluteLong
lblEFmod4b		SBC16
			B	nextinstructionmod4
OpF0mod4
lblF0mod4		OpF0
			B	nextinstructionmod4
OpF1M0mod4
lblF1mod4a		DirectIndirectIndexed
lblF1mod4b		SBC16
			B	nextinstructionmod4
OpF2M0mod4
lblF2mod4a		DirectIndirect
lblF2mod4b		SBC16
			B	nextinstructionmod4
OpF3M0mod4
lblF3mod4a		StackasmRelativeIndirectIndexed
lblF3mod4b		SBC16
			B	nextinstructionmod4
OpF4mod4
lblF4mod4a		Absolute
lblF4mod4b		PushW (OpAddress);
			B	nextinstructionmod4
OpF5M0mod4
lblF5mod4a		DirectIndexedX
lblF5mod4b		SBC16
			B	nextinstructionmod4
OpF6M0mod4
lblF6mod4a		DirectIndexedX
lblF6mod4b		INC16
			B	nextinstructionmod4
OpF7M0mod4
lblF7mod4a		DirectIndirectIndexedLong
lblF7mod4b		SBC16
			B	nextinstructionmod4
OpF8mod4
lblF8mod4		OpF8
			B	nextinstructionmod4
OpF9M0mod4
lblF9mod4a		AbsoluteIndexedY
lblF9mod4b		SBC16
			B	nextinstructionmod4
OpFAX1mod4
lblFAmod4		OpFAX1
			B	nextinstructionmod4
OpFBmod4
lblFBmod4		OpFB
			B	nextinstructionmod4
OpFCmod4
lblFCmod4		OpFC
			B	nextinstructionmod4
OpFDM0mod4
lblFDmod4a		AbsoluteIndexedX
lblFDmod4b		SBC16
			B	nextinstructionmod4
OpFEM0mod4
lblFEmod4a		AbsoluteIndexedX
lblFEmod4b		INC16
			B	nextinstructionmod4
OpFFM0mod4
lblFFmod4a		AbsoluteLongIndexedX
lblFFmod4b		SBC16
			B	nextinstructionmod4

			END