#ifndef _gfxlib_h_included
#define _gfxlib_h_included

//

#define MAGIC_VCLK 0x98aeb8
#define DMA0_INT	0
#define DMA1_INT	1
#define DMA2_INT	2
#define DMA3_INT	3

#define FBUF_SYNC1	0x1
#define FBUF_SYNC2	0x3
#define FBUF_NONE		0

#define BPPMODE1	8
#define BPPMODE2	9
#define BPPMODE4	10
#define BPPMODE8	11
#define BPPMODE16	12

#define SINGLEBUFFER 1
#define DOUBLEBUFFER 2
#define TRIPLEBUFFER 3

#define CACHE_NCNW	0xFF2	// - to disable cache and writeback
#define CACHE_CNW	0xFFA	// - to enable cache and disable writeback
#define CACHE_CW	0xFFE	// - to enable cache and writeback


//

struct LCDinfo {
	int x;		// shorts - visible screen
	int y;		// pixels - visible screen
	int offx;	// shorts - offsize screen
	int offy;	// pixels - offsize screen
	int posx;	// shorts - offset
	int posy;	// pixels - offset

	int clkval;	//
	int bppmode;	// 2,4,8,16
	int paladden;	//
	int addval;		// index
	long vclk;

	unsigned char *base;
	int nbufs;

	// these will be setup later..

	unsigned char *bufs[3];	// output.. buffer start positions..
	int currentBuf;			// currently displayed buffer..
	long basel;
	long bufsize;

	volatile long *disrc;
	volatile long *didst;
	volatile long *dcon;
	volatile long *dstat;
	volatile long *dmasktrig;

	void (*dmaintr)(void);
};





//

void setupLCDMode( struct LCDinfo *, int );
unsigned char *swapBuffer( struct LCDinfo *, int );
void doubleBufferSwap( struct LCDinfo *nfo, int w );
unsigned char *tripleBufferDMA( struct LCDinfo *, int );
int initBufferDMA( struct LCDinfo *, int, void (*)(void) );
void setup8bppMode( struct LCDinfo *, unsigned char *, int );
void setup16bppMode( struct LCDinfo *, unsigned char *, int );

void rgb8torgb5s( unsigned short *, unsigned char *, int ); 
void rgb8torgb5l( unsigned long *,  unsigned char *, int );
void waitLine( int );
int getClkval( long, long );
double frameRate( double hclk );


#endif
