//
// (c) 2003 by Jouni 'Mr.Spiv' Korhonen
//

//#include <stdlib.h>
#ifndef NULL
#define NULL 0
#endif

#include "bioslib.h"
#include "gfxlib.h"
#include "gp32.h"

//
//
//

/*static long localGetHCLK() {
	long hclk;

	asm volatile(""
		"stmdb	sp!,{lr}	\n"
		"mov	r0,#4		\n"
		"swi	#0x0b		\n"
		"ldr	r0,[r0,#4]	\n"
		"mov	%0,r0		\n"
		"ldmia	sp!,{lr}"
		: "=r"(hclk) 
		:
		: "r0","r1");

	return hclk;
}*/

//
//
//

/*void localInstallIRQ( int num, void (*irq)(void) ) {
	asm volatile(""
		"stmdb	sp!,{lr}	\n"
		"swi	#0x09			\n"
		"ldmia	sp!,{lr}"
		: 
		:
		: "r0","r1");
}*/



//
//
//

void rgb8torgb5s( unsigned short *dst, unsigned char *src, int n ) {
	unsigned short x;

	while (n--) {
		x  = ((*src++) & 0xf8) << 8;
		x |= ((*src++) & 0xf8) << 3;
		x |= ((*src++) & 0xf8) >> 2;
		*dst++ = x;
	}
}


//
//
//

void rgb8torgb5l( unsigned long *dst,  unsigned char *src, int n ) {
	unsigned long x;

	while (n--) {
		x  = ((*src++) & 0xf8) << 8;
		x |= ((*src++) & 0xf8) << 3;
		x |= ((*src++) & 0xf8) >> 2;
		*dst++ = x;
	}
}

//
//
//

void waitLine( int line ) {
	while ((rLCDCON1 >> 18) != line);
}


//
//
//




int getClkval( long hclk, long vclk ) {

	int clkval = 0;

	if (vclk == 0) { vclk = MAGIC_VCLK; }
	if (hclk == 0) { hclk = getHCLK();/*localGetHCLK();*/ 	}


	while (hclk >= vclk) {
		clkval++;
		hclk -= vclk;
	}
        
	vclk >>= 2;
	if (hclk < vclk) { clkval--; }


	return clkval;
}

//
//
//

double frameRate( double hclk ) {

//        return 1 / (((VSPW+1)+(VBPD+1)+(LINEVAL+1)+(VFPD+1))*
//                                ((HSPW+1)+(HBPD+1)+(HOZVAL+1) +(HFPD+1))*
//                                (2*(clkval+1)/hclk));


	return 0;
}


//
//
//

void setupLCDMode( struct LCDinfo *nfo, int lcdon ) {
	LCDCON1 lcd1;
	LCDCON2 lcd2;
	LCDCON3 lcd3;
	LCDCON4 lcd4;
	LCDCON5 lcd5;
	LCDSADDR3 lcds3;
	int n;
	long ptr;

	// init..
	
	lcd1.all = 0;
	lcd2.all = 0;
	lcd3.all = 0;
	lcd4.all = 0;
	lcd5.all = 0;

	// build LCDCON1

	lcd1.reg.CLKVAL  = nfo->clkval ? nfo->clkval : getClkval(0,nfo->vclk);
	lcd1.reg.MMODE   = 0;
	lcd1.reg.PNRMODE = 3;
	lcd1.reg.BPPMODE = nfo->bppmode;
	lcd1.reg.ENVID   = lcdon ? 1 : 0;
	//lcd1.reg.ENVID   = 1;

	// build LCDCON2

	lcd2.reg.VBPD    = 1;
	lcd2.reg.LINEVAL = 319;	// it's fixed.. I know :(
	lcd2.reg.VFPD    = 2;
	lcd2.reg.VSPW    = 1;

	// build LCDCON3

	lcd3.reg.HBPD    = 2;
	lcd3.reg.HOZVAL  = 239;	// it's fixed.. I know :(
	lcd3.reg.HFPD    = 6;

	// build LCDCON4

	lcd4.reg.PALADDEN = nfo->paladden ? 1 : 0;
	lcd4.reg.ADDVAL   = nfo->addval & 0xff;
	lcd4.reg.HSPW     = 4;

	// build LCDCON5

	lcd5.reg.INVVCLK    = 1;
	lcd5.reg.INVVLINE   = 1;
	lcd5.reg.INVVFRAME  = 1;
	lcd5.reg.INVVD      = 0;
	lcd5.reg.INVVDEN    = 0;
	lcd5.reg.INVENDLINE = 0;
	lcd5.reg.ENLEND     = 0;
	lcd5.reg.BSWP       = nfo->bppmode == BPPMODE16/*16*/ ? 0 : 1;
	lcd5.reg.HWSWP      = nfo->bppmode == BPPMODE16/*16*/ ? 1 : 0;

	// precalculate buffer addresses..

	nfo->basel = (nfo->offx+nfo->x)*nfo->y;

	n = (nfo->x + nfo->offx) * (nfo->y + nfo->offy) * 2;
	n = (n + 3) & ~3;
	nfo->bufs[0] = nfo->base;
	nfo->bufs[1] = nfo->bufs[0] + n;
	nfo->bufs[2] = nfo->bufs[1] + n;
	nfo->bufsize = n;
	nfo->currentBuf = 0;
	
	// build LCDSADDRx regs etc..

	n = (nfo->x + nfo->offx) * nfo->posy + nfo->posx;
	lcds3.reg.OFFSIZE = nfo->offx;
	lcds3.reg.PAGEWIDTH = nfo->x;
	ptr = (long)nfo->bufs[0];

	// setup

	if (rLCDCON1 & 0x01) {
		waitLine(0);
		rLCDCON1 &= ~1;
	}

	rLCDCON5 = lcd5.all;
	rLCDCON2 = lcd2.all;
	rLCDCON3 = lcd3.all;
	rLCDCON4 = lcd4.all;
	rLCDCON1 = lcd1.all;
	//rLCDCON1 |= 1;

	//waitLine(0);

	rLCDSADDR1 = (ptr >> 1) + n;
	rLCDSADDR2 = ((ptr & 0x003ffffe) >> 1) + n + nfo->basel;
	rLCDSADDR3 = lcds3.all;

	rTPAL = 0;
}


//
// returns:
//   Index of the 
//

int initBufferDMA( struct LCDinfo *nfo, int dmanum, void (*intr)(void) ) {
	int dmaint;
	long dmabase = 0;
	nfo->dmaintr = intr;


	switch (dmanum) {
	case DMA0_INT:
		dmabase = 0x14600000;
		dmaint = 17;
		break;
	case DMA1_INT:
		dmabase = 0x14600020;
		dmaint = 18;
		break;
	case DMA2_INT:
		dmabase = 0x14600040;
		dmaint = 19;
		break;
	case DMA3_INT:
		dmabase = 0x14600060;
		dmaint = 20;
		break;
	default:
		nfo->dmaintr = NULL;
		dmaint = 0;
	}

	// calculate DMA registers

	nfo->disrc = (long *)dmabase;
	nfo->didst = (long *)(dmabase + 0x04);
	nfo->dcon = (long *)(dmabase + 0x08);
	nfo->dstat = (long *)(dmabase + 0x0c);
	nfo->dmasktrig = (long *)(dmabase + 0x18);

	// setup interrupt..

	if (intr) {
		/*localInstallIRQ(dmaint,intr);*/
		installIRQ(dmaint,intr);
	}

	return 0;
}

//
// w - [in] if non 0 sync display
//
// Returns:
//   A ptr to current work buffer..
//

unsigned char *tripleBufferDMA( struct LCDinfo *nfo, int w ) {
	long ptr;
	long n;
	int i = nfo->currentBuf;

	ptr = (long)nfo->bufs[(i+1) % 3];
	n   = (nfo->x + nfo->offx) * nfo->posy + nfo->posx;

	// check if we need to sync the screen...

	if (w & 0x02) {
		waitLine(1);
	}
	if (w & 0x01) {
		waitLine(0);
	}

	// setup new buffers.. for display..

	rLCDSADDR1 = (ptr >> 1) + n;
	rLCDSADDR2 = ((ptr & 0x003ffffe) >> 1) + n + nfo->basel;

	// clear previous displayed buffer..

	n = nfo->dmaintr ? 1 : 0;
	ptr = (long)nfo->bufs[i];
	*((long *)ptr) = 0;

	*nfo->dmasktrig |= 0x04;
	*nfo->disrc = ptr;					// select system bus (AHB)+autoinc
	*nfo->didst = ptr + 4;				// select system bus (AHB)+autoinc
	*nfo->dcon = 	(0 << 30) | 		// demand mode
					(1 << 29) |			// DREQ & DACK are synched to HCLK (AHB)
					(n << 28) |			// disable DMA0 int
					(0 << 27) |			// unit transfer
					(1 << 26) |			// whole servmode
					(0x00 << 24) |		// HWSRCSEL ?? not used
					(0 << 23) |			// sw request mode
					(1 << 22) |			// auto reload off
					(0x02 << 20) |		// data size == word
					(nfo->bufsize >> 2);	// count..

	// start DMA.. and don't wait for it to finish..
	
	*nfo->dmasktrig = 0x03;

	// return new work buffer..

	nfo->currentBuf = (i+1) % 3;
	return nfo->bufs[(i+2) % 3];
}

//
//
//


//
// w - [in] if non 0 sync display
//
// Returns:
//   A ptr to current work buffer..
//

unsigned char *swapBuffer( struct LCDinfo *nfo, int w ) {
	long ptr;
	long n;
	//current buffer, the one currently shown
	int i = nfo->currentBuf;
	//next buffer, the one updated to show
	int j = nfo->currentBuf+1;
	//buffer number
	int nbuf = nfo->nbufs;
	
	//cycle buffer
	if (j==nbuf) j=0;

	// check if we need to sync the screen...		

	
	if (w & 0x02) waitLine(1);
	ARMDisableInterruptSpiv();						
	if (w & 0x01) waitLine(0);
	

	// setup new buffers.. for display..			
	//ptr = (long)nfo->bufs[(i+1) % 3];
	//ARMDisableInterruptSpiv();
	
	
	ptr = (long)nfo->bufs[j];
	n   = (nfo->x + nfo->offx) * nfo->posy + nfo->posx;
	rLCDSADDR1 = (ptr >> 1) + n;
	rLCDSADDR2 = ((ptr & 0x003ffffe) >> 1) + n + nfo->basel;	
	ARMEnableInterruptSpiv();

	//update the currently shown buffer
	nfo->currentBuf = j;
	// return new work buffer..
	j++;
	if (j==nbuf) j=0;
	return nfo->bufs[j];
}

void doubleBufferSwap( struct LCDinfo *nfo, int w ) {
	long ptr;
	long n;
	static int nextprev=1;
	int i = nfo->currentBuf;

	// check if we need to sync the screen...

	if (w & 0x02) waitLine(1);
	ARMDisableInterruptSpiv();
	if (w & 0x01) waitLine(0);
	
//	ARMDisableInterruptSpiv();
	// setup new buffers.. for display..
	if (nextprev)
		//ptr = (long)nfo->bufs[(i+2) % 3];
		ptr = (long)nfo->bufs[i];
	else
		//ptr = (long)nfo->bufs[i % 3];
		ptr = (long)nfo->bufs[i];
		
	nextprev^=1;	
	n   = (nfo->x + nfo->offx) * nfo->posy + nfo->posx;
	rLCDSADDR1 = (ptr >> 1) + n;
	rLCDSADDR2 = ((ptr & 0x003ffffe) >> 1) + n + nfo->basel;

	ARMEnableInterruptSpiv();
	// return new work buffer..
}


//
//
//

void setup8bppMode( struct LCDinfo *nfo, unsigned char *buf, int nbuf ) {
	nfo->x = 240 >> 1;
	nfo->y = 320;
	nfo->offx = 0;
	nfo->offy = 0;
	nfo->posx = 0;
	nfo->posy = 0;

	// bios calls to get hclk.. etc..
	// get proper clkval..


	nfo->clkval   = getClkval(0,0);
	nfo->bppmode  = BPPMODE8;
	nfo->paladden = 0;
	nfo->vclk     = 0;
	
	nfo->base     = buf;
	nfo->nbufs    = nbuf;
}


void setup16bppMode( struct LCDinfo *nfo, unsigned char *buf, int nbuf ) {
	nfo->x = 240;
	nfo->y = 320;
	nfo->offx = 0;
	nfo->offy = 0;
	nfo->posx = 0;
	nfo->posy = 0;

	// bios calls to get hclk.. etc..
	// get proper clkval..


	nfo->clkval   = getClkval(0,0);
	nfo->bppmode  = BPPMODE16;
	nfo->paladden = 0;
	nfo->vclk     = 0;
	
	nfo->base     = buf;
	nfo->nbufs    = nbuf;
}

