	    AREA    asm_mrspiv, CODE, READONLY

		EXPORT  getHCLK
		EXPORT	getPCLK
		EXPORT  setCPUSpeed
		EXPORT  mmuChange
		EXPORT  installIRQ
		EXPORT  removeIRQ
		EXPORT  cache_invalidate_all
		EXPORT  ARMDisableInterruptSpiv
		EXPORT  ARMEnableInterruptSpiv
		
				
;;long getHCLK(void);		
getHCLK	PROC
		stmdb	sp!,{lr}
		mov		r0,#4
		swi		0x0b
		ldr		r0,[r0,#4]
		ldmia	sp!,{lr}		
		mov		pc,lr
		ENDP
		
;;long getPCLK(void);
getPCLK PROC
		stmdb	sp!,{lr}
		mov		r0,#4
		swi		0x0b
		ldr		r0,[r0,#8]
		ldmia	sp!,{lr}
		mov		pc,lr		
		ENDP
		
;;void setCPUSpeed( long mclk, int fac, int div) ;		
setCPUSpeed PROC
		stmdb	sp!,{r0,r1,r2,lr}
		mov		r0,sp
		swi		0x0d
		add		sp,sp,#12
		ldmia	sp!,{lr}
		mov		pc,lr		
		ENDP


		
		
;;void mmuChange( unsigned char *s, unsigned char *e, int flg )
mmuChange PROC
		stmdb	sp!,{lr}
		swi		0x02
		ldmia	sp!,{lr}
		mov		pc,lr
		ENDP

;;void installIRQ( int num, void (*irq)(void) );
installIRQ PROC
		stmdb	sp!,{lr}
		swi		0x09
		ldmia	sp!,{lr}
		mov		pc,lr
		ENDP

;;void removeIRQ( int num ) 
removeIRQ PROC
		stmdb	sp!,{lr}
		swi		0x0a
		ldmia	sp!,{lr}
		mov		pc,lr
		ENDP


;;void cache_invalidate_all( void ) 
cache_invalidate_all PROC
		mcr 	p15, 0, r0, c7, c7, 0
		mov		pc,lr
		ENDP

;;void ARMDisableInterrupt( void ) 
ARMDisableInterruptSpiv PROC
		mrs		r0,CPSR
		orr		r0,r0,#192
		msr		CPSR_fsxc,r0
		mov		pc,lr
		ENDP

;;void ARMEnableInterrupt( void ) {
ARMEnableInterruptSpiv PROC
		mrs		r0,CPSR
		bic		r0,r0,#128
		msr		CPSR_fsxc,r0
		mov		pc,lr
		ENDP
		
		END