/*
  By Don Miguel
  ----------------------------
  Little John GP32
  Version 0.2
  adapted and enhanced by Yoyo  
  
  Last Update on 7th July 2003
*/

#include "port.h"


//#include "gp32\debug.h"
#include "mygraphic.h"
//#include "comi.h"

extern GPDRAWSURFACE gpDraw[2];
extern int nflip;
extern char g_string[100];



void FlipAndShow(void)
{
	//flip and show hidden surface		
	GpSurfaceFlip(&gpDraw[nflip++]);
	nflip &= 1;
}

void WaitKeyRelease(void) {
	int keydata;
	do {
		GpKeyGetEx(&keydata);
		Delay(5);
	} while (keydata);
}

void Delay(int ms) {

	unsigned int i, ticks;
	
	ticks=GpTickCountGet()+ms;
	if (ticks <= ms) return;
	while( GpTickCountGet() < ticks )
	{
		for (i = 0; i< 10; i++)
		{
		}
	};
}



//       
void DrawMessageNoWin(int x,int y,char *s, int nflip,int col)
{
	int tw,th;
	GPRECT rect;	
	rect.left = 2;
	rect.top = y;
	rect.right = GPC_LCD_WIDTH;
	rect.bottom = y+16;//GPC_LCD_HEIGHT;

 	//  
	tw=GpTextWidthGet(s);
	th=GpTextHeightGet(s);
	//DrawWindow( (GPC_LCD_WIDTH - (tw+20) )/2, (GPC_LCD_HEIGHT - (th+20) )/2, tw+20, th+20, nflip,
	//90,94,152,86,81);

#ifdef __GNUC__
	GpTextDraw(&gpDraw[nflip], &rect, GPC_GT_HCENTER | GPC_GT_VCENTER, 
		    	   (char*)s, 0, strlen(s), 0x0);	

	rect.left = 0;
	rect.top = 0;
	GpTextDraw(&gpDraw[nflip], &rect, GPC_GT_HCENTER | GPC_GT_VCENTER, 
		    	   (char*)s, 0, strlen(s), 254);
#endif
}

//       
void DrawMessage(char *s, int nflip)
{
	int tw,th;
	GPRECT rect;	
	rect.left = 2;
	rect.top = 2;
	rect.right = GPC_LCD_WIDTH;
	rect.bottom = GPC_LCD_HEIGHT;

 	//  
	tw=GpTextWidthGet(s);
	th=GpTextHeightGet(s);
	DrawWindow( (GPC_LCD_WIDTH - (tw+20) )/2, (GPC_LCD_HEIGHT - (th+20) )/2, tw+20, th+20, nflip,
	90,94,152,86,81);


	GpTextDraw(&gpDraw[nflip], &rect, GPC_GT_HCENTER | GPC_GT_VCENTER, 
		    	   (char*)s, 0, strlen(s), 0x0);
	rect.left = 0;
	rect.top = 0;
	GpTextDraw(&gpDraw[nflip], &rect, GPC_GT_HCENTER | GPC_GT_VCENTER, 
		    	   (char*)s, 0, strlen(s), 254);

}
//       
void DrawError(char *s, int nflip)
{
	int tw,th;
	GPRECT rect;	
	rect.left = 2;
	rect.top = 2;
	rect.right = GPC_LCD_WIDTH;
	rect.bottom = GPC_LCD_HEIGHT;

 	//  c !
	tw=GpTextWidthGet(s);
	th=GpTextHeightGet(s);
	DrawWindow( (GPC_LCD_WIDTH - (tw+20) )/2, (GPC_LCD_HEIGHT - (th+20) )/2, tw+20, th+20, nflip,
	224,240,241,192,160);

#ifdef __GNUC__
	GpTextDraw(&gpDraw[nflip], &rect, GPC_GT_HCENTER | GPC_GT_VCENTER, 
		    	   (char*)s, 0, strlen(s), 0x0);
	rect.left = 0;
	rect.top = 0;
	GpTextDraw(&gpDraw[nflip], &rect, GPC_GT_HCENTER | GPC_GT_VCENTER, 
		    	   (char*)s, 0, strlen(s), 254);
#endif
}

// green 90,94,152,86,81
// red 224,240,241,192,160

void DrawWindow(int x, int y, int lx, int ly, int nflip, int c1, int c2, int c3, int c4, int c5)
{
	//  
	GpRectFill(NULL, &gpDraw[nflip], x+5,y+5,lx,ly, 0);
	GpRectFill(NULL, &gpDraw[nflip], x-1,y-1,lx+2,ly+2, 0);
	//CurrentColor=wfon;
	GpRectFill(NULL, &gpDraw[nflip], x,y,lx,ly, c1);
	//CurrentColor=wlight;
	GpRectFill(NULL, &gpDraw[nflip], x,y,lx,1, c2);
	GpRectFill(NULL, &gpDraw[nflip], x,y,1,ly, c2);
	//CurrentColor++;
	GpRectFill(NULL, &gpDraw[nflip], x,y,1,1, c3);
	//CurrentColor=wshadow;
	GpRectFill(NULL, &gpDraw[nflip], x,y+ly-1,lx,1, c4);
	GpRectFill(NULL, &gpDraw[nflip], x+lx-1,y+1,1,ly-1, c4);
	//CurrentColor++;
	GpRectFill(NULL, &gpDraw[nflip], x+lx-1,y+ly-1,1,1, c5);
}

#define menu_border 10
#define menu_shadow 3
#define menu_char_width 8
#define menu_char_height 16


// 
#define c1 90
#define c2 94
#define c3 152
#define c4 86
#define c5 81
#define ct 0


//      |
int vopros(int x, int y, char *text, char *v, int n) {
	int tw, th, ni=0, i, j, mxs, mys,lx,ly, old_n=n;
	int keydata;
	short int mi_x[20], mi_y[20], mi_s[20], mi_n[20];
	//  
	tw = GpTextWidthGet(text);
	th = GpTextHeightGet(text);

	j=0;	//  
	mxs = 0; //   
	mys = menu_border;
	//     
	for (i=0; i<= GpTextLenGet(v) && ni<20; i++) {
		if ( *(v+i) == '|') {
			//if (j) j--;
			//  1    
			//    
			if ( (mxs + (i-j)*menu_char_width) > tw ) {
				mxs = 0;
				mys += menu_char_height;
			}
			mi_x[ni] = mxs;
			mi_y[ni] = mys;
			mi_s[ni] = j;	// 
			mi_n[ni] = i-j; // 
			//   
			mxs += (i-j+1)*menu_char_width;
			j=i+1;
			ni++;
		}
	}

	// . 
	if (x < 0) {
		//  
		x = (320 - (tw+2*menu_border) )/2;
	}
	if (y < 0) {
		//  Y
		y = (240 - (th+2*menu_border+mys) )/2;
	}

	WaitKeyRelease();

	//   
	lx = tw + menu_border*2;
	ly = th + menu_border*3+mys;

	//FlipAndShow();
	nflip = nflip?0:1;
	// 
/*	for (i=8; i<lx; i+=4) {
		GpRectFill(NULL, &gpDraw[nflip], x+(lx-i)/2,y+ly/2-i/4+1,i,i/2<ly?i/2:ly, c1);
		Delay(2);
	}
*/
	//  
	GpRectDraw(&gpDraw[nflip],x-1,y-1,x+lx,y+ly, 0);//

	GpRectFill(NULL, &gpDraw[nflip], x+menu_shadow,y+ly,lx,menu_shadow, 0);
	GpRectFill(NULL, &gpDraw[nflip], x+lx,y+menu_shadow,menu_shadow,ly, 0);

	//CurrentColor=wfon;
	GpRectFill(NULL, &gpDraw[nflip], x,y,lx,ly, c1);
	//CurrentColor=wlight;
	GpRectFill(NULL, &gpDraw[nflip], x,y,lx,1, c2);
	GpRectFill(NULL, &gpDraw[nflip], x,y,1,ly, c2);
	//CurrentColor++;
	GpRectFill(NULL, &gpDraw[nflip], x,y,1,1, c3);
	//CurrentColor=wshadow;
	GpRectFill(NULL, &gpDraw[nflip], x,y+ly-1,lx,1, c4);
	GpRectFill(NULL, &gpDraw[nflip], x+lx-1,y+1,1,ly-1, c4);
	//CurrentColor++;
	GpRectFill(NULL, &gpDraw[nflip], x+lx-1,y+ly-1,1,1, c5);
	
	// 
	GpTextOut(NULL, &gpDraw[nflip], x+menu_border+1, y+menu_border+1-2, (char*)text,c4);
	GpTextOut(NULL, &gpDraw[nflip], x+menu_border, y+menu_border-2, (char*)text,ct);

	GpRectFill(NULL, &gpDraw[nflip], x+1,y+menu_border+menu_border/2-1+th,lx-2,1, c2);
	GpRectFill(NULL, &gpDraw[nflip], x+1,y+menu_border+menu_border/2+th,lx-2,1, c4);

	// 
	for (i=0; i<ni; i++) {
		GpTextNOut(NULL, &gpDraw[nflip], x+menu_border+mi_x[i]+2, y+menu_border+th+mi_y[i]+2, (char*)v, mi_s[i],mi_n[i],255);
	}
	//FlipAndShow();
	//nflip = nflip?0:1;

	//    -
	while (1) {
		// 
		GpRectFill(NULL, &gpDraw[nflip], x+menu_border+mi_x[old_n]-1, y+menu_border+th+mi_y[old_n], menu_char_width*(mi_n[old_n])+4, menu_char_height, c1);
		GpTextNOut(NULL, &gpDraw[nflip], x+menu_border+mi_x[old_n]+2, y+menu_border+th+mi_y[old_n]+2, (char*)v, mi_s[old_n],mi_n[old_n],255);
		// 
		GpRectFill(NULL, &gpDraw[nflip], x+menu_border+mi_x[n], y+menu_border+th+mi_y[n], menu_char_width*(mi_n[n])+2, menu_char_height, c2);
		//lev
		GpRectFill(NULL, &gpDraw[nflip], x+menu_border+mi_x[n]-1, y+menu_border+th+mi_y[n]+1, 1, menu_char_height-2, c2);
		//prav
		GpRectFill(NULL, &gpDraw[nflip], x+menu_border+mi_x[n]+menu_char_width*(mi_n[n])+2, y+menu_border+th+mi_y[n]+1, 1, menu_char_height-2, c2);

		GpTextNOut(NULL, &gpDraw[nflip], x+menu_border+mi_x[n]+1+2, y+menu_border+th+mi_y[n]+2+1, (char*)v, mi_s[n],mi_n[n],c4);
		GpTextNOut(NULL, &gpDraw[nflip], x+menu_border+mi_x[n]+2, y+menu_border+th+mi_y[n]+2, (char*)v, mi_s[n],mi_n[n],ct);

		Delay(100);
		GpKeyGetEx(&keydata);
		while ( keydata == 0) GpKeyGetEx(&keydata);

		//keyboard
		if (( keydata & GPC_VK_LEFT ) || ( keydata & GPC_VK_UP )) { //press Left
			old_n = n;
			n--;
			if (n<0) n = ni-1;
			//SE(sfx_cursor);
		} else
		if ( (keydata & GPC_VK_RIGHT) || ( keydata & GPC_VK_DOWN ) || ( keydata & GPC_VK_SELECT ) ) { //press Right
			old_n = n;
			n++;
			if (n>=ni) n = 0;
			//SE(sfx_cursor);
		} else
		if ( keydata & GPC_VK_FL ) { //press Left Shoulder
			old_n = n;
			n=0;
		} else
		if ( keydata & GPC_VK_FR ) { //press Right Shoulder
			old_n = n;
			n = ni-1;
		} else
		if (( keydata & GPC_VK_FA ) || ( keydata & GPC_VK_START )) { //press A | START
			//SE(sfx_OK);
			WaitKeyRelease();
			nflip = nflip?0:1;
			return n;
		}
		if ( keydata & GPC_VK_FB ) {//press B = Cancel
			//SE(sfx_cancel);
			WaitKeyRelease();
			nflip = nflip?0:1;
			return -1;
		}

	}

	return -1;
}

//   
/*int vvod_imeni(char *name, int n, char *title) {
	int i,j,x,xt,y,p, keydata, cs = 'A',tx1,tx2;
	// 
	g_string[1]= g_string[3] = g_string[5] =0;

	name[n-1]=0; n--; //  

	y = (240 - 14)/2;
	x = (320 - n*menu_char_width)/2;
	xt =(320 - GpTextLenGet(title)*menu_char_width)/2;

	p = GpTextLenGet(name);
	if (p>n-1) p=n-1;

	WaitKeyRelease();

	while (1) {

		//if ( name[p] < ' ' || name[p] > '_') name[p] = ' '; 

		//risuy_podlozhku(0);
		Cls(255,nflip);
		
		
		GpLineDraw(&gpDraw[nflip], 0, y-2-menu_char_height, 320, y-2-menu_char_height, c1);
		GpRectFill(NULL, &gpDraw[nflip], 0, y-1-menu_char_height, 320, menu_char_height*2 +4, c3);
		GpLineDraw(&gpDraw[nflip], 0, y+menu_char_height+3, 320, y+menu_char_height+3, c5);

		GpRectFill(NULL, &gpDraw[nflip], x-2, y-1, n*menu_char_width+3, menu_char_height, c5);
		GpLineDraw(&gpDraw[nflip], x-3, y, x-3, y+menu_char_height-3, c5);
		GpLineDraw(&gpDraw[nflip], x-2+n*menu_char_width+3, y, x-2+n*menu_char_width+3, y+menu_char_height-3, c5);


		// 
		GpTextOut(NULL, &gpDraw[nflip], x-1, y, (char*)name, c1);

		//
		GpTextOut(NULL, &gpDraw[nflip], xt, y-menu_char_height, (char*)title, ct);

		// 
		g_string[0]= g_string[2] = g_string[4] = cs;

		//  
		GpCharOut(NULL,&gpDraw[nflip],
		 x+p*menu_char_width+1, y+4,
		 (char *)&g_string[4], 0);
		GpCharOut(NULL,&gpDraw[nflip],
		 x+p*menu_char_width, y+3,
		 (char *)&g_string[4], 255);
		GpRectDraw(&gpDraw[nflip],
			 x-1+p*menu_char_width, y,
			x+p*menu_char_width+menu_char_width+1, y+menu_char_height-2, 8);
		GpRectDraw(&gpDraw[nflip],
			 x-2+p*menu_char_width, y-1,
			x+p*menu_char_width+menu_char_width, y+menu_char_height-3, 15);

		tx2 = tx1 = x+p*menu_char_width;
		for (i=0; i<8; i++) {
			g_string[0]--;
			if (g_string[0] < ' ') g_string[0] = '_';
			g_string[2]++;
			if (g_string[2] > '_') g_string[2] = ' ';

			GpCharOut(NULL,&gpDraw[nflip],
			tx1, y - menu_char_height*2 + 2 - i*(menu_char_height-3),
			 (char *)&g_string[0], 15);
			GpCharOut(NULL,&gpDraw[nflip],
			 tx1-1, y-1 - menu_char_height*2 + 2 - i*(menu_char_height-3),
			 (char *)&g_string[0], 126-(g_string[0]&7));
			//tx1+=sx[i];

			GpCharOut(NULL,&gpDraw[nflip],
			 tx2, y + menu_char_height+7 + i*(menu_char_height-3),
			 (char *)&g_string[2], 15);
			GpCharOut(NULL,&gpDraw[nflip],
			 tx2-1, y-1 + menu_char_height+7 + i*(menu_char_height-3),
			 (char *)&g_string[2], 126-(g_string[2]&7));
			//tx2+=sx[i+10];

		}

		FlipAndShow();

		Delay(100);
		GpKeyGetEx(&keydata);

		//keyboard
		if ( keydata & GPC_VK_LEFT ) //press Left
		{
				p--;
				if (p<0) p = 0;
				//SE(sfx_cursor);
		} else
		if ( keydata & GPC_VK_RIGHT ) //press Rghtt
		{
				p++;
				if (p>n-1) p = n-1;
				//SE(sfx_cursor);
		} else
		//keyboard
		if ( keydata & GPC_VK_UP ) //press UP
		{
				cs++;
				if (cs>'_') cs = ' ';
				//SE(sfx_cursor);
		} else
		if ( keydata & GPC_VK_DOWN ) //press
		{
				cs--;
				if (cs<' ') cs = '_';
				//SE(sfx_cursor);
		} else
		if (keydata & GPC_VK_START)   //press  Strart
		{
			i=n-1;
			while (name[i]==' ' && i>0) {
				name[i--]=0;
			}
			//SE(sfx_OK);
			WaitKeyRelease();
			break;
		} else 
		if ( keydata & GPC_VK_FA ) //press A
		{
				for (i=p-1; i>0; i--) {
					if (name[i]==0)
						name[i]=' ';
				}
				name[p]=cs;
				p++;
				if (p>n-1) p=n-1;

		} else 
		if ( keydata & GPC_VK_FB ) //press B
		{
				for (i=n-1; i>=p; i--) {
					name[i]=' ';
				}
				if (--p<0) p=0;

		}


	}
	
}*/

//    


int random(int r) {
#ifdef __GNUC__
	return r?GpRandN(r):0;
#else
	return r?rand()%r:0;
#endif
}