/* Some menu stuff

  Authors : ThunderZ & YoyoFR
*/

#ifndef __menu_h__
#define __menu_h__

#define MAX_MENU_OPTIONS 16
#define MAX_MENU_SUBOPTIONS 16
#define MAX_LENGTH_LABEL_MENU 46 //45char max on a line
#define MAX_LENGTH_HELP_MENU 46 //45char max on a line
#define MAX_LENGTH_LABEL_SUBMENU 8
#define MAX_MENU_TITLE 22 //big font

typedef struct
{
  int x,y;
  int ex,ey;
  char name[MAX_LENGTH_LABEL_SUBMENU];
} menuSubOption;

typedef struct
{
    int x,y;							/* Start X,Y */
    int ex,ey;							/* End X,Y doit etre calculer... */
    int selected;						/* selection de la sous option */
    int num;
    char name[MAX_LENGTH_LABEL_MENU];
    char helpmsg[MAX_LENGTH_HELP_MENU];
    int testonsel;
  menuSubOption sub_options[MAX_MENU_SUBOPTIONS];
  int disact;
} menuOption ;

typedef struct
{
  menuOption options[MAX_MENU_OPTIONS];
  int num;
  int selected;
  void (*Cls_Menu)(unsigned char *buffer);
  int x,y,w,h;
  char title[MAX_MENU_TITLE];
  int tx,wt;
} stMenu;

void draw_menu (stMenu *menu,int snap_enabled,int mini_img_avail,char *mini_img);
int run_menu(stMenu *menu,int init_halfval,int snap_enabled);
void precalc_menu (stMenu *menu,int ox,int oy,int y_spacing,int x_spacing);
void fill_main_menu (stMenu *menu);
void fill_sound_menu (stMenu *menu);
void fill_video_menu (stMenu *menu);
void fill_hack_menu (stMenu *menu);
void fill_state_menu (stMenu *menu);
void fill_input_menu (stMenu *menu);

/* Main menu */
#define MENU_MAIN_RETURN    		0
#define MENU_MAIN_STATE	    		1
#define MENU_MAIN_VIDEO	    		2
#define MENU_MAIN_SOUND	    		3
#define MENU_MAIN_INPUT	    		4
#define MENU_MAIN_HACK	    		5
#define MENU_MAIN_RESET	            6
#define MENU_MAIN_EXIT_AND_SAVE     7
#define MENU_MAIN_CREDITS           8
#define MENU_MAIN_PARAMGENSAVE      9
#define MENU_MAIN_PARAMSPESAVE      10
#define MENU_MAIN_REBOOT			11

#define MENU_MAIN_NUMENTRIES		12

/*#define MENU_MAIN_FRAMESKIP    		1
#define MENU_MAIN_SLOT_STATE		2
#define MENU_MAIN_LOAD_STATE		3
#define MENU_MAIN_SAVE_STATE		4
#define MENU_MAIN_RESET	            5
#define MENU_MAIN_SOUND             6
#define MENU_MAIN_GAMMA	            7
#define MENU_MAIN_TRANSPARENCY      8
#define MENU_MAIN_SHOW_FPS		    9
#define MENU_MAIN_VIDEO_SYNC		10
#define MENU_MAIN_EXIT_AND_SAVE     11
#define MENU_MAIN_CONFIGURE_INPUT   12
#define MENU_MAIN_DEBUG             13
#define MENU_MAIN_CREDITS           14
#define MENU_MAIN_REBOOT			15*/

/*SaveState MENU*/
#define MENU_STATE_RETURN			0
#define MENU_STATE_SLOT_STATE		1
#define MENU_STATE_LOAD_STATE		2
#define MENU_STATE_SAVE_STATE		3

#define MENU_STATE_NUMENTRIES		4


/*video menu*/
#define MENU_VIDEO_RETURN			0
#define MENU_VIDEO_FRAMESKIP		1
#define MENU_VIDEO_SHOW_FPS		    2
#define MENU_VIDEO_MODE				3
#define MENU_VIDEO_SYNC				4
#define MENU_VIDEO_FASTMODE			5
#define MENU_VIDEO_GAMMA			6

#define MENU_VIDEO_NUMENTRIES		7
/*HACK menu*/
#define MENU_HACK_RETURN			0
#define MENU_HACK_TRANSPARENCY		1
#define MENU_HACK_PALETTEBRIGHTNESS	2
#define MENU_HACK_BG0				3
#define MENU_HACK_BG1				4
#define MENU_HACK_BG2				5
#define MENU_HACK_BG3				6
#define MENU_HACK_OBJS				7
#define MENU_HACK_HDMA				8
#define MENU_HACK_IRQ				9
#define MENU_HACK_FASTSPRITES		10
#define MENU_HACK_CPUCYCLE			11

#define MENU_HACK_NUMENTRIES		12
/*SOUND MENU*/
#define MENU_SOUND_RETURN			0
#define MENU_SOUND_MODE				1
#define MENU_SOUND_STEREO			2
#define MENU_SOUND_FREQUENCY		3
#define MENU_SOUND_16BITS			5

#define MENU_SOUND_NUMENTRIES		6
/*INPUT MENU*/
#define MENU_INPUT_RETURN			0
#define MENU_INPUT_PORT				1
#define MENU_INPUT_TYPE				2
#define MENU_INPUT_CONFSELECT		3
#define MENU_INPUT_BUTTONA			4
#define MENU_INPUT_BUTTONB			5
#define MENU_INPUT_BUTTONL			6
#define MENU_INPUT_BUTTONR			7
#define MENU_INPUT_BUTTONSTART		8
#define MENU_INPUT_BUTTONSELECT		9

#define MENU_INPUT_NUMENTRIES		10
#endif /*__menu_h__*/