/* Some menu stuff

  Authors : ThunderZ & YoyoFR
*/

#define KEYS_PRESS_CONS 4

/***********************************************/
/* SNES9X headers */
#include "snes9x.h"
/***********************************************/

#include "file_dialog.h"

#include "gui_fx.h"
#include "menu.h"
#include "gp32_func.h"
/***********************************************/

/*****************/
/* Some C stuff*/
extern "C"
{
#include "gfxlib.h"
#include "bioslib.h"
#include "gp32.h"
}

extern unsigned char *vrambuffer,*currentbuffer;
extern struct LCDinfo lcd;
extern uint16 *halfval;

int gp32_checkstate(int slot,char *mini_img);

void draw_menu (stMenu *menu,int snap_enabled,int mini_img_avail,char *mini_img)
{
   int i,j;

  if (menu->Cls_Menu) menu->Cls_Menu(vrambuffer);
  
  DrawWindow( menu->tx-3, 5, menu->wt, 25 , (31<<11)|(31<<6)|(28<<1)|1,(24<<11)|(24<<6)|(15<<1)|1);
  gp32_GpTextOutBig(vrambuffer,menu->tx,10,menu->title,(31<<11)|(31<<6)|(24<<1)|1,1);

  DrawWindow( menu->x, menu->y, menu->w, menu->h , (31<<11)|(31<<6)|(28<<1)|1,(24<<11)|(24<<6)|(15<<1)|1);
    
  for (i=0;i<menu->num;i++)
  if (!(menu->options[i].disact))
  {
   // Menu de base 
    if (i==menu->selected)
    {
     	gp32_GpTextOut(vrambuffer, menu->options[i].x, menu->options[i].y, menu->options[i].name, COLOR_GREEN,1);
		if ((menu->options[i]).helpmsg[0])
    	{
	    	DrawWindow( 2, 220, strlen(menu->options[i].helpmsg)*7+6, 16 , (31<<11)|(31<<6)|(28<<1)|1,(24<<11)|(24<<6)|(15<<1)|1); 
		    gp32_GpTextOut(vrambuffer,5, 225, menu->options[i].helpmsg, (31<<11)|(31<<6)|(24<<1)|1,1);
	    }

    }
    else gp32_GpTextOut(vrambuffer, menu->options[i].x, menu->options[i].y, menu->options[i].name, (31<<11)|(31<<6)|(31<<1)|1,1);
    
        
   // Sous menu via selection latral
   for (j=menu->options[i].num-1; j>=0 ; j--)
   {	
     // droite a gauche
    if (j==menu->options[i].selected)
    {
      if (i==menu->selected) gp32_GpTextOut(vrambuffer, menu->options[i].sub_options[j].x,menu->options[i].sub_options[j].y,menu->options[i].sub_options[j].name, COLOR_GREEN,1);  
      else gp32_GpTextOut(vrambuffer, menu->options[i].sub_options[j].x,menu->options[i].sub_options[j].y,menu->options[i].sub_options[j].name, (31<<11)|(5<<6)|(10<<1)|1,1);  
    }
    else gp32_GpTextOut(vrambuffer, menu->options[i].sub_options[j].x,menu->options[i].sub_options[j].y,menu->options[i].sub_options[j].name, (28<<11)|(28<<6)|(28<<1)|1,1);     
   }
 }

 //miniature
  if (snap_enabled&&mini_img_avail&&
  	  ( (menu->selected==MENU_STATE_SLOT_STATE)
    	  ||(menu->selected==MENU_STATE_LOAD_STATE)
    	  ||(menu->selected==MENU_STATE_SAVE_STATE) )
     )
  {
  	for (i=0;i<64;i++)
  	for (j=0;j<60;j++)
  		((int16*)vrambuffer)[i*240+(319-64-3)*240+239-j-3]=((int16*)mini_img)[i*60+59-j];
  	for (i=319-64-5;i<=319-1;i++)
	{
		((int16*)vrambuffer)[i*240+239-1]=(31<<11)|(31<<6)|(24<<1)|1;
		((int16*)vrambuffer)[i*240+239-59-5]=(31<<11)|(31<<6)|(24<<1)|1;
		((int16*)vrambuffer)[i*240+239-2]=(24<<11)|(24<<6)|(15<<1)|1;
	  	((int16*)vrambuffer)[i*240+239-59-4]=(24<<11)|(24<<6)|(15<<1)|1;
	}
	for (j=1;j<=59+5;j++)
	{
		((int16*)vrambuffer)[(319-64-5)*240+239-j]=(31<<11)|(31<<6)|(24<<1)|1;
		((int16*)vrambuffer)[(319-1)*240+239-j]=(31<<11)|(31<<6)|(24<<1)|1;
		((int16*)vrambuffer)[(319-64-4)*240+239-j]=(24<<11)|(24<<6)|(15<<1)|1;
	  	((int16*)vrambuffer)[(319-2)*240+239-j]=(24<<11)|(24<<6)|(15<<1)|1;
	}	  				  					  				  			 
  }
 //DrawWindow( 2, 220, 160, 16 , COLOR_WHITE,COLOR_GRAY); 
 //char strtmp[256]; 
 /*sprintf(strtmp,"RAM : %d",gm_availablesize());
 gp32_GpTextOut(vrambuffer,5,225,strtmp,0xFFFF,1); */
// gp32_GpTextOut(vrambuffer,5,225,"START+SELECT to REBOOT",(31<<11)|(31<<6)|(10<<1)|1,1);
}


int run_menu(stMenu *menu,int init_halfval,int snap_enabled)
{
 int exit_menu=0;
 int keystab[KEYS_PRESS_CONS],keys,key_rep,frame=0;
 int ret_code;
 int i,j;
// char *mini_img;
 int mini_img_avail=0;
 unsigned long fsize; 
 char mini_img[64*60*2];

 
 if (snap_enabled)
 {
 	mini_img_avail=gp32_checkstate((menu->options[MENU_STATE_SLOT_STATE]).selected,mini_img);
 }
 
 if (init_halfval)
 {
    halfval = (uint16*)malloc(65536*sizeof(uint16));	
	for (int i=0;i<65536;i++)
	{
		int r,v,b;
		r=((i>>11))>>1;
		v=(((i>>6)&31))>>1;
		b=(((i>>1)&31))>>1;
		halfval[i]=(r<<11)|(v<<6)|(b<<1)|1;
	}
 }
 //reset keystab
 memset(keystab,0,KEYS_PRESS_CONS*4);
 key_rep=0;
 //pour eviter les pb de sortie direct du menu
 while (GpKeyGet()&(GPC_VK_FA|GPC_VK_FB));
 do
 {
  draw_menu(menu,snap_enabled,mini_img_avail,mini_img);
      
  FlipAndShow();
  
  frame++;
  
  
  for (i=0;i<KEYS_PRESS_CONS-1;i++) keystab[i]=keystab[i+1];
  keystab[KEYS_PRESS_CONS-1]=GpKeyGet();
  
  if ((frame&1)==0) //test keys not each frames
  {  	
   	keys=0;  
    if (key_rep)
   	{

    	for (i=KEYS_PRESS_CONS-1;i;i--) 
    		if (!keystab[i]) {keys=0;break;}
    		else keys|=keystab[i];
   	}
    else 
    {
	    key_rep=1;
    	for (i=KEYS_PRESS_CONS-1;i;i--) 
    		keys|=keystab[i];
   	}
    if (!keys) key_rep=0;
	
    	
	//Hard Reset
	if ( ((keys & GPC_VK_START)&&(keys & GPC_VK_SELECT)&&(keys & GPC_VK_FL))/*||
		((menu->selected==MENU_MAIN_REBOOT)&&(keys&(GPC_VK_FA|GPC_VK_FB)))*/
	   ) GpAppExit();

   	if(keys & GPC_VK_DOWN)  menu->selected=(menu->selected+1);
	if(keys & GPC_VK_UP)  menu->selected=(menu->selected-1);

    if (menu->selected<0) menu->selected=0;//menu->num-1;
    if (menu->selected>=menu->num) menu->selected=menu->num-1;        
      
    if (keys & (GPC_VK_FA)) 
    {
    	if (menu->options[menu->selected].num)
   		{if (menu->options[menu->selected].selected<menu->options[menu->selected].num-1) menu->options[menu->selected].selected++;}
   		else 
   		{
	   		ret_code=menu->selected;
   			exit_menu=1;
   		}
   		
   		if (menu->options[menu->selected].testonsel)
        {
	        ret_code=menu->selected;
   			exit_menu=1;
        }
	}

    if (keys & (GPC_VK_FB) )
 	{
	    if (menu->options[menu->selected].num)
   		{if (menu->options[menu->selected].selected>0) menu->options[menu->selected].selected--;}
   		else 
   		{
	   		ret_code=menu->selected;
   			exit_menu=1;
   		}
   		
   		if (menu->options[menu->selected].testonsel)
        {
	        ret_code=menu->selected;
   			exit_menu=1;
        }
 	}

  	if (menu->options[menu->selected].num)
 	{
   		if(keys & GPC_VK_LEFT)  
      	{ if (menu->options[menu->selected].selected>0) menu->options[menu->selected].selected--;}
   		else 
     	if(keys & GPC_VK_RIGHT) 
       	{if (menu->options[menu->selected].selected<menu->options[menu->selected].num-1) menu->options[menu->selected].selected++;}
       
        if (menu->options[menu->selected].testonsel)
        {
	        ret_code=menu->selected;
   			exit_menu=1;
        }
 	}
 
 	if (snap_enabled&&(menu->selected==MENU_STATE_SLOT_STATE))
   	{	if (keys & (GPC_VK_FA|GPC_VK_FB|GPC_VK_LEFT|GPC_VK_RIGHT)) 
   		{	if (init_halfval) free(halfval);
   			mini_img_avail=gp32_checkstate((menu->options[MENU_STATE_SLOT_STATE]).selected,mini_img);
   			if (init_halfval)
		 	{  	halfval = (uint16*)malloc(65536*sizeof(uint16));	
		    	int r,v,b;
				for (int i=0;i<65536;i++)
				{r=((i>>11))>>1;v=(((i>>6)&31))>>1;b=(((i>>1)&31))>>1;
				 halfval[i]=(r<<11)|(v<<6)|(b<<1)|1;}
			}     
   		}
   	}
   	//Exit menu
  	if ( (keys & GPC_VK_FR) )
  	{  			  	
	   	ret_code=0;
   		exit_menu=1;   		
  	}
   	keys=0;
  }
} while (!exit_menu);


 if (init_halfval) free(halfval);
// if (snap_enabled) gm_free(mini_img);

 return ret_code;
}

void precalc_menu (stMenu *menu,int ox,int oy,int y_spacing,int x_spacing)
 {
   int i,xp,yp,lx,ly;
   int j,sxp,syp,w,wtmp;
   
   	menu->tx=160-strlen(menu->title)*7;
	menu->wt=strlen(menu->title)*14;

   
   w=0;
   for (i=0;i<menu->num;i++)
   {
	   wtmp=strlen(menu->options[i].name)*7;
	   if (menu->options[i].num)
	   {
 	   		wtmp+=7*2; //minimum 2 chars between options & sub options
 			for (j=0; j<menu->options[i].num ; j++)
				wtmp+=strlen(menu->options[i].sub_options[j].name)*7;
			wtmp+=(x_spacing)*(menu->options[i].num-1);
	   }
	   if (w<wtmp) w=wtmp;
   }
   menu->w=w+6; //compute sizes
   menu->h=menu->num*8+(menu->num-1)*y_spacing+6;
   xp=menu->x=160-((menu->w)>>1)+ox; //centering
   yp=menu->y=120-((menu->h)>>1)+oy;
   yp+=3; //borders
   xp+=3;
   
    // yo : on considere une seule ligne   
   for (i=0;i<menu->num;i++)
   {
    lx=strlen(menu->options[i].name)*7;
    ly=8;
    
   	if (menu->options[i].num)
	{   
		menu->options[i].x=xp;
    	menu->options[i].y=yp;

		menu->options[i].ex=menu->options[i].x+lx;
    	menu->options[i].ey=menu->options[i].y+ly;    
    	

    	sxp=xp+menu->w-6;
    	syp=yp;
   		for (j=menu->options[i].num-1; j>=0 ; j--)
   		{
     	// sous menu de droite a gauche
    		menu->options[i].sub_options[j].y=syp;
    		menu->options[i].sub_options[j].ex=sxp;
    		lx=strlen(menu->options[i].sub_options[j].name)*7;
    		sxp-=lx;
    		menu->options[i].sub_options[j].x=sxp;
    		menu->options[i].sub_options[j].ey=syp+ly;
    		sxp-=x_spacing;
   		}
  	}
  	else
 	{
 		menu->options[i].x=160-(lx>>1)+ox;
	    menu->options[i].y=yp;

 	
   		menu->options[i].ex=menu->options[i].x+lx;
   		menu->options[i].ey=menu->options[i].y+ly;   	
 	}
  	yp+=ly+y_spacing;
   }

}

void fill_main_menu (stMenu *menu)
{
	char str[64];
	gm_memset((unsigned char*)menu,0,sizeof(stMenu));
	gm_strcpy (menu->options[MENU_MAIN_RETURN].name,"Return to Game (press R)");
	gm_strcpy (menu->options[MENU_MAIN_STATE].name,"Load/Save");
	gm_strcpy (menu->options[MENU_MAIN_VIDEO].name,"Video settings");
	gm_strcpy (menu->options[MENU_MAIN_SOUND].name,"Sound settings");
	gm_strcpy (menu->options[MENU_MAIN_INPUT].name,"Input settings");
	gm_strcpy (menu->options[MENU_MAIN_HACK].name,"Hack settings");
	gm_strcpy (menu->options[MENU_MAIN_RESET].name,"Reset game");
	gm_strcpy (menu->options[MENU_MAIN_EXIT_AND_SAVE].name,"Exit to ROM browser");
		gm_strcpy (menu->options[MENU_MAIN_EXIT_AND_SAVE].helpmsg,"SRAM is saved");
	gm_strcpy (menu->options[MENU_MAIN_CREDITS].name,"Credits");
	
	gm_strcpy (menu->options[MENU_MAIN_PARAMGENSAVE].name,"Save settings (all)");
		gm_strcpy (menu->options[MENU_MAIN_PARAMGENSAVE].helpmsg,"Save as default settings");
		
	gm_strcpy (menu->options[MENU_MAIN_PARAMSPESAVE].name,"Save settings (this rom)");
		gm_strcpy (menu->options[MENU_MAIN_PARAMSPESAVE].helpmsg,"Save settings for this rom only");
	
	gm_strcpy (menu->options[MENU_MAIN_REBOOT].name,"Reboot");
		gm_strcpy (menu->options[MENU_MAIN_REBOOT].helpmsg,"SRAM is NOT saved");
	
	menu->num = MENU_MAIN_NUMENTRIES;
	menu->selected = 0;
	sprintf(str,"[OpenSNES9xGP v%d.%d]",VERSION_MAJOR,VERSION_MINOR);
	gm_strcpy(menu->title,str);
	precalc_menu(menu,0,0,1,3);
}


void fill_state_menu (stMenu *menu)
{
	gm_memset((unsigned char*)menu,0,sizeof(stMenu));
	gm_strcpy (menu->options[MENU_STATE_RETURN].name,"Return to Menu (R)");
	
	gm_strcpy (menu->options[MENU_STATE_SLOT_STATE].name,"Select Slot");
      gm_strcpy (menu->options[MENU_STATE_SLOT_STATE].sub_options[0].name,"0");
      gm_strcpy (menu->options[MENU_STATE_SLOT_STATE].sub_options[1].name,"1");
      gm_strcpy (menu->options[MENU_STATE_SLOT_STATE].sub_options[2].name,"2");
      gm_strcpy (menu->options[MENU_STATE_SLOT_STATE].sub_options[3].name,"3");
      gm_strcpy (menu->options[MENU_STATE_SLOT_STATE].sub_options[4].name,"4");
      gm_strcpy (menu->options[MENU_STATE_SLOT_STATE].sub_options[5].name,"5");
      gm_strcpy (menu->options[MENU_STATE_SLOT_STATE].sub_options[6].name,"6");
      gm_strcpy (menu->options[MENU_STATE_SLOT_STATE].sub_options[7].name,"7");
      gm_strcpy (menu->options[MENU_STATE_SLOT_STATE].sub_options[8].name,"8");
      gm_strcpy (menu->options[MENU_STATE_SLOT_STATE].sub_options[9].name,"9");
    menu->options[MENU_STATE_SLOT_STATE].num=10;
    menu->options[MENU_STATE_SLOT_STATE].selected = 0; // Par defaut 0

    gm_strcpy (menu->options[MENU_STATE_LOAD_STATE].name,"Load State");
    gm_strcpy (menu->options[MENU_STATE_SAVE_STATE].name,"Save State");
    
   menu->num = MENU_STATE_NUMENTRIES;
   menu->selected = 0;
   gm_strcpy(menu->title,"[Load/Save]");
   precalc_menu(menu,0,0,1,3);
}


void fill_video_menu (stMenu *menu)
{
	gm_memset((unsigned char*)menu,0,sizeof(stMenu));
	gm_strcpy (menu->options[MENU_VIDEO_RETURN].name,"Return to Menu (R)");
	
	gm_strcpy (menu->options[MENU_VIDEO_FRAMESKIP].name,"Frame Skip");
      gm_strcpy (menu->options[MENU_VIDEO_FRAMESKIP].sub_options[0].name,"0");
      gm_strcpy (menu->options[MENU_VIDEO_FRAMESKIP].sub_options[1].name,"1");
      gm_strcpy (menu->options[MENU_VIDEO_FRAMESKIP].sub_options[2].name,"2");
      gm_strcpy (menu->options[MENU_VIDEO_FRAMESKIP].sub_options[3].name,"3");
      gm_strcpy (menu->options[MENU_VIDEO_FRAMESKIP].sub_options[4].name,"4");
      gm_strcpy (menu->options[MENU_VIDEO_FRAMESKIP].sub_options[5].name,"5");
      gm_strcpy (menu->options[MENU_VIDEO_FRAMESKIP].sub_options[6].name,"6");
      gm_strcpy (menu->options[MENU_VIDEO_FRAMESKIP].sub_options[7].name,"7");
      gm_strcpy (menu->options[MENU_VIDEO_FRAMESKIP].sub_options[8].name,"8");
      gm_strcpy (menu->options[MENU_VIDEO_FRAMESKIP].sub_options[9].name,"9");
      gm_strcpy (menu->options[MENU_VIDEO_FRAMESKIP].sub_options[10].name,"A");
    menu->options[MENU_VIDEO_FRAMESKIP].num=11;
    menu->options[MENU_VIDEO_FRAMESKIP].selected = 0; // Par defaut 0
    
    gm_strcpy (menu->options[MENU_VIDEO_SHOW_FPS].name,"Show FPS");
      gm_strcpy (menu->options[MENU_VIDEO_SHOW_FPS].sub_options[0].name,"OFF ");
      gm_strcpy (menu->options[MENU_VIDEO_SHOW_FPS].sub_options[1].name,"ON ");
   menu->options[MENU_VIDEO_SHOW_FPS].num=2;
   menu->options[MENU_VIDEO_SHOW_FPS].selected = 0; // Par defaut OFF
    
    
    gm_strcpy (menu->options[MENU_VIDEO_SYNC].name,"Video sync");
	  gm_strcpy (menu->options[MENU_VIDEO_SYNC].sub_options[0].name,"OFF");
      gm_strcpy (menu->options[MENU_VIDEO_SYNC].sub_options[1].name,"ON");
    menu->options[MENU_VIDEO_SYNC].num=2;
    menu->options[MENU_VIDEO_SYNC].selected = 0; // Par defaut OFF      
    gm_strcpy (menu->options[MENU_VIDEO_SYNC].helpmsg,"ON corrects the flickering issue");
    
    gm_strcpy (menu->options[MENU_VIDEO_FASTMODE].name,"Fastmode");
	  gm_strcpy (menu->options[MENU_VIDEO_FASTMODE].sub_options[0].name,"OFF");
      gm_strcpy (menu->options[MENU_VIDEO_FASTMODE].sub_options[1].name,"ON");
    menu->options[MENU_VIDEO_FASTMODE].num=2;
    menu->options[MENU_VIDEO_FASTMODE].selected = 0; // Par defaut OFF      
    gm_strcpy (menu->options[MENU_VIDEO_FASTMODE].helpmsg,"ON is faster but look bad");
    
    gm_strcpy (menu->options[MENU_VIDEO_MODE].name,"Video mode");
	  gm_strcpy (menu->options[MENU_VIDEO_MODE].sub_options[0].name,"16bpp");
      gm_strcpy (menu->options[MENU_VIDEO_MODE].sub_options[1].name,"8bpp");
    menu->options[MENU_VIDEO_MODE].num=2;
    menu->options[MENU_VIDEO_MODE].selected = 0; // Par defaut OFF      
    gm_strcpy (menu->options[MENU_VIDEO_MODE].helpmsg,"16bpp is slower but more accurate");


	gm_strcpy (menu->options[MENU_VIDEO_GAMMA].name,"Gamma");
      gm_strcpy (menu->options[MENU_VIDEO_GAMMA].sub_options[0].name,"0");
      gm_strcpy (menu->options[MENU_VIDEO_GAMMA].sub_options[1].name,"1");
      gm_strcpy (menu->options[MENU_VIDEO_GAMMA].sub_options[2].name,"2");
      gm_strcpy (menu->options[MENU_VIDEO_GAMMA].sub_options[3].name,"3");
      gm_strcpy (menu->options[MENU_VIDEO_GAMMA].sub_options[4].name,"4");
      gm_strcpy (menu->options[MENU_VIDEO_GAMMA].sub_options[5].name,"5");
      gm_strcpy (menu->options[MENU_VIDEO_GAMMA].sub_options[6].name,"6");
      gm_strcpy (menu->options[MENU_VIDEO_GAMMA].sub_options[7].name,"7");
      gm_strcpy (menu->options[MENU_VIDEO_GAMMA].sub_options[8].name,"8");
      gm_strcpy (menu->options[MENU_VIDEO_GAMMA].sub_options[9].name,"9");
   menu->options[MENU_VIDEO_GAMMA].num=10;
   menu->options[MENU_VIDEO_GAMMA].selected = 2; // Par defaut 2
    
   menu->num = MENU_VIDEO_NUMENTRIES;
   menu->selected = 0;
   gm_strcpy(menu->title,"[Video]");
   precalc_menu(menu,0,0,1,3);
}

void fill_hack_menu (stMenu *menu)
{
	gm_memset((unsigned char*)menu,0,sizeof(stMenu));
	gm_strcpy (menu->options[MENU_HACK_RETURN].name,"Return to Menu (R)");
	
	gm_strcpy (menu->options[MENU_HACK_CPUCYCLE].name,"Cpu cycle");
      gm_strcpy (menu->options[MENU_HACK_CPUCYCLE].sub_options[0].name,"-5");
      gm_strcpy (menu->options[MENU_HACK_CPUCYCLE].sub_options[1].name,"-4");
      gm_strcpy (menu->options[MENU_HACK_CPUCYCLE].sub_options[2].name,"-3");
      gm_strcpy (menu->options[MENU_HACK_CPUCYCLE].sub_options[3].name,"-2");
      gm_strcpy (menu->options[MENU_HACK_CPUCYCLE].sub_options[4].name,"-1");
      gm_strcpy (menu->options[MENU_HACK_CPUCYCLE].sub_options[5].name,"0");
      gm_strcpy (menu->options[MENU_HACK_CPUCYCLE].sub_options[6].name,"+1");
      gm_strcpy (menu->options[MENU_HACK_CPUCYCLE].sub_options[7].name,"+2");
      gm_strcpy (menu->options[MENU_HACK_CPUCYCLE].sub_options[8].name,"+3");
      gm_strcpy (menu->options[MENU_HACK_CPUCYCLE].sub_options[9].name,"+4");
      gm_strcpy (menu->options[MENU_HACK_CPUCYCLE].sub_options[10].name,"+5");
    menu->options[MENU_HACK_CPUCYCLE].num=11;
    menu->options[MENU_HACK_CPUCYCLE].selected = 0; // Par defaut 0
    gm_strcpy (menu->options[MENU_HACK_CPUCYCLE].helpmsg,"Step is 5%, so -5 is 75%");
    
    
    gm_strcpy (menu->options[MENU_HACK_TRANSPARENCY].name,"Transparency hack");
	  gm_strcpy (menu->options[MENU_HACK_TRANSPARENCY].sub_options[0].name,"0");
      gm_strcpy (menu->options[MENU_HACK_TRANSPARENCY].sub_options[1].name,"1");
      gm_strcpy (menu->options[MENU_HACK_TRANSPARENCY].sub_options[2].name,"2");
      gm_strcpy (menu->options[MENU_HACK_TRANSPARENCY].sub_options[3].name,"3");
      gm_strcpy (menu->options[MENU_HACK_TRANSPARENCY].sub_options[4].name,"4");
    menu->options[MENU_HACK_TRANSPARENCY].num=5;
    menu->options[MENU_HACK_TRANSPARENCY].selected = 0; // Par defaut OFF      
    gm_strcpy (menu->options[MENU_HACK_TRANSPARENCY].helpmsg,"see readme.txt");
    
    gm_strcpy (menu->options[MENU_HACK_PALETTEBRIGHTNESS].name,"Palette brightness");
	  gm_strcpy (menu->options[MENU_HACK_PALETTEBRIGHTNESS].sub_options[0].name,"OFF");
      gm_strcpy (menu->options[MENU_HACK_PALETTEBRIGHTNESS].sub_options[1].name,"ON");
    menu->options[MENU_HACK_PALETTEBRIGHTNESS].num=2;
    menu->options[MENU_HACK_PALETTEBRIGHTNESS].selected = 0; // Par defaut OFF      
    gm_strcpy (menu->options[MENU_HACK_PALETTEBRIGHTNESS].helpmsg,"8bpp mode only");
    
    gm_strcpy (menu->options[MENU_HACK_BG0].name,"BG0");
	  gm_strcpy (menu->options[MENU_HACK_BG0].sub_options[0].name,"OFF");
      gm_strcpy (menu->options[MENU_HACK_BG0].sub_options[1].name,"ON");
    menu->options[MENU_HACK_BG0].num=2;
    menu->options[MENU_HACK_BG0].selected = 0; // Par defaut OFF      
    
    gm_strcpy (menu->options[MENU_HACK_BG1].name,"BG1");
	  gm_strcpy (menu->options[MENU_HACK_BG1].sub_options[0].name,"OFF");
      gm_strcpy (menu->options[MENU_HACK_BG1].sub_options[1].name,"ON");
    menu->options[MENU_HACK_BG1].num=2;
    menu->options[MENU_HACK_BG1].selected = 0; // Par defaut OFF      
    
    gm_strcpy (menu->options[MENU_HACK_BG2].name,"BG2");
	  gm_strcpy (menu->options[MENU_HACK_BG2].sub_options[0].name,"OFF");
      gm_strcpy (menu->options[MENU_HACK_BG2].sub_options[1].name,"ON");
    menu->options[MENU_HACK_BG2].num=2;
    menu->options[MENU_HACK_BG2].selected = 0; // Par defaut OFF      
    
    gm_strcpy (menu->options[MENU_HACK_BG3].name,"BG3");
	  gm_strcpy (menu->options[MENU_HACK_BG3].sub_options[0].name,"OFF");
      gm_strcpy (menu->options[MENU_HACK_BG3].sub_options[1].name,"ON");
    menu->options[MENU_HACK_BG3].num=2;
    menu->options[MENU_HACK_BG3].selected = 0; // Par defaut OFF      
    
    gm_strcpy (menu->options[MENU_HACK_OBJS].name,"Sprites");
	  gm_strcpy (menu->options[MENU_HACK_OBJS].sub_options[0].name,"OFF");
      gm_strcpy (menu->options[MENU_HACK_OBJS].sub_options[1].name,"ON");
    menu->options[MENU_HACK_OBJS].num=2;
    menu->options[MENU_HACK_OBJS].selected = 0; // Par defaut OFF      
    
     gm_strcpy (menu->options[MENU_HACK_HDMA].name,"HDMA");
	  gm_strcpy (menu->options[MENU_HACK_HDMA].sub_options[0].name,"OFF");
      gm_strcpy (menu->options[MENU_HACK_HDMA].sub_options[1].name,"ON");
    menu->options[MENU_HACK_HDMA].num=2;
    menu->options[MENU_HACK_HDMA].selected = 1; // Par defaut OFF 
    
    gm_strcpy (menu->options[MENU_HACK_IRQ].name,"IRQ");
	  gm_strcpy (menu->options[MENU_HACK_IRQ].sub_options[0].name,"OFF");
      gm_strcpy (menu->options[MENU_HACK_IRQ].sub_options[1].name,"ON");
    menu->options[MENU_HACK_IRQ].num=2;
    menu->options[MENU_HACK_IRQ].selected = 1; // Par defaut OFF     
    
    gm_strcpy (menu->options[MENU_HACK_FASTSPRITES].name,"Fast sprites");
	  gm_strcpy (menu->options[MENU_HACK_FASTSPRITES].sub_options[0].name,"OFF");
      gm_strcpy (menu->options[MENU_HACK_FASTSPRITES].sub_options[1].name,"ON");
    menu->options[MENU_HACK_FASTSPRITES].num=2;
    menu->options[MENU_HACK_FASTSPRITES].selected = 0; // Par defaut OFF 
    
   menu->num = MENU_HACK_NUMENTRIES;
   menu->selected = 0;
   gm_strcpy(menu->title,"[Hack]");
   precalc_menu(menu,0,0,1,3);
}


void fill_sound_menu (stMenu *menu)
{
	gm_memset((unsigned char*)menu,0,sizeof(stMenu));
	gm_strcpy (menu->options[MENU_SOUND_RETURN].name,"Return to Menu (R)");
	
	
    gm_strcpy (menu->options[MENU_SOUND_MODE].name,"Sound mode");
	  gm_strcpy (menu->options[MENU_SOUND_MODE].sub_options[0].name,"OFF");
      gm_strcpy (menu->options[MENU_SOUND_MODE].sub_options[1].name,"ON");
      gm_strcpy (menu->options[MENU_SOUND_MODE].sub_options[2].name,"SIM");
    menu->options[MENU_SOUND_MODE].num=3;
    menu->options[MENU_SOUND_MODE].selected = 0; // Par defaut OFF      
    gm_strcpy (menu->options[MENU_SOUND_MODE].helpmsg,"Switching from OFF requires Game Reset");
    
    gm_strcpy (menu->options[MENU_SOUND_STEREO].name,"Stereo");
	  gm_strcpy (menu->options[MENU_SOUND_STEREO].sub_options[0].name,"OFF");
      gm_strcpy (menu->options[MENU_SOUND_STEREO].sub_options[1].name,"ON");
    menu->options[MENU_SOUND_STEREO].num=2;
    menu->options[MENU_SOUND_STEREO].selected = 0; // Par defaut OFF      
    
    gm_strcpy (menu->options[MENU_SOUND_FREQUENCY].name,"Frequency");
	  gm_strcpy (menu->options[MENU_SOUND_FREQUENCY].sub_options[0].name,"11Khz");
      gm_strcpy (menu->options[MENU_SOUND_FREQUENCY].sub_options[1].name,"22Khz");
      gm_strcpy (menu->options[MENU_SOUND_FREQUENCY].sub_options[2].name,"44Khz");
    menu->options[MENU_SOUND_FREQUENCY].num=3;
    menu->options[MENU_SOUND_FREQUENCY].selected = 0; // Par defaut OFF      
    
    gm_strcpy (menu->options[MENU_SOUND_16BITS].name,"Quality");
	  gm_strcpy (menu->options[MENU_SOUND_16BITS].sub_options[0].name,"8bits");
      gm_strcpy (menu->options[MENU_SOUND_16BITS].sub_options[1].name,"16bits");
    menu->options[MENU_SOUND_16BITS].num=2;
    menu->options[MENU_SOUND_16BITS].selected = 0; // Par defaut OFF      
    
    
   
   menu->num = MENU_SOUND_NUMENTRIES;
   menu->selected = 0;
   gm_strcpy(menu->title,"[Sound]");
   precalc_menu(menu,0,0,1,3);
}

void fill_input_menu (stMenu *menu)
{
	gm_memset((unsigned char*)menu,0,sizeof(stMenu));
	gm_strcpy (menu->options[MENU_INPUT_RETURN].name,"Return to Menu (R)");
	
	gm_strcpy (menu->options[MENU_INPUT_CONFSELECT].name,"Configuration");
      gm_strcpy (menu->options[MENU_INPUT_CONFSELECT].sub_options[0].name,"0");
      gm_strcpy (menu->options[MENU_INPUT_CONFSELECT].sub_options[1].name,"1");
      gm_strcpy (menu->options[MENU_INPUT_CONFSELECT].sub_options[2].name,"2");
      gm_strcpy (menu->options[MENU_INPUT_CONFSELECT].helpmsg,"In conf.2, START+SELECT=>GUI");
    menu->options[MENU_INPUT_CONFSELECT].num=3;
    menu->options[MENU_INPUT_CONFSELECT].selected = 0;
    menu->options[MENU_INPUT_CONFSELECT].testonsel = 1;
    
    gm_strcpy (menu->options[MENU_INPUT_PORT].name,"Port");
      gm_strcpy (menu->options[MENU_INPUT_PORT].sub_options[0].name,"0");
      gm_strcpy (menu->options[MENU_INPUT_PORT].sub_options[1].name,"1");
      gm_strcpy (menu->options[MENU_INPUT_PORT].sub_options[2].name,"2");
      gm_strcpy (menu->options[MENU_INPUT_PORT].sub_options[3].name,"3");
      gm_strcpy (menu->options[MENU_INPUT_PORT].helpmsg,"Choose which port to use");
    menu->options[MENU_INPUT_PORT].num=4;
    menu->options[MENU_INPUT_PORT].selected = 0;
    
    gm_strcpy (menu->options[MENU_INPUT_TYPE].name,"Type");
      gm_strcpy (menu->options[MENU_INPUT_TYPE].sub_options[0].name,"Pad");
      gm_strcpy (menu->options[MENU_INPUT_TYPE].sub_options[1].name,"Mouse");
      gm_strcpy (menu->options[MENU_INPUT_TYPE].sub_options[2].name,"Superscope");
    menu->options[MENU_INPUT_TYPE].num=3;
    menu->options[MENU_INPUT_TYPE].selected = 0;
	
	gm_strcpy (menu->options[MENU_INPUT_BUTTONA].name,"Button A");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONA].sub_options[0].name,"A");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONA].sub_options[1].name,"B");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONA].sub_options[2].name,"X");     
      gm_strcpy (menu->options[MENU_INPUT_BUTTONA].sub_options[3].name,"Y");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONA].sub_options[4].name,"L");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONA].sub_options[5].name,"R");     
      gm_strcpy (menu->options[MENU_INPUT_BUTTONA].sub_options[6].name,"START");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONA].sub_options[7].name,"SELECT");     
    menu->options[MENU_INPUT_BUTTONA].num=8;
    menu->options[MENU_INPUT_BUTTONA].selected = 0;
    
    gm_strcpy (menu->options[MENU_INPUT_BUTTONB].name,"Button B");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONB].sub_options[0].name,"A");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONB].sub_options[1].name,"B");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONB].sub_options[2].name,"X");     
      gm_strcpy (menu->options[MENU_INPUT_BUTTONB].sub_options[3].name,"Y");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONB].sub_options[4].name,"L");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONB].sub_options[5].name,"R");     
      gm_strcpy (menu->options[MENU_INPUT_BUTTONB].sub_options[6].name,"START");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONB].sub_options[7].name,"SELECT");     
    menu->options[MENU_INPUT_BUTTONB].num=8;
    menu->options[MENU_INPUT_BUTTONB].selected = 0;
    
    gm_strcpy (menu->options[MENU_INPUT_BUTTONL].name,"Button L");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONL].sub_options[0].name,"A");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONL].sub_options[1].name,"B");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONL].sub_options[2].name,"X");     
      gm_strcpy (menu->options[MENU_INPUT_BUTTONL].sub_options[3].name,"Y");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONL].sub_options[4].name,"L");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONL].sub_options[5].name,"R");     
      gm_strcpy (menu->options[MENU_INPUT_BUTTONL].sub_options[6].name,"START");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONL].sub_options[7].name,"SELECT");     
    menu->options[MENU_INPUT_BUTTONL].num=8;
    menu->options[MENU_INPUT_BUTTONL].selected = 0;
    
    gm_strcpy (menu->options[MENU_INPUT_BUTTONR].name,"Button R");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONR].sub_options[0].name,"A");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONR].sub_options[1].name,"B");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONR].sub_options[2].name,"X");     
      gm_strcpy (menu->options[MENU_INPUT_BUTTONR].sub_options[3].name,"Y");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONR].sub_options[4].name,"L");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONR].sub_options[5].name,"R");     
      gm_strcpy (menu->options[MENU_INPUT_BUTTONR].sub_options[6].name,"START");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONR].sub_options[7].name,"SELECT");     
    menu->options[MENU_INPUT_BUTTONR].num=8;
    menu->options[MENU_INPUT_BUTTONR].selected = 0;
    
    gm_strcpy (menu->options[MENU_INPUT_BUTTONSTART].name,"Button START");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONSTART].sub_options[0].name,"A");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONSTART].sub_options[1].name,"B");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONSTART].sub_options[2].name,"X");     
      gm_strcpy (menu->options[MENU_INPUT_BUTTONSTART].sub_options[3].name,"Y");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONSTART].sub_options[4].name,"L");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONSTART].sub_options[5].name,"R");     
      gm_strcpy (menu->options[MENU_INPUT_BUTTONSTART].sub_options[6].name,"START");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONSTART].sub_options[7].name,"SELECT");     
    menu->options[MENU_INPUT_BUTTONSTART].num=8;
    menu->options[MENU_INPUT_BUTTONSTART].selected = 0;
   
    gm_strcpy (menu->options[MENU_INPUT_BUTTONSELECT].name,"Button SELECT");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONSELECT].sub_options[0].name,"A");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONSELECT].sub_options[1].name,"B");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONSELECT].sub_options[2].name,"X");     
      gm_strcpy (menu->options[MENU_INPUT_BUTTONSELECT].sub_options[3].name,"Y");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONSELECT].sub_options[4].name,"L");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONSELECT].sub_options[5].name,"R");     
      gm_strcpy (menu->options[MENU_INPUT_BUTTONSELECT].sub_options[6].name,"START");
      gm_strcpy (menu->options[MENU_INPUT_BUTTONSELECT].sub_options[7].name,"SELECT");     
    menu->options[MENU_INPUT_BUTTONSELECT].num=8;
    menu->options[MENU_INPUT_BUTTONSELECT].selected = 0;
   
    menu->num = MENU_INPUT_NUMENTRIES;
    menu->selected = 0;
    gm_strcpy(menu->title,"[Input]");
    precalc_menu(menu,0,0,1,3);
}