#include "snes9x.h"

#include "cossintab.h"

//#define _TESTING_

int16 *waterbuf[2];
int waterbufa,waterbufb;
char *original_img;


void InitWater(char *img)
{
	waterbuf[0]=(int16*)malloc(320*240*2);
	waterbuf[1]=(int16*)malloc(320*240*2);
	waterbufa=0;
	waterbufb=1;
	memset(waterbuf[0],0,320*240*2);
	memset(waterbuf[1],0,320*240*2);
	original_img=img;
	
	InitFixCosSin(1024);
}

void ReInitWater(void)
{
	waterbuf[0]=(int16*)malloc(320*240*2);
	waterbuf[1]=(int16*)malloc(320*240*2);
	waterbufa=0;
	waterbufb=1;
	memset(waterbuf[0],0,320*240*2);
	memset(waterbuf[1],0,320*240*2);
	
	InitFixCosSin(1024);
}


void CloseWater(void)
{
	FreeFixCosSin();
	free(waterbuf[0]);
	free(waterbuf[1]);	
}

void ProcessWater(int16 *source, int16 *dest)
{
	int i,j,k;
	k=1*240+239-1;
	for (i=1; i<319; i++,k+=238+240)
    for (j=1; j<239; j++,k--)	
    {    	
    	dest[k] = (
    	          ((source[k-1]+
                    source[k+1]+
                    source[k-240]+
                    source[k+240])  >>1) )	-dest[k];

        dest[k] -= (dest[k] >> 8);
    }
}

void RenderWater(int16 *oldbuffer,int16 *waterbuf,int16 *bgtexture)
{
	signed int x,y,Xoffset,Yoffset,Shading,r,v,b;
	int16 t;
	int k=1*240+239-1;
	for (x=1;x<319;x++,k+=238+240)
	for (y=1;y<239;y++,k--)
	{
		Shading = (waterbuf[k-240] - waterbuf[k+240]);//>>1;
		Xoffset = x+(Shading>>4);//3);
	    Yoffset = y+((waterbuf[k+1] - waterbuf[k-1])>>4);
		if (Xoffset<0) Xoffset=0;	    
		if (Yoffset<0) Yoffset=0;
		if (Xoffset>319) Xoffset=319;
		if (Yoffset>239) Yoffset=239;

	    t = bgtexture[Xoffset*240+239-Yoffset];
	    r=(t>>11)&31;
	    v=(t>>6)&31;
	    b=(t>>1)&31;
	    r+=Shading;v+=Shading;b+=Shading;
	    if (r<0) r=0;if (v<0) v=0;if (b<0) b=0;
	    if (r>31) r=31;if (v>31) v=31;if (b>31) b=31;
		oldbuffer[k]=(r<<11)|(v<<6)|(b<<1)|1;
	}
}

void UpdateWater(unsigned char *buffer)
{
#ifdef _TESTING_
	gm_memcpy(buffer,original_img,320*240*2);
	return;
#endif
	static int cpt=0;
	int offs;
	
	ProcessWater(waterbuf[waterbufa],waterbuf[waterbufb]);	
	RenderWater((int16*)buffer,waterbuf[waterbufb],(int16*)original_img);
	waterbufa^=1;
	waterbufb^=1;
						
	offs=(160+(fix_sin[(cpt*4)&1023]>>9))*240 + 
		239-(120+(fix_cos[cpt&1023]>>10));
	waterbuf[waterbufa][offs]=60;
	waterbuf[waterbufb][offs]=60;
	offs=(160+(fix_cos[(cpt*2)&1023]>>9))*240 + 
		239-(120+(fix_sin[(cpt*5)&1023]>>10));
	waterbuf[waterbufa][offs]=60;
	waterbuf[waterbufb][offs]=60;
	offs=(160-((fix_cos[(cpt)&1023]>>10)+(fix_cos[((cpt*2)+128)&1023]>>10)))*240 + 
	 (120+(fix_sin[(cpt*7)&1023]>>11)-(fix_sin[((cpt*4)+300)&1023]>>10));
	waterbuf[waterbufa][offs]=60;
	waterbuf[waterbufb][offs]=60;		
	offs=(160+((fix_cos[(cpt*3)&1023]>>11)-(fix_sin[((cpt)+128)&1023]>>9)))*240 + 
	 ( 120-((fix_sin[(cpt*5)&1023]>>10)+(fix_cos[((cpt*4)-100)&1023]>>11)));
	waterbuf[waterbufa][offs]=60;
	waterbuf[waterbufb][offs]=60;
	offs=(160+((fix_sin[(cpt*3)&1023]>>11)+(fix_sin[((cpt*5)+60)&1023]>>9)))*240 + 
	 ( 120-((fix_cos[(cpt*7)&1023]>>10)+(fix_cos[((cpt*2)-300)&1023]>>11)));
	waterbuf[waterbufa][offs]=60;
	waterbuf[waterbufb][offs]=60;
	offs=(160+((fix_sin[(cpt*2)&1023]>>11)-(fix_sin[((cpt*5)+100)&1023]>>10)+(fix_sin[((cpt*7)+200)&1023]>>10)))*240 + 
	 ( 120+((fix_sin[(cpt*3+300)&1023]>>10)+(fix_sin[((cpt*2+50)+100)&1023]>>11)));
	waterbuf[waterbufa][offs]=60;
	waterbuf[waterbufb][offs]=60;		
	offs=(160-((fix_cos[(cpt*3)&1023]>>10)-(fix_sin[((cpt*2)+100)&1023]>>10)+(fix_sin[((cpt*3)+200)&1023]>>11)))*240 + 
	 ( 120-((fix_sin[(cpt*5+150)&1023]>>10)+(fix_cos[((cpt*3-150)+100)&1023]>>11)));
	waterbuf[waterbufa][offs]=60;
	waterbuf[waterbufb][offs]=60;
		
	cpt++;		
}