 /*
  * filereq.h - GamePark 32 file requester declarations
  * Copyright (c)2002 Christian Nowak <chnowak@web.de>
  *
  *
  * This is free software; you can redistribute it and/or modify
  * it under the terms of the GNU General Public License as published by
  * the Free Software Foundation; either version 2 of the License, or
  * (at your option) any later version.
  *
  * It is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  * GNU General Public License for more details.
  *
  * You should have received a copy of the GNU General Public License
  * along with Foobar; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  */

#ifndef __FILEREQ_H__
#define __FILEREQ_H__



typedef struct FSEL
  {
    char * fname;                /* Pointer to a buffer which will be filled with the selected file's name */
    unsigned char *vbuffer;      /* Pointer to the GP32 surface which will be used for gfx output */
    unsigned int bgcolor,bgcolor2;       /* Background color */
    unsigned int dircolor;      /* Directory entry color */
    unsigned int filecolor;     /* File entry color */
    unsigned int dirselcolor;   /* Selected directory entry color */
    unsigned int fileselcolor;  /* Selected file entry color */
    unsigned int curdircolor;   /* Color of current directory display at the top of the screen */
    unsigned char bppmul;
  } FSEL;

int FileRequest ( FSEL * fsel, char * bdir, char enableCancel );
/* fsel: Pointer to an FSEL structure
 * bdir: Base directory
 * enableCancel: TRUE if the user should be able to cancel with the B button
 *
 * Functions returns 0 if everything is ok and -1 if an error occured or the 
 * user has canceled the file selector
 */

#endif

