 /*
  * gpfilereq.c - GamePark 32 file requester
  * Copyright (c)2002 Christian Nowak <chnowak@web.de>
  *
  *
  * This is free software; you can redistribute it and/or modify
  * it under the terms of the GNU General Public License as published by
  * the Free Software Foundation; either version 2 of the License, or
  * (at your option) any later version.
  *
  * It is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  * GNU General Public License for more details.
  *
  * You should have received a copy of the GNU General Public License
  * along with Foobar; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  */

#include "snes9x.h"
#include "gpfilereq.h"
#include "gp32_func.h"

#include "file_dialog.h"
extern uint16 *halfval;
extern unsigned char *vrambuffer,*currentbuffer,*listbuffer[3];

#include "special_file.h"
extern "C" {
}


#define FSEL_MIDDLE 8
#define BROWSER_VISIBLE_LINES 14

typedef struct FINFO
  {
    char name[42];
    int size;
    char isdir;
  } FINFO;
  
char *browser_bg_logo;

static char FileIsDir ( char * fname )
  {
    GPFILEATTR attr;

    if (GpFileAttr ( fname, &attr )!=SM_OK)
      return FALSE;

    return ((attr.attr&0x10)==0x10);
  }

static void DisplayEntries ( FSEL * fsel, FINFO ** pdirlist, int num_entries, int index )
  {
    int i;
    int screen_start,   /* x/8 position on screen to start rendering */
        index_start;    /* Index position in directory to start */

    if (index>=num_entries)
      index = 0;

    if (index>FSEL_MIDDLE)
      {
        index_start = index-FSEL_MIDDLE;
        screen_start = 0;
      }
    else
      {
        index_start = 0;
        screen_start = FSEL_MIDDLE-index;
      }

/*    for (i=320-1;i>=0;--i)
    for (int j=240-1;j>=0;--j)
    {
    	if (((i>>4)&1)^((j>>4)&1)) 
    	{
    		vrambuffer[(i*240+j)<<1] = (uint8)(fsel->bgcolor);
    		vrambuffer[((i*240+j)<<1)|1] = (uint8)(fsel->bgcolor>>8);
    	}
 	   	else 
 	   	{
 	   		vrambuffer[(i*240+j)<<1] = (uint8)(fsel->bgcolor2);
 	   		vrambuffer[((i*240+j)<<1)|1] = (uint8)(fsel->bgcolor2>>8);
 	   	}
    }*/
    
    gm_memcpy(vrambuffer,browser_bg_logo,320*240*2);
	DrawWindow2((char*)(vrambuffer), 18, 45, 300-20, 240-70 , COLOR_YELLOW,COLOR_ORANGE);
    
    
    for (i=0;(i+screen_start)<BROWSER_VISIBLE_LINES && (i+index_start)<num_entries;i++)
      {
        uint32 col;
        if ( pdirlist[index_start+i]->isdir )
          {
            /* Directory */
            sprintf ( fsel->fname, "<%s>", pdirlist[index_start+i]->name );
            col = (i+index_start)==index ? fsel->dirselcolor : fsel->dircolor;
          } else
          {
            /* Ordinary file */
            int j,k,l;
            char str[42];

            strcpy ( fsel->fname, pdirlist[index_start+i]->name );
            sprintf(str,"%d",pdirlist[index_start+i]->size);
            l = strlen(fsel->fname);
            k = 40-l-strlen(str);
            for (j=strlen(fsel->fname);j<k+l;j++)
              fsel->fname[j] = ' ';
            fsel->fname[j] = '\0';
            strcat(fsel->fname, str);

			if ((i+index_start)==index)
			{
            	col = fsel->fileselcolor;
            }
            else
            {
	            col = fsel->filecolor;
            }
          }
//        GpTextOut(NULL, fsel->gpDraw, 0, (1+i+screen_start)*16, fsel->fname, col);
			//if ((col != fsel->fileselcolor)&&(col != fsel->dirselcolor))
			if ((i+index_start)==index)
			  gp32_GpTextOut(vrambuffer,21,(i+screen_start)*12+50,fsel->fname, col,1);
			else
   			  gp32_GpTextOut(vrambuffer,21,(i+screen_start)*12+50,fsel->fname, col,0);
      }
  }

static void sortDirEntries ( FINFO ** pdirlist, int num )
  {
    int i,j;

    if (num<2)
      return;

    for (i=0;i<num;i++)
      {
        for (j=0;j<num-1;j++)
          {
            if (strcmp(pdirlist[j]->name, pdirlist[j+1]->name)>0)
              {
                FINFO * temp;
                temp = pdirlist[j];
                pdirlist[j] = pdirlist[j+1];
                pdirlist[j+1] = temp;
              }
          }
      }
  }

static int SelectFile ( FSEL * fsel, char * basedir, char enableCancel )
  {
    unsigned int i;
    unsigned int j,kk;
    int numdirs = 0;
    ulong num_entries;
    ulong read_count;
    int index = 0;
    int lk = 0,k;
    FINFO * dirlist;
    FINFO ** pdirlist;
    GPDIRENTRY * direntry;
    char p[256];
    char *pext;
   	char ext[5];
   	uint32 addentry;

/*    for (i=0;i<320*240*fsel->bppmul;++i)
      vrambuffer[i] = fsel->bgcolor;*/
    gm_memcpy(vrambuffer,browser_bg_logo,320*240*2);
//    GpTextOut(NULL, fsel->gpDraw, 80, 116, "Scanning directory...", fsel->filecolor);
	DrawWindow2((char*)(vrambuffer), 18, 45, 300-20, 240-70 , COLOR_YELLOW,COLOR_ORANGE);
	gp32_GpTextOut(vrambuffer,80,116,"Scanning directory...", fsel->filecolor|fsel->filecolor<<8,1);		
	FlipAndShow();


    /* Get directory */
    if ( GpDirEnumNum(basedir, &num_entries)!=SM_OK )
      return -1;
    if (num_entries==0)
      return -1;
      
      


    dirlist = (FINFO *)malloc ( num_entries*sizeof(FINFO) );
    memset ( dirlist, 0, sizeof(FINFO)*num_entries );
    pdirlist = (FINFO **)malloc ( num_entries*sizeof(FINFO*) );

    direntry = (GPDIRENTRY *)malloc ( sizeof(GPDIRENTRY)*num_entries );
    GpDirEnumList ( basedir, 0, num_entries, direntry, &read_count );
    num_entries = read_count;
    


	kk=0;
    for (i=0;i<num_entries;i++)
    if (strcmp("." , direntry[i].name))
      {
        addentry=1;
        strcpy ( dirlist[i].name, direntry[i].name );
        if ( /*(strcmp("." , direntry[i].name)==0) ||*/
             (strcmp("..", direntry[i].name)==0) ||
             FileIsDir(direntry[i].name) )
          {
            dirlist[i].isdir = TRUE;
            numdirs++;
            dirlist[i].size = -1;
          }
        else
          {
            ulong s = 0;
			j=strlen(direntry[i].name);            
       		if (j<4) addentry=0;            
            else
            {
	            pext = strrchr(direntry[i].name, '.');
				if (pext) 
				{
					strncpy(ext, pext, sizeof(ext));
					strlwr(ext);
				}
				else ext[0]=0;							
				if ( (strcmp(ext, ".smc") != 0)&&(strcmp(ext, ".fig") != 0)&&(strcmp(ext, ".1") != 0)&&(strcmp(ext, ".zip") != 0)&&(strcmp(ext, ".spc") != 0))
        		{   
        			addentry=0;
        		}
        		else
        		{ 
	            	GpFileGetSize ( direntry[i].name, &s );
            		dirlist[i].isdir = FALSE;
            		dirlist[i].size = (int)s;
            	}
            }
          }
        if (addentry) 
        {
        	pdirlist[kk++] = &dirlist[i];		  	
		}
      }

    

    free ( direntry );
    


	num_entries=kk;
	
	if (num_entries==0)
   	{      
      	return -1;
    }      
	
	
    /* Separate dirs from files */
    j=0;i=0;
    while (pdirlist[j]->isdir) 
    {
    	j++;
    	if (j==num_entries) break;
    }
    
    for (i=j;i<num_entries;i++)
      {
        if (pdirlist[i]->isdir)
          {
            FINFO * tmp = pdirlist[i];
            pdirlist[i] = pdirlist[j];
            pdirlist[j] = tmp;
            j++;
          }
      }
      
    /* Sort directories */
    sortDirEntries ( pdirlist, numdirs );
    /* Sort files */
    sortDirEntries ( &pdirlist[numdirs], num_entries-numdirs );
    
    
	/* look at entries if filename already available*/
	if (fsel->fname[0])
	{
		i=numdirs;
		while (i<num_entries)
		{
			if (!strcmp(fsel->fname,pdirlist[i]->name))
			{
				index=i;
				break;
			}
			i++;
		}
	}

    
    DisplayEntries ( fsel, pdirlist, num_entries, index );
    sprintf(p,"ROM File browser             RAM : %d",gm_availablesize());
	gp32_GpTextOut(vrambuffer,0,12,p, (31<<11)|(27<<6)|(20<<1)|1,1);
	GpRelativePathGet(p);
	gp32_GpTextOut(vrambuffer,0,28,p, fsel->curdircolor,1);	
	gp32_GpTextOut(vrambuffer,2,225,"START+SELECT to reboot",(31<<11)|(27<<6)|(20<<1)|1,1);
	FlipAndShow();
	
	
	
    while (GpKeyGet()&GPC_VK_FA); /* Wait until the A button is released */
    while (!  ( (k=GpKeyGet())&(GPC_VK_FA|GPC_VK_FB))  ) 
      {
        k &= GPC_VK_FL | GPC_VK_FR | GPC_VK_UP | GPC_VK_DOWN | GPC_VK_LEFT | GPC_VK_RIGHT | GPC_VK_START | GPC_VK_SELECT;
        
        //tempo wait
    	gp32_wait(150);
        
        if ((k&GPC_VK_START)&&(k&GPC_VK_SELECT)) GpAppExit();        

            if (k&GPC_VK_UP)
              index--;
            else
            if (k&GPC_VK_DOWN)
              index++;
            else
            if (k&GPC_VK_LEFT)
              index-=BROWSER_VISIBLE_LINES-1;
            else
            if (k&GPC_VK_RIGHT)
              index+=BROWSER_VISIBLE_LINES-1;

            if (index<0) index=0;//num_entries-1;
            if (index>=(int)num_entries) index=num_entries-1;//0;

            /* Display entries */
            if (k&(GPC_VK_UP|GPC_VK_DOWN|GPC_VK_LEFT|GPC_VK_RIGHT))
              {
                DisplayEntries ( fsel, pdirlist, num_entries, index );                
                sprintf(p,"ROM File browser             RAM : %d",gm_availablesize());
				gp32_GpTextOut(vrambuffer,0,12,p, (31<<11)|(27<<6)|(20<<1)|1,1);
				GpRelativePathGet(p);
				gp32_GpTextOut(vrambuffer,0,28,p,fsel->curdircolor,1);
				gp32_GpTextOut(vrambuffer,2,225,"START+SELECT to reboot",(31<<11)|(27<<6)|(20<<1)|1,1);
				FlipAndShow();				

              }
          }

    strcpy(fsel->fname, pdirlist[index]->name);
    free ( pdirlist );
    free ( dirlist );

    if ( enableCancel )
      return k&GPC_VK_FB ? -1 : 0;
    else
      return 0;
  }

int FileRequest ( FSEL * fsel, char * bdir, char enableCancel )
  {
    char * basedir;
    char isdir = FALSE;
    char *browser_bg_tmp;
    if (SF_LoadData(8,&browser_bg_tmp))
    {
    	browser_bg_logo=(char*)malloc(320*240*2);
    	int i;
    	for (i=0;i<320*240;i++)    	
    	    	((uint16*)browser_bg_logo)[i]=((rand()%15)<<1)|1;
    }
    else
    {
    	browser_bg_logo=(char*)malloc(320*240*2);
    	int i,j,r,v,b,k;
    	for (i=0;i<320;i++)
	    for (j=0;j<240;j++) 
	    {
	    	k=((uint16*)browser_bg_tmp)[i+j*320];
	    	r=(k>>11)&31;v=(k>>6)&31;b=(k>>1)&31;
	    	r>>=1;
	    	v>>=1;
	    	b>>=1;
/*		    if (((i>>4)&1)^((j>>4)&1)) 
		    {
		    	r=r*3/4;v=v*3/4;b=b*3/4;
		    }
		    else
		    {
			    r=r*2/4;v=v*2/4;b=b*2/4;
		    }		    */
	    	((uint16*)browser_bg_logo)[i*240+239-j]=(r<<11)|(v<<6)|(b<<1)|1;
	    }
	    free(browser_bg_tmp);
	    
    }
    
    halfval = (uint16*)malloc(65536*sizeof(uint16));	
	for (int i=0;i<65536;i++)
	{
		int r,v,b;
		r=((i>>11)>>2)+24;
		v=(((i>>6)&31)>>2)+24;
		b=(((i>>1)&31)>>2)+24;
		if (r>31) r=31;if (v>31) v=31;if (b>31) b=31;
		halfval[i]=(r<<11)|(v<<6)|(b<<1)|1;
	}
    
    basedir=bdir;
    if (!FileIsDir(basedir))
      {
        basedir="gp:\\gpmm";
        if (!FileIsDir(basedir))
          {
            basedir="gp:\\";
          }
      }
    GpRelativePathSet ( basedir );

    do
      {
        char path[256];
        if (SelectFile(fsel, "\\", enableCancel)!=0)
        { gm_free(browser_bg_logo);
        	gm_free(halfval);
          return -1;
        }
        GpRelativePathGet(path);
        if (strcmp(fsel->fname,"..")==0)
          {
            int i;
            int l=strlen(path);
            path[l-1]='0';
            for (i=l-2;i>0 && path[i]!='\\';i--)
              path[i]='\0';
            isdir=TRUE;
          } else
        if (strcmp(fsel->fname,".")==0)
          {
            isdir=TRUE;
          } else
          {
            if ((isdir=FileIsDir(fsel->fname)))
              strcat(path,fsel->fname);
          }

        if (isdir)
          GpRelativePathSet(path);
        GpRelativePathGet(path);
      } while (isdir);
     GpRelativePathGet(bdir);
     
    gm_free(browser_bg_logo);
    gm_free(halfval);
    return 0;
  }
