 /*
  * gpfilereq.c - GamePark 32 file requester
  * Copyright (c)2002 Christian Nowak <chnowak@web.de>
  *
  *
  * This is free software; you can redistribute it and/or modify
  * it under the terms of the GNU General Public License as published by
  * the free Software Foundation; either version 2 of the License, or
  * (at your option) any later version.
  *
  * It is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  * GNU General Public License for more details.
  *
  * You should have received a copy of the GNU General Public License
  * along with Foobar; if not, write to the free Software
  * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  */
  
/*
  Little John GP32
  Version 0.21
  adapted and enhanced by Yoyo  
  
  Last Update on 11th July 2003
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
//#include "defines.h"
#include "gpstdlib.h"
#include "gpgraphic.h"
#include "gpdef.h"
#include "gpstdio.h"
#include "gpfont.h"
#include "gpfilereq.h"

#include "unes_db.h"

#include "mygraphic.h"

#include "unes_crc32.h"

#define FSEL_MIDDLE 5

typedef struct FINFO
  {
    char name[42];
    char nes_name[42];
    int size;
    BOOL isdir;
  } FINFO;
  
static uint8 browserDBavailable;

static BOOL FileIsDir ( char * fname )
  {
    GPFILEATTR attr;

    if (GpFileAttr ( fname, &attr )!=SM_OK)
      return FALSE;

    return ((attr.attr&0x10)==0x10);
  }
  
static void sortDirEntries ( FINFO ** pdirlist, int num)
  {
    int i,j;
    char *a,*b;

    if (num<2)
      return;
    
    for (i=0;i<num;i++)
      {
        for (j=0;j<num-1;j++)
          {
          	if (pdirlist[j]->nes_name[0]) a=pdirlist[j]->nes_name ;
          	else a=pdirlist[j]->name;
          	if (pdirlist[j+1]->nes_name[0]) b=pdirlist[j+1]->nes_name;
          	else b=pdirlist[j+1]->name;
            if (strcmp(a, b)>0)
              {
                FINFO * temp;
                temp = pdirlist[j];
                pdirlist[j] = pdirlist[j+1];
                pdirlist[j+1] = temp;
              }
          }
      }
  }
  
 
static void AnalyzeRoms(FSEL *fsel,FINFO **pdirlist, int num_entries, int numdirs)
{
    int i,j;
    char p[256];
    for (i=0;i<num_entries;i++)
    {
        GpRectFill(NULL,&fsel->gpDraw[0], i*320/num_entries,240-16,320/num_entries+1, 16, 0);
        GpRectFill(NULL,&fsel->gpDraw[1], i*320/num_entries,240-16,320/num_entries+1, 16, 0);
	if ( !(pdirlist[i]->isdir))
	{	    	    
	    if (!strlen(pdirlist[i]->nes_name))
	    {	    	
	    	if (pdirlist[i]->size==0)
            	{
            		nestoy_info ninfo;
            		uint32 s;            		
            		char map[4];
            		Rom_GetCrc( pdirlist[i]->name ,&s);
            		
            		if (!dbmem_getinfo(s,0,&ninfo))
            	   	{
            	   	  memcpy(pdirlist[i]->nes_name,ninfo.title,30);
	            	  pdirlist[i]->nes_name[29]='-';
	            	  memcpy(pdirlist[i]->nes_name+30,ninfo.country,3);
	            	  pdirlist[i]->nes_name[33]='m';
	            	  for (j=30;j<33;j++) 	            	  	            	  	            	  
            	   	    if (!pdirlist[i]->nes_name[j]) pdirlist[i]->nes_name[j]='-';
	            	  
	            	  sprintf(map,"%03d",(ninfo.header1>>4)+(ninfo.header2&0xf0));
	            	  memcpy(pdirlist[i]->nes_name+34,map,3);
	            	  pdirlist[i]->nes_name[37]=0;
	            	  for (j=0;j<37;j++) 	            	  	            	  	            	  
            	   	    if (!pdirlist[i]->nes_name[j]) pdirlist[i]->nes_name[j]=' ';
            	   	}            	   		            	   	
            	   	else sprintf(pdirlist[i]->nes_name,"%s",pdirlist[i]->name);            	   	
            	   	pdirlist[i]->size=s;
            	}
	    }
	}
    }
    sortDirEntries ( &pdirlist[numdirs], num_entries-numdirs );

    sprintf(p," Speed : 133Mhz   Free memory : %d",gm_availablesize());
    GpRectFill(NULL,&fsel->gpDraw[0], 0,240-16,320, 16, 255);
    GpTextOut(NULL,&fsel->gpDraw[0],0,240-16,p,1);    
    GpRectFill(NULL,&fsel->gpDraw[1], 0,240-16,320, 16, 255);
    GpTextOut(NULL,&fsel->gpDraw[1],0,240-16,p,1);    
}


static uint8 ResyncFiles(FSEL *fsel,FINFO ***pdirlist, FINFO **dirlist,ulong *num_entries,char *basedir,int *num_dirs)
{
	ulong num_entriesBis,k;
	FINFO * dirlistBis;
	GPDIRENTRY * direntry;
	ulong read_count;
	unsigned int i;
    	unsigned int j;
    	FINFO ** pdirlistBis;
    	int addentry,numdirsBis = 0;
    	char *pext;
    	char ext[5];
    	
    	DrawMessage("Scanning directory...",0);
    	DrawMessage("Scanning directory...",1);
	
	/* Get directory */    	
    	if ( GpDirEnumNum(basedir, &num_entriesBis)!=SM_OK )
    	{    	    		
      		return 1;
     	}         	
    	if (num_entriesBis==0)
    	{	          		
      		return 2;
    	}
    	dirlistBis = malloc ( num_entriesBis*sizeof(FINFO) );
    	memset ( dirlistBis, 0, sizeof(FINFO)*num_entriesBis );    	
    	pdirlistBis = malloc ( num_entriesBis*sizeof(FINFO*) );	
    	direntry = malloc ( sizeof(GPDIRENTRY)*num_entriesBis );
    	GpDirEnumList ( basedir, 0, num_entriesBis, direntry, &read_count );
    	num_entriesBis = read_count;
    	k=0;
    	for (i=0;i<num_entriesBis;i++)
      	{      	
      		addentry=1;
        	strcpy ( dirlistBis[i].name, direntry[i].name );
        	dirlistBis[i].nes_name[0]=0;
        	if ( (strcmp("." , direntry[i].name)==0) || (strcmp("..", direntry[i].name)==0) || FileIsDir(direntry[i].name) )
          	{
            		dirlistBis[i].isdir = TRUE;
            		numdirsBis++;
            		dirlistBis[i].size = -1;       
          	}
        	else
          	{          	          	
            		uint32 s = 0;            
            		j=strlen(direntry[i].name);            
            		if (j<4) addentry=0;
            		else	
            		{            	
				pext = strrchr(direntry[i].name, '.');
				if (pext) {
				strncpy(ext, pext, sizeof(ext));
				}
				strlwr(ext);
				if ( (strcmp(ext, ".zip") != 0)&&(strcmp(ext, ".nes") != 0)&&(strcmp(ext, ".nsf") != 0))
            			{
           	   			addentry=0; 	
            			}
            			else
            			{            	   			
            	   			dirlistBis[i].isdir = FALSE;
            	   			dirlistBis[i].size = 0;             	   			
            			}
            		}
          	}         
        	if (addentry) pdirlistBis[k++] = &dirlistBis[i];
      	}        	
    	free ( direntry );
    	num_entriesBis=k;    
    	if (num_entriesBis==0)
    	{      
    		//TODO...
    		free(pdirlistBis);
    		free(dirlistBis);
      		return 3;
    	}      
    	/* Separate dirs from files */    	
    	j=0;i=0;
    	while (j<num_entriesBis&&pdirlistBis[j]->isdir) j++;        
    	for (i=j;i<num_entriesBis;i++)
      	{
        	if (pdirlistBis[i]->isdir)
          	{
            		FINFO * tmp = pdirlistBis[i];
            		pdirlistBis[i] = pdirlistBis[j];
            		pdirlistBis[j] = tmp;
            		j++;
          	}
      	}
    DrawMessage("Resyncing browsing cache...",0);
    DrawMessage("Resyncing browsing cache...",1);
        
    i=0;
    for (j=0;j<num_entriesBis;j++)
    if (!(pdirlistBis[j]->isdir))
    {
    	for (i=*num_dirs;i<*num_entries;i++)
    	  if (!strcmp((*pdirlist)[i]->name,pdirlistBis[j]->name))
    	  {
    	  	strcpy(pdirlistBis[j]->nes_name,(*pdirlist)[i]->nes_name);
    	  	pdirlistBis[j]->size=(*pdirlist)[i]->size;
    	  	break;
    	  }
    }
    
    /* Sort directories */
    sortDirEntries ( pdirlistBis, numdirsBis );
    /* Sort files */
    sortDirEntries ( &pdirlistBis[numdirsBis], num_entriesBis-numdirsBis );
    
    
    *num_entries=num_entriesBis;
    *num_dirs=numdirsBis;
    free(*pdirlist);
    free(*dirlist);
    *pdirlist=pdirlistBis;
    *dirlist=dirlistBis;
    return 0;
}

static uint8 DisplayEntries ( FSEL * fsel, FINFO ** pdirlist, int num_entries, int index , int searchName, int num_dirs)
  {
    int i;
    int screen_start,   /* x/8 position on screen to start rendering */
        index_start;    /* Index position in directory to start */
    int allcrc,resort;
     
    if (index>=num_entries)
      index = 0;

    if (index>FSEL_MIDDLE)
      {
        index_start = index-FSEL_MIDDLE;
        screen_start = 0;
      }
    else
      {
        index_start = 0;
        screen_start = FSEL_MIDDLE-index;
      }

    //for (i=(320*240)-1;i>=0;--i)
    //  &fsel->gpDraw[fsel->nflip]->ptbuffer[i] = fsel->bgcolor;
    //Cls(fsel->bgcolor,0);
    DrawWindow(2,32,314,240-38-16, fsel->nflip,90,94,152,86,81);
    
    if (searchName) 
    {
    	GpSurfaceFlip(&fsel->gpDraw[fsel->nflip]);    	
    }
 
    resort=0;
    allcrc=0;   
    for (i=0;(i+screen_start)<11 && (i+index_start)<num_entries;i++)
      {
        uint8 col;
        if ( pdirlist[index_start+i]->isdir )
          {
            /* Directory */
            sprintf ( fsel->fname, "<%s>", pdirlist[index_start+i]->name );
            col = (i+index_start)==index ? fsel->dirselcolor : fsel->dircolor;
          } else
          {
            /* Ordinary file */
            int j,k,l;
            //char str[40];

	   
	    if ((!strlen(pdirlist[index_start+i]->nes_name))&&(searchName))
	    {	    	
	    	if (pdirlist[index_start+i]->size==0)
            	{
            		nestoy_info ninfo;
            		uint32 s;            		
            		char map[4];
            		Rom_GetCrc( pdirlist[index_start+i]->name ,&s);
            		
            		if (!dbmem_getinfo(s,0,&ninfo))
            	   	{            	   	  
            	   	  memcpy(pdirlist[index_start+i]->nes_name,ninfo.title,30);
	            	  pdirlist[index_start+i]->nes_name[29]='-';
	            	  memcpy(pdirlist[index_start+i]->nes_name+30,ninfo.country,3);
	            	  pdirlist[index_start+i]->nes_name[33]='m';
	            	  for (j=30;j<33;j++) 	            	  	            	  	            	  
            	   	    if (!pdirlist[index_start+i]->nes_name[j]) pdirlist[index_start+i]->nes_name[j]='-';
	            	  
	            	  sprintf(map,"%03d",(ninfo.header1>>4)+(ninfo.header2&0xf0));
	            	  memcpy(pdirlist[index_start+i]->nes_name+34,map,3);
	            	  pdirlist[index_start+i]->nes_name[37]=0;
	            	  for (j=0;j<37;j++) 	            	  	            	  	            	  
            	   	    if (!pdirlist[index_start+i]->nes_name[j]) pdirlist[index_start+i]->nes_name[j]=' ';
            	   	    
            	   	  resort=1;
            	   	}            	   		            	   	
            	   	else sprintf(pdirlist[index_start+i]->nes_name,"%s",pdirlist[index_start+i]->name);            	   	
            	   	pdirlist[index_start+i]->size=s;
            	}
	    }
	    
	    if (pdirlist[index_start+i]->nes_name[0]) strcpy ( fsel->fname, pdirlist[index_start+i]->nes_name );
	    else 
	    {
	    	strcpy ( fsel->fname, pdirlist[index_start+i]->name );
	    	allcrc++;
	    }
	   	 
	    /*else
	    {
            	strcpy ( fsel->fname, pdirlist[index_start+i]->name );
            	sprintf(str,"%08X",pdirlist[index_start+i]->size);
            	l = strlen(fsel->fname);
            	k = 38-l-strlen(str);
            	for (j=strlen(fsel->fname);j<k+l;j++)
              	fsel->fname[j] = ' ';
            	fsel->fname[j] = '\0';
            	strcat(fsel->fname, str);
	    }*/
            col = (i+index_start)==index ? fsel->fileselcolor : fsel->filecolor;
          }
        //DrawMessageNoWin(0, (1+i+screen_start)*16, fsel->fname,fsel->nflip,col);
        if (col==fsel->fileselcolor) GpRectFill(NULL,&fsel->gpDraw[fsel->nflip], 6, (1+i+screen_start)*16+20,308, 16, fsel->bgfilecolor);
        if (col==fsel->dirselcolor) GpRectFill(NULL,&fsel->gpDraw[fsel->nflip], 6, (1+i+screen_start)*16+20,308, 16, fsel->bgdircolor);        
        GpTextOut(NULL, &fsel->gpDraw[fsel->nflip], 8, (1+i+screen_start)*16+20, fsel->fname, col);
      }
      
      if (resort) sortDirEntries ( &pdirlist[num_dirs], num_entries-num_dirs );
      return allcrc;
  }
  



static int SelectFile ( FSEL * fsel, char * basedir, BOOL enableCancel )
  {
    unsigned int i;
    unsigned int j;
    int numdirs = 0;
    ulong num_entries,k;
    ulong read_count;
    int index = 0;
    int lk = 0,addentry;
    FINFO * dirlist;
    FINFO ** pdirlist;
    GPDIRENTRY * direntry;
    char p[256];
    char *pext;
    char ext[5];
    F_HANDLE f;
    uint8 gotrom;
    long read;
    
    uint32 begTime,speK,dejaCRC;
    uint8 removecache;

    /*for (i=0;i<320*240;++i)
      (&fsel->gpDraw[fsel->nflip])->ptbuffer[i] = fsel->bgcolor;*/
    Cls(fsel->bgcolor,0);
    Cls(fsel->bgcolor,1);
    //GpTextOut(NULL, &fsel->gpDraw[fsel->nflip], 80, 116, "Scanning directory...", fsel->filecolor);
    DrawMessage("Scanning directory...",fsel->nflip^1);
    
    sprintf(p," Speed : 133Mhz   Free memory : %d",gm_availablesize());
    GpTextOut(NULL,&fsel->gpDraw[0],0,240-16,p,1);
    GpTextOut(NULL,&fsel->gpDraw[1],0,240-16,p,1);
    
    gotrom=0;
    GpRelativePathGet(p);
    sprintf(p,"%sljgp.cch",p);    
    if (GpFileOpen(p, OPEN_R, &f)==SM_OK)
    {    	
    	GpFileRead(f, &num_entries,4,&read);
    	GpFileRead(f, &numdirs,4,&read);
    	
    	dirlist = malloc ( num_entries*sizeof(FINFO) );	    	
    	memset ( dirlist, 0, sizeof(FINFO)*num_entries );
    	pdirlist = malloc ( num_entries*sizeof(FINFO*) );	    	
    	direntry = NULL;
    	for (i=0;i<num_entries;i++)
    	{
    		GpFileRead(f, &dirlist[i],sizeof(FINFO),&read);
    		pdirlist[i]=&dirlist[i];
    	}    	    	
    	GpFileClose(f);
    }
    else
    {
    	/* Get directory */
    	
    	if ( GpDirEnumNum(basedir, &num_entries)!=SM_OK )
    	{    	
      		return -1;
     	}    
     	
    	if (num_entries==0)
    	{	      
      		return -1;
    	}
    	dirlist = malloc ( num_entries*sizeof(FINFO) );
    	memset ( dirlist, 0, sizeof(FINFO)*num_entries );
    	pdirlist = malloc ( num_entries*sizeof(FINFO*) );	
    	direntry = malloc ( sizeof(GPDIRENTRY)*num_entries );
    	GpDirEnumList ( basedir, 0, num_entries, direntry, &read_count );
    	num_entries = read_count;            	    	    	    
    	k=0;    	
    	for (i=0;i<num_entries;i++)
      	{      	
      		addentry=1;
        	strcpy ( dirlist[i].name, direntry[i].name );
        	dirlist[i].nes_name[0]=0;
        	if ( (strcmp("." , direntry[i].name)==0) || (strcmp("..", direntry[i].name)==0) || FileIsDir(direntry[i].name) )
          	{
            		dirlist[i].isdir = TRUE;
            		numdirs++;
            		dirlist[i].size = -1;       
          	}
        	else
          	{          	          	
            		uint32 s = 0;            
            		j=strlen(direntry[i].name);            
            		if (j<4) addentry=0;
            		else	
            		{            	
				pext = strrchr(direntry[i].name, '.');
				if (pext) {
				strncpy(ext, pext, sizeof(ext));
				}
				strlwr(ext);
				if ( (strcmp(ext, ".zip") != 0)&&(strcmp(ext, ".nes") != 0)&&(strcmp(ext, ".nsf") != 0))
            			{
           	   			addentry=0; 	
            			}
            			else
            			{
            	   			//GpFileGetSize ( direntry[i].name, &s );            	   			            	   			
            	   			//Rom_GetCrc( direntry[i].name ,&s);
            	   			dirlist[i].isdir = FALSE;            	   			
            	   			dirlist[i].size = 0; //(int)s;    
            	   			/*if (s)
            	   			{
            	   				nestoy_info ninfo;
            	   				if (!db_getinfo(s,0,&ninfo))
            	   				{
            	   					memcpy(dirlist[i].nes_name,ninfo.title,40);
            	   					dirlist[i].nes_name[40]=0;
            	   				}
            	   			}*/
            	   			gotrom=1;
            			}
            		}
          	}         
        	if (addentry) pdirlist[k++] = &dirlist[i];        	
      	}        	
    	free ( direntry );
    	num_entries=k;    
    	if (num_entries==0)
    	{      
      		return -1;
    	}      
    	/* Separate dirs from files */    	
    	j=0;i=0;
    	while (j<num_entries&&pdirlist[j]->isdir) j++;        
    	for (i=j;i<num_entries;i++)
      	{
        	if (pdirlist[i]->isdir)
          	{
            		FINFO * tmp = pdirlist[i];
            		pdirlist[i] = pdirlist[j];
            		pdirlist[j] = tmp;
            		j++;
          	}
      	}                    	      	
     }
    	  
    
    /* Sort directories */
    sortDirEntries ( pdirlist, numdirs );    
    /* Sort files */
    sortDirEntries ( &pdirlist[numdirs], num_entries-numdirs );    	
    
    
    if (strlen(fsel->fname))
    {
    	i=numdirs;
    	while (i<num_entries)
    	{
    		if (!strcmp(fsel->fname,pdirlist[i]->name))
    		{
    			index=i;
    			break;
    		}
    		i++;
    	}
    }
    
    dejaCRC=DisplayEntries ( fsel, pdirlist, num_entries, index , 0,numdirs);
    GpRelativePathGet(p);
    
    DrawWindow(2,2,314,24, fsel->nflip,90,94,152,86,81);        
    GpTextOut(NULL,&fsel->gpDraw[fsel->nflip],8,4,p,fsel->curdircolor);
    
    // show & swap
    GpSurfaceFlip(&fsel->gpDraw[fsel->nflip]);
    fsel->nflip^=1;
    
    
    begTime = GpTickCountGet();
    speK=0;
    removecache=0;
    while (GpKeyGet()&GPC_VK_FA); /* Wait until the A button is released */
    while (!((k=GpKeyGet())&(GPC_VK_FA|(enableCancel?GPC_VK_FB:0))) )
      {	      	      	      	
      	if (k&GPC_VK_SELECT)
	{
		char *listchoix[5]={"Delete browser cache","Synchronize browser cache","Analyze cached roms","Credits","Reboot GP32"};
		uint32 exitwhile=0;
		memcpy(fsel->gpDraw[fsel->nflip].ptbuffer,fsel->gpDraw[fsel->nflip^1].ptbuffer,320*240);
		switch (InputListBox(5,listchoix,0))
		{
			case 0:
				GpRelativePathGet(p);      	
    				sprintf(p,"%sljgp.cch",p);    	
				GpFileRemove(p);
				index=0;
				removecache=1;
				exitwhile=1;
				break;
			case 1:				
				if (ResyncFiles(fsel,&pdirlist,&dirlist,&num_entries,basedir,&numdirs))
				{
					index=0;
					exitwhile=1;
				}
				break;
			case 2:
				if (browserDBavailable==0)
				{
					AnalyzeRoms(fsel,pdirlist,num_entries,numdirs);
					gotrom=1;
				}
				break;		
			case 3:			
      				GpSurfaceFlip(&fsel->gpDraw[fsel->nflip]);
				DrawMessage("[Little John GP32] v0.21 by Yoyo\n-------------\n"\
					    "Logo by Franck\n\n"\
					    "Uses parts of and inspired by\n"
					    "Shatbox, LJNG, FCA,\n"\
					    "Nester, NNNesterJ, NesterDC,\n"
					    "PocketNester, Nestopia\n\n"
					    "Please press a button",fsel->nflip);
				gpwait(0);	
				break;				  
			case 4:
				GpAppExit();			
		}				
		if (exitwhile) break;
		k=0;
		dejaCRC=DisplayEntries ( fsel, pdirlist, num_entries, index , 0,numdirs);
                GpRelativePathGet(p);
                DrawWindow(2,2,314,24, fsel->nflip,90,94,152,86,81);        
                GpTextOut(NULL,&fsel->gpDraw[fsel->nflip],8,4,p,fsel->curdircolor);                
                // show & swap
    		GpSurfaceFlip(&fsel->gpDraw[fsel->nflip]);
    		fsel->nflip^=1;
	}

      	
        k &= GPC_VK_UP | GPC_VK_DOWN | GPC_VK_FL | GPC_VK_FR | GPC_VK_START;
        
        Delay(200);
        

        //if (lk==0)
          //{
            if (k&GPC_VK_UP)
              index--;
            else
            if (k&GPC_VK_DOWN)
              index++;
            else
            if (k&GPC_VK_FL)
              index-=10;
            else
            if (k&GPC_VK_FR)
              index+=10;

            if (index<0) index=0;
            if (index>=(int)num_entries) index=num_entries-1;

            /* Display entries */
            if (k&(GPC_VK_UP|GPC_VK_DOWN|GPC_VK_FL|GPC_VK_FR))
              {
                dejaCRC=DisplayEntries ( fsel, pdirlist, num_entries, index , 0,numdirs);
                GpRelativePathGet(p);
                DrawWindow(2,2,314,24, fsel->nflip,90,94,152,86,81);        
                GpTextOut(NULL,&fsel->gpDraw[fsel->nflip],8,4,p,fsel->curdircolor);
                
                // show & swap
    		GpSurfaceFlip(&fsel->gpDraw[fsel->nflip]);
    		fsel->nflip^=1;
                
              }
              
        if (k&GPC_VK_START) 
      	{
      		//begTime = GpTickCountGet();
      		speK=1;
      	}
      	if ((!k)&&/*(GpTickCountGet()-begTime>2000)&&*/(speK)&&(dejaCRC)&&(browserDBavailable==0)) 
      	{      	
      		fsel->nflip=0;
      		GpSurfaceFlip(&fsel->gpDraw[fsel->nflip]);      		
      		dejaCRC=DisplayEntries ( fsel, pdirlist, num_entries, index , 1,numdirs);      		
      		DisplayEntries ( fsel, pdirlist, num_entries, index , 0,numdirs);
      		fsel->nflip=1;
      		DisplayEntries ( fsel, pdirlist, num_entries, index , 0,numdirs);
      		gotrom=1;      		
      		speK=0;
      	}
          //}

        lk = k;
      }
      
      
    if ((gotrom)&&(!removecache))
    {
    	DrawMessage("Saving browser info...",fsel->nflip^1);
    	GpRelativePathGet(p);      	
    	sprintf(p,"%sljgp.cch",p);    	
    	if (GpFileCreate(p, ALWAYS_CREATE, &f)==SM_OK)
    	{    		
    		GpFileWrite(f, &num_entries,4);
		GpFileWrite(f, &numdirs,4);
    		for (i=0;i<num_entries;i++)
	   			GpFileWrite(f, pdirlist[i], sizeof(FINFO));
    		GpFileClose(f);
    	}
    }

    strcpy(fsel->fname, pdirlist[index]->name);
    free ( pdirlist );
    free ( dirlist );

    if ( enableCancel )
      return k&GPC_VK_FB ? -1 : 0;
    else
      return 0;
  }

int FileRequest ( FSEL * fsel, char * bdir, BOOL enableCancel)
  {
    char * basedir;
    BOOL isdir = FALSE;
    char st[10];
    
    browserDBavailable=init_memdb();
    
    
    basedir=bdir;
    if (!FileIsDir(basedir))
      {
        basedir="gp:\\gpmm";
        if (!FileIsDir(basedir))
          {
            basedir="gp:\\";
          }
      }
    GpRelativePathSet ( basedir );
    
    fsel->nflip=0;
    GpSurfaceFlip(&fsel->gpDraw[fsel->nflip]);
    fsel->nflip^=1;

    do
      {
        char path[256];
        if (SelectFile(fsel, "\\", enableCancel)!=0)
        {
          free_memdb();
          return -1;
         }
        GpRelativePathGet(path);
        if (strcmp(fsel->fname,"..")==0)
          {
            int i;
            int l=strlen(path);
            path[l-1]='0';
            for (i=l-2;i>0 && path[i]!='\\';i--)
              path[i]='\0';
            isdir=TRUE;
          } else
        if (strcmp(fsel->fname,".")==0)
          {
            isdir=TRUE;
          } else
          {
            if ((isdir=FileIsDir(fsel->fname)))
              strcat(path,fsel->fname);
          }

        if (isdir)
          GpRelativePathSet(path);
        GpRelativePathGet(path);
      } while (isdir);
      
         
      
    free_memdb();
                
    return 0;
  }
