//#include "types.h"
#include "snes9x.h"
#include "file_dialog.h"

extern "C"
{
 #include "gfxlib.h"
 #include "bioslib.h"
 #include "gp32.h"
}


//#include "TZ_Lib.h"

extern unsigned char *vrambuffer,*currentbuffer,*listbuffer[3];
extern struct LCDinfo lcd;
extern uint16 *halfval;

//extern const unsigned short intro[76800];

void FlipAndShow(void)
{
  currentbuffer = vrambuffer;		  
  vrambuffer = swapBuffer(&lcd,3/*3*/);
}

/*void Cls_Menu(void)
{
  // Copie l'image de fond
//  gm_memcpy(vrambuffer, intro, 320*240*2);
}*/


void DrawMessage(char *s)
{
	int tw,th;
	tw=strlen(s)*7;
//	tw=GpTextWidthGet(s);
//	th=GpTextHeightGet(s);
	th=10;

    // fixe
//	tw=8;
//	th=9;

   DrawWindow( (GPC_LCD_WIDTH - (tw+20) )/2, (GPC_LCD_HEIGHT - (th+20) )/2, tw+20, th+20, COLOR_WHITE,COLOR_GRAY);

   gp32_GpTextOut(vrambuffer,GPC_LCD_WIDTH/2 - tw/2, GPC_LCD_HEIGHT/2 - th/2,
                              (char *)s,COLOR_WHITE,1);

}

void DrawError(char *s)
{
	int tw;
	int th;
	tw=7*strlen(s);
	//GpTextWidthGet(s);
//	th=GpTextHeightGet(s);
	th=10;
    // fixe
//	tw=8;
//	th=9;

   DrawWindow( (GPC_LCD_WIDTH - (tw+20) )/2, (GPC_LCD_HEIGHT - (th+20) )/2, tw+20, th+20, COLOR_RED,COLOR_DARKRED);
    gp32_GpTextOut(vrambuffer,GPC_LCD_WIDTH/2 - tw/2, GPC_LCD_HEIGHT/2 - th/2,  (char *)s,COLOR_WHITE,1);
}

// green 90,94,152,86,81
// red 224,240,241,192,160

void My_Fill_Half(int x, int y, int w, int h)
{
 int xx,yy;
 int a,b;

 a = x*240;
 b = 239-y;
 
 for (yy=0;yy<h;yy++)
 {
  for (xx=0;xx<w;xx++)
   {
    ((unsigned short *)vrambuffer)[a+xx*240 + b + (239-yy)]=halfval[((unsigned short *)vrambuffer)[a+xx*240 + b + (239-yy)]];
   }
 } 
}


void My_Fill(int x, int y, int w, int h, uint16 color)
{
 int xx,yy;
 int a,b,c;
 
 a = x*240;
 b = 239-y;
 
 for (yy=0;yy<h;yy++)
 {
   c = a + b + (239-yy);
  
  for (xx=0;xx<w;xx++)
   {
    ((unsigned short *)vrambuffer)[a+xx*240 + b + (239-yy)] = color;
   }
 } 
}


void DrawWindow(int x, int y, int lx, int ly, uint16 color,uint16 col2)
{
 int xx,yy;
 int a,b,c;

 a = x*240;
 b = 239-y;

 
 for (yy=0;yy<ly;yy++)
 {
   c = a + b + (239-yy);
  
  for (xx=0;xx<lx;xx++)
   {
    ((unsigned short *)vrambuffer)[xx*240 + c] =halfval[((unsigned short *)vrambuffer)[xx*240 + c]];    
   }
   ((unsigned short *)vrambuffer)[c] = color;
   ((unsigned short *)vrambuffer)[lx*240 + c] = color;
   ((unsigned short *)vrambuffer)[c+240-1] = col2;
   ((unsigned short *)vrambuffer)[lx*240 + c+240-1] = col2;
 } 

 
 for (xx=0;xx<lx;xx++)
 {
   ((unsigned short *)vrambuffer)[xx*240 + a + b + (239)] =color;
   ((unsigned short *)vrambuffer)[xx*240 + a + b + (239-ly)] =color;
   ((unsigned short *)vrambuffer)[xx*240 + a + b + (239)+240-1] =col2;
   ((unsigned short *)vrambuffer)[xx*240 + a + b + (239-ly)+240-1] =col2;
 }
 

}

void DrawWindowSlow(uint8 *buffer,int x, int y, int lx, int ly, uint16 color,uint16 col2)
{
 int xx,yy;
 int a,b,c;
 int col;

 a = x*240;
 b = 239-y;

 
 for (yy=0;yy<ly;yy++)
 {
   c = a + b + (239-yy);
  
  for (xx=0;xx<lx;xx++)
   {
    col=((unsigned short *)buffer)[xx*240 + c];
    ((unsigned short *)buffer)[xx*240 + c] =((col>>12)<<11)
    											|(((col>>7)&0xF)<<6)
    											|(((col>>2)&0xF)<<1)|1;
   }
   ((unsigned short *)buffer)[c] = color;
   ((unsigned short *)buffer)[lx*240 + c] = color;
   ((unsigned short *)buffer)[c+240-1] = col2;
   ((unsigned short *)buffer)[lx*240 + c+240-1] = col2;
 } 

 
 for (xx=0;xx<lx;xx++)
 {
   ((unsigned short *)buffer)[xx*240 + a + b + (239)] =color;
   ((unsigned short *)buffer)[xx*240 + a + b + (239-ly)] =color;
   ((unsigned short *)buffer)[xx*240 + a + b + (239)+240-1] =col2;
   ((unsigned short *)buffer)[xx*240 + a + b + (239-ly)+240-1] =col2;
 }
 

}


void DrawWindow2(char *vbuffer,int x, int y, int lx, int ly, uint16 color,uint16 col2)
{
 int xx,yy;
 int a,b,c;

 a = x*240;
 b = 239-y;

 
 for (yy=0;yy<ly;yy++)
 {
   c = a + b + (239-yy);
  
  for (xx=0;xx<lx;xx++)
   {
    ((unsigned short *)vbuffer)[xx*240 + c] =halfval[((unsigned short *)vbuffer)[xx*240 + c]];    
   }
   ((unsigned short *)vbuffer)[c] = color;
   ((unsigned short *)vbuffer)[lx*240 + c] = color;
   ((unsigned short *)vbuffer)[c+240-1] = col2;
   ((unsigned short *)vbuffer)[lx*240 + c+240-1] = col2;
 } 

 
 for (xx=0;xx<lx;xx++)
 {
   ((unsigned short *)vbuffer)[xx*240 + a + b + (239)] =color;
   ((unsigned short *)vbuffer)[xx*240 + a + b + (239-ly)] =color;
   ((unsigned short *)vbuffer)[xx*240 + a + b + (239)+240-1] =col2;
   ((unsigned short *)vbuffer)[xx*240 + a + b + (239-ly)+240-1] =col2;
 }
 

}


