#include "snes9x.h"
#include "3dngine.h"
#include "polyfiller.h"

#include "gp32_func.h"

#define SCREEN_MAX_X 319
#define SCREEN_MAX_Y 239

#define _env_map_shift 5

/*pointeurs sur les vars de la scene 3D pour acces local au polygoniseur*/
Vertex *poly_m_pVertices;
Triangle *poly_m_pTriangles;
int32 *poly_fix_div;
/*table de division en fixed point 8:24*/
int32 *poly_fix_div2;
/*index couleur pour le gouraud*/
uint16 col_gouraud[256];

#define COMPUTE_ORDER() \
	if (ypval[1]<ypval[0]) \
		{if (ypval[2]<ypval[1])       {/*3,2,1*/A=2;B=1;C=0;mid=0;} \
		 else {if (ypval[2]<ypval[0])	{/*2,3,1*/A=1;B=2;C=0;mid=1;} \
				        else{/*2,1,3*/A=1;B=0;C=2;mid=0;} \
			  } \
		} \
	else \
	{if (ypval[2]<ypval[0]){/*3,1,2*/ A=2;B=0;C=1;mid=1;} \
		else{if (ypval[2]<ypval[1]){/*1,3,2*/	A=0;B=2;C=1;mid=0;} \
			else{/*1,2,3*/A=0;B=1;C=2;mid=1;} \
		    } \
	} \
	ydeb=ypval[A]; \
	ymid=ypval[B]; \
	yfin=ypval[C]; \
	if ((ydeb>SCREEN_MAX_Y)||(yfin<0)) return; /*\
	if (mid) {if (xpval[B]>xpval[C]) return;} \
	else {if (xpval[C]>xpval[B]) return;}*/

#define FLAT_INNER() \
	xpDc=xpD>>_fixpoint_shifter; \
	xpGc=xpG>>_fixpoint_shifter; \
	if (xpGc<0) xpGc=0; \
	if (xpDc>SCREEN_MAX_X) xpDc=SCREEN_MAX_X; \
	if ((xpGc<=SCREEN_MAX_X)&&(xpDc>=0)) \
	{ \
		pBuffer = vbuffer + xpGc*240 + 239-yp; \
		for (xp=xpDc-xpGc;xp>=0;xp--,pBuffer+=240)			 \
			*pBuffer=col;\
	}
				
	
#define GOURAUD_INNER() \
	xpDc=xpD>>_fixpoint_shifter; \
	xpGc=xpG>>_fixpoint_shifter; \
	/*cincr=((int64)(cpD-cpG)*(int64)poly_fix_div[xpDc-xpGc])>>_fixpoint_shifter;*/ \
	SMULT1616(cincr,cpD-cpG,poly_fix_div[xpDc-xpGc]) \
	col=cpG;		 \
	if (xpGc<0) {col-=cincr*xpGc; xpGc=0;} \
	if (xpDc>SCREEN_MAX_X) xpDc=SCREEN_MAX_X; \
	if ((xpGc<=SCREEN_MAX_X)&&(xpDc>=0)) \
	{ \
		pBuffer = vbuffer + xpGc*240 + 239-yp; \
		for (xp=xpDc-xpGc;xp>=0;xp--,pBuffer+=240)	\
		{ \
			*pBuffer=col_g[(uint8)(col>>_fixpoint_shifter)]; \
			col+=cincr; \
		}			 \
	}
	
#define TEXTURE_INNER() \
	xpDc=xpD>>_fixpoint_shifter; \
	xpGc=xpG>>_fixpoint_shifter; \
	/*uincr=((int64)(uD-uG)*(int64)poly_fix_div[xpDc-xpGc])>>_fixpoint_shifter;*/ \
	/*vincr=((int64)(vD-vG)*(int64)poly_fix_div[xpDc-xpGc])>>_fixpoint_shifter;*/ \
	SMULT1616(uincr,(uD-uG),poly_fix_div[xpDc-xpGc]) \
	SMULT1616(vincr,(vD-vG),poly_fix_div[xpDc-xpGc]) \
	u=uG;		 \
	v=vG;		 \
	if (xpGc<0) {u-=uincr*xpGc;v-=vincr*xpGc; xpGc=0;} \
	if (xpDc>SCREEN_MAX_X) xpDc=SCREEN_MAX_X; \
	if ((xpGc<=SCREEN_MAX_X)&&(xpDc>=0)) \
	{ \
		pBuffer = vbuffer + xpGc*240 + 239-yp; \
		for (xp=xpDc-xpGc;xp>=0;xp--,pBuffer+=240)			 \
		{ \
			*pBuffer=(uint16)texture[((u>>_fixpoint_shifter)|((v>>_fixpoint_shifter)<<TEXTURE_SHIFT))]; \
			u+=uincr; \
			v+=vincr; \
		}			 \
	}

#define TEXTURE_COR_INNER() \
	xpDc=xpD>>_fixpoint_shifter; \
	xpGc=xpG>>_fixpoint_shifter; \
	/*uincr=((int64)(uD-uG)*(int64)poly_fix_div[xpDc-xpGc])>>_fixpoint_shifter;*/ \
	/*vincr=((int64)(vD-vG)*(int64)poly_fix_div[xpDc-xpGc])>>_fixpoint_shifter;*/ \
	/*izincr=((int64)(izD-izG)*(int64)poly_fix_div[xpDc-xpGc])>>_fixpoint_shifter;*/\
	SMULT1616(uincr,(uD-uG),poly_fix_div[xpDc-xpGc]) \
	SMULT1616(vincr,(vD-vG),poly_fix_div[xpDc-xpGc]) \
	SMULT1616(izincr,(izD-izG),poly_fix_div[xpDc-xpGc]) \
	u=uG;		 \
	v=vG;		 \
	iz=izG;      \
	if (xpGc<0) {u-=uincr*xpGc;v-=vincr*xpGc;iz-=izincr*xpGc;xpGc=0;} \
	if (xpDc>SCREEN_MAX_X) xpDc=SCREEN_MAX_X; \
	if ((xpGc<=SCREEN_MAX_X)&&(xpDc>=0)) \
	{ \
		pBuffer = vbuffer + xpGc*240 + 239-yp; \
		for (xp=xpDc-xpGc;xp>=0;xp--,pBuffer+=240)			 \
		{ \
			*pBuffer=texture[(\
			 (  ((u>>(_fixpoint_shifter-TEXTURE_SHIFT))*poly_fix_div2[iz>>_fixpoint_shifter])>>24 ) |\
			 ( (((v>>(_fixpoint_shifter-TEXTURE_SHIFT))*poly_fix_div2[iz>>_fixpoint_shifter])>>24 )<<TEXTURE_SHIFT))];\
			iz+=izincr; \
			u+=uincr; \
			v+=vincr; \
		}			 \
	}

#define DOUBLE_TEXTURE_INNER() \
	xpDc=xpD>>_fixpoint_shifter; \
	xpGc=xpG>>_fixpoint_shifter; \
	/*uincr=((int64)(uD-uG)*(int64)poly_fix_div[xpDc-xpGc])>>_fixpoint_shifter;*/ \
	/*vincr=((int64)(vD-vG)*(int64)poly_fix_div[xpDc-xpGc])>>_fixpoint_shifter;*/ \
	SMULT1616(uincr,(uD-uG),poly_fix_div[xpDc-xpGc]) \
	SMULT1616(vincr,(vD-vG),poly_fix_div[xpDc-xpGc]) \
	u=uG;		 \
	v=vG;		 \
	/*u2incr=((int64)(u2D-u2G)*(int64)poly_fix_div[xpDc-xpGc])>>_fixpoint_shifter;*/ \
	/*v2incr=((int64)(v2D-v2G)*(int64)poly_fix_div[xpDc-xpGc])>>_fixpoint_shifter;*/ \
	SMULT1616(u2incr,(u2D-u2G),poly_fix_div[xpDc-xpGc]) \
	SMULT1616(v2incr,(v2D-v2G),poly_fix_div[xpDc-xpGc]) \
	u2=u2G;		 \
	v2=v2G;		 \
	if (xpGc<0) {u-=uincr*xpGc;v-=vincr*xpGc; u2-=u2incr*xpGc;v2-=v2incr*xpGc; xpGc=0;} \
	if (xpDc>SCREEN_MAX_X) xpDc=SCREEN_MAX_X; \
	if ((xpGc<=SCREEN_MAX_X)&&(xpDc>=0)) \
	{ \
		pBuffer = vbuffer + xpGc*240 + 239-yp; \
		for (xp=xpDc-xpGc;xp>=0;xp--,pBuffer+=240)			 \
		{ \
			/* *pBuffer=(uint16)texture[((u>>_fixpoint_shifter)|((v>>_fixpoint_shifter)<<TEXTURE_SHIFT))];*/ \
			pix=(uint16)tex1[((u>>_fixpoint_shifter)|((v>>_fixpoint_shifter)<<TEXTURE_SHIFT))]; \
			col=(uint16)tex2[((u2>>_fixpoint_shifter)|((v2>>_fixpoint_shifter)<<TEXTURE_SHIFT))]; \
			cr=(pix>>11)+(col>>11)-8; \
			cv=((pix>>6)&31)+((col>>6)&31)-8; \
			cb=((pix>>1)&31)+((col>>1)&31)-8; \
			if (cr>31) cr=31; \
			if (cv>31) cv=31; \
			if (cb>31) cb=31; \
			if (cr<0) cr=0; \
			if (cv<0) cv=0; \
			if (cb<0) cb=0; \
			*pBuffer=(cr<<11)|(cv<<6)|(cb<<1)|1; \
			u+=uincr; \
			v+=vincr; \
			u2+=u2incr; \
			v2+=v2incr; \
		}			 \
	}


	
void swap(int32 &a,int32 &b)
{
	int32 tmp=a;
	a=b;
	b=tmp;
}	

int poly_init(Vertex *v,Triangle *t,int32 *fixdiv)
{
	//init some ptr to 3D structures	
	poly_m_pVertices=v;
	poly_m_pTriangles=t;
	//div tables
	poly_fix_div=fixdiv;	
	poly_fix_div2=(int32 *)malloc(65536*sizeof(int32));
	if (!poly_fix_div2) return 1;
	for (int32 i=0;i<65536;i++)
	{
		poly_fix_div2[i]=(1<<24)/(i+1);
	}
	//col init
	for (int32 i=0;i<31;i++)
	{
		int32 r,v,b;
		r=i*3;
		v=i*3;
		b=i;
		if (r>31) r=31;
		if (v>31) v=31;
		if (b>31) b=31;
		col_gouraud[31-i]=(r<<11)|(v<<6)|(b<<1)|1;		
		r=i;
		v=i/4;
		b=i/4;
		if (r>31) r=31;
		if (v>31) v=31;
		if (b>31) b=31;
		col_gouraud[32+31-i]=(r<<11)|(v<<6)|(b<<1)|1;		
		r=i*2;
		v=i/4;
		b=i/2;
		if (r>31) r=31;
		if (v>31) v=31;
		if (b>31) b=31;
		col_gouraud[64+31-i]=(r<<11)|(v<<6)|(b<<1)|1;		
		r=i*2;
		v=i;
		b=i/2;
		if (r>31) r=31;
		if (v>31) v=31;
		if (b>31) b=31;
		col_gouraud[96+31-i]=(r<<11)|(v<<6)|(b<<1)|1;		
		r=i*3;
		v=i;
		b=i*3/2;
		if (r>31) r=31;
		if (v>31) v=31;
		if (b>31) b=31;
		col_gouraud[128+31-i]=(r<<11)|(v<<6)|(b<<1)|1;		
		r=i*3;
		v=i*2;
		b=i;
		if (r>31) r=31;
		if (v>31) v=31;
		if (b>31) b=31;
		col_gouraud[160+31-i]=(r<<11)|(v<<6)|(b<<1)|1;
		
		r=i*5/3;
		v=i*4/3;
		b=i*2;
		if (r>31) r=31;
		if (v>31) v=31;
		if (b>31) b=31;
		col_gouraud[192+31-i]=(r<<11)|(v<<6)|(b<<1)|1;		
	}
	return 0;
}

void poly_deinit(void)
{
	free(poly_fix_div2);
}


void drawTriangle(int32 tri_index,uint16 idx_col,uint16 *vbuffer)
{
	int32 xpval[3],ypval[3],A,B,C;
	int32 i,j;	
	int32 ydeb,ymid,yfin,mid;	
	int32 xincrGdeb,xincrDdeb,xincrGfin,xincrDfin;
	int32 xpG,xpD,xp,yp,xpGc,xpDc;	
	
	uint16 col;
	uint16 *pBuffer;

	i=24+((poly_m_pTriangles[tri_index].m_NormalsTransformed[2])>>13);	
	if (i>31) i=31;
	if (i<1) i=1;
	col=col_gouraud[idx_col*32+i];
	
	xpval[0]=poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[0]].m_projected[0];
	ypval[0]=poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[0]].m_projected[1];
	xpval[1]=poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[1]].m_projected[0];
	ypval[1]=poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[1]].m_projected[1];
	xpval[2]=poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[2]].m_projected[0];
	ypval[2]=poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[2]].m_projected[1];	
			
	COMPUTE_ORDER()
		
	if (ydeb!=ymid) 
	{
		xincrGdeb=(xpval[C]-xpval[A])*poly_fix_div[yfin-ydeb-1];		
		xincrDdeb=(xpval[B]-xpval[A])*poly_fix_div[ymid-ydeb-1];
		xpG=xpD=xpval[A]<<_fixpoint_shifter;					
	}
	else
	{
		xpG=xpval[A]<<_fixpoint_shifter;					
		xpD=xpval[B]<<_fixpoint_shifter;
	}
	if (ymid!=yfin)
	{
		xincrGfin=(xpval[C]-xpval[A])*poly_fix_div[yfin-ydeb-1];
		xincrDfin=(xpval[C]-xpval[B])*poly_fix_div[yfin-ymid-1];
	}
	if (mid)
	{
		swap(xincrGdeb,xincrDdeb);
		swap(xincrGfin,xincrDfin);
		swap(xpG,xpD);
	}	
	

	if (yfin>SCREEN_MAX_Y) yfin=SCREEN_MAX_Y;
	if (ymid>SCREEN_MAX_Y) ymid=SCREEN_MAX_Y;
			
	if (ymid>0)	
	{
		if (ydeb<0)
		{
			xpG-=xincrGdeb*ydeb;
			xpD-=xincrDdeb*ydeb;
			ydeb=0;
		}
		for (yp=ydeb;yp<ymid;yp++)
		{
			FLAT_INNER()
			xpG+=xincrGdeb;
			xpD+=xincrDdeb;				
		}
	}
	else
	{		
		xpG+=xincrGdeb*(ymid-ydeb);
		xpD+=xincrDdeb*(ymid-ydeb);	
		xpG-=xincrGfin*ymid;
		xpD-=xincrDfin*ymid;	
		ymid=0;	
	}
	
	for (yp=ymid;yp<yfin;yp++)
	{
		FLAT_INNER()
		xpG+=xincrGfin;
		xpD+=xincrDfin;
	}
	
}

void drawTriangleGouraud(int32 tri_index,int32 ind_col,uint16 *vbuffer)
{
	int32 i,j;
	uint16 *col_g;
		
	int32 xpval[3],ypval[3],cpval[3],A,B,C;	
	int32 ydeb,ymid,yfin,mid;	
	int32 xincrGdeb,xincrDdeb,xincrGfin,xincrDfin;
	int32 xpG,xpD,xp,yp,xpGc,xpDc;
	int32 cincrGdeb,cincrDdeb,cincrGfin,cincrDfin;
	int32 cpG,cpD,cp,cincr,col;
	
	uint16 *pBuffer;

					
	col_g=(uint16*)(col_gouraud+(ind_col<<5));
	
	xpval[0]=poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[0]].m_projected[0];
	ypval[0]=poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[0]].m_projected[1];
	xpval[1]=poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[1]].m_projected[0];
	ypval[1]=poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[1]].m_projected[1];
	xpval[2]=poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[2]].m_projected[0];
	ypval[2]=poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[2]].m_projected[1];	
			
	COMPUTE_ORDER()
				
	cpval[0]=(poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[0]].m_transformednormal[2]>>(_fixpoint_shifter-5))+24;
	cpval[1]=(poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[1]].m_transformednormal[2]>>(_fixpoint_shifter-5))+24;
	cpval[2]=(poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[2]].m_transformednormal[2]>>(_fixpoint_shifter-5))+24;
	if (cpval[0]<0+1) cpval[0]=0+1;
	if (cpval[0]>31-1) cpval[0]=31-1;
	if (cpval[1]<0+1) cpval[1]=0+1;
	if (cpval[1]>31-1) cpval[1]=31-1;
	if (cpval[2]<0+1) cpval[2]=0+1;
	if (cpval[2]>31-1) cpval[2]=31-1;
	
	
	if (ydeb!=ymid) 
	{
		xincrGdeb=(xpval[C]-xpval[A])*poly_fix_div[yfin-ydeb-1];		
		xincrDdeb=(xpval[B]-xpval[A])*poly_fix_div[ymid-ydeb-1];
		xpG=xpD=xpval[A]<<_fixpoint_shifter;					
		cincrGdeb=(cpval[C]-cpval[A])*poly_fix_div[yfin-ydeb-1];		
		cincrDdeb=(cpval[B]-cpval[A])*poly_fix_div[ymid-ydeb-1];
		cpG=cpD=cpval[A]<<_fixpoint_shifter;					
	}
	else
	{
		xpG=xpval[A]<<_fixpoint_shifter;					
		xpD=xpval[B]<<_fixpoint_shifter;
		cpG=cpval[A]<<_fixpoint_shifter;					
		cpD=cpval[B]<<_fixpoint_shifter;
	}
	if (ymid!=yfin)
	{
		xincrGfin=(xpval[C]-xpval[A])*poly_fix_div[yfin-ydeb-1];
		xincrDfin=(xpval[C]-xpval[B])*poly_fix_div[yfin-ymid-1];
		cincrGfin=(cpval[C]-cpval[A])*poly_fix_div[yfin-ydeb-1];
		cincrDfin=(cpval[C]-cpval[B])*poly_fix_div[yfin-ymid-1];
	}
	if (mid)
	{
		swap(xincrGdeb,xincrDdeb);
		swap(xincrGfin,xincrDfin);
		swap(xpG,xpD);
		swap(cincrGdeb,cincrDdeb);
		swap(cincrGfin,cincrDfin);
		swap(cpG,cpD);
	}	
	

	if (yfin>SCREEN_MAX_Y) yfin=SCREEN_MAX_Y;
	if (ymid>SCREEN_MAX_Y) ymid=SCREEN_MAX_Y;
			
	if (ymid>0)	
	{
		if (ydeb<0)
		{
			xpG-=xincrGdeb*ydeb;
			xpD-=xincrDdeb*ydeb;
			cpG-=cincrGdeb*ydeb;
			cpD-=cincrDdeb*ydeb;
			ydeb=0;
		}
		for (yp=ydeb;yp<ymid;yp++)
		{
			GOURAUD_INNER()
			xpG+=xincrGdeb;
			xpD+=xincrDdeb;				
			cpG+=cincrGdeb;
			cpD+=cincrDdeb;				
		}
	}
	else
	{		
		xpG+=xincrGdeb*(ymid-ydeb);
		xpD+=xincrDdeb*(ymid-ydeb);	
		xpG-=xincrGfin*ymid;
		xpD-=xincrDfin*ymid;	
		cpG+=cincrGdeb*(ymid-ydeb);
		cpD+=cincrDdeb*(ymid-ydeb);	
		cpG-=cincrGfin*ymid;
		cpD-=cincrDfin*ymid;	
		ymid=0;	
	}
	
	for (yp=ymid;yp<yfin;yp++)
	{
		GOURAUD_INNER()	
		xpG+=xincrGfin;
		xpD+=xincrDfin;				
		cpG+=cincrGfin;
		cpD+=cincrDfin;				
	}
	
}


void drawTriangleTexture(int32 tri_index,int32 env_mapping,uint16 *vbuffer,uint16 *texture)
{
	int32 xpval[3],ypval[3],A,B,C;
	int32 uval[3],vval[3];
	int32 i,j;	
	int32 ydeb,ymid,yfin,mid;
	
	int32 xincrGdeb,xincrDdeb,xincrGfin,xincrDfin;
	int32 xpG,xpD,xp,yp,xpGc,xpDc;
	
	int32 uincrGdeb,uincrDdeb,uincrGfin,uincrDfin;
	int32 vincrGdeb,vincrDdeb,vincrGfin,vincrDfin;
	int32 uG,uD,u,uincr;
	int32 vG,vD,v,vincr;
	
	uint16 *pBuffer;
				
	xpval[0]=poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[0]].m_projected[0];
	ypval[0]=poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[0]].m_projected[1];
	xpval[1]=poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[1]].m_projected[0];
	ypval[1]=poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[1]].m_projected[1];
	xpval[2]=poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[2]].m_projected[0];
	ypval[2]=poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[2]].m_projected[1];	
				
	COMPUTE_ORDER()
				
	if (!env_mapping)
	{
		uval[0]=poly_m_pTriangles[tri_index].m_s[0];
		vval[0]=poly_m_pTriangles[tri_index].m_t[0];
		uval[1]=poly_m_pTriangles[tri_index].m_s[1];
		vval[1]=poly_m_pTriangles[tri_index].m_t[1];
		uval[2]=poly_m_pTriangles[tri_index].m_s[2];
		vval[2]=poly_m_pTriangles[tri_index].m_t[2];
	}
	else
	{
		uval[0]=(poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[0]].m_transformednormal[0]>>(_fixpoint_shifter-5))+32;
		if (uval[0]<2) uval[0]=2;
		if (uval[0]>TEXTURE_SIZE-2) uval[0]=TEXTURE_SIZE-2;
		vval[0]=(poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[0]].m_transformednormal[1]>>(_fixpoint_shifter-5))+32;
		if (vval[0]<2) vval[0]=2;
		if (vval[0]>TEXTURE_SIZE-2) vval[0]=TEXTURE_SIZE-2;
		uval[1]=(poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[1]].m_transformednormal[0]>>(_fixpoint_shifter-5))+32;
		if (uval[1]<2) uval[1]=2;
		if (uval[1]>TEXTURE_SIZE-2) uval[1]=TEXTURE_SIZE-2;
		vval[1]=(poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[1]].m_transformednormal[1]>>(_fixpoint_shifter-5))+32;
		if (vval[1]<2) vval[1]=2;
		if (vval[1]>TEXTURE_SIZE-2) vval[1]=TEXTURE_SIZE-2;
		uval[2]=(poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[2]].m_transformednormal[0]>>(_fixpoint_shifter-5))+32;
		if (uval[2]<2) uval[2]=2;
		if (uval[2]>TEXTURE_SIZE-2) uval[2]=TEXTURE_SIZE-2;
		vval[2]=(poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[2]].m_transformednormal[1]>>(_fixpoint_shifter-5))+32;
		if (vval[2]<2) vval[2]=2;
		if (vval[2]>TEXTURE_SIZE-2) vval[2]=TEXTURE_SIZE-2;
	}
	
	
	if (ydeb!=ymid) 
	{
		xincrGdeb=(xpval[C]-xpval[A])*poly_fix_div[yfin-ydeb-1];		
		xincrDdeb=(xpval[B]-xpval[A])*poly_fix_div[ymid-ydeb-1];
		xpG=xpD=xpval[A]<<_fixpoint_shifter;					
		uincrGdeb=(uval[C]-uval[A])*poly_fix_div[yfin-ydeb-1];		
		uincrDdeb=(uval[B]-uval[A])*poly_fix_div[ymid-ydeb-1];
		uG=uD=uval[A]<<_fixpoint_shifter;					
		vincrGdeb=(vval[C]-vval[A])*poly_fix_div[yfin-ydeb-1];		
		vincrDdeb=(vval[B]-vval[A])*poly_fix_div[ymid-ydeb-1];
		vG=vD=vval[A]<<_fixpoint_shifter;					
	}
	else
	{
		xpG=xpval[A]<<_fixpoint_shifter;					
		xpD=xpval[B]<<_fixpoint_shifter;
		uG=uval[A]<<_fixpoint_shifter;					
		uD=uval[B]<<_fixpoint_shifter;
		vG=vval[A]<<_fixpoint_shifter;					
		vD=vval[B]<<_fixpoint_shifter;
	}
	if (ymid!=yfin)
	{
		xincrGfin=(xpval[C]-xpval[A])*poly_fix_div[yfin-ydeb-1];
		xincrDfin=(xpval[C]-xpval[B])*poly_fix_div[yfin-ymid-1];
		uincrGfin=(uval[C]-uval[A])*poly_fix_div[yfin-ydeb-1];
		uincrDfin=(uval[C]-uval[B])*poly_fix_div[yfin-ymid-1];
		vincrGfin=(vval[C]-vval[A])*poly_fix_div[yfin-ydeb-1];
		vincrDfin=(vval[C]-vval[B])*poly_fix_div[yfin-ymid-1];
	}
	if (mid)
	{
		swap(xincrGdeb,xincrDdeb);
		swap(xincrGfin,xincrDfin);
		swap(xpG,xpD);
		swap(uincrGdeb,uincrDdeb);
		swap(uincrGfin,uincrDfin);
		swap(uG,uD);
		swap(vincrGdeb,vincrDdeb);
		swap(vincrGfin,vincrDfin);
		swap(vG,vD);
	}	
	

	if (yfin>SCREEN_MAX_Y) yfin=SCREEN_MAX_Y;
	if (ymid>SCREEN_MAX_Y) ymid=SCREEN_MAX_Y;
			
	if (ymid>0)	
	{
		if (ydeb<0)
		{
			xpG-=xincrGdeb*ydeb;
			xpD-=xincrDdeb*ydeb;
			uG-=uincrGdeb*ydeb;
			uD-=uincrDdeb*ydeb;
			vG-=vincrGdeb*ydeb;
			vD-=vincrDdeb*ydeb;
			ydeb=0;
		}
		for (yp=ydeb;yp<ymid;yp++)
		{
			TEXTURE_INNER()
			xpG+=xincrGdeb;
			xpD+=xincrDdeb;				
			uG+=uincrGdeb;
			uD+=uincrDdeb;				
			vG+=vincrGdeb;
			vD+=vincrDdeb;				
		}
	}
	else
	{		
		xpG+=xincrGdeb*(ymid-ydeb);
		xpD+=xincrDdeb*(ymid-ydeb);	
		xpG-=xincrGfin*ymid;
		xpD-=xincrDfin*ymid;	
		uG+=uincrGdeb*(ymid-ydeb);
		uD+=uincrDdeb*(ymid-ydeb);	
		uG-=uincrGfin*ymid;
		uD-=uincrDfin*ymid;	
		vG+=vincrGdeb*(ymid-ydeb);
		vD+=vincrDdeb*(ymid-ydeb);	
		vG-=vincrGfin*ymid;
		vD-=vincrDfin*ymid;
		ymid=0;	
	}
	
	for (yp=ymid;yp<yfin;yp++)
	{
		TEXTURE_INNER()	
		xpG+=xincrGfin;
		xpD+=xincrDfin;				
		uG+=uincrGfin;
		uD+=uincrDfin;				
		vG+=vincrGfin;
		vD+=vincrDfin;				
	}
	
}

void drawTriangleCorTexture(int32 tri_index,int env_mapping,uint16 *vbuffer,uint16 *texture)
{
	int32 xpval[3],ypval[3],A,B,C;
	int32 uval[3],vval[3],izval[3];
	int32 i,j;	
	int32 ydeb,ymid,yfin,mid;
	
	int32 xincrGdeb,xincrDdeb,xincrGfin,xincrDfin;
	int32 xpG,xpD,xp,yp,xpGc,xpDc;
	
	int32 uincrGdeb,uincrDdeb,uincrGfin,uincrDfin;
	int32 uG,uD,u,uincr;	
	int32 vincrGdeb,vincrDdeb,vincrGfin,vincrDfin;
	int32 vG,vD,v,vincr;
	int32 izincrGdeb,izincrDdeb,izincrGfin,izincrDfin;
	int32 izG,izD,iz,izincr;
	
	uint16 *pBuffer;

				
	xpval[0]=poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[0]].m_projected[0];
	ypval[0]=poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[0]].m_projected[1];
	xpval[1]=poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[1]].m_projected[0];
	ypval[1]=poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[1]].m_projected[1];
	xpval[2]=poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[2]].m_projected[0];
	ypval[2]=poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[2]].m_projected[1];	
					
	COMPUTE_ORDER()
	
	izval[0]=poly_fix_div[((poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[0]].m_transformed[2])>>_fixpoint_shifter)-1];
	izval[1]=poly_fix_div[((poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[1]].m_transformed[2])>>_fixpoint_shifter)-1];
	izval[2]=poly_fix_div[((poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[2]].m_transformed[2])>>_fixpoint_shifter)-1];
	
	if (!env_mapping)
	{
	
		uval[0]=((int64)(poly_m_pTriangles[tri_index].m_s[0])*(int64)izval[0])>>TEXTURE_SHIFT;
		vval[0]=((int64)(poly_m_pTriangles[tri_index].m_t[0])*(int64)izval[0])>>TEXTURE_SHIFT;
		uval[1]=((int64)(poly_m_pTriangles[tri_index].m_s[1])*(int64)izval[1])>>TEXTURE_SHIFT;
		vval[1]=((int64)(poly_m_pTriangles[tri_index].m_t[1])*(int64)izval[1])>>TEXTURE_SHIFT;
		uval[2]=((int64)(poly_m_pTriangles[tri_index].m_s[2])*(int64)izval[2])>>TEXTURE_SHIFT;
		vval[2]=((int64)(poly_m_pTriangles[tri_index].m_t[2])*(int64)izval[2])>>TEXTURE_SHIFT;
	}
	else
	{	
		uval[0]=(poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[0]].m_transformednormal[0]>>(_fixpoint_shifter-5))+32;
		if (uval[0]<2) uval[0]=2;
		if (uval[0]>TEXTURE_SIZE-2) uval[0]=TEXTURE_SIZE-2;
		vval[0]=(poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[0]].m_transformednormal[1]>>(_fixpoint_shifter-5))+32;
		if (vval[0]<2) vval[0]=2;
		if (vval[0]>TEXTURE_SIZE-2) vval[0]=TEXTURE_SIZE-2;
		uval[1]=(poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[1]].m_transformednormal[0]>>(_fixpoint_shifter-5))+32;
		if (uval[1]<2) uval[1]=2;
		if (uval[1]>TEXTURE_SIZE-2) uval[1]=TEXTURE_SIZE-2;
		vval[1]=(poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[1]].m_transformednormal[1]>>(_fixpoint_shifter-5))+32;
		if (vval[1]<2) vval[1]=2;
		if (vval[1]>TEXTURE_SIZE-2) vval[1]=TEXTURE_SIZE-2;
		uval[2]=(poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[2]].m_transformednormal[0]>>(_fixpoint_shifter-5))+32;
		if (uval[2]<2) uval[2]=2;
		if (uval[2]>TEXTURE_SIZE-2) uval[2]=TEXTURE_SIZE-2;
		vval[2]=(poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[2]].m_transformednormal[1]>>(_fixpoint_shifter-5))+32;
		if (vval[2]<2) vval[2]=2;
		if (vval[2]>TEXTURE_SIZE-2) vval[2]=TEXTURE_SIZE-2;	
		
		uval[0]=((int64)(uval[0])*(int64)izval[0])>>TEXTURE_SHIFT;
		vval[0]=((int64)(vval[0])*(int64)izval[0])>>TEXTURE_SHIFT;
		uval[1]=((int64)(uval[1])*(int64)izval[1])>>TEXTURE_SHIFT;
		vval[1]=((int64)(vval[1])*(int64)izval[1])>>TEXTURE_SHIFT;
		uval[2]=((int64)(uval[2])*(int64)izval[2])>>TEXTURE_SHIFT;
		vval[2]=((int64)(vval[2])*(int64)izval[2])>>TEXTURE_SHIFT;		
	}

	
	if (ydeb!=ymid) 
	{
		xincrGdeb=(xpval[C]-xpval[A])*poly_fix_div[yfin-ydeb-1];		
		xincrDdeb=(xpval[B]-xpval[A])*poly_fix_div[ymid-ydeb-1];
		xpG=xpD=xpval[A]<<_fixpoint_shifter;					
		uincrGdeb=(uval[C]-uval[A])*poly_fix_div[yfin-ydeb-1];		
		uincrDdeb=(uval[B]-uval[A])*poly_fix_div[ymid-ydeb-1];
		uG=uD=uval[A]<<_fixpoint_shifter;					
		vincrGdeb=(vval[C]-vval[A])*poly_fix_div[yfin-ydeb-1];		
		vincrDdeb=(vval[B]-vval[A])*poly_fix_div[ymid-ydeb-1];
		vG=vD=vval[A]<<_fixpoint_shifter;					
		izincrGdeb=(izval[C]-izval[A])*poly_fix_div[yfin-ydeb-1];		
		izincrDdeb=(izval[B]-izval[A])*poly_fix_div[ymid-ydeb-1];
		izG=izD=izval[A]<<_fixpoint_shifter;					
	}
	else
	{
		xpG=xpval[A]<<_fixpoint_shifter;					
		xpD=xpval[B]<<_fixpoint_shifter;
		uG=uval[A]<<_fixpoint_shifter;					
		uD=uval[B]<<_fixpoint_shifter;
		vG=vval[A]<<_fixpoint_shifter;					
		vD=vval[B]<<_fixpoint_shifter;
		izG=izval[A]<<_fixpoint_shifter;					
		izD=izval[B]<<_fixpoint_shifter;
	}
	if (ymid!=yfin)
	{
		xincrGfin=(xpval[C]-xpval[A])*poly_fix_div[yfin-ydeb-1];
		xincrDfin=(xpval[C]-xpval[B])*poly_fix_div[yfin-ymid-1];
		uincrGfin=(uval[C]-uval[A])*poly_fix_div[yfin-ydeb-1];
		uincrDfin=(uval[C]-uval[B])*poly_fix_div[yfin-ymid-1];
		vincrGfin=(vval[C]-vval[A])*poly_fix_div[yfin-ydeb-1];
		vincrDfin=(vval[C]-vval[B])*poly_fix_div[yfin-ymid-1];
		izincrGfin=(izval[C]-izval[A])*poly_fix_div[yfin-ydeb-1];
		izincrDfin=(izval[C]-izval[B])*poly_fix_div[yfin-ymid-1];
	}
	if (mid)
	{
		swap(xincrGdeb,xincrDdeb);
		swap(xincrGfin,xincrDfin);
		swap(xpG,xpD);
		swap(uincrGdeb,uincrDdeb);
		swap(uincrGfin,uincrDfin);
		swap(uG,uD);
		swap(vincrGdeb,vincrDdeb);
		swap(vincrGfin,vincrDfin);
		swap(vG,vD);
		swap(izincrGdeb,izincrDdeb);
		swap(izincrGfin,izincrDfin);
		swap(izG,izD);
	}	
	
	if (yfin>SCREEN_MAX_Y) yfin=SCREEN_MAX_Y;
	if (ymid>SCREEN_MAX_Y) ymid=SCREEN_MAX_Y;
	
	if (ymid>0)	
	{
		if (ydeb<0)
		{
			xpG-=xincrGdeb*ydeb;
			xpD-=xincrDdeb*ydeb;
			uG-=uincrGdeb*ydeb;
			uD-=uincrDdeb*ydeb;
			vG-=vincrGdeb*ydeb;
			vD-=vincrDdeb*ydeb;
			izG-=izincrGdeb*ydeb;
			izD-=izincrDdeb*ydeb;
			ydeb=0;
		}
		for (yp=ydeb;yp<ymid;yp++)
		{
			TEXTURE_COR_INNER()
			xpG+=xincrGdeb;
			xpD+=xincrDdeb;				
			uG+=uincrGdeb;
			uD+=uincrDdeb;				
			vG+=vincrGdeb;
			vD+=vincrDdeb;				
			izG+=izincrGdeb;
			izD+=izincrDdeb;
		}
	}
	else
	{		
		xpG+=xincrGdeb*(ymid-ydeb);
		xpD+=xincrDdeb*(ymid-ydeb);	
		xpG-=xincrGfin*ymid;
		xpD-=xincrDfin*ymid;	
		uG+=uincrGdeb*(ymid-ydeb);
		uD+=uincrDdeb*(ymid-ydeb);	
		uG-=uincrGfin*ymid;
		uD-=uincrDfin*ymid;	
		vG+=vincrGdeb*(ymid-ydeb);
		vD+=vincrDdeb*(ymid-ydeb);	
		vG-=vincrGfin*ymid;
		vD-=vincrDfin*ymid;
		izG+=izincrGdeb*(ymid-ydeb);
		izD+=izincrDdeb*(ymid-ydeb);	
		izG-=izincrGfin*ymid;
		izD-=izincrDfin*ymid;
		ymid=0;	
	}
	
	for (yp=ymid;yp<yfin;yp++)
	{
		TEXTURE_COR_INNER()	
		xpG+=xincrGfin;
		xpD+=xincrDfin;				
		uG+=uincrGfin;
		uD+=uincrDfin;				
		vG+=vincrGfin;
		vD+=vincrDfin;				
		izG+=izincrGfin;
		izD+=izincrDfin;				
	}

}

void drawTriangleDoubleTexture(int32 tri_index,uint16 *vbuffer,uint16 *tex1,uint16 *tex2)
{
	int32 xpval[3],ypval[3],A,B,C;
	int32 uval[3],vval[3],u2val[3],v2val[3];
	int32 i,j;	
	int32 ydeb,ymid,yfin,mid;
	
	int32 xincrGdeb,xincrDdeb,xincrGfin,xincrDfin;
	int32 xpG,xpD,xp,yp,xpGc,xpDc;
	
	int32 uincrGdeb,uincrDdeb,uincrGfin,uincrDfin;
	int32 vincrGdeb,vincrDdeb,vincrGfin,vincrDfin;
	int32 uG,uD,u,uincr;
	int32 vG,vD,v,vincr;
	int32 u2incrGdeb,u2incrDdeb,u2incrGfin,u2incrDfin;
	int32 v2incrGdeb,v2incrDdeb,v2incrGfin,v2incrDfin;
	int32 u2G,u2D,u2,u2incr;
	int32 v2G,v2D,v2,v2incr;
	uint16 col,pix;
	int32 cr,cv,cb;
	
	uint16 *pBuffer;
				
	xpval[0]=poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[0]].m_projected[0];
	ypval[0]=poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[0]].m_projected[1];
	xpval[1]=poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[1]].m_projected[0];
	ypval[1]=poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[1]].m_projected[1];
	xpval[2]=poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[2]].m_projected[0];
	ypval[2]=poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[2]].m_projected[1];	
				
	COMPUTE_ORDER()
				
	
	uval[0]=poly_m_pTriangles[tri_index].m_s[0];
	vval[0]=poly_m_pTriangles[tri_index].m_t[0];
	uval[1]=poly_m_pTriangles[tri_index].m_s[1];
	vval[1]=poly_m_pTriangles[tri_index].m_t[1];
	uval[2]=poly_m_pTriangles[tri_index].m_s[2];
	vval[2]=poly_m_pTriangles[tri_index].m_t[2];
	
	u2val[0]=(poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[0]].m_transformednormal[0]>>(_fixpoint_shifter-_env_map_shift))+32;
	if (u2val[0]<2) u2val[0]=2;
	if (u2val[0]>TEXTURE_SIZE-2) u2val[0]=TEXTURE_SIZE-2;
	v2val[0]=(poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[0]].m_transformednormal[1]>>(_fixpoint_shifter-_env_map_shift))+32;
	if (v2val[0]<2) v2val[0]=2;
	if (v2val[0]>TEXTURE_SIZE-2) v2val[0]=TEXTURE_SIZE-2;
	u2val[1]=(poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[1]].m_transformednormal[0]>>(_fixpoint_shifter-_env_map_shift))+32;
	if (u2val[1]<2) u2val[1]=2;
	if (u2val[1]>TEXTURE_SIZE-2) u2val[1]=TEXTURE_SIZE-2;
	v2val[1]=(poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[1]].m_transformednormal[1]>>(_fixpoint_shifter-_env_map_shift))+32;
	if (v2val[1]<2) v2val[1]=2;
	if (v2val[1]>TEXTURE_SIZE-2) v2val[1]=TEXTURE_SIZE-2;
	u2val[2]=(poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[2]].m_transformednormal[0]>>(_fixpoint_shifter-_env_map_shift))+32;
	if (u2val[2]<2) u2val[2]=2;
	if (u2val[2]>TEXTURE_SIZE-2) u2val[2]=TEXTURE_SIZE-2;
	v2val[2]=(poly_m_pVertices[poly_m_pTriangles[tri_index].m_vertexIndices[2]].m_transformednormal[1]>>(_fixpoint_shifter-_env_map_shift))+32;
	if (v2val[2]<2) v2val[2]=2;
	if (v2val[2]>TEXTURE_SIZE-2) v2val[2]=TEXTURE_SIZE-2;
	
	
	
	if (ydeb!=ymid) 
	{
		xincrGdeb=(xpval[C]-xpval[A])*poly_fix_div[yfin-ydeb-1];		
		xincrDdeb=(xpval[B]-xpval[A])*poly_fix_div[ymid-ydeb-1];
		xpG=xpD=xpval[A]<<_fixpoint_shifter;					
		uincrGdeb=(uval[C]-uval[A])*poly_fix_div[yfin-ydeb-1];		
		uincrDdeb=(uval[B]-uval[A])*poly_fix_div[ymid-ydeb-1];
		uG=uD=uval[A]<<_fixpoint_shifter;					
		vincrGdeb=(vval[C]-vval[A])*poly_fix_div[yfin-ydeb-1];		
		vincrDdeb=(vval[B]-vval[A])*poly_fix_div[ymid-ydeb-1];
		vG=vD=vval[A]<<_fixpoint_shifter;					
		
		u2incrGdeb=(u2val[C]-u2val[A])*poly_fix_div[yfin-ydeb-1];		
		u2incrDdeb=(u2val[B]-u2val[A])*poly_fix_div[ymid-ydeb-1];
		u2G=u2D=u2val[A]<<_fixpoint_shifter;					
		v2incrGdeb=(v2val[C]-v2val[A])*poly_fix_div[yfin-ydeb-1];		
		v2incrDdeb=(v2val[B]-v2val[A])*poly_fix_div[ymid-ydeb-1];
		v2G=v2D=v2val[A]<<_fixpoint_shifter;					
	}
	else
	{
		xpG=xpval[A]<<_fixpoint_shifter;					
		xpD=xpval[B]<<_fixpoint_shifter;
		uG=uval[A]<<_fixpoint_shifter;					
		uD=uval[B]<<_fixpoint_shifter;
		vG=vval[A]<<_fixpoint_shifter;					
		vD=vval[B]<<_fixpoint_shifter;
		
		u2G=u2val[A]<<_fixpoint_shifter;					
		u2D=u2val[B]<<_fixpoint_shifter;
		v2G=v2val[A]<<_fixpoint_shifter;					
		v2D=v2val[B]<<_fixpoint_shifter;
	}
	if (ymid!=yfin)
	{
		xincrGfin=(xpval[C]-xpval[A])*poly_fix_div[yfin-ydeb-1];
		xincrDfin=(xpval[C]-xpval[B])*poly_fix_div[yfin-ymid-1];
		uincrGfin=(uval[C]-uval[A])*poly_fix_div[yfin-ydeb-1];
		uincrDfin=(uval[C]-uval[B])*poly_fix_div[yfin-ymid-1];
		vincrGfin=(vval[C]-vval[A])*poly_fix_div[yfin-ydeb-1];
		vincrDfin=(vval[C]-vval[B])*poly_fix_div[yfin-ymid-1];
		
		u2incrGfin=(u2val[C]-u2val[A])*poly_fix_div[yfin-ydeb-1];
		u2incrDfin=(u2val[C]-u2val[B])*poly_fix_div[yfin-ymid-1];
		v2incrGfin=(v2val[C]-v2val[A])*poly_fix_div[yfin-ydeb-1];
		v2incrDfin=(v2val[C]-v2val[B])*poly_fix_div[yfin-ymid-1];
	}
	if (mid)
	{
		swap(xincrGdeb,xincrDdeb);
		swap(xincrGfin,xincrDfin);
		swap(xpG,xpD);
		swap(uincrGdeb,uincrDdeb);
		swap(uincrGfin,uincrDfin);
		swap(uG,uD);
		swap(vincrGdeb,vincrDdeb);
		swap(vincrGfin,vincrDfin);
		swap(vG,vD);
		
		swap(u2incrGdeb,u2incrDdeb);
		swap(u2incrGfin,u2incrDfin);
		swap(u2G,u2D);
		swap(v2incrGdeb,v2incrDdeb);
		swap(v2incrGfin,v2incrDfin);
		swap(v2G,v2D);
	}	
	

	if (yfin>SCREEN_MAX_Y) yfin=SCREEN_MAX_Y;
	if (ymid>SCREEN_MAX_Y) ymid=SCREEN_MAX_Y;
			
	if (ymid>0)	
	{
		if (ydeb<0)
		{
			xpG-=xincrGdeb*ydeb;
			xpD-=xincrDdeb*ydeb;
			uG-=uincrGdeb*ydeb;
			uD-=uincrDdeb*ydeb;
			vG-=vincrGdeb*ydeb;
			vD-=vincrDdeb*ydeb;
			
			u2G-=u2incrGdeb*ydeb;
			u2D-=u2incrDdeb*ydeb;
			v2G-=v2incrGdeb*ydeb;
			v2D-=v2incrDdeb*ydeb;
			ydeb=0;
		}
		for (yp=ydeb;yp<ymid;yp++)
		{
			DOUBLE_TEXTURE_INNER()
			xpG+=xincrGdeb;
			xpD+=xincrDdeb;				
			uG+=uincrGdeb;
			uD+=uincrDdeb;				
			vG+=vincrGdeb;
			vD+=vincrDdeb;				
			
			u2G+=u2incrGdeb;
			u2D+=u2incrDdeb;				
			v2G+=v2incrGdeb;
			v2D+=v2incrDdeb;				
		}
	}
	else
	{		
		xpG+=xincrGdeb*(ymid-ydeb);
		xpD+=xincrDdeb*(ymid-ydeb);	
		xpG-=xincrGfin*ymid;
		xpD-=xincrDfin*ymid;	
		uG+=uincrGdeb*(ymid-ydeb);
		uD+=uincrDdeb*(ymid-ydeb);	
		uG-=uincrGfin*ymid;
		uD-=uincrDfin*ymid;	
		vG+=vincrGdeb*(ymid-ydeb);
		vD+=vincrDdeb*(ymid-ydeb);	
		vG-=vincrGfin*ymid;
		vD-=vincrDfin*ymid;
		
		u2G+=u2incrGdeb*(ymid-ydeb);
		u2D+=u2incrDdeb*(ymid-ydeb);	
		u2G-=u2incrGfin*ymid;
		u2D-=u2incrDfin*ymid;	
		v2G+=v2incrGdeb*(ymid-ydeb);
		v2D+=v2incrDdeb*(ymid-ydeb);	
		v2G-=v2incrGfin*ymid;
		v2D-=v2incrDfin*ymid;
		ymid=0;	
	}
	
	for (yp=ymid;yp<yfin;yp++)
	{
		DOUBLE_TEXTURE_INNER()	
		xpG+=xincrGfin;
		xpD+=xincrDfin;				
		uG+=uincrGfin;
		uD+=uincrDfin;				
		vG+=vincrGfin;
		vD+=vincrDfin;				
		
		u2G+=u2incrGfin;
		u2D+=u2incrDfin;				
		v2G+=v2incrGfin;
		v2D+=v2incrDfin;				
	}
	
}
