#include "snes9x.h"
#include "ms3dLoader.h"
#include "math.h"

// offset des fichiers en fin de .Fxe
#include "special_file.h"
extern "C" {

}

uint8 LoadModel(int model/*char *filename*/,int *numVertices,int *numTriangles,int *numMeshes,
   Vertex *(*pVertices),Triangle *(*pTriangles),Mesh **pMeshes)
{	
	char *pBuffer;	
	char text[256];	
	
	if (SF_LoadData(model,&pBuffer)) return 1;
	
	const char *pPtr = pBuffer;
	MS3DHeader *pHeader = ( MS3DHeader* )pPtr;
	pPtr += sizeof_MS3DHeader;

	if ( strncmp( pHeader->m_ID, "MS3D000000", 10 ) != 0 )
		return 1; // "Not a valid Milkshape3D model file."
		
	if ( pHeader->m_version < 3 )
		return 2; // "Unhandled file version. Only Milkshape3D Version 1.3 and 1.4 is supported." );
		
	int nVertices = pPtr[0]|(pPtr[1]<<8); 
	*numVertices = nVertices;
	(*pVertices) = (Vertex *)malloc(nVertices*sizeof(Vertex));
	pPtr += sizeof( uint16 );
	
	int i;
	MS3DVertex tmpVertex;
	MS3DVertex *pVertex = &tmpVertex;
	for ( i = 0; i < nVertices; i++ )
	{

		memcpy(pVertex,pPtr,sizeof_MS3DVertex);		
		memcpy(pVertex->m_vertex,pPtr+1,12);

		(*pVertices)[i].m_boneID = pVertex->m_boneID;
		(*pVertices)[i].m_location[0] = int(pVertex->m_vertex[0]*65536);
		(*pVertices)[i].m_location[1] = int(pVertex->m_vertex[1]*65536);
		(*pVertices)[i].m_location[2] = -int(pVertex->m_vertex[2]*65536);
		
		(*pVertices)[i].m_normal[0]=(*pVertices)[i].m_normal[1]=(*pVertices)[i].m_normal[2]=0;
		
		pPtr += sizeof_MS3DVertex;
		
	}
	
	int nTriangles = pPtr[0]|(pPtr[1]<<8);
	*numTriangles = nTriangles;
	(*pTriangles) = (Triangle *)malloc(nTriangles*sizeof(Triangle));	
	pPtr += sizeof( uint16 );
	
	MS3DTriangle tmpTriangle;
	MS3DTriangle *pTriangle = &tmpTriangle;
	
	
//	S9xMessage(0,0,"Processing tri");
//	gp32_pause();
	int64 ux,uy,uz,vx,vy,vz,Nx,Ny,Nz,Norm;
	for ( i = 0; i < nTriangles; i++ )
	{

		memcpy(pTriangle,pPtr,sizeof_MS3DTriangle);
		
		int vertexIndices[3] = { pTriangle->m_vertexIndices[0], pTriangle->m_vertexIndices[1], pTriangle->m_vertexIndices[2] };
		//memcpy(pTriangle->m_vertexNormals,pPtr+8,9*4);		
		
		memcpy(pTriangle->m_s,pPtr+44,3*4);
		
		(*pTriangles)[i].m_t[0]=int(TEXTURE_SIZE*(pTriangle->m_s[0]))&TEXTURE_MASK;
		(*pTriangles)[i].m_t[1]=int(TEXTURE_SIZE*(pTriangle->m_s[1]))&TEXTURE_MASK;
		(*pTriangles)[i].m_t[2]=int(TEXTURE_SIZE*(pTriangle->m_s[2]))&TEXTURE_MASK;
		
		memcpy(pTriangle->m_t,pPtr+56,3*4);
		
		(*pTriangles)[i].m_s[0]=int(TEXTURE_SIZE*(1-pTriangle->m_t[0]))&TEXTURE_MASK;
		(*pTriangles)[i].m_s[1]=int(TEXTURE_SIZE*(1-pTriangle->m_t[1]))&TEXTURE_MASK;
		(*pTriangles)[i].m_s[2]=int(TEXTURE_SIZE*(1-pTriangle->m_t[2]))&TEXTURE_MASK;
		
		
		(*pTriangles)[i].m_vertexIndices[0]=vertexIndices[0];
		(*pTriangles)[i].m_vertexIndices[1]=vertexIndices[1];
		(*pTriangles)[i].m_vertexIndices[2]=vertexIndices[2];
		
		ux=(*pVertices)[(*pTriangles)[i].m_vertexIndices[2]].m_location[0]-(*pVertices)[(*pTriangles)[i].m_vertexIndices[0]].m_location[0];
		uy=(*pVertices)[(*pTriangles)[i].m_vertexIndices[2]].m_location[1]-(*pVertices)[(*pTriangles)[i].m_vertexIndices[0]].m_location[1];
		uz=(*pVertices)[(*pTriangles)[i].m_vertexIndices[2]].m_location[2]-(*pVertices)[(*pTriangles)[i].m_vertexIndices[0]].m_location[2];
		vx=(*pVertices)[(*pTriangles)[i].m_vertexIndices[1]].m_location[0]-(*pVertices)[(*pTriangles)[i].m_vertexIndices[0]].m_location[0];
		vy=(*pVertices)[(*pTriangles)[i].m_vertexIndices[1]].m_location[1]-(*pVertices)[(*pTriangles)[i].m_vertexIndices[0]].m_location[1];
		vz=(*pVertices)[(*pTriangles)[i].m_vertexIndices[1]].m_location[2]-(*pVertices)[(*pTriangles)[i].m_vertexIndices[0]].m_location[2];
		Nx=(uy*vz-uz*vy)>>_fixpoint_shifter;
		Ny=(uz*vx-ux*vz)>>_fixpoint_shifter;
		Nz=(ux*vy-uy*vx)>>_fixpoint_shifter;
		
		Norm=(Nx*Nx+Ny*Ny+Nz*Nz);
		Norm=sqrt((float)Norm)/65536;
		if (Norm>0)
		{
			(*pTriangles)[i].m_Normals[0]=Nx/Norm;
			(*pTriangles)[i].m_Normals[1]=Ny/Norm;
			(*pTriangles)[i].m_Normals[2]=Nz/Norm;
		}
		else
		{
			(*pTriangles)[i].m_Normals[0]=0;
			(*pTriangles)[i].m_Normals[1]=0;
			(*pTriangles)[i].m_Normals[2]=0;
		}
		for (int j=0;j<3;j++) 
		{	
			/*(*pTriangles)[i].m_vertexNormals[j][0]=int(65536*(pTriangle->m_vertexNormals[j][0]));
			(*pTriangles)[i].m_vertexNormals[j][1]=int(65536*(pTriangle->m_vertexNormals[j][1]));
			(*pTriangles)[i].m_vertexNormals[j][2]=-int(65536*(pTriangle->m_vertexNormals[j][2]));
			
			(*pVertices)[vertexIndices[j]].m_normal[0]+=(*pTriangles)[i].m_vertexNormals[j][0];
			(*pVertices)[vertexIndices[j]].m_normal[1]+=(*pTriangles)[i].m_vertexNormals[j][1];
			(*pVertices)[vertexIndices[j]].m_normal[2]+=(*pTriangles)[i].m_vertexNormals[j][2];*/
			(*pVertices)[vertexIndices[j]].m_normal[0]+=(*pTriangles)[i].m_Normals[0];
			(*pVertices)[vertexIndices[j]].m_normal[1]+=(*pTriangles)[i].m_Normals[1];
			(*pVertices)[vertexIndices[j]].m_normal[2]+=(*pTriangles)[i].m_Normals[2];
		}
		
		pPtr += sizeof_MS3DTriangle;
	}

//	S9xMessage(0,0,"Done");
//	gp32_pause();


	int nGroups = pPtr[0]|(pPtr[1]<<8);
	*numMeshes = nGroups;
	*pMeshes = (Mesh*)malloc(nGroups*sizeof(Mesh));
	pPtr += sizeof( uint16 );
	
//	sprintf(text,"Meshes nb : %d",nGroups);
//	S9xMessage(0,0,text);
//	gp32_pause();
	
	for ( i = 0; i < nGroups; i++ )
	{
		pPtr += sizeof( char );	// flags
		pPtr += 32;				// name

		uint16 nTriangles = pPtr[0]|(pPtr[1]<<8);			
		pPtr += sizeof( uint16 );
		int *pTriangleIndices = (int*)malloc(nTriangles*sizeof(int));						
		for ( int j = 0; j < nTriangles; j++ )
		{
			pTriangleIndices[j] = pPtr[0]|(pPtr[1]<<8);
			pPtr += sizeof( uint16 );
			
			(*pTriangles)[pTriangleIndices[j]].mesh=i;
			(*pVertices)[(*pTriangles)[pTriangleIndices[j]].m_vertexIndices[0]].mesh=i;
			(*pVertices)[(*pTriangles)[pTriangleIndices[j]].m_vertexIndices[1]].mesh=i;
			(*pVertices)[(*pTriangles)[pTriangleIndices[j]].m_vertexIndices[2]].mesh=i;
		}

		char materialIndex = *( char* )pPtr;
		pPtr += sizeof( char );
	
		(*pMeshes)[i].m_materialIndex = materialIndex;
		(*pMeshes)[i].m_numTriangles = nTriangles;
		(*pMeshes)[i].m_pTriangleIndices = pTriangleIndices;				
	
/*		sprintf(text,"Meshes nb : %d, Mat : %d",i,materialIndex);
		S9xMessage(0,0,text);
		gp32_pause();*/
	}
	
	for (i=0;i<*numVertices;i++)
	{
		int64 x,y,z;
		x=(*pVertices)[i].m_normal[0];
		y=(*pVertices)[i].m_normal[1];
		z=(*pVertices)[i].m_normal[2];
		x=(x*x+y*y+z*z);
		x=sqrt((float)x)/65536;
		if (x>0)
		{
			(*pVertices)[i].m_normal[0]=(*pVertices)[i].m_normal[0]/x;
			(*pVertices)[i].m_normal[1]=(*pVertices)[i].m_normal[1]/x;
			(*pVertices)[i].m_normal[2]=(*pVertices)[i].m_normal[2]/x;
		}
	}

	
	int32 *cx,*cy,*cz,*cvert;
	cx=(int32*)malloc((*numMeshes)*sizeof(int32));
	cy=(int32*)malloc((*numMeshes)*sizeof(int32));
	cz=(int32*)malloc((*numMeshes)*sizeof(int32));
	cvert=(int32*)malloc((*numMeshes)*sizeof(int32));
	
	for (i=0;i<(*numMeshes);i++)
	{
		cx[i]=cy[i]=cz[i]=cvert[i]=0;	
	}
	
	for (i=0;i<(*numVertices);i++)
	{
		if ((uint32)((*pVertices)[i].mesh)>=(*numMeshes)) (*pVertices)[i].mesh=0;
		else
		{
			cx[(*pVertices)[i].mesh]+=(*pVertices)[i].m_location[0];	
			cy[(*pVertices)[i].mesh]+=(*pVertices)[i].m_location[1];	
			cz[(*pVertices)[i].mesh]+=(*pVertices)[i].m_location[2];	
			cvert[(*pVertices)[i].mesh]++;
		}
	}
	
	for (i=0;i<(*numMeshes);i++)
	{		
		if (cvert[i]>0)
		{
			(*pMeshes)[i].m_center[0]=0*cx[i]/cvert[i];	
			(*pMeshes)[i].m_center[1]=0*cy[i]/cvert[i];	
			(*pMeshes)[i].m_center[2]=0*cz[i]/cvert[i];	
		}
		else
		{
			(*pMeshes)[i].m_center[0]=0;	
			(*pMeshes)[i].m_center[1]=0;	
			(*pMeshes)[i].m_center[2]=0;	
		}
		(*pMeshes)[i].m_position[0]=0;
		(*pMeshes)[i].m_position[1]=0;
		(*pMeshes)[i].m_position[2]=0;
	}
	
	free(cx);
	free(cy);
	free(cz);
	free(cvert);
	
	free(pBuffer);
//recreer manuellement coord de mapping pour mesh n j	
//en se basant les coords des points * 1<<k
	int j=0;
	int k;
	for (j=0;j<(*numMeshes);j++)
	{
		k=3;
		if ((model==0)&&(j<3)) k=5;
		for (i=0;i<(*pMeshes)[j].m_numTriangles;i++)
		{

	 		(*pTriangles)[(*pMeshes)[j].m_pTriangleIndices[i]].m_s[0]=(((*pVertices)[(*pTriangles)[(*pMeshes)[j].m_pTriangleIndices[i]].m_vertexIndices[0]].m_location[0])>>(_fixpoint_shifter-k))&TEXTURE_MASK;
 			(*pTriangles)[(*pMeshes)[j].m_pTriangleIndices[i]].m_s[1]=(((*pVertices)[(*pTriangles)[(*pMeshes)[j].m_pTriangleIndices[i]].m_vertexIndices[1]].m_location[0])>>(_fixpoint_shifter-k))&TEXTURE_MASK;
 			(*pTriangles)[(*pMeshes)[j].m_pTriangleIndices[i]].m_s[2]=(((*pVertices)[(*pTriangles)[(*pMeshes)[j].m_pTriangleIndices[i]].m_vertexIndices[2]].m_location[0])>>(_fixpoint_shifter-k))&TEXTURE_MASK;
	 		(*pTriangles)[(*pMeshes)[j].m_pTriangleIndices[i]].m_t[0]=(((*pVertices)[(*pTriangles)[(*pMeshes)[j].m_pTriangleIndices[i]].m_vertexIndices[0]].m_location[1])>>(_fixpoint_shifter-k))&TEXTURE_MASK;
	 		(*pTriangles)[(*pMeshes)[j].m_pTriangleIndices[i]].m_t[1]=(((*pVertices)[(*pTriangles)[(*pMeshes)[j].m_pTriangleIndices[i]].m_vertexIndices[1]].m_location[1])>>(_fixpoint_shifter-k))&TEXTURE_MASK;
	 		(*pTriangles)[(*pMeshes)[j].m_pTriangleIndices[i]].m_t[2]=(((*pVertices)[(*pTriangles)[(*pMeshes)[j].m_pTriangleIndices[i]].m_vertexIndices[2]].m_location[1])>>(_fixpoint_shifter-k))&TEXTURE_MASK;
		}
	}
	return 0;
}	
