#include "port.h"
#include <math.h>

int32 *fix_cos=NULL;
int32 *fix_sin=NULL;

#define PI 3.1415926535897932384626433832795

void InitFixCosSin(int size)
{
	int i;
	fix_cos=(int32*)gm_malloc(size*sizeof(int32));
	fix_sin=(int32*)gm_malloc(size*sizeof(int32));	
	for (i=0;i<size;i++)
	{
		fix_cos[i]=(65536*cos((double)i*2*PI/size));
		fix_sin[i]=(65536*sin((double)i*2*PI/size));
	}
}
void FreeFixCosSin(void)
{
	if (fix_cos) gm_free(fix_cos);
	if (fix_sin) gm_free(fix_sin);
}
