#ifndef __3dngine_h__
#define __3dngine_h__

#define _fixpoint_shifter 16

#define SCREEN_WIDTH_2 160
#define SCREEN_HEIGHT_2 120
#define SCREEN_CENTER_X 160
#define SCREEN_CENTER_Y 120

#define TEXTURE_SIZE 63
#define TEXTURE_MASK 63
#define TEXTURE_SHIFT 6

#define ZclipMin 4<<_fixpoint_shifter
#define ZclipMax 512<<_fixpoint_shifter /*max : int32 et fixed point sur 16, donc 31>>16 -> 15 -> 32767*/

int y3DEngine_Init(int model,int star);
int y3DEngine_Render(unsigned char*vbuffer,int *interact_mode);
void y3DEngine_RenderAuto(uint8 *vbuffer);
int y3DEngine_Close(void);

typedef struct MS3DHeader						// File Header
{
	char m_ID[10];
	int m_version;
} MS3DHeader;
#define sizeof_MS3DHeader 14

typedef struct MS3DVertex						// Vertex info
{	
	char m_flags;
    float m_vertex[3];
	char m_boneID;
	char m_refCount;
} MS3DVertex;
#define sizeof_MS3DVertex 15

typedef struct MS3DTriangle						// Triangle info
{
	uint16 m_flags;
	uint16 m_vertexIndices[3];
	float m_vertexNormals[3][3];
	float m_s[3], m_t[3];
	char m_smoothingGroup;
	char m_groupIndex;
} MS3DTriangle;
#define sizeof_MS3DTriangle 70

typedef struct MS3DMaterial						// Material info
{
    char m_name[32];
    float m_ambient[4];
    float m_diffuse[4];
    float m_specular[4];
    float m_emissive[4];
    float m_shininess;					// 0.0f - 128.0f
    float m_transparency;				// 0.0f - 1.0f
    char m_mode;						// 0, 1, 2 (unused now)
    char m_texture[128];
    char m_alphamap[128];
} MS3DMaterial;
#define sizeof_MS3DMaterial 361


typedef struct Mesh								//	Mesh struct
{
	int m_materialIndex;
	int m_numTriangles;
	int *m_pTriangleIndices;
	int32 m_center[3];
	int32 m_position[3];
} Mesh;

typedef struct Triangle							//	Triangle struct
{
	int32 m_Normals[3];
	uint8 m_s[3], m_t[3];
	int m_vertexIndices[3];
	int m_Z;
	int32 m_NormalsTransformed[3];
	int mesh;
} Triangle;

typedef struct Vertex							//	Vertex struct
{	
	int32 m_location[3];	
	int32 m_transformed[3];	
	int32 m_projected[2];
	int32 m_normal[3];
	int32 m_transformednormal[3];		
	char m_boneID;	
	int mesh;
} Vertex;


#endif

