#include "snes9x.h"

#include "3dngine.h"
#include "cossintab.h"
#include "polyfiller.h"
#include "ms3dLoader.h"
#include "math.h"
//#include "texture.h"


#include "gp32_func.h"

#include "special_file.h"
/*****************/
extern "C"
{
#include "gfxlib.h"
#include "bioslib.h"
#include "gp32.h"
}
/****************/

// some struct to import
extern struct LCDinfo lcd;
extern int32 gp32_timermul;
extern uint16 col_gouraud[256];

//y3DEngine vars
volatile int y3DE_FrameCpt;
int y3DE_frameRendered,y3DE_frameTime,y3DE_frameRate,y3DE_oldFrameCpt;
int y3DE_rendermode,y3DE_movemode;
int y3DE_keywaiter;	
int y3DE_ax,y3DE_ay,y3DE_az;
int32 y3DE_posX,y3DE_posY,y3DE_posZ;

//starfield var
#define _num_stars_ 4096
int y3DE_stars;
int *y3DE_st_X,*y3DE_st_Y,*y3DE_st_Z;
int y3DE_st_aX,y3DE_st_aY,y3DE_st_aZ;


//char *y3DE_bg_logo;

//Texture
uint16 *texture1,*texture2;
uint16 *texture_env1,*texture_env2;

//Model stuff
int m_numVertices;
int m_numTriangles;
int m_numMeshes;
Vertex *m_pVertices;
Triangle *m_pTriangles;
Mesh *m_pMeshes;

//Rendering stuff
uint32 *m_sortedTrianglesIndex;
int32 *m_sortedTrianglesZ;
int m_numTriangles2Draw;

uint32 *radixsortTab;
uint32 *radixsortPos[256];
uint32 radixsortDistrib[256];
uint32 *pradix;
int32 *fix_div;
uint16 *halfval,*minval;

void y3DEngine_timer(void) 
{	
	y3DE_FrameCpt++;	
}

int y3DEngine_Render(uint8 *vbuffer,int *interact_mode)
{
	char text[16];	
	int32 x,y,z,rx,ry,rz,px,py,pz,cx,cy,cz,t;
	int i,j,k,tmp;
	int32 xp,yp,zp;	
	int32 cosx,cosy,cosz,sinx,siny,sinz;
	
	int32 minZ,maxZ;	
	
	if (y3DE_stars)
	{
	//Rotation
		sinx = fix_sin[y3DE_st_aX];
		siny = fix_sin[y3DE_st_aY];
		sinz = fix_sin[y3DE_st_aZ];
		cosx = fix_cos[y3DE_st_aX];
		cosy = fix_cos[y3DE_st_aY];
		cosz = fix_cos[y3DE_st_aZ];
	for (i=0;i<_num_stars_;i++)
	{
		px=y3DE_st_X[i];
		py=y3DE_st_Y[i];
		pz=y3DE_st_Z[i];
		y3DE_st_Z[i]-=2<<16;
		if (y3DE_st_Z[i]<-(128<<16)) y3DE_st_Z[i]+=(256<<16);		

		/* Rotation autour de l'axe x'Ox */
		//t = ((int64)py*(int64)cosx - (int64)pz*(int64)sinx)>>16;
		SADDMULT1616(t,py,cosx,-pz,sinx)
		//pz = ((int64)py*(int64)sinx + (int64)pz*(int64)cosx)>>16;
		SADDMULT1616(pz,py,sinx,pz,cosx)
		py = t;
		/* Rotation autour de l'axe y'Oy */
		//t = ((int64)px*(int64)cosy + (int64)pz*(int64)siny)>>16;
		SADDMULT1616(t,px,cosy,pz,siny)
		//pz = ((int64)pz*(int64)cosy - (int64)px*(int64)siny)>>16;
		SADDMULT1616(pz,pz,cosy,-px,siny)
		px = t;
		/* Rotation autour de l'axe z'Oz */
		//t = ((int64)px*(int64)cosz - (int64)py*(int64)sinz)>>16;
		SADDMULT1616(t,px,cosz,-py,sinz)
		//py = ((int64)px*(int64)sinz + (int64)py*(int64)cosz)>>16;
		SADDMULT1616(py,px,sinz,py,cosz)
		px = t;
		
		if (pz>(8<<16)) //clipping
		{			
			xp=px*SCREEN_WIDTH_2/(pz) + SCREEN_CENTER_X;
			yp=-py*SCREEN_HEIGHT_2/(pz) + SCREEN_CENTER_Y;
			
			if ((xp>0)&&(yp>0)&&(xp<319)&&(yp<239))
			{
				zp=(pz>>(_fixpoint_shifter+2));
				if (zp>31) zp=31;
				((uint16*)vbuffer)[xp*240+239-yp]=col_gouraud[192|zp];
				zp+=2;if (zp>31) zp=31;
				((uint16*)vbuffer)[xp*240+239-yp+1]=col_gouraud[192|zp];
				((uint16*)vbuffer)[xp*240+239-yp-1]=col_gouraud[192|zp];
				((uint16*)vbuffer)[xp*240+239-yp+240]=col_gouraud[192|zp];
				((uint16*)vbuffer)[xp*240+239-yp-240]=col_gouraud[192|zp];
			}
		}
	}
	y3DE_st_aX=(y3DE_FrameCpt/3)&1023;
	y3DE_st_aY=(y3DE_FrameCpt)&1023;
	y3DE_st_aZ=(-y3DE_FrameCpt*2/3)&1023;
	}
	
	
	//Rotation
		sinx = fix_sin[y3DE_ax];
		siny = fix_sin[y3DE_ay];
		sinz = fix_sin[y3DE_az];
		cosx = fix_cos[y3DE_ax];
		cosy = fix_cos[y3DE_ay];
		cosz = fix_cos[y3DE_az];
	for (i=0;i<m_numVertices;i++)
	{
		x=m_pVertices[i].m_location[0];
		y=m_pVertices[i].m_location[1];
		z=m_pVertices[i].m_location[2];			
		
		
		cx=m_pMeshes[m_pVertices[i].mesh].m_center[0];
		cy=m_pMeshes[m_pVertices[i].mesh].m_center[1];
		cz=m_pMeshes[m_pVertices[i].mesh].m_center[2];
		
		/* 1re translation pour amener le "centre"  l'origine */
		px = x - cx;
		py = y - cy;
		pz = z - cz;
		/* Rotation autour de l'axe x'Ox */
		//t = (py*cosx - pz*sinx)>>16;
		SADDMULT1616(t,py,cosx,-pz,sinx)
		//pz = (py*sinx + pz*cosx)>>16;
		SADDMULT1616(pz,py,sinx,pz,cosx)
		py = t;
		/* Rotation autour de l'axe y'Oy */
		//t = (px*cosy + pz*siny)>>16;
		SADDMULT1616(t,px,cosy,pz,siny)
		//pz = (pz*cosy - px*siny)>>16;
		SADDMULT1616(pz,pz,cosy,-px,siny)
		px = t;
		/* Rotation autour de l'axe z'Oz */
		//t = (px*cosz - py*sinz)>>16;
		SADDMULT1616(t,px,cosz,-py,sinz)
		//py = (px*sinz + py*cosz)>>16;
		SADDMULT1616(py,px,sinz,py,cosz)
		px = t;
		
		/* Translation pour ramener le centre  sa place */
		/* + translation mouvement */
		rx = px + cx - y3DE_posX;
		ry = py + cy - y3DE_posY;
		rz = pz + cz - y3DE_posZ;
		
		m_pVertices[i].m_transformed[0]=rx;
		m_pVertices[i].m_transformed[1]=ry;
		m_pVertices[i].m_transformed[2]=rz;
		
		if ((rz>ZclipMin)&&(rz<ZclipMax))
		{			
			xp=rx*SCREEN_WIDTH_2/(rz) + SCREEN_CENTER_X;
			yp=-ry*SCREEN_HEIGHT_2/(rz) + SCREEN_CENTER_Y;
			//				xp=((int64)rx*SCREEN_WIDTH_2*(int64)fix_div24[rz>>_fixpoint_shifter]>>(_fixpoint_shifter*2)) + SCREEN_CENTER_X;
			//				yp=((int64)ry*SCREEN_HEIGHT_2*(int64)fix_div24[rz>>_fixpoint_shifter]>>(_fixpoint_shifter*2)) + SCREEN_CENTER_Y;
			
			m_pVertices[i].m_projected[0]=xp;
			m_pVertices[i].m_projected[1]=yp;			
		}
	}
	
	
	//Rotation
		sinx = fix_sin[y3DE_ax];
		siny = fix_sin[y3DE_ay];
		sinz = fix_sin[y3DE_az];
		cosx = fix_cos[y3DE_ax];
		cosy = fix_cos[y3DE_ay];
		cosz = fix_cos[y3DE_az];
	for (i=0;i<m_numVertices;i++)
	{
		x=m_pVertices[i].m_normal[0];
		y=m_pVertices[i].m_normal[1];
		z=m_pVertices[i].m_normal[2];
		
		
		
		/* 1re translation pour amener le "centre"  l'origine */		
		px = x ;
		py = y ;
		pz = z ;
		/* Rotation autour de l'axe x'Ox */
		//t = (py*cosx - pz*sinx)>>16;
		SADDMULT1616(t,py,cosx,-pz,sinx)
		//pz = (py*sinx + pz*cosx)>>16;
		SADDMULT1616(pz,py,sinx,pz,cosx)
		py = t;
		/* Rotation autour de l'axe y'Oy */
		//t = (px*cosy + pz*siny)>>16;
		SADDMULT1616(t,px,cosy,pz,siny)
		//pz = (pz*cosy - px*siny)>>16;
		SADDMULT1616(pz,pz,cosy,-px,siny)
		px = t;
		/* Rotation autour de l'axe z'Oz */
		//t = (px*cosz - py*sinz)>>16;
		SADDMULT1616(t,px,cosz,-py,sinz)
		//py = (px*sinz + py*cosz)>>16;
		SADDMULT1616(py,px,sinz,py,cosz)
		px = t;
		
		/* Translation pour ramener le centre  sa place */
		rx = px;
		ry = py;
		rz = pz;
		
		m_pVertices[i].m_transformednormal[0]=rx;
		m_pVertices[i].m_transformednormal[1]=ry;
		m_pVertices[i].m_transformednormal[2]=rz;
	}
	
	
	//Rotation			
		sinx = fix_sin[y3DE_ax];
		siny = fix_sin[y3DE_ay];
		sinz = fix_sin[y3DE_az];
		cosx = fix_cos[y3DE_ax];
		cosy = fix_cos[y3DE_ay];
		cosz = fix_cos[y3DE_az];
	for (i=0;i<m_numTriangles;i++)
	{			
		x=m_pTriangles[i].m_Normals[0];//+m_pTriangles[i].m_vertexNormals[1][0]+m_pTriangles[i].m_vertexNormals[2][0];
		y=m_pTriangles[i].m_Normals[1];//+m_pTriangles[i].m_vertexNormals[1][1]+m_pTriangles[i].m_vertexNormals[2][1]);
		z=m_pTriangles[i].m_Normals[2];//+m_pTriangles[i].m_vertexNormals[1][2]+m_pTriangles[i].m_vertexNormals[2][2];
		
		
		
		// 1re translation pour amener le "centre"  l'origine 
		px = x;
		py = y;
		pz = z;
		/* Rotation autour de l'axe x'Ox */
		//t = (py*cosx - pz*sinx)>>16;
		SADDMULT1616(t,py,cosx,-pz,sinx)
		//pz = (py*sinx + pz*cosx)>>16;
		SADDMULT1616(pz,py,sinx,pz,cosx)
		py = t;
		/* Rotation autour de l'axe y'Oy */
		//t = (px*cosy + pz*siny)>>16;
		SADDMULT1616(t,px,cosy,pz,siny)
		//pz = (pz*cosy - px*siny)>>16;
		SADDMULT1616(pz,pz,cosy,-px,siny)
		px = t;
		/* Rotation autour de l'axe z'Oz */
		//t = (px*cosz - py*sinz)>>16;
		SADDMULT1616(t,px,cosz,-py,sinz)
		//py = (px*sinz + py*cosz)>>16;
		SADDMULT1616(py,px,sinz,py,cosz)
		px = t;
		// Translation pour ramener le centre  sa place
		rx = px;
		ry = py;
		rz = pz;
		
		m_pTriangles[i].m_NormalsTransformed[0]=rx;
		m_pTriangles[i].m_NormalsTransformed[1]=ry;
		m_pTriangles[i].m_NormalsTransformed[2]=rz;
		
	}
	
	m_numTriangles2Draw=0;				
	for (int i=0;i<m_numTriangles;i++)
	{			
		//if (m_pTriangles[i].m_NormalsTransformed[2]<=65536*0.1)
		{					
			minZ=m_pVertices[m_pTriangles[i].m_vertexIndices[0]].m_transformed[2];
			maxZ=m_pVertices[m_pTriangles[i].m_vertexIndices[0]].m_transformed[2];
			if (m_pVertices[m_pTriangles[i].m_vertexIndices[1]].m_transformed[2]<minZ) minZ=m_pVertices[m_pTriangles[i].m_vertexIndices[1]].m_transformed[2];
			if (m_pVertices[m_pTriangles[i].m_vertexIndices[2]].m_transformed[2]<minZ) minZ=m_pVertices[m_pTriangles[i].m_vertexIndices[2]].m_transformed[2];
			if (m_pVertices[m_pTriangles[i].m_vertexIndices[1]].m_transformed[2]>maxZ) maxZ=m_pVertices[m_pTriangles[i].m_vertexIndices[1]].m_transformed[2];
			if (m_pVertices[m_pTriangles[i].m_vertexIndices[2]].m_transformed[2]>maxZ) maxZ=m_pVertices[m_pTriangles[i].m_vertexIndices[2]].m_transformed[2];
			if ((minZ>ZclipMin)&&(maxZ<ZclipMax))
			{
				m_sortedTrianglesZ[m_numTriangles2Draw]=m_pTriangles[i].m_Z=(
					(m_pVertices[m_pTriangles[i].m_vertexIndices[0]].m_transformed[2])+
					(m_pVertices[m_pTriangles[i].m_vertexIndices[1]].m_transformed[2])+
					(m_pVertices[m_pTriangles[i].m_vertexIndices[2]].m_transformed[2])
					)>>16;
				m_sortedTrianglesIndex[m_numTriangles2Draw]=i;				
				m_numTriangles2Draw++;
			}
		}
	}
	
	
	/* remise a zero du tableau des repartitions*/
	gm_memset(radixsortDistrib,0,256*sizeof(uint32));
	/*calcul de la repartition*/
	for (i=0;i<m_numTriangles2Draw;i++)
		radixsortDistrib[uint8(m_sortedTrianglesZ[i])]++;		
	
	/*init des pointeurs en fonction de la repartition*/
	radixsortPos[0]=radixsortTab;
	for (i=1;i<256;i++) radixsortPos[i]=radixsortPos[i-1]+radixsortDistrib[i-1];
	
	/*remplissage du tableau*/
	for (i=0;i<m_numTriangles2Draw;i++)
	{
		*radixsortPos[uint8(m_sortedTrianglesZ[i])]=m_sortedTrianglesIndex[i];
		radixsortPos[uint8(m_sortedTrianglesZ[i])]++;
	}
	/*relecture du tableau*/		
	for (i=0;i<m_numTriangles2Draw;i++)
	{
		m_sortedTrianglesIndex[i]=radixsortTab[i];
		m_sortedTrianglesZ[i]=m_pTriangles[radixsortTab[i]].m_Z;
	}
	
	/* remise a zero du tableau des repartitions*/
	gm_memset(radixsortDistrib,0,256*sizeof(uint32));
	/*calcul de la repartition*/
	for (i=0;i<m_numTriangles2Draw;i++)		
		radixsortDistrib[uint8(m_sortedTrianglesZ[i]>>8)]++;
	
	/*init des pointeurs en fonction de la repartition*/
	radixsortPos[0]=radixsortTab;
	for (i=1;i<256;i++) radixsortPos[i]=radixsortPos[i-1]+radixsortDistrib[i-1];
	
	/*remplissage du tableau*/
	for (i=0;i<m_numTriangles2Draw;i++)
	{
		*radixsortPos[uint8(m_sortedTrianglesZ[i]>>8)]=m_sortedTrianglesIndex[i];
		radixsortPos[uint8(m_sortedTrianglesZ[i]>>8)]++;
	}
	/*relecture du tableau*/		
	for (i=0;i<m_numTriangles2Draw;i++)
	{
		m_sortedTrianglesIndex[i]=radixsortTab[i];
		m_sortedTrianglesZ[i]=m_pTriangles[radixsortTab[i]].m_Z;
	}
	
	switch (y3DE_rendermode)
	{
	case 0:
		for (i=m_numTriangles2Draw-1;i>=0;i--)
		{			
			j=m_sortedTrianglesIndex[i];
			if (m_pTriangles[j].mesh<3) k=m_pTriangles[j].mesh+1;
			else k=0;
			drawTriangle(j,k,(uint16*)vbuffer);
		}
		break;
	case 1:
		for (i=m_numTriangles2Draw-1;i>=0;i--)
		{
			j=m_sortedTrianglesIndex[i];
			if (m_pTriangles[j].mesh<3) k=m_pTriangles[j].mesh+1;
			else k=0;
			drawTriangleGouraud(j,k,(uint16*)vbuffer);
		}
		break;
	case 2:
		for (i=m_numTriangles2Draw-1;i>=0;i--)
		{
			j=m_sortedTrianglesIndex[i];
			if (m_pTriangles[j].mesh)
				drawTriangleTexture(j,1,(uint16*)vbuffer,(uint16*)texture2);
			else
				drawTriangleGouraud(j,m_pTriangles[j].mesh&1,(uint16*)vbuffer);
		}
		break;
	case 3:
		for (i=m_numTriangles2Draw-1;i>=0;i--)
		{
			j=m_sortedTrianglesIndex[i];
			/*if (m_pTriangles[j].mesh<=4)
			drawTriangleTexture(j,1,(uint16*)vbuffer,(uint16*)texture2);					
			else						
			drawTriangleTexture(j,0,(uint16*)vbuffer,(uint16*)texture1);*/
			k=m_pMeshes[m_pTriangles[j].mesh].m_materialIndex;
			switch (k&1)
			{
			case 0:drawTriangleDoubleTexture(j,(uint16*)vbuffer,(uint16*)texture1,(uint16*)texture_env2);
				break;					
			case 1:drawTriangleDoubleTexture(j,(uint16*)vbuffer,(uint16*)texture2,(uint16*)texture_env1);
				break;
			}				
		}
		break;
	case 4:
		for (i=m_numTriangles2Draw-1;i>=0;i--)
		{
			j=m_sortedTrianglesIndex[i];
			if (m_pTriangles[j].mesh)
				drawTriangleCorTexture(j,1,(uint16*)vbuffer,(uint16*)texture2);
			else
				drawTriangleGouraud(j,m_pTriangles[j].mesh,(uint16*)vbuffer);
		}
		break;
	case 5:									
		for (i=m_numTriangles2Draw-1;i>=0;i--)
		{
			j=m_sortedTrianglesIndex[i];
			if (m_pTriangles[j].mesh)
				drawTriangleCorTexture(j,1,(uint16*)vbuffer,(uint16*)texture_env1);
			else						
				drawTriangleCorTexture(j,0,(uint16*)vbuffer,(uint16*)texture1);
			
		}
		break;
	
	case 6:
		for (i=m_numTriangles2Draw-1;i>=0;i--)
		{
			j=m_sortedTrianglesIndex[i];			
			k=m_pMeshes[m_pTriangles[j].mesh].m_materialIndex;
			switch (k&1)
			{
//			case 0:drawTriangleDoubleTexture(j,(uint16*)vbuffer,(uint16*)texture1,(uint16*)texture_env2);
			case 0:drawTriangleTexture(j,1,(uint16*)vbuffer,(uint16*)texture_env2);
				break;					
			case 1:drawTriangle(j,m_pTriangles[j].mesh+1,(uint16*)vbuffer);
				break;
			}				
		}
		break;
	}
	/* Calcul du y3DE_frameRate*/
	y3DE_frameRendered++;
	if (y3DE_FrameCpt-y3DE_frameTime>=50)
	{
		y3DE_frameRate=y3DE_frameRendered*50/(y3DE_FrameCpt-y3DE_frameTime);
		y3DE_frameTime=y3DE_FrameCpt;
		y3DE_frameRendered=0;
	}
	/**********************/
	/* Affichage du cadre avec les infos*/							
	for (i=8*240;i<160*240;i+=240)
	{			
		for (j=180;j<230;j++)
			((uint16*)vbuffer)[i+239-j]=halfval[((uint16*)vbuffer)[i+239-j]];
		((uint16*)vbuffer)[i+239-180]=0xFFFF;	
		((uint16*)vbuffer)[i+239-229]=0xFFFF;	
	}		
	for (j=180;j<230;j++)
	{
		((uint16*)vbuffer)[8*240+239-j]=0xFFFF;
		((uint16*)vbuffer)[159*240+239-j]=0xFFFF;
	}		
	sprintf(text,"[OpenSNES9XGP %d.%d]\n->",VERSION_MAJOR,VERSION_MINOR);
	gp32_GpTextOut(vbuffer,12,184,text,(31<<11)|(28<<6)|(15<<1)|1,1);
	gp32_GpTextOut(vbuffer,30,193,"Yoyofr",(30<<11)|(30<<6)|(31<<1)|1,0);
	gp32_GpTextOut(vbuffer,50,205,"Laxer3a",(31<<11)|(31<<6)|(30<<1)|1,0);
	gp32_GpTextOut(vbuffer,70,217,"ThunderZ",(31<<11)|(28<<6)|(31<<1)|1,0);		
	sprintf(text,"FR:%d",y3DE_frameRate);
	gp32_GpTextOut(vbuffer,110,193,text,(31<<11)|(31<<6)|(31<<1)|1,0);
	sprintf(text,"R:%d",y3DE_rendermode);
	gp32_GpTextOut(vbuffer,110,205,text,(31<<11)|(31<<6)|(31<<1)|1,0);
	/**********************/
	/* Recupere les touches appuyes*/
	int keypressed=0;
	if (*interact_mode)
	{
		keypressed=GpKeyGet();	
		if (keypressed&&(keypressed&GPC_VK_SELECT)) *interact_mode=1;
		if ((*interact_mode==2)&&keypressed) return 1;
	}
	/**********************/		
	/* Mouvements */
	switch (y3DE_movemode)
	{
	case 0:	
		y3DE_ax=y3DE_FrameCpt*3;			
		y3DE_ay=y3DE_FrameCpt*5;
		y3DE_az=y3DE_FrameCpt*3;
		y3DE_posZ=-40*65536+(fix_cos[(y3DE_FrameCpt<<1)&1023]<<4);
		break;
	case 1:
		y3DE_ax=fix_sin[(y3DE_FrameCpt*1)&1023]>>10;
		y3DE_ay=fix_sin[(y3DE_FrameCpt*3)&1023]>>9;			
		y3DE_az=fix_sin[(y3DE_FrameCpt*2)&1023]>>10;	
		y3DE_posZ=-30*65536+(fix_sin[(y3DE_FrameCpt<<1)&1023]<<3);
		break;
	case 2:
	{
		int diff_frame=y3DE_FrameCpt-y3DE_oldFrameCpt;
		y3DE_oldFrameCpt=y3DE_FrameCpt;
		if (keypressed&GPC_VK_UP) 
		{
			if (keypressed&GPC_VK_FA) y3DE_posY-=0.5*65536* diff_frame;
			else if (keypressed&GPC_VK_FB) y3DE_ay-=3* diff_frame;
			else y3DE_posZ-=0.5*65536* diff_frame;
		}
		if (keypressed&GPC_VK_DOWN) 
		{
			if (keypressed&GPC_VK_FA) y3DE_posY+=0.5*65536* diff_frame;
			else if (keypressed&GPC_VK_FB) y3DE_ay+=3* diff_frame;
			else y3DE_posZ+=0.5*65536* diff_frame;
		}
		if (keypressed&GPC_VK_LEFT) 
		{
			if (keypressed&GPC_VK_FA) y3DE_ax+=3* diff_frame;
			else if (keypressed&GPC_VK_FB) y3DE_az-=3* diff_frame;
			else y3DE_posX+=0.5*65536* diff_frame;
		}
		if (keypressed&GPC_VK_RIGHT) 
		{
			if (keypressed&GPC_VK_FA) y3DE_ax-=3* diff_frame;
			else 	if (keypressed&GPC_VK_FB) y3DE_az+=3* diff_frame;
			else y3DE_posX-=0.5*65536* diff_frame;
		}
		break;
	}
	case 3:	
	{
		long temp3d=256-((fix_cos[(y3DE_FrameCpt)&1023]*256)>>16);
		y3DE_ax=temp3d*4;
		if ((y3DE_FrameCpt>0)&&(y3DE_FrameCpt<0+256*2))
			y3DE_posY=-(20<<16)-(fix_cos[(temp3d)&1023]*20);
		if (y3DE_FrameCpt>0+256*2)
		{
			y3DE_movemode=1;
			y3DE_FrameCpt=0;
		}
		break;
	}
	case 4:	
	{
		long temp3d=256-((fix_cos[(y3DE_FrameCpt)&1023]*256)>>16);
		y3DE_ax=temp3d*2*2;
		y3DE_ay=temp3d*2*1;
		if ((y3DE_FrameCpt>0)&&(y3DE_FrameCpt<0+256*2))
		{
			y3DE_posY=(200<<16)+(fix_cos[(temp3d)&1023]*200);
			y3DE_posZ=-(30<<16)-(fix_sin[(temp3d)&1023]*10);
		}
		if (y3DE_FrameCpt>0+256*2)
		{
			y3DE_movemode=1;
			y3DE_FrameCpt=0;
		}
		break;
	}
	}		
	y3DE_ax&=1023;
	y3DE_ay&=1023;
	y3DE_az&=1023;
	/*************************/
	/* gestion des entrees*/
	if (y3DE_keywaiter<y3DE_FrameCpt)
	{
		
		if (keypressed&(GPC_VK_START)) return 1;
		if (keypressed&(GPC_VK_FR)) 
		{
			y3DE_rendermode++;
			y3DE_keywaiter=y3DE_FrameCpt+20;
		}
		
		if (keypressed&(GPC_VK_SELECT)) 
		{
			y3DE_keywaiter=y3DE_FrameCpt+20;
			y3DE_movemode++;
			if (y3DE_movemode>2) y3DE_movemode=0;
			y3DE_ax=y3DE_ay=y3DE_az=0;
			y3DE_posX=0*65536;
			y3DE_posY=0*65536;
			y3DE_posZ=-50*65536;
		}
		if (y3DE_rendermode<0) y3DE_rendermode=6;
		if (y3DE_rendermode>6) y3DE_rendermode=0;				
	}	
	
	return 0;			
}

int y3DEngine_Init(int model,int star=0)
{
	char text[512];
	
	InitFixCosSin(1024);
			
	/* Chargement du model 3D*/
	if (LoadModel(model,&m_numVertices,&m_numTriangles,&m_numMeshes,
		&m_pVertices,&m_pTriangles,&m_pMeshes))
	{
		S9xMessage(0,0,"Error dat file not found in gp:\\gpmm\\os9xgp.dat");
		gp32_pause();
		return 1;
	}
	
	if (star)
	{
		y3DE_stars=1;
		y3DE_st_aX=y3DE_st_aY=y3DE_st_aZ=0;
		y3DE_st_X=(int*)malloc(_num_stars_*sizeof(int));
		y3DE_st_Y=(int*)malloc(_num_stars_*sizeof(int));
		y3DE_st_Z=(int*)malloc(_num_stars_*sizeof(int));
		for (int i=0;i<_num_stars_;i++)
		{
			y3DE_st_X[i]=((int)(rand()&255)-128)<<16;
			y3DE_st_Y[i]=((int)(rand()&255)-128)<<16;
			y3DE_st_Z[i]=((int)(rand()&255)-128)<<16;
		}
	}
	
	/* Init des var internes*/
	m_sortedTrianglesIndex = (uint32 *)malloc(m_numTriangles*sizeof(uint32));
	m_sortedTrianglesZ = (int32 *)malloc(m_numTriangles*sizeof(int32));
	radixsortTab=(uint32*)malloc(m_numTriangles*sizeof(uint32));		
	fix_div=(int32*)malloc(65536*sizeof(int32));	
	
	halfval = (uint16*)malloc(65536*sizeof(uint16));
//	minval = (uint16*)malloc(65536*sizeof(uint16));	
	for (int i=0;i<65536;i++)
	{
		int r,v,b;
		r=((i>>11))>>1;
		v=(((i>>6)&31))>>1;
		b=(((i>>1)&31))>>1;
		halfval[i]=(r<<11)|(v<<6)|(b<<1)|1;
		r=(i>>11)*4/5;
		v=((i>>6)&31)*4/5;
		b=((i>>1)&31)*4/5;
		if (r<0) r=0;
		if (v<0) v=0;
		if (b<0) b=0;
//		minval[i]=(r<<11)|(v<<6)|(b<<1)|1;
		
		fix_div[i]=65536/(i+1);
	}
	/************************/
	
	/* Lancement du timer pour synchro des frames*/
	GpTimerOptSet(2, 50*gp32_timermul>>8, 0, y3DEngine_timer);  // FIX: doesn't work ok...
	GpTimerSet(2);
    
	
	/* Init du polygoniseur*/
	if (poly_init(m_pVertices,m_pTriangles,fix_div)) return 1;			
	
	y3DE_rendermode=3;y3DE_movemode=3;			
	y3DE_ax=0;y3DE_ay=0;y3DE_az=0;
	y3DE_posX=0*65536;y3DE_posY=-100*65536;y3DE_posZ=-30*65536;
	y3DE_keywaiter=y3DE_FrameCpt=y3DE_frameTime=0;
	y3DE_frameRate=0;
	
	/*Texture*/
	/*texture1=(uint16*)malloc(64*64*2);
	texture2=(uint16*)malloc(64*64*2);
	texture_env1=(uint16*)malloc(64*64*2);
	texture_env2=(uint16*)malloc(64*64*2);*/
	int i,j,k;
	if (SF_LoadData(7,(char**)&texture1)) 
	{
		texture1=(uint16*)malloc(64*64*2);
		for (i=0;i<64;i++)
		for (j=0;j<64;j++) ((uint16*)texture1)[i*64+j]=((rand()&31)<<1)|1;
	}
	if (SF_LoadData(6,(char**)&texture2)) 
	{
		texture2=(uint16*)malloc(64*64*2);
		for (i=0;i<64;i++)
		for (j=0;j<64;j++) ((uint16*)texture2)[i*64+j]=((rand()&31)<<11)|1;
	}
	if (SF_LoadData(5,(char**)&texture_env1)) 
	{
		texture_env1=(uint16*)malloc(64*64*2);		
		for (i=0;i<64;i++)
		for (j=0;j<64;j++) 
		{
			k=(i-32)*(i-32)+(j-32)*(j-32);
			k=31-k/16;
			if (k<0) k=0;
			((uint16*)texture_env1)[i*64+j]=(k<<11)|(k<<6)|(k<<1)|1;
		}
	}
	if (SF_LoadData(4,(char**)&texture_env2)) 
	{
		texture_env2=(uint16*)malloc(64*64*2);
		int r,v,b;
		for (i=0;i<64;i++)
		for (j=0;j<64;j++) 
		{
			k=(i-32)*(i-32)+(j-32)*(j-32);
			r=31-r/16;
			if (r<0) r=0;
			v=31-r/8;
			if (v<0) v=0;
			b=31-b/24;
			if (b<0) b=0;
			((uint16*)texture_env2)[i*64+j]=(r<<11)|(v<<6)|(b<<1)|1;
		}
	}
		
	if (model==0)
	{
		int r,v,b;
		for (i=0;i<64;i++)
		for (j=0;j<64;j++) 
		{
			k=((uint16*)texture_env2)[i*64+j];
			r=(k>>11)&31;v=(k>>6)&31;b=(k>>1)&31;			
			r=b;
			v=b;
			b=(k>>11)&31;
			((uint16*)texture_env2)[i*64+j]=(r<<11)|(v<<6)|(b<<1)|1;
			
			k=((uint16*)texture1)[i*64+j];
			r=(k>>11)&31;v=(k>>6)&31;b=(k>>1)&31;			
			r=b;
			v=b;
			b=(k>>11)&31;
			((uint16*)texture1)[i*64+j]=(r<<11)|(v<<6)|(b<<1)|1;
			
			k=((uint16*)texture_env1)[i*64+j];
			r=(k>>11)&31;v=(k>>6)&31;b=(k>>1)&31;			
			b=v;
			((uint16*)texture_env1)[i*64+j]=(r<<11)|(v<<6)|(b<<1)|1;
			
		}
	}
}


int y3DEngine_Close(void)
{
	/* Deinit table de cos/sin */
	FreeFixCosSin();
	/* Deinit du polygoniseur*/
	poly_deinit();	
	/* Deinit du model*/
	for (int i=0;i<m_numMeshes;i++)
	{
		free(m_pMeshes[i].m_pTriangleIndices);
	}	
	free(m_pVertices);
	free(m_pTriangles);
	free(m_pMeshes);	
	free(radixsortTab);		
	free(m_sortedTrianglesIndex);
	free(m_sortedTrianglesZ);
	
	free(halfval);
//	free(minval);	
	free(fix_div);
	
	free(texture1);
	free(texture2);
	free(texture_env1);
	free(texture_env2);	
	
//	free(y3DE_bg_logo);

	if (y3DE_stars)
	{
		free(y3DE_st_X);
		free(y3DE_st_Y);
		free(y3DE_st_Z);
	}
	
	GpTimerKill(2);
    
	
	return 0;
}

void y3DEngine_RenderAuto(uint8 *vbuffer)
{
	static int interact_mode=0;
	int i,j;
	gm_memset((char*)vbuffer,0,320*240*2);	
//	gm_memcpy((char*)vbuffer,y3DE_bg_logo,320*240*2);	
/*	register uint16 *p=(uint16*)vbuffer;
	for (int i=320*240;i;i--,p++) *p=minval[*p];*/	
	y3DEngine_Render(vbuffer,&interact_mode);	
}
