/*

	menu.c - Quick & Dirty rom selection screen. The code in this file is
	         far from optimised or efficient, but it does the job and thats
			 good enough for me.

	                  (c) Nick Van Veen (aka Sjeep), 2002

	-------------------------------------------------------------------------

    This file is part of the PSMS.

    PSMS is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    PSMS is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Foobar; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <tamtypes.h>
#include <string.h>
#include <kernel.h>
#include <sifrpc.h>
#include <stdlib.h>
#include <stdio.h>
#include "hw.h"
#include "gs.h"
#include "gfxpipe.h"
#include "shared.h"
#include "pad.h"
#include "psms.h"
#include "menu.h"

#define Z_LOGO		1
#define Z_STARS		2
#define Z_BOX1		3
#define Z_BOX2		4
#define Z_LIST		5
#define Z_SELECT	6
#define Z_SCROLLBG	7
#define Z_SCROLL	8
#define Z_SCROLL_M	9

struct ROMdata *romdata;
int num_roms = 0;

int selection = 0;
int frame_position;
int frame_selection = 0;

// Note: Space = 4pix wide
char scroll_text[] = "                                                    PSMS v1.2 - PS2 specific code (GFX, Sound) by Nick Van Veen (aka Sjeep) - SMS emulator coded by Charles Mac Donald                    Thanks to: Vzzrzzn for releasing src to his demo's which I learned a lot from, and for writing the original sound driver (which is no longer used) - Pukko for padlib and many fixes to the sif code in psx2lib - Gustavo Scotti for psx2lib - Oobles for his IOP tutorial and example code - The people behind naplink, which was used to develop PSMS - Phex_X, Sykopieces, struct2, justice7 and Sparcky for beta testing PSMS - Justice7 for writing the FILES.TXT util - Charles Mac Donald for writing SMSPlus, the excellent SMS emulator which PSMS is based on. Get it at: http://cgfm2.emuviews.com                 Greets to: Nagra, Stryder Hiryu, Now3d, Dreamtime, Vzzrzzn, Oobles, Gustavo, Pukko, Justice7, Jules, Karmix, Phed_X, Duke, Adk, struct2, Sparcky, dayta, Sykopieces, adresd and anybody that I've missed out.                   You can find the lastest PSMS release at: http://psms.gamebase.ca";

static t_starfield starfield[SF_SIZE];

char* menu_main()
{
	int i;
	int y;
	static int scroll_x = 8, scroll_pos = 0,scroll_delay = 1;

	menu_init_stars();

	while(1) {

		if(menu_update_input()) { // X was pressed
			gp_gouradrect(&thegp, 40<<4, 96<<4, GS_SET_RGBA(140, 0, 255, 128), 216<<4, 144<<4, GS_SET_RGBA(13, 88, 174, 128), Z_BOX1);
			gp_linerect(&thegp, 39<<4, 95<<4, 216<<4, 144<<4, Z_BOX2, GS_SET_RGBA(255, 255, 255, 128));
			TextOutC(0<<4, 256<<4, 112<<4, "Loading ROM...", Z_SELECT);
			gp_hardflush(&thegp);
			WaitForNextVRstart(1);
	    	GS_SetCrtFB(whichdrawbuf);
    		whichdrawbuf ^= 1;
	    	GS_SetDrawFB(whichdrawbuf);
			break;
		}

		// Draw starfield
		menu_draw_stars();

		// Logo data seems to get distorted during emulation, so reload..
		gp_uploadTexture(&thegp, LOGO_TEX, 256, 0, 0, GS_PSMT8, psms_image, psms_width, psms_height);
		gp_uploadTexture(&thegp, LOGO_CLUT, 256, 0, 0, GS_PSMCT16, psms_clut, 256, 1);

		// Draw PSMS Logo
		gp_setTex(&thegp, LOGO_TEX, 256, psms_width, psms_height, GS_PSMT8, LOGO_CLUT, 256, GS_PSMCT16);
		gp_texrect(&thegp, 9<<4, 0<<4, 0, 0, (237+9)<<4, (52+0)<<4, 237<<4, 52<<4, Z_LOGO, GS_SET_RGBA(255, 255, 255, 128));

		// Draw Scroll Box
		gp_gouradrect(&thegp, 32<<4, 60<<4, GS_SET_RGBA(140, 0, 255, 128), (192+32)<<4, (142+60)<<4, GS_SET_RGBA(13, 88, 174, 128), Z_BOX1);
		gp_linerect(&thegp, 31<<4, 59<<4, (193+31)<<4, (143+59)<<4, Z_BOX2, GS_SET_RGBA(255, 255, 255, 128));

		// Draw text in scroll box
		y = 60<<4;
		for(i=frame_position;i<(frame_position+8);i++) {
			TextOutC(32<<4,224<<4,y,(char *)&romdata[i].name,Z_LIST);
			y += 18<<4;
		}
		gp_frect(&thegp, 32<<4, (60+(frame_selection*18))<<4, 224<<4, (76+(frame_selection*18))<<4, Z_SELECT, GS_SET_RGBA(123, 255, 255, 40));

		// Draw scroller
		TextOut(scroll_x<<4,216<<4,&scroll_text[scroll_pos],Z_SCROLL);
		if(--scroll_delay < 0) {
			if(--scroll_x < 0) {
				scroll_x = vixarmet[(int)scroll_text[scroll_pos]];
				if(++scroll_pos > sizeof(scroll_text)) scroll_pos = 0;
			}
			scroll_delay = 1;
		}
		gp_frect(&thegp,0<<4,0<<4,9<<4,240<<4,Z_SCROLL_M,GS_SET_RGBA(0, 0, 0, 128));

		gp_hardflush(&thegp);

		WaitForNextVRstart(1);

		// Update drawing and display enviroments.
    	GS_SetCrtFB(whichdrawbuf);
    	whichdrawbuf ^= 1;
    	GS_SetDrawFB(whichdrawbuf);

	}

	return (char *)&romdata[selection].filename;
}

int menu_update_input()
{
	static struct padButtonStatus pad1; // just in case
	static int pad1_connected = 0;
	static int padcountdown = 0;
	static int pad_held_down = 0;

	int pad1_data = 0;

	if(pad1_connected) {
		padRead(0, 0, &pad1); // port, slot, buttons
		pad1_data = 0xffff ^ ((pad1.btns[0] << 8) | pad1.btns[1]);

		if((pad1.mode >> 4) == 0x07) {
			if(pad1.ljoy_v < 64) pad1_data |= PAD_UP;
			else if(pad1.ljoy_v > 192) pad1_data |= PAD_DOWN;

			if(pad1.ljoy_h < 64) pad1_data |= PAD_LEFT;
			else if(pad1.ljoy_h > 192) pad1_data |= PAD_RIGHT;
		}
	}

	if(pad1_data & PAD_CROSS) return 1;

	if(padcountdown) padcountdown--;

	if((pad1_data & PAD_DOWN) && (padcountdown==0) && (selection!=(num_roms-1))) {
		selection++;

		if(frame_selection<7) frame_selection++;

		//if the pad has been held down for a certain amount of time, give padcountdown
		//a lower value, in effect making the scrolling of the text faster
		if(pad_held_down++<4) padcountdown=10;
		else padcountdown=2;

		//move the display frame if necessary
		if(selection>(frame_position+7)) frame_position++;

		return 0;

	}
	else if((pad1_data & PAD_UP) && (padcountdown==0) && (selection>0)) {
		selection--;

		if(frame_selection>0)frame_selection--;

		if(pad_held_down++<4) padcountdown=10;
		else padcountdown = 2;

		if(selection<frame_position) frame_position--;

		return 0;
	}
	else if((pad1_data & PAD_LEFT) && (padcountdown==0) && (frame_position>8)) {
		frame_position -= 8;
		selection -= 8;

		if(pad_held_down++<4) padcountdown=10;
		else padcountdown = 2;

		return 0;
	}
	else if((pad1_data & PAD_RIGHT) && (padcountdown==0) && (frame_position<(num_roms-16))) {
		frame_position += 8;
		selection += 8;

		if(pad_held_down++<4) padcountdown=10;
		else padcountdown = 2;

		return 0;
	}

	//if up or are NOT being pressed, reset the pad_held_down flag
	if(!(pad1_data & (PAD_UP | PAD_DOWN))) pad_held_down = 0;

	//check controller status
	if((padGetState(0, 0)) == PAD_STATE_STABLE) {
		if(pad1_connected == 0) {
			WaitForNextVRstart(1);
		}
		pad1_connected = 1;
	} else pad1_connected = 0;

	return 0;
}

void ProcessROMlist()
{
	int fd, fd_size;
	char* buffer;
	int i,j,k,l;
	int num_lines = 0;
	char line[256];

#ifdef CD_BUILD
	fd = fio_open("cdrom0:\\FILES.TXT;1", O_RDONLY);
#else
	fd = fio_open("host:FILES.TXT", O_RDONLY);
#endif

	if(fd <= 0) {
		display_error("FILES.TXT not found on CDROM!", 1);
	}

	fd_size = fio_lseek(fd,0,SEEK_END);
	fio_lseek(fd,0,SEEK_SET);

	buffer = memalign(64, fd_size);
	if(buffer == NULL) display_error("Failed to allocate memory!", 1);

	if(fio_read(fd, buffer, fd_size) != fd_size) {
		display_error("Error reading FILES.TXT!", 1);
	}
#ifdef DEVEL
	printf("File loaded! %d bytes.\n",fd_size);
#endif

	fio_close(fd);

	for(i=0;i<fd_size;i++) {
		if(buffer[i] == '\n') num_lines++;
	}

	romdata = malloc(sizeof(struct ROMdata) * num_lines);
	memset((byte *)romdata,0,sizeof(struct ROMdata) * num_lines);
	memset(line,0,256);

	num_roms = 0;
	i=j=k=l=0;

	for(j=0;j<num_lines;j++) {

		while(buffer[i] != '\n') {
			line[k] = buffer[i];
			i++;
			k++;
		}
		k=0;
		i++;

		if(strstr(line,",") == NULL) continue;

		while(line[k] != ',') {
			romdata[num_roms].name[l] = line[k];
			k++;
			l++;
		}
		l=0;
		k++;
		while(line[k] != '\0') {
			romdata[num_roms].filename[l] = line[k];
			k++;
			l++;
		}
		l=0;
		k=0;
		memset(line,0,256);
		num_roms++;
	}
}

void menu_draw_stars()
{
	int x,y,i;

	for(i=0;i<SF_SIZE;i++)
	{
		starfield[i].z -= SPEED;
		if(starfield[i].z < 2) menu_create_star(i);
		x = (WIDTH/2) + ((starfield[i].x<<6) / starfield[i].z);
		y = (HEIGHT/2) + ((starfield[i].y<<6) / starfield[i].z);

		if ((x<0) || (y<0) || (x>(WIDTH-1)) || (y>(HEIGHT-1))) {
				menu_create_star(i);
				x = (WIDTH/2) + (starfield[i].x / starfield[i].z);
				y = (HEIGHT/2) + (starfield[i].y / starfield[i].z);
		}

		gp_point(&thegp, x<<4, y<<4, Z_STARS, GS_SET_RGBA(255, 255, 255, 128));
	}
}

void menu_create_star(int i)
{
	// Set a star to new random values
	starfield[i].x=rand()%WIDTH;
	starfield[i].y=rand()%HEIGHT;
	starfield[i].z=Z_MAX;
}

void menu_init_stars()
{
	int i;
	static int inited = 0;

	if(inited) return;

	for(i=0;i<SF_SIZE;i++) {
		starfield[i].x=rand()%WIDTH;
		starfield[i].y=rand()%HEIGHT;
		starfield[i].z=Z_MAX;
	}

	inited = 1;
}
