/*
  _____     ___ ____
   ____|   |    ____|      PSX2 OpenSource Project
  |     ___|   |____       (C)2001, Gustavo Scotti (gustavo@scotti.com)
  ------------------------------------------------------------------------
  crt0.s
			EE C-RunTime startup code
			reversed from public available binaries.
*/

	.file	1 "crt0.s"
	.text
	.p2align 3
	.globl	_start
	.ent	_start

_stack 		= 0x01FFFF00
_stack_size	= 0x8000
_stack_end	= _stack - _stack_size

_start:
	lui		$4, %hi(_gp)
	lui		$5, %hi(_stack)
	lui		$6, %hi(_stack_size)
	lui		$7, %hi(.bss)
	lui		$8, %hi(_root)

	addiu		$4, $4, %lo(_gp)
	addiu		$5, $5, %lo(_stack)
	addiu		$6, $6, %lo(_stack_size)
	addiu		$7, $7, %lo(.bss)
	addiu		$8, $8, %lo(_root)

	move		$gp, $4
	li		$3,  60
	syscall					# RFU060

	move		$sp, $2
	lui		$4, %hi(_stack_end)
	lui		$5, %hi(_stack_size)

	addiu		$4, $4, %lo(_stack_end)
	addiu		$5, $5, %lo(_stack_size)

	li		$3,  61
	syscall					# RFU061

	jal		main
	nop

	/* vou trocar por um ExitThread(); --- temporario */
	addiu		$3, $0, 35
	syscall
/*
	j		Exit
	move		$4, $2
*/
	.end	_start


_root:	# kills the thread.
	li		$3, 35
	syscall					# ExitThread


