/*
** N64/Nincest 64 memory handling (header file)
*/
#ifndef MEMHAND_H
#define MEMHAND_H

#define                 BYTE            unsigned char
#define                 WORD            unsigned short int
#define                 DWORD           unsigned long
#define                 QWORD           unsigned long long

char boot[0x2000];  // Boot code
char *g_n64rom;
unsigned int size;  // Keep how big the rom is in memory.

BYTE getbyte ( unsigned int );
WORD getword ( unsigned int );
DWORD getdword ( unsigned int );
QWORD getqword ( unsigned int );

void putbyte ( unsigned int, BYTE );
void putword ( unsigned int, WORD );
void putdword ( unsigned int, DWORD );
void putqword ( unsigned int, QWORD );

char RDram_Registers[0x2F];     // 3f00000h - 3f0002Fh
char *RDram;                    // bleah
char *SP_Registers;             // 0400000h     // Boot?
char DP_Cmd_Registers[0x0F];    // 0410000h
char DP_Span_Registers[0x0F];   // 0420000h
char MI_Registers[0x0F];        // 0430000h
char VI_Registers[0x37];        // 0440000h
char AI_Registers[0x17];        // 0450000h
char PI_Registers[0x34];        // 0460000h
char RI_Registers[0x1F];        // 0470000h
char SI_Registers[0x1B];        // 0480000h
char PIF_RxM[0x7FF];            // 0FC0000H - 0FC007FF

struct PI_typ
{
  DWORD DRAM;
  DWORD Cart;
  DWORD RD_LEN;
  DWORD WR_LEN;
} PI;

#endif
