/*
** N64/Nincest 64 memory handling
*/

//#include "r4300.h"
#include "memhand.h"
//#include "main.h"
#include <malloc.h>
#include <string.h>
#ifdef DEBUG
#include "debug.h"
#endif
void init_mem ( void )
{
  DWORD *temp;

  RDram = (char*)malloc(0x400000);
  memset(&RDram[0], 0, 0x400000);
  memset(&RDram_Registers[0],0, 0x2f);
  memset(&DP_Cmd_Registers[0],0, 0x0f);
  memset(&DP_Span_Registers[0],0, 0x0f);
  memset(&MI_Registers[0], 0, 0x0f);
  memset(&VI_Registers[0], 0, 0x37);
  memset(&AI_Registers[0], 0, 0x17);
  memset(&PI_Registers[0], 0, 0x33);
  memset(&RI_Registers[0], 0, 0x1f);
  memset(&SI_Registers[0], 0, 0x1b);

  temp = (DWORD*)&MI_Registers[4];
  *temp = 0x01010101;
}

void r_memcpy (void *out, void *in, size_t size)
{
  size_t x = --size;
  size_t y = 0;
  char *src = (char*)in;
  char *dest = (char*)out;

  for (; x != -1 ; --x)
  {
    dest[y++] = src[x]; 
  }
}

void Do_PI_Transfer ( void )
{
  DWORD count;

#ifdef DEBUG
  printf("Doing PI transfer of %08X bytes from: %08X to %08X\n", PI.WR_LEN, PI.Cart, PI.DRAM);
#endif
  for (count = 0; count <= PI.WR_LEN; count++)
    putbyte(PI.DRAM+count,getbyte(PI.Cart+count));
}

/*
QWORD getmem (unsigned int location, unsigned char size)
{
  QWORD ret = 0;

#ifdef DEBUGMEM
    printf("** Reading from memory location %08X\n", location);
#endif
  location &= 0x1FFFFFFF;               // Everything WRAPS!!!

  if (location >= 0x1FC00000 && location <= 0x1FC007FF)
  {
    r_memcpy(&ret, &PIF_RxM[location & 0x7FF], size);
    return(ret);
  }
  if (location >= 0x10000000)
  {
    r_memcpy(&ret, &g_n64rom[location & 0x0FFFFFFF], size);
    return(ret);
  }
  if (location >= 0x03f00000 && location <= 0x04900000)
  {
    if (location >= 0x04800000 && location <= 0x0480001B)
    {
      r_memcpy(&ret, &SI_Registers[location & 0xFF], size);
      return(ret);
    }
    if (location >= 0x04700000 && location <= 0x0470001F)
    {
      r_memcpy(&ret, &RI_Registers[location & 0xFF], size);
      return(ret);
    }
    if (location >= 0x04600000 && location <= 0x04600033)
    {
      r_memcpy(&ret, &PI_Registers[location & 0xFF], size);
      return(ret);
    }
    if (location >= 0x04500000 && location <= 0x04500017)
    {
      r_memcpy(&ret, &AI_Registers[location & 0xFF], size);
      return(ret);
    }
    if (location >= 0x04400000 && location <= 0x04400037)
    {
      r_memcpy(&ret, &VI_Registers[location & 0xFF], size);
      return(ret);
    }
    if (location >= 0x04300000 && location <= 0x0430000F)
    {
      r_memcpy(&ret, &MI_Registers[location & 0xFF], size);
      return(ret);
    }
    if (location >= 0x04200000 && location <= 0x0420000F)
    {
      r_memcpy(&ret, &DP_Span_Registers[location & 0xFF], size);
      return(ret);
    }
    if (location >= 0x04100000 && location <= 0x0410001F)
    {
      r_memcpy(&ret, &DP_Cmd_Registers[location & 0xFF], size);
      return(ret);
    }
    if (location >= 0x04000000 && location <  0x04002000)
    {
      r_memcpy(&ret, &boot[location & 0x1FFF], size);
      return(ret);
    }
    if (location >= 0x03f00000 && location <  0x03f0002f)
    {
      r_memcpy(&ret, &RDram_Registers[location & 0xff], size);
      return(ret);
    }
  }
  if (location <= 0x003fffff)
  {
    if (location == 0x180)
    {
      debug.cont = FALSE;
      debug.info_nec = TRUE;
    }
    r_memcpy(&ret, &RDram[location], size);
    return(ret);
  }
  return 0;
}
*/
DWORD getdword (unsigned int location)
{
  DWORD ret = 0;

#ifdef DEBUGMEM
    printf("** Reading from memory location %08X\n", location);
#endif
  location &= 0x1FFFFFFF;               // Everything WRAPS!!!

  if (location >= 0x1FC00000 && location <= 0x1FC007FF)
  {
    r_memcpy(&ret, &PIF_RxM[location & 0x7FF], 4);
    return(ret);
  }
  if (location >= 0x10000000)
  {
    r_memcpy(&ret, &g_n64rom[location & 0x0FFFFFFF], 4);
    return(ret);
  }
  if (location >= 0x03f00000 && location <= 0x04900000)
  {
    if (location >= 0x04800000 && location <= 0x0480001B)
    {
      r_memcpy(&ret, &SI_Registers[location & 0xff], 4);
      return(ret);
    }
    if (location >= 0x04700000 && location <= 0x0470001F)
    {
      r_memcpy(&ret, &RI_Registers[location & 0xfF], 4);
      return(ret);
    }
    if (location >= 0x04600000 && location <= 0x04600033)
    {
      r_memcpy(&ret, &PI_Registers[location & 0xff], 4);
      return(ret);
    }
    if (location >= 0x04500000 && location <= 0x04500017)
    {
      r_memcpy(&ret, &AI_Registers[location & 0xff], 4);
      return(ret);
    }
    if (location >= 0x04400000 && location <= 0x04400037)
    {
      r_memcpy(&ret, &VI_Registers[location & 0xff], 4);
      return(ret);
    }
    if (location >= 0x04300000 && location <= 0x0430000F)
    {
      r_memcpy(&ret, &MI_Registers[location & 0xfF], 4);
      return(ret);
    }
    if (location >= 0x04200000 && location <= 0x0420000F)
    {
      r_memcpy(&ret, &DP_Span_Registers[location & 0xfF], 4);
      return(ret);
    }
    if (location >= 0x04100000 && location <= 0x0410001F)
    {
      r_memcpy(&ret, &DP_Cmd_Registers[location & 0xfF], 4);
      return(ret);
    }
    if (location >= 0x04000000 && location <  0x04002000)
    {
      r_memcpy(&ret, &boot[location & 0x1FFF], 4);
      return(ret);
    }
    if (location >= 0x03f00000 && location <  0x03f0002f)
    {
      r_memcpy(&ret, &RDram_Registers[location & 0xff], 4);
      return(ret);
    }
  }
  if (location <= 0x003fffff)
  {
    r_memcpy(&ret, &RDram[location], 4);
    return(ret);
  }
  return 0;
}

WORD getword (unsigned int location)
{
  WORD ret = 0;

#ifdef DEBUGMEM
    printf("** Reading from memory location %08X\n", location);
#endif
  location &= 0x1FFFFFFF;               // Everything WRAPS!!!

  if (location >= 0x1FC00000 && location <= 0x1FC007FF)
  {
    r_memcpy(&ret, &PIF_RxM[location & 0x7FF], 2);
    return(ret);
  }
  if (location >= 0x10000000)
  {
    r_memcpy(&ret, &g_n64rom[location & 0x0FFFFFFF], 2);
    return(ret);
  }
  if (location >= 0x03f00000 && location <= 0x04900000)
  {
    if (location >= 0x04800000 && location <= 0x0480001B)
    {
      r_memcpy(&ret, &SI_Registers[location & 0xff], 2);
      return(ret);
    }
    if (location >= 0x04700000 && location <= 0x0470001F)
    {
      r_memcpy(&ret, &RI_Registers[location & 0xfF], 2);
      return(ret);
    }
    if (location >= 0x04600000 && location <= 0x04600033)
    {
      r_memcpy(&ret, &PI_Registers[location & 0xff], 2);
      return(ret);
    }
    if (location >= 0x04500000 && location <= 0x04500017)
    {
      r_memcpy(&ret, &AI_Registers[location & 0xff], 2);
      return(ret);
    }
    if (location >= 0x04400000 && location <= 0x04400037)
    {
      r_memcpy(&ret, &VI_Registers[location & 0xff], 4);
      return(ret);
    }
    if (location >= 0x04300000 && location <= 0x0430000F)
    {
      r_memcpy(&ret, &MI_Registers[location & 0xfF], 2);
      return(ret);
    }
    if (location >= 0x04200000 && location <= 0x0420000F)
    {
      r_memcpy(&ret, &DP_Span_Registers[location & 0xfF], 2);
      return(ret);
    }
    if (location >= 0x04100000 && location <= 0x0410001F)
    {
      r_memcpy(&ret, &DP_Cmd_Registers[location & 0xfF], 2);
      return(ret);
    }
    if (location >= 0x04000000 && location <  0x04002000)
    {
      r_memcpy(&ret, &boot[location & 0x1FFF], 2);
      return(ret);
    }
    if (location >= 0x03f00000 && location <  0x03f0002f)
    {
      r_memcpy(&ret, &RDram_Registers[location & 0xff], 2);
      return(ret);
    }
  }
  if (location <= 0x003fffff)
  {
    r_memcpy(&ret, &RDram[location], 2);
    return(ret);
  }
  return 0;
}


QWORD getqword (unsigned int location)
{
  QWORD ret = 0;

#ifdef DEBUGMEM
    printf("** Reading from memory location %08X\n", location);
#endif
  location &= 0x1FFFFFFF;               // Everything WRAPS!!!

  if (location >= 0x1FC00000 && location <= 0x1FC007FF)
  {
    r_memcpy(&ret, &PIF_RxM[location & 0x7FF], 8);
    return(ret);
  }
  if (location >= 0x10000000)
  {
    r_memcpy(&ret, &g_n64rom[location & 0x0FFFFFFF], 8);
    return(ret);
  }
  if (location >= 0x03f00000 && location <= 0x04900000)
  {
    if (location >= 0x04800000 && location <= 0x0480001B)
    {
      r_memcpy(&ret, &SI_Registers[location & 0xff], 8);
      return(ret);
    }
    if (location >= 0x04700000 && location <= 0x0470001F)
    {
      r_memcpy(&ret, &RI_Registers[location & 0xfF], 8);
      return(ret);
    }
    if (location >= 0x04600000 && location <= 0x04600033)
    {
      r_memcpy(&ret, &PI_Registers[location & 0xff], 8);
      return(ret);
    }
    if (location >= 0x04500000 && location <= 0x04500017)
    {
      r_memcpy(&ret, &AI_Registers[location & 0xff], 8);
      return(ret);
    }
    if (location >= 0x04400000 && location <= 0x04400037)
    {
      r_memcpy(&ret, &VI_Registers[location & 0xff], 8);
      return(ret);
    }
    if (location >= 0x04300000 && location <= 0x0430000F)
    {
      r_memcpy(&ret, &MI_Registers[location & 0xfF], 8);
      return(ret);
    }
    if (location >= 0x04200000 && location <= 0x0420000F)
    {
      r_memcpy(&ret, &DP_Span_Registers[location & 0xfF], 8);
      return(ret);
    }
    if (location >= 0x04100000 && location <= 0x0410001F)
    {
      r_memcpy(&ret, &DP_Cmd_Registers[location & 0xfF], 8);
      return(ret);
    }
    if (location >= 0x04000000 && location <  0x04002000)
    {
      r_memcpy(&ret, &boot[location & 0x1FFF], 8);
      return(ret);
    }
    if (location >= 0x03f00000 && location <  0x03f0002f)
    {
      r_memcpy(&ret, &RDram_Registers[location & 0xff], 8);
      return(ret);
    }
  }
  if (location <= 0x003fffff)
  {
    r_memcpy(&ret, &RDram[location], 8);
    return(ret);
  }
  return 0;
}


BYTE getbyte (unsigned int location)
{
  BYTE ret = 0;

#ifdef DEBUGMEM
    printf("** Reading from memory location %08X\n", location);
#endif
  location &= 0x1FFFFFFF;               // Everything WRAPS!!!

  if (location >= 0x1FC00000 && location <= 0x1FC007FF)
  {
    r_memcpy(&ret, &PIF_RxM[location & 0x7FF], 1);
    return(ret);
  }
  if (location >= 0x10000000)
  {
    r_memcpy(&ret, &g_n64rom[location & 0x0FFFFFFF], 1);
    return(ret);
  }
  if (location >= 0x03f00000 && location <= 0x04900000)
  {
    if (location >= 0x04800000 && location <= 0x0480001B)
    {
      r_memcpy(&ret, &SI_Registers[location & 0xff], 1);
      return(ret);
    }
    if (location >= 0x04700000 && location <= 0x0470001F)
    {
      r_memcpy(&ret, &RI_Registers[location & 0xff], 1);
      return(ret);
    }
    if (location >= 0x04600000 && location <= 0x04600033)
    {
      r_memcpy(&ret, &PI_Registers[location & 0xff], 1);
      return(ret);
    }
    if (location >= 0x04500000 && location <= 0x04500017)
    {
      r_memcpy(&ret, &AI_Registers[location & 0xff], 1);
      return(ret);
    }
    if (location >= 0x04400000 && location <= 0x04400037)
    {
      r_memcpy(&ret, &VI_Registers[location & 0xff], 1);
      return(ret);
    }
    if (location >= 0x04300000 && location <= 0x0430000F)
    {
      r_memcpy(&ret, &MI_Registers[location & 0xfF], 1);
      return(ret);
    }
    if (location >= 0x04200000 && location <= 0x0420000F)
    {
      r_memcpy(&ret, &DP_Span_Registers[location & 0xfF], 1);
      return(ret);
    }
    if (location >= 0x04100000 && location <= 0x0410001F)
    {
      r_memcpy(&ret, &DP_Cmd_Registers[location & 0xfF], 1);
      return(ret);
    }
    if (location >= 0x04000000 && location <  0x04002000)
    {
      r_memcpy(&ret, &boot[location & 0x1FFF], 1);
      return(ret);
    }
    if (location >= 0x03f00000 && location <  0x03f0002f)
    {
      r_memcpy(&ret, &RDram_Registers[location & 0xff], 1);
      return(ret);
    }
  }
  if (location <= 0x003fffff)
  {
    r_memcpy(&ret, &RDram[location], 1);
    return(ret);
  }
  return 0;
}

/*
void putmem (unsigned int location, QWORD data, unsigned char size)
{
  location &= 0x1FFFFFFF;               // Everything WRAPS!!!


  if (location >= 0x10000000)
  {
    return; // I don't really think we can do this!
  }
  if (location >= 0x03f00000 && location <= 0x04900000)
  {
    if (location >= 0x04800000 && location <= 0x0480001B)
    {
      r_memcpy(&SI_Registers[location & 0xff], &data, size);
      return;
    }
    if (location >= 0x04700000 && location <= 0x0470001F)
    {
      r_memcpy(&RI_Registers[location & 0xff], &data, size);
      return;
    }
    if (location >= 0x04600000 && location <= 0x04600033)
    {
      r_memcpy(&PI_Registers[location & 0xff], &data, size);
      return;
    }
    if (location >= 0x04500000 && location <= 0x04500017)
    {
      r_memcpy(&AI_Registers[location & 0xff], &data, size);
      return;
    }
    if (location >= 0x04400000 && location <= 0x04400037)
    {
      r_memcpy(&VI_Registers[location & 0xff], &data, size);
      return;
    }
    if (location >= 0x04300000 && location <= 0x0430000F)
    {
      r_memcpy(&MI_Registers[location & 0xfF], &data, size);
      return;
    }
    if (location >= 0x04200000 && location <= 0x0420000F)
    {
      r_memcpy(&DP_Span_Registers[location & 0xfF], &data, size);
      return;
    }
    if (location >= 0x04100000 && location <= 0x0410001F)
    {
      r_memcpy(&DP_Cmd_Registers[location & 0xfF], &data, size);
      return;
    }
    if (location >= 0x04000000 && location <  0x04002000)
    {
      r_memcpy(&boot[location & 0x1FFF], &data, size);
      return;
    }
    if (location >= 0x03f00000 && location <= 0x03f0002f)
    {
      r_memcpy(&RDram_Registers[location & 0xff], &data, size);
      return;
    }
  }
  if (location <= 0x003fffff)
    r_memcpy(&RDram[location & 0x003fffff], &data, size);
  return;
}
*/
void putbyte (unsigned int location, BYTE data)
{
  location &= 0x1FFFFFFF;               // Everything WRAPS!!!

  if (location >= 0x1FC007C0 && location <= 0x1FC007FF)
  {
    r_memcpy(&PIF_RxM[location & 0x7FF], &data, 1);
    return;
  }

  if (location >= 0x10000000)
  {
    return; // I don't really think we can do this!
  }
  if (location >= 0x03f00000 && location <= 0x04900000)
  {
    if (location >= 0x04800000 && location <= 0x0480001B)
    {
      r_memcpy(&SI_Registers[location & 0xff], &data, 1);
      return;
    }
    if (location >= 0x04700000 && location <= 0x0470001F)
    {
      r_memcpy(&RI_Registers[location & 0xfF], &data, 1);
      return;
    }
    if (location >= 0x04600000 && location <= 0x04600034)
    {
      switch (location & 0xff)
      {
        case 0x00:
          PI.DRAM = data;
          break;
        case 0x04:
          PI.Cart = data;
          break;
        case 0x08:
          PI.RD_LEN = data;
          break;
        case 0x0C:
          PI.WR_LEN = data;
          Do_PI_Transfer();
          break;
        case 0x10:
          if (data < 2)
            r_memcpy(&PI_Registers[location & 0xff], &data, 1);
          return;
      }
      r_memcpy(&PI_Registers[location & 0xff], &data, 1);
      return;
    }
    if (location >= 0x04500000 && location <= 0x04500017)
    {
      r_memcpy(&AI_Registers[location & 0xff], &data, 1);
      return;
    }
    if (location >= 0x04400000 && location <= 0x04400037)
    {
      r_memcpy(&VI_Registers[location & 0xff], &data, 1);
      return;
    }
    if (location >= 0x04300000 && location <= 0x0430000F)
    {
      r_memcpy(&MI_Registers[location & 0xFf], &data, 1);
      return;
    }
    if (location >= 0x04200000 && location <= 0x0420000F)
    {
      r_memcpy(&DP_Span_Registers[location & 0xfF], &data, 1);
      return;
    }
    if (location >= 0x04100000 && location <= 0x0410001F)
    {
      r_memcpy(&DP_Cmd_Registers[location & 0xfF], &data, 1);
      return;
    }
    if (location >= 0x04000000 && location <  0x04002000)
    {
      r_memcpy(&boot[location & 0x1FFF], &data, 1);
      return;
    }
    if (location >= 0x03f00000 && location <= 0x03f0002f)
    {
      r_memcpy(&RDram_Registers[location & 0xff], &data, 1);
      return;
    }
  }
  if (location <= 0x003fffff)
    r_memcpy(&RDram[location & 0x003fffff], &data, 1);
  return;
}

void putdword (unsigned int location, DWORD data)
{
  location &= 0x1FFFFFFF;               // Everything WRAPS!!!


  if (location >= 0x1FC007C0 && location <= 0x1FC007FF)
  {
    r_memcpy(&PIF_RxM[location & 0x7FF], &data, 4);
    return;
  }
  if (location >= 0x10000000)
  {
    return; // I don't really think we can do this!
  }
  if (location >= 0x03f00000 && location <= 0x04900000)
  {
    if (location >= 0x04800000 && location <= 0x0480001B)
    {
      r_memcpy(&SI_Registers[location & 0xff], &data, 4);
      return;
    }
    if (location >= 0x04700000 && location <= 0x0470001F)
    {
      r_memcpy(&RI_Registers[location & 0xfF], &data, 4);
      return;
    }
    if (location >= 0x04600000 && location <= 0x04600034)
    {
      switch (location & 0xff)
      {
        case 0x00:
          PI.DRAM = data;
          break;
        case 0x04:
          PI.Cart = data;
          break;
        case 0x08:
          PI.RD_LEN = data;
          break;
        case 0x0C:
          PI.WR_LEN = data;
          Do_PI_Transfer();
          break;
        case 0x10:
          if (data < 2)
            r_memcpy(&PI_Registers[location & 0xff], &data, 4);
          return;
      }
      r_memcpy(&PI_Registers[location & 0xff], &data, 4);
      return;
    }
    if (location >= 0x04500000 && location <= 0x04500017)
    {
      r_memcpy(&AI_Registers[location & 0xff], &data, 4);
      return;
    }
    if (location >= 0x04400000 && location <= 0x04400037)
    {
      r_memcpy(&VI_Registers[location & 0xff], &data, 4);
      return;
    }
    if (location >= 0x04300000 && location <= 0x0430000F)
    {
      r_memcpy(&MI_Registers[location & 0xFf], &data, 4);
      return;
    }
    if (location >= 0x04200000 && location <= 0x0420000F)
    {
      r_memcpy(&DP_Span_Registers[location & 0xfF], &data, 4);
      return;
    }
    if (location >= 0x04100000 && location <= 0x0410001F)
    {
      r_memcpy(&DP_Cmd_Registers[location & 0xfF], &data, 4);
      return;
    }
    if (location >= 0x04000000 && location <  0x04002000)
    {
      r_memcpy(&boot[location & 0x1FFF], &data, 4);
      return;
    }
    if (location >= 0x03f00000 && location <= 0x03f0002f)
    {
      r_memcpy(&RDram_Registers[location & 0xff], &data, 4);
      return;
    }
  }
  if (location <= 0x003fffff)
    r_memcpy(&RDram[location & 0x003fffff], &data, 4);
  return;
}

void putqword (unsigned int location, QWORD data)
{
  location &= 0x1FFFFFFF;               // Everything WRAPS!!!


  if (location >= 0x1FC007C0 && location <= 0x1FC007FF)
  {
    r_memcpy(&PIF_RxM[location & 0x7FF], &data, 8);
    return;
  }
  if (location >= 0x10000000)
  {
    return; // I don't really think we can do this!
  }
  if (location >= 0x03f00000 && location <= 0x04900000)
  {
    if (location >= 0x04800000 && location <= 0x0480001B)
    {
      r_memcpy(&SI_Registers[location & 0xff], &data, 8);
      return;
    }
    if (location >= 0x04700000 && location <= 0x0470001F)
    {
      r_memcpy(&RI_Registers[location & 0xff], &data, 8);
      return;
    }
    if (location >= 0x04600000 && location <= 0x04600034)
    {
      switch (location & 0xff)
      {
        case 0x00:
          PI.DRAM = data;
          break;
        case 0x04:
          PI.Cart = data;
          break;
        case 0x08:
          PI.RD_LEN = data;
          break;
        case 0x0C:
          PI.WR_LEN = data;
          Do_PI_Transfer();
          break;
        case 0x10:
          if (data < 2)
            r_memcpy(&PI_Registers[location & 0xff], &data, 8);
          return;
      }
      r_memcpy(&PI_Registers[location & 0xff], &data, 8);
      return;
    }
    if (location >= 0x04500000 && location <= 0x04500017)
    {
      r_memcpy(&AI_Registers[location & 0xff], &data, 8);
      return;
    }
    if (location >= 0x04400000 && location <= 0x04400037)
    {
      r_memcpy(&VI_Registers[location & 0xff], &data, 8);
      return;
    }
    if (location >= 0x04300000 && location <= 0x0430000F)
    {
      r_memcpy(&MI_Registers[location & 0xfF], &data, 8);
      return;
    }
    if (location >= 0x04200000 && location <= 0x0420000F)
    {
      r_memcpy(&DP_Span_Registers[location & 0xfF], &data, 8);
      return;
    }
    if (location >= 0x04100000 && location <= 0x0410001F)
    {
      r_memcpy(&DP_Cmd_Registers[location & 0xfF], &data, 8);
      return;
    }
    if (location >= 0x04000000 && location <  0x04002000)
    {
      r_memcpy(&boot[location & 0x1FFF], &data, 8);
      return;
    }
    if (location >= 0x03f00000 && location <= 0x03f0002f)
    {
      r_memcpy(&RDram_Registers[location & 0xff], &data, 8);
      return;
    }
  }
  if (location <= 0x003fffff)
    r_memcpy(&RDram[location & 0x003fffff], &data, 8);
  return;
}

void putword (unsigned int location, WORD data)
{
  location &= 0x1FFFFFFF;               // Everything WRAPS!!!


  if (location >= 0x1FC007C0 && location <= 0x1FC007FF)
  {
    r_memcpy(&PIF_RxM[location & 0x7FF], &data, 2);
    return;
  }
  if (location >= 0x10000000)
  {
    return; // I don't really think we can do this!
  }
  if (location >= 0x03f00000 && location <= 0x04900000)
  {
    if (location >= 0x04800000 && location <= 0x0480001B)
    {
      r_memcpy(&SI_Registers[location & 0xff], &data, 2);
      return;
    }
    if (location >= 0x04700000 && location <= 0x0470001F)
    {
      r_memcpy(&RI_Registers[location & 0xff], &data, 2);
      return;
    }
    if (location >= 0x04600000 && location <= 0x04600034)
    {
      switch (location & 0xff)
      {
        case 0x00:
          PI.DRAM = data;
          break;
        case 0x04:
          PI.Cart = data;
          break;
        case 0x08:
          PI.RD_LEN = data;
          break;
        case 0x0C:
          PI.WR_LEN = data;
          Do_PI_Transfer();
          break;
        case 0x10:
          if (data < 2)
            r_memcpy(&PI_Registers[location & 0xff], &data, 2);
          return;
      }
      r_memcpy(&PI_Registers[location & 0xff], &data, 2);
      return;
    }
    if (location >= 0x04500000 && location <= 0x04500017)
    {
      r_memcpy(&AI_Registers[location & 0xff], &data, 2);
      return;
    }
    if (location >= 0x04400000 && location <= 0x04400037)
    {
      r_memcpy(&VI_Registers[location & 0xff], &data, 2);
      return;
    }
    if (location >= 0x04300000 && location <= 0x0430000F)
    {
      r_memcpy(&MI_Registers[location & 0xfF], &data, 2);
      return;
    }
    if (location >= 0x04200000 && location <= 0x0420000F)
    {
      r_memcpy(&DP_Span_Registers[location & 0xfF], &data, 2);
      return;
    }
    if (location >= 0x04100000 && location <= 0x0410001F)
    {
      r_memcpy(&DP_Cmd_Registers[location & 0xff], &data, 2);
      return;
    }
    if (location >= 0x04000000 && location <  0x04002000)
    {
      r_memcpy(&boot[location & 0x1FFF], &data, 2);
      return;
    }
    if (location >= 0x03f00000 && location <= 0x03f0002f)
    {
      r_memcpy(&RDram_Registers[location & 0xff], &data, 2);
      return;
    }
  }
  if (location <= 0x003fffff)
    r_memcpy(&RDram[location & 0x003fffff], &data, 2);
  return;
}
