#include "pvrfuncts.h" 

#ifdef PVR
#include <kos.h> 
/* textures */ 
#define TEX_WIDTH 512
#define TEX_HEIGHT 512
pvr_ptr_t vidram_tex; 
extern unsigned short   *vidram_buf;

/* init background */ 
void back_init() 
{ 
    vidram_tex = pvr_mem_malloc(TEX_WIDTH*TEX_HEIGHT*2); 

} 

/* draw background */ 
void draw_back() 
{ 
	//dcache_flush_range((uint32)vidram_buf, TEX_WIDTH*TEX_HEIGHT*2);
    //pvr_txr_load_dma(vidram_buf, vidram_tex, TEX_WIDTH*TEX_HEIGHT*2, 1); 
    pvr_txr_load    (vidram_buf, vidram_tex, TEX_WIDTH*TEX_HEIGHT*2);    
    
    pvr_poly_cxt_t cxt; 
    pvr_poly_hdr_t hdr; 
    pvr_vertex_t vert; 
    
    pvr_poly_cxt_txr(&cxt, PVR_LIST_OP_POLY, PVR_TXRFMT_RGB565|PVR_TXRFMT_NONTWIDDLED, TEX_WIDTH, TEX_HEIGHT, vidram_tex, PVR_FILTER_BILINEAR); 
                      
    pvr_poly_compile(&hdr, &cxt); 
    pvr_prim(&hdr, sizeof(hdr)); 

    vert.argb = PVR_PACK_COLOR(1.0f, 1.0f, 1.0f, 1.0f);    
    vert.oargb = 0; 
    vert.flags = PVR_CMD_VERTEX; 
    
    vert.x = 1; 
    vert.y = 1; 
    vert.z = 1; 
    vert.u = 0.0; 
    vert.v = 0.0; 
    pvr_prim(&vert, sizeof(vert)); 
    
    vert.x = 640; 
    vert.y = 1; 
    vert.z = 1; 
    vert.u = 1.0; 
    vert.v = 0.0; 
    pvr_prim(&vert, sizeof(vert)); 
    
    vert.x = 1; 
    vert.y = 480; 
    vert.z = 1; 
    vert.u = 0.0; 
    vert.v = 1.0; 
    pvr_prim(&vert, sizeof(vert)); 
    
    vert.x = 640; 
    vert.y = 480; 
    vert.z = 1; 
    vert.u = 1.0; 
    vert.v = 1.0;  
   vert.flags = PVR_CMD_VERTEX_EOL; 
   pvr_prim(&vert, sizeof(vert)); 

} 


/* draw one frame */ 
void draw_frame() 
{ 
    pvr_wait_ready(); 
    pvr_scene_begin(); 

    pvr_list_begin(PVR_LIST_OP_POLY); 

    draw_back(); 
    pvr_list_finish(); 

    pvr_scene_finish(); 
      
} 

void pvr_setup() 
{ 

    /* init kos  */ 
    pvr_init_defaults(); 
    pvr_dma_init(); 
    
    /* init background */ 
    back_init(); 
} 
#endif
