typedef struct VesaModeData
{
        unsigned short int           ModeAttributes;
        unsigned char           WindowAAttributes;
        unsigned char           WindowBAttributes;
        unsigned short int           WindowGranularity;
        unsigned short int           WindowSize;
        unsigned short int           StartSegmentWindowA;
        unsigned short int           StartSegmentWindowB;
        void            (*WindowPositioningFunction)(signed long page);
        unsigned short int           BytesPerScanLine;

//Remainder of this structure is optional for VESA modes in v1.0/1.1, needed for OEM modes.

        unsigned short int           PixelWidth;
        unsigned short int           PixelHeight;
        unsigned char           CharacterCellPixelWidth;
        unsigned char           CharacterCellPixelHeight;
        unsigned char           NumberOfMemoryPlanes;
        unsigned char           BitsPerPixel;
        unsigned char           NumberOfBanks;
        unsigned char           MemoryModelType;
        unsigned char           SizeOfBank;
        unsigned char           NumberOfImagePages;
        unsigned char           Reserved1;

//VBE v1.2+

        unsigned char           RedMaskSize;
        unsigned char           RedFieldPosition;
        unsigned char           GreenMaskSize;
        unsigned char           GreenFieldPosition;
        unsigned char           BlueMaskSize;
        unsigned char           BlueFieldPosition;
        unsigned char           ReservedMaskSize;
        unsigned char           ReservedFieldPosition;
        unsigned char           DirectColourModeInfo;

// VBE 2.0+

        unsigned long int       PhysBasePtr;
        unsigned long int       OffScreenMemOffset;
        unsigned short int      OffScreenMemSize;
        unsigned char           Reserved2[206];
} VesaModeData;

typedef struct RMREGS
{
        unsigned long           edi;
        unsigned long           esi;
        unsigned long           ebp;
        unsigned long           reserved;
        unsigned long           ebx;
        unsigned long           edx;
        unsigned long           ecx;
        unsigned long           eax;
        unsigned short int           flags;
        unsigned short int           es,ds,fs,gs,ip,cs,sp,ss;
} RMREGS;

unsigned short int vesa_granularity;
unsigned short int vesa_width;
unsigned short int vesa_height;
unsigned char vesa_bits_per_pixel;
unsigned char LFB;
__dpmi_meminfo LFB_mem;
