/* NINCEST 64
** (c)1998-2000 by Marius Dumitrean P. and Chris Le Blond
*/

#ifndef R4300_H
#define R4300_H
#include "global.h"
//#if defined(__cplusplus)
//extern "C"
//{
//#endif

struct regs_typ Nregs;

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define u32	unsigned long
#define	u8	unsigned char
#define                 BYTE            unsigned char
#define                 WORD            unsigned short int
#define                 DWORD           unsigned long
#define                 QWORD           unsigned long long

#define                 TRUE                    1
#define                 FALSE                   0

typedef struct {
	DWORD hh,hl;
	DWORD lh,ll;
	BYTE isGlobal;
} s_tlb;

extern BYTE getbyte ( unsigned int );
extern WORD getword ( unsigned int );
extern DWORD getdword ( unsigned int );
extern QWORD getqword ( unsigned int );

extern void putbyte ( unsigned int, BYTE );
extern void putword ( unsigned int, WORD );
extern void putdword ( unsigned int, DWORD );
extern void putqword ( unsigned int, QWORD );
extern ROMHeader n64header;
extern char MI_Registers[0x0F];        // 0430000h
/* user friendlyness needed? */
#define		main_reg_r0			Nregs.main.regs[0]
#define		main_reg_v0			Nregs.main.regs[1]
#define		main_reg_v1			Nregs.main.regs[2]
#define		main_reg_a0			Nregs.main.regs[3]
#define		main_reg_a1			Nregs.main.regs[4]
#define		main_reg_a2			Nregs.main.regs[5]
#define		main_reg_a3			Nregs.main.regs[6]
#define		main_reg_t0			Nregs.main.regs[7]
#define		main_reg_t1			Nregs.main.regs[8]
#define		main_reg_t2			Nregs.main.regs[9]
#define		main_reg_t3			Nregs.main.regs[10]
#define		main_reg_t4			Nregs.main.regs[11]
#define		main_reg_t5			Nregs.main.regs[12]
#define		main_reg_t6			Nregs.main.regs[13]
#define 	main_reg_t7			Nregs.main.regs[14]
#define 	main_reg_s0			Nregs.main.regs[15]
#define		main_reg_s1			Nregs.main.regs[16]
#define		main_reg_s2			Nregs.main.regs[17]
#define		main_reg_s3			Nregs.main.regs[18]
#define		main_reg_s4			Nregs.main.regs[19]
#define		main_reg_s5			Nregs.main.regs[20]
#define		main_reg_s6			Nregs.main.regs[21]
#define		main_reg_s7			Nregs.main.regs[22]
#define		main_reg_t8			Nregs.main.regs[23]
#define		main_reg_t9			Nregs.main.regs[24]
#define		main_reg_k0			Nregs.main.regs[25]
#define		main_reg_k1			Nregs.main.regs[26]
#define		main_reg_gp			Nregs.main.regs[27]
#define		main_reg_sp			Nregs.main.regs[28]
#define		main_reg_s8			Nregs.main.regs[29]
#define		main_reg_ra			Nregs.main.regs[30]
/* end being friendly! */

//struct main_typ
//{
//  QWORD regs[0x20];
//};
//
//struct COP0_typ
//{
//  QWORD regs[0x20];
//};
//
//struct COP1_typ
//{
//  DWORD regs[0x20]; // DAMN YOU BPOINT!
//};
//
//
//struct regs_typ
//{
//  DWORD PC;
//  DWORD REAL_PC;
//  QWORD MultHI;
//  QWORD MultLO;
//  struct main_typ main;
//  struct COP0_typ cop0;
//  struct COP1_typ cop1;
//} Nregs;

void print_regs ( void );
void print_log (const char *text, ... );


// Exception types //
#define                         R4300_INT               0       // interrupt
#define                         R4300_TLBMOD            1       // tlb modification
#define                         R4300_TLBLOAD           2       // tlb load

char          DebugFile[20];            // For crashes!
unsigned int  DebugLine;                //  "     "
#ifdef DEBUG_EXEC
  #ifdef __LINE__
    #ifdef __FILE__
      // WOW!! Cool compiler! //
      #define         lastexec {strcpy(DebugFile, __FILE__); DebugLine=__LINE__;}
    #endif
  #endif
#endif

QWORD instructions;
//#if defined(__cplusplus)
//}
//#endif
#endif
