/* notes:
**
*/
// 971 3772


//
//#include "main.h"
#include "r4300.h"
//#include "memhand.h"
#ifdef VIDEO
#include "video.h"
extern void (*Do_Video)();
#endif

void init_mem ( void );
extern void Reset_Video ( void );
s_tlb tlb[32];
//#include <signal.h>

#ifdef DEBUG
#include "debug.h"
#endif

#define eop_n                           op_n

#define r4300_opcode()                  (BYTE)(opcode >> 26)
#define r4300_rt()                      (BYTE)(opcode >> 16) & 0x1f
#define r4300_rs()                      (BYTE)(opcode >> 21) & 0x1f
#define r4300_rd()                      (BYTE)(opcode >> 11) & 0x1f
#define r4300_sa()                      (BYTE)(opcode >> 6) & 0x1f
#define r4300_eopcode()                 (BYTE)(opcode) & 0x3f
#define r4300_offset()                  (WORD)opcode

#define r4300_copXop()                  r4300_rs()
#define r4300_base()                    r4300_rs()
#define r4300_fmt()                     r4300_rs()
#define r4300_ft()                      r4300_rt()
#define r4300_fs()                      r4300_rd()
#define r4300_fd()			r4300_sa()

// Normal opcodes
void op_n ( void );
void op_ori ( void );
void op_lui ( void );
void op_mtc0 ( void );
void op_addiu ( void );
void op_beq ( void );
void op_nop ( void );
void op_lw ( void );
void op_lwc1 ( void );
void op_swc2 ( void );
void op_bne ( void );
void op_sw ( void );
void op_addi ( void );
void op_jal ( void );
void op_slti ( void );
void op_sltiu ( void );
void op_beql ( void );
void op_andi ( void );
void op_xori ( void );
void op_bnel ( void );
void op_blezl ( void );
void op_sb ( void );
void op_lbu ( void );
void op_bgezl ( void );
void op_cache ( void );
void op_cop1 ( void );
void op_cop0 ( void );
void op_mfc0 ( void );
void op_blez ( void );
void op_cfc1 ( void );
void op_ctc1 ( void );
void op_extra ( void );                 // Extra opcodes:)
void op_ld ( void );
void op_sd ( void );
void op_sh ( void );
void op_lhu ( void );
void op_lh ( void );
void op_eret ( void );
void op_tlbwi ( void );
void op_tlbp ( void );
void op_tlbr ( void );
void op_tlbwr ( void );
void op_mtc1 ( void );
void op_mfc1 ( void );
void op_j ( void );
void op_cvt_s ( void );
void op_cvt_d ( void );
void op_div_x ( void );
void op_mul_x ( void );
void op_add_x ( void );
void op_trc_w ( void );
void op_lwl ( void );
void op_lwr ( void );
void op_swr ( void );
void op_lb ( void );
void op_swl ( void );
void op_bgtz ( void );

// Extras
void eop_sll ( void );
void eop_rsv ( void );
void eop_sltu ( void );
void eop_jr ( void );
void eop_jalr ( void );
void eop_or ( void );
void eop_srl ( void );
void eop_subu ( void );
void eop_multu ( void );
void eop_mflo ( void );
void eop_mtlo ( void );
void eop_addu ( void );
void eop_and ( void );
void eop_slt ( void );
void eop_add ( void );
void eop_srlv ( void );
void eop_sllv ( void );
void eop_xor ( void );
void eop_dsll32 ( void );
void eop_dsra32 ( void );
void eop_mult ( void );
void eop_dmultu ( void );
void eop_ddivu ( void );
void eop_div ( void );
void eop_mthi ( void );
void eop_mfhi ( void );
void eop_sra ( void );


void SwapWords(DWORD *);

DWORD opcode;
DWORD temp_4op;                                 // a temp variable for opcodes

char *reg_str[0x20] =
{
  "r0", "at", "v0", "v1", "a0", "a1", "a2", "a3", "t0", "t1", "t2",
  "t3", "t4", "t5", "t6", "t7", "s0", "s1", "s2", "s3", "s4", "s5",
  "s6", "s7", "t8", "t9", "k0", "k1", "gp", "sp", "s8", "ra"
};
char *reg_cop0[0x20] =
{
  "Index", "Random", "EntryLo0", "EntryLo1", "Context", "PageMask", "Wired",
  "RESERVED", "BadVAddr", "Count", "EntryHi", "Compare", "Status", "Cause",
  "ExceptPC", "PRevID", "Config", "LLAddr", "WatchLo", "WatchHi", "XContext", "RESERVED",
  "RESERVED", "RESERVED", "RESERVED", "RESERVED", "PErr", "CacheErr", "TagLo",
  "TagHi", "ErrorEPC", "RESERVED"
};

char *reg_cop1[0x20] =
{
  "f00","f01","f02","f03","f04","f05","f06","f07","f08","f09","f10","f11",
  "f12","f13","f14","f15","f16","f17","f18","f19","f20","f21","f22","f23",
  "f24","f25","f26","f27","f28","f29","f30","f31",
};

void (*opcodes[0x40])() =
{// 0        1        2        3        4        5        6        7
    op_extra,op_bgezl,op_j,    op_jal,  op_beq,  op_bne,  op_blez, op_bgtz,  // 0
    op_addi, op_addiu,op_slti, op_sltiu,op_andi, op_ori,  op_xori, op_lui,// 1
    op_cop0, op_cop1, op_n,    op_n,    op_beql, op_bnel, op_blezl,op_n,  // 2
    op_n,    op_n,    op_n,    op_n,    op_n,    op_n,    op_n,    op_n,  // 3
    op_lb,   op_lh,   op_lwl,  op_lw,   op_lbu,  op_lhu,  op_lwr,  op_n,  // 4
    op_sb,   op_sh,   op_swl,  op_sw,   op_n,    op_n,    op_swr,  op_cache,// 5
    op_n,    op_lwc1, op_n,    op_n,    op_n,    op_n,    op_n,    op_ld, // 6
    op_n,    op_swc2,    op_n,    op_n,    op_n,    op_n,    op_n,    op_sd, // 7
};

void (*eopcodes[0x40])() =
{// 0         1         2         3         4         5         6         7
    eop_sll,  eop_rsv,    eop_srl,  eop_sra,  eop_sllv, eop_n,    eop_srlv, eop_n,  // 0
    eop_jr,   eop_jalr,    eop_n,    eop_n,    eop_n,    eop_n,    eop_n,    eop_n,  // 1
    eop_mfhi, eop_mthi, eop_mflo, eop_mtlo, eop_n,    eop_n,    eop_n,    eop_n,  // 2
    eop_mult, eop_multu,eop_div,  eop_n,    eop_n,    eop_dmultu,eop_n,   eop_ddivu,// 3
    eop_add,  eop_addu, eop_n,    eop_subu, eop_and,  eop_or,   eop_xor,  eop_n,  // 4
    eop_n,    eop_n,    eop_slt,  eop_sltu, eop_n,    eop_n,    eop_n,    eop_n,  // 5
    eop_n,    eop_n,    eop_n,    eop_n,    eop_n,    eop_n,    eop_n,    eop_n,  // 6
    eop_n,    eop_n,    eop_n,    eop_n,    eop_dsll32,eop_n,   eop_n,    eop_dsra32,  // 7
};

void (*cop0_0[0x3F])() =
{
    op_n,    op_tlbr, op_tlbwi,op_n,    op_n,    op_n,    op_tlbwr,op_n,    
    op_tlbp, op_n,    op_n,    op_n,    op_n,    op_n,    op_n,    op_n,
    op_n,    op_n,    op_n,    op_n,    op_n,    op_n,    op_n,    op_n,
    op_eret, op_n,    op_n,    op_n,    op_n,    op_n,    op_n,    op_n,
    op_n,    op_n,    op_n,    op_n,    op_n,    op_n,    op_n,    op_n,
    op_n,    op_n,    op_n,    op_n,    op_n,    op_n,    op_n,    op_n
};

void (*cop0_1[0x1F])() =
{
    op_mfc0, op_n,    op_n,    op_n,    op_mtc0, op_n,    op_n,    op_n,
    op_n,    op_n,    op_n,    op_n,    op_n,    op_n,    op_n,    op_n,
    op_mtc0,    op_n,    op_n,    op_n,    op_n,    op_n,    op_n,    op_n
};

void (*cop1_0[0x3F])() =
{
    op_add_x,op_n,    op_mul_x,op_div_x,op_n,    op_n,    op_n,    op_n,
    op_n,    op_n,    op_n,    op_n,    op_n,    op_trc_w,op_n,    op_n,
    op_n,    op_n,    op_n,    op_n,    op_n,    op_n,    op_n,    op_n,
    op_n,    op_n,    op_n,    op_n,    op_n,    op_n,    op_n,    op_n,
    op_cvt_s,op_cvt_d,op_n,    op_n,    op_n,    op_n,    op_n,    op_n,
    op_n,    op_n,    op_n,    op_n,    op_n,    op_n,    op_n,    op_n
};

void (*cop1_1[0x1F])() =
{
    op_mfc1, op_n,    op_cfc1, op_n,    op_mtc1, op_n,    op_ctc1, op_n,
    op_n,    op_n,    op_n,    op_n,    op_n,    op_n,    op_n,    op_n,
    op_n,    op_n,    op_n,    op_n,    op_n,    op_n,    op_n,    op_n
};

void op_cop0 ( void )
{
  if (opcode & 0x7FF){
    cop0_0[r4300_eopcode()]();
    //printf("%d\n",r4300_eopcode());
    }
  else
    cop0_1[r4300_copXop()]();
}

void op_cop1 ( void )
{
  temp_4op = r4300_fmt();
  if ((temp_4op == 16 || temp_4op == 17) || (temp_4op == 20 || temp_4op == 21))
    cop1_0[r4300_eopcode()]();
  else
    cop1_1[r4300_copXop()]();
}

void op_extra ( void )
{
  eopcodes[r4300_eopcode()]();
}

void print_regs ( void )
{
  int i;

  printf("GPR:\n ");
  for (i = 0; i < 0x20;)
  {
    printf("%2s: %08X ", reg_str[i], Nregs.main.regs[i]);
    i++;
    if (i%6 == 0)
      printf("\n ");
  }
  printf("\nMultLO: %016LX\tMultHI: %016LX\n", Nregs.MultLO, Nregs.MultHI);

  printf("Instruction #: %08LX\n", instructions);

  printf("\n");
  printf("FGR:\n ");
  for (i = 0; i < 0x20;)
  {
    printf("%8s: %08X ", reg_cop0[i], Nregs.cop0.regs[i]);
    i++;
    if (i%4 == 0)
      printf("\n ");
  }
  printf("\n");
}

void GenerateException ( unsigned char type )
{ // page 151
  unsigned short int vector;
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
#endif
  switch (type)
  {
    case R4300_INT:             // Interrupt
      if (Nregs.cop0.regs[12] & 0x01)
      {
        if (((Nregs.cop0.regs[12]>>8)&0xff) & ((Nregs.cop0.regs[13]>>8)&0xff))
        {
//          printf("YOU PIECE OF CRAP WORK\n");
#ifdef VIDEO        
          Do_Video();
#endif
          if (Nregs.cop0.regs[12] & 0x02)
          {
            Nregs.cop0.regs[14] = Nregs.PC;
            Nregs.cop0.regs[13] &= 0x0000ff00;
            Nregs.cop0.regs[13] |= type<<2;

            vector = 0x180;

          }
          else
          {
            Nregs.cop0.regs[13] &= 0x8000ff00;
            Nregs.cop0.regs[13] |= type<<2;
            vector = 0x180;
          }
          Nregs.cop0.regs[12] |= 0x02;
          if ((Nregs.cop0.regs[12] >> 22) & 0x01)
            Nregs.PC = 0xBFC00200 + vector;
          else
            Nregs.PC = 0x80000000 + vector;
        }
      }
      break;
  }
}

void crash ( void )
{
  Reset_Video();

  printf("Crash - %d/%s <-- EMail this to marius@faraway.ml.org\n", DebugLine, DebugFile);
  exit(0);
}

void c_exit ( void ) // ctrl-c exit
{
  Reset_Video();

  printf("\r\nCTRL-C pressed at PC=%08X\n",Nregs.PC);
  print_regs();
  exit(0);
}

void emulate ( void )
{
//  typedef void (*sig_t) (int);
//  signal(SIGSEGV,(sig_t)crash);                 // Whoa Shiznit! Crash Handler //
//  signal(SIGILL,(sig_t)crash);                  // Whoa Shiznit! Crash Handler //
//  signal(SIGFPE,(sig_t)crash);                  // Whoa Shiznit! Crash Handler //
//#ifdef VIDEO
//  signal(SIGINT,(sig_t)c_exit);                   // CTRL-C (just drop some usefull info) //
//#endif
  #ifdef DEBUG_EXEC
    lastexec;
  #endif

  init_mem();
  Nregs.PC = 0xA4000040;
	u32 i;
	for (i=0; i < 32; i++) {
		tlb[i].hh = tlb[i].hl = tlb[i].ll = tlb[i].lh = 0;
		tlb[i].isGlobal = 0;
	}
#ifdef DEBUG
  debug.break_op = -1;
  debug.info_nec = 1;
  debug.show_regs = 0;
  jump_cnt = 0;
  instructions = 0;
  signal(SIGINT, (sig_t)stop_cont);             
#endif

  Nregs.cop0.regs[0x0C] = 0x00400004;    // Status
  Nregs.cop0.regs[0x0F] = 0x00000411;    // PRevID
  Nregs.cop0.regs[0x10] = 0x00066463;    // Config
  Nregs.cop0.regs[0x01] = 0x2F;          // Random
  Nregs.main.regs[0x1D] = 0x400000;      // SP
  Nregs.main.regs[0x16] = 0x3F;          // S6?
  Nregs.main.regs[0x14] = 1;             // S4
  Nregs.MultHI = 0;
  Nregs.MultLO = 0;
  while (1)
  {
    instructions++;
    if (instructions % 625000 == 0)
    {
      Nregs.cop0.regs[13] |= 4 << 8;
//      if (MI_Registers[0x0C] & 0x08)
      putdword(0xa4300008, getdword(0xa4300008) | (DWORD)0x08);
//      *((DWORD*)&MI_Registers[0x8]) = *((DWORD*)&MI_Registers[0x8]) | (DWORD)(0x);
      GenerateException(R4300_INT);
    }
    Nregs.cop0.regs[0x01]--;
    Nregs.cop0.regs[0x01] &= 0x3f;
    opcode=getdword(Nregs.PC);
#ifdef DEBUG                            // Break on address / opcode?
    if (debug.break_addr == Nregs.PC)
    {
      debug.cont = 0;
      debug.info_nec = 1;
      debug.break_addr = 0;
      get_debug_input("*** Break on address\n");
    }
    if (debug.break_op == opcode && debug.break_op != -1)
    {
      debug.cont = 0;
      debug.info_nec = 1;
      debug.break_op = -1;
      get_debug_input("*** Break on opcode\n");
    }
#endif

    // where everything gets run //
    opcodes[r4300_opcode()]();
#ifdef DEBUG
    if (debug.show_regs == 1)
      print_regs();
#endif
  }
}

void eop_sll ( void )
{
  if (opcode == 0)
  {
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
    get_debug_input("NOP");
#endif
  }
  else
  {
#ifdef DEBUG
    get_debug_input("SLL %2s,%2s,%02X", reg_str[r4300_rt()], reg_str[r4300_rd()], r4300_sa());
#endif
    Nregs.main.regs[r4300_rd()] = (DWORD)(Nregs.main.regs[r4300_rt()] << (DWORD)(r4300_sa())) ;
  }
  Nregs.PC+=4;
}

void eop_rsv ( void )
{
 printf("RESERVED\n");
}

void eop_dsra32 ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("DSRA32 %2s,%2s,%02X", reg_str[r4300_rd()], reg_str[r4300_rt()], r4300_sa());
#endif
  Nregs.main.regs[r4300_rd()] = (signed long long)((QWORD)Nregs.main.regs[r4300_rt()] >> ((QWORD)(r4300_sa()) + 32) );
  Nregs.PC+=4;
}

void eop_dsll32 ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("DSLL32 %2s,%2s,%02X", reg_str[r4300_rd()], reg_str[r4300_rt()], r4300_sa());
#endif
  Nregs.main.regs[r4300_rd()] = (QWORD)(Nregs.main.regs[r4300_rt()] << (QWORD)(r4300_sa() + 32) ) ;
  Nregs.PC+=4;
}

void eop_srl ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("SRL %2s,%2s,%02X", reg_str[r4300_rt()], reg_str[r4300_rd()], r4300_sa());
#endif
  Nregs.main.regs[r4300_rd()] = (DWORD)(Nregs.main.regs[r4300_rt()] >> (DWORD)(r4300_sa())) ;
  Nregs.PC+=4;
}

void eop_sra ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("SRA %2s,%2s,%02X", reg_str[r4300_rd()], reg_str[r4300_rt()], r4300_sa());
#endif
  Nregs.main.regs[r4300_rd()] = (signed int)(Nregs.main.regs[r4300_rt()] >> (DWORD)(r4300_sa())) ;
  Nregs.PC+=4;
}

void eop_subu ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("SUBU %2s,%2s,%2s", reg_str[r4300_rd()], reg_str[r4300_rs()], reg_str[r4300_rt()]);
#endif
  Nregs.main.regs[r4300_rd()] = (unsigned)Nregs.main.regs[r4300_rs()] - (unsigned)Nregs.main.regs[r4300_rt()] ;
  Nregs.PC += 4;
}

void eop_dmultu ( void )
{ // we cheat - hi bpoint/truereality 64 guy!:-) //
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("DMULTU %2s,%2s", reg_str[r4300_rs()], reg_str[r4300_rt()]);
#endif
  Nregs.MultLO = (QWORD)((QWORD)Nregs.main.regs[r4300_rs()] * (QWORD)Nregs.main.regs[r4300_rt()]);
  Nregs.MultHI = 0;
  Nregs.PC += 4;
}

void eop_multu ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("MULTU %2s,%2s", reg_str[r4300_rs()], reg_str[r4300_rt()]);
#endif
  Nregs.MultLO = (QWORD)((DWORD)Nregs.main.regs[r4300_rs()] * (DWORD)Nregs.main.regs[r4300_rt()]) & 0xffffffff;
  Nregs.MultHI = ((QWORD)Nregs.main.regs[r4300_rs()] * (QWORD)Nregs.main.regs[r4300_rt()]) >> 32;
  Nregs.PC += 4;
}

void eop_mult ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("MULT %2s,%2s", reg_str[r4300_rs()], reg_str[r4300_rt()]);
#endif
  Nregs.MultLO = (signed long long)((signed int)Nregs.main.regs[r4300_rs()] * (signed int)Nregs.main.regs[r4300_rt()]) & 0xffffffff;
  Nregs.MultHI = ((signed long long)Nregs.main.regs[r4300_rs()] * (signed long long)Nregs.main.regs[r4300_rt()]) >> 32;
  Nregs.PC += 4;
}

void eop_addu ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("ADDU %2s,%2s,%2s", reg_str[r4300_rd()], reg_str[r4300_rs()], reg_str[r4300_rt()]);
#endif
  Nregs.main.regs[r4300_rd()] = (DWORD)(Nregs.main.regs[r4300_rs()] + Nregs.main.regs[r4300_rt()]);
  Nregs.PC += 4;
}

void eop_mflo ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("MFLO %2s", reg_str[r4300_rd()]);
#endif
  Nregs.main.regs[r4300_rd()] = Nregs.MultLO;
  Nregs.PC += 4;
}

void eop_mfhi ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("MFHI %2s", reg_str[r4300_rd()]);
#endif
  Nregs.main.regs[r4300_rd()] = Nregs.MultHI;
  Nregs.PC += 4;
}

void eop_mthi ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("MTHI %2s", reg_str[r4300_rd()]);
#endif
  Nregs.MultHI = Nregs.main.regs[r4300_rd()];
  Nregs.PC += 4;
}

void eop_mtlo ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("MTLO %2s", reg_str[r4300_rd()]);
#endif
  Nregs.MultLO = Nregs.main.regs[r4300_rd()];
  Nregs.PC += 4;
}

void eop_sllv ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("SLLV %2s,%2s,%2s", reg_str[r4300_rd()], reg_str[r4300_rt()], reg_str[r4300_rs()]);
#endif
  Nregs.main.regs[r4300_rd()] = (DWORD)(Nregs.main.regs[r4300_rt()]) << Nregs.main.regs[r4300_rs()];
  Nregs.PC+=4;
}

void eop_ddivu ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("DDIVU %2s,%2s", reg_str[r4300_rs()], reg_str[r4300_rt()]);
#endif
  Nregs.MultLO = (QWORD)((QWORD)Nregs.main.regs[r4300_rs()] / (QWORD)Nregs.main.regs[r4300_rt()]);
  Nregs.MultHI = (QWORD)((QWORD)Nregs.main.regs[r4300_rs()] % (QWORD)Nregs.main.regs[r4300_rt()]);
  Nregs.PC += 4;
}

void eop_div ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("DIV %2s,%2s", reg_str[r4300_rs()], reg_str[r4300_rt()]);
#endif
  Nregs.MultLO = (QWORD)((DWORD)Nregs.main.regs[r4300_rs()] / (DWORD)Nregs.main.regs[r4300_rt()]);
  Nregs.MultHI = (QWORD)((DWORD)Nregs.main.regs[r4300_rs()] % (DWORD)Nregs.main.regs[r4300_rt()]);
  Nregs.PC += 4;
}

void eop_srlv ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("SRLV %2s,%2s,%2s", reg_str[r4300_rd()], reg_str[r4300_rt()], reg_str[r4300_rs()]);
#endif
  Nregs.main.regs[r4300_rd()] = (DWORD)(Nregs.main.regs[r4300_rt()]) >> Nregs.main.regs[r4300_rs()];
  Nregs.PC+=4;
}

void eop_slt ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("SLT %2s,%2s,%2s", reg_str[r4300_rs()], reg_str[r4300_rt()], reg_str[r4300_rd()]);
#endif
  if ((signed)Nregs.main.regs[r4300_rs()] < (signed)Nregs.main.regs[r4300_rt()])
    Nregs.main.regs[r4300_rd()] = 1;
  else
    Nregs.main.regs[r4300_rd()] = 0;
  Nregs.PC+=4;
}

void eop_sltu ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("SLTU %2s,%2s,%2s", reg_str[r4300_rs()], reg_str[r4300_rt()], reg_str[r4300_rd()]);
#endif
//** until further notice, r4300_rd == r4300_rt in here
  if ((unsigned)Nregs.main.regs[r4300_rs()] < (unsigned)Nregs.main.regs[r4300_rt()])
    Nregs.main.regs[r4300_rd()] = 1;
//    Nregs.main.regs[r4300_rt()] = 1;
  else
    Nregs.main.regs[r4300_rd()] = 0;
//    Nregs.main.regs[r4300_rt()] = 0;
  Nregs.PC+=4;
}

void eop_xor ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("XOR %2s,%2s,%2s", reg_str[r4300_rd()], reg_str[r4300_rs()], reg_str[r4300_rt()]);
#endif
  Nregs.main.regs[r4300_rd()] = Nregs.main.regs[r4300_rs()] ^ Nregs.main.regs[r4300_rt()];

  Nregs.PC+=4;
}

void eop_or ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("OR %2s,%2s,%2s", reg_str[r4300_rd()], reg_str[r4300_rs()], reg_str[r4300_rt()]);
#endif
  Nregs.main.regs[r4300_rd()] = Nregs.main.regs[r4300_rs()] | Nregs.main.regs[r4300_rt()];

  Nregs.PC+=4;
}

void eop_jr ( void )
{
  temp_4op = (DWORD)Nregs.main.regs[r4300_rs()];
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("JR %2s", reg_str[r4300_rs()]);
  JUMPS[jump_cnt++] = Nregs.main.regs[r4300_rs()];
#endif
  opcode=getdword(Nregs.PC + 4);
  opcodes[r4300_opcode()]();
  Nregs.PC = temp_4op;
}

void eop_jalr ( void )
{
   //printf("eop_jalr\n");
	temp_4op = (DWORD)Nregs.main.regs[r4300_rs()];
  opcode=getdword(Nregs.PC + 8);
  opcodes[r4300_opcode()]();
  Nregs.PC = temp_4op;
}

void op_tlbwi ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("NOT IMPLEMENTED YET -- ASK BPOINT!:-)\n");
#endif
printf("op_tlbwi\n");
	int j = Nregs.cop0.regs[0] & 0x1f;
	tlb[j].hh = Nregs.cop0.regs[5];
	tlb[j].hl = Nregs.cop0.regs[10] & (~Nregs.cop0.regs[5]);
	tlb[j].lh = Nregs.cop0.regs[2] & 0xFFFFFFFE;
	tlb[j].ll = Nregs.cop0.regs[3] & 0xFFFFFFFE;
	tlb[j].isGlobal = (u8)(Nregs.cop0.regs[2] & Nregs.cop0.regs[3] & 0x1);
  Nregs.PC+=4;
}

void op_tlbp ( void )
{
//#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  printf("op_tlbp\n");
//#endif
//	Nregs.cop0.regs[0]=0x80000000;
//	for (int i=0; i < 32; i++) {
//		if((tlb[i].hl&0xfffff000) == (Nregs.cop0.regs[10]&0xfffff000)) {//assumes it is always global
//			Nregs.cop0.regs[0]=i;
//			return;
//		}
//	}	
  Nregs.PC+=4;
}

void op_tlbr ( void )
{
//#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  printf("op_tlbr\n");
//#endif
	int j = Nregs.cop0.regs[0] & 0x1f;
	Nregs.cop0.regs[5] = tlb[j].hh;
	Nregs.cop0.regs[10] = tlb[j].hl & (~tlb[j].hh);
	Nregs.cop0.regs[2] = tlb[j].lh | tlb[j].isGlobal;
	Nregs.cop0.regs[3] = tlb[j].ll | tlb[j].isGlobal;
  Nregs.PC+=4;
}
void op_tlbwr ( void )
{
//#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  printf("op_tlbwr NOT IMPLEMENTED YET -- ASK BPOINT!:-)\n");
//#endif
  Nregs.PC+=4;
}

void op_cache ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("CACHE (NOT SUPPORTED)");
#endif
  Nregs.PC+=4;
}

// This opcode uhm.. this is Niki Waibels' work.  I was too lazy to write it
// myself.  I presume I'll write more COP1 opcodes based off of this opcode.
void op_cvt_s ( void )
{
  switch (r4300_fmt())
  {
    case 17: // D
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
      get_debug_input("CVT.S.D %s,%s", reg_cop1[r4300_fd()], reg_cop1[r4300_fs()]);
#endif
      *((float *)&Nregs.cop1.regs[r4300_fd()]) = (float) *( (double *)&Nregs.cop1.regs[r4300_fs()] );
      break;
    case 20: // W
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
      get_debug_input("CVT.S.W %s,%s", reg_cop1[r4300_fd()], reg_cop1[r4300_fs()]);
#endif
      *((float *)&Nregs.cop1.regs[r4300_fd()]) = (float)(signed long)Nregs.cop1.regs[r4300_fs()];
      break;
    case 21: // L
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
      get_debug_input("CVT.S.L %s,%s", reg_cop1[r4300_fd()], reg_cop1[r4300_fs()]);
#endif
      *((float *)&Nregs.cop1.regs[r4300_fd()]) = (float)(signed long long)Nregs.cop1.regs[r4300_fs()];
      break;
    default:
      break;
  }
  Nregs.PC+=4;                           
}

void op_trc_w ( void )
{

  switch (r4300_fmt())
  {
    case 16: // S
#ifdef DEBUG                            
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
      get_debug_input("TRUNC.W.S %2s,%2s", reg_cop1[r4300_fd()], reg_cop1[r4300_fs()]);
#endif
      *((signed long *)&Nregs.cop1.regs[r4300_fd()]) = (signed long long) *((float *)&Nregs.cop1.regs[r4300_fs()] );
      break;
    case 17: // D
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
      get_debug_input("TRUNC.W.D %s,%s", reg_cop1[r4300_fd()], reg_cop1[r4300_fs()]);
#endif
      *((signed long *)&Nregs.cop1.regs[r4300_fd()]) = (signed long long) *( (double *)&Nregs.cop1.regs[r4300_fs()] );
      break;
    case 20: // W
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
      get_debug_input("TRUNC.W.W %s,%s", reg_cop1[r4300_fd()], reg_cop1[r4300_fs()]);
#endif
      break;
    case 21: // L
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
      get_debug_input("TRUNC.W.L %s,%s", reg_cop1[r4300_fd()], reg_cop1[r4300_fs()]);
#endif
      break;
    default:
      break;
  }
  Nregs.PC+=4;                           
}

void op_cvt_d ( void )
{
  switch (r4300_fmt())
  {
    case 16: // S
#ifdef DEBUG                            
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
      get_debug_input("CVT.D.S %2s,%2s", reg_cop1[r4300_fd()], reg_cop1[r4300_fs()]);
#endif
      *((double *)&Nregs.cop1.regs[r4300_fd()]) = (double) *( (float *)&Nregs.cop1.regs[r4300_fs()] );
      break;
    case 17: // D
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
      get_debug_input("CVT.D.D %s,%s", reg_cop1[r4300_fd()], reg_cop1[r4300_fs()]);
#endif
      break;
    case 20: // W
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
      get_debug_input("CVT.D.W %s,%s", reg_cop1[r4300_fd()], reg_cop1[r4300_fs()]);
#endif
      *((double *)&Nregs.cop1.regs[r4300_fd()]) = (double)(signed long)Nregs.cop1.regs[r4300_fs()];
      break;
    case 21: // L
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
      get_debug_input("CVT.D.L %s,%s", reg_cop1[r4300_fd()], reg_cop1[r4300_fs()]);
#endif
      *((double *)&Nregs.cop1.regs[r4300_fd()]) = (double)(signed long long)Nregs.cop1.regs[r4300_fs()];
      break;
    default:
      break;
  }

  Nregs.PC+=4;                        
}

void op_div_x ( void )
{
  switch (r4300_fmt())
  {
    case 16: // S
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
      get_debug_input("DIV.S %2s,%2s,%2s", reg_cop1[r4300_fd()], reg_cop1[r4300_fs()], reg_cop1[r4300_ft()]);
#endif
      if (*((float *)&Nregs.cop1.regs[r4300_ft()]) != 0)
        *((float *)&Nregs.cop1.regs[r4300_fd()]) = *((float *)&Nregs.cop1.regs[r4300_fs()]) / *((float *)&Nregs.cop1.regs[r4300_ft()]);
      break;
    case 17: // D
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
      get_debug_input("DIV.D %2s,%2s,%2s", reg_cop1[r4300_fd()], reg_cop1[r4300_fs()], reg_cop1[r4300_ft()]);
#endif
      if (*((double *)&Nregs.cop1.regs[r4300_ft()]) != 0)
        *((double *)&Nregs.cop1.regs[r4300_fd()]) = *((double *)&Nregs.cop1.regs[r4300_fs()]) / *((double *)&Nregs.cop1.regs[r4300_ft()]);
      break;
    case 20: // W
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
      get_debug_input("DIV.W %2s,%2s,%2s", reg_cop1[r4300_fd()], reg_cop1[r4300_fs()], reg_cop1[r4300_ft()]);
#endif
      break;
    case 21: // L
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
      get_debug_input("DIV.L %2s,%2s,%2s", reg_cop1[r4300_fd()], reg_cop1[r4300_fs()], reg_cop1[r4300_ft()]);
#endif
      break;
    default:
      break;
  }
  Nregs.PC+=4;
}

void op_mul_x ( void )
{
  switch (r4300_fmt())
  {
    case 16: // S
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
      get_debug_input("MUL.S %2s,%2s,%2s", reg_cop1[r4300_fd()], reg_cop1[r4300_fs()], reg_cop1[r4300_ft()]);
#endif
      *((float *)&Nregs.cop1.regs[r4300_fd()]) = *((float *)&Nregs.cop1.regs[r4300_fs()]) * *((float *)&Nregs.cop1.regs[r4300_ft()]);
      break;
    case 17: // D
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
      get_debug_input("MUL.D %2s,%2s,%2s", reg_cop1[r4300_fd()], reg_cop1[r4300_fs()], reg_cop1[r4300_ft()]);
#endif
      *((double *)&Nregs.cop1.regs[r4300_fd()]) = *((double *)&Nregs.cop1.regs[r4300_fs()]) * *((double *)&Nregs.cop1.regs[r4300_ft()]);
      break;
    case 20: // W
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
      get_debug_input("MUL.W %2s,%2s,%2s", reg_cop1[r4300_fd()], reg_cop1[r4300_fs()], reg_cop1[r4300_ft()]);
#endif
      break;
    case 21: // L
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
      get_debug_input("MUL.L %2s,%2s,%2s", reg_cop1[r4300_fd()], reg_cop1[r4300_fs()], reg_cop1[r4300_ft()]);
#endif
      break;
    default:
      break;
  }
  Nregs.PC+=4;
}

void op_add_x ( void )
{
  switch (r4300_fmt())
  {
    case 16: // S
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
      get_debug_input("ADD.S %2s,%2s,%2s", reg_cop1[r4300_fd()], reg_cop1[r4300_fs()], reg_cop1[r4300_ft()]);
#endif
      *((float *)&Nregs.cop1.regs[r4300_fd()]) = *((float *)&Nregs.cop1.regs[r4300_fs()]) + *((float *)&Nregs.cop1.regs[r4300_ft()]);
      break;
    case 17: // D
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
      get_debug_input("ADD.D %2s,%2s,%2s", reg_cop1[r4300_fd()], reg_cop1[r4300_fs()], reg_cop1[r4300_ft()]);
#endif
      *((double *)&Nregs.cop1.regs[r4300_fd()]) = (double)((double) *((double *)&Nregs.cop1.regs[r4300_fs()]) + (double) *((double *)&Nregs.cop1.regs[r4300_ft()]));
      break;
    case 20: // W
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
      get_debug_input("ADD.W %2s,%2s,%2s", reg_cop1[r4300_fd()], reg_cop1[r4300_fs()], reg_cop1[r4300_ft()]);
#endif
      break;
    case 21: // L
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
      get_debug_input("ADD.L %2s,%2s,%2s", reg_cop1[r4300_fd()], reg_cop1[r4300_fs()], reg_cop1[r4300_ft()]);
#endif
      break;
    default:
      break;
  }
  Nregs.PC+=4;
}

void op_ctc1 ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("CTC1 %s,%s", reg_str[r4300_rt()], reg_cop1[r4300_fs()]);
#endif
  Nregs.cop1.regs[r4300_fs()] = Nregs.main.regs[r4300_rt()];
  Nregs.PC+=4;
}

void op_cfc1 ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("CFC1 %s,%s", reg_str[r4300_rt()], reg_cop1[r4300_fs()]);
#endif
  Nregs.main.regs[r4300_rt()] = Nregs.cop1.regs[r4300_fs()];
  Nregs.PC+=4;
}

void op_slti ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("SLTI %2s,%2s,%04X", reg_str[r4300_rt()], reg_str[r4300_rs()], (WORD)opcode);
#endif


//  Nregs.main.regs[r4300_rt()] = (signed)Nregs.main.regs[r4300_rs()] - (signed short int)opcode;
  if ((signed)Nregs.main.regs[r4300_rs()] < (signed short int)opcode)
    Nregs.main.regs[r4300_rt()] = 1;
  else
    Nregs.main.regs[r4300_rt()] = 0;
  Nregs.PC+=4;
}

void op_sltiu ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("SLTIU %2s,%2s,%04X", reg_str[r4300_rt()], reg_str[r4300_rs()], (WORD)opcode);
#endif

  if ((unsigned)Nregs.main.regs[r4300_rs()] < (unsigned short int)opcode)
    Nregs.main.regs[r4300_rt()] = 1;
  else
    Nregs.main.regs[r4300_rt()] = 0;
  Nregs.PC+=4;
}

void op_xori ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("XORI %2s,%2s,%04Xh", reg_str[r4300_rs()], reg_str[r4300_rt()], (WORD)opcode);
#endif
  Nregs.main.regs[r4300_rt()] = Nregs.main.regs[r4300_rs()] ^ (WORD)opcode;
  Nregs.PC+=4;
}

void op_ori ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("ORI %2s,%2s,%04Xh", reg_str[r4300_rs()], reg_str[r4300_rt()], (WORD)opcode);
#endif
  Nregs.main.regs[r4300_rt()] = Nregs.main.regs[r4300_rs()] | (WORD)opcode;
  Nregs.PC+=4;
}

void op_andi ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("ANDI %2s,%2s,%04Xh", reg_str[r4300_rs()], reg_str[r4300_rt()], (WORD)opcode);
#endif
  Nregs.main.regs[r4300_rt()] = Nregs.main.regs[r4300_rs()] & (WORD)opcode;
  Nregs.PC+=4;
}

void eop_and ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("AND %2s,%2s,%2s", reg_str[r4300_rd()], reg_str[r4300_rs()], reg_str[r4300_rt()]);
#endif
  Nregs.main.regs[r4300_rd()] = Nregs.main.regs[r4300_rs()] & Nregs.main.regs[r4300_rt()];
  Nregs.PC+=4;
}

void op_ld ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("LD %2s,%04Xh(%2s)", reg_str[r4300_rt()], (WORD)opcode, reg_str[r4300_base()]);
#endif
  Nregs.PC+=4;
  Nregs.main.regs[r4300_rt()] = getqword(Nregs.main.regs[r4300_base()] + (signed short int)opcode);
}

void op_sd ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("SD %2s,%04Xh(%2s)", reg_str[r4300_rt()], (WORD)opcode, reg_str[r4300_base()]);
#endif
  Nregs.PC+=4;
  putqword(Nregs.main.regs[r4300_base()] + (signed short int)opcode, (QWORD)Nregs.main.regs[r4300_rt()]);
}

void op_lbu ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("LBU %2s,%04Xh(%2s)", reg_str[r4300_rt()], (WORD)opcode, reg_str[r4300_base()]);
#endif
  Nregs.PC+=4;
  Nregs.main.regs[r4300_rt()] = getbyte(Nregs.main.regs[r4300_base()] + (signed short int)opcode);
}

void op_lh ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("LH %2s,%04Xh(%2s)", reg_str[r4300_rt()], (WORD)opcode, reg_str[r4300_base()]);
#endif
  Nregs.PC+=4;
  Nregs.main.regs[r4300_rt()] = (signed)getword(Nregs.main.regs[r4300_base()] + (short signed int)opcode);
}

void op_lhu ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("LHU %2s,%04Xh(%2s)", reg_str[r4300_rt()], (WORD)opcode, reg_str[r4300_base()]);
#endif
  Nregs.PC+=4;
  Nregs.main.regs[r4300_rt()] = getword(Nregs.main.regs[r4300_base()] + (short signed int)opcode);
}

void op_lb ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("LB %2s,%04Xh(%2s)", reg_str[r4300_rt()], (WORD)opcode, reg_str[r4300_base()]);
#endif
  Nregs.PC+=4;
  Nregs.main.regs[r4300_rt()] = (signed)getbyte(Nregs.main.regs[r4300_base()] + (short signed int)opcode);
}

void op_sh ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("SH %2s,%04Xh(%2s)", reg_str[r4300_rt()], (WORD)opcode, reg_str[r4300_base()]);
#endif
  Nregs.PC+=4;
  putword(Nregs.main.regs[r4300_base()] + (signed short int)opcode, (WORD)Nregs.main.regs[r4300_rt()]);
}

void op_sb ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("SB %2s,%04Xh(%2s)", reg_str[r4300_rt()], (WORD)opcode, reg_str[r4300_base()]);
#endif
  Nregs.PC+=4;
  putbyte(Nregs.main.regs[r4300_base()] + (signed short int)opcode, (BYTE)Nregs.main.regs[r4300_rt()]);
}

void op_sw ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("SW %2s,%04Xh(%2s)", reg_str[r4300_rt()], (WORD)opcode, reg_str[r4300_base()]);
#endif
  Nregs.PC+=4;
  putdword(Nregs.main.regs[r4300_base()] + (signed short int)opcode, Nregs.main.regs[r4300_rt()]);
}

void op_swl ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("SW %2s,%04Xh(%2s)", reg_str[r4300_rt()], (WORD)opcode, reg_str[r4300_base()]);
#endif
  Nregs.PC+=4;
  putdword(Nregs.main.regs[r4300_base()] + (signed short int)opcode, (DWORD)((QWORD)Nregs.main.regs[r4300_rt()]>>32));
}

void op_lwr ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("LWR %2s,%04Xh(%2s)", reg_str[r4300_rt()], (WORD)opcode, reg_str[r4300_base()]);
#endif
  Nregs.PC+=4;
  Nregs.main.regs[r4300_rt()] |= ((QWORD)getdword(Nregs.main.regs[r4300_base()] + (signed short int)opcode));
}

void op_swr ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("SWR %2s,%04Xh(%2s)", reg_str[r4300_rt()], (WORD)opcode, reg_str[r4300_base()]);
#endif
  Nregs.PC+=4;
  putdword(Nregs.main.regs[r4300_base()] + (signed short int)opcode, (DWORD)Nregs.main.regs[r4300_rt()]);
}

void op_lwl ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("LWL %2s,%04Xh(%2s)", reg_str[r4300_rt()], (WORD)opcode, reg_str[r4300_base()]);
#endif
  Nregs.PC+=4;
  Nregs.main.regs[r4300_rt()] |= ((QWORD)getdword(Nregs.main.regs[r4300_base()] + (signed short int)opcode))<<32;
}

void op_lw ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("LW %2s,%04Xh(%2s)", reg_str[r4300_rt()], (WORD)opcode, reg_str[r4300_base()]);
#endif
  Nregs.PC+=4;
  Nregs.main.regs[r4300_rt()] = getdword(Nregs.main.regs[r4300_base()] + (signed short int)opcode);
}

void op_lwc1 ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("LWC1 %2s,%04Xh(%2s)", reg_cop1[r4300_rt()], (WORD)opcode, reg_str[r4300_base()]);
#endif
  Nregs.PC+=4;
  Nregs.cop1.regs[r4300_rt()] = getdword(Nregs.main.regs[r4300_base()] + (signed short int)opcode);
}

void op_swc2 ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  //get_debug_input("LWC1 %2s,%04Xh(%2s)", reg_cop1[r4300_rt()], (WORD)opcode, reg_str[r4300_base()]);
#endif
 // Nregs.PC+=4;
//  Nregs.main.regs[13] &= ~(3 << 28);
//  Nregs.main.regs[13] |= (r4300_copXop() << 28);

}

void op_jal ( void )
{
  temp_4op = (Nregs.PC & 0xFF000000) | (opcode<<2 &0x00FFFFFF);
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("JAL %08X", (Nregs.PC & 0xFF000000) | (opcode<<2 &0x00FFFFFF) );
  JUMPS[jump_cnt++] = temp_4op;
#endif
  Nregs.main.regs[31] = Nregs.PC + 8;

  opcode=getdword(Nregs.PC + 4);
  opcodes[r4300_opcode()]();
  Nregs.PC = temp_4op;
}

void op_j ( void )
{
  temp_4op = (Nregs.PC & 0xFF000000) | (opcode<<2 &0x00FFFFFF);
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("J %08X", (Nregs.PC & 0xFF000000) | (opcode<<2 &0x00FFFFFF) );
  JUMPS[jump_cnt++] = temp_4op;
#endif

  opcode=getdword(Nregs.PC + 4);
  opcodes[r4300_opcode()]();
  Nregs.PC = temp_4op;
}

void op_eret ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("ERET %08X", Nregs.cop0.regs[0x0e] );
  JUMPS[jump_cnt++] = Nregs.cop0.regs[0x0e];
#endif

  Nregs.PC = Nregs.cop0.regs[0x0e];
}

void op_bne ( void )
{
  Nregs.PC += 4;
  temp_4op = Nregs.PC + ((signed short int)(opcode)<<2);
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("BNE %2s,%2s,%04Xh", reg_str[r4300_rs()], reg_str[r4300_rt()], temp_4op);
#endif

  if (Nregs.main.regs[r4300_rt()] != Nregs.main.regs[r4300_rs()])
  {
    opcode=getdword(Nregs.PC);
//    SwapBytes((WORD*)&opcode);
//    SwapWords(&opcode);
//    SwapBytes((WORD*)&opcode);
    opcodes[r4300_opcode()]();
    Nregs.PC = temp_4op;
  }
}

void op_blez ( void )
{
  Nregs.PC += 4;
  temp_4op = Nregs.PC + ((signed short int)(opcode)<<2);
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("BLEZ %2s,%04Xh", reg_str[r4300_rs()], temp_4op);
#endif

  if ((signed)Nregs.main.regs[r4300_rs()] <= 0)
  {
    opcode=getdword(Nregs.PC);
    opcodes[r4300_opcode()]();
    Nregs.PC = temp_4op;
  }
}


void op_bnel ( void )
{
  Nregs.PC += 4;
  temp_4op = Nregs.PC + ((signed short int)(opcode)<<2);
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("BNE %2s,%02s,%04Xh", reg_str[r4300_rs()], reg_str[r4300_rt()], temp_4op);
#endif

  if (Nregs.main.regs[r4300_rt()] != Nregs.main.regs[r4300_rs()])
  {
    opcode=getdword(Nregs.PC);
//    SwapBytes((WORD*)&opcode);
//    SwapWords(&opcode);
//    SwapBytes((WORD*)&opcode);
    opcodes[r4300_opcode()]();
    Nregs.PC = temp_4op;
  }
  else
    Nregs.PC += 4;
}

void op_blezl ( void )
{
  Nregs.PC += 4;
  temp_4op = Nregs.PC + ((signed short int)(opcode)<<2);
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("BLEZL %2s,%04Xh", reg_str[r4300_rs()], temp_4op);
#endif

  if ((signed)Nregs.main.regs[r4300_rs()] <= 0)
  {
    opcode=getdword(Nregs.PC);
//    SwapBytes((WORD*)&opcode);
//    SwapWords(&opcode);
//    SwapBytes((WORD*)&opcode);
    opcodes[r4300_opcode()]();
    Nregs.PC = temp_4op;
  }
  else
    Nregs.PC += 4;
}

void op_bgezl ( void )
{
  Nregs.PC += 4;
  temp_4op = Nregs.PC + ((signed short int)(opcode)<<2);
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("BGEZL %2s,%04Xh", reg_str[r4300_rs()], temp_4op);
#endif

  if ((signed)Nregs.main.regs[r4300_rs()] >= (signed)0)
  {
    opcode=getdword(Nregs.PC);
    opcodes[r4300_opcode()]();
    Nregs.PC = temp_4op;
  }
  else
    Nregs.PC += 4;
}

void op_bgtz ( void )
{
  Nregs.PC += 4;
  temp_4op = Nregs.PC + ((signed short int)(opcode)<<2);
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("BGTZ %2s,%04Xh", reg_str[r4300_rs()], temp_4op);
#endif

  if ((signed)Nregs.main.regs[r4300_rs()] > (signed)0)
  {
    opcode=getdword(Nregs.PC);
    opcodes[r4300_opcode()]();
    Nregs.PC = temp_4op;
  }
}

void op_beq ( void )
{
  Nregs.PC += 4;
  temp_4op = Nregs.PC + ((signed short int)(opcode)<<2);
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("BEQ %2s,%2s,%04Xh", reg_str[r4300_rs()], reg_str[r4300_rt()], temp_4op);
#endif

  if (Nregs.main.regs[r4300_rt()] == Nregs.main.regs[r4300_rs()])
  {
    opcode=getdword(Nregs.PC);
    opcodes[r4300_opcode()]();
    Nregs.PC = temp_4op;
  }
}

void op_beql ( void )
{

  Nregs.PC += 4;
  temp_4op = Nregs.PC + ((signed short int)(opcode)<<2);
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("BEQL %2s,%2s,%04Xh", reg_str[r4300_rs()], reg_str[r4300_rt()], temp_4op);
#endif

  if (Nregs.main.regs[r4300_rt()] == Nregs.main.regs[r4300_rs()])
  {
    opcode=getdword(Nregs.PC);
//    SwapBytes((WORD*)&opcode);
//    SwapWords(&opcode);
//    SwapBytes((WORD*)&opcode);
    opcodes[r4300_opcode()]();
    Nregs.PC = temp_4op;
  }
  else
    Nregs.PC+=4;
}


void op_addi ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("ADDI %2s,%2s,%04Xh", reg_str[r4300_rs()], reg_str[r4300_rt()], (WORD)opcode);
#endif
  Nregs.PC+=4;
//  Nregs.main.regs[r4300_rt()] = (unsigned)Nregs.main.regs[r4300_rs()] + (WORD)opcode;
  Nregs.main.regs[r4300_rt()] = (unsigned)Nregs.main.regs[r4300_rs()] - (signed short int)(~(opcode-1) &0xffff);
}

void eop_add ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("ADD %2s,%2s,%2s", reg_str[r4300_rd()], reg_str[r4300_rs()], reg_str[r4300_rt()]);
#endif
  Nregs.PC+=4;
//  Nregs.main.regs[r4300_rt()] = (unsigned)Nregs.main.regs[r4300_rs()] + (WORD)opcode;
//  Nregs.main.regs[r4300_rt()] = Nregs.main.regs[r4300_rs()] - (int)(~(opcode-1));
  Nregs.main.regs[r4300_rd()] = Nregs.main.regs[r4300_rs()] + Nregs.main.regs[r4300_rt()];
}

void op_addiu ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("ADDIU %2s,%2s,%04Xh", reg_str[r4300_rt()], reg_str[r4300_rs()], (WORD)opcode);
#endif
  Nregs.PC+=4;
//  Nregs.main.regs[r4300_rt()] = (unsigned)Nregs.main.regs[r4300_rs()] + (WORD)opcode;
//  Nregs.main.regs[r4300_rt()] = (unsigned)Nregs.main.regs[r4300_rs()] - (signed short int)(~(opcode-1));
  Nregs.main.regs[r4300_rt()] = (unsigned)(Nregs.main.regs[r4300_rs()] + (signed short int)opcode);
}

void op_mtc0 ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("MTC0 %2s,%2s", reg_str[r4300_rt()], reg_cop0[r4300_fs()]);
#endif
  Nregs.PC+=4;
  Nregs.cop0.regs[r4300_fs()] = Nregs.main.regs[r4300_rt()];
}

void op_mtc1 ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("MTC1 %2s,%2s", reg_str[r4300_rt()], reg_cop1[r4300_fs()]);
#endif
  Nregs.PC+=4;
  if ((BYTE)(r4300_fs()) == 0x0C)
    return;
  Nregs.cop1.regs[r4300_fs()] = Nregs.main.regs[r4300_rt()];
}

void op_mfc0 ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("MFC0 %2s,%2s", reg_str[r4300_rt()], reg_cop0[r4300_fs()]);
#endif
  Nregs.PC+=4;
  Nregs.main.regs[r4300_rt()] = Nregs.cop0.regs[r4300_fs()];
}

void op_mfc1 ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("MFC1 %2s,%2s", reg_str[r4300_rt()], reg_cop1[r4300_fs()]);
#endif
  Nregs.PC+=4;
  Nregs.main.regs[r4300_rt()] = Nregs.cop1.regs[r4300_fs()];
}

void op_lui ( void )
{
#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  get_debug_input("LUI %2s, %04Xh", reg_str[r4300_rt()], (WORD)opcode);
#endif
  Nregs.PC+=4;
  Nregs.main.regs[r4300_rt()] =  (DWORD)(opcode&0xffff)<<16;
}

void op_n ( void )
{
  int i;

#ifdef DEBUG
  #ifdef DEBUG_EXEC
    lastexec;
  #endif
  if (debug.cont == 1)
  {
    printf("Can't continue... I don't know how to handle the opcode!\n");
  }
  debug.cont = 0;
  debug.info_nec = TRUE;
  if (r4300_opcode() != 0)
  {
    switch (r4300_opcode())
    {
      case 16: // COP0
        get_debug_input("hit unknown COP0 opcode %08X (op: %02d cop0: %02d)\n", opcode, r4300_opcode(), r4300_copXop());
        break;
      case 17: // COP1
        get_debug_input("hit unknown COP1 opcode %08X (op: %02d cop1: %02d)\n", opcode, r4300_opcode(), (BYTE)opcode &0x3f);
        break;
      default:
        get_debug_input("hit unknown opcode %08X (op: %02d)\n", opcode, r4300_opcode());
        break;
    }
  }
  else
    get_debug_input("%08X: hit unknown opcode %08X (op: %02d eop: %02d)\b",Nregs.PC, opcode, r4300_opcode(), r4300_eopcode());
#endif
#ifndef DEBUG
  Reset_Video();
  if (r4300_opcode() != 0)
  {
    switch (r4300_opcode())
    {
      case 16: // COP0
        printf("%08X: hit unknown COP0 opcode %08X (op: %02d cop0: %02d)\n",Nregs.PC, opcode, r4300_opcode(), r4300_copXop());
        break;
      case 17: // COP1
        printf("%08X: hit unknown COP1 opcode %08X (op: %02d cop1: %02d)\n",Nregs.PC, opcode, r4300_opcode(), (BYTE)opcode & 0x3f);
        break;
      default:
        printf("%08X: hit unknown opcode %08X (op: %02d)\n",Nregs.PC, opcode, r4300_opcode());
        break;
    }
  }
  else
    printf("%08X: hit unknown opcode %08X (op: %02d eop: %02d)\n",Nregs.PC, opcode, r4300_opcode(), r4300_eopcode());
  print_regs();

  //exit(0);
#endif
/*
  for (i = Nregs.PC; i < 4+Nregs.PC; i++)
    printf("%02X", (BYTE)g_n64rom[i]);
  printf("\n");
*/
}
