#include "main.h"
#include "r4300.h"
#include "memhand.h"
#include "debug.h"

extern DWORD opcode;
extern QWORD instructions;
extern char *reg_str[0x20];
extern char *reg_cop0[0x20];
extern char *reg_cop1[0x20];

void get_number ( char *string )
{
  char n_str [ 20 ];
  DWORD number;
  
  if (string[0] != '$')
    return;
  else
  {
    sscanf(&string[1], "%x", &number);
    sprintf(string, "%d", number);
  }
}

unsigned char parse_debug_input ( char *string )
{
  /* returns:
  ** 0 - stay in debugger
  ** 1 - step
  ** 2 - continue
  ** 3 - exit
  */

  DWORD count = 0,
        count_1[4];
  DWORD temp[ 4 ];
  unsigned char c_temp[ 20 ],
                d_temp[ 20 ];

  if (string[0] == 10)
  {
    debug.info_nec = 1;
    return 0;
  }
  while ((char)string[count] != '\0')
  {
    switch ( tolower(string[count]) )
    {
      case 'r':                                         // show registers
      {
        print_regs();
        return 0;
      }
      case 't':                                         // toggle
      {
        if (debug.show_regs == 0)
        {
          printf("*** Showing registers after each instruction.\n");
          debug.show_regs = 1;
        }
        else
        {
          printf("*** NOT Showing registers after each instruction.\n");
          debug.show_regs = 0;
        }
        return 0;
      }
      case 's':                                         // Step
      {
        return 1;
      }
      case 'c':						// Continue
      {
        return 2;
      }
      case 'l':                                         // list all jumps
      {
        for (count = 0; count < jump_cnt; count++)
          printf("Jump[%04X] to-> %08X\n", count, JUMPS[count]);
        return 0;
      }
      case 'q':
      {
        return 3;
      }
      case 'm':
      {							// Memory
        count++;
        sscanf(&string[count], "%s", &c_temp);
        get_number(c_temp);
        temp[0] = atoi ( c_temp );
        for (count_1[0] = 0 ; count_1[0] < 6; count_1[0]++)
        {
          printf("%08X: ", temp[0] + count_1[0]*16);
          for (count_1[1] = 0; count_1[1] < 16; count_1[1]++)
          {
            printf("%02X ", (unsigned char)getbyte( (temp[0] + count_1[0]*16)+count_1[1]) );
            if (count_1[1] == 7)
              printf(" ");
          }
          printf("  ");
          for (count_1[1] = 0; count_1[1] < 16; count_1[1]++)
          {
            if ((unsigned char)getbyte( (temp[0] + count_1[0]*16)+count_1[1]) >= 0x20 && (unsigned char)getbyte( (temp[0] + count_1[0]*16)+count_1[1]) <= 0x7E)
              printf("%c", getbyte( (temp[0] + count_1[0]*16)+count_1[1]));
            else
              printf(".");
          }
          printf("\n");
        }
        return 0;
        break;
      }
      case 'j':
      {							// Jump
        count++;
        sscanf(&string[count], "%s", &c_temp);
        get_number(c_temp);
        regs.PC = atoi ( c_temp );
        return 0;
        break;
      }
      case 'w':
      {							// write
        count++;
        sscanf(&string[count], "%s %s", &c_temp, &d_temp);
        get_number(c_temp);
        temp[0] = atoi ( c_temp );
        get_number(d_temp);
        putbyte(temp[0], atoi(d_temp));
        return 0;
        break;
      }
      case 'b':
      {							// Break
        count++;
        switch ( tolower(string[count]) )
        {
          case 'a':					// On address.
          {
            count++;
            sscanf(&string[count], "%s", &c_temp);
            get_number(c_temp);
            debug.break_addr = atoi ( c_temp );
            debug.info_nec = 0;
            return 0;
            break;
          }
          case 'm':					// On memory
          {
            count++;
            switch ( tolower(string[count]) )
            {
              case 'w':
              {
                count++;
                sscanf(&string[count], "%s", &c_temp);
                get_number(c_temp);
                debug.break_mw = atoi ( c_temp );
                debug.info_nec = 0;
                return 0;
              }
              case 'r':
              {
                count++;
                sscanf(&string[count], "%s", &c_temp);
                get_number(c_temp);
                debug.break_mr = atoi ( c_temp );
                debug.info_nec = 0;
                return 0;
              }
            }
            break;
          }
        }
        break;
      }
      case 'v':
      {							// View video
        printf("VI Status REG: %08X\n", getdword(0x04400000));
        printf("VI DRAM addr reg: %08X\n", getdword(0x04400004));
        printf("VI Width REG: %08X\n", getdword(0x04400008));
        printf("VI Vertical Intr REG: %08X\n", getdword(0x0440000C));
        return 0;
        break;
      }
      case '?':
      {
        count++;
        sscanf(&string[count], "%s", &c_temp);
        for (temp[0] = 0; temp[0] != 0x20; temp[0]++)
        {
          if (strcasecmp(c_temp, reg_str[temp[0]]) == 0)
          {
            printf("?: %s == %016LX\n", reg_str[temp[0]], regs.main.regs[temp[0]]);
            return 0;
          }
        }
        for (temp[0] = 0; temp[0] != 0x20; temp[0]++)
        {
          if (strcasecmp(c_temp, reg_cop0[temp[0]]) == 0)
          {
            printf("?: %s == %016LX\n", reg_cop0[temp[0]], regs.cop0.regs[temp[0]]);
            return 0;
          }
        }
        for (temp[0] = 0; temp[0] != 0x20; temp[0]++)
        {
          if (strcasecmp(c_temp, reg_cop1[temp[0]]) == 0)
          {
            printf("?: %s == %016X\n", reg_cop1[temp[0]], regs.cop1.regs[temp[0]]);
            return 0;
          }
        }
        printf("?: %s no such GPR register\n", c_temp);
        return 0;
      }
      case 'h':						// Help
      {
        printf("Help:\n");
        printf("\t Use $<number> for HEX values\n");
        printf("\t h             \t\t Help\n");
        printf("\t l             \t\t List jumps\n");
        printf("\t ? <reg>       \t\t Show contents of <reg>ister (GPR/etc)\n");
        printf("\t q             \t\t Quit\n");
        printf("\t m <adr>       \t\t Display contents of <adr>ess\n");
        printf("\t t             \t\t Show contents of GPR/COP0 regs after each op.\n");
        printf("\t ba <pc>       \t\t Break when PC == <pc>\n");
        printf("\t bmw <adr>     \t\t Break memory write to <adr>ress\n");
        printf("\t bmr <adr>     \t\t Break memory read from <adr>ress\n");
        printf("\t c             \t\t Continue emulation\n");
        printf("\t s             \t\t Step\n");
        printf("\t r             \t\t Show CPU registers\n");
        printf("\t v             \t\t View current screen\n");
        printf("\t j             \t\t Jump\n");
        printf("\t w <adr> <val> \t\t A Write <val>ue to <adr>ory\n");
        break;
      }
    }
    count++;
  }
  return 0;
}

void get_debug_input ( const char *text, ... )
{
  /* input:
  ** stuff to be passed printed neatly;
  */

  char *input_str = malloc(1024);
  int ret;
  char buffah[100];
  va_list valist;

/* ?? we need to find out where something changes?
  if (regs.cop0.regs[0x0c] != 0x00400004)
  {
    printf("status has changed! %08X\n", regs.PC);
    exit(0);
  }
*/
  if (debug.cont == 1)
  {
    return;
  }
  do
  {
    if (debug.info_nec == TRUE)
    {
      va_start(valist, text);
      vsprintf(buffah, text, valist);
      va_end(valist);
      printf("%08X:(%08X) - %s\n", regs.PC, opcode, buffah);
      debug.info_nec = FALSE;
    }
    printf("[%08X]=> ", regs.PC);
    fgets(input_str, 0xFFFF, stdin);
    ret = parse_debug_input ( input_str );
  } while (ret == 0);
  switch (ret)
  {
    case 1:
      debug.cont = FALSE;
      debug.info_nec = TRUE;
    break;
    case 2:
      debug.info_nec = TRUE;
      debug.show_regs = FALSE;
      debug.cont = TRUE;
      break;
    case 3:
      exit(0);
    default:break;
  }
}

void stop_cont ( void )
{
  debug.cont = FALSE;
  debug.info_nec = TRUE;
}
