#include <dos.h>
#include <pc.h>
#include <dpmi.h>
#include "r4300.h"
#include "memhand.h"
#include "main.h"
#include "debug.h"
#include "video.h"
#include "vesa.h"

VesaModeData vesa_mode;
void vesa_get_mode_info(unsigned short int vmode);

void segread ( struct SREGS * regs )
{
   asm volatile (
      " movw %%es,0(%%eax); "
      " movw %%ds,2(%%eax); "
      " movw %%fs,4(%%eax); "
      " movw %%gs,6(%%eax); "
      " movw %%cs,8(%%eax); "
      " movw %%ss,10(%%eax) "
   :
   : "0" (regs)
   : "%eax"
   );
}

void setup_lfb ( unsigned short int mode )
{
  unsigned long linear_address;
  __dpmi_regs regs;
  __dpmi_regs regs2;
  LFB_mem.size=(unsigned long) (vesa_mode.PixelHeight*vesa_mode.PixelWidth*(vesa_mode.BytesPerScanLine/vesa_mode.PixelWidth));
  LFB_mem.address=vesa_mode.PhysBasePtr;
  printf("VESA 2.0+: Using Linear Frame Buffer at: %08X\n", vesa_mode.PhysBasePtr);

  if (0!=__dpmi_physical_address_mapping(&LFB_mem))
  {
    fprintf (stderr, "physical_address_mapping failed !\n");
    exit(0);
  }

  linear_address=LFB_mem.address;
  regs2.x.ax=0x4F02;
  regs2.x.bx=mode;
  __dpmi_int (0x10, &regs2);
  if (regs2.x.ax!=0x4F)
  {
    regs.x.ax=0x03;
    __dpmi_int(0x10, &regs);
    LFB = FALSE;
    fprintf (stderr, "NO LFB SUPPORT\n");
    exit(0);
  }
  else
  {
    LFB = TRUE;
    video=(char *)(linear_address+__djgpp_conventional_base);
  }
//  __djgpp_nearptr_enable();  
//  __djgpp_nearptr_disable();
//  regs.x.ax=0x03;
//  __dpmi_int(0x10, &regs);
}

void vesa_get_mode_info(unsigned short int vmode)
{
  union   REGS    regs;
  struct  SREGS   sregs;
  RMREGS rmregs;
  _go32_dpmi_seginfo info;

  info.size = sizeof(VesaModeData)+16 / 16;
  _go32_dpmi_allocate_dos_memory(&info);
    
  memset(&rmregs,0,sizeof(rmregs));
  rmregs.es = info.rm_segment;
  rmregs.ds = info.rm_segment;
  rmregs.edi = 0;
  rmregs.eax = 0x4f01;
  rmregs.ecx = vmode;
  memset(&regs,0,sizeof(regs));
  memset(&sregs,0,sizeof(sregs));
  segread(&sregs);
  regs.d.eax = 0x300;
  regs.d.ebx = 0x10;
  regs.d.edi = (unsigned long)&rmregs;
  int86x(0x31,&regs,&regs,&sregs);


  dosmemget(info.rm_segment*16, sizeof(VesaModeData), &vesa_mode);
  _go32_dpmi_free_dos_memory(&info);
  if(regs.h.al == 0)
  {
    vesa_granularity        = vesa_mode.WindowGranularity;
    vesa_width              = vesa_mode.PixelWidth;
    vesa_height             = vesa_mode.PixelHeight;
    vesa_bits_per_pixel     = vesa_mode.BitsPerPixel;
  }
  // can we use a LFB?
  if (vesa_mode.PhysBasePtr)
  {
    setup_lfb(vmode);
  }
  else
    LFB = FALSE;
}

