


//#include "r4300.h"
#include "main.h"
//#include "memhand.h"
//#include "video.h"

#ifdef _arch_dreamcast
#include "kos.h"
//extern uint8 romdisk[]; 
//KOS_INIT_ROMDISK(romdisk);
#endif

#define VERSION         "0.05beta"
#undef PRIVATE

void emulate ( void );
void Init_Video ( void );
// this function will swap the bytes in a short int(16-bit)
void SwapBytes(WORD *var)
{
        WORD temp;
        temp = (*var >> 8);
        temp |= (*var << 8);
        *var = temp;

}

void SwapWords(DWORD *var)
{
/*
        DWORD f=*var;
	_asm {
		mov eax, f
		rol eax, 16		// rotate the bits around by 16 bits so the high word=low & low=high
		mov f, eax
	}
	*var = f;
*/
        DWORD temp;
        temp = (*var >> 16);
        temp |= (*var << 16);
        *var = temp;

}
	
int main(int argc, char **argv)
{
        FILE *romfp;
	QWORD current_read;
	unsigned short workvar, workvar2;
        unsigned long int i = 0, filesize = 0;
        
#ifdef DEBUG
        g_logfile = fopen("memory.dmp", "wb");
#endif
        if (argv[1] == NULL)
        {
//          printf("usage: %s <rom>\n", argv[0]);
//          exit(0);
	        #ifdef _arch_dreamcast
	        argv[1]="/rd/fire.v64";
	        #else
	        argv[1]="romdisk/fire.v64";
	        #endif

        }
    if ( (romfp = fopen("/cd/stars.v64", "rb")) == NULL)
	{
		printf("can't open file\n");
                exit(0);
	}
	memset(&n64header, 0, sizeof(n64header));

	fread(&n64header.valid, 2, 1, romfp);
	fread (&workvar, 2, 1, romfp);
	n64header.is_compressed = workvar>>8;
	n64header.unknown = workvar & 0x00FF;
	
	fread (&n64header.Clockrate, 4, 1, romfp);
	SwapWords(&n64header.Clockrate);
	
	fread (&n64header.Program_Counter, 4, 1, romfp);
	SwapWords(&n64header.Program_Counter);

	fread(&n64header.Release, 4, 1, romfp);
	SwapWords(&n64header.Release);
//	fread(&current_read, 8, 1, romfp);
//      printf ("%LX\n", current_read);
	fread(&n64header.CRC1, 4, 1, romfp);
	SwapWords(&n64header.CRC1);

	fread(&n64header.CRC2, 4, 1, romfp);
	SwapWords(&n64header.CRC2);

	fread (&n64header.filler1, 8, 1, romfp);
	fread(n64header.Image_Name, 20, 1, romfp);
	fread(&current_read, 8, 1, romfp);
	fread(n64header.filler2, 7, 1, romfp);
	fread(&n64header.Manu_ID, 1, 1, romfp);
	fread(&n64header.Cart_ID, 2, 1, romfp);
	fread(&n64header.Country_Code, 1, 1, romfp);
	fread(&n64header.filler3, 1, 1, romfp);
        printf("NINCEST 64: v%s by Marius Dumitrean [marius@faraway.ml.org]\n", VERSION);
        printf("Some code by Chris Le Blond (Baalzamon)\n");
        printf("Special thanks to: Mike Tedder (bpoint), Niki Weibel:-), #n64dev\n");
        printf("\t\t   JL_Picard, LaC, braneded etc.\n");
#ifdef PRIVATE
        printf("THIS IS A PRIVATE BETA: DO NOT DISTRIBUTE.\n");
#endif
//        sleep(2);
//#ifdef DEBUG 
        printf ("Validation word = %4X\n", n64header.valid);
	if (n64header.is_compressed == 0x12)
		printf ("The file is not compressed\n");
        else
          if (n64header.is_compressed == 0x13)
            printf ("The file is compressed\n");
        printf ("%X\n", n64header.is_compressed);
        printf ("%X\n", n64header.unknown);
	printf ("The Clockrate is: %x\n", n64header.Clockrate);
        printf ("Starting Program Counter:  %8X\n", n64header.Program_Counter);
	printf ("Release version: %x\n", n64header.Release);
        printf ("CRC1: %8X\n", n64header.CRC1);
        printf ("CRC2: %8X\n", n64header.CRC2);
	printf ("filler (should be all 0's): %x \n", n64header.filler1);
	printf ("Image Name: %s\n", n64header.Image_Name);
	printf ("filler2 (should be all 0's): %x\n", n64header.filler2);
	printf ("Manufacturers ID: %x\n", n64header.Manu_ID);

	printf ("Cartridge ID: %x\n", n64header.Cart_ID);
	printf ("Country Code: %x\n", n64header.Country_Code);
	printf ("filler3 (should be 0): %x\n", n64header.filler3);
	printf ("Boot code starts here (1008 dwords)\n");
	printf ("Game Code starts at file ofs 1000h\n");
//#endif
        fseek(romfp, 0, SEEK_END);
        filesize = ftell(romfp);
        
        g_n64rom = (char*)malloc(filesize);
        if ((g_n64rom == NULL))
	{
		printf ("Insufficient memory to load ROM image\n");
		return 1;
	}
        memset(&g_n64rom[0], 0, filesize);

        fseek(romfp, 0, SEEK_SET); // paranoia?
        for (i = 0; i < filesize/2; i += 2)
        {
          fread(&g_n64rom[i], 2, 1, romfp);
          SwapBytes((WORD *)&g_n64rom[i]);
        }

        memcpy(boot, g_n64rom, 0x1000);
        SP_Registers = &boot[0];

//        fwrite(g_n64rom, filesize, 1, g_logfile);

        Nregs.PC = 0;
        Nregs.REAL_PC = n64header.Program_Counter;
        memset(&Nregs.main.regs, 0, sizeof(Nregs.main.regs));
        memset(&Nregs.cop0.regs, 0, sizeof(Nregs.cop0.regs));

#ifndef DEBUG
  #ifdef VIDEO
        Init_Video();
  #endif
#endif

        emulate();

	free(g_n64rom);
        fclose(romfp);
#ifdef DEBUG
        fclose(g_logfile);
#endif
	return 0;
}
