/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class PgbJoypad
implements KeyListener {
    protected static final int C_RIGHT = 1;
    protected static final int C_LEFT = 2;
    protected static final int C_UP = 4;
    protected static final int C_DOWN = 8;
    protected static final int B_A = 1;
    protected static final int B_B = 2;
    protected static final int B_SELECT = 4;
    protected static final int B_START = 8;
    public boolean c_right;
    public boolean c_left;
    public boolean c_up;
    public boolean c_down;
    public boolean b_a;
    public boolean b_b;
    public boolean b_select;
    public boolean b_start;
    public byte lastpoll;
    public byte selected;
    public byte player;
    public byte gbtype;

    public void reset() {
        this.c_right = false;
        this.c_left = false;
        this.c_up = false;
        this.c_down = false;
        this.b_a = false;
        this.b_b = false;
        this.b_select = false;
        this.b_start = false;
        this.gbtype = PgbSettings.system == 10 ? (byte)0 : (byte)-64;
        this.player = 0;
    }

    public void write(byte by) {
        this.selected = (byte)(by & 0x30);
    }

    public byte read() {
        int n = 0;
        switch (this.selected) {
            case 32: {
                n |= this.c_right ? 1 : 0;
                n |= this.c_left ? 2 : 0;
                n |= this.c_up ? 4 : 0;
                n |= this.c_down ? 8 : 0;
                break;
            }
            case 16: {
                n |= this.b_a ? 1 : 0;
                n |= this.b_b ? 2 : 0;
                n |= this.b_select ? 4 : 0;
                n |= this.b_start ? 8 : 0;
                break;
            }
            case 48: {
                n = this.player == 0 ? 0 : 1;
            }
        }
        n ^= 0xFFFFFFFF;
        return (byte)(this.gbtype | this.selected | (n &= 0xF));
    }

    public boolean changed() {
        byte by = 0;
        if ((this.selected & 0x20) == 0) {
            by = (byte)(by | (this.c_right ? 1 : 0));
            by = (byte)(by | (this.c_left ? 2 : 0));
            by = (byte)(by | (this.c_up ? 4 : 0));
            by = (byte)(by | (this.c_down ? 8 : 0));
        }
        if ((this.selected & 0x10) == 0) {
            by = (byte)(by | (this.b_a ? (byte)1 : 0));
            by = (byte)(by | (this.b_b ? 2 : 0));
            by = (byte)(by | (this.b_select ? 4 : 0));
            by = (byte)(by | (this.b_start ? 8 : 0));
        }
        boolean bl = by != this.lastpoll;
        this.lastpoll = by;
        return bl;
    }

    public void setSgbPlayer(byte by) {
        this.player = by;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == PgbSettings.key_right) {
            this.c_right = true;
            return;
        }
        if (keyEvent.getKeyCode() == PgbSettings.key_left) {
            this.c_left = true;
            return;
        }
        if (keyEvent.getKeyCode() == PgbSettings.key_up) {
            this.c_up = true;
            return;
        }
        if (keyEvent.getKeyCode() == PgbSettings.key_down) {
            this.c_down = true;
            return;
        }
        if (keyEvent.getKeyCode() == PgbSettings.key_a) {
            this.b_a = true;
            return;
        }
        if (keyEvent.getKeyCode() == PgbSettings.key_b) {
            this.b_b = true;
            return;
        }
        if (keyEvent.getKeyCode() == PgbSettings.key_select) {
            this.b_select = true;
            return;
        }
        if (keyEvent.getKeyCode() == PgbSettings.key_start) {
            this.b_start = true;
            return;
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == PgbSettings.key_right) {
            this.c_right = false;
            return;
        }
        if (keyEvent.getKeyCode() == PgbSettings.key_left) {
            this.c_left = false;
            return;
        }
        if (keyEvent.getKeyCode() == PgbSettings.key_up) {
            this.c_up = false;
            return;
        }
        if (keyEvent.getKeyCode() == PgbSettings.key_down) {
            this.c_down = false;
            return;
        }
        if (keyEvent.getKeyCode() == PgbSettings.key_a) {
            this.b_a = false;
            return;
        }
        if (keyEvent.getKeyCode() == PgbSettings.key_b) {
            this.b_b = false;
            return;
        }
        if (keyEvent.getKeyCode() == PgbSettings.key_select) {
            this.b_select = false;
            return;
        }
        if (keyEvent.getKeyCode() == PgbSettings.key_start) {
            this.b_start = false;
            return;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

