/*
 * Decompiled with CFR 0.152.
 */
public class PgbCachedVideo
extends PgbBasicVideo {
    byte[][][][] tiles = new byte[2][384][8][8];
    byte[][][] map = new byte[4][256][256];
    byte[][][] sprites = new byte[40][16][8];
    int lastTile;

    public void write(int n, byte by) {
        super.write(n, by);
        if (n >= 32768 && n < 38912) {
            this.checkTile(n);
        }
        if (n >= 38912 && n < 39936) {
            this.updateMap(0, n - 38912 & 0x1F, n - 38912 >> 5, this.vram[n - 32768] + 256);
            this.updateMap(1, n - 38912 & 0x1F, n - 38912 >> 5, this.vram[n - 32768] & 0xFF);
            return;
        }
        if (n >= 39936 && n < 40960) {
            this.updateMap(2, n - 39936 & 0x1F, n - 39936 >> 5, this.vram[n - 32768] + 256);
            this.updateMap(3, n - 39936 & 0x1F, n - 39936 >> 5, this.vram[n - 32768] & 0xFF);
            return;
        }
        if (n >= 65024 && n < 65184) {
            if ((n & 2) == 2) {
                this.updateObj(n - 65024 >> 2);
            }
            return;
        }
    }

    void doBgLine(int n) {
        int n2 = n + this.scy & 0xFF;
        byte[] byArray = this.map[(this.chr_mode ? 1 : 0) + (this.bg_mode ? 2 : 0)][n2];
        if (this.scx < 97) {
            System.arraycopy(byArray, this.scx, this.screenMemory, n * 160, 160);
        } else {
            int n3 = 256 - this.scx;
            System.arraycopy(byArray, this.scx, this.screenMemory, n * 160, n3);
            System.arraycopy(byArray, 0, this.screenMemory, n * 160 + n3, 160 - n3);
        }
    }

    void doWinLine(int n) {
        int n2;
        int n3;
        int n4;
        if (this.wy > n || this.wx > 166) {
            return;
        }
        byte[] byArray = this.map[(this.chr_mode ? 1 : 0) + (this.win_mode ? 2 : 0)][n - this.wy];
        if (this.wx < 7) {
            n4 = 7 - this.wx;
            n3 = 0;
            n2 = 160 - n4;
        } else {
            n4 = 0;
            n3 = this.wx - 7;
            n2 = 160 - n3;
        }
        System.arraycopy(byArray, n4, this.screenMemory, n * 160 + n3, n2);
    }

    void doObjLine(int n) {
        for (int i = 39; i >= 0; --i) {
            int n2 = i * 4;
            int n3 = this.oam[n2 + 1] & 0xFF;
            int n4 = this.oam[n2] & 0xFF;
            if (n3 <= 0 || n4 <= 0 || n4 > n + 16 || n4 <= n + (16 - this.obj_siz)) continue;
            boolean bl = (this.oam[n2 + 3] & 0x80) == 128;
            byte[] byArray = this.sprites[i][n - n4 + 16];
            for (int j = 0; j < 8; ++j) {
                int n5 = n3 - 8 + j;
                byte by = byArray[j];
                if ((by & 3) <= 0 || n5 >= 160 || n5 < 0 || (bl || (this.getBackgroundAttr(n5, n) & 0x80) == 128) && (this.screenMemory[n * 160 + n5] & 3) != 0) continue;
                this.screenMemory[n * 160 + n5] = by;
            }
        }
    }

    void updateMap(int n, int n2, int n3, int n4) {
        if (PgbSettings.system == 11) {
            byte by = this.getAttr(n2, n3, (n & 2) == 2);
            byte by2 = (byte)((by & 7) << 3);
            int n5 = (by & 8) == 8 ? 1 : 0;
            for (int i = 0; i < 8; ++i) {
                int n6;
                int n7 = n3 * 8 + i;
                int n8 = n2 * 8;
                int n9 = n6 = (by & 0x40) == 64 ? 7 - i : i;
                if ((by & 0x20) == 32) {
                    this.map[n][n7][n8++] = (byte)(by2 | this.tiles[n5][n4][n6][7]);
                    this.map[n][n7][n8++] = (byte)(by2 | this.tiles[n5][n4][n6][6]);
                    this.map[n][n7][n8++] = (byte)(by2 | this.tiles[n5][n4][n6][5]);
                    this.map[n][n7][n8++] = (byte)(by2 | this.tiles[n5][n4][n6][4]);
                    this.map[n][n7][n8++] = (byte)(by2 | this.tiles[n5][n4][n6][3]);
                    this.map[n][n7][n8++] = (byte)(by2 | this.tiles[n5][n4][n6][2]);
                    this.map[n][n7][n8++] = (byte)(by2 | this.tiles[n5][n4][n6][1]);
                    this.map[n][n7][n8++] = (byte)(by2 | this.tiles[n5][n4][n6][0]);
                    continue;
                }
                this.map[n][n7][n8++] = (byte)(by2 | this.tiles[n5][n4][n6][0]);
                this.map[n][n7][n8++] = (byte)(by2 | this.tiles[n5][n4][n6][1]);
                this.map[n][n7][n8++] = (byte)(by2 | this.tiles[n5][n4][n6][2]);
                this.map[n][n7][n8++] = (byte)(by2 | this.tiles[n5][n4][n6][3]);
                this.map[n][n7][n8++] = (byte)(by2 | this.tiles[n5][n4][n6][4]);
                this.map[n][n7][n8++] = (byte)(by2 | this.tiles[n5][n4][n6][5]);
                this.map[n][n7][n8++] = (byte)(by2 | this.tiles[n5][n4][n6][6]);
                this.map[n][n7][n8++] = (byte)(by2 | this.tiles[n5][n4][n6][7]);
            }
        } else {
            int n10 = n2 * 8;
            int n11 = n3 * 8;
            System.arraycopy(this.tiles[0][n4][0], 0, this.map[n][n11++], n10, 8);
            System.arraycopy(this.tiles[0][n4][1], 0, this.map[n][n11++], n10, 8);
            System.arraycopy(this.tiles[0][n4][2], 0, this.map[n][n11++], n10, 8);
            System.arraycopy(this.tiles[0][n4][3], 0, this.map[n][n11++], n10, 8);
            System.arraycopy(this.tiles[0][n4][4], 0, this.map[n][n11++], n10, 8);
            System.arraycopy(this.tiles[0][n4][5], 0, this.map[n][n11++], n10, 8);
            System.arraycopy(this.tiles[0][n4][6], 0, this.map[n][n11++], n10, 8);
            System.arraycopy(this.tiles[0][n4][7], 0, this.map[n][n11++], n10, 8);
        }
    }

    public void updateObj(int n) {
        byte by;
        int n2;
        int n3 = this.oam[(n << 2) + 2] & (this.obj_mode ? 254 : 255);
        byte by2 = this.oam[(n << 2) + 3];
        if (PgbSettings.system == 11) {
            n2 = by2 >> 3 & 1;
            by = (byte)(by2 << 3 & 0x38 | 4);
        } else {
            n2 = 0;
            by = (byte)(by2 >> 1 & 8 | 4);
        }
        boolean bl = (by2 & 0x40) == 64;
        boolean bl2 = (by2 & 0x20) == 32;
        int n4 = n3 * 16 + 8192 * n2;
        for (int i = 0; i < this.obj_siz; ++i) {
            int n5 = bl ? this.obj_siz - i - 1 : i;
            this.copyTileLineArray(n4 + n5 * 2, bl2, by, this.sprites[n][i], 0);
        }
    }

    void checkTile(int n) {
        int n2 = (n - 32768) / 16;
        if ((n & 0xF) == 15) {
            this.doTile(n2, this.gbcVram & 1);
        } else if (n2 != this.lastTile) {
            this.doTile(this.lastTile, this.gbcVram & 1);
        }
        this.lastTile = n2;
    }

    void doTile(int n, int n2) {
        int n3 = n * 16 + 8192 * n2;
        this.copyTileLineArray(n3 + 0, this.tiles[n2][n][0], 0);
        this.copyTileLineArray(n3 + 2, this.tiles[n2][n][1], 0);
        this.copyTileLineArray(n3 + 4, this.tiles[n2][n][2], 0);
        this.copyTileLineArray(n3 + 6, this.tiles[n2][n][3], 0);
        this.copyTileLineArray(n3 + 8, this.tiles[n2][n][4], 0);
        this.copyTileLineArray(n3 + 10, this.tiles[n2][n][5], 0);
        this.copyTileLineArray(n3 + 12, this.tiles[n2][n][6], 0);
        this.copyTileLineArray(n3 + 14, this.tiles[n2][n][7], 0);
        this.scanUpdateTile(n);
    }

    void scanUpdateTile(int n) {
        int n2;
        byte by = (byte)n;
        for (n2 = 6144; n2 < 7168; ++n2) {
            if (this.vram[n2] != by) continue;
            if (n > 127) {
                this.updateMap(0, n2 - 6144 & 0x1F, n2 - 6144 >> 5, n);
            }
            if (n >= 256) continue;
            this.updateMap(1, n2 - 6144 & 0x1F, n2 - 6144 >> 5, n);
        }
        for (n2 = 7168; n2 < 8192; ++n2) {
            if (this.vram[n2] != by) continue;
            if (n > 127) {
                this.updateMap(2, n2 - 7168 & 0x1F, n2 - 7168 >> 5, n);
            }
            if (n >= 256) continue;
            this.updateMap(3, n2 - 7168 & 0x1F, n2 - 7168 >> 5, n);
        }
    }
}

