#include <stdio.h>
#include <string.h>
#include "gba.h"
#include "minilzo.107/minilzo.h"

//Removed redundancy.
/*
typedef struct {
	char name[32];
	u32 filesize;
	u32 flags;
	u32 followval;
	u32 reserved;
} rominfo;
*/

extern u8 Image$$RO$$Base;
extern u8 Image$$RO$$Limit;
extern u8 Image$$RW$$Base;
extern u8 Image$$RW$$Limit;
extern u8 Image$$ZI$$Base;
extern u8 Image$$ZI$$Limit;

extern u32 g_emuflags;	//from cart.s
extern u32 joycfg;	//from io.s
extern u32 font;
extern u32 fontpal;
extern u32 AGBinput;	//from ppu.s
extern u32 NESinput;
       u32 oldinput;

extern romheader mb_header;

#define HEAP_START ((((u32) &Image$$RO$$Limit)+3)&~3)

//asm calls
void loadcart(int,int);	//from cart.s
void run(int);
void ppu_init(void);
void resetSIO(u32);//io.s

u32 checksum(u8 *p);

void cls(void);
void rommenu(void);
int drawmenu(int);
int getinput(void);
int ines(u8 *p);
void splash(u32);
void waitframe(void);
void drawtext(int,char*,int);
u32 find_checksum(int n); //sram.c
void readconfig(void);		//sram.c
void backup_nes_sram(void);
void get_saved_sram(void);	//sram.c

//int sprintf(char*, const char*, ...);

// Simpler.
u8 *findromheader(int n);

/* To be renamed to something more meaningful
   to account for its decompression behavior.
   */
u8 *findrom(int n);

//const unsigned __fp_status_arm=0x40070000;
u8 *textstart;//points to first NES rom (initialized by boot.s)
int roms;//total number of roms
int selected_rom = 0;
u32 current_checksum;

char pogoshell_romname[32];	//keep track of rom name (for state saving, etc)
u8 compressed;  /* For everything other than cart.s, which uses the modifed
                   "NEZ" header to detect compression
		   */
u8 pogones=0;
u32 pogones_filesize;
int gameboyplayer=0;

//int ne=0x454e;

// For debugging. 
/* 
void dprint(char *string) {
  __asm {
    mov r2, r0
    mov r0, #0xC0DED00D
    mov r1, #0
    and r0, r0, r0
  }
} 
*/

void C_entry() {
    //lzo_uint size;
    u32 temp=(u32)(*(u8**)0x0203FBFC);
    if((temp & 0xFE000000) == 0x08000000) pogones=1;
    if(pogones)
    {
	char *s=(char*)0x203fc08;
	do s++; while(*s);
	do s++; while(*s);
	do s--; while(*s!='/');
	s++;			//s=nes rom name


	roms=1;
	memcpy(pogoshell_romname,s,32);
	memcpy(mb_header.name,s,32);

	lzo_init();	//init compression lib for savestates

	textstart=(*(u8**)0x0203FBFC)-sizeof(romheader);
         pogones_filesize = *((u32*) 0x0203FBF8);
         mb_header.checksum = checksum(findrom(0)+sizeof(romheader)+16);

	ppu_init();
    }
    else
    {
	//keep iNES id constant out of binary (for rom searching purposes)
//	int nes_id=0x1a530000+ne;
	u16 i;
//	u8 *p;
//	char buf[100];
	REG_DISPCNT=FORCE_BLANK;	//screen OFF

	lzo_init();	//init compression lib for savestates

	//splash screen present?
	//This is a saner check, since the nes_id could
         //hypothetically be part of the image.
/*	
	sprintf(buf, "Image$$RO$$Base/Limit: %p/%p\n", &Image$$RO$$Base, &Image$$RO$$Limit);
	dprint(buf);
	sprintf(buf, "Image$$RW$$Base/Limit: %p/%p\n", &Image$$RW$$Base, &Image$$RW$$Limit);
	dprint(buf);
	sprintf(buf, "Image$$ZI$$Base/Limit: %p/%p\n", &Image$$ZI$$Base, &Image$$ZI$$Limit);
	dprint(buf);
*/
	//32-bit align
        textstart = (u8*) (((u32)textstart + 3)&~3);

	if(*(u32*)(textstart)!=0) {
		splash(*(u32*)(textstart));
	}
	textstart += 4;
	/*
	sprintf(buf, "Textstart2: %p\n", (u32*) textstart);
	dprint(buf);
	 */

	ppu_init();

         // Simpler and sane way.
         i=*(u32*)textstart;
	textstart += 4;
/*
	sprintf(buf, "Textstart: %p\n", (u32*) textstart);
	dprint(buf);
  */
	if(i==0)i=1;
	roms=i;
/*
         sprintf(buf, "Roms: %d\n", i);
	dprint(buf);
  */
    }
	//load font+palette
	memcpy((void*)0x6002400,&font,16*8*32);
	memcpy((void*)0x5000080,&fontpal,64);
	readconfig();
	rommenu();
}

//show splash screen
void splash(u32 type) {
	u16 *src;
	u16 *dst;
	int i;

         if (type == 1) {
	  src=(u16*)(textstart+4);	//this *SHOULD* be halfword aligned..
           textstart += 76800;
         } else {
           lzo_uint size;
           // This should be okay
           size = type;
	  lzo1x_decompress((u8*) (textstart+4),size,
                            (u8*) (HEAP_START),
                            &size,NULL);
           if (size != 76800) {
               drawtext(9,"    Splash Screen Corrupt.",0);
               for(i=0;i<60;i++)       //(1 second wait)
                  waitframe();
               cls();
               //32-bit align
               textstart += (type+3)&~3;
               return;
           }
           //32-bit align
           textstart += (type+3)&~3;
           src=(u16*) (HEAP_START);
         }
	dst=MEM_VRAM;
	for(i=0;i<38400;i++) {
		*dst=*src;
		src++;
		dst++;
	}
	waitframe();
	REG_BG2CNT=0x0000;
	REG_BLDCNT=0x84;	//(brightness increase)
	REG_DISPCNT=BG2_EN|MODE3;
	for(i=16;i>=0;i--) {	//fade from white
		REG_COLY=i;
		waitframe();
	}
	for(i=0;i<150;i++) {	//wait 2.5 seconds
		waitframe();
		if (REG_P1==0x030f) gameboyplayer=1;
	}
	REG_BLDCNT=0xc4;	//(brightness decrease)
	for(i=0;i<16;i++) {
		REG_COLY=i;	//fade to black
		waitframe();
	}
	*MEM_PALETTE=0;//black background (avoids blue flash when doing multiboot)
}

void rommenu(void) {
    if(pogones)
    {
        cls();
        REG_BLDCNT=0;
        REG_BG2CNT=0x0700;	//16color 256x256 CHRbase0 SCRbase7 Priority0
        REG_DISPCNT=BG2_EN|OBJ_1D; //mode0, 1d sprites, main screen turn on
        backup_nes_sram();
        selected_rom = 0;
        current_checksum = find_checksum(selected_rom);
        loadcart(selected_rom,g_emuflags&0x300);
        get_saved_sram();
	findrom(selected_rom);
        run(1);
    }
    else
    {
    	int i;
    	int key;
    
    	int romz=roms;	//globals=bigger code :P
    	int sel, lastselected, change=24;
	
	sel=lastselected=selected_rom;
	
    	oldinput=AGBinput=~REG_P1;
    	cls();
    	waitframe();
    	REG_BLDCNT=0x00f3;	//darken screen
    	REG_BG2CNT=0x0700;	//16color 256x256 CHRbase0 SCRbase7 Priority0
    	REG_DISPCNT=BG2_EN|OBJ_1D; //mode0, 1d sprites, main screen turn on
    	resetSIO((joycfg&~0xff000000) + 0x40000000);//back to 1P
    
    	backup_nes_sram();
    
 	i=drawmenu(sel);
	
    	do {
    		key=getinput();
    		if(key&RIGHT) {
    			sel+=10;
    			if(sel>romz-1) sel=romz-1;
    		}
    		if(key&LEFT) {
    			sel-=10;
    			if(sel<0) sel=0;
    		}
    		if(key&UP)
    			sel=sel+romz-1;
    		if(key&DOWN)
    			sel++;
		sel%=romz;
    		if(lastselected!=sel) {
    			i=drawmenu(sel);
    			lastselected=sel;
			change = 1;
    		}
		if (change) {
		   waitframe();
		   change++;
		   if (change > 24) {
		      selected_rom = sel;
		      current_checksum = find_checksum(selected_rom);
    		      loadcart(selected_rom,i|(g_emuflags&0x300));
		                               //(keep old gfxmode)
    		      get_saved_sram();
		      findrom(selected_rom);
		      change = 0;
		   }
		}
    		run(0);
    	} while(romz>1 && !(key&(A_BTN+B_BTN+START)));
    	cls();	//leave BG2 on for debug output
    	while(AGBinput&(A_BTN+B_BTN+START)) {
    		AGBinput=0;
    		run(0);
    	}
    	run(1);
    }
}

/* Just does a simple romheader search, which is less fuss
   than decompressing the rom (which is sometimes overkill).
   */
u8 *findromheader(int n) {
        u8 *p=textstart;

	if (!pogones) {
	   while(n--)
	      p += ((((romheader*)p)->filesize+3)&~3)
                    +sizeof(romheader);
	}
	return p;
}

//return ptr to Nth ROM (including romheader struct)
u8 *findrom(int n) {
        u8 *p=textstart;
	char *s;
	//char buf[100];

        /*
        sprintf(buf, "rom: %d  checksum: %x\n", n, current_checksum);
	dprint(buf);
	*/
	if (pogones) {
	   mb_header.filesize = pogones_filesize;
	   // Fill in the romheader.
	   memcpy((u8*) HEAP_START, &mb_header, sizeof(romheader)); 
	} else {
	   while(n--)
	      p += ((((romheader*)p)->filesize+3)&~3)
                    +sizeof(romheader);
	   // Fill in, for mbclient.
	   mb_header.filesize = ((romheader*)p)->filesize;
	   memcpy(&(mb_header.name), ((romheader*)p)->name, 32);
	   // Copy the rom header, which might not be necessary.
	   memcpy((u8*) HEAP_START, (romheader*) p, sizeof(romheader));
	}

	s = mb_header.name;
	while (*s)
	  s++;
	if (s[-1] == 'z' || s[-1] == 'Z') {
	  lzo_uint size;
	  u8* comp;

          compressed = 1;
          comp = p + sizeof(romheader);
          size = mb_header.filesize;

	  lzo1x_decompress(comp,size,
                            (u8*) (HEAP_START+sizeof(romheader)),
                            &size,NULL);
	  p=(u8*) (HEAP_START);
          ((romheader *) p)->filesize = size;
	} else
          compressed = 0;
        return p;
}

//returns options for selected rom
int drawmenu(int sel) {
	int i,j,topline,toprow,romflags;
	u8 *p;
	romheader *ri;

	if(roms>20) {
		topline=8*(roms-20)*sel/(roms-1);
		toprow=topline/8;
		j=(toprow<roms-20)?21:20;
	} else {
		toprow=0;
		j=roms;
	}
	/* WARNING:  This is a hack to avoid having to
	             call findrom[header] for each
		     romheader.  This assumes that all
		     the romheaders are in a row
		     (which findrom doesn't guarantee).

		     Calling findromheader, which only
		     returns a position on the cart,
		     is safer (and more correct).
	  */
	p=findromheader(toprow);
	for(i=0;i<j;i++) {
		drawtext(i,(char*)p,i==(sel-toprow)?1:0);
		if(i==sel-toprow) {
			ri=(romheader*)p;
			romflags=(*ri).flags|(ri->spritefollow)<<16;
		}
		//32-bit align
	         p += ((((romheader*)p)->filesize+3)&~3)
                       +sizeof(romheader);
	}
	if(roms>20)
		REG_BG2VOFS=topline%8;
	else
		REG_BG2VOFS=176+roms*4;
	return romflags;
}

int getinput() {
	static int lastdpad,repeatcount=0;
	int dpad;
	int keyhit=(oldinput^AGBinput)&AGBinput;
	oldinput=AGBinput;

	dpad=AGBinput&(UP+DOWN+LEFT+RIGHT);
	if(lastdpad==dpad) {
		repeatcount++;
		if(repeatcount<25 || repeatcount&3)    //delay/repeat
			dpad=0;
	} else {
		repeatcount=0;

		lastdpad=dpad;
	}
	NESinput=0;	//disable game input
	return dpad|(keyhit&(A_BTN+B_BTN+START));
}


void cls(void) {
	int i;
	u32 *scr=(u32*)SCREENBASE;
	for(i=0;i<0x200;i++)
		scr[i]=0x01200120;
	REG_BG2VOFS=0;
}

void drawtext(int row,char *str,int hilite) {
	u16 *here=SCREENBASE+row*32;
	int i=0;

	*here=hilite?0x412a:0x4120;
	hilite=(hilite<<12)+0x4100;
	here++;
	while(str[i]>=' ') {
		here[i]=str[i]|hilite;
		i++;
	}
	for(;i<29;i++)
		here[i]=0x0120;
}

void waitframe(void) {
#ifndef __DEBUGBUILD
	while(REG_VCOUNT>=160) {};
	while(REG_VCOUNT<160) {};
#endif
}
